/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ActionRelationshipType;

public class ActionRelationshipTypeEnumFactory
implements EnumFactory<ActionRelationshipType> {
    @Override
    public ActionRelationshipType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("before-start".equals(codeString)) {
            return ActionRelationshipType.BEFORESTART;
        }
        if ("before".equals(codeString)) {
            return ActionRelationshipType.BEFORE;
        }
        if ("before-end".equals(codeString)) {
            return ActionRelationshipType.BEFOREEND;
        }
        if ("concurrent-with-start".equals(codeString)) {
            return ActionRelationshipType.CONCURRENTWITHSTART;
        }
        if ("concurrent".equals(codeString)) {
            return ActionRelationshipType.CONCURRENT;
        }
        if ("concurrent-with-end".equals(codeString)) {
            return ActionRelationshipType.CONCURRENTWITHEND;
        }
        if ("after-start".equals(codeString)) {
            return ActionRelationshipType.AFTERSTART;
        }
        if ("after".equals(codeString)) {
            return ActionRelationshipType.AFTER;
        }
        if ("after-end".equals(codeString)) {
            return ActionRelationshipType.AFTEREND;
        }
        throw new IllegalArgumentException("Unknown ActionRelationshipType code '" + codeString + "'");
    }

    @Override
    public String toCode(ActionRelationshipType code) {
        if (code == ActionRelationshipType.NULL) {
            return null;
        }
        if (code == ActionRelationshipType.BEFORESTART) {
            return "before-start";
        }
        if (code == ActionRelationshipType.BEFORE) {
            return "before";
        }
        if (code == ActionRelationshipType.BEFOREEND) {
            return "before-end";
        }
        if (code == ActionRelationshipType.CONCURRENTWITHSTART) {
            return "concurrent-with-start";
        }
        if (code == ActionRelationshipType.CONCURRENT) {
            return "concurrent";
        }
        if (code == ActionRelationshipType.CONCURRENTWITHEND) {
            return "concurrent-with-end";
        }
        if (code == ActionRelationshipType.AFTERSTART) {
            return "after-start";
        }
        if (code == ActionRelationshipType.AFTER) {
            return "after";
        }
        if (code == ActionRelationshipType.AFTEREND) {
            return "after-end";
        }
        return "?";
    }

    @Override
    public String toSystem(ActionRelationshipType code) {
        return code.getSystem();
    }
}

