/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConceptSubsumptionOutcome {
    EQUIVALENT,
    SUBSUMES,
    SUBSUMEDBY,
    NOTSUBSUMED,
    NULL;


    public static ConceptSubsumptionOutcome fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("equivalent".equals(codeString)) {
            return EQUIVALENT;
        }
        if ("subsumes".equals(codeString)) {
            return SUBSUMES;
        }
        if ("subsumed-by".equals(codeString)) {
            return SUBSUMEDBY;
        }
        if ("not-subsumed".equals(codeString)) {
            return NOTSUBSUMED;
        }
        throw new FHIRException("Unknown ConceptSubsumptionOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EQUIVALENT: {
                return "equivalent";
            }
            case SUBSUMES: {
                return "subsumes";
            }
            case SUBSUMEDBY: {
                return "subsumed-by";
            }
            case NOTSUBSUMED: {
                return "not-subsumed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/concept-subsumption-outcome";
    }

    public String getDefinition() {
        switch (this) {
            case EQUIVALENT: {
                return "The two concepts are equivalent (have the same properties).";
            }
            case SUBSUMES: {
                return "Coding/code \"A\" subsumes Coding/code \"B\" (e.g. B has all the properties A has, and some of it's own).";
            }
            case SUBSUMEDBY: {
                return "Coding/code \"A\" is subsumed by Coding/code \"B\" (e.g. A has all the properties B has, and some of it's own).";
            }
            case NOTSUBSUMED: {
                return "Coding/code \"A\" and Coding/code \"B\" are disjoint (e.g. each has propeties that the other doesn't have).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EQUIVALENT: {
                return "Equivalent";
            }
            case SUBSUMES: {
                return "Subsumes";
            }
            case SUBSUMEDBY: {
                return "Subsumed-By";
            }
            case NOTSUBSUMED: {
                return "Not-Subsumed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

