/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.RejectionCriteria;

public class RejectionCriteriaEnumFactory
implements EnumFactory<RejectionCriteria> {
    @Override
    public RejectionCriteria fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("hemolized".equals(codeString)) {
            return RejectionCriteria.HEMOLIZED;
        }
        if ("insufficient".equals(codeString)) {
            return RejectionCriteria.INSUFFICIENT;
        }
        if ("broken".equals(codeString)) {
            return RejectionCriteria.BROKEN;
        }
        if ("clotted".equals(codeString)) {
            return RejectionCriteria.CLOTTED;
        }
        if ("wrong-temperature".equals(codeString)) {
            return RejectionCriteria.WRONGTEMPERATURE;
        }
        throw new IllegalArgumentException("Unknown RejectionCriteria code '" + codeString + "'");
    }

    @Override
    public String toCode(RejectionCriteria code) {
        if (code == RejectionCriteria.NULL) {
            return null;
        }
        if (code == RejectionCriteria.HEMOLIZED) {
            return "hemolized";
        }
        if (code == RejectionCriteria.INSUFFICIENT) {
            return "insufficient";
        }
        if (code == RejectionCriteria.BROKEN) {
            return "broken";
        }
        if (code == RejectionCriteria.CLOTTED) {
            return "clotted";
        }
        if (code == RejectionCriteria.WRONGTEMPERATURE) {
            return "wrong-temperature";
        }
        return "?";
    }

    @Override
    public String toSystem(RejectionCriteria code) {
        return code.getSystem();
    }
}

