/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Parameters;

public class ConceptTranslationEngine {
    private final IWorkerContext context;

    public ConceptTranslationEngine(IWorkerContext worker) {
        this.context = worker;
    }

    public Parameters translateCode(String s, ConceptMap cm) {
        Parameters p = new Parameters();
        boolean matched = false;
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent src : grp.getElement()) {
                if (!src.getCode().equals(s)) continue;
                for (ConceptMap.TargetElementComponent tgt : src.getTarget()) {
                    matched = true;
                    Parameters.ParametersParameterComponent match = p.addParameter();
                    match.setName("match");
                    match.addPart().setName("equivalence").setValue(new CodeType(tgt.getEquivalence().toCode()));
                    match.addPart().setName("concept").setValue(new Coding().setCode(tgt.getCode()).setSystem(grp.getTarget()));
                }
            }
        }
        p.addParameter("result", matched);
        return p;
    }

    public Parameters translateCoding(Coding coding, ConceptMap cm) {
        Parameters p = new Parameters();
        boolean matched = false;
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            if (!grp.getSourceElement().equals(coding.getSystem())) continue;
            for (ConceptMap.SourceElementComponent src : grp.getElement()) {
                if (!src.getCode().equals(coding.getCode())) continue;
                for (ConceptMap.TargetElementComponent tgt : src.getTarget()) {
                    matched = true;
                    Parameters.ParametersParameterComponent match = p.addParameter();
                    match.setName("match");
                    match.addPart().setName("equivalence").setValue(new CodeType(tgt.getEquivalence().toCode()));
                    match.addPart().setName("concept").setValue(new Coding().setCode(tgt.getCode()).setSystem(grp.getTarget()));
                }
            }
        }
        p.addParameter("result", matched);
        return p;
    }
}

