package org.hl7.fhir.r5.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Sep 18, 2019 03:45+1000 for FHIR v4.1.0


import org.hl7.fhir.r5.model.EnumFactory;

public class ResearchElementTypeEnumFactory implements EnumFactory<ResearchElementType> {

  public ResearchElementType fromCode(String codeString) throws IllegalArgumentException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("population".equals(codeString))
      return ResearchElementType.POPULATION;
    if ("exposure".equals(codeString))
      return ResearchElementType.EXPOSURE;
    if ("outcome".equals(codeString))
      return ResearchElementType.OUTCOME;
    throw new IllegalArgumentException("Unknown ResearchElementType code '"+codeString+"'");
  }

  public String toCode(ResearchElementType code) {
    if (code == ResearchElementType.POPULATION)
      return "population";
    if (code == ResearchElementType.EXPOSURE)
      return "exposure";
    if (code == ResearchElementType.OUTCOME)
      return "outcome";
    return "?";
  }

    public String toSystem(ResearchElementType code) {
      return code.getSystem();
      }

}

