/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.DefinitionNavigator;
import org.hl7.fhir.r5.utils.KeyGenerator;
import org.hl7.fhir.r5.utils.NarrativeGenerator;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ProfileComparer
implements ProfileUtilities.ProfileKnowledgeProvider {
    private IWorkerContext context;
    private KeyGenerator keygen;
    private String folder;
    private static final int BUFFER_SIZE = 4096;
    private static final int BOTH_NULL = 0;
    private static final int EITHER_NULL = 1;
    private List<ValueSet> valuesets = new ArrayList<ValueSet>();
    private List<ProfileComparison> comparisons = new ArrayList<ProfileComparison>();
    private String id;
    private String title;
    private String leftLink;
    private String leftName;
    private String rightLink;
    private String rightName;

    public ProfileComparer(IWorkerContext context, KeyGenerator keygen, String folder) throws IOException {
        this.context = context;
        this.keygen = keygen;
        this.folder = folder;
        if (!new File(Utilities.path((String[])new String[]{folder, "conparison-zip-marker.bin"})).exists()) {
            String f = Utilities.path((String[])new String[]{folder, "comparison.zip"});
            this.download("http://www.fhir.org/archive/comparison.zip", f);
            this.unzip(f, folder);
        }
    }

    private void download(String address, String filename) throws IOException {
        URL url = new URL(address);
        URLConnection c = url.openConnection();
        InputStream s = c.getInputStream();
        FileOutputStream f = new FileOutputStream(filename);
        ProfileComparer.transfer(s, f, 1024);
        f.close();
    }

    public static void transfer(InputStream in, OutputStream out, int buffer) throws IOException {
        byte[] read = new byte[buffer];
        while (0 < (buffer = in.read(read))) {
            out.write(read, 0, buffer);
        }
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public ProfileComparer(IWorkerContext context, String folder) throws IOException {
        this.context = context;
        this.folder = folder;
        if (!new File(Utilities.path((String[])new String[]{folder, "conparison-zip-marker.bin"})).exists()) {
            String f = Utilities.path((String[])new String[]{folder, "comparison.zip"});
            this.download("https://www.fhir.org/archive/comparison.zip", f);
            this.unzip(f, folder);
        }
    }

    public List<ValueSet> getValuesets() {
        return this.valuesets;
    }

    public void status(ElementDefinition ed, int value) {
        ed.setUserData("error-status", Math.max(value, ed.getUserInt("error-status")));
    }

    public List<ProfileComparison> getComparisons() {
        return this.comparisons;
    }

    public ProfileComparison compareProfiles(StructureDefinition left, StructureDefinition right) throws DefinitionException, IOException, FHIRFormatError {
        ProfileComparison outcome = new ProfileComparison();
        outcome.left = left;
        outcome.right = right;
        if (left == null) {
            throw new DefinitionException("No StructureDefinition provided (left)");
        }
        if (right == null) {
            throw new DefinitionException("No StructureDefinition provided (right)");
        }
        if (!left.hasSnapshot()) {
            throw new DefinitionException("StructureDefinition has no snapshot (left: " + outcome.leftName() + ")");
        }
        if (!right.hasSnapshot()) {
            throw new DefinitionException("StructureDefinition has no snapshot (right: " + outcome.rightName() + ")");
        }
        if (left.getSnapshot().getElement().isEmpty()) {
            throw new DefinitionException("StructureDefinition snapshot is empty (left: " + outcome.leftName() + ")");
        }
        if (right.getSnapshot().getElement().isEmpty()) {
            throw new DefinitionException("StructureDefinition snapshot is empty (right: " + outcome.rightName() + ")");
        }
        for (ProfileComparison pc : this.comparisons) {
            if (!pc.left.getUrl().equals(left.getUrl()) || !pc.right.getUrl().equals(right.getUrl())) continue;
            return pc;
        }
        outcome.id = Integer.toString(this.comparisons.size() + 1);
        this.comparisons.add(outcome);
        DefinitionNavigator ln = new DefinitionNavigator(this.context, left);
        DefinitionNavigator rn = new DefinitionNavigator(this.context, right);
        outcome.superset = new StructureDefinition();
        outcome.subset = new StructureDefinition();
        this.keygen.genId(outcome.subset);
        this.keygen.genId(outcome.superset);
        if (outcome.ruleEqual(ln.path(), null, ln.path(), rn.path(), "Base Type is not compatible", false)) {
            if (this.compareElements(outcome, ln.path(), ln, rn, null)) {
                outcome.subset.setName("intersection of " + outcome.leftName() + " and " + outcome.rightName());
                outcome.subset.setStatus(Enumerations.PublicationStatus.DRAFT);
                outcome.subset.setKind(outcome.left.getKind());
                outcome.subset.setType(outcome.left.getType());
                outcome.subset.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/" + outcome.subset.getType());
                outcome.subset.setDerivation(StructureDefinition.TypeDerivationRule.CONSTRAINT);
                outcome.subset.setAbstract(false);
                outcome.superset.setName("union of " + outcome.leftName() + " and " + outcome.rightName());
                outcome.superset.setStatus(Enumerations.PublicationStatus.DRAFT);
                outcome.superset.setKind(outcome.left.getKind());
                outcome.superset.setType(outcome.left.getType());
                outcome.superset.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/" + outcome.subset.getType());
                outcome.superset.setAbstract(false);
                outcome.superset.setDerivation(StructureDefinition.TypeDerivationRule.CONSTRAINT);
            } else {
                outcome.subset = null;
                outcome.superset = null;
            }
        }
        return outcome;
    }

    private boolean compareElements(ProfileComparison outcome, String path, DefinitionNavigator left, DefinitionNavigator right, String sliceName) throws DefinitionException, IOException, FHIRFormatError {
        assert (path != null);
        assert (left != null);
        assert (right != null);
        assert (left.path().equals(right.path()));
        ElementDefinition subset = new ElementDefinition();
        subset.setPath(left.path());
        if (sliceName != null) {
            subset.setSliceName(sliceName);
        }
        subset.getRepresentation().addAll(left.current().getRepresentation());
        if (!outcome.ruleCompares(subset, left.current().getDefaultValue(), right.current().getDefaultValue(), path + ".defaultValue[x]", 0)) {
            return false;
        }
        subset.setDefaultValue(left.current().getDefaultValue());
        if (!outcome.ruleEqual(path, subset, left.current().getMeaningWhenMissing(), right.current().getMeaningWhenMissing(), "meaningWhenMissing Must be the same", true)) {
            return false;
        }
        subset.setMeaningWhenMissing(left.current().getMeaningWhenMissing());
        if (!outcome.ruleEqual(subset, left.current().getIsModifier(), right.current().getIsModifier(), path, "isModifier")) {
            return false;
        }
        subset.setIsModifier(left.current().getIsModifier());
        if (!outcome.ruleEqual(subset, left.current().getIsSummary(), right.current().getIsSummary(), path, "isSummary")) {
            return false;
        }
        subset.setIsSummary(left.current().getIsSummary());
        subset.setLabel(this.mergeText(subset, outcome, path, "label", left.current().getLabel(), right.current().getLabel()));
        subset.setShort(this.mergeText(subset, outcome, path, "short", left.current().getShort(), right.current().getShort()));
        subset.setDefinition(this.mergeText(subset, outcome, path, "definition", left.current().getDefinition(), right.current().getDefinition()));
        subset.setComment(this.mergeText(subset, outcome, path, "comments", left.current().getComment(), right.current().getComment()));
        subset.setRequirements(this.mergeText(subset, outcome, path, "requirements", left.current().getRequirements(), right.current().getRequirements()));
        subset.getCode().addAll(this.mergeCodings(left.current().getCode(), right.current().getCode()));
        subset.getAlias().addAll(this.mergeStrings(left.current().getAlias(), right.current().getAlias()));
        subset.getMapping().addAll(this.mergeMappings(left.current().getMapping(), right.current().getMapping()));
        subset.setExample(left.current().hasExample() ? left.current().getExample() : right.current().getExample());
        subset.setMustSupport(left.current().getMustSupport() || right.current().getMustSupport());
        ElementDefinition superset = subset.copy();
        superset.setMin(this.unionMin(left.current().getMin(), right.current().getMin()));
        superset.setMax(this.unionMax(left.current().getMax(), right.current().getMax()));
        subset.setMin(this.intersectMin(left.current().getMin(), right.current().getMin()));
        subset.setMax(this.intersectMax(left.current().getMax(), right.current().getMax()));
        outcome.rule(subset, subset.getMax().equals("*") || Integer.parseInt(subset.getMax()) >= subset.getMin(), path, "Cardinality Mismatch: " + this.card(left) + "/" + this.card(right));
        superset.getType().addAll(this.unionTypes(path, left.current().getType(), right.current().getType()));
        subset.getType().addAll(this.intersectTypes(subset, outcome, path, left.current().getType(), right.current().getType()));
        outcome.rule(subset, !subset.getType().isEmpty() || !left.current().hasType() && !right.current().hasType(), path, "Type Mismatch:\r\n  " + this.typeCode(left) + "\r\n  " + this.typeCode(right));
        superset.setMaxLengthElement(this.unionMaxLength(left.current().getMaxLength(), right.current().getMaxLength()));
        subset.setMaxLengthElement(this.intersectMaxLength(left.current().getMaxLength(), right.current().getMaxLength()));
        if (left.current().hasBinding() || right.current().hasBinding()) {
            this.compareBindings(outcome, subset, superset, path, left.current(), right.current());
        }
        superset.getConstraint().addAll(this.intersectConstraints(path, left.current().getConstraint(), right.current().getConstraint()));
        subset.getConstraint().addAll(this.unionConstraints(subset, outcome, path, left.current().getConstraint(), right.current().getConstraint()));
        outcome.subset.getSnapshot().getElement().add(subset);
        outcome.superset.getSnapshot().getElement().add(superset);
        boolean ret = this.compareChildren(subset, outcome, path, left, right);
        if (left.current().hasSlicing() || right.current().hasSlicing()) {
            assert (sliceName == null);
            if (this.isExtension(left.path())) {
                return this.compareExtensions(outcome, path, superset, subset, left, right);
            }
            ElementDefinition.ElementDefinitionSlicingComponent slicingL = left.current().getSlicing();
            ElementDefinition.ElementDefinitionSlicingComponent slicingR = right.current().getSlicing();
            if (left.current().hasSlicing() && !right.current().hasSlicing()) {
                subset.setSlicing(slicingL);
                this.copySlices(outcome.subset.getSnapshot().getElement(), left.getStructure().getSnapshot().getElement(), left.slices());
            } else if (!left.current().hasSlicing() && right.current().hasSlicing()) {
                subset.setSlicing(slicingR);
                this.copySlices(outcome.subset.getSnapshot().getElement(), right.getStructure().getSnapshot().getElement(), right.slices());
            } else if (this.isTypeSlicing(slicingL) || this.isTypeSlicing(slicingR)) {
                superset.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN).setOrdered(false).addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                subset.getSlicing().setRules(slicingL.getRules() == ElementDefinition.SlicingRules.CLOSED || slicingR.getRules() == ElementDefinition.SlicingRules.CLOSED ? ElementDefinition.SlicingRules.OPEN : ElementDefinition.SlicingRules.CLOSED).setOrdered(false).addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                ArrayList<DefinitionNavigator> handled = new ArrayList<DefinitionNavigator>();
                for (DefinitionNavigator t : left.slices()) {
                    DefinitionNavigator r = this.findMatchingSlice(right.slices(), t);
                    if (r == null) {
                        this.copySlice(outcome.superset.getSnapshot().getElement(), left.getStructure().getSnapshot().getElement(), t);
                        continue;
                    }
                    handled.add(r);
                    ret = this.compareElements(outcome, path + ":" + t.current().getSliceName(), t, r, t.current().getSliceName()) && ret;
                }
                for (DefinitionNavigator t : right.slices()) {
                    if (handled.contains(t)) continue;
                    this.copySlice(outcome.superset.getSnapshot().getElement(), right.getStructure().getSnapshot().getElement(), t);
                }
            } else {
                if (this.slicingMatches(slicingL, slicingR)) {
                    throw new DefinitionException("Slicing matches but is not handled yet at " + left.current().getId() + ": (" + ProfileUtilities.summarizeSlicing(slicingL) + ")");
                }
                throw new DefinitionException("Slicing doesn't match at " + left.current().getId() + ": (" + ProfileUtilities.summarizeSlicing(slicingL) + " / " + ProfileUtilities.summarizeSlicing(slicingR) + ")");
            }
        }
        return ret;
    }

    private DefinitionNavigator findMatchingSlice(List<DefinitionNavigator> slices, DefinitionNavigator tgt) {
        for (DefinitionNavigator t : slices) {
            if (!this.sliceMatchesByType(t, tgt)) continue;
            return t;
        }
        return null;
    }

    private boolean sliceMatchesByType(DefinitionNavigator t, DefinitionNavigator tgt) {
        return t.current().typeSummary().equals(tgt.current().typeSummary());
    }

    private void copySlices(List<ElementDefinition> target, List<ElementDefinition> source, List<DefinitionNavigator> list) {
        for (DefinitionNavigator slice : list) {
            this.copySlice(target, source, slice);
        }
    }

    public void copySlice(List<ElementDefinition> target, List<ElementDefinition> source, DefinitionNavigator slice) {
        target.add(slice.current().copy());
        for (int i = source.indexOf(slice.current()) + 1; i < source.size() && source.get(i).getPath().startsWith(slice.current().getPath() + "."); ++i) {
            target.add(source.get(i).copy());
        }
    }

    private boolean isTypeSlicing(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        return slicing.getDiscriminator().size() == 1 && slicing.getDiscriminatorFirstRep().getType() == ElementDefinition.DiscriminatorType.TYPE && "$this".equals(slicing.getDiscriminatorFirstRep().getPath());
    }

    private boolean slicingMatches(ElementDefinition.ElementDefinitionSlicingComponent l, ElementDefinition.ElementDefinitionSlicingComponent r) {
        if (l.getDiscriminator().size() != r.getDiscriminator().size()) {
            return false;
        }
        for (int i = 0; i < l.getDiscriminator().size(); ++i) {
            if (this.slicingMatches(l.getDiscriminator().get(i), r.getDiscriminator().get(i))) continue;
            return false;
        }
        return l.getOrdered() == r.getOrdered();
    }

    private boolean slicingMatches(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent l, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent r) {
        return l.getType() == r.getType() && l.getPath().equals(r.getPath());
    }

    private boolean compareExtensions(ProfileComparison outcome, String path, ElementDefinition superset, ElementDefinition subset, DefinitionNavigator left, DefinitionNavigator right) throws DefinitionException {
        ExtensionUsage exd;
        String url;
        HashMap<String, ExtensionUsage> map = new HashMap<String, ExtensionUsage>();
        if (left.slices() != null) {
            for (DefinitionNavigator ex : left.slices()) {
                url = (String)ex.current().getType().get(0).getProfile().get(0).getValue();
                if (map.containsKey(url)) {
                    throw new DefinitionException("Duplicate Extension " + url + " at " + path);
                }
                map.put(url, new ExtensionUsage(ex, ex.current().getMin(), ex.current().getMax()));
            }
        }
        if (right.slices() != null) {
            for (DefinitionNavigator ex : right.slices()) {
                url = (String)ex.current().getType().get(0).getProfile().get(0).getValue();
                if (map.containsKey(url)) {
                    exd = (ExtensionUsage)map.get(url);
                    exd.minSuperset = this.unionMin(exd.defn.current().getMin(), ex.current().getMin());
                    exd.maxSuperset = this.unionMax(exd.defn.current().getMax(), ex.current().getMax());
                    exd.minSubset = this.intersectMin(exd.defn.current().getMin(), ex.current().getMin());
                    exd.maxSubset = this.intersectMax(exd.defn.current().getMax(), ex.current().getMax());
                    exd.both = true;
                    outcome.rule(subset, exd.maxSubset.equals("*") || Integer.parseInt(exd.maxSubset) >= exd.minSubset, path, "Cardinality Mismatch on extension: " + this.card(exd.defn) + "/" + this.card(ex));
                    continue;
                }
                map.put(url, new ExtensionUsage(ex, ex.current().getMin(), ex.current().getMax()));
            }
        }
        ArrayList names = new ArrayList();
        names.addAll(map.keySet());
        Collections.sort(names);
        for (String name : names) {
            exd = (ExtensionUsage)map.get(name);
            if (exd.both) {
                outcome.subset.getSnapshot().getElement().add(exd.defn.current().copy().setMin(exd.minSubset).setMax(exd.maxSubset));
            }
            outcome.superset.getSnapshot().getElement().add(exd.defn.current().copy().setMin(exd.minSuperset).setMax(exd.maxSuperset));
        }
        return true;
    }

    private boolean isExtension(String path) {
        return path.endsWith(".extension") || path.endsWith(".modifierExtension");
    }

    private boolean compareChildren(ElementDefinition ed, ProfileComparison outcome, String path, DefinitionNavigator left, DefinitionNavigator right) throws DefinitionException, IOException, FHIRFormatError {
        List<DefinitionNavigator> lc = left.children();
        List<DefinitionNavigator> rc = right.children();
        if (lc.isEmpty() && !rc.isEmpty() && right.current().getType().size() == 1 && left.hasTypeChildren(right.current().getType().get(0))) {
            lc = left.childrenFromType(right.current().getType().get(0));
        }
        if (rc.isEmpty() && !lc.isEmpty() && left.current().getType().size() == 1 && right.hasTypeChildren(left.current().getType().get(0))) {
            rc = right.childrenFromType(left.current().getType().get(0));
        }
        if (lc.size() != rc.size()) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Different number of children at " + path + " (" + Integer.toString(lc.size()) + "/" + Integer.toString(rc.size()) + ")", ValidationMessage.IssueSeverity.ERROR));
            this.status(ed, 3);
            return false;
        }
        for (int i = 0; i < lc.size(); ++i) {
            DefinitionNavigator l = lc.get(i);
            DefinitionNavigator r = rc.get(i);
            String cpath = this.comparePaths(l.path(), r.path(), path, l.nameTail(), r.nameTail());
            if (cpath != null) {
                if (this.compareElements(outcome, cpath, l, r, null)) continue;
                return false;
            }
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Different path at " + path + "[" + Integer.toString(i) + "] (" + l.path() + "/" + r.path() + ")", ValidationMessage.IssueSeverity.ERROR));
            this.status(ed, 3);
            return false;
        }
        return true;
    }

    private String comparePaths(String path1, String path2, String path, String tail1, String tail2) {
        if (tail1.equals(tail2)) {
            return path + "." + tail1;
        }
        if (tail1.endsWith("[x]") && tail2.startsWith(tail1.substring(0, tail1.length() - 3))) {
            return path + "." + tail1;
        }
        if (tail2.endsWith("[x]") && tail1.startsWith(tail2.substring(0, tail2.length() - 3))) {
            return path + "." + tail2;
        }
        return null;
    }

    private boolean compareBindings(ProfileComparison outcome, ElementDefinition subset, ElementDefinition superset, String path, ElementDefinition lDef, ElementDefinition rDef) throws FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent right;
        assert (lDef.hasBinding() || rDef.hasBinding());
        if (!lDef.hasBinding()) {
            subset.setBinding(rDef.getBinding());
            superset.setBinding(rDef.getBinding().copy());
            superset.getBinding().setStrength(Enumerations.BindingStrength.EXAMPLE);
            return true;
        }
        if (!rDef.hasBinding()) {
            subset.setBinding(lDef.getBinding());
            superset.setBinding(lDef.getBinding().copy());
            superset.getBinding().setStrength(Enumerations.BindingStrength.EXAMPLE);
            return true;
        }
        ElementDefinition.ElementDefinitionBindingComponent left = lDef.getBinding();
        if (Base.compareDeep(left, right = rDef.getBinding(), false)) {
            subset.setBinding(left);
            superset.setBinding(right);
        }
        if (this.isPreferredOrExample(left) && this.isPreferredOrExample(right)) {
            if (right.getStrength() == Enumerations.BindingStrength.PREFERRED && left.getStrength() == Enumerations.BindingStrength.EXAMPLE && !Base.compareDeep(left.getValueSet(), right.getValueSet(), false)) {
                outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Example/preferred bindings differ at " + path + " using binding from " + outcome.rightName(), ValidationMessage.IssueSeverity.INFORMATION));
                this.status(subset, 1);
                subset.setBinding(right);
                superset.setBinding(this.unionBindings(superset, outcome, path, left, right));
            } else {
                if (!(right.getStrength() == Enumerations.BindingStrength.EXAMPLE && left.getStrength() == Enumerations.BindingStrength.EXAMPLE || Base.compareDeep(left.getValueSet(), right.getValueSet(), false))) {
                    outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Example/preferred bindings differ at " + path + " using binding from " + outcome.leftName(), ValidationMessage.IssueSeverity.INFORMATION));
                    this.status(subset, 1);
                }
                subset.setBinding(left);
                superset.setBinding(this.unionBindings(superset, outcome, path, left, right));
            }
            return true;
        }
        if (this.isPreferredOrExample(left)) {
            subset.setBinding(right);
            superset.setBinding(this.unionBindings(superset, outcome, path, left, right));
            return true;
        }
        if (this.isPreferredOrExample(right)) {
            subset.setBinding(left);
            superset.setBinding(this.unionBindings(superset, outcome, path, left, right));
            return true;
        }
        ElementDefinition.ElementDefinitionBindingComponent subBinding = new ElementDefinition.ElementDefinitionBindingComponent();
        subset.setBinding(subBinding);
        ElementDefinition.ElementDefinitionBindingComponent superBinding = new ElementDefinition.ElementDefinitionBindingComponent();
        superset.setBinding(superBinding);
        subBinding.setDescription(this.mergeText(subset, outcome, path, "description", left.getDescription(), right.getDescription()));
        superBinding.setDescription(this.mergeText(subset, outcome, null, "description", left.getDescription(), right.getDescription()));
        if (left.getStrength() == Enumerations.BindingStrength.REQUIRED || right.getStrength() == Enumerations.BindingStrength.REQUIRED) {
            subBinding.setStrength(Enumerations.BindingStrength.REQUIRED);
        } else {
            subBinding.setStrength(Enumerations.BindingStrength.EXTENSIBLE);
        }
        if (left.getStrength() == Enumerations.BindingStrength.EXTENSIBLE || right.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
            superBinding.setStrength(Enumerations.BindingStrength.EXTENSIBLE);
        } else {
            superBinding.setStrength(Enumerations.BindingStrength.REQUIRED);
        }
        if (Base.compareDeep(left.getValueSet(), right.getValueSet(), false)) {
            subBinding.setValueSet(left.getValueSet());
            superBinding.setValueSet(left.getValueSet());
            return true;
        }
        if (!left.hasValueSet()) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "No left Value set at " + path, ValidationMessage.IssueSeverity.ERROR));
            return true;
        }
        if (!right.hasValueSet()) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "No right Value set at " + path, ValidationMessage.IssueSeverity.ERROR));
            return true;
        }
        ValueSet lvs = this.resolveVS(outcome.left, left.getValueSet());
        ValueSet rvs = this.resolveVS(outcome.right, right.getValueSet());
        if (lvs == null) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Unable to resolve left value set " + left.getValueSet().toString() + " at " + path, ValidationMessage.IssueSeverity.ERROR));
            return true;
        }
        if (rvs == null) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Unable to resolve right value set " + right.getValueSet().toString() + " at " + path, ValidationMessage.IssueSeverity.ERROR));
            return true;
        }
        ValueSet cvs = this.intersectByDefinition(lvs, rvs);
        if (cvs == null) {
            try {
                ValueSetExpander.ValueSetExpansionOutcome le = this.context.expandVS(lvs, true, false);
                ValueSetExpander.ValueSetExpansionOutcome re = this.context.expandVS(rvs, true, false);
                if (!this.closed(le.getValueset()) || !this.closed(re.getValueset())) {
                    throw new DefinitionException("unclosed value sets are not handled yet");
                }
                cvs = this.intersectByExpansion(path, le.getValueset(), re.getValueset());
                if (!cvs.getCompose().hasInclude()) {
                    outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "The value sets " + lvs.getUrl() + " and " + rvs.getUrl() + " do not intersect", ValidationMessage.IssueSeverity.ERROR));
                    this.status(subset, 3);
                    return false;
                }
            }
            catch (Exception e) {
                outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Unable to expand or process value sets " + lvs.getUrl() + " and " + rvs.getUrl() + ": " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR));
                this.status(subset, 3);
                return false;
            }
        }
        subBinding.setValueSet("#" + this.addValueSet(cvs));
        superBinding.setValueSet("#" + this.addValueSet(this.unite(superset, outcome, path, lvs, rvs)));
        return false;
    }

    private ElementDefinition.ElementDefinitionBindingComponent unionBindings(ElementDefinition ed, ProfileComparison outcome, String path, ElementDefinition.ElementDefinitionBindingComponent left, ElementDefinition.ElementDefinitionBindingComponent right) throws FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent union = new ElementDefinition.ElementDefinitionBindingComponent();
        if (left.getStrength().compareTo(right.getStrength()) < 0) {
            union.setStrength(left.getStrength());
        } else {
            union.setStrength(right.getStrength());
        }
        union.setDescription(this.mergeText(ed, outcome, path, "binding.description", left.getDescription(), right.getDescription()));
        if (Base.compareDeep(left.getValueSet(), right.getValueSet(), false)) {
            union.setValueSet(left.getValueSet());
        } else {
            ValueSet lvs = this.resolveVS(outcome.left, left.getValueSet());
            ValueSet rvs = this.resolveVS(outcome.left, right.getValueSet());
            if (lvs != null && rvs != null) {
                union.setValueSet("#" + this.addValueSet(this.unite(ed, outcome, path, lvs, rvs)));
            } else if (lvs != null) {
                union.setValueSet("#" + this.addValueSet(lvs));
            } else if (rvs != null) {
                union.setValueSet("#" + this.addValueSet(rvs));
            }
        }
        return union;
    }

    private ValueSet unite(ElementDefinition ed, ProfileComparison outcome, String path, ValueSet lvs, ValueSet rvs) {
        ValueSet vs = new ValueSet();
        vs.setName(path);
        if (lvs.hasCompose()) {
            for (ValueSet.ConceptSetComponent inc : lvs.getCompose().getInclude()) {
                vs.getCompose().getInclude().add(inc);
            }
            if (lvs.getCompose().hasExclude()) {
                outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "The value sets " + lvs.getUrl() + " has exclude statements, and no union involving it can be correctly determined", ValidationMessage.IssueSeverity.ERROR));
                this.status(ed, 3);
            }
        }
        if (rvs.hasCompose()) {
            for (ValueSet.ConceptSetComponent inc : rvs.getCompose().getInclude()) {
                if (this.mergeIntoExisting(vs.getCompose().getInclude(), inc)) continue;
                vs.getCompose().getInclude().add(inc);
            }
            if (rvs.getCompose().hasExclude()) {
                outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "The value sets " + lvs.getUrl() + " has exclude statements, and no union involving it can be correctly determined", ValidationMessage.IssueSeverity.ERROR));
                this.status(ed, 3);
            }
        }
        return vs;
    }

    private boolean mergeIntoExisting(List<ValueSet.ConceptSetComponent> include, ValueSet.ConceptSetComponent inc) {
        for (ValueSet.ConceptSetComponent dst : include) {
            if (Base.compareDeep(dst, inc, false)) {
                return true;
            }
            if (!dst.hasSystem() || !dst.getSystem().equals(inc.getSystem())) continue;
            if (inc.hasFilter() || dst.hasFilter()) {
                return false;
            }
            if (inc.hasConcept() && dst.hasConcept()) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    boolean found = false;
                    for (ValueSet.ConceptReferenceComponent dd : dst.getConcept()) {
                        if (dd.getCode().equals(cc.getCode())) {
                            found = true;
                        }
                        if (!found) continue;
                        if (!cc.hasDisplay() || dd.hasDisplay()) break;
                        dd.setDisplay(cc.getDisplay());
                        break;
                    }
                    if (found) continue;
                    dst.getConcept().add(cc.copy());
                }
                continue;
            }
            dst.getConcept().clear();
        }
        return false;
    }

    private ValueSet resolveVS(StructureDefinition ctxtLeft, String vsRef) {
        if (vsRef == null) {
            return null;
        }
        return this.context.fetchResource(ValueSet.class, vsRef);
    }

    private ValueSet intersectByDefinition(ValueSet lvs, ValueSet rvs) {
        return null;
    }

    private ValueSet intersectByExpansion(String path, ValueSet lvs, ValueSet rvs) {
        ValueSet vs = new ValueSet();
        vs.setName(path);
        vs.setStatus(Enumerations.PublicationStatus.DRAFT);
        HashMap<String, ValueSet.ValueSetExpansionContainsComponent> left = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
        this.scan(lvs.getExpansion().getContains(), left);
        HashMap<String, ValueSet.ValueSetExpansionContainsComponent> right = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
        this.scan(rvs.getExpansion().getContains(), right);
        HashMap<String, ValueSet.ConceptSetComponent> inc = new HashMap<String, ValueSet.ConceptSetComponent>();
        for (String s : left.keySet()) {
            if (!right.containsKey(s)) continue;
            ValueSet.ValueSetExpansionContainsComponent cc = (ValueSet.ValueSetExpansionContainsComponent)left.get(s);
            ValueSet.ConceptSetComponent c = (ValueSet.ConceptSetComponent)inc.get(cc.getSystem());
            if (c == null) {
                c = vs.getCompose().addInclude().setSystem(cc.getSystem());
                inc.put(cc.getSystem(), c);
            }
            c.addConcept().setCode(cc.getCode()).setDisplay(cc.getDisplay());
        }
        return vs;
    }

    private void scan(List<ValueSet.ValueSetExpansionContainsComponent> list, Map<String, ValueSet.ValueSetExpansionContainsComponent> map) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : list) {
            String s;
            if (cc.hasSystem() && cc.hasCode() && !map.containsKey(s = cc.getSystem() + "::" + cc.getCode())) {
                map.put(s, cc);
            }
            if (!cc.hasContains()) continue;
            this.scan(cc.getContains(), map);
        }
    }

    private boolean closed(ValueSet vs) {
        return !ToolingExtensions.findBooleanExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-unclosed");
    }

    private boolean isPreferredOrExample(ElementDefinition.ElementDefinitionBindingComponent binding) {
        return binding.getStrength() == Enumerations.BindingStrength.EXAMPLE || binding.getStrength() == Enumerations.BindingStrength.PREFERRED;
    }

    private Collection<? extends ElementDefinition.TypeRefComponent> intersectTypes(ElementDefinition ed, ProfileComparison outcome, String path, List<ElementDefinition.TypeRefComponent> left, List<ElementDefinition.TypeRefComponent> right) throws DefinitionException, IOException, FHIRFormatError {
        ArrayList<ElementDefinition.TypeRefComponent> result = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent l : left) {
            if (l.hasAggregation()) {
                throw new DefinitionException("Aggregation not supported: " + path);
            }
            boolean pfound = false;
            boolean tfound = false;
            ElementDefinition.TypeRefComponent c = l.copy();
            for (ElementDefinition.TypeRefComponent r : right) {
                ProfileComparison comp;
                StructureDefinition sdr;
                StructureDefinition sdl;
                if (r.hasAggregation()) {
                    throw new DefinitionException("Aggregation not supported: " + path);
                }
                if (!l.hasProfile() && !r.hasProfile()) {
                    pfound = true;
                } else if (!r.hasProfile()) {
                    pfound = true;
                } else if (!l.hasProfile()) {
                    pfound = true;
                    c.setProfile(r.getProfile());
                } else {
                    sdl = this.resolveProfile(ed, outcome, path, (String)l.getProfile().get(0).getValue(), outcome.leftName());
                    sdr = this.resolveProfile(ed, outcome, path, (String)r.getProfile().get(0).getValue(), outcome.rightName());
                    if (sdl != null && sdr != null) {
                        if (sdl == sdr) {
                            pfound = true;
                        } else if (this.derivesFrom(sdl, sdr)) {
                            pfound = true;
                        } else if (this.derivesFrom(sdr, sdl)) {
                            c.setProfile(r.getProfile());
                            pfound = true;
                        } else if (sdl.getType().equals(sdr.getType()) && (comp = this.compareProfiles(sdl, sdr)).getSubset() != null) {
                            pfound = true;
                            c.addProfile("#" + comp.id);
                        }
                    }
                }
                if (!l.hasTargetProfile() && !r.hasTargetProfile()) {
                    tfound = true;
                    continue;
                }
                if (!r.hasTargetProfile()) {
                    tfound = true;
                    continue;
                }
                if (!l.hasTargetProfile()) {
                    tfound = true;
                    c.setTargetProfile(r.getTargetProfile());
                    continue;
                }
                sdl = this.resolveProfile(ed, outcome, path, (String)l.getTargetProfile().get(0).getValue(), outcome.leftName());
                sdr = this.resolveProfile(ed, outcome, path, (String)r.getTargetProfile().get(0).getValue(), outcome.rightName());
                if (sdl == null || sdr == null) continue;
                if (sdl == sdr) {
                    tfound = true;
                    continue;
                }
                if (this.derivesFrom(sdl, sdr)) {
                    tfound = true;
                    continue;
                }
                if (this.derivesFrom(sdr, sdl)) {
                    c.setTargetProfile(r.getTargetProfile());
                    tfound = true;
                    continue;
                }
                if (!sdl.getType().equals(sdr.getType()) || (comp = this.compareProfiles(sdl, sdr)).getSubset() == null) continue;
                tfound = true;
                c.addTargetProfile("#" + comp.id);
            }
            if (!pfound || !tfound) continue;
            result.add(c);
        }
        return result;
    }

    private StructureDefinition resolveProfile(ElementDefinition ed, ProfileComparison outcome, String path, String url, String name) {
        StructureDefinition res = this.context.fetchResource(StructureDefinition.class, url);
        if (res == null) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Unable to resolve profile " + url + " in profile " + name, ValidationMessage.IssueSeverity.WARNING));
            this.status(ed, 1);
        }
        return res;
    }

    private Collection<? extends ElementDefinition.TypeRefComponent> unionTypes(String path, List<ElementDefinition.TypeRefComponent> left, List<ElementDefinition.TypeRefComponent> right) throws DefinitionException, IOException, FHIRFormatError {
        ArrayList<ElementDefinition.TypeRefComponent> result = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent l : left) {
            this.checkAddTypeUnion(path, result, l);
        }
        for (ElementDefinition.TypeRefComponent r : right) {
            this.checkAddTypeUnion(path, result, r);
        }
        return result;
    }

    private void checkAddTypeUnion(String path, List<ElementDefinition.TypeRefComponent> results, ElementDefinition.TypeRefComponent nw) throws DefinitionException, IOException, FHIRFormatError {
        boolean pfound = false;
        boolean tfound = false;
        if ((nw = nw.copy()).hasAggregation()) {
            throw new DefinitionException("Aggregation not supported: " + path);
        }
        for (ElementDefinition.TypeRefComponent ex : results) {
            ProfileComparison comp;
            StructureDefinition sdnw;
            StructureDefinition sdex;
            if (!Utilities.equals((String)ex.getWorkingCode(), (String)nw.getWorkingCode())) continue;
            if (!ex.hasProfile() && !nw.hasProfile()) {
                pfound = true;
            } else if (!ex.hasProfile()) {
                pfound = true;
            } else if (!nw.hasProfile()) {
                pfound = true;
                ex.setProfile(null);
            } else {
                sdex = this.context.fetchResource(StructureDefinition.class, (String)ex.getProfile().get(0).getValue());
                sdnw = this.context.fetchResource(StructureDefinition.class, (String)nw.getProfile().get(0).getValue());
                if (sdex != null && sdnw != null) {
                    if (sdex == sdnw) {
                        pfound = true;
                    } else if (this.derivesFrom(sdex, sdnw)) {
                        ex.setProfile(nw.getProfile());
                        pfound = true;
                    } else if (this.derivesFrom(sdnw, sdex)) {
                        pfound = true;
                    } else if (sdnw.getSnapshot().getElement().get(0).getPath().equals(sdex.getSnapshot().getElement().get(0).getPath()) && (comp = this.compareProfiles(sdex, sdnw)).getSuperset() != null) {
                        pfound = true;
                        ex.addProfile("#" + comp.id);
                    }
                }
            }
            if (!ex.hasTargetProfile() && !nw.hasTargetProfile()) {
                tfound = true;
                continue;
            }
            if (!ex.hasTargetProfile()) {
                tfound = true;
                continue;
            }
            if (!nw.hasTargetProfile()) {
                tfound = true;
                ex.setTargetProfile(null);
                continue;
            }
            sdex = this.context.fetchResource(StructureDefinition.class, (String)ex.getTargetProfile().get(0).getValue());
            sdnw = this.context.fetchResource(StructureDefinition.class, (String)nw.getTargetProfile().get(0).getValue());
            if (sdex == null || sdnw == null) continue;
            if (sdex == sdnw) {
                tfound = true;
                continue;
            }
            if (this.derivesFrom(sdex, sdnw)) {
                ex.setTargetProfile(nw.getTargetProfile());
                tfound = true;
                continue;
            }
            if (this.derivesFrom(sdnw, sdex)) {
                tfound = true;
                continue;
            }
            if (!sdnw.getSnapshot().getElement().get(0).getPath().equals(sdex.getSnapshot().getElement().get(0).getPath()) || (comp = this.compareProfiles(sdex, sdnw)).getSuperset() == null) continue;
            tfound = true;
            ex.addTargetProfile("#" + comp.id);
        }
        if (!tfound || !pfound) {
            results.add(nw);
        }
    }

    private boolean derivesFrom(StructureDefinition left, StructureDefinition right) {
        return left.hasBaseDefinition() && left.getBaseDefinition().equals(right.getUrl());
    }

    private String mergeText(ElementDefinition ed, ProfileComparison outcome, String path, String name, String left, String right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if ((left = this.stripLinks(left)).equalsIgnoreCase(right = this.stripLinks(right))) {
            return left;
        }
        if (path != null) {
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Elements differ in definition for " + name + ":\r\n  \"" + left + "\"\r\n  \"" + right + "\"", "Elements differ in definition for " + name + ":<br/>\"" + Utilities.escapeXml((String)left) + "\"<br/>\"" + Utilities.escapeXml((String)right) + "\"", ValidationMessage.IssueSeverity.INFORMATION));
            this.status(ed, 1);
        }
        return "left: " + left + "; right: " + right;
    }

    private String stripLinks(String s) {
        while (s.contains("](")) {
            int i = s.indexOf("](");
            int j = s.substring(i).indexOf(")");
            if (j == -1) {
                return s;
            }
            s = s.substring(0, i + 1) + s.substring(i + j + 1);
        }
        return s;
    }

    private List<Coding> mergeCodings(List<Coding> left, List<Coding> right) {
        ArrayList<Coding> result = new ArrayList<Coding>();
        result.addAll(left);
        for (Coding c : right) {
            boolean found = false;
            for (Coding ct : left) {
                if (!Utilities.equals((String)c.getSystem(), (String)ct.getSystem()) || !Utilities.equals((String)c.getCode(), (String)ct.getCode())) continue;
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    private List<StringType> mergeStrings(List<StringType> left, List<StringType> right) {
        ArrayList<StringType> result = new ArrayList<StringType>();
        result.addAll(left);
        for (StringType c : right) {
            boolean found = false;
            for (StringType ct : left) {
                if (!Utilities.equals((String)((String)c.getValue()), (String)((String)ct.getValue()))) continue;
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    private List<ElementDefinition.ElementDefinitionMappingComponent> mergeMappings(List<ElementDefinition.ElementDefinitionMappingComponent> left, List<ElementDefinition.ElementDefinitionMappingComponent> right) {
        ArrayList<ElementDefinition.ElementDefinitionMappingComponent> result = new ArrayList<ElementDefinition.ElementDefinitionMappingComponent>();
        result.addAll(left);
        for (ElementDefinition.ElementDefinitionMappingComponent c : right) {
            boolean found = false;
            for (ElementDefinition.ElementDefinitionMappingComponent ct : left) {
                if (!Utilities.equals((String)c.getIdentity(), (String)ct.getIdentity()) || !Utilities.equals((String)c.getLanguage(), (String)ct.getLanguage()) || !Utilities.equals((String)c.getMap(), (String)ct.getMap())) continue;
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    private List<ElementDefinition.ElementDefinitionConstraintComponent> unionConstraints(ElementDefinition ed, ProfileComparison outcome, String path, List<ElementDefinition.ElementDefinitionConstraintComponent> left, List<ElementDefinition.ElementDefinitionConstraintComponent> right) {
        boolean found;
        ArrayList<ElementDefinition.ElementDefinitionConstraintComponent> result = new ArrayList<ElementDefinition.ElementDefinitionConstraintComponent>();
        for (ElementDefinition.ElementDefinitionConstraintComponent l : left) {
            found = false;
            for (ElementDefinition.ElementDefinitionConstraintComponent r : right) {
                if (!Utilities.equals((String)r.getId(), (String)l.getId()) && (!Utilities.equals((String)r.getXpath(), (String)l.getXpath()) || r.getSeverity() != l.getSeverity())) continue;
                found = true;
            }
            if (!found) {
                outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "StructureDefinition " + outcome.leftName() + " has a constraint that is not found in " + outcome.rightName() + " and it is uncertain whether they are compatible (" + l.getXpath() + ")", ValidationMessage.IssueSeverity.INFORMATION));
                this.status(ed, 2);
            }
            result.add(l);
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent r : right) {
            found = false;
            for (ElementDefinition.ElementDefinitionConstraintComponent l : left) {
                if (!Utilities.equals((String)r.getId(), (String)l.getId()) && (!Utilities.equals((String)r.getXpath(), (String)l.getXpath()) || r.getSeverity() != l.getSeverity())) continue;
                found = true;
            }
            if (found) continue;
            outcome.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "StructureDefinition " + outcome.rightName() + " has a constraint that is not found in " + outcome.leftName() + " and it is uncertain whether they are compatible (" + r.getXpath() + ")", ValidationMessage.IssueSeverity.INFORMATION));
            this.status(ed, 2);
            result.add(r);
        }
        return result;
    }

    private List<ElementDefinition.ElementDefinitionConstraintComponent> intersectConstraints(String path, List<ElementDefinition.ElementDefinitionConstraintComponent> left, List<ElementDefinition.ElementDefinitionConstraintComponent> right) {
        ArrayList<ElementDefinition.ElementDefinitionConstraintComponent> result = new ArrayList<ElementDefinition.ElementDefinitionConstraintComponent>();
        for (ElementDefinition.ElementDefinitionConstraintComponent l : left) {
            boolean found = false;
            for (ElementDefinition.ElementDefinitionConstraintComponent r : right) {
                if (!Utilities.equals((String)r.getId(), (String)l.getId()) && (!Utilities.equals((String)r.getXpath(), (String)l.getXpath()) || r.getSeverity() != l.getSeverity())) continue;
                found = true;
            }
            if (!found) continue;
            result.add(l);
        }
        return result;
    }

    private String card(DefinitionNavigator defn) {
        return Integer.toString(defn.current().getMin()) + ".." + defn.current().getMax();
    }

    private String typeCode(DefinitionNavigator defn) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : defn.current().getType()) {
            b.append(t.getWorkingCode() + (t.hasProfile() ? "(" + t.getProfile() + ")" : "") + (t.hasTargetProfile() ? "(" + t.getTargetProfile() + ")" : ""));
        }
        return b.toString();
    }

    private int intersectMin(int left, int right) {
        if (left > right) {
            return left;
        }
        return right;
    }

    private int unionMin(int left, int right) {
        if (left > right) {
            return right;
        }
        return left;
    }

    private String intersectMax(String left, String right) {
        int r;
        int l = "*".equals(left) ? Integer.MAX_VALUE : Integer.parseInt(left);
        int n = r = "*".equals(right) ? Integer.MAX_VALUE : Integer.parseInt(right);
        if (l < r) {
            return left;
        }
        return right;
    }

    private String unionMax(String left, String right) {
        int r;
        int l = "*".equals(left) ? Integer.MAX_VALUE : Integer.parseInt(left);
        int n = r = "*".equals(right) ? Integer.MAX_VALUE : Integer.parseInt(right);
        if (l < r) {
            return right;
        }
        return left;
    }

    private IntegerType intersectMaxLength(int left, int right) {
        if (left == 0) {
            left = Integer.MAX_VALUE;
        }
        if (right == 0) {
            right = Integer.MAX_VALUE;
        }
        if (left < right) {
            return left == Integer.MAX_VALUE ? null : new IntegerType(left);
        }
        return right == Integer.MAX_VALUE ? null : new IntegerType(right);
    }

    private IntegerType unionMaxLength(int left, int right) {
        if (left == 0) {
            left = Integer.MAX_VALUE;
        }
        if (right == 0) {
            right = Integer.MAX_VALUE;
        }
        if (left < right) {
            return right == Integer.MAX_VALUE ? null : new IntegerType(right);
        }
        return left == Integer.MAX_VALUE ? null : new IntegerType(left);
    }

    public String addValueSet(ValueSet cvs) {
        String id = Integer.toString(this.valuesets.size() + 1);
        cvs.setId(id);
        this.valuesets.add(cvs);
        return id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLeftLink() {
        return this.leftLink;
    }

    public void setLeftLink(String leftLink) {
        this.leftLink = leftLink;
    }

    public String getLeftName() {
        return this.leftName;
    }

    public void setLeftName(String leftName) {
        this.leftName = leftName;
    }

    public String getRightLink() {
        return this.rightLink;
    }

    public void setRightLink(String rightLink) {
        this.rightLink = rightLink;
    }

    public String getRightName() {
        return this.rightName;
    }

    public void setRightName(String rightName) {
        this.rightName = rightName;
    }

    private String genPCLink(String leftName, String leftLink) {
        if (leftLink == null) {
            return leftName;
        }
        return "<a href=\"" + leftLink + "\">" + Utilities.escapeXml((String)leftName) + "</a>";
    }

    private String genValueSets(String base) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("<ul>\r\n");
        for (ValueSet vs : this.getValuesets()) {
            System.out.println("  .. Value set: " + vs.getName());
            b.append("<li>");
            b.append(" <td><a href=\"" + base + "-" + vs.getId() + ".html\">" + Utilities.escapeXml((String)vs.present()) + "</a></td>");
            b.append("</li>\r\n");
            this.genValueSetFile(base + "-" + vs.getId() + ".html", vs);
        }
        b.append("</ul>\r\n");
        return b.toString();
    }

    private void genValueSetFile(String filename, ValueSet vs) throws IOException {
        NarrativeGenerator gen = new NarrativeGenerator("", "http://hl7.org/fhir", this.context);
        gen.setNoSlowLookup(true);
        gen.generate(null, vs, false);
        String s = new XhtmlComposer(false).compose(vs.getText().getDiv());
        StringBuilder b = new StringBuilder();
        b.append("<html>");
        b.append("<head>");
        b.append("<title>" + vs.present() + "</title>");
        b.append("<link rel=\"stylesheet\" href=\"fhir.css\"/>\r\n");
        b.append("</head>");
        b.append("<body>");
        b.append("<h2>" + vs.present() + "</h2>");
        b.append(s);
        b.append("</body>");
        b.append("</html>");
        TextFile.stringToFile((String)b.toString(), (String)filename);
    }

    private String genPCTable() {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"grid\">\r\n");
        b.append("<tr>");
        b.append(" <td><b>Left</b></td>");
        b.append(" <td><b>Right</b></td>");
        b.append(" <td><b>Comparison</b></td>");
        b.append(" <td><b>Error #</b></td>");
        b.append(" <td><b>Warning #</b></td>");
        b.append(" <td><b>Hint #</b></td>");
        b.append("</tr>");
        for (ProfileComparison cmp : this.getComparisons()) {
            b.append("<tr>");
            b.append(" <td><a href=\"" + cmp.getLeft().getUserString("path") + "\">" + Utilities.escapeXml((String)cmp.getLeft().getName()) + "</a></td>");
            b.append(" <td><a href=\"" + cmp.getRight().getUserString("path") + "\">" + Utilities.escapeXml((String)cmp.getRight().getName()) + "</a></td>");
            b.append(" <td><a href=\"" + this.getId() + "." + cmp.getId() + ".html\">Click Here</a></td>");
            b.append(" <td>" + cmp.getErrorCount() + "</td>");
            b.append(" <td>" + cmp.getWarningCount() + "</td>");
            b.append(" <td>" + cmp.getHintCount() + "</td>");
            b.append("</tr>");
        }
        b.append("</table>\r\n");
        return b.toString();
    }

    private String genCmpMessages(ProfileComparison cmp) {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"grid\">\r\n");
        b.append("<tr><td><b>Path</b></td><td><b>Message</b></td></tr>\r\n");
        b.append("<tr><td colspan=\"2\" style=\"background: #eeeeee\">Errors Detected</td></tr>\r\n");
        boolean found = false;
        for (ValidationMessage vm : cmp.getMessages()) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
            found = true;
            b.append("<tr><td>" + vm.getLocation() + "</td><td>" + vm.getHtml() + (vm.getLevel() == ValidationMessage.IssueSeverity.FATAL ? "(<span style=\"color: maroon\">This error terminated the comparison process</span>)" : "") + "</td></tr>\r\n");
        }
        if (!found) {
            b.append("<tr><td colspan=\"2\">(None)</td></tr>\r\n");
        }
        boolean first = true;
        for (ValidationMessage vm : cmp.getMessages()) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.WARNING) continue;
            if (first) {
                first = false;
                b.append("<tr><td colspan=\"2\" style=\"background: #eeeeee\">Warnings about the comparison</td></tr>\r\n");
            }
            b.append("<tr><td>" + vm.getLocation() + "</td><td>" + vm.getHtml() + "</td></tr>\r\n");
        }
        first = true;
        for (ValidationMessage vm : cmp.getMessages()) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.INFORMATION) continue;
            if (first) {
                b.append("<tr><td colspan=\"2\" style=\"background: #eeeeee\">Notes about differences (e.g. definitions)</td></tr>\r\n");
                first = false;
            }
            b.append("<tr><td>" + vm.getLocation() + "</td><td>" + vm.getHtml() + "</td></tr>\r\n");
        }
        b.append("</table>\r\n");
        return b.toString();
    }

    private String genCompModel(StructureDefinition sd, String name, String base, String prefix, String dest) throws FHIRException, IOException {
        if (sd == null) {
            return "<p style=\"color: maroon\">No " + name + " could be generated</p>\r\n";
        }
        return new XhtmlComposer(false).compose(new ProfileUtilities(this.context, null, this).generateTable("??", sd, false, dest, false, base, true, prefix, prefix, false, false, null));
    }

    public String generate() throws IOException {
        for (ValueSet vs : this.valuesets) {
            vs.setUserData("path", this.folder + "/" + this.getId() + "-vs-" + vs.getId() + ".html");
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("title", this.getTitle());
        vars.put("left", this.genPCLink(this.getLeftName(), this.getLeftLink()));
        vars.put("right", this.genPCLink(this.getRightName(), this.getRightLink()));
        vars.put("table", this.genPCTable());
        vars.put("valuesets", this.genValueSets(this.folder + "/" + this.getId() + "-vs"));
        this.producePage(this.summaryTemplate(), Utilities.path((String[])new String[]{this.folder, this.getId() + ".html"}), vars);
        for (ProfileComparison cmp : this.getComparisons()) {
            vars.clear();
            vars.put("title", this.getTitle());
            vars.put("left", this.genPCLink(this.getLeftName(), this.getLeftLink()));
            vars.put("right", this.genPCLink(this.getRightName(), this.getRightLink()));
            vars.put("messages", this.genCmpMessages(cmp));
            vars.put("subset", this.genCompModel(cmp.getSubset(), "intersection", this.getId() + "." + cmp.getId(), "", this.folder));
            vars.put("superset", this.genCompModel(cmp.getSuperset(), "union", this.getId() + "." + cmp.getId(), "", this.folder));
            this.producePage(this.singleTemplate(), Utilities.path((String[])new String[]{this.folder, this.getId() + "." + cmp.getId() + ".html"}), vars);
        }
        return Utilities.path((String[])new String[]{this.folder, this.getId() + ".html"});
    }

    private void producePage(String src, String path, Map<String, String> vars) throws IOException {
        while (src.contains("[%")) {
            int i1 = src.indexOf("[%");
            int i2 = src.substring(i1).indexOf("%]") + i1;
            String s1 = src.substring(0, i1);
            String s2 = src.substring(i1 + 2, i2).trim();
            String s3 = src.substring(i2 + 2);
            String v = vars.containsKey(s2) ? vars.get(s2) : "???";
            src = s1 + v + s3;
        }
        TextFile.stringToFile((String)src, (String)path);
    }

    private String summaryTemplate() throws IOException {
        return TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, "template-comparison-set.html"}));
    }

    private String singleTemplate() throws IOException {
        return TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, "template-comparison.html"}));
    }

    private String cachedFetch(String id, String source) throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String local = Utilities.path((String[])new String[]{tmpDir, id});
        File f = new File(local);
        if (f.exists()) {
            return TextFile.fileToString((File)f);
        }
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        String result = TextFile.streamToString((InputStream)c.getInputStream());
        TextFile.stringToFile((String)result, (File)f);
        return result;
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        throw new Error("Not done yet");
    }

    @Override
    public boolean isResource(String typeSimple) {
        throw new Error("Not done yet");
    }

    @Override
    public boolean hasLinkFor(String name) {
        StructureDefinition sd = this.context.fetchTypeDefinition(name);
        return sd != null && sd.hasUserData("path");
    }

    @Override
    public String getLinkFor(String corePath, String name) {
        StructureDefinition sd = this.context.fetchTypeDefinition(name);
        return sd == null ? null : sd.getUserString("path");
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition def, ElementDefinition.ElementDefinitionBindingComponent binding, String path) throws FHIRException {
        return this.resolveBindingInt(def, binding.getValueSet(), binding.getDescription());
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition def, String url, String path) throws FHIRException {
        return this.resolveBindingInt(def, url, url);
    }

    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBindingInt(StructureDefinition def, String url, String desc) throws FHIRException {
        MetadataResource vs = null;
        if (url != null && url.startsWith("#")) {
            for (ValueSet t : this.valuesets) {
                if (!("#" + t.getId()).equals(url)) continue;
                vs = t;
                break;
            }
        }
        if (url != null && vs == null) {
            this.context.fetchResource(ValueSet.class, url);
        }
        ProfileUtilities.ProfileKnowledgeProvider.BindingResolution br = new ProfileUtilities.ProfileKnowledgeProvider.BindingResolution();
        if (vs != null) {
            br.display = vs.present();
            br.url = vs.getUserString("path");
        } else {
            br.display = desc;
        }
        return br;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url);
        return sd == null ? null : sd.getUserString("path");
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    @Override
    public String getLinkForUrl(String corePath, String s) {
        return null;
    }

    public int getErrCount() {
        int res = 0;
        for (ProfileComparison pc : this.comparisons) {
            res += pc.getErrorCount();
        }
        return res;
    }

    private class ExtensionUsage {
        private DefinitionNavigator defn;
        private int minSuperset;
        private int minSubset;
        private String maxSuperset;
        private String maxSubset;
        private boolean both = false;

        public ExtensionUsage(DefinitionNavigator defn, int min, String max) {
            this.defn = defn;
            this.minSubset = min;
            this.minSuperset = min;
            this.maxSubset = max;
            this.maxSuperset = max;
        }
    }

    public class ProfileComparison {
        private String id;
        private StructureDefinition left;
        private StructureDefinition right;
        private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        private StructureDefinition subset;
        private StructureDefinition superset;

        public String getId() {
            return this.id;
        }

        private String leftName() {
            return this.left.getName();
        }

        private String rightName() {
            return this.right.getName();
        }

        public StructureDefinition getLeft() {
            return this.left;
        }

        public StructureDefinition getRight() {
            return this.right;
        }

        public List<ValidationMessage> getMessages() {
            return this.messages;
        }

        public StructureDefinition getSubset() {
            return this.subset;
        }

        public StructureDefinition getSuperset() {
            return this.superset;
        }

        private boolean ruleEqual(String path, ElementDefinition ed, String vLeft, String vRight, String description, boolean nullOK) {
            if (vLeft == null && vRight == null && nullOK) {
                return true;
            }
            if (vLeft == null && vRight == null) {
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, description + " and not null (null/null)", ValidationMessage.IssueSeverity.ERROR));
                if (ed != null) {
                    ProfileComparer.this.status(ed, 3);
                }
            }
            if (vLeft == null || !vLeft.equals(vRight)) {
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, description + " (" + vLeft + "/" + vRight + ")", ValidationMessage.IssueSeverity.ERROR));
                if (ed != null) {
                    ProfileComparer.this.status(ed, 3);
                }
            }
            return true;
        }

        private boolean ruleCompares(ElementDefinition ed, Type vLeft, Type vRight, String path, int nullStatus) throws IOException {
            if (vLeft == null && vRight == null && nullStatus == 0) {
                return true;
            }
            if (vLeft == null && vRight == null) {
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Must be the same and not null (null/null)", ValidationMessage.IssueSeverity.ERROR));
                ProfileComparer.this.status(ed, 3);
            }
            if (vLeft == null && nullStatus == 1) {
                return true;
            }
            if (vRight == null && nullStatus == 1) {
                return true;
            }
            if (vLeft == null || vRight == null || !Base.compareDeep(vLeft, vRight, false)) {
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, "Must be the same (" + this.toString(vLeft) + "/" + this.toString(vRight) + ")", ValidationMessage.IssueSeverity.ERROR));
                ProfileComparer.this.status(ed, 3);
            }
            return true;
        }

        private boolean rule(ElementDefinition ed, boolean test, String path, String message) {
            if (!test) {
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, message, ValidationMessage.IssueSeverity.ERROR));
                ProfileComparer.this.status(ed, 3);
            }
            return test;
        }

        private boolean ruleEqual(ElementDefinition ed, boolean vLeft, boolean vRight, String path, String elementName) {
            if (vLeft != vRight) {
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.STRUCTURE, path, elementName + " must be the same (" + vLeft + "/" + vRight + ")", ValidationMessage.IssueSeverity.ERROR));
                ProfileComparer.this.status(ed, 3);
            }
            return true;
        }

        private String toString(Type val) throws IOException {
            if (val instanceof PrimitiveType) {
                return "\"" + ((PrimitiveType)val).getValueAsString() + "\"";
            }
            IParser jp = ProfileComparer.this.context.newJsonParser();
            return jp.composeString(val, "value");
        }

        public int getErrorCount() {
            int c = 0;
            for (ValidationMessage vm : this.messages) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR) continue;
                ++c;
            }
            return c;
        }

        public int getWarningCount() {
            int c = 0;
            for (ValidationMessage vm : this.messages) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.WARNING) continue;
                ++c;
            }
            return c;
        }

        public int getHintCount() {
            int c = 0;
            for (ValidationMessage vm : this.messages) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.INFORMATION) continue;
                ++c;
            }
            return c;
        }
    }
}

