/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.OrderedDistribution;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Statistic;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Evidence", profile="http://hl7.org/fhir/StructureDefinition/Evidence")
@ChildOrder(names={"url", "identifier", "version", "title", "status", "useContext", "date", "approvalDate", "lastReviewDate", "contributor", "relatedArtifact", "description", "assertion", "note", "referentGroup", "variableDefinition", "synthesisType", "studyType", "statistic", "distribution", "certainty"})
public class Evidence
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the summary", formalDefinition="A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="approvalDate", type={DateType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the summary was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the summary was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="contributor", type={Contributor.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact detail and role for contributor to summary", formalDefinition="Contact detail and role for contributor to summary.")
    protected List<Contributor> contributor;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link or citation to artifact associated with the summary", formalDefinition="Link or citation to artifact associated with the summary.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="assertion", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Declarative description of the Evidence", formalDefinition="Declarative description of the Evidence.")
    protected MarkdownType assertion;
    @Child(name="note", type={Annotation.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
    protected List<Annotation> note;
    @Child(name="referentGroup", type={}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Group being referenced", formalDefinition="Group being referenced.")
    protected EvidenceReferentGroupComponent referentGroup;
    @Child(name="variableDefinition", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Evidence variable", formalDefinition="Evidence variable.")
    protected List<EvidenceVariableDefinitionComponent> variableDefinition;
    @Child(name="synthesisType", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The particular type of synthesis if this is a synthesis summary", formalDefinition="The particular type of synthesis if this is a synthesis summary.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/synthesis-type")
    protected CodeableConcept synthesisType;
    @Child(name="studyType", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The type of study that produced this summary", formalDefinition="The type of study that produced this summary.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/study-type")
    protected CodeableConcept studyType;
    @Child(name="statistic", type={Statistic.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Values and parameters for a single statistic", formalDefinition="The statistic value(s).")
    protected List<Statistic> statistic;
    @Child(name="distribution", type={OrderedDistribution.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An ordered group of statistics", formalDefinition="Ordered distribution.")
    protected List<OrderedDistribution> distribution;
    @Child(name="certainty", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Level of certainty", formalDefinition="Level of certainty.")
    protected List<EvidenceCertaintyComponent> certainty;
    private static final long serialVersionUID = -1740041871L;
    @SearchParamDefinition(name="date", path="Evidence.date", description="The evidence publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Evidence.identifier", description="External identifier for the evidence", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="context-quantity", path="(Evidence.useContext.value as Quantity) | (Evidence.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the evidence", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-value", path="Evidence.useContext", description="A use context type and value assigned to the evidence", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context", path="(Evidence.useContext.value as CodeableConcept)", description="A use context assigned to the evidence", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="description", path="Evidence.description", description="The description of the evidence", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="Evidence.useContext.code", description="A type of use context assigned to the evidence", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="Evidence.title", description="The human-friendly name of the evidence", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="Evidence.version", description="The business version of the evidence", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="Evidence.url", description="The uri that identifies the evidence", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-type-quantity", path="Evidence.useContext", description="A use context type and quantity- or range-based value assigned to the evidence", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="Evidence.status", description="The current status of the evidence", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Evidence() {
    }

    public Evidence(Enumeration<Enumerations.PublicationStatus> status, EvidenceReferentGroupComponent referentGroup) {
        this.status = status;
        this.referentGroup = referentGroup;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Evidence setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Evidence setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Evidence setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Evidence addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Evidence setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Evidence setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Evidence setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Evidence setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Evidence setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Evidence setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public Evidence setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Evidence addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Evidence setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Evidence setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public Evidence setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public Evidence setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public Evidence setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public Evidence setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public List<Contributor> getContributor() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        return this.contributor;
    }

    public Evidence setContributor(List<Contributor> theContributor) {
        this.contributor = theContributor;
        return this;
    }

    public boolean hasContributor() {
        if (this.contributor == null) {
            return false;
        }
        for (Contributor item : this.contributor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Contributor addContributor() {
        Contributor t = new Contributor();
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return t;
    }

    public Evidence addContributor(Contributor t) {
        if (t == null) {
            return this;
        }
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return this;
    }

    public Contributor getContributorFirstRep() {
        if (this.getContributor().isEmpty()) {
            this.addContributor();
        }
        return this.getContributor().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public Evidence setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public Evidence addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Evidence setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Evidence setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public MarkdownType getAssertionElement() {
        if (this.assertion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.assertion");
            }
            if (Configuration.doAutoCreate()) {
                this.assertion = new MarkdownType();
            }
        }
        return this.assertion;
    }

    public boolean hasAssertionElement() {
        return this.assertion != null && !this.assertion.isEmpty();
    }

    public boolean hasAssertion() {
        return this.assertion != null && !this.assertion.isEmpty();
    }

    public Evidence setAssertionElement(MarkdownType value) {
        this.assertion = value;
        return this;
    }

    public String getAssertion() {
        return this.assertion == null ? null : (String)this.assertion.getValue();
    }

    public Evidence setAssertion(String value) {
        if (value == null) {
            this.assertion = null;
        } else {
            if (this.assertion == null) {
                this.assertion = new MarkdownType();
            }
            this.assertion.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Evidence setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Evidence addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public EvidenceReferentGroupComponent getReferentGroup() {
        if (this.referentGroup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.referentGroup");
            }
            if (Configuration.doAutoCreate()) {
                this.referentGroup = new EvidenceReferentGroupComponent();
            }
        }
        return this.referentGroup;
    }

    public boolean hasReferentGroup() {
        return this.referentGroup != null && !this.referentGroup.isEmpty();
    }

    public Evidence setReferentGroup(EvidenceReferentGroupComponent value) {
        this.referentGroup = value;
        return this;
    }

    public List<EvidenceVariableDefinitionComponent> getVariableDefinition() {
        if (this.variableDefinition == null) {
            this.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
        }
        return this.variableDefinition;
    }

    public Evidence setVariableDefinition(List<EvidenceVariableDefinitionComponent> theVariableDefinition) {
        this.variableDefinition = theVariableDefinition;
        return this;
    }

    public boolean hasVariableDefinition() {
        if (this.variableDefinition == null) {
            return false;
        }
        for (EvidenceVariableDefinitionComponent item : this.variableDefinition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceVariableDefinitionComponent addVariableDefinition() {
        EvidenceVariableDefinitionComponent t = new EvidenceVariableDefinitionComponent();
        if (this.variableDefinition == null) {
            this.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
        }
        this.variableDefinition.add(t);
        return t;
    }

    public Evidence addVariableDefinition(EvidenceVariableDefinitionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.variableDefinition == null) {
            this.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
        }
        this.variableDefinition.add(t);
        return this;
    }

    public EvidenceVariableDefinitionComponent getVariableDefinitionFirstRep() {
        if (this.getVariableDefinition().isEmpty()) {
            this.addVariableDefinition();
        }
        return this.getVariableDefinition().get(0);
    }

    public CodeableConcept getSynthesisType() {
        if (this.synthesisType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.synthesisType");
            }
            if (Configuration.doAutoCreate()) {
                this.synthesisType = new CodeableConcept();
            }
        }
        return this.synthesisType;
    }

    public boolean hasSynthesisType() {
        return this.synthesisType != null && !this.synthesisType.isEmpty();
    }

    public Evidence setSynthesisType(CodeableConcept value) {
        this.synthesisType = value;
        return this;
    }

    public CodeableConcept getStudyType() {
        if (this.studyType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.studyType");
            }
            if (Configuration.doAutoCreate()) {
                this.studyType = new CodeableConcept();
            }
        }
        return this.studyType;
    }

    public boolean hasStudyType() {
        return this.studyType != null && !this.studyType.isEmpty();
    }

    public Evidence setStudyType(CodeableConcept value) {
        this.studyType = value;
        return this;
    }

    public List<Statistic> getStatistic() {
        if (this.statistic == null) {
            this.statistic = new ArrayList<Statistic>();
        }
        return this.statistic;
    }

    public Evidence setStatistic(List<Statistic> theStatistic) {
        this.statistic = theStatistic;
        return this;
    }

    public boolean hasStatistic() {
        if (this.statistic == null) {
            return false;
        }
        for (Statistic item : this.statistic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Statistic addStatistic() {
        Statistic t = new Statistic();
        if (this.statistic == null) {
            this.statistic = new ArrayList<Statistic>();
        }
        this.statistic.add(t);
        return t;
    }

    public Evidence addStatistic(Statistic t) {
        if (t == null) {
            return this;
        }
        if (this.statistic == null) {
            this.statistic = new ArrayList<Statistic>();
        }
        this.statistic.add(t);
        return this;
    }

    public Statistic getStatisticFirstRep() {
        if (this.getStatistic().isEmpty()) {
            this.addStatistic();
        }
        return this.getStatistic().get(0);
    }

    public List<OrderedDistribution> getDistribution() {
        if (this.distribution == null) {
            this.distribution = new ArrayList<OrderedDistribution>();
        }
        return this.distribution;
    }

    public Evidence setDistribution(List<OrderedDistribution> theDistribution) {
        this.distribution = theDistribution;
        return this;
    }

    public boolean hasDistribution() {
        if (this.distribution == null) {
            return false;
        }
        for (OrderedDistribution item : this.distribution) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrderedDistribution addDistribution() {
        OrderedDistribution t = new OrderedDistribution();
        if (this.distribution == null) {
            this.distribution = new ArrayList<OrderedDistribution>();
        }
        this.distribution.add(t);
        return t;
    }

    public Evidence addDistribution(OrderedDistribution t) {
        if (t == null) {
            return this;
        }
        if (this.distribution == null) {
            this.distribution = new ArrayList<OrderedDistribution>();
        }
        this.distribution.add(t);
        return this;
    }

    public OrderedDistribution getDistributionFirstRep() {
        if (this.getDistribution().isEmpty()) {
            this.addDistribution();
        }
        return this.getDistribution().get(0);
    }

    public List<EvidenceCertaintyComponent> getCertainty() {
        if (this.certainty == null) {
            this.certainty = new ArrayList<EvidenceCertaintyComponent>();
        }
        return this.certainty;
    }

    public Evidence setCertainty(List<EvidenceCertaintyComponent> theCertainty) {
        this.certainty = theCertainty;
        return this;
    }

    public boolean hasCertainty() {
        if (this.certainty == null) {
            return false;
        }
        for (EvidenceCertaintyComponent item : this.certainty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceCertaintyComponent addCertainty() {
        EvidenceCertaintyComponent t = new EvidenceCertaintyComponent();
        if (this.certainty == null) {
            this.certainty = new ArrayList<EvidenceCertaintyComponent>();
        }
        this.certainty.add(t);
        return t;
    }

    public Evidence addCertainty(EvidenceCertaintyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.certainty == null) {
            this.certainty = new ArrayList<EvidenceCertaintyComponent>();
        }
        this.certainty.add(t);
        return this;
    }

    public EvidenceCertaintyComponent getCertaintyFirstRep() {
        if (this.getCertainty().isEmpty()) {
            this.addCertainty();
        }
        return this.getCertainty().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the summary.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the summary was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the summary changes.", 0, 1, this.date));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("contributor", "Contributor", "Contact detail and role for contributor to summary.", 0, Integer.MAX_VALUE, this.contributor));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Link or citation to artifact associated with the summary.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("assertion", "markdown", "Declarative description of the Evidence.", 0, 1, this.assertion));
        children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("referentGroup", "", "Group being referenced.", 0, 1, this.referentGroup));
        children.add(new Property("variableDefinition", "", "Evidence variable.", 0, Integer.MAX_VALUE, this.variableDefinition));
        children.add(new Property("synthesisType", "CodeableConcept", "The particular type of synthesis if this is a synthesis summary.", 0, 1, this.synthesisType));
        children.add(new Property("studyType", "CodeableConcept", "The type of study that produced this summary.", 0, 1, this.studyType));
        children.add(new Property("statistic", "Statistic", "The statistic value(s).", 0, Integer.MAX_VALUE, this.statistic));
        children.add(new Property("distribution", "OrderedDistribution", "Ordered distribution.", 0, Integer.MAX_VALUE, this.distribution));
        children.add(new Property("certainty", "", "Level of certainty.", 0, Integer.MAX_VALUE, this.certainty));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the summary.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the summary was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the summary changes.", 0, 1, this.date);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -1895276325: {
                return new Property("contributor", "Contributor", "Contact detail and role for contributor to summary.", 0, Integer.MAX_VALUE, this.contributor);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Link or citation to artifact associated with the summary.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence from a consumer's perspective.", 0, 1, this.description);
            }
            case 1314395906: {
                return new Property("assertion", "markdown", "Declarative description of the Evidence.", 0, 1, this.assertion);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case 2060829908: {
                return new Property("referentGroup", "", "Group being referenced.", 0, 1, this.referentGroup);
            }
            case -1807222545: {
                return new Property("variableDefinition", "", "Evidence variable.", 0, Integer.MAX_VALUE, this.variableDefinition);
            }
            case 672726254: {
                return new Property("synthesisType", "CodeableConcept", "The particular type of synthesis if this is a synthesis summary.", 0, 1, this.synthesisType);
            }
            case -1955265373: {
                return new Property("studyType", "CodeableConcept", "The type of study that produced this summary.", 0, 1, this.studyType);
            }
            case -2081261232: {
                return new Property("statistic", "Statistic", "The statistic value(s).", 0, Integer.MAX_VALUE, this.statistic);
            }
            case -1580708220: {
                return new Property("distribution", "OrderedDistribution", "Ordered distribution.", 0, Integer.MAX_VALUE, this.distribution);
            }
            case -1404142937: {
                return new Property("certainty", "", "Level of certainty.", 0, Integer.MAX_VALUE, this.certainty);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -1895276325: {
                return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case 1314395906: {
                Base[] baseArray;
                if (this.assertion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.assertion;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 2060829908: {
                Base[] baseArray;
                if (this.referentGroup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.referentGroup;
                }
                return baseArray;
            }
            case -1807222545: {
                return this.variableDefinition == null ? new Base[]{} : this.variableDefinition.toArray(new Base[this.variableDefinition.size()]);
            }
            case 672726254: {
                Base[] baseArray;
                if (this.synthesisType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.synthesisType;
                }
                return baseArray;
            }
            case -1955265373: {
                Base[] baseArray;
                if (this.studyType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.studyType;
                }
                return baseArray;
            }
            case -2081261232: {
                return this.statistic == null ? new Base[]{} : this.statistic.toArray(new Base[this.statistic.size()]);
            }
            case -1580708220: {
                return this.distribution == null ? new Base[]{} : this.distribution.toArray(new Base[this.distribution.size()]);
            }
            case -1404142937: {
                return this.certainty == null ? new Base[]{} : this.certainty.toArray(new Base[this.certainty.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -1895276325: {
                this.getContributor().add(this.castToContributor(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 1314395906: {
                this.assertion = this.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 2060829908: {
                this.referentGroup = (EvidenceReferentGroupComponent)((Object)value);
                return value;
            }
            case -1807222545: {
                this.getVariableDefinition().add((EvidenceVariableDefinitionComponent)((Object)value));
                return value;
            }
            case 672726254: {
                this.synthesisType = this.castToCodeableConcept(value);
                return value;
            }
            case -1955265373: {
                this.studyType = this.castToCodeableConcept(value);
                return value;
            }
            case -2081261232: {
                this.getStatistic().add(this.castToStatistic(value));
                return value;
            }
            case -1580708220: {
                this.getDistribution().add(this.castToOrderedDistribution(value));
                return value;
            }
            case -1404142937: {
                this.getCertainty().add((EvidenceCertaintyComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("contributor")) {
            this.getContributor().add(this.castToContributor(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("assertion")) {
            this.assertion = this.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("referentGroup")) {
            this.referentGroup = (EvidenceReferentGroupComponent)((Object)value);
        } else if (name.equals("variableDefinition")) {
            this.getVariableDefinition().add((EvidenceVariableDefinitionComponent)((Object)value));
        } else if (name.equals("synthesisType")) {
            this.synthesisType = this.castToCodeableConcept(value);
        } else if (name.equals("studyType")) {
            this.studyType = this.castToCodeableConcept(value);
        } else if (name.equals("statistic")) {
            this.getStatistic().add(this.castToStatistic(value));
        } else if (name.equals("distribution")) {
            this.getDistribution().add(this.castToOrderedDistribution(value));
        } else if (name.equals("certainty")) {
            this.getCertainty().add((EvidenceCertaintyComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -1895276325: {
                return this.addContributor();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 1314395906: {
                return this.getAssertionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case 2060829908: {
                return this.getReferentGroup();
            }
            case -1807222545: {
                return this.addVariableDefinition();
            }
            case 672726254: {
                return this.getSynthesisType();
            }
            case -1955265373: {
                return this.getStudyType();
            }
            case -2081261232: {
                return this.addStatistic();
            }
            case -1580708220: {
                return this.addDistribution();
            }
            case -1404142937: {
                return this.addCertainty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -1895276325: {
                return new String[]{"Contributor"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 1314395906: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 2060829908: {
                return new String[0];
            }
            case -1807222545: {
                return new String[0];
            }
            case 672726254: {
                return new String[]{"CodeableConcept"};
            }
            case -1955265373: {
                return new String[]{"CodeableConcept"};
            }
            case -2081261232: {
                return new String[]{"Statistic"};
            }
            case -1580708220: {
                return new String[]{"OrderedDistribution"};
            }
            case -1404142937: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.status");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.date");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.lastReviewDate");
        }
        if (name.equals("contributor")) {
            return this.addContributor();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.description");
        }
        if (name.equals("assertion")) {
            throw new FHIRException("Cannot call addChild on a primitive type Evidence.assertion");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("referentGroup")) {
            this.referentGroup = new EvidenceReferentGroupComponent();
            return this.referentGroup;
        }
        if (name.equals("variableDefinition")) {
            return this.addVariableDefinition();
        }
        if (name.equals("synthesisType")) {
            this.synthesisType = new CodeableConcept();
            return this.synthesisType;
        }
        if (name.equals("studyType")) {
            this.studyType = new CodeableConcept();
            return this.studyType;
        }
        if (name.equals("statistic")) {
            return this.addStatistic();
        }
        if (name.equals("distribution")) {
            return this.addDistribution();
        }
        if (name.equals("certainty")) {
            return this.addCertainty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Evidence";
    }

    @Override
    public Evidence copy() {
        Evidence dst = new Evidence();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Evidence dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.title = this.title == null ? null : this.title.copy();
        Type type = dst.status = this.status == null ? null : this.status.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        DateType dateType = dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        if (this.contributor != null) {
            dst.contributor = new ArrayList<Contributor>();
            for (Contributor contributor : this.contributor) {
                dst.contributor.add(contributor.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        MarkdownType markdownType = dst.assertion = this.assertion == null ? null : this.assertion.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        EvidenceReferentGroupComponent evidenceReferentGroupComponent = dst.referentGroup = this.referentGroup == null ? null : this.referentGroup.copy();
        if (this.variableDefinition != null) {
            dst.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
            for (EvidenceVariableDefinitionComponent evidenceVariableDefinitionComponent : this.variableDefinition) {
                dst.variableDefinition.add(evidenceVariableDefinitionComponent.copy());
            }
        }
        dst.synthesisType = this.synthesisType == null ? null : this.synthesisType.copy();
        CodeableConcept codeableConcept = dst.studyType = this.studyType == null ? null : this.studyType.copy();
        if (this.statistic != null) {
            dst.statistic = new ArrayList<Statistic>();
            for (Statistic statistic : this.statistic) {
                dst.statistic.add(statistic.copy());
            }
        }
        if (this.distribution != null) {
            dst.distribution = new ArrayList<OrderedDistribution>();
            for (OrderedDistribution orderedDistribution : this.distribution) {
                dst.distribution.add(orderedDistribution.copy());
            }
        }
        if (this.certainty != null) {
            dst.certainty = new ArrayList<EvidenceCertaintyComponent>();
            for (EvidenceCertaintyComponent evidenceCertaintyComponent : this.certainty) {
                dst.certainty.add(evidenceCertaintyComponent.copy());
            }
        }
    }

    protected Evidence typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Evidence)) {
            return false;
        }
        Evidence o = (Evidence)other_;
        return Evidence.compareDeep(this.identifier, o.identifier, true) && Evidence.compareDeep(this.approvalDate, o.approvalDate, true) && Evidence.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Evidence.compareDeep(this.contributor, o.contributor, true) && Evidence.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && Evidence.compareDeep(this.assertion, o.assertion, true) && Evidence.compareDeep(this.note, o.note, true) && Evidence.compareDeep(this.referentGroup, o.referentGroup, true) && Evidence.compareDeep(this.variableDefinition, o.variableDefinition, true) && Evidence.compareDeep(this.synthesisType, o.synthesisType, true) && Evidence.compareDeep(this.studyType, o.studyType, true) && Evidence.compareDeep(this.statistic, o.statistic, true) && Evidence.compareDeep(this.distribution, o.distribution, true) && Evidence.compareDeep(this.certainty, o.certainty, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Evidence)) {
            return false;
        }
        Evidence o = (Evidence)other_;
        return Evidence.compareValues(this.approvalDate, o.approvalDate, true) && Evidence.compareValues(this.lastReviewDate, o.lastReviewDate, true) && Evidence.compareValues(this.assertion, o.assertion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.approvalDate, this.lastReviewDate, this.contributor, this.relatedArtifact, this.assertion, this.note, this.referentGroup, this.variableDefinition, this.synthesisType, this.studyType, this.statistic, this.distribution, this.certainty});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Evidence;
    }

    @Block
    public static class EvidenceCertaintyCertaintySubcomponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of certainty subcomponent", formalDefinition="Textual description of certainty subcomponent.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual note of certainty subcomponent", formalDefinition="Textual note of certainty subcomponent.")
        protected Annotation note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-type")
        protected List<CodeableConcept> type;
        @Child(name="rating", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rating of certainty subcomponent", formalDefinition="Rating of certainty subcomponent.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-rating")
        protected List<CodeableConcept> rating;
        private static final long serialVersionUID = 2048436483L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyCertaintySubcomponentComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceCertaintyCertaintySubcomponentComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceCertaintyCertaintySubcomponentComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Annotation getNote() {
            if (this.note == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyCertaintySubcomponentComponent.note");
                }
                if (Configuration.doAutoCreate()) {
                    this.note = new Annotation();
                }
            }
            return this.note;
        }

        public boolean hasNote() {
            return this.note != null && !this.note.isEmpty();
        }

        public EvidenceCertaintyCertaintySubcomponentComponent setNote(Annotation value) {
            this.note = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public EvidenceCertaintyCertaintySubcomponentComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public EvidenceCertaintyCertaintySubcomponentComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<CodeableConcept> getRating() {
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            return this.rating;
        }

        public EvidenceCertaintyCertaintySubcomponentComponent setRating(List<CodeableConcept> theRating) {
            this.rating = theRating;
            return this;
        }

        public boolean hasRating() {
            if (this.rating == null) {
                return false;
            }
            for (CodeableConcept item : this.rating) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRating() {
            CodeableConcept t = new CodeableConcept();
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return t;
        }

        public EvidenceCertaintyCertaintySubcomponentComponent addRating(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return this;
        }

        public CodeableConcept getRatingFirstRep() {
            if (this.getRating().isEmpty()) {
                this.addRating();
            }
            return this.getRating().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "string", "Textual description of certainty subcomponent.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Textual note of certainty subcomponent.", 0, 1, this.note));
            children.add(new Property("type", "CodeableConcept", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("rating", "CodeableConcept", "Rating of certainty subcomponent.", 0, Integer.MAX_VALUE, this.rating));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "string", "Textual description of certainty subcomponent.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Textual note of certainty subcomponent.", 0, 1, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.type);
                }
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "Rating of certainty subcomponent.", 0, Integer.MAX_VALUE, this.rating);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    Base[] baseArray;
                    if (this.note == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.note;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -938102371: {
                    return this.rating == null ? new Base[]{} : this.rating.toArray(new Base[this.rating.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.note = this.castToAnnotation(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -938102371: {
                    this.getRating().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("note")) {
                this.note = this.castToAnnotation(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("rating")) {
                this.getRating().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.getNote();
                }
                case 3575610: {
                    return this.addType();
                }
                case -938102371: {
                    return this.addRating();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Evidence.description");
            }
            if (name.equals("note")) {
                this.note = new Annotation();
                return this.note;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("rating")) {
                return this.addRating();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceCertaintyCertaintySubcomponentComponent copy() {
            EvidenceCertaintyCertaintySubcomponentComponent dst = new EvidenceCertaintyCertaintySubcomponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceCertaintyCertaintySubcomponentComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            Annotation annotation = dst.note = this.note == null ? null : this.note.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            if (this.rating != null) {
                dst.rating = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.rating) {
                    dst.rating.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceCertaintyCertaintySubcomponentComponent)) {
                return false;
            }
            EvidenceCertaintyCertaintySubcomponentComponent o = (EvidenceCertaintyCertaintySubcomponentComponent)other_;
            return EvidenceCertaintyCertaintySubcomponentComponent.compareDeep(this.description, o.description, true) && EvidenceCertaintyCertaintySubcomponentComponent.compareDeep(this.note, o.note, true) && EvidenceCertaintyCertaintySubcomponentComponent.compareDeep(this.type, o.type, true) && EvidenceCertaintyCertaintySubcomponentComponent.compareDeep(this.rating, o.rating, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceCertaintyCertaintySubcomponentComponent)) {
                return false;
            }
            EvidenceCertaintyCertaintySubcomponentComponent o = (EvidenceCertaintyCertaintySubcomponentComponent)other_;
            return EvidenceCertaintyCertaintySubcomponentComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.rating});
        }

        @Override
        public String fhirType() {
            return "Evidence.certainty.certaintySubcomponent";
        }
    }

    @Block
    public static class EvidenceCertaintyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of certainty", formalDefinition="Textual description of certainty.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        protected Annotation note;
        @Child(name="rating", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rating of certainty", formalDefinition="Rating of certainty.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-rating")
        protected List<CodeableConcept> rating;
        @Child(name="certaintySubcomponent", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subcomponent of certainty", formalDefinition="Subcomponent of certainty.")
        protected List<EvidenceCertaintyCertaintySubcomponentComponent> certaintySubcomponent;
        private static final long serialVersionUID = -1718011695L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceCertaintyComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceCertaintyComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Annotation getNote() {
            if (this.note == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyComponent.note");
                }
                if (Configuration.doAutoCreate()) {
                    this.note = new Annotation();
                }
            }
            return this.note;
        }

        public boolean hasNote() {
            return this.note != null && !this.note.isEmpty();
        }

        public EvidenceCertaintyComponent setNote(Annotation value) {
            this.note = value;
            return this;
        }

        public List<CodeableConcept> getRating() {
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            return this.rating;
        }

        public EvidenceCertaintyComponent setRating(List<CodeableConcept> theRating) {
            this.rating = theRating;
            return this;
        }

        public boolean hasRating() {
            if (this.rating == null) {
                return false;
            }
            for (CodeableConcept item : this.rating) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRating() {
            CodeableConcept t = new CodeableConcept();
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return t;
        }

        public EvidenceCertaintyComponent addRating(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return this;
        }

        public CodeableConcept getRatingFirstRep() {
            if (this.getRating().isEmpty()) {
                this.addRating();
            }
            return this.getRating().get(0);
        }

        public List<EvidenceCertaintyCertaintySubcomponentComponent> getCertaintySubcomponent() {
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<EvidenceCertaintyCertaintySubcomponentComponent>();
            }
            return this.certaintySubcomponent;
        }

        public EvidenceCertaintyComponent setCertaintySubcomponent(List<EvidenceCertaintyCertaintySubcomponentComponent> theCertaintySubcomponent) {
            this.certaintySubcomponent = theCertaintySubcomponent;
            return this;
        }

        public boolean hasCertaintySubcomponent() {
            if (this.certaintySubcomponent == null) {
                return false;
            }
            for (EvidenceCertaintyCertaintySubcomponentComponent item : this.certaintySubcomponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceCertaintyCertaintySubcomponentComponent addCertaintySubcomponent() {
            EvidenceCertaintyCertaintySubcomponentComponent t = new EvidenceCertaintyCertaintySubcomponentComponent();
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<EvidenceCertaintyCertaintySubcomponentComponent>();
            }
            this.certaintySubcomponent.add(t);
            return t;
        }

        public EvidenceCertaintyComponent addCertaintySubcomponent(EvidenceCertaintyCertaintySubcomponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<EvidenceCertaintyCertaintySubcomponentComponent>();
            }
            this.certaintySubcomponent.add(t);
            return this;
        }

        public EvidenceCertaintyCertaintySubcomponentComponent getCertaintySubcomponentFirstRep() {
            if (this.getCertaintySubcomponent().isEmpty()) {
                this.addCertaintySubcomponent();
            }
            return this.getCertaintySubcomponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "string", "Textual description of certainty.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, 1, this.note));
            children.add(new Property("rating", "CodeableConcept", "Rating of certainty.", 0, Integer.MAX_VALUE, this.rating));
            children.add(new Property("certaintySubcomponent", "", "Subcomponent of certainty.", 0, Integer.MAX_VALUE, this.certaintySubcomponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "string", "Textual description of certainty.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, 1, this.note);
                }
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "Rating of certainty.", 0, Integer.MAX_VALUE, this.rating);
                }
                case 1806398212: {
                    return new Property("certaintySubcomponent", "", "Subcomponent of certainty.", 0, Integer.MAX_VALUE, this.certaintySubcomponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    Base[] baseArray;
                    if (this.note == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.note;
                    }
                    return baseArray;
                }
                case -938102371: {
                    return this.rating == null ? new Base[]{} : this.rating.toArray(new Base[this.rating.size()]);
                }
                case 1806398212: {
                    return this.certaintySubcomponent == null ? new Base[]{} : this.certaintySubcomponent.toArray(new Base[this.certaintySubcomponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.note = this.castToAnnotation(value);
                    return value;
                }
                case -938102371: {
                    this.getRating().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1806398212: {
                    this.getCertaintySubcomponent().add((EvidenceCertaintyCertaintySubcomponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("note")) {
                this.note = this.castToAnnotation(value);
            } else if (name.equals("rating")) {
                this.getRating().add(this.castToCodeableConcept(value));
            } else if (name.equals("certaintySubcomponent")) {
                this.getCertaintySubcomponent().add((EvidenceCertaintyCertaintySubcomponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.getNote();
                }
                case -938102371: {
                    return this.addRating();
                }
                case 1806398212: {
                    return this.addCertaintySubcomponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
                case 1806398212: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Evidence.description");
            }
            if (name.equals("note")) {
                this.note = new Annotation();
                return this.note;
            }
            if (name.equals("rating")) {
                return this.addRating();
            }
            if (name.equals("certaintySubcomponent")) {
                return this.addCertaintySubcomponent();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceCertaintyComponent copy() {
            EvidenceCertaintyComponent dst = new EvidenceCertaintyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceCertaintyComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            Annotation annotation = dst.note = this.note == null ? null : this.note.copy();
            if (this.rating != null) {
                dst.rating = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.rating) {
                    dst.rating.add(codeableConcept.copy());
                }
            }
            if (this.certaintySubcomponent != null) {
                dst.certaintySubcomponent = new ArrayList<EvidenceCertaintyCertaintySubcomponentComponent>();
                for (EvidenceCertaintyCertaintySubcomponentComponent evidenceCertaintyCertaintySubcomponentComponent : this.certaintySubcomponent) {
                    dst.certaintySubcomponent.add(evidenceCertaintyCertaintySubcomponentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceCertaintyComponent)) {
                return false;
            }
            EvidenceCertaintyComponent o = (EvidenceCertaintyComponent)other_;
            return EvidenceCertaintyComponent.compareDeep(this.description, o.description, true) && EvidenceCertaintyComponent.compareDeep(this.note, o.note, true) && EvidenceCertaintyComponent.compareDeep(this.rating, o.rating, true) && EvidenceCertaintyComponent.compareDeep(this.certaintySubcomponent, o.certaintySubcomponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceCertaintyComponent)) {
                return false;
            }
            EvidenceCertaintyComponent o = (EvidenceCertaintyComponent)other_;
            return EvidenceCertaintyComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.rating, this.certaintySubcomponent});
        }

        @Override
        public String fhirType() {
            return "Evidence.certainty";
        }
    }

    @Block
    public static class EvidenceVariableDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the variable", formalDefinition="Description of the variable.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        protected List<Annotation> note;
        @Child(name="variableRole", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="exposure | referenceExposure | measuredVariable | confounder", formalDefinition="exposure | referenceExposure | measuredVariable | confounder.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-role")
        protected CodeableConcept variableRole;
        @Child(name="actualDefinition", type={EvidenceVariable.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Definition of the actual variable related to the statistic(s)", formalDefinition="Definition of the actual variable related to the statistic(s).")
        protected Reference actualDefinition;
        @Child(name="intendedDefinition", type={EvidenceVariable.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of the intended variable related to the Evidence", formalDefinition="Definition of the intended variable related to the Evidence.")
        protected Reference intendedDefinition;
        @Child(name="directnessMatch", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="low | moderate | high | exact", formalDefinition="Indication of quality of match between intended variable to actual variable.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/directness")
        protected CodeableConcept directnessMatch;
        private static final long serialVersionUID = -1887907534L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceVariableDefinitionComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceVariableDefinitionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceVariableDefinitionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getVariableRole() {
            if (this.variableRole == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.variableRole");
                }
                if (Configuration.doAutoCreate()) {
                    this.variableRole = new CodeableConcept();
                }
            }
            return this.variableRole;
        }

        public boolean hasVariableRole() {
            return this.variableRole != null && !this.variableRole.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setVariableRole(CodeableConcept value) {
            this.variableRole = value;
            return this;
        }

        public Reference getActualDefinition() {
            if (this.actualDefinition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.actualDefinition");
                }
                if (Configuration.doAutoCreate()) {
                    this.actualDefinition = new Reference();
                }
            }
            return this.actualDefinition;
        }

        public boolean hasActualDefinition() {
            return this.actualDefinition != null && !this.actualDefinition.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setActualDefinition(Reference value) {
            this.actualDefinition = value;
            return this;
        }

        public Reference getIntendedDefinition() {
            if (this.intendedDefinition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.intendedDefinition");
                }
                if (Configuration.doAutoCreate()) {
                    this.intendedDefinition = new Reference();
                }
            }
            return this.intendedDefinition;
        }

        public boolean hasIntendedDefinition() {
            return this.intendedDefinition != null && !this.intendedDefinition.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setIntendedDefinition(Reference value) {
            this.intendedDefinition = value;
            return this;
        }

        public CodeableConcept getDirectnessMatch() {
            if (this.directnessMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.directnessMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.directnessMatch = new CodeableConcept();
                }
            }
            return this.directnessMatch;
        }

        public boolean hasDirectnessMatch() {
            return this.directnessMatch != null && !this.directnessMatch.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setDirectnessMatch(CodeableConcept value) {
            this.directnessMatch = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "Description of the variable.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("variableRole", "CodeableConcept", "exposure | referenceExposure | measuredVariable | confounder.", 0, 1, this.variableRole));
            children.add(new Property("actualDefinition", "Reference(EvidenceVariable)", "Definition of the actual variable related to the statistic(s).", 0, 1, this.actualDefinition));
            children.add(new Property("intendedDefinition", "Reference(EvidenceVariable)", "Definition of the intended variable related to the Evidence.", 0, 1, this.intendedDefinition));
            children.add(new Property("directnessMatch", "CodeableConcept", "Indication of quality of match between intended variable to actual variable.", 0, 1, this.directnessMatch));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "Description of the variable.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
                }
                case -372889326: {
                    return new Property("variableRole", "CodeableConcept", "exposure | referenceExposure | measuredVariable | confounder.", 0, 1, this.variableRole);
                }
                case -2019122815: {
                    return new Property("actualDefinition", "Reference(EvidenceVariable)", "Definition of the actual variable related to the statistic(s).", 0, 1, this.actualDefinition);
                }
                case -1749096482: {
                    return new Property("intendedDefinition", "Reference(EvidenceVariable)", "Definition of the intended variable related to the Evidence.", 0, 1, this.intendedDefinition);
                }
                case -2144864283: {
                    return new Property("directnessMatch", "CodeableConcept", "Indication of quality of match between intended variable to actual variable.", 0, 1, this.directnessMatch);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -372889326: {
                    Base[] baseArray;
                    if (this.variableRole == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.variableRole;
                    }
                    return baseArray;
                }
                case -2019122815: {
                    Base[] baseArray;
                    if (this.actualDefinition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.actualDefinition;
                    }
                    return baseArray;
                }
                case -1749096482: {
                    Base[] baseArray;
                    if (this.intendedDefinition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.intendedDefinition;
                    }
                    return baseArray;
                }
                case -2144864283: {
                    Base[] baseArray;
                    if (this.directnessMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.directnessMatch;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
                case -372889326: {
                    this.variableRole = this.castToCodeableConcept(value);
                    return value;
                }
                case -2019122815: {
                    this.actualDefinition = this.castToReference(value);
                    return value;
                }
                case -1749096482: {
                    this.intendedDefinition = this.castToReference(value);
                    return value;
                }
                case -2144864283: {
                    this.directnessMatch = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = this.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else if (name.equals("variableRole")) {
                this.variableRole = this.castToCodeableConcept(value);
            } else if (name.equals("actualDefinition")) {
                this.actualDefinition = this.castToReference(value);
            } else if (name.equals("intendedDefinition")) {
                this.intendedDefinition = this.castToReference(value);
            } else if (name.equals("directnessMatch")) {
                this.directnessMatch = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -372889326: {
                    return this.getVariableRole();
                }
                case -2019122815: {
                    return this.getActualDefinition();
                }
                case -1749096482: {
                    return this.getIntendedDefinition();
                }
                case -2144864283: {
                    return this.getDirectnessMatch();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -372889326: {
                    return new String[]{"CodeableConcept"};
                }
                case -2019122815: {
                    return new String[]{"Reference"};
                }
                case -1749096482: {
                    return new String[]{"Reference"};
                }
                case -2144864283: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Evidence.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("variableRole")) {
                this.variableRole = new CodeableConcept();
                return this.variableRole;
            }
            if (name.equals("actualDefinition")) {
                this.actualDefinition = new Reference();
                return this.actualDefinition;
            }
            if (name.equals("intendedDefinition")) {
                this.intendedDefinition = new Reference();
                return this.intendedDefinition;
            }
            if (name.equals("directnessMatch")) {
                this.directnessMatch = new CodeableConcept();
                return this.directnessMatch;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableDefinitionComponent copy() {
            EvidenceVariableDefinitionComponent dst = new EvidenceVariableDefinitionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableDefinitionComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.variableRole = this.variableRole == null ? null : this.variableRole.copy();
            dst.actualDefinition = this.actualDefinition == null ? null : this.actualDefinition.copy();
            dst.intendedDefinition = this.intendedDefinition == null ? null : this.intendedDefinition.copy();
            dst.directnessMatch = this.directnessMatch == null ? null : this.directnessMatch.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableDefinitionComponent)) {
                return false;
            }
            EvidenceVariableDefinitionComponent o = (EvidenceVariableDefinitionComponent)other_;
            return EvidenceVariableDefinitionComponent.compareDeep(this.description, o.description, true) && EvidenceVariableDefinitionComponent.compareDeep(this.note, o.note, true) && EvidenceVariableDefinitionComponent.compareDeep(this.variableRole, o.variableRole, true) && EvidenceVariableDefinitionComponent.compareDeep(this.actualDefinition, o.actualDefinition, true) && EvidenceVariableDefinitionComponent.compareDeep(this.intendedDefinition, o.intendedDefinition, true) && EvidenceVariableDefinitionComponent.compareDeep(this.directnessMatch, o.directnessMatch, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableDefinitionComponent)) {
                return false;
            }
            EvidenceVariableDefinitionComponent o = (EvidenceVariableDefinitionComponent)other_;
            return EvidenceVariableDefinitionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.variableRole, this.actualDefinition, this.intendedDefinition, this.directnessMatch});
        }

        @Override
        public String fhirType() {
            return "Evidence.variableDefinition";
        }
    }

    @Block
    public static class EvidenceReferentGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of referent group", formalDefinition="Textual description of referent group.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        protected List<Annotation> note;
        @Child(name="evidenceSource", type={Group.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Various information categories of group", formalDefinition="Various information categories of group.")
        protected Reference evidenceSource;
        @Child(name="intendedGroup", type={Group.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Non-actual group that is a set of characteristics", formalDefinition="Non-actual group that is a set of characteristics.")
        protected Reference intendedGroup;
        @Child(name="directnessMatch", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="low | moderate | high | exact", formalDefinition="Indication of quality of match between intended group to actual group.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/directness")
        protected CodeableConcept directnessMatch;
        private static final long serialVersionUID = -444548956L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReferentGroupComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceReferentGroupComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceReferentGroupComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceReferentGroupComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceReferentGroupComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public Reference getEvidenceSource() {
            if (this.evidenceSource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReferentGroupComponent.evidenceSource");
                }
                if (Configuration.doAutoCreate()) {
                    this.evidenceSource = new Reference();
                }
            }
            return this.evidenceSource;
        }

        public boolean hasEvidenceSource() {
            return this.evidenceSource != null && !this.evidenceSource.isEmpty();
        }

        public EvidenceReferentGroupComponent setEvidenceSource(Reference value) {
            this.evidenceSource = value;
            return this;
        }

        public Reference getIntendedGroup() {
            if (this.intendedGroup == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReferentGroupComponent.intendedGroup");
                }
                if (Configuration.doAutoCreate()) {
                    this.intendedGroup = new Reference();
                }
            }
            return this.intendedGroup;
        }

        public boolean hasIntendedGroup() {
            return this.intendedGroup != null && !this.intendedGroup.isEmpty();
        }

        public EvidenceReferentGroupComponent setIntendedGroup(Reference value) {
            this.intendedGroup = value;
            return this;
        }

        public CodeableConcept getDirectnessMatch() {
            if (this.directnessMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReferentGroupComponent.directnessMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.directnessMatch = new CodeableConcept();
                }
            }
            return this.directnessMatch;
        }

        public boolean hasDirectnessMatch() {
            return this.directnessMatch != null && !this.directnessMatch.isEmpty();
        }

        public EvidenceReferentGroupComponent setDirectnessMatch(CodeableConcept value) {
            this.directnessMatch = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "Textual description of referent group.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("evidenceSource", "Reference(Group)", "Various information categories of group.", 0, 1, this.evidenceSource));
            children.add(new Property("intendedGroup", "Reference(Group)", "Non-actual group that is a set of characteristics.", 0, 1, this.intendedGroup));
            children.add(new Property("directnessMatch", "CodeableConcept", "Indication of quality of match between intended group to actual group.", 0, 1, this.directnessMatch));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "Textual description of referent group.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
                }
                case 324572498: {
                    return new Property("evidenceSource", "Reference(Group)", "Various information categories of group.", 0, 1, this.evidenceSource);
                }
                case -777873132: {
                    return new Property("intendedGroup", "Reference(Group)", "Non-actual group that is a set of characteristics.", 0, 1, this.intendedGroup);
                }
                case -2144864283: {
                    return new Property("directnessMatch", "CodeableConcept", "Indication of quality of match between intended group to actual group.", 0, 1, this.directnessMatch);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 324572498: {
                    Base[] baseArray;
                    if (this.evidenceSource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.evidenceSource;
                    }
                    return baseArray;
                }
                case -777873132: {
                    Base[] baseArray;
                    if (this.intendedGroup == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.intendedGroup;
                    }
                    return baseArray;
                }
                case -2144864283: {
                    Base[] baseArray;
                    if (this.directnessMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.directnessMatch;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
                case 324572498: {
                    this.evidenceSource = this.castToReference(value);
                    return value;
                }
                case -777873132: {
                    this.intendedGroup = this.castToReference(value);
                    return value;
                }
                case -2144864283: {
                    this.directnessMatch = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = this.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else if (name.equals("evidenceSource")) {
                this.evidenceSource = this.castToReference(value);
            } else if (name.equals("intendedGroup")) {
                this.intendedGroup = this.castToReference(value);
            } else if (name.equals("directnessMatch")) {
                this.directnessMatch = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 324572498: {
                    return this.getEvidenceSource();
                }
                case -777873132: {
                    return this.getIntendedGroup();
                }
                case -2144864283: {
                    return this.getDirectnessMatch();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 324572498: {
                    return new String[]{"Reference"};
                }
                case -777873132: {
                    return new String[]{"Reference"};
                }
                case -2144864283: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Evidence.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("evidenceSource")) {
                this.evidenceSource = new Reference();
                return this.evidenceSource;
            }
            if (name.equals("intendedGroup")) {
                this.intendedGroup = new Reference();
                return this.intendedGroup;
            }
            if (name.equals("directnessMatch")) {
                this.directnessMatch = new CodeableConcept();
                return this.directnessMatch;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceReferentGroupComponent copy() {
            EvidenceReferentGroupComponent dst = new EvidenceReferentGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceReferentGroupComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.evidenceSource = this.evidenceSource == null ? null : this.evidenceSource.copy();
            dst.intendedGroup = this.intendedGroup == null ? null : this.intendedGroup.copy();
            dst.directnessMatch = this.directnessMatch == null ? null : this.directnessMatch.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReferentGroupComponent)) {
                return false;
            }
            EvidenceReferentGroupComponent o = (EvidenceReferentGroupComponent)other_;
            return EvidenceReferentGroupComponent.compareDeep(this.description, o.description, true) && EvidenceReferentGroupComponent.compareDeep(this.note, o.note, true) && EvidenceReferentGroupComponent.compareDeep(this.evidenceSource, o.evidenceSource, true) && EvidenceReferentGroupComponent.compareDeep(this.intendedGroup, o.intendedGroup, true) && EvidenceReferentGroupComponent.compareDeep(this.directnessMatch, o.directnessMatch, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReferentGroupComponent)) {
                return false;
            }
            EvidenceReferentGroupComponent o = (EvidenceReferentGroupComponent)other_;
            return EvidenceReferentGroupComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.evidenceSource, this.intendedGroup, this.directnessMatch});
        }

        @Override
        public String fhirType() {
            return "Evidence.referentGroup";
        }
    }
}

