/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Ingredient", profile="http://hl7.org/fhir/StructureDefinition/Ingredient")
public class Ingredient
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier or code by which the ingredient can be referenced", formalDefinition="The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected Identifier identifier;
    @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Ingredient role e.g. Active ingredient, excipient", formalDefinition="Ingredient role e.g. Active ingredient, excipient.")
    protected CodeableConcept role;
    @Child(name="allergenicIndicator", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the ingredient is a known or suspected allergen", formalDefinition="If the ingredient is a known or suspected allergen.")
    protected BooleanType allergenicIndicator;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The organization that manufactures this ingredient", formalDefinition="The organization that manufactures this ingredient.")
    protected List<Reference> manufacturer;
    @Child(name="specifiedSubstance", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A specified substance that comprises this ingredient", formalDefinition="A specified substance that comprises this ingredient.")
    protected List<IngredientSpecifiedSubstanceComponent> specifiedSubstance;
    @Child(name="substance", type={}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The substance that comprises this ingredient", formalDefinition="The substance that comprises this ingredient.")
    protected IngredientSubstanceComponent substance;
    private static final long serialVersionUID = 1070468172L;
    @SearchParamDefinition(name="identifier", path="Ingredient.identifier", description="An identifier or code by which the ingredient can be referenced", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Ingredient() {
    }

    public Ingredient(CodeableConcept role) {
        this.role = role;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Ingredient setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getRole() {
        if (this.role == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.role");
            }
            if (Configuration.doAutoCreate()) {
                this.role = new CodeableConcept();
            }
        }
        return this.role;
    }

    public boolean hasRole() {
        return this.role != null && !this.role.isEmpty();
    }

    public Ingredient setRole(CodeableConcept value) {
        this.role = value;
        return this;
    }

    public BooleanType getAllergenicIndicatorElement() {
        if (this.allergenicIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.allergenicIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.allergenicIndicator = new BooleanType();
            }
        }
        return this.allergenicIndicator;
    }

    public boolean hasAllergenicIndicatorElement() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public boolean hasAllergenicIndicator() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public Ingredient setAllergenicIndicatorElement(BooleanType value) {
        this.allergenicIndicator = value;
        return this;
    }

    public boolean getAllergenicIndicator() {
        return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
    }

    public Ingredient setAllergenicIndicator(boolean value) {
        if (this.allergenicIndicator == null) {
            this.allergenicIndicator = new BooleanType();
        }
        this.allergenicIndicator.setValue((Object)value);
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public Ingredient setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public Ingredient addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<IngredientSpecifiedSubstanceComponent> getSpecifiedSubstance() {
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
        }
        return this.specifiedSubstance;
    }

    public Ingredient setSpecifiedSubstance(List<IngredientSpecifiedSubstanceComponent> theSpecifiedSubstance) {
        this.specifiedSubstance = theSpecifiedSubstance;
        return this;
    }

    public boolean hasSpecifiedSubstance() {
        if (this.specifiedSubstance == null) {
            return false;
        }
        for (IngredientSpecifiedSubstanceComponent item : this.specifiedSubstance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IngredientSpecifiedSubstanceComponent addSpecifiedSubstance() {
        IngredientSpecifiedSubstanceComponent t = new IngredientSpecifiedSubstanceComponent();
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
        }
        this.specifiedSubstance.add(t);
        return t;
    }

    public Ingredient addSpecifiedSubstance(IngredientSpecifiedSubstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
        }
        this.specifiedSubstance.add(t);
        return this;
    }

    public IngredientSpecifiedSubstanceComponent getSpecifiedSubstanceFirstRep() {
        if (this.getSpecifiedSubstance().isEmpty()) {
            this.addSpecifiedSubstance();
        }
        return this.getSpecifiedSubstance().get(0);
    }

    public IngredientSubstanceComponent getSubstance() {
        if (this.substance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.substance");
            }
            if (Configuration.doAutoCreate()) {
                this.substance = new IngredientSubstanceComponent();
            }
        }
        return this.substance;
    }

    public boolean hasSubstance() {
        return this.substance != null && !this.substance.isEmpty();
    }

    public Ingredient setSubstance(IngredientSubstanceComponent value) {
        this.substance = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier));
        children.add(new Property("role", "CodeableConcept", "Ingredient role e.g. Active ingredient, excipient.", 0, 1, this.role));
        children.add(new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen.", 0, 1, this.allergenicIndicator));
        children.add(new Property("manufacturer", "Reference(Organization)", "The organization that manufactures this ingredient.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("specifiedSubstance", "", "A specified substance that comprises this ingredient.", 0, Integer.MAX_VALUE, this.specifiedSubstance));
        children.add(new Property("substance", "", "The substance that comprises this ingredient.", 0, 1, this.substance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier);
            }
            case 3506294: {
                return new Property("role", "CodeableConcept", "Ingredient role e.g. Active ingredient, excipient.", 0, 1, this.role);
            }
            case 75406931: {
                return new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen.", 0, 1, this.allergenicIndicator);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "The organization that manufactures this ingredient.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -331477600: {
                return new Property("specifiedSubstance", "", "A specified substance that comprises this ingredient.", 0, Integer.MAX_VALUE, this.specifiedSubstance);
            }
            case 530040176: {
                return new Property("substance", "", "The substance that comprises this ingredient.", 0, 1, this.substance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3506294: {
                Base[] baseArray;
                if (this.role == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.role;
                }
                return baseArray;
            }
            case 75406931: {
                Base[] baseArray;
                if (this.allergenicIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.allergenicIndicator;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -331477600: {
                return this.specifiedSubstance == null ? new Base[]{} : this.specifiedSubstance.toArray(new Base[this.specifiedSubstance.size()]);
            }
            case 530040176: {
                Base[] baseArray;
                if (this.substance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.substance;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3506294: {
                this.role = this.castToCodeableConcept(value);
                return value;
            }
            case 75406931: {
                this.allergenicIndicator = this.castToBoolean(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(this.castToReference(value));
                return value;
            }
            case -331477600: {
                this.getSpecifiedSubstance().add((IngredientSpecifiedSubstanceComponent)value);
                return value;
            }
            case 530040176: {
                this.substance = (IngredientSubstanceComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("role")) {
            this.role = this.castToCodeableConcept(value);
        } else if (name.equals("allergenicIndicator")) {
            this.allergenicIndicator = this.castToBoolean(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(this.castToReference(value));
        } else if (name.equals("specifiedSubstance")) {
            this.getSpecifiedSubstance().add((IngredientSpecifiedSubstanceComponent)value);
        } else if (name.equals("substance")) {
            this.substance = (IngredientSubstanceComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3506294: {
                return this.getRole();
            }
            case 75406931: {
                return this.getAllergenicIndicatorElement();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -331477600: {
                return this.addSpecifiedSubstance();
            }
            case 530040176: {
                return this.getSubstance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3506294: {
                return new String[]{"CodeableConcept"};
            }
            case 75406931: {
                return new String[]{"boolean"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -331477600: {
                return new String[0];
            }
            case 530040176: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("role")) {
            this.role = new CodeableConcept();
            return this.role;
        }
        if (name.equals("allergenicIndicator")) {
            throw new FHIRException("Cannot call addChild on a primitive type Ingredient.allergenicIndicator");
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("specifiedSubstance")) {
            return this.addSpecifiedSubstance();
        }
        if (name.equals("substance")) {
            this.substance = new IngredientSubstanceComponent();
            return this.substance;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Ingredient";
    }

    @Override
    public Ingredient copy() {
        Ingredient dst = new Ingredient();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Ingredient dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.role = this.role == null ? null : this.role.copy();
        BooleanType booleanType = dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.specifiedSubstance != null) {
            dst.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
            for (IngredientSpecifiedSubstanceComponent ingredientSpecifiedSubstanceComponent : this.specifiedSubstance) {
                dst.specifiedSubstance.add(ingredientSpecifiedSubstanceComponent.copy());
            }
        }
        dst.substance = this.substance == null ? null : this.substance.copy();
    }

    protected Ingredient typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Ingredient)) {
            return false;
        }
        Ingredient o = (Ingredient)other_;
        return Ingredient.compareDeep(this.identifier, o.identifier, true) && Ingredient.compareDeep(this.role, o.role, true) && Ingredient.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true) && Ingredient.compareDeep(this.manufacturer, o.manufacturer, true) && Ingredient.compareDeep(this.specifiedSubstance, o.specifiedSubstance, true) && Ingredient.compareDeep(this.substance, o.substance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Ingredient)) {
            return false;
        }
        Ingredient o = (Ingredient)other_;
        return Ingredient.compareValues(this.allergenicIndicator, o.allergenicIndicator, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.role, this.allergenicIndicator, this.manufacturer, this.specifiedSubstance, this.substance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Ingredient;
    }

    @Block
    public static class IngredientSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class, SubstanceDefinition.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code that represents the ingredient substance", formalDefinition="A code that represents the ingredient substance.")
        protected Type code;
        @Child(name="strength", type={IngredientSpecifiedSubstanceStrengthComponent.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product", formalDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.")
        protected List<IngredientSpecifiedSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = -2025953377L;

        public IngredientSubstanceComponent() {
        }

        public IngredientSubstanceComponent(Type code) {
            this.code = code;
        }

        public Type getCode() {
            return this.code;
        }

        public CodeableConcept getCodeCodeableConcept() throws FHIRException {
            if (this.code == null) {
                this.code = new CodeableConcept();
            }
            if (!(this.code instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.code.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.code;
        }

        public boolean hasCodeCodeableConcept() {
            return this != null && this.code instanceof CodeableConcept;
        }

        public Reference getCodeReference() throws FHIRException {
            if (this.code == null) {
                this.code = new Reference();
            }
            if (!(this.code instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.code.getClass().getName() + " was encountered");
            }
            return (Reference)this.code;
        }

        public boolean hasCodeReference() {
            return this != null && this.code instanceof Reference;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public IngredientSubstanceComponent setCode(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Ingredient.substance.code[x]: " + value.fhirType());
            }
            this.code = value;
            return this;
        }

        public List<IngredientSpecifiedSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public IngredientSubstanceComponent setStrength(List<IngredientSpecifiedSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (IngredientSpecifiedSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSpecifiedSubstanceStrengthComponent addStrength() {
            IngredientSpecifiedSubstanceStrengthComponent t = new IngredientSpecifiedSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public IngredientSubstanceComponent addStrength(IngredientSpecifiedSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public IngredientSpecifiedSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "A code that represents the ingredient substance.", 0, 1, this.code));
            children.add(new Property("strength", "@Ingredient.specifiedSubstance.strength", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 941839219: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "A code that represents the ingredient substance.", 0, 1, this.code);
                }
                case 3059181: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "A code that represents the ingredient substance.", 0, 1, this.code);
                }
                case 4899316: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "A code that represents the ingredient substance.", 0, 1, this.code);
                }
                case 1565461470: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "A code that represents the ingredient substance.", 0, 1, this.code);
                }
                case 1791316033: {
                    return new Property("strength", "@Ingredient.specifiedSubstance.strength", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToType(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((IngredientSpecifiedSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code[x]")) {
                this.code = this.castToType(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((IngredientSpecifiedSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 941839219: {
                    return this.getCode();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 1791316033: {
                    return new String[]{"@Ingredient.specifiedSubstance.strength"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("codeCodeableConcept")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("codeReference")) {
                this.code = new Reference();
                return this.code;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceComponent copy() {
            IngredientSubstanceComponent dst = new IngredientSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceComponent dst) {
            super.copyValues(dst);
            Type type = dst.code = this.code == null ? null : this.code.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
                for (IngredientSpecifiedSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceComponent)) {
                return false;
            }
            IngredientSubstanceComponent o = (IngredientSubstanceComponent)other_;
            return IngredientSubstanceComponent.compareDeep(this.code, o.code, true) && IngredientSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceComponent)) {
                return false;
            }
            IngredientSubstanceComponent o = (IngredientSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.strength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance";
        }
    }

    @Block
    public static class IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class, SubstanceDefinition.class, Substance.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Relevant reference substance", formalDefinition="Relevant reference substance.")
        protected Type substance;
        @Child(name="strength", type={Ratio.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected Ratio strength;
        @Child(name="strengthHighLimit", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance, upper limit", formalDefinition="Strength expressed in terms of a reference substance, upper limit.")
        protected Ratio strengthHighLimit;
        @Child(name="measurementPoint", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For when strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The country or countries for which the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        protected List<CodeableConcept> country;
        private static final long serialVersionUID = -1892265771L;

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent() {
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(Ratio strength) {
            this.strength = strength;
        }

        public Type getSubstance() {
            return this.substance;
        }

        public CodeableConcept getSubstanceCodeableConcept() throws FHIRException {
            if (this.substance == null) {
                this.substance = new CodeableConcept();
            }
            if (!(this.substance instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.substance.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.substance;
        }

        public boolean hasSubstanceCodeableConcept() {
            return this != null && this.substance instanceof CodeableConcept;
        }

        public Reference getSubstanceReference() throws FHIRException {
            if (this.substance == null) {
                this.substance = new Reference();
            }
            if (!(this.substance instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.substance.getClass().getName() + " was encountered");
            }
            return (Reference)this.substance;
        }

        public boolean hasSubstanceReference() {
            return this != null && this.substance instanceof Reference;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setSubstance(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Ingredient.specifiedSubstance.strength.referenceStrength.substance[x]: " + value.fhirType());
            }
            this.substance = value;
            return this;
        }

        public Ratio getStrength() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Ratio();
                }
            }
            return this.strength;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setStrength(Ratio value) {
            this.strength = value;
            return this;
        }

        public Ratio getStrengthHighLimit() {
            if (this.strengthHighLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.strengthHighLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.strengthHighLimit = new Ratio();
                }
            }
            return this.strengthHighLimit;
        }

        public boolean hasStrengthHighLimit() {
            return this.strengthHighLimit != null && !this.strengthHighLimit.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setStrengthHighLimit(Ratio value) {
            this.strengthHighLimit = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance));
            children.add(new Property("strength", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strength));
            children.add(new Property("strengthHighLimit", "Ratio", "Strength expressed in terms of a reference substance, upper limit.", 0, 1, this.strengthHighLimit));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2127194384: {
                    return new Property("substance[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance);
                }
                case 530040176: {
                    return new Property("substance[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance);
                }
                case -1974119407: {
                    return new Property("substance[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance);
                }
                case 516208571: {
                    return new Property("substance[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance);
                }
                case 1791316033: {
                    return new Property("strength", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case 703544312: {
                    return new Property("strengthHighLimit", "Ratio", "Strength expressed in terms of a reference substance, upper limit.", 0, 1, this.strengthHighLimit);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.strength;
                    }
                    return baseArray;
                }
                case 703544312: {
                    Base[] baseArray;
                    if (this.strengthHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strengthHighLimit;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToType(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = this.castToRatio(value);
                    return value;
                }
                case 703544312: {
                    this.strengthHighLimit = this.castToRatio(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = this.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance[x]")) {
                this.substance = this.castToType(value);
            } else if (name.equals("strength")) {
                this.strength = this.castToRatio(value);
            } else if (name.equals("strengthHighLimit")) {
                this.strengthHighLimit = this.castToRatio(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = this.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2127194384: {
                    return this.getSubstance();
                }
                case 530040176: {
                    return this.getSubstance();
                }
                case 1791316033: {
                    return this.getStrength();
                }
                case 703544312: {
                    return this.getStrengthHighLimit();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 1791316033: {
                    return new String[]{"Ratio"};
                }
                case 703544312: {
                    return new String[]{"Ratio"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substanceCodeableConcept")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("substanceReference")) {
                this.substance = new Reference();
                return this.substance;
            }
            if (name.equals("strength")) {
                this.strength = new Ratio();
                return this.strength;
            }
            if (name.equals("strengthHighLimit")) {
                this.strengthHighLimit = new Ratio();
                return this.strengthHighLimit;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type Ingredient.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent copy() {
            IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent dst = new IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.strengthHighLimit = this.strengthHighLimit == null ? null : this.strengthHighLimit.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.country) {
                    dst.country.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent o = (IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)other_;
            return IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.substance, o.substance, true) && IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strength, o.strength, true) && IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strengthHighLimit, o.strengthHighLimit, true) && IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareDeep(this.country, o.country, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent o = (IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)other_;
            return IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substance, this.strength, this.strengthHighLimit, this.measurementPoint, this.country});
        }

        @Override
        public String fhirType() {
            return "Ingredient.specifiedSubstance.strength.referenceStrength";
        }
    }

    @Block
    public static class IngredientSpecifiedSubstanceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="presentation", type={Ratio.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item", formalDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.")
        protected Ratio presentation;
        @Child(name="presentationHighLimit", type={Ratio.class}, order=2, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="An upper limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the high limit, with the presentation attribute becoming the lower limit", formalDefinition="An upper limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the high limit, with the presentation attribute becoming the lower limit.")
        protected Ratio presentationHighLimit;
        @Child(name="concentration", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The strength per unitary volume (or mass)", formalDefinition="The strength per unitary volume (or mass).")
        protected Ratio concentration;
        @Child(name="concentrationHighLimit", type={Ratio.class}, order=4, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit", formalDefinition="An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.")
        protected Ratio concentrationHighLimit;
        @Child(name="measurementPoint", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For when strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The country or countries for which the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        protected List<CodeableConcept> country;
        @Child(name="referenceStrength", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected List<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent> referenceStrength;
        private static final long serialVersionUID = 790266823L;

        public IngredientSpecifiedSubstanceStrengthComponent() {
        }

        public IngredientSpecifiedSubstanceStrengthComponent(Ratio presentation) {
            this.presentation = presentation;
        }

        public Ratio getPresentation() {
            if (this.presentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthComponent.presentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.presentation = new Ratio();
                }
            }
            return this.presentation;
        }

        public boolean hasPresentation() {
            return this.presentation != null && !this.presentation.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthComponent setPresentation(Ratio value) {
            this.presentation = value;
            return this;
        }

        public Ratio getPresentationHighLimit() {
            if (this.presentationHighLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthComponent.presentationHighLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.presentationHighLimit = new Ratio();
                }
            }
            return this.presentationHighLimit;
        }

        public boolean hasPresentationHighLimit() {
            return this.presentationHighLimit != null && !this.presentationHighLimit.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthComponent setPresentationHighLimit(Ratio value) {
            this.presentationHighLimit = value;
            return this;
        }

        public Ratio getConcentration() {
            if (this.concentration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthComponent.concentration");
                }
                if (Configuration.doAutoCreate()) {
                    this.concentration = new Ratio();
                }
            }
            return this.concentration;
        }

        public boolean hasConcentration() {
            return this.concentration != null && !this.concentration.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthComponent setConcentration(Ratio value) {
            this.concentration = value;
            return this;
        }

        public Ratio getConcentrationHighLimit() {
            if (this.concentrationHighLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthComponent.concentrationHighLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.concentrationHighLimit = new Ratio();
                }
            }
            return this.concentrationHighLimit;
        }

        public boolean hasConcentrationHighLimit() {
            return this.concentrationHighLimit != null && !this.concentrationHighLimit.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthComponent setConcentrationHighLimit(Ratio value) {
            this.concentrationHighLimit = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public IngredientSpecifiedSubstanceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public IngredientSpecifiedSubstanceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public IngredientSpecifiedSubstanceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public IngredientSpecifiedSubstanceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        public List<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent> getReferenceStrength() {
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
            }
            return this.referenceStrength;
        }

        public IngredientSpecifiedSubstanceStrengthComponent setReferenceStrength(List<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent> theReferenceStrength) {
            this.referenceStrength = theReferenceStrength;
            return this;
        }

        public boolean hasReferenceStrength() {
            if (this.referenceStrength == null) {
                return false;
            }
            for (IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent item : this.referenceStrength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent addReferenceStrength() {
            IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent t = new IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return t;
        }

        public IngredientSpecifiedSubstanceStrengthComponent addReferenceStrength(IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return this;
        }

        public IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent getReferenceStrengthFirstRep() {
            if (this.getReferenceStrength().isEmpty()) {
                this.addReferenceStrength();
            }
            return this.getReferenceStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("presentation", "Ratio", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation));
            children.add(new Property("presentationHighLimit", "Ratio", "An upper limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the high limit, with the presentation attribute becoming the lower limit.", 0, 1, this.presentationHighLimit));
            children.add(new Property("concentration", "Ratio", "The strength per unitary volume (or mass).", 0, 1, this.concentration));
            children.add(new Property("concentrationHighLimit", "Ratio", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
            children.add(new Property("referenceStrength", "", "Strength expressed in terms of a reference substance.", 0, Integer.MAX_VALUE, this.referenceStrength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 696975130: {
                    return new Property("presentation", "Ratio", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case 904802623: {
                    return new Property("presentationHighLimit", "Ratio", "An upper limit for the quantity of substance in the unit of presentation. For use when there is a range of strengths, this is the high limit, with the presentation attribute becoming the lower limit.", 0, 1, this.presentationHighLimit);
                }
                case -410557331: {
                    return new Property("concentration", "Ratio", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -1595729588: {
                    return new Property("concentrationHighLimit", "Ratio", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
                case 1943566508: {
                    return new Property("referenceStrength", "", "Strength expressed in terms of a reference substance.", 0, Integer.MAX_VALUE, this.referenceStrength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    Base[] baseArray;
                    if (this.presentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.presentation;
                    }
                    return baseArray;
                }
                case 904802623: {
                    Base[] baseArray;
                    if (this.presentationHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.presentationHighLimit;
                    }
                    return baseArray;
                }
                case -410557331: {
                    Base[] baseArray;
                    if (this.concentration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.concentration;
                    }
                    return baseArray;
                }
                case -1595729588: {
                    Base[] baseArray;
                    if (this.concentrationHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.concentrationHighLimit;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
                case 1943566508: {
                    return this.referenceStrength == null ? new Base[]{} : this.referenceStrength.toArray(new Base[this.referenceStrength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    this.presentation = this.castToRatio(value);
                    return value;
                }
                case 904802623: {
                    this.presentationHighLimit = this.castToRatio(value);
                    return value;
                }
                case -410557331: {
                    this.concentration = this.castToRatio(value);
                    return value;
                }
                case -1595729588: {
                    this.concentrationHighLimit = this.castToRatio(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = this.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1943566508: {
                    this.getReferenceStrength().add((IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("presentation")) {
                this.presentation = this.castToRatio(value);
            } else if (name.equals("presentationHighLimit")) {
                this.presentationHighLimit = this.castToRatio(value);
            } else if (name.equals("concentration")) {
                this.concentration = this.castToRatio(value);
            } else if (name.equals("concentrationHighLimit")) {
                this.concentrationHighLimit = this.castToRatio(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = this.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(this.castToCodeableConcept(value));
            } else if (name.equals("referenceStrength")) {
                this.getReferenceStrength().add((IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    return this.getPresentation();
                }
                case 904802623: {
                    return this.getPresentationHighLimit();
                }
                case -410557331: {
                    return this.getConcentration();
                }
                case -1595729588: {
                    return this.getConcentrationHighLimit();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
                case 1943566508: {
                    return this.addReferenceStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    return new String[]{"Ratio"};
                }
                case 904802623: {
                    return new String[]{"Ratio"};
                }
                case -410557331: {
                    return new String[]{"Ratio"};
                }
                case -1595729588: {
                    return new String[]{"Ratio"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case 1943566508: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("presentation")) {
                this.presentation = new Ratio();
                return this.presentation;
            }
            if (name.equals("presentationHighLimit")) {
                this.presentationHighLimit = new Ratio();
                return this.presentationHighLimit;
            }
            if (name.equals("concentration")) {
                this.concentration = new Ratio();
                return this.concentration;
            }
            if (name.equals("concentrationHighLimit")) {
                this.concentrationHighLimit = new Ratio();
                return this.concentrationHighLimit;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type Ingredient.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            if (name.equals("referenceStrength")) {
                return this.addReferenceStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSpecifiedSubstanceStrengthComponent copy() {
            IngredientSpecifiedSubstanceStrengthComponent dst = new IngredientSpecifiedSubstanceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSpecifiedSubstanceStrengthComponent dst) {
            super.copyValues(dst);
            dst.presentation = this.presentation == null ? null : this.presentation.copy();
            dst.presentationHighLimit = this.presentationHighLimit == null ? null : this.presentationHighLimit.copy();
            dst.concentration = this.concentration == null ? null : this.concentration.copy();
            dst.concentrationHighLimit = this.concentrationHighLimit == null ? null : this.concentrationHighLimit.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.country) {
                    dst.country.add(codeableConcept.copy());
                }
            }
            if (this.referenceStrength != null) {
                dst.referenceStrength = new ArrayList<IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent>();
                for (IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent ingredientSpecifiedSubstanceStrengthReferenceStrengthComponent : this.referenceStrength) {
                    dst.referenceStrength.add(ingredientSpecifiedSubstanceStrengthReferenceStrengthComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceStrengthComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceStrengthComponent o = (IngredientSpecifiedSubstanceStrengthComponent)other_;
            return IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.presentation, o.presentation, true) && IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.presentationHighLimit, o.presentationHighLimit, true) && IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.concentration, o.concentration, true) && IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.concentrationHighLimit, o.concentrationHighLimit, true) && IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.country, o.country, true) && IngredientSpecifiedSubstanceStrengthComponent.compareDeep(this.referenceStrength, o.referenceStrength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceStrengthComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceStrengthComponent o = (IngredientSpecifiedSubstanceStrengthComponent)other_;
            return IngredientSpecifiedSubstanceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.presentation, this.presentationHighLimit, this.concentration, this.concentrationHighLimit, this.measurementPoint, this.country, this.referenceStrength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.specifiedSubstance.strength";
        }
    }

    @Block
    public static class IngredientSpecifiedSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class, SubstanceDefinition.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance as a 'specified substance', implying extra substance related characteristics", formalDefinition="Substance as a 'specified substance', implying extra substance related characteristics.")
        protected Type code;
        @Child(name="group", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The group of specified substance, e.g. group 1 to 4", formalDefinition="The group of specified substance, e.g. group 1 to 4.")
        protected CodeableConcept group;
        @Child(name="confidentiality", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Confidentiality level of the specified substance as the ingredient", formalDefinition="Confidentiality level of the specified substance as the ingredient.")
        protected CodeableConcept confidentiality;
        @Child(name="strength", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product", formalDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.")
        protected List<IngredientSpecifiedSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = 762473586L;

        public IngredientSpecifiedSubstanceComponent() {
        }

        public IngredientSpecifiedSubstanceComponent(Type code, CodeableConcept group) {
            this.code = code;
            this.group = group;
        }

        public Type getCode() {
            return this.code;
        }

        public CodeableConcept getCodeCodeableConcept() throws FHIRException {
            if (this.code == null) {
                this.code = new CodeableConcept();
            }
            if (!(this.code instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.code.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.code;
        }

        public boolean hasCodeCodeableConcept() {
            return this != null && this.code instanceof CodeableConcept;
        }

        public Reference getCodeReference() throws FHIRException {
            if (this.code == null) {
                this.code = new Reference();
            }
            if (!(this.code instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.code.getClass().getName() + " was encountered");
            }
            return (Reference)this.code;
        }

        public boolean hasCodeReference() {
            return this != null && this.code instanceof Reference;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public IngredientSpecifiedSubstanceComponent setCode(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Ingredient.specifiedSubstance.code[x]: " + value.fhirType());
            }
            this.code = value;
            return this;
        }

        public CodeableConcept getGroup() {
            if (this.group == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceComponent.group");
                }
                if (Configuration.doAutoCreate()) {
                    this.group = new CodeableConcept();
                }
            }
            return this.group;
        }

        public boolean hasGroup() {
            return this.group != null && !this.group.isEmpty();
        }

        public IngredientSpecifiedSubstanceComponent setGroup(CodeableConcept value) {
            this.group = value;
            return this;
        }

        public CodeableConcept getConfidentiality() {
            if (this.confidentiality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceComponent.confidentiality");
                }
                if (Configuration.doAutoCreate()) {
                    this.confidentiality = new CodeableConcept();
                }
            }
            return this.confidentiality;
        }

        public boolean hasConfidentiality() {
            return this.confidentiality != null && !this.confidentiality.isEmpty();
        }

        public IngredientSpecifiedSubstanceComponent setConfidentiality(CodeableConcept value) {
            this.confidentiality = value;
            return this;
        }

        public List<IngredientSpecifiedSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public IngredientSpecifiedSubstanceComponent setStrength(List<IngredientSpecifiedSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (IngredientSpecifiedSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSpecifiedSubstanceStrengthComponent addStrength() {
            IngredientSpecifiedSubstanceStrengthComponent t = new IngredientSpecifiedSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public IngredientSpecifiedSubstanceComponent addStrength(IngredientSpecifiedSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public IngredientSpecifiedSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code));
            children.add(new Property("group", "CodeableConcept", "The group of specified substance, e.g. group 1 to 4.", 0, 1, this.group));
            children.add(new Property("confidentiality", "CodeableConcept", "Confidentiality level of the specified substance as the ingredient.", 0, 1, this.confidentiality));
            children.add(new Property("strength", "", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 941839219: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code);
                }
                case 3059181: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code);
                }
                case 4899316: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code);
                }
                case 1565461470: {
                    return new Property("code[x]", "CodeableConcept|Reference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code);
                }
                case 98629247: {
                    return new Property("group", "CodeableConcept", "The group of specified substance, e.g. group 1 to 4.", 0, 1, this.group);
                }
                case -1923018202: {
                    return new Property("confidentiality", "CodeableConcept", "Confidentiality level of the specified substance as the ingredient.", 0, 1, this.confidentiality);
                }
                case 1791316033: {
                    return new Property("strength", "", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 98629247: {
                    Base[] baseArray;
                    if (this.group == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.group;
                    }
                    return baseArray;
                }
                case -1923018202: {
                    Base[] baseArray;
                    if (this.confidentiality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.confidentiality;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToType(value);
                    return value;
                }
                case 98629247: {
                    this.group = this.castToCodeableConcept(value);
                    return value;
                }
                case -1923018202: {
                    this.confidentiality = this.castToCodeableConcept(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((IngredientSpecifiedSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code[x]")) {
                this.code = this.castToType(value);
            } else if (name.equals("group")) {
                this.group = this.castToCodeableConcept(value);
            } else if (name.equals("confidentiality")) {
                this.confidentiality = this.castToCodeableConcept(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((IngredientSpecifiedSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 941839219: {
                    return this.getCode();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 98629247: {
                    return this.getGroup();
                }
                case -1923018202: {
                    return this.getConfidentiality();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 98629247: {
                    return new String[]{"CodeableConcept"};
                }
                case -1923018202: {
                    return new String[]{"CodeableConcept"};
                }
                case 1791316033: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("codeCodeableConcept")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("codeReference")) {
                this.code = new Reference();
                return this.code;
            }
            if (name.equals("group")) {
                this.group = new CodeableConcept();
                return this.group;
            }
            if (name.equals("confidentiality")) {
                this.confidentiality = new CodeableConcept();
                return this.confidentiality;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSpecifiedSubstanceComponent copy() {
            IngredientSpecifiedSubstanceComponent dst = new IngredientSpecifiedSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSpecifiedSubstanceComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.group = this.group == null ? null : this.group.copy();
            CodeableConcept codeableConcept = dst.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<IngredientSpecifiedSubstanceStrengthComponent>();
                for (IngredientSpecifiedSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceComponent o = (IngredientSpecifiedSubstanceComponent)other_;
            return IngredientSpecifiedSubstanceComponent.compareDeep(this.code, o.code, true) && IngredientSpecifiedSubstanceComponent.compareDeep(this.group, o.group, true) && IngredientSpecifiedSubstanceComponent.compareDeep(this.confidentiality, o.confidentiality, true) && IngredientSpecifiedSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceComponent o = (IngredientSpecifiedSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.group, this.confidentiality, this.strength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.specifiedSubstance";
        }
    }
}

