/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MolecularSequence", profile="http://hl7.org/fhir/StructureDefinition/MolecularSequence")
public class MolecularSequence
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique ID for this particular sequence. This is a FHIR-defined id", formalDefinition="A unique identifier for this particular sequence instance. This is a FHIR-defined id.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="aa | dna | rna", formalDefinition="Amino Acid Sequence/ DNA Sequence / RNA Sequence.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/sequence-type")
    protected Enumeration<SequenceType> type;
    @Child(name="coordinateSystem", type={IntegerType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Base number of coordinate system (0 for 0-based numbering or coordinates, inclusive start, exclusive end, 1 for 1-based numbering, inclusive start, inclusive end)", formalDefinition="Whether the sequence is numbered starting at 0 (0-based numbering or coordinates, inclusive start, exclusive end) or starting at 1 (1-based numbering, inclusive start and inclusive end).")
    protected IntegerType coordinateSystem;
    @Child(name="patient", type={Patient.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what this is about", formalDefinition="The patient whose sequencing results are described by this resource.")
    protected Reference patient;
    @Child(name="specimen", type={Specimen.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specimen used for sequencing", formalDefinition="Specimen used for sequencing.")
    protected Reference specimen;
    @Child(name="device", type={Device.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The method for sequencing", formalDefinition="The method for sequencing, for example, chip information.")
    protected Reference device;
    @Child(name="performer", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who should be responsible for test result", formalDefinition="The organization or lab that should be responsible for this result.")
    protected Reference performer;
    @Child(name="quantity", type={Quantity.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The number of copies of the sequence of interest.  (RNASeq)", formalDefinition="The number of copies of the sequence of interest. (RNASeq).")
    protected Quantity quantity;
    @Child(name="referenceSeq", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A sequence used as reference", formalDefinition="A sequence that is used as a reference to describe variants that are present in a sequence analyzed.")
    protected MolecularSequenceReferenceSeqComponent referenceSeq;
    @Child(name="variant", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Variant in sequence", formalDefinition="The definition of variant here originates from Sequence ontology ([variant_of](http://www.sequenceontology.org/browser/current_svn/term/variant_of)). This element can represent amino acid or nucleic sequence change(including insertion,deletion,SNP,etc.)  It can represent some complex mutation or segment variation with the assist of CIGAR string.")
    protected List<MolecularSequenceVariantComponent> variant;
    @Child(name="observedSeq", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Sequence that was observed", formalDefinition="Sequence that was observed. It is the result marked by referenceSeq along with variant records on referenceSeq. This shall start from referenceSeq.windowStart and end by referenceSeq.windowEnd.")
    protected StringType observedSeq;
    @Child(name="quality", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An set of value as quality of sequence", formalDefinition="An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score ([SO:0001686](http://www.sequenceontology.org/browser/current_svn/term/SO:0001686)).")
    protected List<MolecularSequenceQualityComponent> quality;
    @Child(name="readCoverage", type={IntegerType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Average number of reads representing a given nucleotide in the reconstructed sequence", formalDefinition="Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.")
    protected IntegerType readCoverage;
    @Child(name="repository", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External repository which contains detailed report related with observedSeq in this resource", formalDefinition="Configurations of the external repository. The repository shall store target's observedSeq or records related with target's observedSeq.")
    protected List<MolecularSequenceRepositoryComponent> repository;
    @Child(name="pointer", type={MolecularSequence.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Pointer to next atomic sequence", formalDefinition="Pointer to next atomic sequence which at most contains one variant.")
    protected List<Reference> pointer;
    @Child(name="structureVariant", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Structural variant", formalDefinition="Information about chromosome structure variation.")
    protected List<MolecularSequenceStructureVariantComponent> structureVariant;
    private static final long serialVersionUID = -1100594126L;
    @SearchParamDefinition(name="identifier", path="MolecularSequence.identifier", description="The unique identity for a particular sequence", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="referenceseqid-variant-coordinate", path="MolecularSequence.variant", description="Search parameter by reference sequence and variant coordinate. This will refer to part of a locus or part of a gene where search region will be represented in 1-based system. Since the coordinateSystem can either be 0-based or 1-based, this search query will include the result of both coordinateSystem that contains the equivalent segment of the gene or whole genome sequence. For example, a search for sequence can be represented as `referenceSeqId-variant-coordinate=NC_000001.11$lt345$gt123`, this means it will search for the MolecularSequence resource with variants on NC_000001.11 and with position >123 and <345, where in 1-based system resource, all strings within region NC_000001.11:124-344 will be revealed, while in 0-based system resource, all strings within region NC_000001.11:123-344 will be revealed. You may want to check detail about 0-based v.s. 1-based above.", type="composite", compositeOf={"referenceseqid", "variant-start"})
    public static final String SP_REFERENCESEQID_VARIANT_COORDINATE = "referenceseqid-variant-coordinate";
    public static final CompositeClientParam<TokenClientParam, NumberClientParam> REFERENCESEQID_VARIANT_COORDINATE = new CompositeClientParam("referenceseqid-variant-coordinate");
    @SearchParamDefinition(name="chromosome", path="MolecularSequence.referenceSeq.chromosome", description="Chromosome number of the reference sequence", type="token")
    public static final String SP_CHROMOSOME = "chromosome";
    public static final TokenClientParam CHROMOSOME = new TokenClientParam("chromosome");
    @SearchParamDefinition(name="window-end", path="MolecularSequence.referenceSeq.windowEnd", description="End position (0-based exclusive, which menas the acid at this position will not be included, 1-based inclusive, which means the acid at this position will be included) of the reference sequence.", type="number")
    public static final String SP_WINDOW_END = "window-end";
    public static final NumberClientParam WINDOW_END = new NumberClientParam("window-end");
    @SearchParamDefinition(name="type", path="MolecularSequence.type", description="Amino Acid Sequence/ DNA Sequence / RNA Sequence", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="window-start", path="MolecularSequence.referenceSeq.windowStart", description="Start position (0-based inclusive, 1-based inclusive, that means the nucleic acid or amino acid at this position will be included) of the reference sequence.", type="number")
    public static final String SP_WINDOW_START = "window-start";
    public static final NumberClientParam WINDOW_START = new NumberClientParam("window-start");
    @SearchParamDefinition(name="variant-end", path="MolecularSequence.variant.end", description="End position (0-based exclusive, which menas the acid at this position will not be included, 1-based inclusive, which means the acid at this position will be included) of the variant.", type="number")
    public static final String SP_VARIANT_END = "variant-end";
    public static final NumberClientParam VARIANT_END = new NumberClientParam("variant-end");
    @SearchParamDefinition(name="chromosome-variant-coordinate", path="MolecularSequence.variant", description="Search parameter by chromosome and variant coordinate. This will refer to part of a locus or part of a gene where search region will be represented in 1-based system. Since the coordinateSystem can either be 0-based or 1-based, this search query will include the result of both coordinateSystem that contains the equivalent segment of the gene or whole genome sequence. For example, a search for sequence can be represented as `chromosome-variant-coordinate=1$lt345$gt123`, this means it will search for the MolecularSequence resource with variants on chromosome 1 and with position >123 and <345, where in 1-based system resource, all strings within region 1:124-344 will be revealed, while in 0-based system resource, all strings within region 1:123-344 will be revealed. You may want to check detail about 0-based v.s. 1-based above.", type="composite", compositeOf={"chromosome", "variant-start"})
    public static final String SP_CHROMOSOME_VARIANT_COORDINATE = "chromosome-variant-coordinate";
    public static final CompositeClientParam<TokenClientParam, NumberClientParam> CHROMOSOME_VARIANT_COORDINATE = new CompositeClientParam("chromosome-variant-coordinate");
    @SearchParamDefinition(name="patient", path="MolecularSequence.patient", description="The subject that the observation is about", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MolecularSequence:patient").toLocked();
    @SearchParamDefinition(name="variant-start", path="MolecularSequence.variant.start", description="Start position (0-based inclusive, 1-based inclusive, that means the nucleic acid or amino acid at this position will be included) of the variant.", type="number")
    public static final String SP_VARIANT_START = "variant-start";
    public static final NumberClientParam VARIANT_START = new NumberClientParam("variant-start");
    @SearchParamDefinition(name="chromosome-window-coordinate", path="MolecularSequence.referenceSeq", description="Search parameter by chromosome and window. This will refer to part of a locus or part of a gene where search region will be represented in 1-based system. Since the coordinateSystem can either be 0-based or 1-based, this search query will include the result of both coordinateSystem that contains the equivalent segment of the gene or whole genome sequence. For example, a search for sequence can be represented as `chromosome-window-coordinate=1$lt345$gt123`, this means it will search for the MolecularSequence resource with a window on chromosome 1 and with position >123 and <345, where in 1-based system resource, all strings within region 1:124-344 will be revealed, while in 0-based system resource, all strings within region 1:123-344 will be revealed. You may want to check detail about 0-based v.s. 1-based above.", type="composite", compositeOf={"chromosome", "window-start"})
    public static final String SP_CHROMOSOME_WINDOW_COORDINATE = "chromosome-window-coordinate";
    public static final CompositeClientParam<TokenClientParam, NumberClientParam> CHROMOSOME_WINDOW_COORDINATE = new CompositeClientParam("chromosome-window-coordinate");
    @SearchParamDefinition(name="referenceseqid-window-coordinate", path="MolecularSequence.referenceSeq", description="Search parameter by reference sequence and window. This will refer to part of a locus or part of a gene where search region will be represented in 1-based system. Since the coordinateSystem can either be 0-based or 1-based, this search query will include the result of both coordinateSystem that contains the equivalent segment of the gene or whole genome sequence. For example, a search for sequence can be represented as `referenceSeqId-window-coordinate=NC_000001.11$lt345$gt123`, this means it will search for the MolecularSequence resource with a window on NC_000001.11 and with position >123 and <345, where in 1-based system resource, all strings within region NC_000001.11:124-344 will be revealed, while in 0-based system resource, all strings within region NC_000001.11:123-344 will be revealed. You may want to check detail about 0-based v.s. 1-based above.", type="composite", compositeOf={"referenceseqid", "window-start"})
    public static final String SP_REFERENCESEQID_WINDOW_COORDINATE = "referenceseqid-window-coordinate";
    public static final CompositeClientParam<TokenClientParam, NumberClientParam> REFERENCESEQID_WINDOW_COORDINATE = new CompositeClientParam("referenceseqid-window-coordinate");
    @SearchParamDefinition(name="referenceseqid", path="MolecularSequence.referenceSeq.referenceSeqId", description="Reference Sequence of the sequence", type="token")
    public static final String SP_REFERENCESEQID = "referenceseqid";
    public static final TokenClientParam REFERENCESEQID = new TokenClientParam("referenceseqid");

    public MolecularSequence() {
    }

    public MolecularSequence(IntegerType coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MolecularSequence setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MolecularSequence addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<SequenceType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<SequenceType>(new SequenceTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MolecularSequence setTypeElement(Enumeration<SequenceType> value) {
        this.type = value;
        return this;
    }

    public SequenceType getType() {
        return this.type == null ? null : (SequenceType)((Object)this.type.getValue());
    }

    public MolecularSequence setType(SequenceType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<SequenceType>(new SequenceTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public IntegerType getCoordinateSystemElement() {
        if (this.coordinateSystem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.coordinateSystem");
            }
            if (Configuration.doAutoCreate()) {
                this.coordinateSystem = new IntegerType();
            }
        }
        return this.coordinateSystem;
    }

    public boolean hasCoordinateSystemElement() {
        return this.coordinateSystem != null && !this.coordinateSystem.isEmpty();
    }

    public boolean hasCoordinateSystem() {
        return this.coordinateSystem != null && !this.coordinateSystem.isEmpty();
    }

    public MolecularSequence setCoordinateSystemElement(IntegerType value) {
        this.coordinateSystem = value;
        return this;
    }

    public int getCoordinateSystem() {
        return this.coordinateSystem == null || this.coordinateSystem.isEmpty() ? 0 : (Integer)this.coordinateSystem.getValue();
    }

    public MolecularSequence setCoordinateSystem(int value) {
        if (this.coordinateSystem == null) {
            this.coordinateSystem = new IntegerType();
        }
        this.coordinateSystem.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public MolecularSequence setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getSpecimen() {
        if (this.specimen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimen = new Reference();
            }
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        return this.specimen != null && !this.specimen.isEmpty();
    }

    public MolecularSequence setSpecimen(Reference value) {
        this.specimen = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public MolecularSequence setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public MolecularSequence setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public MolecularSequence setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public MolecularSequenceReferenceSeqComponent getReferenceSeq() {
        if (this.referenceSeq == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.referenceSeq");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceSeq = new MolecularSequenceReferenceSeqComponent();
            }
        }
        return this.referenceSeq;
    }

    public boolean hasReferenceSeq() {
        return this.referenceSeq != null && !this.referenceSeq.isEmpty();
    }

    public MolecularSequence setReferenceSeq(MolecularSequenceReferenceSeqComponent value) {
        this.referenceSeq = value;
        return this;
    }

    public List<MolecularSequenceVariantComponent> getVariant() {
        if (this.variant == null) {
            this.variant = new ArrayList<MolecularSequenceVariantComponent>();
        }
        return this.variant;
    }

    public MolecularSequence setVariant(List<MolecularSequenceVariantComponent> theVariant) {
        this.variant = theVariant;
        return this;
    }

    public boolean hasVariant() {
        if (this.variant == null) {
            return false;
        }
        for (MolecularSequenceVariantComponent item : this.variant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MolecularSequenceVariantComponent addVariant() {
        MolecularSequenceVariantComponent t = new MolecularSequenceVariantComponent();
        if (this.variant == null) {
            this.variant = new ArrayList<MolecularSequenceVariantComponent>();
        }
        this.variant.add(t);
        return t;
    }

    public MolecularSequence addVariant(MolecularSequenceVariantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.variant == null) {
            this.variant = new ArrayList<MolecularSequenceVariantComponent>();
        }
        this.variant.add(t);
        return this;
    }

    public MolecularSequenceVariantComponent getVariantFirstRep() {
        if (this.getVariant().isEmpty()) {
            this.addVariant();
        }
        return this.getVariant().get(0);
    }

    public StringType getObservedSeqElement() {
        if (this.observedSeq == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.observedSeq");
            }
            if (Configuration.doAutoCreate()) {
                this.observedSeq = new StringType();
            }
        }
        return this.observedSeq;
    }

    public boolean hasObservedSeqElement() {
        return this.observedSeq != null && !this.observedSeq.isEmpty();
    }

    public boolean hasObservedSeq() {
        return this.observedSeq != null && !this.observedSeq.isEmpty();
    }

    public MolecularSequence setObservedSeqElement(StringType value) {
        this.observedSeq = value;
        return this;
    }

    public String getObservedSeq() {
        return this.observedSeq == null ? null : (String)this.observedSeq.getValue();
    }

    public MolecularSequence setObservedSeq(String value) {
        if (Utilities.noString((String)value)) {
            this.observedSeq = null;
        } else {
            if (this.observedSeq == null) {
                this.observedSeq = new StringType();
            }
            this.observedSeq.setValue(value);
        }
        return this;
    }

    public List<MolecularSequenceQualityComponent> getQuality() {
        if (this.quality == null) {
            this.quality = new ArrayList<MolecularSequenceQualityComponent>();
        }
        return this.quality;
    }

    public MolecularSequence setQuality(List<MolecularSequenceQualityComponent> theQuality) {
        this.quality = theQuality;
        return this;
    }

    public boolean hasQuality() {
        if (this.quality == null) {
            return false;
        }
        for (MolecularSequenceQualityComponent item : this.quality) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MolecularSequenceQualityComponent addQuality() {
        MolecularSequenceQualityComponent t = new MolecularSequenceQualityComponent();
        if (this.quality == null) {
            this.quality = new ArrayList<MolecularSequenceQualityComponent>();
        }
        this.quality.add(t);
        return t;
    }

    public MolecularSequence addQuality(MolecularSequenceQualityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.quality == null) {
            this.quality = new ArrayList<MolecularSequenceQualityComponent>();
        }
        this.quality.add(t);
        return this;
    }

    public MolecularSequenceQualityComponent getQualityFirstRep() {
        if (this.getQuality().isEmpty()) {
            this.addQuality();
        }
        return this.getQuality().get(0);
    }

    public IntegerType getReadCoverageElement() {
        if (this.readCoverage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.readCoverage");
            }
            if (Configuration.doAutoCreate()) {
                this.readCoverage = new IntegerType();
            }
        }
        return this.readCoverage;
    }

    public boolean hasReadCoverageElement() {
        return this.readCoverage != null && !this.readCoverage.isEmpty();
    }

    public boolean hasReadCoverage() {
        return this.readCoverage != null && !this.readCoverage.isEmpty();
    }

    public MolecularSequence setReadCoverageElement(IntegerType value) {
        this.readCoverage = value;
        return this;
    }

    public int getReadCoverage() {
        return this.readCoverage == null || this.readCoverage.isEmpty() ? 0 : (Integer)this.readCoverage.getValue();
    }

    public MolecularSequence setReadCoverage(int value) {
        if (this.readCoverage == null) {
            this.readCoverage = new IntegerType();
        }
        this.readCoverage.setValue((Object)value);
        return this;
    }

    public List<MolecularSequenceRepositoryComponent> getRepository() {
        if (this.repository == null) {
            this.repository = new ArrayList<MolecularSequenceRepositoryComponent>();
        }
        return this.repository;
    }

    public MolecularSequence setRepository(List<MolecularSequenceRepositoryComponent> theRepository) {
        this.repository = theRepository;
        return this;
    }

    public boolean hasRepository() {
        if (this.repository == null) {
            return false;
        }
        for (MolecularSequenceRepositoryComponent item : this.repository) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MolecularSequenceRepositoryComponent addRepository() {
        MolecularSequenceRepositoryComponent t = new MolecularSequenceRepositoryComponent();
        if (this.repository == null) {
            this.repository = new ArrayList<MolecularSequenceRepositoryComponent>();
        }
        this.repository.add(t);
        return t;
    }

    public MolecularSequence addRepository(MolecularSequenceRepositoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.repository == null) {
            this.repository = new ArrayList<MolecularSequenceRepositoryComponent>();
        }
        this.repository.add(t);
        return this;
    }

    public MolecularSequenceRepositoryComponent getRepositoryFirstRep() {
        if (this.getRepository().isEmpty()) {
            this.addRepository();
        }
        return this.getRepository().get(0);
    }

    public List<Reference> getPointer() {
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        return this.pointer;
    }

    public MolecularSequence setPointer(List<Reference> thePointer) {
        this.pointer = thePointer;
        return this;
    }

    public boolean hasPointer() {
        if (this.pointer == null) {
            return false;
        }
        for (Reference item : this.pointer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPointer() {
        Reference t = new Reference();
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        this.pointer.add(t);
        return t;
    }

    public MolecularSequence addPointer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        this.pointer.add(t);
        return this;
    }

    public Reference getPointerFirstRep() {
        if (this.getPointer().isEmpty()) {
            this.addPointer();
        }
        return this.getPointer().get(0);
    }

    public List<MolecularSequenceStructureVariantComponent> getStructureVariant() {
        if (this.structureVariant == null) {
            this.structureVariant = new ArrayList<MolecularSequenceStructureVariantComponent>();
        }
        return this.structureVariant;
    }

    public MolecularSequence setStructureVariant(List<MolecularSequenceStructureVariantComponent> theStructureVariant) {
        this.structureVariant = theStructureVariant;
        return this;
    }

    public boolean hasStructureVariant() {
        if (this.structureVariant == null) {
            return false;
        }
        for (MolecularSequenceStructureVariantComponent item : this.structureVariant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MolecularSequenceStructureVariantComponent addStructureVariant() {
        MolecularSequenceStructureVariantComponent t = new MolecularSequenceStructureVariantComponent();
        if (this.structureVariant == null) {
            this.structureVariant = new ArrayList<MolecularSequenceStructureVariantComponent>();
        }
        this.structureVariant.add(t);
        return t;
    }

    public MolecularSequence addStructureVariant(MolecularSequenceStructureVariantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.structureVariant == null) {
            this.structureVariant = new ArrayList<MolecularSequenceStructureVariantComponent>();
        }
        this.structureVariant.add(t);
        return this;
    }

    public MolecularSequenceStructureVariantComponent getStructureVariantFirstRep() {
        if (this.getStructureVariant().isEmpty()) {
            this.addStructureVariant();
        }
        return this.getStructureVariant().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for this particular sequence instance. This is a FHIR-defined id.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "code", "Amino Acid Sequence/ DNA Sequence / RNA Sequence.", 0, 1, this.type));
        children.add(new Property("coordinateSystem", "integer", "Whether the sequence is numbered starting at 0 (0-based numbering or coordinates, inclusive start, exclusive end) or starting at 1 (1-based numbering, inclusive start and inclusive end).", 0, 1, this.coordinateSystem));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient whose sequencing results are described by this resource.", 0, 1, this.patient));
        children.add(new Property("specimen", "Reference(Specimen)", "Specimen used for sequencing.", 0, 1, this.specimen));
        children.add(new Property("device", "Reference(Device)", "The method for sequencing, for example, chip information.", 0, 1, this.device));
        children.add(new Property("performer", "Reference(Organization)", "The organization or lab that should be responsible for this result.", 0, 1, this.performer));
        children.add(new Property("quantity", "Quantity", "The number of copies of the sequence of interest. (RNASeq).", 0, 1, this.quantity));
        children.add(new Property("referenceSeq", "", "A sequence that is used as a reference to describe variants that are present in a sequence analyzed.", 0, 1, this.referenceSeq));
        children.add(new Property("variant", "", "The definition of variant here originates from Sequence ontology ([variant_of](http://www.sequenceontology.org/browser/current_svn/term/variant_of)). This element can represent amino acid or nucleic sequence change(including insertion,deletion,SNP,etc.)  It can represent some complex mutation or segment variation with the assist of CIGAR string.", 0, Integer.MAX_VALUE, this.variant));
        children.add(new Property("observedSeq", "string", "Sequence that was observed. It is the result marked by referenceSeq along with variant records on referenceSeq. This shall start from referenceSeq.windowStart and end by referenceSeq.windowEnd.", 0, 1, this.observedSeq));
        children.add(new Property("quality", "", "An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score ([SO:0001686](http://www.sequenceontology.org/browser/current_svn/term/SO:0001686)).", 0, Integer.MAX_VALUE, this.quality));
        children.add(new Property("readCoverage", "integer", "Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.", 0, 1, this.readCoverage));
        children.add(new Property("repository", "", "Configurations of the external repository. The repository shall store target's observedSeq or records related with target's observedSeq.", 0, Integer.MAX_VALUE, this.repository));
        children.add(new Property("pointer", "Reference(MolecularSequence)", "Pointer to next atomic sequence which at most contains one variant.", 0, Integer.MAX_VALUE, this.pointer));
        children.add(new Property("structureVariant", "", "Information about chromosome structure variation.", 0, Integer.MAX_VALUE, this.structureVariant));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for this particular sequence instance. This is a FHIR-defined id.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "Amino Acid Sequence/ DNA Sequence / RNA Sequence.", 0, 1, this.type);
            }
            case 354212295: {
                return new Property("coordinateSystem", "integer", "Whether the sequence is numbered starting at 0 (0-based numbering or coordinates, inclusive start, exclusive end) or starting at 1 (1-based numbering, inclusive start and inclusive end).", 0, 1, this.coordinateSystem);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient whose sequencing results are described by this resource.", 0, 1, this.patient);
            }
            case -2132868344: {
                return new Property("specimen", "Reference(Specimen)", "Specimen used for sequencing.", 0, 1, this.specimen);
            }
            case -1335157162: {
                return new Property("device", "Reference(Device)", "The method for sequencing, for example, chip information.", 0, 1, this.device);
            }
            case 481140686: {
                return new Property("performer", "Reference(Organization)", "The organization or lab that should be responsible for this result.", 0, 1, this.performer);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The number of copies of the sequence of interest. (RNASeq).", 0, 1, this.quantity);
            }
            case -502547180: {
                return new Property("referenceSeq", "", "A sequence that is used as a reference to describe variants that are present in a sequence analyzed.", 0, 1, this.referenceSeq);
            }
            case 236785797: {
                return new Property("variant", "", "The definition of variant here originates from Sequence ontology ([variant_of](http://www.sequenceontology.org/browser/current_svn/term/variant_of)). This element can represent amino acid or nucleic sequence change(including insertion,deletion,SNP,etc.)  It can represent some complex mutation or segment variation with the assist of CIGAR string.", 0, Integer.MAX_VALUE, this.variant);
            }
            case 125541495: {
                return new Property("observedSeq", "string", "Sequence that was observed. It is the result marked by referenceSeq along with variant records on referenceSeq. This shall start from referenceSeq.windowStart and end by referenceSeq.windowEnd.", 0, 1, this.observedSeq);
            }
            case 651215103: {
                return new Property("quality", "", "An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score ([SO:0001686](http://www.sequenceontology.org/browser/current_svn/term/SO:0001686)).", 0, Integer.MAX_VALUE, this.quality);
            }
            case -1798816354: {
                return new Property("readCoverage", "integer", "Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.", 0, 1, this.readCoverage);
            }
            case 1950800714: {
                return new Property("repository", "", "Configurations of the external repository. The repository shall store target's observedSeq or records related with target's observedSeq.", 0, Integer.MAX_VALUE, this.repository);
            }
            case -400605635: {
                return new Property("pointer", "Reference(MolecularSequence)", "Pointer to next atomic sequence which at most contains one variant.", 0, Integer.MAX_VALUE, this.pointer);
            }
            case 757269394: {
                return new Property("structureVariant", "", "Information about chromosome structure variation.", 0, Integer.MAX_VALUE, this.structureVariant);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 354212295: {
                Base[] baseArray;
                if (this.coordinateSystem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.coordinateSystem;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case -2132868344: {
                Base[] baseArray;
                if (this.specimen == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.specimen;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.device;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.performer;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.quantity;
                }
                return baseArray;
            }
            case -502547180: {
                Base[] baseArray;
                if (this.referenceSeq == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.referenceSeq;
                }
                return baseArray;
            }
            case 236785797: {
                return this.variant == null ? new Base[]{} : this.variant.toArray(new Base[this.variant.size()]);
            }
            case 125541495: {
                Base[] baseArray;
                if (this.observedSeq == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.observedSeq;
                }
                return baseArray;
            }
            case 651215103: {
                return this.quality == null ? new Base[]{} : this.quality.toArray(new Base[this.quality.size()]);
            }
            case -1798816354: {
                Base[] baseArray;
                if (this.readCoverage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.readCoverage;
                }
                return baseArray;
            }
            case 1950800714: {
                return this.repository == null ? new Base[]{} : this.repository.toArray(new Base[this.repository.size()]);
            }
            case -400605635: {
                return this.pointer == null ? new Base[]{} : this.pointer.toArray(new Base[this.pointer.size()]);
            }
            case 757269394: {
                return this.structureVariant == null ? new Base[]{} : this.structureVariant.toArray(new Base[this.structureVariant.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                value = new SequenceTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 354212295: {
                this.coordinateSystem = this.castToInteger(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -2132868344: {
                this.specimen = this.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                return value;
            }
            case 481140686: {
                this.performer = this.castToReference(value);
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                return value;
            }
            case -502547180: {
                this.referenceSeq = (MolecularSequenceReferenceSeqComponent)((Object)value);
                return value;
            }
            case 236785797: {
                this.getVariant().add((MolecularSequenceVariantComponent)((Object)value));
                return value;
            }
            case 125541495: {
                this.observedSeq = this.castToString(value);
                return value;
            }
            case 651215103: {
                this.getQuality().add((MolecularSequenceQualityComponent)((Object)value));
                return value;
            }
            case -1798816354: {
                this.readCoverage = this.castToInteger(value);
                return value;
            }
            case 1950800714: {
                this.getRepository().add((MolecularSequenceRepositoryComponent)((Object)value));
                return value;
            }
            case -400605635: {
                this.getPointer().add(this.castToReference(value));
                return value;
            }
            case 757269394: {
                this.getStructureVariant().add((MolecularSequenceStructureVariantComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            value = new SequenceTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("coordinateSystem")) {
            this.coordinateSystem = this.castToInteger(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("specimen")) {
            this.specimen = this.castToReference(value);
        } else if (name.equals("device")) {
            this.device = this.castToReference(value);
        } else if (name.equals("performer")) {
            this.performer = this.castToReference(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals("referenceSeq")) {
            this.referenceSeq = (MolecularSequenceReferenceSeqComponent)((Object)value);
        } else if (name.equals("variant")) {
            this.getVariant().add((MolecularSequenceVariantComponent)((Object)value));
        } else if (name.equals("observedSeq")) {
            this.observedSeq = this.castToString(value);
        } else if (name.equals("quality")) {
            this.getQuality().add((MolecularSequenceQualityComponent)((Object)value));
        } else if (name.equals("readCoverage")) {
            this.readCoverage = this.castToInteger(value);
        } else if (name.equals("repository")) {
            this.getRepository().add((MolecularSequenceRepositoryComponent)((Object)value));
        } else if (name.equals("pointer")) {
            this.getPointer().add(this.castToReference(value));
        } else if (name.equals("structureVariant")) {
            this.getStructureVariant().add((MolecularSequenceStructureVariantComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 354212295: {
                return this.getCoordinateSystemElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -2132868344: {
                return this.getSpecimen();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -502547180: {
                return this.getReferenceSeq();
            }
            case 236785797: {
                return this.addVariant();
            }
            case 125541495: {
                return this.getObservedSeqElement();
            }
            case 651215103: {
                return this.addQuality();
            }
            case -1798816354: {
                return this.getReadCoverageElement();
            }
            case 1950800714: {
                return this.addRepository();
            }
            case -400605635: {
                return this.addPointer();
            }
            case 757269394: {
                return this.addStructureVariant();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 354212295: {
                return new String[]{"integer"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case -502547180: {
                return new String[0];
            }
            case 236785797: {
                return new String[0];
            }
            case 125541495: {
                return new String[]{"string"};
            }
            case 651215103: {
                return new String[0];
            }
            case -1798816354: {
                return new String[]{"integer"};
            }
            case 1950800714: {
                return new String[0];
            }
            case -400605635: {
                return new String[]{"Reference"};
            }
            case 757269394: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.type");
        }
        if (name.equals("coordinateSystem")) {
            throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.coordinateSystem");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("specimen")) {
            this.specimen = new Reference();
            return this.specimen;
        }
        if (name.equals("device")) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("performer")) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("referenceSeq")) {
            this.referenceSeq = new MolecularSequenceReferenceSeqComponent();
            return this.referenceSeq;
        }
        if (name.equals("variant")) {
            return this.addVariant();
        }
        if (name.equals("observedSeq")) {
            throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.observedSeq");
        }
        if (name.equals("quality")) {
            return this.addQuality();
        }
        if (name.equals("readCoverage")) {
            throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.readCoverage");
        }
        if (name.equals("repository")) {
            return this.addRepository();
        }
        if (name.equals("pointer")) {
            return this.addPointer();
        }
        if (name.equals("structureVariant")) {
            return this.addStructureVariant();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MolecularSequence";
    }

    @Override
    public MolecularSequence copy() {
        MolecularSequence dst = new MolecularSequence();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MolecularSequence dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.coordinateSystem = this.coordinateSystem == null ? null : this.coordinateSystem.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.specimen = this.specimen == null ? null : this.specimen.copy();
        dst.device = this.device == null ? null : this.device.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        MolecularSequenceReferenceSeqComponent molecularSequenceReferenceSeqComponent = dst.referenceSeq = this.referenceSeq == null ? null : this.referenceSeq.copy();
        if (this.variant != null) {
            dst.variant = new ArrayList<MolecularSequenceVariantComponent>();
            for (MolecularSequenceVariantComponent molecularSequenceVariantComponent : this.variant) {
                dst.variant.add(molecularSequenceVariantComponent.copy());
            }
        }
        StringType stringType = dst.observedSeq = this.observedSeq == null ? null : this.observedSeq.copy();
        if (this.quality != null) {
            dst.quality = new ArrayList<MolecularSequenceQualityComponent>();
            for (MolecularSequenceQualityComponent molecularSequenceQualityComponent : this.quality) {
                dst.quality.add(molecularSequenceQualityComponent.copy());
            }
        }
        IntegerType integerType = dst.readCoverage = this.readCoverage == null ? null : this.readCoverage.copy();
        if (this.repository != null) {
            dst.repository = new ArrayList<MolecularSequenceRepositoryComponent>();
            for (MolecularSequenceRepositoryComponent molecularSequenceRepositoryComponent : this.repository) {
                dst.repository.add(molecularSequenceRepositoryComponent.copy());
            }
        }
        if (this.pointer != null) {
            dst.pointer = new ArrayList<Reference>();
            for (Reference reference : this.pointer) {
                dst.pointer.add(reference.copy());
            }
        }
        if (this.structureVariant != null) {
            dst.structureVariant = new ArrayList<MolecularSequenceStructureVariantComponent>();
            for (MolecularSequenceStructureVariantComponent molecularSequenceStructureVariantComponent : this.structureVariant) {
                dst.structureVariant.add(molecularSequenceStructureVariantComponent.copy());
            }
        }
    }

    protected MolecularSequence typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MolecularSequence)) {
            return false;
        }
        MolecularSequence o = (MolecularSequence)other_;
        return MolecularSequence.compareDeep(this.identifier, o.identifier, true) && MolecularSequence.compareDeep(this.type, o.type, true) && MolecularSequence.compareDeep(this.coordinateSystem, o.coordinateSystem, true) && MolecularSequence.compareDeep(this.patient, o.patient, true) && MolecularSequence.compareDeep(this.specimen, o.specimen, true) && MolecularSequence.compareDeep(this.device, o.device, true) && MolecularSequence.compareDeep(this.performer, o.performer, true) && MolecularSequence.compareDeep(this.quantity, o.quantity, true) && MolecularSequence.compareDeep(this.referenceSeq, o.referenceSeq, true) && MolecularSequence.compareDeep(this.variant, o.variant, true) && MolecularSequence.compareDeep(this.observedSeq, o.observedSeq, true) && MolecularSequence.compareDeep(this.quality, o.quality, true) && MolecularSequence.compareDeep(this.readCoverage, o.readCoverage, true) && MolecularSequence.compareDeep(this.repository, o.repository, true) && MolecularSequence.compareDeep(this.pointer, o.pointer, true) && MolecularSequence.compareDeep(this.structureVariant, o.structureVariant, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MolecularSequence)) {
            return false;
        }
        MolecularSequence o = (MolecularSequence)other_;
        return MolecularSequence.compareValues(this.type, o.type, true) && MolecularSequence.compareValues(this.coordinateSystem, o.coordinateSystem, true) && MolecularSequence.compareValues(this.observedSeq, o.observedSeq, true) && MolecularSequence.compareValues(this.readCoverage, o.readCoverage, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.coordinateSystem, this.patient, this.specimen, this.device, this.performer, this.quantity, this.referenceSeq, this.variant, this.observedSeq, this.quality, this.readCoverage, this.repository, this.pointer, this.structureVariant});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MolecularSequence;
    }

    @Block
    public static class MolecularSequenceStructureVariantInnerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant inner start", formalDefinition="Structural variant inner start. If the coordinate system is either 0-based or 1-based, then start position is inclusive.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant inner end", formalDefinition="Structural variant inner end. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.")
        protected IntegerType end;
        private static final long serialVersionUID = -1798864889L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantInnerComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public MolecularSequenceStructureVariantInnerComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public MolecularSequenceStructureVariantInnerComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantInnerComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public MolecularSequenceStructureVariantInnerComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public MolecularSequenceStructureVariantInnerComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("start", "integer", "Structural variant inner start. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start));
            children.add(new Property("end", "integer", "Structural variant inner end. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109757538: {
                    return new Property("start", "integer", "Structural variant inner start. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start);
                }
                case 100571: {
                    return new Property("end", "integer", "Structural variant inner end. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    return value;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("start")) {
                this.start = this.castToInteger(value);
            } else if (name.equals("end")) {
                this.end = this.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return this.getStartElement();
                }
                case 100571: {
                    return this.getEndElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return new String[]{"integer"};
                }
                case 100571: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("start")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.start");
            }
            if (name.equals("end")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.end");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceStructureVariantInnerComponent copy() {
            MolecularSequenceStructureVariantInnerComponent dst = new MolecularSequenceStructureVariantInnerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceStructureVariantInnerComponent dst) {
            super.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceStructureVariantInnerComponent)) {
                return false;
            }
            MolecularSequenceStructureVariantInnerComponent o = (MolecularSequenceStructureVariantInnerComponent)other_;
            return MolecularSequenceStructureVariantInnerComponent.compareDeep(this.start, o.start, true) && MolecularSequenceStructureVariantInnerComponent.compareDeep(this.end, o.end, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceStructureVariantInnerComponent)) {
                return false;
            }
            MolecularSequenceStructureVariantInnerComponent o = (MolecularSequenceStructureVariantInnerComponent)other_;
            return MolecularSequenceStructureVariantInnerComponent.compareValues(this.start, o.start, true) && MolecularSequenceStructureVariantInnerComponent.compareValues(this.end, o.end, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.start, this.end});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.structureVariant.inner";
        }
    }

    @Block
    public static class MolecularSequenceStructureVariantOuterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant outer start", formalDefinition="Structural variant outer start. If the coordinate system is either 0-based or 1-based, then start position is inclusive.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant outer end", formalDefinition="Structural variant outer end. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.")
        protected IntegerType end;
        private static final long serialVersionUID = -1798864889L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantOuterComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public MolecularSequenceStructureVariantOuterComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public MolecularSequenceStructureVariantOuterComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantOuterComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public MolecularSequenceStructureVariantOuterComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public MolecularSequenceStructureVariantOuterComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("start", "integer", "Structural variant outer start. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start));
            children.add(new Property("end", "integer", "Structural variant outer end. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109757538: {
                    return new Property("start", "integer", "Structural variant outer start. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start);
                }
                case 100571: {
                    return new Property("end", "integer", "Structural variant outer end. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    return value;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("start")) {
                this.start = this.castToInteger(value);
            } else if (name.equals("end")) {
                this.end = this.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return this.getStartElement();
                }
                case 100571: {
                    return this.getEndElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return new String[]{"integer"};
                }
                case 100571: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("start")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.start");
            }
            if (name.equals("end")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.end");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceStructureVariantOuterComponent copy() {
            MolecularSequenceStructureVariantOuterComponent dst = new MolecularSequenceStructureVariantOuterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceStructureVariantOuterComponent dst) {
            super.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceStructureVariantOuterComponent)) {
                return false;
            }
            MolecularSequenceStructureVariantOuterComponent o = (MolecularSequenceStructureVariantOuterComponent)other_;
            return MolecularSequenceStructureVariantOuterComponent.compareDeep(this.start, o.start, true) && MolecularSequenceStructureVariantOuterComponent.compareDeep(this.end, o.end, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceStructureVariantOuterComponent)) {
                return false;
            }
            MolecularSequenceStructureVariantOuterComponent o = (MolecularSequenceStructureVariantOuterComponent)other_;
            return MolecularSequenceStructureVariantOuterComponent.compareValues(this.start, o.start, true) && MolecularSequenceStructureVariantOuterComponent.compareValues(this.end, o.end, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.start, this.end});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.structureVariant.outer";
        }
    }

    @Block
    public static class MolecularSequenceStructureVariantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="variantType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant change type", formalDefinition="Information about chromosome structure variation DNA change type.")
        protected CodeableConcept variantType;
        @Child(name="exact", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Does the structural variant have base pair resolution breakpoints?", formalDefinition="Used to indicate if the outer and inner start-end values have the same meaning.")
        protected BooleanType exact;
        @Child(name="length", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant length", formalDefinition="Length of the variant chromosome.")
        protected IntegerType length;
        @Child(name="outer", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant outer", formalDefinition="Structural variant outer.")
        protected MolecularSequenceStructureVariantOuterComponent outer;
        @Child(name="inner", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural variant inner", formalDefinition="Structural variant inner.")
        protected MolecularSequenceStructureVariantInnerComponent inner;
        private static final long serialVersionUID = -1943515207L;

        public CodeableConcept getVariantType() {
            if (this.variantType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantComponent.variantType");
                }
                if (Configuration.doAutoCreate()) {
                    this.variantType = new CodeableConcept();
                }
            }
            return this.variantType;
        }

        public boolean hasVariantType() {
            return this.variantType != null && !this.variantType.isEmpty();
        }

        public MolecularSequenceStructureVariantComponent setVariantType(CodeableConcept value) {
            this.variantType = value;
            return this;
        }

        public BooleanType getExactElement() {
            if (this.exact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantComponent.exact");
                }
                if (Configuration.doAutoCreate()) {
                    this.exact = new BooleanType();
                }
            }
            return this.exact;
        }

        public boolean hasExactElement() {
            return this.exact != null && !this.exact.isEmpty();
        }

        public boolean hasExact() {
            return this.exact != null && !this.exact.isEmpty();
        }

        public MolecularSequenceStructureVariantComponent setExactElement(BooleanType value) {
            this.exact = value;
            return this;
        }

        public boolean getExact() {
            return this.exact == null || this.exact.isEmpty() ? false : (Boolean)this.exact.getValue();
        }

        public MolecularSequenceStructureVariantComponent setExact(boolean value) {
            if (this.exact == null) {
                this.exact = new BooleanType();
            }
            this.exact.setValue((Object)value);
            return this;
        }

        public IntegerType getLengthElement() {
            if (this.length == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantComponent.length");
                }
                if (Configuration.doAutoCreate()) {
                    this.length = new IntegerType();
                }
            }
            return this.length;
        }

        public boolean hasLengthElement() {
            return this.length != null && !this.length.isEmpty();
        }

        public boolean hasLength() {
            return this.length != null && !this.length.isEmpty();
        }

        public MolecularSequenceStructureVariantComponent setLengthElement(IntegerType value) {
            this.length = value;
            return this;
        }

        public int getLength() {
            return this.length == null || this.length.isEmpty() ? 0 : (Integer)this.length.getValue();
        }

        public MolecularSequenceStructureVariantComponent setLength(int value) {
            if (this.length == null) {
                this.length = new IntegerType();
            }
            this.length.setValue((Object)value);
            return this;
        }

        public MolecularSequenceStructureVariantOuterComponent getOuter() {
            if (this.outer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantComponent.outer");
                }
                if (Configuration.doAutoCreate()) {
                    this.outer = new MolecularSequenceStructureVariantOuterComponent();
                }
            }
            return this.outer;
        }

        public boolean hasOuter() {
            return this.outer != null && !this.outer.isEmpty();
        }

        public MolecularSequenceStructureVariantComponent setOuter(MolecularSequenceStructureVariantOuterComponent value) {
            this.outer = value;
            return this;
        }

        public MolecularSequenceStructureVariantInnerComponent getInner() {
            if (this.inner == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceStructureVariantComponent.inner");
                }
                if (Configuration.doAutoCreate()) {
                    this.inner = new MolecularSequenceStructureVariantInnerComponent();
                }
            }
            return this.inner;
        }

        public boolean hasInner() {
            return this.inner != null && !this.inner.isEmpty();
        }

        public MolecularSequenceStructureVariantComponent setInner(MolecularSequenceStructureVariantInnerComponent value) {
            this.inner = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("variantType", "CodeableConcept", "Information about chromosome structure variation DNA change type.", 0, 1, this.variantType));
            children.add(new Property("exact", "boolean", "Used to indicate if the outer and inner start-end values have the same meaning.", 0, 1, this.exact));
            children.add(new Property("length", "integer", "Length of the variant chromosome.", 0, 1, this.length));
            children.add(new Property("outer", "", "Structural variant outer.", 0, 1, this.outer));
            children.add(new Property("inner", "", "Structural variant inner.", 0, 1, this.inner));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1601222305: {
                    return new Property("variantType", "CodeableConcept", "Information about chromosome structure variation DNA change type.", 0, 1, this.variantType);
                }
                case 96946943: {
                    return new Property("exact", "boolean", "Used to indicate if the outer and inner start-end values have the same meaning.", 0, 1, this.exact);
                }
                case -1106363674: {
                    return new Property("length", "integer", "Length of the variant chromosome.", 0, 1, this.length);
                }
                case 106111099: {
                    return new Property("outer", "", "Structural variant outer.", 0, 1, this.outer);
                }
                case 100355670: {
                    return new Property("inner", "", "Structural variant inner.", 0, 1, this.inner);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1601222305: {
                    Base[] baseArray;
                    if (this.variantType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.variantType;
                    }
                    return baseArray;
                }
                case 96946943: {
                    Base[] baseArray;
                    if (this.exact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exact;
                    }
                    return baseArray;
                }
                case -1106363674: {
                    Base[] baseArray;
                    if (this.length == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.length;
                    }
                    return baseArray;
                }
                case 106111099: {
                    Base[] baseArray;
                    if (this.outer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.outer;
                    }
                    return baseArray;
                }
                case 100355670: {
                    Base[] baseArray;
                    if (this.inner == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.inner;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1601222305: {
                    this.variantType = this.castToCodeableConcept(value);
                    return value;
                }
                case 96946943: {
                    this.exact = this.castToBoolean(value);
                    return value;
                }
                case -1106363674: {
                    this.length = this.castToInteger(value);
                    return value;
                }
                case 106111099: {
                    this.outer = (MolecularSequenceStructureVariantOuterComponent)value;
                    return value;
                }
                case 100355670: {
                    this.inner = (MolecularSequenceStructureVariantInnerComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("variantType")) {
                this.variantType = this.castToCodeableConcept(value);
            } else if (name.equals("exact")) {
                this.exact = this.castToBoolean(value);
            } else if (name.equals("length")) {
                this.length = this.castToInteger(value);
            } else if (name.equals("outer")) {
                this.outer = (MolecularSequenceStructureVariantOuterComponent)value;
            } else if (name.equals("inner")) {
                this.inner = (MolecularSequenceStructureVariantInnerComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1601222305: {
                    return this.getVariantType();
                }
                case 96946943: {
                    return this.getExactElement();
                }
                case -1106363674: {
                    return this.getLengthElement();
                }
                case 106111099: {
                    return this.getOuter();
                }
                case 100355670: {
                    return this.getInner();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1601222305: {
                    return new String[]{"CodeableConcept"};
                }
                case 96946943: {
                    return new String[]{"boolean"};
                }
                case -1106363674: {
                    return new String[]{"integer"};
                }
                case 106111099: {
                    return new String[0];
                }
                case 100355670: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("variantType")) {
                this.variantType = new CodeableConcept();
                return this.variantType;
            }
            if (name.equals("exact")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.exact");
            }
            if (name.equals("length")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.length");
            }
            if (name.equals("outer")) {
                this.outer = new MolecularSequenceStructureVariantOuterComponent();
                return this.outer;
            }
            if (name.equals("inner")) {
                this.inner = new MolecularSequenceStructureVariantInnerComponent();
                return this.inner;
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceStructureVariantComponent copy() {
            MolecularSequenceStructureVariantComponent dst = new MolecularSequenceStructureVariantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceStructureVariantComponent dst) {
            super.copyValues(dst);
            dst.variantType = this.variantType == null ? null : this.variantType.copy();
            dst.exact = this.exact == null ? null : this.exact.copy();
            dst.length = this.length == null ? null : this.length.copy();
            dst.outer = this.outer == null ? null : this.outer.copy();
            dst.inner = this.inner == null ? null : this.inner.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceStructureVariantComponent)) {
                return false;
            }
            MolecularSequenceStructureVariantComponent o = (MolecularSequenceStructureVariantComponent)other_;
            return MolecularSequenceStructureVariantComponent.compareDeep(this.variantType, o.variantType, true) && MolecularSequenceStructureVariantComponent.compareDeep(this.exact, o.exact, true) && MolecularSequenceStructureVariantComponent.compareDeep(this.length, o.length, true) && MolecularSequenceStructureVariantComponent.compareDeep(this.outer, o.outer, true) && MolecularSequenceStructureVariantComponent.compareDeep(this.inner, o.inner, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceStructureVariantComponent)) {
                return false;
            }
            MolecularSequenceStructureVariantComponent o = (MolecularSequenceStructureVariantComponent)other_;
            return MolecularSequenceStructureVariantComponent.compareValues(this.exact, o.exact, true) && MolecularSequenceStructureVariantComponent.compareValues(this.length, o.length, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.variantType, this.exact, this.length, this.outer, this.inner});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.structureVariant";
        }
    }

    @Block
    public static class MolecularSequenceRepositoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="directlink | openapi | login | oauth | other", formalDefinition="Click and see / RESTful API / Need login to see / RESTful API with authentication / Other ways to see resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/repository-type")
        protected Enumeration<RepositoryType> type;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URI of the repository", formalDefinition="URI of an external repository which contains further details about the genetics data.")
        protected UriType url;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Repository's name", formalDefinition="URI of an external repository which contains further details about the genetics data.")
        protected StringType name;
        @Child(name="datasetId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of the dataset that used to call for dataset in repository", formalDefinition="Id of the variant in this external repository. The server will understand how to use this id to call for more info about datasets in external repository.")
        protected StringType datasetId;
        @Child(name="variantsetId", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of the variantset that used to call for variantset in repository", formalDefinition="Id of the variantset in this external repository. The server will understand how to use this id to call for more info about variantsets in external repository.")
        protected StringType variantsetId;
        @Child(name="readsetId", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of the read", formalDefinition="Id of the read in this external repository.")
        protected StringType readsetId;
        private static final long serialVersionUID = -899243265L;

        public MolecularSequenceRepositoryComponent() {
        }

        public MolecularSequenceRepositoryComponent(Enumeration<RepositoryType> type) {
            this.type = type;
        }

        public Enumeration<RepositoryType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRepositoryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<RepositoryType>(new RepositoryTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MolecularSequenceRepositoryComponent setTypeElement(Enumeration<RepositoryType> value) {
            this.type = value;
            return this;
        }

        public RepositoryType getType() {
            return this.type == null ? null : (RepositoryType)((Object)this.type.getValue());
        }

        public MolecularSequenceRepositoryComponent setType(RepositoryType value) {
            if (this.type == null) {
                this.type = new Enumeration<RepositoryType>(new RepositoryTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRepositoryComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public MolecularSequenceRepositoryComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public MolecularSequenceRepositoryComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRepositoryComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MolecularSequenceRepositoryComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MolecularSequenceRepositoryComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDatasetIdElement() {
            if (this.datasetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRepositoryComponent.datasetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.datasetId = new StringType();
                }
            }
            return this.datasetId;
        }

        public boolean hasDatasetIdElement() {
            return this.datasetId != null && !this.datasetId.isEmpty();
        }

        public boolean hasDatasetId() {
            return this.datasetId != null && !this.datasetId.isEmpty();
        }

        public MolecularSequenceRepositoryComponent setDatasetIdElement(StringType value) {
            this.datasetId = value;
            return this;
        }

        public String getDatasetId() {
            return this.datasetId == null ? null : (String)this.datasetId.getValue();
        }

        public MolecularSequenceRepositoryComponent setDatasetId(String value) {
            if (Utilities.noString((String)value)) {
                this.datasetId = null;
            } else {
                if (this.datasetId == null) {
                    this.datasetId = new StringType();
                }
                this.datasetId.setValue(value);
            }
            return this;
        }

        public StringType getVariantsetIdElement() {
            if (this.variantsetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRepositoryComponent.variantsetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.variantsetId = new StringType();
                }
            }
            return this.variantsetId;
        }

        public boolean hasVariantsetIdElement() {
            return this.variantsetId != null && !this.variantsetId.isEmpty();
        }

        public boolean hasVariantsetId() {
            return this.variantsetId != null && !this.variantsetId.isEmpty();
        }

        public MolecularSequenceRepositoryComponent setVariantsetIdElement(StringType value) {
            this.variantsetId = value;
            return this;
        }

        public String getVariantsetId() {
            return this.variantsetId == null ? null : (String)this.variantsetId.getValue();
        }

        public MolecularSequenceRepositoryComponent setVariantsetId(String value) {
            if (Utilities.noString((String)value)) {
                this.variantsetId = null;
            } else {
                if (this.variantsetId == null) {
                    this.variantsetId = new StringType();
                }
                this.variantsetId.setValue(value);
            }
            return this;
        }

        public StringType getReadsetIdElement() {
            if (this.readsetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRepositoryComponent.readsetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.readsetId = new StringType();
                }
            }
            return this.readsetId;
        }

        public boolean hasReadsetIdElement() {
            return this.readsetId != null && !this.readsetId.isEmpty();
        }

        public boolean hasReadsetId() {
            return this.readsetId != null && !this.readsetId.isEmpty();
        }

        public MolecularSequenceRepositoryComponent setReadsetIdElement(StringType value) {
            this.readsetId = value;
            return this;
        }

        public String getReadsetId() {
            return this.readsetId == null ? null : (String)this.readsetId.getValue();
        }

        public MolecularSequenceRepositoryComponent setReadsetId(String value) {
            if (Utilities.noString((String)value)) {
                this.readsetId = null;
            } else {
                if (this.readsetId == null) {
                    this.readsetId = new StringType();
                }
                this.readsetId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MolecularSequence.SP_TYPE, "code", "Click and see / RESTful API / Need login to see / RESTful API with authentication / Other ways to see resource.", 0, 1, this.type));
            children.add(new Property("url", "uri", "URI of an external repository which contains further details about the genetics data.", 0, 1, this.url));
            children.add(new Property("name", "string", "URI of an external repository which contains further details about the genetics data.", 0, 1, this.name));
            children.add(new Property("datasetId", "string", "Id of the variant in this external repository. The server will understand how to use this id to call for more info about datasets in external repository.", 0, 1, this.datasetId));
            children.add(new Property("variantsetId", "string", "Id of the variantset in this external repository. The server will understand how to use this id to call for more info about variantsets in external repository.", 0, 1, this.variantsetId));
            children.add(new Property("readsetId", "string", "Id of the read in this external repository.", 0, 1, this.readsetId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MolecularSequence.SP_TYPE, "code", "Click and see / RESTful API / Need login to see / RESTful API with authentication / Other ways to see resource.", 0, 1, this.type);
                }
                case 116079: {
                    return new Property("url", "uri", "URI of an external repository which contains further details about the genetics data.", 0, 1, this.url);
                }
                case 3373707: {
                    return new Property("name", "string", "URI of an external repository which contains further details about the genetics data.", 0, 1, this.name);
                }
                case -345342029: {
                    return new Property("datasetId", "string", "Id of the variant in this external repository. The server will understand how to use this id to call for more info about datasets in external repository.", 0, 1, this.datasetId);
                }
                case 1929752504: {
                    return new Property("variantsetId", "string", "Id of the variantset in this external repository. The server will understand how to use this id to call for more info about variantsets in external repository.", 0, 1, this.variantsetId);
                }
                case -1095407289: {
                    return new Property("readsetId", "string", "Id of the read in this external repository.", 0, 1, this.readsetId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -345342029: {
                    Base[] baseArray;
                    if (this.datasetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.datasetId;
                    }
                    return baseArray;
                }
                case 1929752504: {
                    Base[] baseArray;
                    if (this.variantsetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.variantsetId;
                    }
                    return baseArray;
                }
                case -1095407289: {
                    Base[] baseArray;
                    if (this.readsetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.readsetId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new RepositoryTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -345342029: {
                    this.datasetId = this.castToString(value);
                    return value;
                }
                case 1929752504: {
                    this.variantsetId = this.castToString(value);
                    return value;
                }
                case -1095407289: {
                    this.readsetId = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MolecularSequence.SP_TYPE)) {
                value = new RepositoryTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("datasetId")) {
                this.datasetId = this.castToString(value);
            } else if (name.equals("variantsetId")) {
                this.variantsetId = this.castToString(value);
            } else if (name.equals("readsetId")) {
                this.readsetId = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -345342029: {
                    return this.getDatasetIdElement();
                }
                case 1929752504: {
                    return this.getVariantsetIdElement();
                }
                case -1095407289: {
                    return this.getReadsetIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -345342029: {
                    return new String[]{"string"};
                }
                case 1929752504: {
                    return new String[]{"string"};
                }
                case -1095407289: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MolecularSequence.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.type");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.url");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.name");
            }
            if (name.equals("datasetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.datasetId");
            }
            if (name.equals("variantsetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.variantsetId");
            }
            if (name.equals("readsetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.readsetId");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceRepositoryComponent copy() {
            MolecularSequenceRepositoryComponent dst = new MolecularSequenceRepositoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceRepositoryComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.datasetId = this.datasetId == null ? null : this.datasetId.copy();
            dst.variantsetId = this.variantsetId == null ? null : this.variantsetId.copy();
            dst.readsetId = this.readsetId == null ? null : this.readsetId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRepositoryComponent)) {
                return false;
            }
            MolecularSequenceRepositoryComponent o = (MolecularSequenceRepositoryComponent)other_;
            return MolecularSequenceRepositoryComponent.compareDeep(this.type, o.type, true) && MolecularSequenceRepositoryComponent.compareDeep(this.url, o.url, true) && MolecularSequenceRepositoryComponent.compareDeep(this.name, o.name, true) && MolecularSequenceRepositoryComponent.compareDeep(this.datasetId, o.datasetId, true) && MolecularSequenceRepositoryComponent.compareDeep(this.variantsetId, o.variantsetId, true) && MolecularSequenceRepositoryComponent.compareDeep(this.readsetId, o.readsetId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRepositoryComponent)) {
                return false;
            }
            MolecularSequenceRepositoryComponent o = (MolecularSequenceRepositoryComponent)other_;
            return MolecularSequenceRepositoryComponent.compareValues(this.type, o.type, true) && MolecularSequenceRepositoryComponent.compareValues(this.url, o.url, true) && MolecularSequenceRepositoryComponent.compareValues(this.name, o.name, true) && MolecularSequenceRepositoryComponent.compareValues(this.datasetId, o.datasetId, true) && MolecularSequenceRepositoryComponent.compareValues(this.variantsetId, o.variantsetId, true) && MolecularSequenceRepositoryComponent.compareValues(this.readsetId, o.readsetId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.url, this.name, this.datasetId, this.variantsetId, this.readsetId});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.repository";
        }
    }

    @Block
    public static class MolecularSequenceQualityRocComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="score", type={IntegerType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Genotype quality score", formalDefinition="Invidual data point representing the GQ (genotype quality) score threshold.")
        protected List<IntegerType> score;
        @Child(name="numTP", type={IntegerType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Roc score true positive numbers", formalDefinition="The number of true positives if the GQ score threshold was set to \"score\" field value.")
        protected List<IntegerType> numTP;
        @Child(name="numFP", type={IntegerType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Roc score false positive numbers", formalDefinition="The number of false positives if the GQ score threshold was set to \"score\" field value.")
        protected List<IntegerType> numFP;
        @Child(name="numFN", type={IntegerType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Roc score false negative numbers", formalDefinition="The number of false negatives if the GQ score threshold was set to \"score\" field value.")
        protected List<IntegerType> numFN;
        @Child(name="precision", type={DecimalType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Precision of the GQ score", formalDefinition="Calculated precision if the GQ score threshold was set to \"score\" field value.")
        protected List<DecimalType> precision;
        @Child(name="sensitivity", type={DecimalType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Sensitivity of the GQ score", formalDefinition="Calculated sensitivity if the GQ score threshold was set to \"score\" field value.")
        protected List<DecimalType> sensitivity;
        @Child(name="fMeasure", type={DecimalType.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="FScore of the GQ score", formalDefinition="Calculated fScore if the GQ score threshold was set to \"score\" field value.")
        protected List<DecimalType> fMeasure;
        private static final long serialVersionUID = 1923392132L;

        public List<IntegerType> getScore() {
            if (this.score == null) {
                this.score = new ArrayList<IntegerType>();
            }
            return this.score;
        }

        public MolecularSequenceQualityRocComponent setScore(List<IntegerType> theScore) {
            this.score = theScore;
            return this;
        }

        public boolean hasScore() {
            if (this.score == null) {
                return false;
            }
            for (IntegerType item : this.score) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IntegerType addScoreElement() {
            IntegerType t = new IntegerType();
            if (this.score == null) {
                this.score = new ArrayList<IntegerType>();
            }
            this.score.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addScore(int value) {
            IntegerType t = new IntegerType();
            t.setValue((Object)value);
            if (this.score == null) {
                this.score = new ArrayList<IntegerType>();
            }
            this.score.add(t);
            return this;
        }

        public boolean hasScore(int value) {
            if (this.score == null) {
                return false;
            }
            for (IntegerType v : this.score) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<IntegerType> getNumTP() {
            if (this.numTP == null) {
                this.numTP = new ArrayList<IntegerType>();
            }
            return this.numTP;
        }

        public MolecularSequenceQualityRocComponent setNumTP(List<IntegerType> theNumTP) {
            this.numTP = theNumTP;
            return this;
        }

        public boolean hasNumTP() {
            if (this.numTP == null) {
                return false;
            }
            for (IntegerType item : this.numTP) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IntegerType addNumTPElement() {
            IntegerType t = new IntegerType();
            if (this.numTP == null) {
                this.numTP = new ArrayList<IntegerType>();
            }
            this.numTP.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addNumTP(int value) {
            IntegerType t = new IntegerType();
            t.setValue((Object)value);
            if (this.numTP == null) {
                this.numTP = new ArrayList<IntegerType>();
            }
            this.numTP.add(t);
            return this;
        }

        public boolean hasNumTP(int value) {
            if (this.numTP == null) {
                return false;
            }
            for (IntegerType v : this.numTP) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<IntegerType> getNumFP() {
            if (this.numFP == null) {
                this.numFP = new ArrayList<IntegerType>();
            }
            return this.numFP;
        }

        public MolecularSequenceQualityRocComponent setNumFP(List<IntegerType> theNumFP) {
            this.numFP = theNumFP;
            return this;
        }

        public boolean hasNumFP() {
            if (this.numFP == null) {
                return false;
            }
            for (IntegerType item : this.numFP) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IntegerType addNumFPElement() {
            IntegerType t = new IntegerType();
            if (this.numFP == null) {
                this.numFP = new ArrayList<IntegerType>();
            }
            this.numFP.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addNumFP(int value) {
            IntegerType t = new IntegerType();
            t.setValue((Object)value);
            if (this.numFP == null) {
                this.numFP = new ArrayList<IntegerType>();
            }
            this.numFP.add(t);
            return this;
        }

        public boolean hasNumFP(int value) {
            if (this.numFP == null) {
                return false;
            }
            for (IntegerType v : this.numFP) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<IntegerType> getNumFN() {
            if (this.numFN == null) {
                this.numFN = new ArrayList<IntegerType>();
            }
            return this.numFN;
        }

        public MolecularSequenceQualityRocComponent setNumFN(List<IntegerType> theNumFN) {
            this.numFN = theNumFN;
            return this;
        }

        public boolean hasNumFN() {
            if (this.numFN == null) {
                return false;
            }
            for (IntegerType item : this.numFN) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IntegerType addNumFNElement() {
            IntegerType t = new IntegerType();
            if (this.numFN == null) {
                this.numFN = new ArrayList<IntegerType>();
            }
            this.numFN.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addNumFN(int value) {
            IntegerType t = new IntegerType();
            t.setValue((Object)value);
            if (this.numFN == null) {
                this.numFN = new ArrayList<IntegerType>();
            }
            this.numFN.add(t);
            return this;
        }

        public boolean hasNumFN(int value) {
            if (this.numFN == null) {
                return false;
            }
            for (IntegerType v : this.numFN) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<DecimalType> getPrecision() {
            if (this.precision == null) {
                this.precision = new ArrayList<DecimalType>();
            }
            return this.precision;
        }

        public MolecularSequenceQualityRocComponent setPrecision(List<DecimalType> thePrecision) {
            this.precision = thePrecision;
            return this;
        }

        public boolean hasPrecision() {
            if (this.precision == null) {
                return false;
            }
            for (DecimalType item : this.precision) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DecimalType addPrecisionElement() {
            DecimalType t = new DecimalType();
            if (this.precision == null) {
                this.precision = new ArrayList<DecimalType>();
            }
            this.precision.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addPrecision(BigDecimal value) {
            DecimalType t = new DecimalType();
            t.setValue(value);
            if (this.precision == null) {
                this.precision = new ArrayList<DecimalType>();
            }
            this.precision.add(t);
            return this;
        }

        public boolean hasPrecision(BigDecimal value) {
            if (this.precision == null) {
                return false;
            }
            for (DecimalType v : this.precision) {
                if (!((BigDecimal)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<DecimalType> getSensitivity() {
            if (this.sensitivity == null) {
                this.sensitivity = new ArrayList<DecimalType>();
            }
            return this.sensitivity;
        }

        public MolecularSequenceQualityRocComponent setSensitivity(List<DecimalType> theSensitivity) {
            this.sensitivity = theSensitivity;
            return this;
        }

        public boolean hasSensitivity() {
            if (this.sensitivity == null) {
                return false;
            }
            for (DecimalType item : this.sensitivity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DecimalType addSensitivityElement() {
            DecimalType t = new DecimalType();
            if (this.sensitivity == null) {
                this.sensitivity = new ArrayList<DecimalType>();
            }
            this.sensitivity.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addSensitivity(BigDecimal value) {
            DecimalType t = new DecimalType();
            t.setValue(value);
            if (this.sensitivity == null) {
                this.sensitivity = new ArrayList<DecimalType>();
            }
            this.sensitivity.add(t);
            return this;
        }

        public boolean hasSensitivity(BigDecimal value) {
            if (this.sensitivity == null) {
                return false;
            }
            for (DecimalType v : this.sensitivity) {
                if (!((BigDecimal)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<DecimalType> getFMeasure() {
            if (this.fMeasure == null) {
                this.fMeasure = new ArrayList<DecimalType>();
            }
            return this.fMeasure;
        }

        public MolecularSequenceQualityRocComponent setFMeasure(List<DecimalType> theFMeasure) {
            this.fMeasure = theFMeasure;
            return this;
        }

        public boolean hasFMeasure() {
            if (this.fMeasure == null) {
                return false;
            }
            for (DecimalType item : this.fMeasure) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DecimalType addFMeasureElement() {
            DecimalType t = new DecimalType();
            if (this.fMeasure == null) {
                this.fMeasure = new ArrayList<DecimalType>();
            }
            this.fMeasure.add(t);
            return t;
        }

        public MolecularSequenceQualityRocComponent addFMeasure(BigDecimal value) {
            DecimalType t = new DecimalType();
            t.setValue(value);
            if (this.fMeasure == null) {
                this.fMeasure = new ArrayList<DecimalType>();
            }
            this.fMeasure.add(t);
            return this;
        }

        public boolean hasFMeasure(BigDecimal value) {
            if (this.fMeasure == null) {
                return false;
            }
            for (DecimalType v : this.fMeasure) {
                if (!((BigDecimal)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("score", "integer", "Invidual data point representing the GQ (genotype quality) score threshold.", 0, Integer.MAX_VALUE, this.score));
            children.add(new Property("numTP", "integer", "The number of true positives if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.numTP));
            children.add(new Property("numFP", "integer", "The number of false positives if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.numFP));
            children.add(new Property("numFN", "integer", "The number of false negatives if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.numFN));
            children.add(new Property("precision", "decimal", "Calculated precision if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.precision));
            children.add(new Property("sensitivity", "decimal", "Calculated sensitivity if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.sensitivity));
            children.add(new Property("fMeasure", "decimal", "Calculated fScore if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.fMeasure));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109264530: {
                    return new Property("score", "integer", "Invidual data point representing the GQ (genotype quality) score threshold.", 0, Integer.MAX_VALUE, this.score);
                }
                case 105180290: {
                    return new Property("numTP", "integer", "The number of true positives if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.numTP);
                }
                case 105179856: {
                    return new Property("numFP", "integer", "The number of false positives if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.numFP);
                }
                case 105179854: {
                    return new Property("numFN", "integer", "The number of false negatives if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.numFN);
                }
                case -1376177026: {
                    return new Property("precision", "decimal", "Calculated precision if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.precision);
                }
                case 564403871: {
                    return new Property("sensitivity", "decimal", "Calculated sensitivity if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.sensitivity);
                }
                case -18997736: {
                    return new Property("fMeasure", "decimal", "Calculated fScore if the GQ score threshold was set to \"score\" field value.", 0, Integer.MAX_VALUE, this.fMeasure);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109264530: {
                    return this.score == null ? new Base[]{} : this.score.toArray(new Base[this.score.size()]);
                }
                case 105180290: {
                    return this.numTP == null ? new Base[]{} : this.numTP.toArray(new Base[this.numTP.size()]);
                }
                case 105179856: {
                    return this.numFP == null ? new Base[]{} : this.numFP.toArray(new Base[this.numFP.size()]);
                }
                case 105179854: {
                    return this.numFN == null ? new Base[]{} : this.numFN.toArray(new Base[this.numFN.size()]);
                }
                case -1376177026: {
                    return this.precision == null ? new Base[]{} : this.precision.toArray(new Base[this.precision.size()]);
                }
                case 564403871: {
                    return this.sensitivity == null ? new Base[]{} : this.sensitivity.toArray(new Base[this.sensitivity.size()]);
                }
                case -18997736: {
                    return this.fMeasure == null ? new Base[]{} : this.fMeasure.toArray(new Base[this.fMeasure.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109264530: {
                    this.getScore().add(this.castToInteger(value));
                    return value;
                }
                case 105180290: {
                    this.getNumTP().add(this.castToInteger(value));
                    return value;
                }
                case 105179856: {
                    this.getNumFP().add(this.castToInteger(value));
                    return value;
                }
                case 105179854: {
                    this.getNumFN().add(this.castToInteger(value));
                    return value;
                }
                case -1376177026: {
                    this.getPrecision().add(this.castToDecimal(value));
                    return value;
                }
                case 564403871: {
                    this.getSensitivity().add(this.castToDecimal(value));
                    return value;
                }
                case -18997736: {
                    this.getFMeasure().add(this.castToDecimal(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("score")) {
                this.getScore().add(this.castToInteger(value));
            } else if (name.equals("numTP")) {
                this.getNumTP().add(this.castToInteger(value));
            } else if (name.equals("numFP")) {
                this.getNumFP().add(this.castToInteger(value));
            } else if (name.equals("numFN")) {
                this.getNumFN().add(this.castToInteger(value));
            } else if (name.equals("precision")) {
                this.getPrecision().add(this.castToDecimal(value));
            } else if (name.equals("sensitivity")) {
                this.getSensitivity().add(this.castToDecimal(value));
            } else if (name.equals("fMeasure")) {
                this.getFMeasure().add(this.castToDecimal(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109264530: {
                    return this.addScoreElement();
                }
                case 105180290: {
                    return this.addNumTPElement();
                }
                case 105179856: {
                    return this.addNumFPElement();
                }
                case 105179854: {
                    return this.addNumFNElement();
                }
                case -1376177026: {
                    return this.addPrecisionElement();
                }
                case 564403871: {
                    return this.addSensitivityElement();
                }
                case -18997736: {
                    return this.addFMeasureElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109264530: {
                    return new String[]{"integer"};
                }
                case 105180290: {
                    return new String[]{"integer"};
                }
                case 105179856: {
                    return new String[]{"integer"};
                }
                case 105179854: {
                    return new String[]{"integer"};
                }
                case -1376177026: {
                    return new String[]{"decimal"};
                }
                case 564403871: {
                    return new String[]{"decimal"};
                }
                case -18997736: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("score")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.score");
            }
            if (name.equals("numTP")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.numTP");
            }
            if (name.equals("numFP")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.numFP");
            }
            if (name.equals("numFN")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.numFN");
            }
            if (name.equals("precision")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.precision");
            }
            if (name.equals("sensitivity")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.sensitivity");
            }
            if (name.equals("fMeasure")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.fMeasure");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceQualityRocComponent copy() {
            MolecularSequenceQualityRocComponent dst = new MolecularSequenceQualityRocComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceQualityRocComponent dst) {
            super.copyValues(dst);
            if (this.score != null) {
                dst.score = new ArrayList<IntegerType>();
                for (IntegerType integerType : this.score) {
                    dst.score.add(integerType.copy());
                }
            }
            if (this.numTP != null) {
                dst.numTP = new ArrayList<IntegerType>();
                for (IntegerType integerType : this.numTP) {
                    dst.numTP.add(integerType.copy());
                }
            }
            if (this.numFP != null) {
                dst.numFP = new ArrayList<IntegerType>();
                for (IntegerType integerType : this.numFP) {
                    dst.numFP.add(integerType.copy());
                }
            }
            if (this.numFN != null) {
                dst.numFN = new ArrayList<IntegerType>();
                for (IntegerType integerType : this.numFN) {
                    dst.numFN.add(integerType.copy());
                }
            }
            if (this.precision != null) {
                dst.precision = new ArrayList<DecimalType>();
                for (DecimalType decimalType : this.precision) {
                    dst.precision.add(decimalType.copy());
                }
            }
            if (this.sensitivity != null) {
                dst.sensitivity = new ArrayList<DecimalType>();
                for (DecimalType decimalType : this.sensitivity) {
                    dst.sensitivity.add(decimalType.copy());
                }
            }
            if (this.fMeasure != null) {
                dst.fMeasure = new ArrayList<DecimalType>();
                for (DecimalType decimalType : this.fMeasure) {
                    dst.fMeasure.add(decimalType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceQualityRocComponent)) {
                return false;
            }
            MolecularSequenceQualityRocComponent o = (MolecularSequenceQualityRocComponent)other_;
            return MolecularSequenceQualityRocComponent.compareDeep(this.score, o.score, true) && MolecularSequenceQualityRocComponent.compareDeep(this.numTP, o.numTP, true) && MolecularSequenceQualityRocComponent.compareDeep(this.numFP, o.numFP, true) && MolecularSequenceQualityRocComponent.compareDeep(this.numFN, o.numFN, true) && MolecularSequenceQualityRocComponent.compareDeep(this.precision, o.precision, true) && MolecularSequenceQualityRocComponent.compareDeep(this.sensitivity, o.sensitivity, true) && MolecularSequenceQualityRocComponent.compareDeep(this.fMeasure, o.fMeasure, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceQualityRocComponent)) {
                return false;
            }
            MolecularSequenceQualityRocComponent o = (MolecularSequenceQualityRocComponent)other_;
            return MolecularSequenceQualityRocComponent.compareValues(this.score, o.score, true) && MolecularSequenceQualityRocComponent.compareValues(this.numTP, o.numTP, true) && MolecularSequenceQualityRocComponent.compareValues(this.numFP, o.numFP, true) && MolecularSequenceQualityRocComponent.compareValues(this.numFN, o.numFN, true) && MolecularSequenceQualityRocComponent.compareValues(this.precision, o.precision, true) && MolecularSequenceQualityRocComponent.compareValues(this.sensitivity, o.sensitivity, true) && MolecularSequenceQualityRocComponent.compareValues(this.fMeasure, o.fMeasure, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.score, this.numTP, this.numFP, this.numFN, this.precision, this.sensitivity, this.fMeasure});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.quality.roc";
        }
    }

    @Block
    public static class MolecularSequenceQualityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="indel | snp | unknown", formalDefinition="INDEL / SNP / Undefined variant.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/quality-type")
        protected Enumeration<QualityType> type;
        @Child(name="standardSequence", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Standard sequence for comparison", formalDefinition="Gold standard sequence used for comparing against.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/sequence-quality-standardSequence")
        protected CodeableConcept standardSequence;
        @Child(name="start", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Start position of the sequence", formalDefinition="Start position of the sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="End position of the sequence", formalDefinition="End position of the sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.")
        protected IntegerType end;
        @Child(name="score", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quality score for the comparison", formalDefinition="The score of an experimentally derived feature such as a p-value ([SO:0001685](http://www.sequenceontology.org/browser/current_svn/term/SO:0001685)).")
        protected Quantity score;
        @Child(name="method", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Method to get quality", formalDefinition="Which method is used to get sequence quality.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/sequence-quality-method")
        protected CodeableConcept method;
        @Child(name="truthTP", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="True positives from the perspective of the truth data", formalDefinition="True positives, from the perspective of the truth data, i.e. the number of sites in the Truth Call Set for which there are paths through the Query Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.")
        protected DecimalType truthTP;
        @Child(name="queryTP", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="True positives from the perspective of the query data", formalDefinition="True positives, from the perspective of the query data, i.e. the number of sites in the Query Call Set for which there are paths through the Truth Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.")
        protected DecimalType queryTP;
        @Child(name="truthFN", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="False negatives", formalDefinition="False negatives, i.e. the number of sites in the Truth Call Set for which there is no path through the Query Call Set that is consistent with all of the alleles at this site, or sites for which there is an inaccurate genotype call for the event. Sites with correct variant but incorrect genotype are counted here.")
        protected DecimalType truthFN;
        @Child(name="queryFP", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="False positives", formalDefinition="False positives, i.e. the number of sites in the Query Call Set for which there is no path through the Truth Call Set that is consistent with this site. Sites with correct variant but incorrect genotype are counted here.")
        protected DecimalType queryFP;
        @Child(name="gtFP", type={DecimalType.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="False positives where the non-REF alleles in the Truth and Query Call Sets match", formalDefinition="The number of false positives where the non-REF alleles in the Truth and Query Call Sets match (i.e. cases where the truth is 1/1 and the query is 0/1 or similar).")
        protected DecimalType gtFP;
        @Child(name="precision", type={DecimalType.class}, order=12, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Precision of comparison", formalDefinition="QUERY.TP / (QUERY.TP + QUERY.FP).")
        protected DecimalType precision;
        @Child(name="recall", type={DecimalType.class}, order=13, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Recall of comparison", formalDefinition="TRUTH.TP / (TRUTH.TP + TRUTH.FN).")
        protected DecimalType recall;
        @Child(name="fScore", type={DecimalType.class}, order=14, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="F-score", formalDefinition="Harmonic mean of Recall and Precision, computed as: 2 * precision * recall / (precision + recall).")
        protected DecimalType fScore;
        @Child(name="roc", type={}, order=15, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Receiver Operator Characteristic (ROC) Curve", formalDefinition="Receiver Operator Characteristic (ROC) Curve  to give sensitivity/specificity tradeoff.")
        protected MolecularSequenceQualityRocComponent roc;
        private static final long serialVersionUID = -811933526L;

        public MolecularSequenceQualityComponent() {
        }

        public MolecularSequenceQualityComponent(Enumeration<QualityType> type) {
            this.type = type;
        }

        public Enumeration<QualityType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<QualityType>(new QualityTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MolecularSequenceQualityComponent setTypeElement(Enumeration<QualityType> value) {
            this.type = value;
            return this;
        }

        public QualityType getType() {
            return this.type == null ? null : (QualityType)((Object)this.type.getValue());
        }

        public MolecularSequenceQualityComponent setType(QualityType value) {
            if (this.type == null) {
                this.type = new Enumeration<QualityType>(new QualityTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getStandardSequence() {
            if (this.standardSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.standardSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.standardSequence = new CodeableConcept();
                }
            }
            return this.standardSequence;
        }

        public boolean hasStandardSequence() {
            return this.standardSequence != null && !this.standardSequence.isEmpty();
        }

        public MolecularSequenceQualityComponent setStandardSequence(CodeableConcept value) {
            this.standardSequence = value;
            return this;
        }

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public MolecularSequenceQualityComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public MolecularSequenceQualityComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public MolecularSequenceQualityComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public MolecularSequenceQualityComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        public Quantity getScore() {
            if (this.score == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.score");
                }
                if (Configuration.doAutoCreate()) {
                    this.score = new Quantity();
                }
            }
            return this.score;
        }

        public boolean hasScore() {
            return this.score != null && !this.score.isEmpty();
        }

        public MolecularSequenceQualityComponent setScore(Quantity value) {
            this.score = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MolecularSequenceQualityComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public DecimalType getTruthTPElement() {
            if (this.truthTP == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.truthTP");
                }
                if (Configuration.doAutoCreate()) {
                    this.truthTP = new DecimalType();
                }
            }
            return this.truthTP;
        }

        public boolean hasTruthTPElement() {
            return this.truthTP != null && !this.truthTP.isEmpty();
        }

        public boolean hasTruthTP() {
            return this.truthTP != null && !this.truthTP.isEmpty();
        }

        public MolecularSequenceQualityComponent setTruthTPElement(DecimalType value) {
            this.truthTP = value;
            return this;
        }

        public BigDecimal getTruthTP() {
            return this.truthTP == null ? null : (BigDecimal)this.truthTP.getValue();
        }

        public MolecularSequenceQualityComponent setTruthTP(BigDecimal value) {
            if (value == null) {
                this.truthTP = null;
            } else {
                if (this.truthTP == null) {
                    this.truthTP = new DecimalType();
                }
                this.truthTP.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setTruthTP(long value) {
            this.truthTP = new DecimalType();
            this.truthTP.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setTruthTP(double value) {
            this.truthTP = new DecimalType();
            this.truthTP.setValue(value);
            return this;
        }

        public DecimalType getQueryTPElement() {
            if (this.queryTP == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.queryTP");
                }
                if (Configuration.doAutoCreate()) {
                    this.queryTP = new DecimalType();
                }
            }
            return this.queryTP;
        }

        public boolean hasQueryTPElement() {
            return this.queryTP != null && !this.queryTP.isEmpty();
        }

        public boolean hasQueryTP() {
            return this.queryTP != null && !this.queryTP.isEmpty();
        }

        public MolecularSequenceQualityComponent setQueryTPElement(DecimalType value) {
            this.queryTP = value;
            return this;
        }

        public BigDecimal getQueryTP() {
            return this.queryTP == null ? null : (BigDecimal)this.queryTP.getValue();
        }

        public MolecularSequenceQualityComponent setQueryTP(BigDecimal value) {
            if (value == null) {
                this.queryTP = null;
            } else {
                if (this.queryTP == null) {
                    this.queryTP = new DecimalType();
                }
                this.queryTP.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setQueryTP(long value) {
            this.queryTP = new DecimalType();
            this.queryTP.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setQueryTP(double value) {
            this.queryTP = new DecimalType();
            this.queryTP.setValue(value);
            return this;
        }

        public DecimalType getTruthFNElement() {
            if (this.truthFN == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.truthFN");
                }
                if (Configuration.doAutoCreate()) {
                    this.truthFN = new DecimalType();
                }
            }
            return this.truthFN;
        }

        public boolean hasTruthFNElement() {
            return this.truthFN != null && !this.truthFN.isEmpty();
        }

        public boolean hasTruthFN() {
            return this.truthFN != null && !this.truthFN.isEmpty();
        }

        public MolecularSequenceQualityComponent setTruthFNElement(DecimalType value) {
            this.truthFN = value;
            return this;
        }

        public BigDecimal getTruthFN() {
            return this.truthFN == null ? null : (BigDecimal)this.truthFN.getValue();
        }

        public MolecularSequenceQualityComponent setTruthFN(BigDecimal value) {
            if (value == null) {
                this.truthFN = null;
            } else {
                if (this.truthFN == null) {
                    this.truthFN = new DecimalType();
                }
                this.truthFN.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setTruthFN(long value) {
            this.truthFN = new DecimalType();
            this.truthFN.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setTruthFN(double value) {
            this.truthFN = new DecimalType();
            this.truthFN.setValue(value);
            return this;
        }

        public DecimalType getQueryFPElement() {
            if (this.queryFP == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.queryFP");
                }
                if (Configuration.doAutoCreate()) {
                    this.queryFP = new DecimalType();
                }
            }
            return this.queryFP;
        }

        public boolean hasQueryFPElement() {
            return this.queryFP != null && !this.queryFP.isEmpty();
        }

        public boolean hasQueryFP() {
            return this.queryFP != null && !this.queryFP.isEmpty();
        }

        public MolecularSequenceQualityComponent setQueryFPElement(DecimalType value) {
            this.queryFP = value;
            return this;
        }

        public BigDecimal getQueryFP() {
            return this.queryFP == null ? null : (BigDecimal)this.queryFP.getValue();
        }

        public MolecularSequenceQualityComponent setQueryFP(BigDecimal value) {
            if (value == null) {
                this.queryFP = null;
            } else {
                if (this.queryFP == null) {
                    this.queryFP = new DecimalType();
                }
                this.queryFP.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setQueryFP(long value) {
            this.queryFP = new DecimalType();
            this.queryFP.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setQueryFP(double value) {
            this.queryFP = new DecimalType();
            this.queryFP.setValue(value);
            return this;
        }

        public DecimalType getGtFPElement() {
            if (this.gtFP == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.gtFP");
                }
                if (Configuration.doAutoCreate()) {
                    this.gtFP = new DecimalType();
                }
            }
            return this.gtFP;
        }

        public boolean hasGtFPElement() {
            return this.gtFP != null && !this.gtFP.isEmpty();
        }

        public boolean hasGtFP() {
            return this.gtFP != null && !this.gtFP.isEmpty();
        }

        public MolecularSequenceQualityComponent setGtFPElement(DecimalType value) {
            this.gtFP = value;
            return this;
        }

        public BigDecimal getGtFP() {
            return this.gtFP == null ? null : (BigDecimal)this.gtFP.getValue();
        }

        public MolecularSequenceQualityComponent setGtFP(BigDecimal value) {
            if (value == null) {
                this.gtFP = null;
            } else {
                if (this.gtFP == null) {
                    this.gtFP = new DecimalType();
                }
                this.gtFP.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setGtFP(long value) {
            this.gtFP = new DecimalType();
            this.gtFP.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setGtFP(double value) {
            this.gtFP = new DecimalType();
            this.gtFP.setValue(value);
            return this;
        }

        public DecimalType getPrecisionElement() {
            if (this.precision == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.precision");
                }
                if (Configuration.doAutoCreate()) {
                    this.precision = new DecimalType();
                }
            }
            return this.precision;
        }

        public boolean hasPrecisionElement() {
            return this.precision != null && !this.precision.isEmpty();
        }

        public boolean hasPrecision() {
            return this.precision != null && !this.precision.isEmpty();
        }

        public MolecularSequenceQualityComponent setPrecisionElement(DecimalType value) {
            this.precision = value;
            return this;
        }

        public BigDecimal getPrecision() {
            return this.precision == null ? null : (BigDecimal)this.precision.getValue();
        }

        public MolecularSequenceQualityComponent setPrecision(BigDecimal value) {
            if (value == null) {
                this.precision = null;
            } else {
                if (this.precision == null) {
                    this.precision = new DecimalType();
                }
                this.precision.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setPrecision(long value) {
            this.precision = new DecimalType();
            this.precision.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setPrecision(double value) {
            this.precision = new DecimalType();
            this.precision.setValue(value);
            return this;
        }

        public DecimalType getRecallElement() {
            if (this.recall == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.recall");
                }
                if (Configuration.doAutoCreate()) {
                    this.recall = new DecimalType();
                }
            }
            return this.recall;
        }

        public boolean hasRecallElement() {
            return this.recall != null && !this.recall.isEmpty();
        }

        public boolean hasRecall() {
            return this.recall != null && !this.recall.isEmpty();
        }

        public MolecularSequenceQualityComponent setRecallElement(DecimalType value) {
            this.recall = value;
            return this;
        }

        public BigDecimal getRecall() {
            return this.recall == null ? null : (BigDecimal)this.recall.getValue();
        }

        public MolecularSequenceQualityComponent setRecall(BigDecimal value) {
            if (value == null) {
                this.recall = null;
            } else {
                if (this.recall == null) {
                    this.recall = new DecimalType();
                }
                this.recall.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setRecall(long value) {
            this.recall = new DecimalType();
            this.recall.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setRecall(double value) {
            this.recall = new DecimalType();
            this.recall.setValue(value);
            return this;
        }

        public DecimalType getFScoreElement() {
            if (this.fScore == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.fScore");
                }
                if (Configuration.doAutoCreate()) {
                    this.fScore = new DecimalType();
                }
            }
            return this.fScore;
        }

        public boolean hasFScoreElement() {
            return this.fScore != null && !this.fScore.isEmpty();
        }

        public boolean hasFScore() {
            return this.fScore != null && !this.fScore.isEmpty();
        }

        public MolecularSequenceQualityComponent setFScoreElement(DecimalType value) {
            this.fScore = value;
            return this;
        }

        public BigDecimal getFScore() {
            return this.fScore == null ? null : (BigDecimal)this.fScore.getValue();
        }

        public MolecularSequenceQualityComponent setFScore(BigDecimal value) {
            if (value == null) {
                this.fScore = null;
            } else {
                if (this.fScore == null) {
                    this.fScore = new DecimalType();
                }
                this.fScore.setValue(value);
            }
            return this;
        }

        public MolecularSequenceQualityComponent setFScore(long value) {
            this.fScore = new DecimalType();
            this.fScore.setValue(value);
            return this;
        }

        public MolecularSequenceQualityComponent setFScore(double value) {
            this.fScore = new DecimalType();
            this.fScore.setValue(value);
            return this;
        }

        public MolecularSequenceQualityRocComponent getRoc() {
            if (this.roc == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceQualityComponent.roc");
                }
                if (Configuration.doAutoCreate()) {
                    this.roc = new MolecularSequenceQualityRocComponent();
                }
            }
            return this.roc;
        }

        public boolean hasRoc() {
            return this.roc != null && !this.roc.isEmpty();
        }

        public MolecularSequenceQualityComponent setRoc(MolecularSequenceQualityRocComponent value) {
            this.roc = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MolecularSequence.SP_TYPE, "code", "INDEL / SNP / Undefined variant.", 0, 1, this.type));
            children.add(new Property("standardSequence", "CodeableConcept", "Gold standard sequence used for comparing against.", 0, 1, this.standardSequence));
            children.add(new Property("start", "integer", "Start position of the sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start));
            children.add(new Property("end", "integer", "End position of the sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end));
            children.add(new Property("score", "Quantity", "The score of an experimentally derived feature such as a p-value ([SO:0001685](http://www.sequenceontology.org/browser/current_svn/term/SO:0001685)).", 0, 1, this.score));
            children.add(new Property("method", "CodeableConcept", "Which method is used to get sequence quality.", 0, 1, this.method));
            children.add(new Property("truthTP", "decimal", "True positives, from the perspective of the truth data, i.e. the number of sites in the Truth Call Set for which there are paths through the Query Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.", 0, 1, this.truthTP));
            children.add(new Property("queryTP", "decimal", "True positives, from the perspective of the query data, i.e. the number of sites in the Query Call Set for which there are paths through the Truth Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.", 0, 1, this.queryTP));
            children.add(new Property("truthFN", "decimal", "False negatives, i.e. the number of sites in the Truth Call Set for which there is no path through the Query Call Set that is consistent with all of the alleles at this site, or sites for which there is an inaccurate genotype call for the event. Sites with correct variant but incorrect genotype are counted here.", 0, 1, this.truthFN));
            children.add(new Property("queryFP", "decimal", "False positives, i.e. the number of sites in the Query Call Set for which there is no path through the Truth Call Set that is consistent with this site. Sites with correct variant but incorrect genotype are counted here.", 0, 1, this.queryFP));
            children.add(new Property("gtFP", "decimal", "The number of false positives where the non-REF alleles in the Truth and Query Call Sets match (i.e. cases where the truth is 1/1 and the query is 0/1 or similar).", 0, 1, this.gtFP));
            children.add(new Property("precision", "decimal", "QUERY.TP / (QUERY.TP + QUERY.FP).", 0, 1, this.precision));
            children.add(new Property("recall", "decimal", "TRUTH.TP / (TRUTH.TP + TRUTH.FN).", 0, 1, this.recall));
            children.add(new Property("fScore", "decimal", "Harmonic mean of Recall and Precision, computed as: 2 * precision * recall / (precision + recall).", 0, 1, this.fScore));
            children.add(new Property("roc", "", "Receiver Operator Characteristic (ROC) Curve  to give sensitivity/specificity tradeoff.", 0, 1, this.roc));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MolecularSequence.SP_TYPE, "code", "INDEL / SNP / Undefined variant.", 0, 1, this.type);
                }
                case -1861227106: {
                    return new Property("standardSequence", "CodeableConcept", "Gold standard sequence used for comparing against.", 0, 1, this.standardSequence);
                }
                case 109757538: {
                    return new Property("start", "integer", "Start position of the sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start);
                }
                case 100571: {
                    return new Property("end", "integer", "End position of the sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end);
                }
                case 109264530: {
                    return new Property("score", "Quantity", "The score of an experimentally derived feature such as a p-value ([SO:0001685](http://www.sequenceontology.org/browser/current_svn/term/SO:0001685)).", 0, 1, this.score);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "Which method is used to get sequence quality.", 0, 1, this.method);
                }
                case -1048421849: {
                    return new Property("truthTP", "decimal", "True positives, from the perspective of the truth data, i.e. the number of sites in the Truth Call Set for which there are paths through the Query Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.", 0, 1, this.truthTP);
                }
                case 655102276: {
                    return new Property("queryTP", "decimal", "True positives, from the perspective of the query data, i.e. the number of sites in the Query Call Set for which there are paths through the Truth Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.", 0, 1, this.queryTP);
                }
                case -1048422285: {
                    return new Property("truthFN", "decimal", "False negatives, i.e. the number of sites in the Truth Call Set for which there is no path through the Query Call Set that is consistent with all of the alleles at this site, or sites for which there is an inaccurate genotype call for the event. Sites with correct variant but incorrect genotype are counted here.", 0, 1, this.truthFN);
                }
                case 655101842: {
                    return new Property("queryFP", "decimal", "False positives, i.e. the number of sites in the Query Call Set for which there is no path through the Truth Call Set that is consistent with this site. Sites with correct variant but incorrect genotype are counted here.", 0, 1, this.queryFP);
                }
                case 3182199: {
                    return new Property("gtFP", "decimal", "The number of false positives where the non-REF alleles in the Truth and Query Call Sets match (i.e. cases where the truth is 1/1 and the query is 0/1 or similar).", 0, 1, this.gtFP);
                }
                case -1376177026: {
                    return new Property("precision", "decimal", "QUERY.TP / (QUERY.TP + QUERY.FP).", 0, 1, this.precision);
                }
                case -934922479: {
                    return new Property("recall", "decimal", "TRUTH.TP / (TRUTH.TP + TRUTH.FN).", 0, 1, this.recall);
                }
                case -1295082036: {
                    return new Property("fScore", "decimal", "Harmonic mean of Recall and Precision, computed as: 2 * precision * recall / (precision + recall).", 0, 1, this.fScore);
                }
                case 113094: {
                    return new Property("roc", "", "Receiver Operator Characteristic (ROC) Curve  to give sensitivity/specificity tradeoff.", 0, 1, this.roc);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1861227106: {
                    Base[] baseArray;
                    if (this.standardSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.standardSequence;
                    }
                    return baseArray;
                }
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.end;
                    }
                    return baseArray;
                }
                case 109264530: {
                    Base[] baseArray;
                    if (this.score == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.score;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.method;
                    }
                    return baseArray;
                }
                case -1048421849: {
                    Base[] baseArray;
                    if (this.truthTP == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.truthTP;
                    }
                    return baseArray;
                }
                case 655102276: {
                    Base[] baseArray;
                    if (this.queryTP == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.queryTP;
                    }
                    return baseArray;
                }
                case -1048422285: {
                    Base[] baseArray;
                    if (this.truthFN == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.truthFN;
                    }
                    return baseArray;
                }
                case 655101842: {
                    Base[] baseArray;
                    if (this.queryFP == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.queryFP;
                    }
                    return baseArray;
                }
                case 3182199: {
                    Base[] baseArray;
                    if (this.gtFP == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.gtFP;
                    }
                    return baseArray;
                }
                case -1376177026: {
                    Base[] baseArray;
                    if (this.precision == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.precision;
                    }
                    return baseArray;
                }
                case -934922479: {
                    Base[] baseArray;
                    if (this.recall == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.recall;
                    }
                    return baseArray;
                }
                case -1295082036: {
                    Base[] baseArray;
                    if (this.fScore == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.fScore;
                    }
                    return baseArray;
                }
                case 113094: {
                    Base[] baseArray;
                    if (this.roc == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.roc;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new QualityTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -1861227106: {
                    this.standardSequence = this.castToCodeableConcept(value);
                    return value;
                }
                case 109757538: {
                    this.start = this.castToInteger(value);
                    return value;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    return value;
                }
                case 109264530: {
                    this.score = this.castToQuantity(value);
                    return value;
                }
                case -1077554975: {
                    this.method = this.castToCodeableConcept(value);
                    return value;
                }
                case -1048421849: {
                    this.truthTP = this.castToDecimal(value);
                    return value;
                }
                case 655102276: {
                    this.queryTP = this.castToDecimal(value);
                    return value;
                }
                case -1048422285: {
                    this.truthFN = this.castToDecimal(value);
                    return value;
                }
                case 655101842: {
                    this.queryFP = this.castToDecimal(value);
                    return value;
                }
                case 3182199: {
                    this.gtFP = this.castToDecimal(value);
                    return value;
                }
                case -1376177026: {
                    this.precision = this.castToDecimal(value);
                    return value;
                }
                case -934922479: {
                    this.recall = this.castToDecimal(value);
                    return value;
                }
                case -1295082036: {
                    this.fScore = this.castToDecimal(value);
                    return value;
                }
                case 113094: {
                    this.roc = (MolecularSequenceQualityRocComponent)((Object)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MolecularSequence.SP_TYPE)) {
                value = new QualityTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("standardSequence")) {
                this.standardSequence = this.castToCodeableConcept(value);
            } else if (name.equals("start")) {
                this.start = this.castToInteger(value);
            } else if (name.equals("end")) {
                this.end = this.castToInteger(value);
            } else if (name.equals("score")) {
                this.score = this.castToQuantity(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("truthTP")) {
                this.truthTP = this.castToDecimal(value);
            } else if (name.equals("queryTP")) {
                this.queryTP = this.castToDecimal(value);
            } else if (name.equals("truthFN")) {
                this.truthFN = this.castToDecimal(value);
            } else if (name.equals("queryFP")) {
                this.queryFP = this.castToDecimal(value);
            } else if (name.equals("gtFP")) {
                this.gtFP = this.castToDecimal(value);
            } else if (name.equals("precision")) {
                this.precision = this.castToDecimal(value);
            } else if (name.equals("recall")) {
                this.recall = this.castToDecimal(value);
            } else if (name.equals("fScore")) {
                this.fScore = this.castToDecimal(value);
            } else if (name.equals("roc")) {
                this.roc = (MolecularSequenceQualityRocComponent)((Object)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -1861227106: {
                    return this.getStandardSequence();
                }
                case 109757538: {
                    return this.getStartElement();
                }
                case 100571: {
                    return this.getEndElement();
                }
                case 109264530: {
                    return this.getScore();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case -1048421849: {
                    return this.getTruthTPElement();
                }
                case 655102276: {
                    return this.getQueryTPElement();
                }
                case -1048422285: {
                    return this.getTruthFNElement();
                }
                case 655101842: {
                    return this.getQueryFPElement();
                }
                case 3182199: {
                    return this.getGtFPElement();
                }
                case -1376177026: {
                    return this.getPrecisionElement();
                }
                case -934922479: {
                    return this.getRecallElement();
                }
                case -1295082036: {
                    return this.getFScoreElement();
                }
                case 113094: {
                    return this.getRoc();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -1861227106: {
                    return new String[]{"CodeableConcept"};
                }
                case 109757538: {
                    return new String[]{"integer"};
                }
                case 100571: {
                    return new String[]{"integer"};
                }
                case 109264530: {
                    return new String[]{"Quantity"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case -1048421849: {
                    return new String[]{"decimal"};
                }
                case 655102276: {
                    return new String[]{"decimal"};
                }
                case -1048422285: {
                    return new String[]{"decimal"};
                }
                case 655101842: {
                    return new String[]{"decimal"};
                }
                case 3182199: {
                    return new String[]{"decimal"};
                }
                case -1376177026: {
                    return new String[]{"decimal"};
                }
                case -934922479: {
                    return new String[]{"decimal"};
                }
                case -1295082036: {
                    return new String[]{"decimal"};
                }
                case 113094: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MolecularSequence.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.type");
            }
            if (name.equals("standardSequence")) {
                this.standardSequence = new CodeableConcept();
                return this.standardSequence;
            }
            if (name.equals("start")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.start");
            }
            if (name.equals("end")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.end");
            }
            if (name.equals("score")) {
                this.score = new Quantity();
                return this.score;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("truthTP")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.truthTP");
            }
            if (name.equals("queryTP")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.queryTP");
            }
            if (name.equals("truthFN")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.truthFN");
            }
            if (name.equals("queryFP")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.queryFP");
            }
            if (name.equals("gtFP")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.gtFP");
            }
            if (name.equals("precision")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.precision");
            }
            if (name.equals("recall")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.recall");
            }
            if (name.equals("fScore")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.fScore");
            }
            if (name.equals("roc")) {
                this.roc = new MolecularSequenceQualityRocComponent();
                return this.roc;
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceQualityComponent copy() {
            MolecularSequenceQualityComponent dst = new MolecularSequenceQualityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceQualityComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.standardSequence = this.standardSequence == null ? null : this.standardSequence.copy();
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            dst.score = this.score == null ? null : this.score.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.truthTP = this.truthTP == null ? null : this.truthTP.copy();
            dst.queryTP = this.queryTP == null ? null : this.queryTP.copy();
            dst.truthFN = this.truthFN == null ? null : this.truthFN.copy();
            dst.queryFP = this.queryFP == null ? null : this.queryFP.copy();
            dst.gtFP = this.gtFP == null ? null : this.gtFP.copy();
            dst.precision = this.precision == null ? null : this.precision.copy();
            dst.recall = this.recall == null ? null : this.recall.copy();
            dst.fScore = this.fScore == null ? null : this.fScore.copy();
            dst.roc = this.roc == null ? null : this.roc.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceQualityComponent)) {
                return false;
            }
            MolecularSequenceQualityComponent o = (MolecularSequenceQualityComponent)other_;
            return MolecularSequenceQualityComponent.compareDeep(this.type, o.type, true) && MolecularSequenceQualityComponent.compareDeep(this.standardSequence, o.standardSequence, true) && MolecularSequenceQualityComponent.compareDeep(this.start, o.start, true) && MolecularSequenceQualityComponent.compareDeep(this.end, o.end, true) && MolecularSequenceQualityComponent.compareDeep(this.score, o.score, true) && MolecularSequenceQualityComponent.compareDeep(this.method, o.method, true) && MolecularSequenceQualityComponent.compareDeep(this.truthTP, o.truthTP, true) && MolecularSequenceQualityComponent.compareDeep(this.queryTP, o.queryTP, true) && MolecularSequenceQualityComponent.compareDeep(this.truthFN, o.truthFN, true) && MolecularSequenceQualityComponent.compareDeep(this.queryFP, o.queryFP, true) && MolecularSequenceQualityComponent.compareDeep(this.gtFP, o.gtFP, true) && MolecularSequenceQualityComponent.compareDeep(this.precision, o.precision, true) && MolecularSequenceQualityComponent.compareDeep(this.recall, o.recall, true) && MolecularSequenceQualityComponent.compareDeep(this.fScore, o.fScore, true) && MolecularSequenceQualityComponent.compareDeep(this.roc, o.roc, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceQualityComponent)) {
                return false;
            }
            MolecularSequenceQualityComponent o = (MolecularSequenceQualityComponent)other_;
            return MolecularSequenceQualityComponent.compareValues(this.type, o.type, true) && MolecularSequenceQualityComponent.compareValues(this.start, o.start, true) && MolecularSequenceQualityComponent.compareValues(this.end, o.end, true) && MolecularSequenceQualityComponent.compareValues(this.truthTP, o.truthTP, true) && MolecularSequenceQualityComponent.compareValues(this.queryTP, o.queryTP, true) && MolecularSequenceQualityComponent.compareValues(this.truthFN, o.truthFN, true) && MolecularSequenceQualityComponent.compareValues(this.queryFP, o.queryFP, true) && MolecularSequenceQualityComponent.compareValues(this.gtFP, o.gtFP, true) && MolecularSequenceQualityComponent.compareValues(this.precision, o.precision, true) && MolecularSequenceQualityComponent.compareValues(this.recall, o.recall, true) && MolecularSequenceQualityComponent.compareValues(this.fScore, o.fScore, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.standardSequence, this.start, this.end, this.score, this.method, this.truthTP, this.queryTP, this.truthFN, this.queryFP, this.gtFP, this.precision, this.recall, this.fScore, this.roc});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.quality";
        }
    }

    @Block
    public static class MolecularSequenceVariantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Start position of the variant on the  reference sequence", formalDefinition="Start position of the variant on the  reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="End position of the variant on the reference sequence", formalDefinition="End position of the variant on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.")
        protected IntegerType end;
        @Child(name="observedAllele", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allele that was observed", formalDefinition="An allele is one of a set of coexisting sequence variants of a gene ([SO:0001023](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).  Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed  sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.")
        protected StringType observedAllele;
        @Child(name="referenceAllele", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allele in the reference sequence", formalDefinition="An allele is one of a set of coexisting sequence variants of a gene ([SO:0001023](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)). Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the reference sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.")
        protected StringType referenceAllele;
        @Child(name="cigar", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Extended CIGAR string for aligning the sequence with reference bases", formalDefinition="Extended CIGAR string for aligning the sequence with reference bases. See detailed documentation [here](http://support.illumina.com/help/SequencingAnalysisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_ExtendedCIGARFormat.htm).")
        protected StringType cigar;
        @Child(name="variantPointer", type={Observation.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Pointer to observed variant information", formalDefinition="A pointer to an Observation containing variant information.")
        protected Reference variantPointer;
        private static final long serialVersionUID = -1012918644L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceVariantComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public MolecularSequenceVariantComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public MolecularSequenceVariantComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceVariantComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public MolecularSequenceVariantComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public MolecularSequenceVariantComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        public StringType getObservedAlleleElement() {
            if (this.observedAllele == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceVariantComponent.observedAllele");
                }
                if (Configuration.doAutoCreate()) {
                    this.observedAllele = new StringType();
                }
            }
            return this.observedAllele;
        }

        public boolean hasObservedAlleleElement() {
            return this.observedAllele != null && !this.observedAllele.isEmpty();
        }

        public boolean hasObservedAllele() {
            return this.observedAllele != null && !this.observedAllele.isEmpty();
        }

        public MolecularSequenceVariantComponent setObservedAlleleElement(StringType value) {
            this.observedAllele = value;
            return this;
        }

        public String getObservedAllele() {
            return this.observedAllele == null ? null : (String)this.observedAllele.getValue();
        }

        public MolecularSequenceVariantComponent setObservedAllele(String value) {
            if (Utilities.noString((String)value)) {
                this.observedAllele = null;
            } else {
                if (this.observedAllele == null) {
                    this.observedAllele = new StringType();
                }
                this.observedAllele.setValue(value);
            }
            return this;
        }

        public StringType getReferenceAlleleElement() {
            if (this.referenceAllele == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceVariantComponent.referenceAllele");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceAllele = new StringType();
                }
            }
            return this.referenceAllele;
        }

        public boolean hasReferenceAlleleElement() {
            return this.referenceAllele != null && !this.referenceAllele.isEmpty();
        }

        public boolean hasReferenceAllele() {
            return this.referenceAllele != null && !this.referenceAllele.isEmpty();
        }

        public MolecularSequenceVariantComponent setReferenceAlleleElement(StringType value) {
            this.referenceAllele = value;
            return this;
        }

        public String getReferenceAllele() {
            return this.referenceAllele == null ? null : (String)this.referenceAllele.getValue();
        }

        public MolecularSequenceVariantComponent setReferenceAllele(String value) {
            if (Utilities.noString((String)value)) {
                this.referenceAllele = null;
            } else {
                if (this.referenceAllele == null) {
                    this.referenceAllele = new StringType();
                }
                this.referenceAllele.setValue(value);
            }
            return this;
        }

        public StringType getCigarElement() {
            if (this.cigar == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceVariantComponent.cigar");
                }
                if (Configuration.doAutoCreate()) {
                    this.cigar = new StringType();
                }
            }
            return this.cigar;
        }

        public boolean hasCigarElement() {
            return this.cigar != null && !this.cigar.isEmpty();
        }

        public boolean hasCigar() {
            return this.cigar != null && !this.cigar.isEmpty();
        }

        public MolecularSequenceVariantComponent setCigarElement(StringType value) {
            this.cigar = value;
            return this;
        }

        public String getCigar() {
            return this.cigar == null ? null : (String)this.cigar.getValue();
        }

        public MolecularSequenceVariantComponent setCigar(String value) {
            if (Utilities.noString((String)value)) {
                this.cigar = null;
            } else {
                if (this.cigar == null) {
                    this.cigar = new StringType();
                }
                this.cigar.setValue(value);
            }
            return this;
        }

        public Reference getVariantPointer() {
            if (this.variantPointer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceVariantComponent.variantPointer");
                }
                if (Configuration.doAutoCreate()) {
                    this.variantPointer = new Reference();
                }
            }
            return this.variantPointer;
        }

        public boolean hasVariantPointer() {
            return this.variantPointer != null && !this.variantPointer.isEmpty();
        }

        public MolecularSequenceVariantComponent setVariantPointer(Reference value) {
            this.variantPointer = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("start", "integer", "Start position of the variant on the  reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start));
            children.add(new Property("end", "integer", "End position of the variant on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end));
            children.add(new Property("observedAllele", "string", "An allele is one of a set of coexisting sequence variants of a gene ([SO:0001023](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).  Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed  sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.observedAllele));
            children.add(new Property("referenceAllele", "string", "An allele is one of a set of coexisting sequence variants of a gene ([SO:0001023](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)). Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the reference sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.referenceAllele));
            children.add(new Property("cigar", "string", "Extended CIGAR string for aligning the sequence with reference bases. See detailed documentation [here](http://support.illumina.com/help/SequencingAnalysisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_ExtendedCIGARFormat.htm).", 0, 1, this.cigar));
            children.add(new Property("variantPointer", "Reference(Observation)", "A pointer to an Observation containing variant information.", 0, 1, this.variantPointer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109757538: {
                    return new Property("start", "integer", "Start position of the variant on the  reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start);
                }
                case 100571: {
                    return new Property("end", "integer", "End position of the variant on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end);
                }
                case -1418745787: {
                    return new Property("observedAllele", "string", "An allele is one of a set of coexisting sequence variants of a gene ([SO:0001023](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).  Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed  sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.observedAllele);
                }
                case 364045960: {
                    return new Property("referenceAllele", "string", "An allele is one of a set of coexisting sequence variants of a gene ([SO:0001023](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)). Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the reference sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.referenceAllele);
                }
                case 94658738: {
                    return new Property("cigar", "string", "Extended CIGAR string for aligning the sequence with reference bases. See detailed documentation [here](http://support.illumina.com/help/SequencingAnalysisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_ExtendedCIGARFormat.htm).", 0, 1, this.cigar);
                }
                case -1654319624: {
                    return new Property("variantPointer", "Reference(Observation)", "A pointer to an Observation containing variant information.", 0, 1, this.variantPointer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
                case -1418745787: {
                    Base[] baseArray;
                    if (this.observedAllele == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.observedAllele;
                    }
                    return baseArray;
                }
                case 364045960: {
                    Base[] baseArray;
                    if (this.referenceAllele == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.referenceAllele;
                    }
                    return baseArray;
                }
                case 94658738: {
                    Base[] baseArray;
                    if (this.cigar == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.cigar;
                    }
                    return baseArray;
                }
                case -1654319624: {
                    Base[] baseArray;
                    if (this.variantPointer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.variantPointer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    return value;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    return value;
                }
                case -1418745787: {
                    this.observedAllele = this.castToString(value);
                    return value;
                }
                case 364045960: {
                    this.referenceAllele = this.castToString(value);
                    return value;
                }
                case 94658738: {
                    this.cigar = this.castToString(value);
                    return value;
                }
                case -1654319624: {
                    this.variantPointer = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("start")) {
                this.start = this.castToInteger(value);
            } else if (name.equals("end")) {
                this.end = this.castToInteger(value);
            } else if (name.equals("observedAllele")) {
                this.observedAllele = this.castToString(value);
            } else if (name.equals("referenceAllele")) {
                this.referenceAllele = this.castToString(value);
            } else if (name.equals("cigar")) {
                this.cigar = this.castToString(value);
            } else if (name.equals("variantPointer")) {
                this.variantPointer = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return this.getStartElement();
                }
                case 100571: {
                    return this.getEndElement();
                }
                case -1418745787: {
                    return this.getObservedAlleleElement();
                }
                case 364045960: {
                    return this.getReferenceAlleleElement();
                }
                case 94658738: {
                    return this.getCigarElement();
                }
                case -1654319624: {
                    return this.getVariantPointer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return new String[]{"integer"};
                }
                case 100571: {
                    return new String[]{"integer"};
                }
                case -1418745787: {
                    return new String[]{"string"};
                }
                case 364045960: {
                    return new String[]{"string"};
                }
                case 94658738: {
                    return new String[]{"string"};
                }
                case -1654319624: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("start")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.start");
            }
            if (name.equals("end")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.end");
            }
            if (name.equals("observedAllele")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.observedAllele");
            }
            if (name.equals("referenceAllele")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.referenceAllele");
            }
            if (name.equals("cigar")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.cigar");
            }
            if (name.equals("variantPointer")) {
                this.variantPointer = new Reference();
                return this.variantPointer;
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceVariantComponent copy() {
            MolecularSequenceVariantComponent dst = new MolecularSequenceVariantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceVariantComponent dst) {
            super.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            dst.observedAllele = this.observedAllele == null ? null : this.observedAllele.copy();
            dst.referenceAllele = this.referenceAllele == null ? null : this.referenceAllele.copy();
            dst.cigar = this.cigar == null ? null : this.cigar.copy();
            dst.variantPointer = this.variantPointer == null ? null : this.variantPointer.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceVariantComponent)) {
                return false;
            }
            MolecularSequenceVariantComponent o = (MolecularSequenceVariantComponent)other_;
            return MolecularSequenceVariantComponent.compareDeep(this.start, o.start, true) && MolecularSequenceVariantComponent.compareDeep(this.end, o.end, true) && MolecularSequenceVariantComponent.compareDeep(this.observedAllele, o.observedAllele, true) && MolecularSequenceVariantComponent.compareDeep(this.referenceAllele, o.referenceAllele, true) && MolecularSequenceVariantComponent.compareDeep(this.cigar, o.cigar, true) && MolecularSequenceVariantComponent.compareDeep(this.variantPointer, o.variantPointer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceVariantComponent)) {
                return false;
            }
            MolecularSequenceVariantComponent o = (MolecularSequenceVariantComponent)other_;
            return MolecularSequenceVariantComponent.compareValues(this.start, o.start, true) && MolecularSequenceVariantComponent.compareValues(this.end, o.end, true) && MolecularSequenceVariantComponent.compareValues(this.observedAllele, o.observedAllele, true) && MolecularSequenceVariantComponent.compareValues(this.referenceAllele, o.referenceAllele, true) && MolecularSequenceVariantComponent.compareValues(this.cigar, o.cigar, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.start, this.end, this.observedAllele, this.referenceAllele, this.cigar, this.variantPointer});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.variant";
        }
    }

    @Block
    public static class MolecularSequenceReferenceSeqComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="chromosome", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Chromosome containing genetic finding", formalDefinition="Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/chromosome-human")
        protected CodeableConcept chromosome;
        @Child(name="genomeBuild", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'", formalDefinition="The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'.  Version number must be included if a versioned release of a primary build was used.")
        protected StringType genomeBuild;
        @Child(name="orientation", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="sense | antisense", formalDefinition="A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the \"sense\" strand, and the opposite complementary strand is the \"antisense\" strand.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/orientation-type")
        protected Enumeration<OrientationType> orientation;
        @Child(name="referenceSeqId", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference identifier", formalDefinition="Reference identifier of reference sequence submitted to NCBI. It must match the type in the MolecularSequence.type field. For example, the prefix, \u201cNG_\u201d identifies reference sequence for genes, \u201cNM_\u201d for messenger RNA transcripts, and \u201cNP_\u201d for amino acid sequences.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/sequence-referenceSeq")
        protected CodeableConcept referenceSeqId;
        @Child(name="referenceSeqPointer", type={MolecularSequence.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A pointer to another MolecularSequence entity as reference sequence", formalDefinition="A pointer to another MolecularSequence entity as reference sequence.")
        protected Reference referenceSeqPointer;
        @Child(name="referenceSeqString", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A string to represent reference sequence", formalDefinition="A string like \"ACGT\".")
        protected StringType referenceSeqString;
        @Child(name="strand", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="watson | crick", formalDefinition="An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/strand-type")
        protected Enumeration<StrandType> strand;
        @Child(name="windowStart", type={IntegerType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Start position of the window on the  reference sequence", formalDefinition="Start position of the window on the reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.")
        protected IntegerType windowStart;
        @Child(name="windowEnd", type={IntegerType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="End position of the window on the reference sequence", formalDefinition="End position of the window on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.")
        protected IntegerType windowEnd;
        private static final long serialVersionUID = -257666326L;

        public CodeableConcept getChromosome() {
            if (this.chromosome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.chromosome");
                }
                if (Configuration.doAutoCreate()) {
                    this.chromosome = new CodeableConcept();
                }
            }
            return this.chromosome;
        }

        public boolean hasChromosome() {
            return this.chromosome != null && !this.chromosome.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setChromosome(CodeableConcept value) {
            this.chromosome = value;
            return this;
        }

        public StringType getGenomeBuildElement() {
            if (this.genomeBuild == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.genomeBuild");
                }
                if (Configuration.doAutoCreate()) {
                    this.genomeBuild = new StringType();
                }
            }
            return this.genomeBuild;
        }

        public boolean hasGenomeBuildElement() {
            return this.genomeBuild != null && !this.genomeBuild.isEmpty();
        }

        public boolean hasGenomeBuild() {
            return this.genomeBuild != null && !this.genomeBuild.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setGenomeBuildElement(StringType value) {
            this.genomeBuild = value;
            return this;
        }

        public String getGenomeBuild() {
            return this.genomeBuild == null ? null : (String)this.genomeBuild.getValue();
        }

        public MolecularSequenceReferenceSeqComponent setGenomeBuild(String value) {
            if (Utilities.noString((String)value)) {
                this.genomeBuild = null;
            } else {
                if (this.genomeBuild == null) {
                    this.genomeBuild = new StringType();
                }
                this.genomeBuild.setValue(value);
            }
            return this;
        }

        public Enumeration<OrientationType> getOrientationElement() {
            if (this.orientation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.orientation");
                }
                if (Configuration.doAutoCreate()) {
                    this.orientation = new Enumeration<OrientationType>(new OrientationTypeEnumFactory());
                }
            }
            return this.orientation;
        }

        public boolean hasOrientationElement() {
            return this.orientation != null && !this.orientation.isEmpty();
        }

        public boolean hasOrientation() {
            return this.orientation != null && !this.orientation.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setOrientationElement(Enumeration<OrientationType> value) {
            this.orientation = value;
            return this;
        }

        public OrientationType getOrientation() {
            return this.orientation == null ? null : (OrientationType)((Object)this.orientation.getValue());
        }

        public MolecularSequenceReferenceSeqComponent setOrientation(OrientationType value) {
            if (value == null) {
                this.orientation = null;
            } else {
                if (this.orientation == null) {
                    this.orientation = new Enumeration<OrientationType>(new OrientationTypeEnumFactory());
                }
                this.orientation.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getReferenceSeqId() {
            if (this.referenceSeqId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.referenceSeqId");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqId = new CodeableConcept();
                }
            }
            return this.referenceSeqId;
        }

        public boolean hasReferenceSeqId() {
            return this.referenceSeqId != null && !this.referenceSeqId.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setReferenceSeqId(CodeableConcept value) {
            this.referenceSeqId = value;
            return this;
        }

        public Reference getReferenceSeqPointer() {
            if (this.referenceSeqPointer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.referenceSeqPointer");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqPointer = new Reference();
                }
            }
            return this.referenceSeqPointer;
        }

        public boolean hasReferenceSeqPointer() {
            return this.referenceSeqPointer != null && !this.referenceSeqPointer.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setReferenceSeqPointer(Reference value) {
            this.referenceSeqPointer = value;
            return this;
        }

        public StringType getReferenceSeqStringElement() {
            if (this.referenceSeqString == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.referenceSeqString");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqString = new StringType();
                }
            }
            return this.referenceSeqString;
        }

        public boolean hasReferenceSeqStringElement() {
            return this.referenceSeqString != null && !this.referenceSeqString.isEmpty();
        }

        public boolean hasReferenceSeqString() {
            return this.referenceSeqString != null && !this.referenceSeqString.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setReferenceSeqStringElement(StringType value) {
            this.referenceSeqString = value;
            return this;
        }

        public String getReferenceSeqString() {
            return this.referenceSeqString == null ? null : (String)this.referenceSeqString.getValue();
        }

        public MolecularSequenceReferenceSeqComponent setReferenceSeqString(String value) {
            if (Utilities.noString((String)value)) {
                this.referenceSeqString = null;
            } else {
                if (this.referenceSeqString == null) {
                    this.referenceSeqString = new StringType();
                }
                this.referenceSeqString.setValue(value);
            }
            return this;
        }

        public Enumeration<StrandType> getStrandElement() {
            if (this.strand == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.strand");
                }
                if (Configuration.doAutoCreate()) {
                    this.strand = new Enumeration<StrandType>(new StrandTypeEnumFactory());
                }
            }
            return this.strand;
        }

        public boolean hasStrandElement() {
            return this.strand != null && !this.strand.isEmpty();
        }

        public boolean hasStrand() {
            return this.strand != null && !this.strand.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setStrandElement(Enumeration<StrandType> value) {
            this.strand = value;
            return this;
        }

        public StrandType getStrand() {
            return this.strand == null ? null : (StrandType)((Object)this.strand.getValue());
        }

        public MolecularSequenceReferenceSeqComponent setStrand(StrandType value) {
            if (value == null) {
                this.strand = null;
            } else {
                if (this.strand == null) {
                    this.strand = new Enumeration<StrandType>(new StrandTypeEnumFactory());
                }
                this.strand.setValue((Object)value);
            }
            return this;
        }

        public IntegerType getWindowStartElement() {
            if (this.windowStart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.windowStart");
                }
                if (Configuration.doAutoCreate()) {
                    this.windowStart = new IntegerType();
                }
            }
            return this.windowStart;
        }

        public boolean hasWindowStartElement() {
            return this.windowStart != null && !this.windowStart.isEmpty();
        }

        public boolean hasWindowStart() {
            return this.windowStart != null && !this.windowStart.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setWindowStartElement(IntegerType value) {
            this.windowStart = value;
            return this;
        }

        public int getWindowStart() {
            return this.windowStart == null || this.windowStart.isEmpty() ? 0 : (Integer)this.windowStart.getValue();
        }

        public MolecularSequenceReferenceSeqComponent setWindowStart(int value) {
            if (this.windowStart == null) {
                this.windowStart = new IntegerType();
            }
            this.windowStart.setValue((Object)value);
            return this;
        }

        public IntegerType getWindowEndElement() {
            if (this.windowEnd == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceReferenceSeqComponent.windowEnd");
                }
                if (Configuration.doAutoCreate()) {
                    this.windowEnd = new IntegerType();
                }
            }
            return this.windowEnd;
        }

        public boolean hasWindowEndElement() {
            return this.windowEnd != null && !this.windowEnd.isEmpty();
        }

        public boolean hasWindowEnd() {
            return this.windowEnd != null && !this.windowEnd.isEmpty();
        }

        public MolecularSequenceReferenceSeqComponent setWindowEndElement(IntegerType value) {
            this.windowEnd = value;
            return this;
        }

        public int getWindowEnd() {
            return this.windowEnd == null || this.windowEnd.isEmpty() ? 0 : (Integer)this.windowEnd.getValue();
        }

        public MolecularSequenceReferenceSeqComponent setWindowEnd(int value) {
            if (this.windowEnd == null) {
                this.windowEnd = new IntegerType();
            }
            this.windowEnd.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MolecularSequence.SP_CHROMOSOME, "CodeableConcept", "Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).", 0, 1, this.chromosome));
            children.add(new Property("genomeBuild", "string", "The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'.  Version number must be included if a versioned release of a primary build was used.", 0, 1, this.genomeBuild));
            children.add(new Property("orientation", "code", "A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the \"sense\" strand, and the opposite complementary strand is the \"antisense\" strand.", 0, 1, this.orientation));
            children.add(new Property("referenceSeqId", "CodeableConcept", "Reference identifier of reference sequence submitted to NCBI. It must match the type in the MolecularSequence.type field. For example, the prefix, \u201cNG_\u201d identifies reference sequence for genes, \u201cNM_\u201d for messenger RNA transcripts, and \u201cNP_\u201d for amino acid sequences.", 0, 1, this.referenceSeqId));
            children.add(new Property("referenceSeqPointer", "Reference(MolecularSequence)", "A pointer to another MolecularSequence entity as reference sequence.", 0, 1, this.referenceSeqPointer));
            children.add(new Property("referenceSeqString", "string", "A string like \"ACGT\".", 0, 1, this.referenceSeqString));
            children.add(new Property("strand", "code", "An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.", 0, 1, this.strand));
            children.add(new Property("windowStart", "integer", "Start position of the window on the reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.windowStart));
            children.add(new Property("windowEnd", "integer", "End position of the window on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.windowEnd));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1499470472: {
                    return new Property(MolecularSequence.SP_CHROMOSOME, "CodeableConcept", "Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).", 0, 1, this.chromosome);
                }
                case 1061239735: {
                    return new Property("genomeBuild", "string", "The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'.  Version number must be included if a versioned release of a primary build was used.", 0, 1, this.genomeBuild);
                }
                case -1439500848: {
                    return new Property("orientation", "code", "A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the \"sense\" strand, and the opposite complementary strand is the \"antisense\" strand.", 0, 1, this.orientation);
                }
                case -1911500465: {
                    return new Property("referenceSeqId", "CodeableConcept", "Reference identifier of reference sequence submitted to NCBI. It must match the type in the MolecularSequence.type field. For example, the prefix, \u201cNG_\u201d identifies reference sequence for genes, \u201cNM_\u201d for messenger RNA transcripts, and \u201cNP_\u201d for amino acid sequences.", 0, 1, this.referenceSeqId);
                }
                case 1923414665: {
                    return new Property("referenceSeqPointer", "Reference(MolecularSequence)", "A pointer to another MolecularSequence entity as reference sequence.", 0, 1, this.referenceSeqPointer);
                }
                case -1648301499: {
                    return new Property("referenceSeqString", "string", "A string like \"ACGT\".", 0, 1, this.referenceSeqString);
                }
                case -891993594: {
                    return new Property("strand", "code", "An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.", 0, 1, this.strand);
                }
                case 1903685202: {
                    return new Property("windowStart", "integer", "Start position of the window on the reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.windowStart);
                }
                case -217026869: {
                    return new Property("windowEnd", "integer", "End position of the window on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.windowEnd);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    Base[] baseArray;
                    if (this.chromosome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.chromosome;
                    }
                    return baseArray;
                }
                case 1061239735: {
                    Base[] baseArray;
                    if (this.genomeBuild == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.genomeBuild;
                    }
                    return baseArray;
                }
                case -1439500848: {
                    Base[] baseArray;
                    if (this.orientation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.orientation;
                    }
                    return baseArray;
                }
                case -1911500465: {
                    Base[] baseArray;
                    if (this.referenceSeqId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.referenceSeqId;
                    }
                    return baseArray;
                }
                case 1923414665: {
                    Base[] baseArray;
                    if (this.referenceSeqPointer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.referenceSeqPointer;
                    }
                    return baseArray;
                }
                case -1648301499: {
                    Base[] baseArray;
                    if (this.referenceSeqString == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.referenceSeqString;
                    }
                    return baseArray;
                }
                case -891993594: {
                    Base[] baseArray;
                    if (this.strand == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.strand;
                    }
                    return baseArray;
                }
                case 1903685202: {
                    Base[] baseArray;
                    if (this.windowStart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.windowStart;
                    }
                    return baseArray;
                }
                case -217026869: {
                    Base[] baseArray;
                    if (this.windowEnd == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.windowEnd;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    this.chromosome = this.castToCodeableConcept(value);
                    return value;
                }
                case 1061239735: {
                    this.genomeBuild = this.castToString(value);
                    return value;
                }
                case -1439500848: {
                    value = new OrientationTypeEnumFactory().fromType(this.castToCode(value));
                    this.orientation = value;
                    return value;
                }
                case -1911500465: {
                    this.referenceSeqId = this.castToCodeableConcept(value);
                    return value;
                }
                case 1923414665: {
                    this.referenceSeqPointer = this.castToReference(value);
                    return value;
                }
                case -1648301499: {
                    this.referenceSeqString = this.castToString(value);
                    return value;
                }
                case -891993594: {
                    value = new StrandTypeEnumFactory().fromType(this.castToCode(value));
                    this.strand = value;
                    return value;
                }
                case 1903685202: {
                    this.windowStart = this.castToInteger(value);
                    return value;
                }
                case -217026869: {
                    this.windowEnd = this.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MolecularSequence.SP_CHROMOSOME)) {
                this.chromosome = this.castToCodeableConcept(value);
            } else if (name.equals("genomeBuild")) {
                this.genomeBuild = this.castToString(value);
            } else if (name.equals("orientation")) {
                value = new OrientationTypeEnumFactory().fromType(this.castToCode(value));
                this.orientation = value;
            } else if (name.equals("referenceSeqId")) {
                this.referenceSeqId = this.castToCodeableConcept(value);
            } else if (name.equals("referenceSeqPointer")) {
                this.referenceSeqPointer = this.castToReference(value);
            } else if (name.equals("referenceSeqString")) {
                this.referenceSeqString = this.castToString(value);
            } else if (name.equals("strand")) {
                value = new StrandTypeEnumFactory().fromType(this.castToCode(value));
                this.strand = value;
            } else if (name.equals("windowStart")) {
                this.windowStart = this.castToInteger(value);
            } else if (name.equals("windowEnd")) {
                this.windowEnd = this.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    return this.getChromosome();
                }
                case 1061239735: {
                    return this.getGenomeBuildElement();
                }
                case -1439500848: {
                    return this.getOrientationElement();
                }
                case -1911500465: {
                    return this.getReferenceSeqId();
                }
                case 1923414665: {
                    return this.getReferenceSeqPointer();
                }
                case -1648301499: {
                    return this.getReferenceSeqStringElement();
                }
                case -891993594: {
                    return this.getStrandElement();
                }
                case 1903685202: {
                    return this.getWindowStartElement();
                }
                case -217026869: {
                    return this.getWindowEndElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    return new String[]{"CodeableConcept"};
                }
                case 1061239735: {
                    return new String[]{"string"};
                }
                case -1439500848: {
                    return new String[]{"code"};
                }
                case -1911500465: {
                    return new String[]{"CodeableConcept"};
                }
                case 1923414665: {
                    return new String[]{"Reference"};
                }
                case -1648301499: {
                    return new String[]{"string"};
                }
                case -891993594: {
                    return new String[]{"code"};
                }
                case 1903685202: {
                    return new String[]{"integer"};
                }
                case -217026869: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MolecularSequence.SP_CHROMOSOME)) {
                this.chromosome = new CodeableConcept();
                return this.chromosome;
            }
            if (name.equals("genomeBuild")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.genomeBuild");
            }
            if (name.equals("orientation")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.orientation");
            }
            if (name.equals("referenceSeqId")) {
                this.referenceSeqId = new CodeableConcept();
                return this.referenceSeqId;
            }
            if (name.equals("referenceSeqPointer")) {
                this.referenceSeqPointer = new Reference();
                return this.referenceSeqPointer;
            }
            if (name.equals("referenceSeqString")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.referenceSeqString");
            }
            if (name.equals("strand")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.strand");
            }
            if (name.equals("windowStart")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.windowStart");
            }
            if (name.equals("windowEnd")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.windowEnd");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceReferenceSeqComponent copy() {
            MolecularSequenceReferenceSeqComponent dst = new MolecularSequenceReferenceSeqComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceReferenceSeqComponent dst) {
            super.copyValues(dst);
            dst.chromosome = this.chromosome == null ? null : this.chromosome.copy();
            dst.genomeBuild = this.genomeBuild == null ? null : this.genomeBuild.copy();
            dst.orientation = this.orientation == null ? null : this.orientation.copy();
            dst.referenceSeqId = this.referenceSeqId == null ? null : this.referenceSeqId.copy();
            dst.referenceSeqPointer = this.referenceSeqPointer == null ? null : this.referenceSeqPointer.copy();
            dst.referenceSeqString = this.referenceSeqString == null ? null : this.referenceSeqString.copy();
            dst.strand = this.strand == null ? null : this.strand.copy();
            dst.windowStart = this.windowStart == null ? null : this.windowStart.copy();
            dst.windowEnd = this.windowEnd == null ? null : this.windowEnd.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceReferenceSeqComponent)) {
                return false;
            }
            MolecularSequenceReferenceSeqComponent o = (MolecularSequenceReferenceSeqComponent)other_;
            return MolecularSequenceReferenceSeqComponent.compareDeep(this.chromosome, o.chromosome, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.genomeBuild, o.genomeBuild, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.orientation, o.orientation, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.referenceSeqId, o.referenceSeqId, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.referenceSeqPointer, o.referenceSeqPointer, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.referenceSeqString, o.referenceSeqString, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.strand, o.strand, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.windowStart, o.windowStart, true) && MolecularSequenceReferenceSeqComponent.compareDeep(this.windowEnd, o.windowEnd, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceReferenceSeqComponent)) {
                return false;
            }
            MolecularSequenceReferenceSeqComponent o = (MolecularSequenceReferenceSeqComponent)other_;
            return MolecularSequenceReferenceSeqComponent.compareValues(this.genomeBuild, o.genomeBuild, true) && MolecularSequenceReferenceSeqComponent.compareValues(this.orientation, o.orientation, true) && MolecularSequenceReferenceSeqComponent.compareValues(this.referenceSeqString, o.referenceSeqString, true) && MolecularSequenceReferenceSeqComponent.compareValues(this.strand, o.strand, true) && MolecularSequenceReferenceSeqComponent.compareValues(this.windowStart, o.windowStart, true) && MolecularSequenceReferenceSeqComponent.compareValues(this.windowEnd, o.windowEnd, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.chromosome, this.genomeBuild, this.orientation, this.referenceSeqId, this.referenceSeqPointer, this.referenceSeqString, this.strand, this.windowStart, this.windowEnd});
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.referenceSeq";
        }
    }

    public static class RepositoryTypeEnumFactory
    implements EnumFactory<RepositoryType> {
        @Override
        public RepositoryType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("directlink".equals(codeString)) {
                return RepositoryType.DIRECTLINK;
            }
            if ("openapi".equals(codeString)) {
                return RepositoryType.OPENAPI;
            }
            if ("login".equals(codeString)) {
                return RepositoryType.LOGIN;
            }
            if ("oauth".equals(codeString)) {
                return RepositoryType.OAUTH;
            }
            if ("other".equals(codeString)) {
                return RepositoryType.OTHER;
            }
            throw new IllegalArgumentException("Unknown RepositoryType code '" + codeString + "'");
        }

        public Enumeration<RepositoryType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RepositoryType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("directlink".equals(codeString)) {
                return new Enumeration<RepositoryType>(this, RepositoryType.DIRECTLINK);
            }
            if ("openapi".equals(codeString)) {
                return new Enumeration<RepositoryType>(this, RepositoryType.OPENAPI);
            }
            if ("login".equals(codeString)) {
                return new Enumeration<RepositoryType>(this, RepositoryType.LOGIN);
            }
            if ("oauth".equals(codeString)) {
                return new Enumeration<RepositoryType>(this, RepositoryType.OAUTH);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<RepositoryType>(this, RepositoryType.OTHER);
            }
            throw new FHIRException("Unknown RepositoryType code '" + codeString + "'");
        }

        @Override
        public String toCode(RepositoryType code) {
            if (code == RepositoryType.DIRECTLINK) {
                return "directlink";
            }
            if (code == RepositoryType.OPENAPI) {
                return "openapi";
            }
            if (code == RepositoryType.LOGIN) {
                return "login";
            }
            if (code == RepositoryType.OAUTH) {
                return "oauth";
            }
            if (code == RepositoryType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(RepositoryType code) {
            return code.getSystem();
        }
    }

    public static enum RepositoryType {
        DIRECTLINK,
        OPENAPI,
        LOGIN,
        OAUTH,
        OTHER,
        NULL;


        public static RepositoryType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("directlink".equals(codeString)) {
                return DIRECTLINK;
            }
            if ("openapi".equals(codeString)) {
                return OPENAPI;
            }
            if ("login".equals(codeString)) {
                return LOGIN;
            }
            if ("oauth".equals(codeString)) {
                return OAUTH;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RepositoryType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DIRECTLINK: {
                    return "directlink";
                }
                case OPENAPI: {
                    return "openapi";
                }
                case LOGIN: {
                    return "login";
                }
                case OAUTH: {
                    return "oauth";
                }
                case OTHER: {
                    return "other";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DIRECTLINK: {
                    return "http://hl7.org/fhir/repository-type";
                }
                case OPENAPI: {
                    return "http://hl7.org/fhir/repository-type";
                }
                case LOGIN: {
                    return "http://hl7.org/fhir/repository-type";
                }
                case OAUTH: {
                    return "http://hl7.org/fhir/repository-type";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/repository-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DIRECTLINK: {
                    return "When URL is clicked, the resource can be seen directly (by webpage or by download link format).";
                }
                case OPENAPI: {
                    return "When the API method (e.g. [base_url]/[parameter]) related with the URL of the website is executed, the resource can be seen directly (usually in JSON or XML format).";
                }
                case LOGIN: {
                    return "When logged into the website, the resource can be seen.";
                }
                case OAUTH: {
                    return "When logged in and  follow the API in the website related with URL, the resource can be seen.";
                }
                case OTHER: {
                    return "Some other complicated or particular way to get resource from URL.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DIRECTLINK: {
                    return "Click and see";
                }
                case OPENAPI: {
                    return "The URL is the RESTful or other kind of API that can access to the result.";
                }
                case LOGIN: {
                    return "Result cannot be access unless an account is logged in";
                }
                case OAUTH: {
                    return "Result need to be fetched with API and need LOGIN( or cookies are required when visiting the link of resource)";
                }
                case OTHER: {
                    return "Some other complicated or particular way to get resource from URL.";
                }
            }
            return "?";
        }
    }

    public static class QualityTypeEnumFactory
    implements EnumFactory<QualityType> {
        @Override
        public QualityType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("indel".equals(codeString)) {
                return QualityType.INDEL;
            }
            if ("snp".equals(codeString)) {
                return QualityType.SNP;
            }
            if ("unknown".equals(codeString)) {
                return QualityType.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown QualityType code '" + codeString + "'");
        }

        public Enumeration<QualityType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<QualityType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("indel".equals(codeString)) {
                return new Enumeration<QualityType>(this, QualityType.INDEL);
            }
            if ("snp".equals(codeString)) {
                return new Enumeration<QualityType>(this, QualityType.SNP);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<QualityType>(this, QualityType.UNKNOWN);
            }
            throw new FHIRException("Unknown QualityType code '" + codeString + "'");
        }

        @Override
        public String toCode(QualityType code) {
            if (code == QualityType.INDEL) {
                return "indel";
            }
            if (code == QualityType.SNP) {
                return "snp";
            }
            if (code == QualityType.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(QualityType code) {
            return code.getSystem();
        }
    }

    public static enum QualityType {
        INDEL,
        SNP,
        UNKNOWN,
        NULL;


        public static QualityType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("indel".equals(codeString)) {
                return INDEL;
            }
            if ("snp".equals(codeString)) {
                return SNP;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown QualityType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INDEL: {
                    return "indel";
                }
                case SNP: {
                    return "snp";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INDEL: {
                    return "http://hl7.org/fhir/quality-type";
                }
                case SNP: {
                    return "http://hl7.org/fhir/quality-type";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/quality-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INDEL: {
                    return "INDEL Comparison.";
                }
                case SNP: {
                    return "SNP Comparison.";
                }
                case UNKNOWN: {
                    return "UNKNOWN Comparison.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INDEL: {
                    return "INDEL Comparison";
                }
                case SNP: {
                    return "SNP Comparison";
                }
                case UNKNOWN: {
                    return "UNKNOWN Comparison";
                }
            }
            return "?";
        }
    }

    public static class StrandTypeEnumFactory
    implements EnumFactory<StrandType> {
        @Override
        public StrandType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("watson".equals(codeString)) {
                return StrandType.WATSON;
            }
            if ("crick".equals(codeString)) {
                return StrandType.CRICK;
            }
            throw new IllegalArgumentException("Unknown StrandType code '" + codeString + "'");
        }

        public Enumeration<StrandType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StrandType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("watson".equals(codeString)) {
                return new Enumeration<StrandType>(this, StrandType.WATSON);
            }
            if ("crick".equals(codeString)) {
                return new Enumeration<StrandType>(this, StrandType.CRICK);
            }
            throw new FHIRException("Unknown StrandType code '" + codeString + "'");
        }

        @Override
        public String toCode(StrandType code) {
            if (code == StrandType.WATSON) {
                return "watson";
            }
            if (code == StrandType.CRICK) {
                return "crick";
            }
            return "?";
        }

        @Override
        public String toSystem(StrandType code) {
            return code.getSystem();
        }
    }

    public static enum StrandType {
        WATSON,
        CRICK,
        NULL;


        public static StrandType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("watson".equals(codeString)) {
                return WATSON;
            }
            if ("crick".equals(codeString)) {
                return CRICK;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StrandType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case WATSON: {
                    return "watson";
                }
                case CRICK: {
                    return "crick";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case WATSON: {
                    return "http://hl7.org/fhir/strand-type";
                }
                case CRICK: {
                    return "http://hl7.org/fhir/strand-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case WATSON: {
                    return "Watson strand of reference sequence.";
                }
                case CRICK: {
                    return "Crick strand of reference sequence.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case WATSON: {
                    return "Watson strand of referenceSeq";
                }
                case CRICK: {
                    return "Crick strand of referenceSeq";
                }
            }
            return "?";
        }
    }

    public static class OrientationTypeEnumFactory
    implements EnumFactory<OrientationType> {
        @Override
        public OrientationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("sense".equals(codeString)) {
                return OrientationType.SENSE;
            }
            if ("antisense".equals(codeString)) {
                return OrientationType.ANTISENSE;
            }
            throw new IllegalArgumentException("Unknown OrientationType code '" + codeString + "'");
        }

        public Enumeration<OrientationType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<OrientationType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sense".equals(codeString)) {
                return new Enumeration<OrientationType>(this, OrientationType.SENSE);
            }
            if ("antisense".equals(codeString)) {
                return new Enumeration<OrientationType>(this, OrientationType.ANTISENSE);
            }
            throw new FHIRException("Unknown OrientationType code '" + codeString + "'");
        }

        @Override
        public String toCode(OrientationType code) {
            if (code == OrientationType.SENSE) {
                return "sense";
            }
            if (code == OrientationType.ANTISENSE) {
                return "antisense";
            }
            return "?";
        }

        @Override
        public String toSystem(OrientationType code) {
            return code.getSystem();
        }
    }

    public static enum OrientationType {
        SENSE,
        ANTISENSE,
        NULL;


        public static OrientationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sense".equals(codeString)) {
                return SENSE;
            }
            if ("antisense".equals(codeString)) {
                return ANTISENSE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown OrientationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SENSE: {
                    return "sense";
                }
                case ANTISENSE: {
                    return "antisense";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SENSE: {
                    return "http://hl7.org/fhir/orientation-type";
                }
                case ANTISENSE: {
                    return "http://hl7.org/fhir/orientation-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SENSE: {
                    return "Sense orientation of reference sequence.";
                }
                case ANTISENSE: {
                    return "Antisense orientation of reference sequence.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SENSE: {
                    return "Sense orientation of referenceSeq";
                }
                case ANTISENSE: {
                    return "Antisense orientation of referenceSeq";
                }
            }
            return "?";
        }
    }

    public static class SequenceTypeEnumFactory
    implements EnumFactory<SequenceType> {
        @Override
        public SequenceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("aa".equals(codeString)) {
                return SequenceType.AA;
            }
            if ("dna".equals(codeString)) {
                return SequenceType.DNA;
            }
            if ("rna".equals(codeString)) {
                return SequenceType.RNA;
            }
            throw new IllegalArgumentException("Unknown SequenceType code '" + codeString + "'");
        }

        public Enumeration<SequenceType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SequenceType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("aa".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.AA);
            }
            if ("dna".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.DNA);
            }
            if ("rna".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.RNA);
            }
            throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
        }

        @Override
        public String toCode(SequenceType code) {
            if (code == SequenceType.AA) {
                return "aa";
            }
            if (code == SequenceType.DNA) {
                return "dna";
            }
            if (code == SequenceType.RNA) {
                return "rna";
            }
            return "?";
        }

        @Override
        public String toSystem(SequenceType code) {
            return code.getSystem();
        }
    }

    public static enum SequenceType {
        AA,
        DNA,
        RNA,
        NULL;


        public static SequenceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("aa".equals(codeString)) {
                return AA;
            }
            if ("dna".equals(codeString)) {
                return DNA;
            }
            if ("rna".equals(codeString)) {
                return RNA;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AA: {
                    return "aa";
                }
                case DNA: {
                    return "dna";
                }
                case RNA: {
                    return "rna";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case DNA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case RNA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AA: {
                    return "Amino acid sequence.";
                }
                case DNA: {
                    return "DNA Sequence.";
                }
                case RNA: {
                    return "RNA Sequence.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AA: {
                    return "AA Sequence";
                }
                case DNA: {
                    return "DNA Sequence";
                }
                case RNA: {
                    return "RNA Sequence";
                }
            }
            return "?";
        }
    }
}

