/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;

@DatatypeDef(name="ProductShelfLife")
public class ProductShelfLife
extends BackboneType
implements ICompositeType {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier for the packaged Medicinal Product", formalDefinition="Unique identifier for the packaged Medicinal Product.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified", formalDefinition="This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.")
    protected CodeableConcept type;
    @Child(name="period", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity period;
    @Child(name="specialPrecautionsForStorage", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified", formalDefinition="Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.")
    protected List<CodeableConcept> specialPrecautionsForStorage;
    private static final long serialVersionUID = -1561196410L;

    public ProductShelfLife() {
    }

    public ProductShelfLife(CodeableConcept type, Quantity period) {
        this.type = type;
        this.period = period;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductShelfLife.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ProductShelfLife setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductShelfLife.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ProductShelfLife setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Quantity getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductShelfLife.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Quantity();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ProductShelfLife setPeriod(Quantity value) {
        this.period = value;
        return this;
    }

    public List<CodeableConcept> getSpecialPrecautionsForStorage() {
        if (this.specialPrecautionsForStorage == null) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
        }
        return this.specialPrecautionsForStorage;
    }

    public ProductShelfLife setSpecialPrecautionsForStorage(List<CodeableConcept> theSpecialPrecautionsForStorage) {
        this.specialPrecautionsForStorage = theSpecialPrecautionsForStorage;
        return this;
    }

    public boolean hasSpecialPrecautionsForStorage() {
        if (this.specialPrecautionsForStorage == null) {
            return false;
        }
        for (CodeableConcept item : this.specialPrecautionsForStorage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialPrecautionsForStorage() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialPrecautionsForStorage == null) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
        }
        this.specialPrecautionsForStorage.add(t);
        return t;
    }

    public ProductShelfLife addSpecialPrecautionsForStorage(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialPrecautionsForStorage == null) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
        }
        this.specialPrecautionsForStorage.add(t);
        return this;
    }

    public CodeableConcept getSpecialPrecautionsForStorageFirstRep() {
        if (this.getSpecialPrecautionsForStorage().isEmpty()) {
            this.addSpecialPrecautionsForStorage();
        }
        return this.getSpecialPrecautionsForStorage().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Unique identifier for the packaged Medicinal Product.", 0, 1, this.identifier));
        children.add(new Property("type", "CodeableConcept", "This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, 1, this.type));
        children.add(new Property("period", "Quantity", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period));
        children.add(new Property("specialPrecautionsForStorage", "CodeableConcept", "Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, Integer.MAX_VALUE, this.specialPrecautionsForStorage));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Unique identifier for the packaged Medicinal Product.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, 1, this.type);
            }
            case -991726143: {
                return new Property("period", "Quantity", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period);
            }
            case 2103459492: {
                return new Property("specialPrecautionsForStorage", "CodeableConcept", "Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, Integer.MAX_VALUE, this.specialPrecautionsForStorage);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case 2103459492: {
                return this.specialPrecautionsForStorage == null ? new Base[]{} : this.specialPrecautionsForStorage.toArray(new Base[this.specialPrecautionsForStorage.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToQuantity(value);
                return value;
            }
            case 2103459492: {
                this.getSpecialPrecautionsForStorage().add(this.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("period")) {
            this.period = this.castToQuantity(value);
        } else if (name.equals("specialPrecautionsForStorage")) {
            this.getSpecialPrecautionsForStorage().add(this.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 2103459492: {
                return this.addSpecialPrecautionsForStorage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Quantity"};
            }
            case 2103459492: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("period")) {
            this.period = new Quantity();
            return this.period;
        }
        if (name.equals("specialPrecautionsForStorage")) {
            return this.addSpecialPrecautionsForStorage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProductShelfLife";
    }

    @Override
    public ProductShelfLife copy() {
        ProductShelfLife dst = new ProductShelfLife();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ProductShelfLife dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        Quantity quantity = dst.period = this.period == null ? null : this.period.copy();
        if (this.specialPrecautionsForStorage != null) {
            dst.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
            for (CodeableConcept i : this.specialPrecautionsForStorage) {
                dst.specialPrecautionsForStorage.add(i.copy());
            }
        }
    }

    @Override
    protected ProductShelfLife typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ProductShelfLife)) {
            return false;
        }
        ProductShelfLife o = (ProductShelfLife)other_;
        return ProductShelfLife.compareDeep(this.identifier, o.identifier, true) && ProductShelfLife.compareDeep(this.type, o.type, true) && ProductShelfLife.compareDeep(this.period, o.period, true) && ProductShelfLife.compareDeep(this.specialPrecautionsForStorage, o.specialPrecautionsForStorage, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ProductShelfLife)) {
            return false;
        }
        ProductShelfLife o = (ProductShelfLife)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.period, this.specialPrecautionsForStorage});
    }
}

