/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.CertaintyRating;

public class CertaintyRatingEnumFactory
implements EnumFactory<CertaintyRating> {
    @Override
    public CertaintyRating fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("high".equals(codeString)) {
            return CertaintyRating.HIGH;
        }
        if ("moderate".equals(codeString)) {
            return CertaintyRating.MODERATE;
        }
        if ("low".equals(codeString)) {
            return CertaintyRating.LOW;
        }
        if ("very-low".equals(codeString)) {
            return CertaintyRating.VERYLOW;
        }
        throw new IllegalArgumentException("Unknown CertaintyRating code '" + codeString + "'");
    }

    @Override
    public String toCode(CertaintyRating code) {
        if (code == CertaintyRating.HIGH) {
            return "high";
        }
        if (code == CertaintyRating.MODERATE) {
            return "moderate";
        }
        if (code == CertaintyRating.LOW) {
            return "low";
        }
        if (code == CertaintyRating.VERYLOW) {
            return "very-low";
        }
        return "?";
    }

    @Override
    public String toSystem(CertaintyRating code) {
        return code.getSystem();
    }
}

