/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DefinitionTopic {
    TREATMENT,
    EDUCATION,
    ASSESSMENT,
    NULL;


    public static DefinitionTopic fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("treatment".equals(codeString)) {
            return TREATMENT;
        }
        if ("education".equals(codeString)) {
            return EDUCATION;
        }
        if ("assessment".equals(codeString)) {
            return ASSESSMENT;
        }
        throw new FHIRException("Unknown DefinitionTopic code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TREATMENT: {
                return "treatment";
            }
            case EDUCATION: {
                return "education";
            }
            case ASSESSMENT: {
                return "assessment";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/definition-topic";
    }

    public String getDefinition() {
        switch (this) {
            case TREATMENT: {
                return "The definition is related to treatment of the patient.";
            }
            case EDUCATION: {
                return "The definition is related to education of the patient.";
            }
            case ASSESSMENT: {
                return "The definition is related to assessment of the patient.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TREATMENT: {
                return "Treatment";
            }
            case EDUCATION: {
                return "Education";
            }
            case ASSESSMENT: {
                return "Assessment";
            }
        }
        return "?";
    }
}

