/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DeviceAction {
    IMPLANTED,
    EXPLANTED,
    MANIPULATED,
    NULL;


    public static DeviceAction fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("implanted".equals(codeString)) {
            return IMPLANTED;
        }
        if ("explanted".equals(codeString)) {
            return EXPLANTED;
        }
        if ("manipulated".equals(codeString)) {
            return MANIPULATED;
        }
        throw new FHIRException("Unknown DeviceAction code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case IMPLANTED: {
                return "implanted";
            }
            case EXPLANTED: {
                return "explanted";
            }
            case MANIPULATED: {
                return "manipulated";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/device-action";
    }

    public String getDefinition() {
        switch (this) {
            case IMPLANTED: {
                return "The device was implanted in the patient during the procedure.";
            }
            case EXPLANTED: {
                return "The device was explanted from the patient during the procedure.";
            }
            case MANIPULATED: {
                return "The device remains in the patient, but its location, settings, or functionality was changed.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case IMPLANTED: {
                return "Implanted";
            }
            case EXPLANTED: {
                return "Explanted";
            }
            case MANIPULATED: {
                return "Manipulated";
            }
        }
        return "?";
    }
}

