/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterStatus {
    PLANNED,
    INPROGRESS,
    ONHOLD,
    COMPLETED,
    CANCELLED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static EncounterStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("onhold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown EncounterStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLANNED: {
                return "planned";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONHOLD: {
                return "onhold";
            }
            case COMPLETED: {
                return "completed";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/encounter-status";
    }

    public String getDefinition() {
        switch (this) {
            case PLANNED: {
                return "The Encounter has not yet started.";
            }
            case INPROGRESS: {
                return "The Encounter has begun and the patient is present / the practitioner and the patient are meeting.";
            }
            case ONHOLD: {
                return "The Encounter has begun, but is currently on hold, e.g. because the patient is temporarily on leave.";
            }
            case COMPLETED: {
                return "The Encounter has ended.";
            }
            case CANCELLED: {
                return "The Encounter has ended before it has begun.";
            }
            case ENTEREDINERROR: {
                return "This instance should not have been part of this patient's medical record.";
            }
            case UNKNOWN: {
                return "The encounter status is unknown. Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLANNED: {
                return "Planned";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

