/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum FilterOperator {
    EQUAL,
    ISA,
    DESCENDENTOF,
    ISNOTA,
    REGEX,
    IN,
    NOTIN,
    GENERALIZES,
    EXISTS,
    NULL;


    public static FilterOperator fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("=".equals(codeString)) {
            return EQUAL;
        }
        if ("is-a".equals(codeString)) {
            return ISA;
        }
        if ("descendent-of".equals(codeString)) {
            return DESCENDENTOF;
        }
        if ("is-not-a".equals(codeString)) {
            return ISNOTA;
        }
        if ("regex".equals(codeString)) {
            return REGEX;
        }
        if ("in".equals(codeString)) {
            return IN;
        }
        if ("not-in".equals(codeString)) {
            return NOTIN;
        }
        if ("generalizes".equals(codeString)) {
            return GENERALIZES;
        }
        if ("exists".equals(codeString)) {
            return EXISTS;
        }
        throw new FHIRException("Unknown FilterOperator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EQUAL: {
                return "=";
            }
            case ISA: {
                return "is-a";
            }
            case DESCENDENTOF: {
                return "descendent-of";
            }
            case ISNOTA: {
                return "is-not-a";
            }
            case REGEX: {
                return "regex";
            }
            case IN: {
                return "in";
            }
            case NOTIN: {
                return "not-in";
            }
            case GENERALIZES: {
                return "generalizes";
            }
            case EXISTS: {
                return "exists";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/filter-operator";
    }

    public String getDefinition() {
        switch (this) {
            case EQUAL: {
                return "The specified property of the code equals the provided value.";
            }
            case ISA: {
                return "Includes all concept ids that have a transitive is-a relationship with the concept Id provided as the value, including the provided concept itself (include descendant codes and self).";
            }
            case DESCENDENTOF: {
                return "Includes all concept ids that have a transitive is-a relationship with the concept Id provided as the value, excluding the provided concept itself i.e. include descendant codes only).";
            }
            case ISNOTA: {
                return "The specified property of the code does not have an is-a relationship with the provided value.";
            }
            case REGEX: {
                return "The specified property of the code  matches the regex specified in the provided value.";
            }
            case IN: {
                return "The specified property of the code is in the set of codes or concepts specified in the provided value (comma separated list).";
            }
            case NOTIN: {
                return "The specified property of the code is not in the set of codes or concepts specified in the provided value (comma separated list).";
            }
            case GENERALIZES: {
                return "Includes all concept ids that have a transitive is-a relationship from the concept Id provided as the value, including the provided concept itself (i.e. include ancestor codes and self).";
            }
            case EXISTS: {
                return "The specified property of the code has at least one value (if the specified value is true; if the specified value is false, then matches when the specified property of the code has no values).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EQUAL: {
                return "Equals";
            }
            case ISA: {
                return "Is A (by subsumption)";
            }
            case DESCENDENTOF: {
                return "Descendent Of (by subsumption)";
            }
            case ISNOTA: {
                return "Not (Is A) (by subsumption)";
            }
            case REGEX: {
                return "Regular Expression";
            }
            case IN: {
                return "In Set";
            }
            case NOTIN: {
                return "Not in Set";
            }
            case GENERALIZES: {
                return "Generalizes (by Subsumption)";
            }
            case EXISTS: {
                return "Exists";
            }
        }
        return "?";
    }
}

