/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImagingstudyStatus {
    REGISTERED,
    AVAILABLE,
    CANCELLED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static ImagingstudyStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("registered".equals(codeString)) {
            return REGISTERED;
        }
        if ("available".equals(codeString)) {
            return AVAILABLE;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ImagingstudyStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REGISTERED: {
                return "registered";
            }
            case AVAILABLE: {
                return "available";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/imagingstudy-status";
    }

    public String getDefinition() {
        switch (this) {
            case REGISTERED: {
                return "The existence of the imaging study is registered, but there is nothing yet available.";
            }
            case AVAILABLE: {
                return "At least one instance has been associated with this imaging study.";
            }
            case CANCELLED: {
                return "The imaging study is unavailable because the imaging study was not started or not completed (also sometimes called \"aborted\").";
            }
            case ENTEREDINERROR: {
                return "The imaging study has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
            }
            case UNKNOWN: {
                return "The system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REGISTERED: {
                return "Registered";
            }
            case AVAILABLE: {
                return "Available";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

