/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OralProsthodonticMaterial {
    _1,
    _2,
    _3,
    _4,
    NULL;


    public static OralProsthodonticMaterial fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        if ("3".equals(codeString)) {
            return _3;
        }
        if ("4".equals(codeString)) {
            return _4;
        }
        throw new FHIRException("Unknown OralProsthodonticMaterial code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
            case _3: {
                return "3";
            }
            case _4: {
                return "4";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-oralprostho";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "Fixed Bridge";
            }
            case _2: {
                return "Maryland Bridge";
            }
            case _3: {
                return "Denture Acrylic";
            }
            case _4: {
                return "Denture Chrome Cobalt";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "Fixed Bridge";
            }
            case _2: {
                return "Maryland Bridge";
            }
            case _3: {
                return "Denture Acrylic";
            }
            case _4: {
                return "Denture Chrome Cobalt";
            }
        }
        return "?";
    }
}

