/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PvalueType {
    PLACEHOLDER,
    NULL;


    public static PvalueType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("placeholder".equals(codeString)) {
            return PLACEHOLDER;
        }
        throw new FHIRException("Unknown PvalueType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLACEHOLDER: {
                return "placeholder";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/pvalue-type";
    }

    public String getDefinition() {
        switch (this) {
            case PLACEHOLDER: {
                return "Real codes go here.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLACEHOLDER: {
                return "place holder";
            }
        }
        return "?";
    }
}

