/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchStudyPhase {
    NA,
    EARLYPHASE1,
    PHASE1,
    PHASE1PHASE2,
    PHASE2,
    PHASE2PHASE3,
    PHASE3,
    PHASE4,
    NULL;


    public static ResearchStudyPhase fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("n-a".equals(codeString)) {
            return NA;
        }
        if ("early-phase-1".equals(codeString)) {
            return EARLYPHASE1;
        }
        if ("phase-1".equals(codeString)) {
            return PHASE1;
        }
        if ("phase-1-phase-2".equals(codeString)) {
            return PHASE1PHASE2;
        }
        if ("phase-2".equals(codeString)) {
            return PHASE2;
        }
        if ("phase-2-phase-3".equals(codeString)) {
            return PHASE2PHASE3;
        }
        if ("phase-3".equals(codeString)) {
            return PHASE3;
        }
        if ("phase-4".equals(codeString)) {
            return PHASE4;
        }
        throw new FHIRException("Unknown ResearchStudyPhase code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NA: {
                return "n-a";
            }
            case EARLYPHASE1: {
                return "early-phase-1";
            }
            case PHASE1: {
                return "phase-1";
            }
            case PHASE1PHASE2: {
                return "phase-1-phase-2";
            }
            case PHASE2: {
                return "phase-2";
            }
            case PHASE2PHASE3: {
                return "phase-2-phase-3";
            }
            case PHASE3: {
                return "phase-3";
            }
            case PHASE4: {
                return "phase-4";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/research-study-phase";
    }

    public String getDefinition() {
        switch (this) {
            case NA: {
                return "Trials without phases (for example, studies of devices or behavioral interventions).";
            }
            case EARLYPHASE1: {
                return "Designation for optional exploratory trials conducted in accordance with the United States Food and Drug Administration's (FDA) 2006 Guidance on Exploratory Investigational New Drug (IND) Studies. Formerly called Phase 0.";
            }
            case PHASE1: {
                return "Includes initial studies to determine the metabolism and pharmacologic actions of drugs in humans, the side effects associated with increasing doses, and to gain early evidence of effectiveness; may include healthy participants and/or patients.";
            }
            case PHASE1PHASE2: {
                return "Trials that are a combination of phases 1 and 2.";
            }
            case PHASE2: {
                return "Includes controlled clinical studies conducted to evaluate the effectiveness of the drug for a particular indication or indications in participants with the disease or condition under study and to determine the common short-term side effects and risks.";
            }
            case PHASE2PHASE3: {
                return "Trials that are a combination of phases 2 and 3.";
            }
            case PHASE3: {
                return "Includes trials conducted after preliminary evidence suggesting effectiveness of the drug has been obtained, and are intended to gather additional information to evaluate the overall benefit-risk relationship of the drug.";
            }
            case PHASE4: {
                return "Studies of FDA-approved drugs to delineate additional information including the drug's risks, benefits, and optimal use.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NA: {
                return "N/A";
            }
            case EARLYPHASE1: {
                return "Early Phase 1";
            }
            case PHASE1: {
                return "Phase 1";
            }
            case PHASE1PHASE2: {
                return "Phase 1/Phase 2";
            }
            case PHASE2: {
                return "Phase 2";
            }
            case PHASE2PHASE3: {
                return "Phase 2/Phase 3";
            }
            case PHASE3: {
                return "Phase 3";
            }
            case PHASE4: {
                return "Phase 4";
            }
        }
        return "?";
    }
}

