/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.SequenceType;

public class SequenceTypeEnumFactory
implements EnumFactory<SequenceType> {
    @Override
    public SequenceType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("aa".equals(codeString)) {
            return SequenceType.AA;
        }
        if ("dna".equals(codeString)) {
            return SequenceType.DNA;
        }
        if ("rna".equals(codeString)) {
            return SequenceType.RNA;
        }
        throw new IllegalArgumentException("Unknown SequenceType code '" + codeString + "'");
    }

    @Override
    public String toCode(SequenceType code) {
        if (code == SequenceType.AA) {
            return "aa";
        }
        if (code == SequenceType.DNA) {
            return "dna";
        }
        if (code == SequenceType.RNA) {
            return "rna";
        }
        return "?";
    }

    @Override
    public String toSystem(SequenceType code) {
        return code.getSystem();
    }
}

