/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.UsageContextType;

public class UsageContextTypeEnumFactory
implements EnumFactory<UsageContextType> {
    @Override
    public UsageContextType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("gender".equals(codeString)) {
            return UsageContextType.GENDER;
        }
        if ("age".equals(codeString)) {
            return UsageContextType.AGE;
        }
        if ("focus".equals(codeString)) {
            return UsageContextType.FOCUS;
        }
        if ("user".equals(codeString)) {
            return UsageContextType.USER;
        }
        if ("workflow".equals(codeString)) {
            return UsageContextType.WORKFLOW;
        }
        if ("task".equals(codeString)) {
            return UsageContextType.TASK;
        }
        if ("venue".equals(codeString)) {
            return UsageContextType.VENUE;
        }
        if ("species".equals(codeString)) {
            return UsageContextType.SPECIES;
        }
        if ("program".equals(codeString)) {
            return UsageContextType.PROGRAM;
        }
        throw new IllegalArgumentException("Unknown UsageContextType code '" + codeString + "'");
    }

    @Override
    public String toCode(UsageContextType code) {
        if (code == UsageContextType.GENDER) {
            return "gender";
        }
        if (code == UsageContextType.AGE) {
            return "age";
        }
        if (code == UsageContextType.FOCUS) {
            return "focus";
        }
        if (code == UsageContextType.USER) {
            return "user";
        }
        if (code == UsageContextType.WORKFLOW) {
            return "workflow";
        }
        if (code == UsageContextType.TASK) {
            return "task";
        }
        if (code == UsageContextType.VENUE) {
            return "venue";
        }
        if (code == UsageContextType.SPECIES) {
            return "species";
        }
        if (code == UsageContextType.PROGRAM) {
            return "program";
        }
        return "?";
    }

    @Override
    public String toSystem(UsageContextType code) {
        return code.getSystem();
    }
}

