/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Meta")
public class Meta
extends DataType
implements IBaseMetaType {
    @Child(name="versionId", type={IdType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Version specific identifier", formalDefinition="The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted.")
    protected IdType versionId;
    @Child(name="lastUpdated", type={InstantType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the resource version last changed", formalDefinition="When the resource last changed - e.g. when the version changed.")
    protected InstantType lastUpdated;
    @Child(name="source", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies where the resource comes from", formalDefinition="A uri that identifies the source system of the resource. This provides a minimal amount of [Provenance](provenance.html#) information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc.")
    protected UriType source;
    @Child(name="profile", type={CanonicalType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Profiles this resource claims to conform to", formalDefinition="A list of profiles (references to [StructureDefinition](structuredefinition.html#) resources) that this resource claims to conform to. The URL is a reference to [StructureDefinition.url](structuredefinition-definitions.html#StructureDefinition.url).")
    protected List<CanonicalType> profile;
    @Child(name="security", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Security Labels applied to this resource", formalDefinition="Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    protected List<Coding> security;
    @Child(name="tag", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Tags applied to this resource", formalDefinition="Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/common-tags")
    protected List<Coding> tag;
    private static final long serialVersionUID = -1386695622L;

    public IdType getVersionIdElement() {
        if (this.versionId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Meta.versionId");
            }
            if (Configuration.doAutoCreate()) {
                this.versionId = new IdType();
            }
        }
        return this.versionId;
    }

    public boolean hasVersionIdElement() {
        return this.versionId != null && !this.versionId.isEmpty();
    }

    public boolean hasVersionId() {
        return this.versionId != null && !this.versionId.isEmpty();
    }

    public Meta setVersionIdElement(IdType value) {
        this.versionId = value;
        return this;
    }

    public String getVersionId() {
        return this.versionId == null ? null : this.versionId.getValue();
    }

    public Meta setVersionId(String value) {
        if (Utilities.noString((String)value)) {
            this.versionId = null;
        } else {
            if (this.versionId == null) {
                this.versionId = new IdType();
            }
            this.versionId.setValue(value);
        }
        return this;
    }

    public InstantType getLastUpdatedElement() {
        if (this.lastUpdated == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Meta.lastUpdated");
            }
            if (Configuration.doAutoCreate()) {
                this.lastUpdated = new InstantType();
            }
        }
        return this.lastUpdated;
    }

    public boolean hasLastUpdatedElement() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public Meta setLastUpdatedElement(InstantType value) {
        this.lastUpdated = value;
        return this;
    }

    public Date getLastUpdated() {
        return this.lastUpdated == null ? null : (Date)this.lastUpdated.getValue();
    }

    public Meta setLastUpdated(Date value) {
        if (value == null) {
            this.lastUpdated = null;
        } else {
            if (this.lastUpdated == null) {
                this.lastUpdated = new InstantType();
            }
            this.lastUpdated.setValue(value);
        }
        return this;
    }

    public UriType getSourceElement() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Meta.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new UriType();
            }
        }
        return this.source;
    }

    public boolean hasSourceElement() {
        return this.source != null && !this.source.isEmpty();
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public Meta setSourceElement(UriType value) {
        this.source = value;
        return this;
    }

    public String getSource() {
        return this.source == null ? null : (String)this.source.getValue();
    }

    public Meta setSource(String value) {
        if (Utilities.noString((String)value)) {
            this.source = null;
        } else {
            if (this.source == null) {
                this.source = new UriType();
            }
            this.source.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<CanonicalType>();
        }
        return this.profile;
    }

    public Meta setProfile(List<CanonicalType> theProfile) {
        this.profile = theProfile;
        return this;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (CanonicalType item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addProfileElement() {
        CanonicalType t = new CanonicalType();
        if (this.profile == null) {
            this.profile = new ArrayList<CanonicalType>();
        }
        this.profile.add(t);
        return t;
    }

    public Meta addProfile(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.profile == null) {
            this.profile = new ArrayList<CanonicalType>();
        }
        this.profile.add(t);
        return this;
    }

    public boolean hasProfile(String value) {
        if (this.profile == null) {
            return false;
        }
        for (CanonicalType v : this.profile) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Coding> getSecurity() {
        if (this.security == null) {
            this.security = new ArrayList<Coding>();
        }
        return this.security;
    }

    public Meta setSecurity(List<Coding> theSecurity) {
        this.security = theSecurity;
        return this;
    }

    public boolean hasSecurity() {
        if (this.security == null) {
            return false;
        }
        for (Coding item : this.security) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSecurity() {
        Coding t = new Coding();
        if (this.security == null) {
            this.security = new ArrayList<Coding>();
        }
        this.security.add(t);
        return t;
    }

    public Meta addSecurity(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.security == null) {
            this.security = new ArrayList<Coding>();
        }
        this.security.add(t);
        return this;
    }

    public Coding getSecurityFirstRep() {
        if (this.getSecurity().isEmpty()) {
            this.addSecurity();
        }
        return this.getSecurity().get(0);
    }

    public List<Coding> getTag() {
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        return this.tag;
    }

    public Meta setTag(List<Coding> theTag) {
        this.tag = theTag;
        return this;
    }

    public boolean hasTag() {
        if (this.tag == null) {
            return false;
        }
        for (Coding item : this.tag) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addTag() {
        Coding t = new Coding();
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        this.tag.add(t);
        return t;
    }

    public Meta addTag(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        this.tag.add(t);
        return this;
    }

    public Coding getTagFirstRep() {
        if (this.getTag().isEmpty()) {
            this.addTag();
        }
        return this.getTag().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("versionId", "id", "The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted.", 0, 1, this.versionId));
        children.add(new Property("lastUpdated", "instant", "When the resource last changed - e.g. when the version changed.", 0, 1, this.lastUpdated));
        children.add(new Property("source", "uri", "A uri that identifies the source system of the resource. This provides a minimal amount of [Provenance](provenance.html#) information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc.", 0, 1, this.source));
        children.add(new Property("profile", "canonical(StructureDefinition)", "A list of profiles (references to [StructureDefinition](structuredefinition.html#) resources) that this resource claims to conform to. The URL is a reference to [StructureDefinition.url](structuredefinition-definitions.html#StructureDefinition.url).", 0, Integer.MAX_VALUE, this.profile));
        children.add(new Property("security", "Coding", "Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.", 0, Integer.MAX_VALUE, this.security));
        children.add(new Property("tag", "Coding", "Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.", 0, Integer.MAX_VALUE, this.tag));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1407102957: {
                return new Property("versionId", "id", "The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted.", 0, 1, this.versionId);
            }
            case 1649733957: {
                return new Property("lastUpdated", "instant", "When the resource last changed - e.g. when the version changed.", 0, 1, this.lastUpdated);
            }
            case -896505829: {
                return new Property("source", "uri", "A uri that identifies the source system of the resource. This provides a minimal amount of [Provenance](provenance.html#) information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc.", 0, 1, this.source);
            }
            case -309425751: {
                return new Property("profile", "canonical(StructureDefinition)", "A list of profiles (references to [StructureDefinition](structuredefinition.html#) resources) that this resource claims to conform to. The URL is a reference to [StructureDefinition.url](structuredefinition-definitions.html#StructureDefinition.url).", 0, Integer.MAX_VALUE, this.profile);
            }
            case 949122880: {
                return new Property("security", "Coding", "Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.", 0, Integer.MAX_VALUE, this.security);
            }
            case 114586: {
                return new Property("tag", "Coding", "Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.", 0, Integer.MAX_VALUE, this.tag);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1407102957: {
                Base[] baseArray;
                if (this.versionId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.versionId;
                }
                return baseArray;
            }
            case 1649733957: {
                Base[] baseArray;
                if (this.lastUpdated == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.lastUpdated;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.source;
                }
                return baseArray;
            }
            case -309425751: {
                return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
            }
            case 949122880: {
                return this.security == null ? new Base[]{} : this.security.toArray(new Base[this.security.size()]);
            }
            case 114586: {
                return this.tag == null ? new Base[]{} : this.tag.toArray(new Base[this.tag.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1407102957: {
                this.versionId = TypeConvertor.castToId(value);
                return value;
            }
            case 1649733957: {
                this.lastUpdated = TypeConvertor.castToInstant(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToUri(value);
                return value;
            }
            case -309425751: {
                this.getProfile().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case 949122880: {
                this.getSecurity().add(TypeConvertor.castToCoding(value));
                return value;
            }
            case 114586: {
                this.getTag().add(TypeConvertor.castToCoding(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("versionId")) {
            this.versionId = TypeConvertor.castToId(value);
        } else if (name.equals("lastUpdated")) {
            this.lastUpdated = TypeConvertor.castToInstant(value);
        } else if (name.equals("source")) {
            this.source = TypeConvertor.castToUri(value);
        } else if (name.equals("profile")) {
            this.getProfile().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("security")) {
            this.getSecurity().add(TypeConvertor.castToCoding(value));
        } else if (name.equals("tag")) {
            this.getTag().add(TypeConvertor.castToCoding(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1407102957: {
                return this.getVersionIdElement();
            }
            case 1649733957: {
                return this.getLastUpdatedElement();
            }
            case -896505829: {
                return this.getSourceElement();
            }
            case -309425751: {
                return this.addProfileElement();
            }
            case 949122880: {
                return this.addSecurity();
            }
            case 114586: {
                return this.addTag();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1407102957: {
                return new String[]{"id"};
            }
            case 1649733957: {
                return new String[]{"instant"};
            }
            case -896505829: {
                return new String[]{"uri"};
            }
            case -309425751: {
                return new String[]{"canonical"};
            }
            case 949122880: {
                return new String[]{"Coding"};
            }
            case 114586: {
                return new String[]{"Coding"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("versionId")) {
            throw new FHIRException("Cannot call addChild on a primitive type Meta.versionId");
        }
        if (name.equals("lastUpdated")) {
            throw new FHIRException("Cannot call addChild on a primitive type Meta.lastUpdated");
        }
        if (name.equals("source")) {
            throw new FHIRException("Cannot call addChild on a primitive type Meta.source");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a primitive type Meta.profile");
        }
        if (name.equals("security")) {
            return this.addSecurity();
        }
        if (name.equals("tag")) {
            return this.addTag();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Meta";
    }

    @Override
    public Meta copy() {
        Meta dst = new Meta();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Meta dst) {
        super.copyValues(dst);
        dst.versionId = this.versionId == null ? null : this.versionId.copy();
        dst.lastUpdated = this.lastUpdated == null ? null : this.lastUpdated.copy();
        UriType uriType = dst.source = this.source == null ? null : this.source.copy();
        if (this.profile != null) {
            dst.profile = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.profile) {
                dst.profile.add(canonicalType.copy());
            }
        }
        if (this.security != null) {
            dst.security = new ArrayList<Coding>();
            for (Coding coding : this.security) {
                dst.security.add(coding.copy());
            }
        }
        if (this.tag != null) {
            dst.tag = new ArrayList<Coding>();
            for (Coding coding : this.tag) {
                dst.tag.add(coding.copy());
            }
        }
    }

    protected Meta typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Meta)) {
            return false;
        }
        Meta o = (Meta)other_;
        return Meta.compareDeep(this.versionId, o.versionId, true) && Meta.compareDeep(this.lastUpdated, o.lastUpdated, true) && Meta.compareDeep(this.source, o.source, true) && Meta.compareDeep(this.profile, o.profile, true) && Meta.compareDeep(this.security, o.security, true) && Meta.compareDeep(this.tag, o.tag, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Meta)) {
            return false;
        }
        Meta o = (Meta)other_;
        return Meta.compareValues(this.versionId, o.versionId, true) && Meta.compareValues(this.lastUpdated, o.lastUpdated, true) && Meta.compareValues(this.source, o.source, true) && Meta.compareValues(this.profile, o.profile, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.versionId, this.lastUpdated, this.source, this.profile, this.security, this.tag});
    }

    public Meta addTag(String theSystem, String theCode, String theDisplay) {
        this.addTag().setSystem(theSystem).setCode(theCode).setDisplay(theDisplay);
        return this;
    }

    public Coding getTag(String theSystem, String theCode) {
        for (Coding next : this.getTag()) {
            if (!ObjectUtil.equals((Object)next.getSystem(), (Object)theSystem) || !ObjectUtil.equals((Object)next.getCode(), (Object)theCode)) continue;
            return next;
        }
        return null;
    }

    public Coding getSecurity(String theSystem, String theCode) {
        for (Coding next : this.getTag()) {
            if (!ObjectUtil.equals((Object)next.getSystem(), (Object)theSystem) || !ObjectUtil.equals((Object)next.getCode(), (Object)theCode)) continue;
            return next;
        }
        return null;
    }
}

