/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.StringType;

public abstract class PrimitiveType<T>
extends DataType
implements IPrimitiveType<T>,
IBaseHasExtensions,
IElement,
Externalizable {
    private static final long serialVersionUID = 3L;
    private T myCoercedValue;
    private String myStringValue;

    public String asStringValue() {
        return this.myStringValue;
    }

    @Override
    public abstract DataType copy();

    protected abstract String encode(T var1);

    @Override
    public boolean equalsDeep(Base obj) {
        if (!super.equalsDeep(obj)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PrimitiveType o = (PrimitiveType)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.getValue(), o.getValue());
        return b.isEquals();
    }

    @Override
    public boolean equalsShallow(Base obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PrimitiveType o = (PrimitiveType)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.getValue(), o.getValue());
        return b.isEquals();
    }

    public void fromStringValue(String theValue) {
        this.myStringValue = theValue;
        this.myCoercedValue = theValue == null ? null : this.parse(theValue);
    }

    public T getValue() {
        return this.myCoercedValue;
    }

    public String getValueAsString() {
        return this.asStringValue();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getValue()).toHashCode();
    }

    public boolean hasValue() {
        return !StringUtils.isBlank((CharSequence)this.getValueAsString());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && StringUtils.isBlank((CharSequence)this.getValueAsString());
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    protected abstract T parse(String var1);

    @Override
    public String primitiveValue() {
        return this.asStringValue();
    }

    @Override
    public void readExternal(ObjectInput theIn) throws IOException, ClassNotFoundException {
        String object = (String)theIn.readObject();
        this.setValueAsString(object);
    }

    public PrimitiveType<T> setValue(T theValue) {
        this.myCoercedValue = theValue;
        this.updateStringValue();
        return this;
    }

    public void setValueAsString(String theValue) {
        this.fromStringValue(theValue);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.asStringValue() + "]";
    }

    protected DataType typedCopy() {
        return this.copy();
    }

    protected void updateStringValue() {
        this.myStringValue = this.myCoercedValue == null ? null : this.encode(this.myCoercedValue);
    }

    @Override
    public void writeExternal(ObjectOutput theOut) throws IOException {
        theOut.writeObject(this.getValueAsString());
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.setValueAsString(value.toString());
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("value")) {
            return super.setProperty(name, value);
        }
        this.setValueAsString(value.toString());
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        if (hash == 111972721) {
            return this;
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (hash == 111972721) {
            Base[] b = new Base[]{new StringType(this.getValueAsString())};
            return b;
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        if (name.equals("value")) {
            return new String[]{this.fhirType(), "string"};
        }
        return super.getTypesForProperty(hash, name);
    }

    protected void forceStringValue(String value) {
        this.myStringValue = value;
    }

    @Override
    public boolean hasPrimitiveValue() {
        return StringUtils.isNotBlank((CharSequence)this.getValueAsString());
    }
}

