/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.test.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.PackageCacheManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TestingUtilities {
    private static final boolean SHOW_DIFF = true;
    public static IWorkerContext fcontext;
    public static boolean silent;
    public static String fixedpath;
    public static String contentpath;

    public static IWorkerContext context() {
        if (fcontext == null) {
            try {
                PackageCacheManager pcm = new PackageCacheManager(true, 3);
                fcontext = SimpleWorkerContext.fromPackage(pcm.loadPackage("hl7.fhir.r4.core", "4.0.1"));
                fcontext.setUcumService((UcumService)new UcumEssenceService(TestingUtilities.loadTestResourceStream("ucum", "ucum-essence.xml")));
                fcontext.setExpansionProfile(new Parameters());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return fcontext;
    }

    public static String home() {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s = System.getenv("FHIR_HOME");
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = "C:\\work\\org.hl7.fhir\\build";
        s = "/Users/jamesagnew/git/fhir";
        if (new File(s).exists()) {
            return s;
        }
        throw new Error("FHIR Home directory not configured");
    }

    public static String content() throws IOException {
        if (contentpath != null) {
            return contentpath;
        }
        String s = "R:\\fhir\\publish";
        if (new File(s).exists()) {
            return s;
        }
        return Utilities.path((String[])new String[]{TestingUtilities.home(), "publish"});
    }

    public static String us() {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s = System.getenv("FHIR_HOME");
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = "C:\\work\\org.hl7.fhir.us";
        if (new File(s).exists()) {
            return s;
        }
        throw new Error("FHIR US directory not configured");
    }

    public static String checkXMLIsSame(InputStream f1, InputStream f2) throws Exception {
        String result = TestingUtilities.compareXml(f1, f2);
        return result;
    }

    public static String checkXMLIsSame(String f1, String f2) throws Exception {
        String result = TestingUtilities.compareXml(f1, f2);
        if (result != null) {
            String diff = Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe"});
            ArrayList<String> command = new ArrayList<String>();
            command.add("\"" + diff + "\" \"" + f1 + "\" \"" + f2 + "\"");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory((File)new CSFile("c:\\temp"));
            builder.start();
        }
        return result;
    }

    private static String compareXml(InputStream f1, InputStream f2) throws Exception {
        return TestingUtilities.compareElements("", TestingUtilities.loadXml(f1).getDocumentElement(), TestingUtilities.loadXml(f2).getDocumentElement());
    }

    private static String compareXml(String f1, String f2) throws Exception {
        return TestingUtilities.compareElements("", TestingUtilities.loadXml(f1).getDocumentElement(), TestingUtilities.loadXml(f2).getDocumentElement());
    }

    private static String compareElements(String path, Element e1, Element e2) {
        if (!e1.getNamespaceURI().equals(e2.getNamespaceURI())) {
            return "Namespaces differ at " + path + ": " + e1.getNamespaceURI() + "/" + e2.getNamespaceURI();
        }
        if (!e1.getLocalName().equals(e2.getLocalName())) {
            return "Names differ at " + path + ": " + e1.getLocalName() + "/" + e2.getLocalName();
        }
        String s = TestingUtilities.compareAttributes(path = path + "/" + e1.getLocalName(), e1.getAttributes(), e2.getAttributes());
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = TestingUtilities.compareAttributes(path, e2.getAttributes(), e1.getAttributes());
        if (!Utilities.noString((String)s)) {
            return s;
        }
        Node c1 = e1.getFirstChild();
        Node c2 = e2.getFirstChild();
        c1 = TestingUtilities.skipBlankText(c1);
        c2 = TestingUtilities.skipBlankText(c2);
        while (c1 != null && c2 != null) {
            if (c1.getNodeType() != c2.getNodeType()) {
                return "node type mismatch in children of " + path + ": " + Integer.toString(e1.getNodeType()) + "/" + Integer.toString(e2.getNodeType());
            }
            if (c1.getNodeType() == 3) {
                if (!TestingUtilities.normalise(c1.getTextContent()).equals(TestingUtilities.normalise(c2.getTextContent()))) {
                    return "Text differs at " + path + ": " + TestingUtilities.normalise(c1.getTextContent()) + "/" + TestingUtilities.normalise(c2.getTextContent());
                }
            } else if (c1.getNodeType() == 1 && !Utilities.noString((String)(s = TestingUtilities.compareElements(path, (Element)c1, (Element)c2)))) {
                return s;
            }
            c1 = TestingUtilities.skipBlankText(c1.getNextSibling());
            c2 = TestingUtilities.skipBlankText(c2.getNextSibling());
        }
        if (c1 != null) {
            return "node mismatch - more nodes in source in children of " + path;
        }
        if (c2 != null) {
            return "node mismatch - more nodes in target in children of " + path;
        }
        return null;
    }

    private static Object normalise(String text) {
        String result = text.trim().replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result;
    }

    private static String compareAttributes(String path, NamedNodeMap src, NamedNodeMap tgt) {
        for (int i = 0; i < src.getLength(); ++i) {
            byte[] b2;
            byte[] b1;
            Node sa = src.item(i);
            String sn = sa.getNodeName();
            if (sn.equals("xmlns") || sn.startsWith("xmlns:")) continue;
            Node ta = tgt.getNamedItem(sn);
            if (ta == null) {
                return "Attributes differ at " + path + ": missing attribute " + sn;
            }
            if (TestingUtilities.normalise(sa.getTextContent()).equals(TestingUtilities.normalise(ta.getTextContent())) || TestingUtilities.sameBytes(b1 = TestingUtilities.unBase64(sa.getTextContent()), b2 = TestingUtilities.unBase64(ta.getTextContent()))) continue;
            return "Attributes differ at " + path + ": value " + TestingUtilities.normalise(sa.getTextContent()) + "/" + TestingUtilities.normalise(ta.getTextContent());
        }
        return null;
    }

    private static boolean sameBytes(byte[] b1, byte[] b2) {
        if (b1.length == 0 || b2.length == 0) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] unBase64(String text) {
        return Base64.decodeBase64((String)text);
    }

    private static Node skipBlankText(Node node) {
        while (node != null && (node.getNodeType() == 3 && Utilities.isWhitespace((String)node.getTextContent()) || node.getNodeType() == 8)) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static Document loadXml(String fn) throws Exception {
        return TestingUtilities.loadXml(new FileInputStream(fn));
    }

    private static Document loadXml(InputStream fn) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(fn);
    }

    public static String checkJsonSrcIsSame(String s1, String s2) throws JsonSyntaxException, FileNotFoundException, IOException {
        return TestingUtilities.checkJsonSrcIsSame(s1, s2, true);
    }

    public static String checkJsonSrcIsSame(String s1, String s2, boolean showDiff) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = TestingUtilities.compareJsonSrc(s1, s2);
        if (result != null && showDiff) {
            String diff = null;
            if (System.getProperty("os.name").contains("Linux")) {
                diff = Utilities.path((String[])new String[]{"/", "usr", "bin", "meld"});
            } else if (Utilities.checkFile((String)"WinMerge", (String)Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "WinMerge"}), (String)"\\WinMergeU.exe", null)) {
                diff = Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe"});
            } else if (Utilities.checkFile((String)"WinMerge", (String)Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "Meld"}), (String)"\\Meld.exe", null)) {
                diff = Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "Meld", "Meld.exe"});
            }
            if (diff == null || diff.isEmpty()) {
                return result;
            }
            ArrayList<String> command = new ArrayList<String>();
            String f1 = Utilities.path((String[])new String[]{"[tmp]", "input" + s1.hashCode() + ".json"});
            String f2 = Utilities.path((String[])new String[]{"[tmp]", "output" + s2.hashCode() + ".json"});
            TextFile.stringToFile((String)s1, (String)f1);
            TextFile.stringToFile((String)s2, (String)f2);
            command.add(diff);
            if (diff.toLowerCase().contains("meld")) {
                command.add("--newtab");
            }
            command.add(f1);
            command.add(f2);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory((File)new CSFile(Utilities.path((String[])new String[]{"[tmp]"})));
            builder.start();
        }
        return result;
    }

    public static String checkJsonIsSame(String f1, String f2) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = TestingUtilities.compareJson(f1, f2);
        if (result != null) {
            String diff = Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe"});
            ArrayList<String> command = new ArrayList<String>();
            command.add("\"" + diff + "\" \"" + f1 + "\" \"" + f2 + "\"");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory((File)new CSFile("c:\\temp"));
            builder.start();
        }
        return result;
    }

    private static String compareJsonSrc(String f1, String f2) throws JsonSyntaxException, FileNotFoundException, IOException {
        JsonObject o1 = (JsonObject)new JsonParser().parse(f1);
        JsonObject o2 = (JsonObject)new JsonParser().parse(f2);
        return TestingUtilities.compareObjects("", o1, o2);
    }

    private static String compareJson(String f1, String f2) throws JsonSyntaxException, FileNotFoundException, IOException {
        JsonObject o1 = (JsonObject)new JsonParser().parse(TextFile.fileToString((String)f1));
        JsonObject o2 = (JsonObject)new JsonParser().parse(TextFile.fileToString((String)f2));
        return TestingUtilities.compareObjects("", o1, o2);
    }

    private static String compareObjects(String path, JsonObject o1, JsonObject o2) {
        String n;
        for (Map.Entry en : o1.entrySet()) {
            n = (String)en.getKey();
            if (n.equals("fhir_comments")) continue;
            if (o2.has(n)) {
                String s = TestingUtilities.compareNodes(path + '.' + n, (JsonElement)en.getValue(), o2.get(n));
                if (Utilities.noString((String)s)) continue;
                return s;
            }
            return "properties differ at " + path + ": missing property " + n;
        }
        for (Map.Entry en : o2.entrySet()) {
            n = (String)en.getKey();
            if (n.equals("fhir_comments") || o1.has(n)) continue;
            return "properties differ at " + path + ": missing property " + n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String compareNodes(String path, JsonElement n1, JsonElement n2) {
        if (n1.getClass() != n2.getClass()) {
            return "properties differ at " + path + ": type " + n1.getClass().getName() + "/" + n2.getClass().getName();
        }
        if (n1 instanceof JsonPrimitive) {
            JsonPrimitive p1 = (JsonPrimitive)n1;
            JsonPrimitive p2 = (JsonPrimitive)n2;
            if (p1.isBoolean() && p2.isBoolean()) {
                if (p1.getAsBoolean() == p2.getAsBoolean()) return null;
                return "boolean property values differ at " + path + ": type " + p1.getAsString() + "/" + p2.getAsString();
            }
            if (p1.isString() && p2.isString()) {
                String s1 = p1.getAsString();
                String s2 = p2.getAsString();
                if (s1.contains("<div") && s2.contains("<div") || s1.equals(s2) || TestingUtilities.sameBytes(TestingUtilities.unBase64(s1), TestingUtilities.unBase64(s2))) return null;
                return "string property values differ at " + path + ": type " + s1 + "/" + s2;
            }
            if (!p1.isNumber() || !p2.isNumber()) return "property types differ at " + path + ": type " + p1.getAsString() + "/" + p2.getAsString();
            if (p1.getAsString().equals(p2.getAsString())) return null;
            return "number property values differ at " + path + ": type " + p1.getAsString() + "/" + p2.getAsString();
        }
        if (n1 instanceof JsonObject) {
            String s = TestingUtilities.compareObjects(path, (JsonObject)n1, (JsonObject)n2);
            if (Utilities.noString((String)s)) return null;
            return s;
        }
        if (n1 instanceof JsonArray) {
            JsonArray a1 = (JsonArray)n1;
            JsonArray a2 = (JsonArray)n2;
            if (a1.size() != a2.size()) {
                return "array properties differ at " + path + ": count " + Integer.toString(a1.size()) + "/" + Integer.toString(a2.size());
            }
            for (int i = 0; i < a1.size(); ++i) {
                String s = TestingUtilities.compareNodes(path + "[" + Integer.toString(i) + "]", a1.get(i), a2.get(i));
                if (Utilities.noString((String)s)) continue;
                return s;
            }
            return null;
        } else {
            if (n1 instanceof JsonNull) return null;
            return "unhandled property " + n1.getClass().getName();
        }
    }

    public static String temp() {
        if (new File("c:\\temp").exists()) {
            return "c:\\temp";
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static String checkTextIsSame(String s1, String s2) throws JsonSyntaxException, FileNotFoundException, IOException {
        return TestingUtilities.checkTextIsSame(s1, s2, true);
    }

    public static String checkTextIsSame(String s1, String s2, boolean showDiff) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = TestingUtilities.compareText(s1, s2);
        if (result != null && showDiff) {
            String diff = null;
            if (System.getProperty("os.name").contains("Linux")) {
                diff = Utilities.path((String[])new String[]{"/", "usr", "bin", "meld"});
            } else if (Utilities.checkFile((String)"WinMerge", (String)Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "WinMerge"}), (String)"\\WinMergeU.exe", null)) {
                diff = Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe"});
            } else if (Utilities.checkFile((String)"WinMerge", (String)Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "Meld"}), (String)"\\Meld.exe", null)) {
                diff = Utilities.path((String[])new String[]{System.getenv("ProgramFiles(X86)"), "Meld", "Meld.exe"});
            }
            if (diff == null || diff.isEmpty()) {
                return result;
            }
            ArrayList<String> command = new ArrayList<String>();
            String f1 = Utilities.path((String[])new String[]{"[tmp]", "input" + s1.hashCode() + ".json"});
            String f2 = Utilities.path((String[])new String[]{"[tmp]", "output" + s2.hashCode() + ".json"});
            TextFile.stringToFile((String)s1, (String)f1);
            TextFile.stringToFile((String)s2, (String)f2);
            command.add(diff);
            if (diff.toLowerCase().contains("meld")) {
                command.add("--newtab");
            }
            command.add(f1);
            command.add(f2);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory((File)new CSFile(Utilities.path((String[])new String[]{"[tmp]"})));
            builder.start();
        }
        return result;
    }

    private static String compareText(String s1, String s2) {
        for (int i = 0; i < Integer.min(s1.length(), s2.length()); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return "Strings differ at character " + Integer.toString(i) + ": '" + s1.charAt(i) + "' vs '" + s2.charAt(i) + "'";
        }
        if (s1.length() != s2.length()) {
            return "Strings differ in length: " + Integer.toString(s1.length()) + " vs " + Integer.toString(s2.length()) + " but match to the end of the shortest";
        }
        return null;
    }

    public static boolean findTestResource(String ... paths) throws IOException {
        if (new File("../../fhir-test-cases").exists() && TestingUtilities.isTryToLoadFromFileSystem()) {
            String n = Utilities.path((String[])new String[]{System.getProperty("user.dir"), "..", "..", "fhir-test-cases", Utilities.path((String[])paths)});
            return new File(n).exists();
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL((String[])paths);
        try {
            InputStream inputStream = TestingUtilities.class.getResourceAsStream(classpath);
            return inputStream != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isTryToLoadFromFileSystem() {
        return !"true".equals(System.getProperty("dont_load_from_filesystem"));
    }

    public static String loadTestResource(String ... paths) throws IOException {
        String contents;
        if (new File("../../fhir-test-cases").exists() && TestingUtilities.isTryToLoadFromFileSystem()) {
            String n = Utilities.path((String[])new String[]{System.getProperty("user.dir"), "..", "..", "fhir-test-cases", Utilities.path((String[])paths)});
            return TextFile.fileToString((File)new File(n));
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL((String[])paths);
        try (InputStream inputStream = TestingUtilities.class.getResourceAsStream(classpath);){
            if (inputStream == null) {
                throw new IOException("Can't find file on classpath: " + classpath);
            }
            contents = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        return contents;
    }

    public static InputStream loadTestResourceStream(String ... paths) throws IOException {
        if (new File("../../fhir-test-cases").exists() && TestingUtilities.isTryToLoadFromFileSystem()) {
            String n = Utilities.path((String[])new String[]{System.getProperty("user.dir"), "..", "..", "fhir-test-cases", Utilities.path((String[])paths)});
            return new FileInputStream(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL((String[])paths);
        InputStream s = TestingUtilities.class.getResourceAsStream(classpath);
        if (s == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return s;
    }

    public static byte[] loadTestResourceBytes(String ... paths) throws IOException {
        if (new File("../../fhir-test-cases").exists() && TestingUtilities.isTryToLoadFromFileSystem()) {
            String n = Utilities.path((String[])new String[]{System.getProperty("user.dir"), "..", "..", "fhir-test-cases", Utilities.path((String[])paths)});
            return TextFile.fileToBytes((String)n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL((String[])paths);
        InputStream s = TestingUtilities.class.getResourceAsStream(classpath);
        if (s == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return TextFile.streamToBytes((InputStream)s);
    }

    public static String tempFile(String folder, String name) throws IOException {
        String tmp = TestingUtilities.tempFolder(folder);
        return Utilities.path((String[])new String[]{tmp, name});
    }

    public static String tempFolder(String name) throws IOException {
        File tmp = new File("C:\\temp");
        if (tmp.exists() && tmp.isDirectory()) {
            String path = Utilities.path((String[])new String[]{"C:\\temp", name});
            Utilities.createDirectory((String)path);
            return path;
        }
        if (new File("/tmp").exists()) {
            String path = Utilities.path((String[])new String[]{"/tmp", name});
            Utilities.createDirectory((String)path);
            return path;
        }
        String path = Utilities.path((String[])new String[]{System.getProperty("java.io.tmpdir"), name});
        Utilities.createDirectory((String)path);
        return path;
    }
}

