/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Bundle", profile="http://hl7.org/fhir/StructureDefinition/Bundle")
public class Bundle
extends Resource
implements IBaseBundle {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Persistent identifier for the bundle", formalDefinition="A persistent identifier for the bundle that won't change as a bundle is copied from server to server.")
    protected Identifier identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification", formalDefinition="Indicates the purpose of this bundle - how it is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/bundle-type")
    protected Enumeration<BundleType> type;
    @Child(name="timestamp", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the bundle was assembled", formalDefinition="The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.")
    protected InstantType timestamp;
    @Child(name="total", type={UnsignedIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If search, the total number of matches", formalDefinition="If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.")
    protected UnsignedIntType total;
    @Child(name="link", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Links related to this Bundle", formalDefinition="A series of links that provide context to this bundle.")
    protected List<BundleLinkComponent> link;
    @Child(name="entry", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Entry in the bundle - will have a resource or information", formalDefinition="An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).")
    protected List<BundleEntryComponent> entry;
    @Child(name="signature", type={Signature.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Digital Signature", formalDefinition="Digital Signature - base64 encoded. XML-DSig or a JWS.")
    protected Signature signature;
    @Child(name="issues", type={Resource.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Issues with the Bundle", formalDefinition="Captures issues and warnings that relate to the construction of the Bundle and the content within it.")
    protected Resource issues;
    private static final long serialVersionUID = -843739668L;
    @SearchParamDefinition(name="composition", path="Bundle.entry[0].resource as Composition", description="The first resource in the bundle, if the bundle type is \"document\" - this is a composition, and this parameter provides access to search its contents", type="reference")
    public static final String SP_COMPOSITION = "composition";
    public static final ReferenceClientParam COMPOSITION = new ReferenceClientParam("composition");
    public static final Include INCLUDE_COMPOSITION = new Include("Bundle:composition").toLocked();
    @SearchParamDefinition(name="identifier", path="Bundle.identifier", description="Persistent identifier for the bundle", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="message", path="Bundle.entry[0].resource as MessageHeader", description="The first resource in the bundle, if the bundle type is \"message\" - this is a message header, and this parameter provides access to search its contents", type="reference")
    public static final String SP_MESSAGE = "message";
    public static final ReferenceClientParam MESSAGE = new ReferenceClientParam("message");
    public static final Include INCLUDE_MESSAGE = new Include("Bundle:message").toLocked();
    @SearchParamDefinition(name="timestamp", path="Bundle.timestamp", description="When the bundle was assembled", type="date")
    public static final String SP_TIMESTAMP = "timestamp";
    public static final DateClientParam TIMESTAMP = new DateClientParam("timestamp");
    @SearchParamDefinition(name="type", path="Bundle.type", description="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="example-constraint", path="Bundle.entry[0].resource", description="Search Composition Bundle", type="reference", target={Composition.class})
    public static final String SP_EXAMPLE_CONSTRAINT = "example-constraint";
    public static final ReferenceClientParam EXAMPLE_CONSTRAINT = new ReferenceClientParam("example-constraint");
    public static final Include INCLUDE_EXAMPLE_CONSTRAINT = new Include("Bundle:example-constraint").toLocked();

    public Bundle() {
    }

    public Bundle(BundleType type) {
        this.setType(type);
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Bundle setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<BundleType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Bundle setTypeElement(Enumeration<BundleType> value) {
        this.type = value;
        return this;
    }

    public BundleType getType() {
        return this.type == null ? null : (BundleType)((Object)this.type.getValue());
    }

    public Bundle setType(BundleType value) {
        if (this.type == null) {
            this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public InstantType getTimestampElement() {
        if (this.timestamp == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.timestamp");
            }
            if (Configuration.doAutoCreate()) {
                this.timestamp = new InstantType();
            }
        }
        return this.timestamp;
    }

    public boolean hasTimestampElement() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public boolean hasTimestamp() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public Bundle setTimestampElement(InstantType value) {
        this.timestamp = value;
        return this;
    }

    public Date getTimestamp() {
        return this.timestamp == null ? null : (Date)this.timestamp.getValue();
    }

    public Bundle setTimestamp(Date value) {
        if (value == null) {
            this.timestamp = null;
        } else {
            if (this.timestamp == null) {
                this.timestamp = new InstantType();
            }
            this.timestamp.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getTotalElement() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new UnsignedIntType();
            }
        }
        return this.total;
    }

    public boolean hasTotalElement() {
        return this.total != null && !this.total.isEmpty();
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public Bundle setTotalElement(UnsignedIntType value) {
        this.total = value;
        return this;
    }

    public int getTotal() {
        return this.total == null || this.total.isEmpty() ? 0 : (Integer)this.total.getValue();
    }

    public Bundle setTotal(int value) {
        if (this.total == null) {
            this.total = new UnsignedIntType();
        }
        this.total.setValue((Object)value);
        return this;
    }

    public List<BundleLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        return this.link;
    }

    public Bundle setLink(List<BundleLinkComponent> theLink) {
        this.link = theLink;
        return this;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (BundleLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BundleLinkComponent addLink() {
        BundleLinkComponent t = new BundleLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public Bundle addLink(BundleLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public BundleLinkComponent getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            this.addLink();
        }
        return this.getLink().get(0);
    }

    public List<BundleEntryComponent> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        return this.entry;
    }

    public Bundle setEntry(List<BundleEntryComponent> theEntry) {
        this.entry = theEntry;
        return this;
    }

    public boolean hasEntry() {
        if (this.entry == null) {
            return false;
        }
        for (BundleEntryComponent item : this.entry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BundleEntryComponent addEntry() {
        BundleEntryComponent t = new BundleEntryComponent();
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        this.entry.add(t);
        return t;
    }

    public Bundle addEntry(BundleEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        this.entry.add(t);
        return this;
    }

    public BundleEntryComponent getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public Signature getSignature() {
        if (this.signature == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.signature");
            }
            if (Configuration.doAutoCreate()) {
                this.signature = new Signature();
            }
        }
        return this.signature;
    }

    public boolean hasSignature() {
        return this.signature != null && !this.signature.isEmpty();
    }

    public Bundle setSignature(Signature value) {
        this.signature = value;
        return this;
    }

    public Resource getIssues() {
        return this.issues;
    }

    public boolean hasIssues() {
        return this.issues != null && !this.issues.isEmpty();
    }

    public Bundle setIssues(Resource value) {
        this.issues = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A persistent identifier for the bundle that won't change as a bundle is copied from server to server.", 0, 1, this.identifier));
        children.add(new Property(SP_TYPE, "code", "Indicates the purpose of this bundle - how it is intended to be used.", 0, 1, this.type));
        children.add(new Property(SP_TIMESTAMP, "instant", "The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.", 0, 1, this.timestamp));
        children.add(new Property("total", "unsignedInt", "If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.", 0, 1, this.total));
        children.add(new Property("link", "", "A series of links that provide context to this bundle.", 0, Integer.MAX_VALUE, this.link));
        children.add(new Property("entry", "", "An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).", 0, Integer.MAX_VALUE, this.entry));
        children.add(new Property("signature", "Signature", "Digital Signature - base64 encoded. XML-DSig or a JWS.", 0, 1, this.signature));
        children.add(new Property("issues", "Resource", "Captures issues and warnings that relate to the construction of the Bundle and the content within it.", 0, 1, this.issues));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A persistent identifier for the bundle that won't change as a bundle is copied from server to server.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "Indicates the purpose of this bundle - how it is intended to be used.", 0, 1, this.type);
            }
            case 55126294: {
                return new Property(SP_TIMESTAMP, "instant", "The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.", 0, 1, this.timestamp);
            }
            case 110549828: {
                return new Property("total", "unsignedInt", "If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.", 0, 1, this.total);
            }
            case 3321850: {
                return new Property("link", "", "A series of links that provide context to this bundle.", 0, Integer.MAX_VALUE, this.link);
            }
            case 96667762: {
                return new Property("entry", "", "An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).", 0, Integer.MAX_VALUE, this.entry);
            }
            case 1073584312: {
                return new Property("signature", "Signature", "Digital Signature - base64 encoded. XML-DSig or a JWS.", 0, 1, this.signature);
            }
            case -1179159878: {
                return new Property("issues", "Resource", "Captures issues and warnings that relate to the construction of the Bundle and the content within it.", 0, 1, this.issues);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 55126294: {
                Base[] baseArray;
                if (this.timestamp == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.timestamp;
                }
                return baseArray;
            }
            case 110549828: {
                Base[] baseArray;
                if (this.total == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.total;
                }
                return baseArray;
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
            case 96667762: {
                return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
            }
            case 1073584312: {
                Base[] baseArray;
                if (this.signature == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.signature;
                }
                return baseArray;
            }
            case -1179159878: {
                Base[] baseArray;
                if (this.issues == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.issues;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                value = new BundleTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case 55126294: {
                this.timestamp = TypeConvertor.castToInstant(value);
                return value;
            }
            case 110549828: {
                this.total = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case 3321850: {
                this.getLink().add((BundleLinkComponent)((Object)value));
                return value;
            }
            case 96667762: {
                this.getEntry().add((BundleEntryComponent)((Object)value));
                return value;
            }
            case 1073584312: {
                this.signature = TypeConvertor.castToSignature(value);
                return value;
            }
            case -1179159878: {
                this.issues = TypeConvertor.castToResource(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_TYPE)) {
            value = new BundleTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_TIMESTAMP)) {
            this.timestamp = TypeConvertor.castToInstant(value);
        } else if (name.equals("total")) {
            this.total = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("link")) {
            this.getLink().add((BundleLinkComponent)((Object)value));
        } else if (name.equals("entry")) {
            this.getEntry().add((BundleEntryComponent)((Object)value));
        } else if (name.equals("signature")) {
            this.signature = TypeConvertor.castToSignature(value);
        } else if (name.equals("issues")) {
            this.issues = TypeConvertor.castToResource(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 55126294: {
                return this.getTimestampElement();
            }
            case 110549828: {
                return this.getTotalElement();
            }
            case 3321850: {
                return this.addLink();
            }
            case 96667762: {
                return this.addEntry();
            }
            case 1073584312: {
                return this.getSignature();
            }
            case -1179159878: {
                throw new FHIRException("Cannot make property issues as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 55126294: {
                return new String[]{"instant"};
            }
            case 110549828: {
                return new String[]{"unsignedInt"};
            }
            case 3321850: {
                return new String[0];
            }
            case 96667762: {
                return new String[0];
            }
            case 1073584312: {
                return new String[]{"Signature"};
            }
            case -1179159878: {
                return new String[]{"Resource"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Bundle.type");
        }
        if (name.equals(SP_TIMESTAMP)) {
            throw new FHIRException("Cannot call addChild on a primitive type Bundle.timestamp");
        }
        if (name.equals("total")) {
            throw new FHIRException("Cannot call addChild on a primitive type Bundle.total");
        }
        if (name.equals("link")) {
            return this.addLink();
        }
        if (name.equals("entry")) {
            return this.addEntry();
        }
        if (name.equals("signature")) {
            this.signature = new Signature();
            return this.signature;
        }
        if (name.equals("issues")) {
            throw new FHIRException("Cannot call addChild on an abstract type Bundle.issues");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Bundle";
    }

    @Override
    public Bundle copy() {
        Bundle dst = new Bundle();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Bundle dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
        UnsignedIntType unsignedIntType = dst.total = this.total == null ? null : this.total.copy();
        if (this.link != null) {
            dst.link = new ArrayList<BundleLinkComponent>();
            for (BundleLinkComponent bundleLinkComponent : this.link) {
                dst.link.add(bundleLinkComponent.copy());
            }
        }
        if (this.entry != null) {
            dst.entry = new ArrayList<BundleEntryComponent>();
            for (BundleEntryComponent bundleEntryComponent : this.entry) {
                dst.entry.add(bundleEntryComponent.copy());
            }
        }
        dst.signature = this.signature == null ? null : this.signature.copy();
        dst.issues = this.issues == null ? null : this.issues.copy();
    }

    protected Bundle typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Bundle)) {
            return false;
        }
        Bundle o = (Bundle)other_;
        return Bundle.compareDeep(this.identifier, o.identifier, true) && Bundle.compareDeep(this.type, o.type, true) && Bundle.compareDeep(this.timestamp, o.timestamp, true) && Bundle.compareDeep(this.total, o.total, true) && Bundle.compareDeep(this.link, o.link, true) && Bundle.compareDeep(this.entry, o.entry, true) && Bundle.compareDeep(this.signature, o.signature, true) && Bundle.compareDeep(this.issues, o.issues, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Bundle)) {
            return false;
        }
        Bundle o = (Bundle)other_;
        return Bundle.compareValues(this.type, o.type, true) && Bundle.compareValues(this.timestamp, o.timestamp, true) && Bundle.compareValues(this.total, o.total, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.timestamp, this.total, this.link, this.entry, this.signature, this.issues});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Bundle;
    }

    public BundleLinkComponent getLink(String theRelation) {
        Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
        for (BundleLinkComponent next : this.getLink()) {
            if (!theRelation.equals((Object)next.getRelation())) continue;
            return next;
        }
        return null;
    }

    public BundleLinkComponent getLinkOrCreate(String theRelation) {
        Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
        for (BundleLinkComponent next : this.getLink()) {
            if (!theRelation.equals((Object)next.getRelation())) continue;
            return next;
        }
        BundleLinkComponent retVal = new BundleLinkComponent();
        retVal.setRelation(LinkRelationTypes.fromCode(theRelation));
        this.getLink().add(retVal);
        return retVal;
    }

    @Block
    public static class BundleEntryResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status response code (text optional)", formalDefinition="The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.")
        protected StringType status;
        @Child(name="location", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The location (if the operation returns a location)", formalDefinition="The location header created by processing this operation, populated if the operation returns a location.")
        protected UriType location;
        @Child(name="etag", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Etag for the resource (if relevant)", formalDefinition="The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).")
        protected StringType etag;
        @Child(name="lastModified", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Server's date time modified", formalDefinition="The date/time that the resource was modified on the server.")
        protected InstantType lastModified;
        @Child(name="outcome", type={Resource.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="OperationOutcome with hints and warnings (for batch/transaction)", formalDefinition="An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.")
        protected Resource outcome;
        private static final long serialVersionUID = 923278008L;

        public BundleEntryResponseComponent() {
        }

        public BundleEntryResponseComponent(String status) {
            this.setStatus(status);
        }

        public StringType getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new StringType();
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public BundleEntryResponseComponent setStatusElement(StringType value) {
            this.status = value;
            return this;
        }

        public String getStatus() {
            return this.status == null ? null : (String)this.status.getValue();
        }

        public BundleEntryResponseComponent setStatus(String value) {
            if (this.status == null) {
                this.status = new StringType();
            }
            this.status.setValue(value);
            return this;
        }

        public UriType getLocationElement() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new UriType();
                }
            }
            return this.location;
        }

        public boolean hasLocationElement() {
            return this.location != null && !this.location.isEmpty();
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public BundleEntryResponseComponent setLocationElement(UriType value) {
            this.location = value;
            return this;
        }

        public String getLocation() {
            return this.location == null ? null : (String)this.location.getValue();
        }

        public BundleEntryResponseComponent setLocation(String value) {
            if (Utilities.noString((String)value)) {
                this.location = null;
            } else {
                if (this.location == null) {
                    this.location = new UriType();
                }
                this.location.setValue(value);
            }
            return this;
        }

        public StringType getEtagElement() {
            if (this.etag == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.etag");
                }
                if (Configuration.doAutoCreate()) {
                    this.etag = new StringType();
                }
            }
            return this.etag;
        }

        public boolean hasEtagElement() {
            return this.etag != null && !this.etag.isEmpty();
        }

        public boolean hasEtag() {
            return this.etag != null && !this.etag.isEmpty();
        }

        public BundleEntryResponseComponent setEtagElement(StringType value) {
            this.etag = value;
            return this;
        }

        public String getEtag() {
            return this.etag == null ? null : (String)this.etag.getValue();
        }

        public BundleEntryResponseComponent setEtag(String value) {
            if (Utilities.noString((String)value)) {
                this.etag = null;
            } else {
                if (this.etag == null) {
                    this.etag = new StringType();
                }
                this.etag.setValue(value);
            }
            return this;
        }

        public InstantType getLastModifiedElement() {
            if (this.lastModified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.lastModified");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastModified = new InstantType();
                }
            }
            return this.lastModified;
        }

        public boolean hasLastModifiedElement() {
            return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public boolean hasLastModified() {
            return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public BundleEntryResponseComponent setLastModifiedElement(InstantType value) {
            this.lastModified = value;
            return this;
        }

        public Date getLastModified() {
            return this.lastModified == null ? null : (Date)this.lastModified.getValue();
        }

        public BundleEntryResponseComponent setLastModified(Date value) {
            if (value == null) {
                this.lastModified = null;
            } else {
                if (this.lastModified == null) {
                    this.lastModified = new InstantType();
                }
                this.lastModified.setValue(value);
            }
            return this;
        }

        public Resource getOutcome() {
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public BundleEntryResponseComponent setOutcome(Resource value) {
            this.outcome = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, 1, this.status));
            children.add(new Property("location", "uri", "The location header created by processing this operation, populated if the operation returns a location.", 0, 1, this.location));
            children.add(new Property("etag", "string", "The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).", 0, 1, this.etag));
            children.add(new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, 1, this.lastModified));
            children.add(new Property("outcome", "Resource", "An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.", 0, 1, this.outcome));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, 1, this.status);
                }
                case 1901043637: {
                    return new Property("location", "uri", "The location header created by processing this operation, populated if the operation returns a location.", 0, 1, this.location);
                }
                case 3123477: {
                    return new Property("etag", "string", "The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).", 0, 1, this.etag);
                }
                case 1959003007: {
                    return new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, 1, this.lastModified);
                }
                case -1106507950: {
                    return new Property("outcome", "Resource", "An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.", 0, 1, this.outcome);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.location;
                    }
                    return baseArray;
                }
                case 3123477: {
                    Base[] baseArray;
                    if (this.etag == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.etag;
                    }
                    return baseArray;
                }
                case 1959003007: {
                    Base[] baseArray;
                    if (this.lastModified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lastModified;
                    }
                    return baseArray;
                }
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.outcome;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = TypeConvertor.castToString(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToUri(value);
                    return value;
                }
                case 3123477: {
                    this.etag = TypeConvertor.castToString(value);
                    return value;
                }
                case 1959003007: {
                    this.lastModified = TypeConvertor.castToInstant(value);
                    return value;
                }
                case -1106507950: {
                    this.outcome = TypeConvertor.castToResource(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("status")) {
                this.status = TypeConvertor.castToString(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToUri(value);
            } else if (name.equals("etag")) {
                this.etag = TypeConvertor.castToString(value);
            } else if (name.equals("lastModified")) {
                this.lastModified = TypeConvertor.castToInstant(value);
            } else if (name.equals("outcome")) {
                this.outcome = TypeConvertor.castToResource(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatusElement();
                }
                case 1901043637: {
                    return this.getLocationElement();
                }
                case 3123477: {
                    return this.getEtagElement();
                }
                case 1959003007: {
                    return this.getLastModifiedElement();
                }
                case -1106507950: {
                    throw new FHIRException("Cannot make property outcome as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"string"};
                }
                case 1901043637: {
                    return new String[]{"uri"};
                }
                case 3123477: {
                    return new String[]{"string"};
                }
                case 1959003007: {
                    return new String[]{"instant"};
                }
                case -1106507950: {
                    return new String[]{"Resource"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("status")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.response.status");
            }
            if (name.equals("location")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.response.location");
            }
            if (name.equals("etag")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.response.etag");
            }
            if (name.equals("lastModified")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.response.lastModified");
            }
            if (name.equals("outcome")) {
                throw new FHIRException("Cannot call addChild on an abstract type Bundle.entry.response.outcome");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryResponseComponent copy() {
            BundleEntryResponseComponent dst = new BundleEntryResponseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntryResponseComponent dst) {
            super.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.etag = this.etag == null ? null : this.etag.copy();
            dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryResponseComponent)) {
                return false;
            }
            BundleEntryResponseComponent o = (BundleEntryResponseComponent)other_;
            return BundleEntryResponseComponent.compareDeep(this.status, o.status, true) && BundleEntryResponseComponent.compareDeep(this.location, o.location, true) && BundleEntryResponseComponent.compareDeep(this.etag, o.etag, true) && BundleEntryResponseComponent.compareDeep(this.lastModified, o.lastModified, true) && BundleEntryResponseComponent.compareDeep(this.outcome, o.outcome, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryResponseComponent)) {
                return false;
            }
            BundleEntryResponseComponent o = (BundleEntryResponseComponent)other_;
            return BundleEntryResponseComponent.compareValues(this.status, o.status, true) && BundleEntryResponseComponent.compareValues(this.location, o.location, true) && BundleEntryResponseComponent.compareValues(this.etag, o.etag, true) && BundleEntryResponseComponent.compareValues(this.lastModified, o.lastModified, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.status, this.location, this.etag, this.lastModified, this.outcome});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.response";
        }
    }

    @Block
    public static class BundleEntryRequestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="method", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="GET | HEAD | POST | PUT | DELETE | PATCH", formalDefinition="In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/http-verb")
        protected Enumeration<HTTPVerb> method;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL for HTTP equivalent of this entry", formalDefinition="The URL for this entry, relative to the root (the address to which the request is posted).")
        protected UriType url;
        @Child(name="ifNoneMatch", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache validation", formalDefinition="If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).")
        protected StringType ifNoneMatch;
        @Child(name="ifModifiedSince", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache currency", formalDefinition="Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).")
        protected InstantType ifModifiedSince;
        @Child(name="ifMatch", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing update contention", formalDefinition="Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).")
        protected StringType ifMatch;
        @Child(name="ifNoneExist", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For conditional creates", formalDefinition="Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").")
        protected StringType ifNoneExist;
        private static final long serialVersionUID = -1349769744L;

        public BundleEntryRequestComponent() {
        }

        public BundleEntryRequestComponent(HTTPVerb method, String url) {
            this.setMethod(method);
            this.setUrl(url);
        }

        public Enumeration<HTTPVerb> getMethodElement() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
                }
            }
            return this.method;
        }

        public boolean hasMethodElement() {
            return this.method != null && !this.method.isEmpty();
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public BundleEntryRequestComponent setMethodElement(Enumeration<HTTPVerb> value) {
            this.method = value;
            return this;
        }

        public HTTPVerb getMethod() {
            return this.method == null ? null : (HTTPVerb)((Object)this.method.getValue());
        }

        public BundleEntryRequestComponent setMethod(HTTPVerb value) {
            if (this.method == null) {
                this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
            }
            this.method.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public BundleEntryRequestComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public BundleEntryRequestComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public StringType getIfNoneMatchElement() {
            if (this.ifNoneMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifNoneMatch = new StringType();
                }
            }
            return this.ifNoneMatch;
        }

        public boolean hasIfNoneMatchElement() {
            return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public boolean hasIfNoneMatch() {
            return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public BundleEntryRequestComponent setIfNoneMatchElement(StringType value) {
            this.ifNoneMatch = value;
            return this;
        }

        public String getIfNoneMatch() {
            return this.ifNoneMatch == null ? null : (String)this.ifNoneMatch.getValue();
        }

        public BundleEntryRequestComponent setIfNoneMatch(String value) {
            if (Utilities.noString((String)value)) {
                this.ifNoneMatch = null;
            } else {
                if (this.ifNoneMatch == null) {
                    this.ifNoneMatch = new StringType();
                }
                this.ifNoneMatch.setValue(value);
            }
            return this;
        }

        public InstantType getIfModifiedSinceElement() {
            if (this.ifModifiedSince == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifModifiedSince");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifModifiedSince = new InstantType();
                }
            }
            return this.ifModifiedSince;
        }

        public boolean hasIfModifiedSinceElement() {
            return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public boolean hasIfModifiedSince() {
            return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public BundleEntryRequestComponent setIfModifiedSinceElement(InstantType value) {
            this.ifModifiedSince = value;
            return this;
        }

        public Date getIfModifiedSince() {
            return this.ifModifiedSince == null ? null : (Date)this.ifModifiedSince.getValue();
        }

        public BundleEntryRequestComponent setIfModifiedSince(Date value) {
            if (value == null) {
                this.ifModifiedSince = null;
            } else {
                if (this.ifModifiedSince == null) {
                    this.ifModifiedSince = new InstantType();
                }
                this.ifModifiedSince.setValue(value);
            }
            return this;
        }

        public StringType getIfMatchElement() {
            if (this.ifMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifMatch = new StringType();
                }
            }
            return this.ifMatch;
        }

        public boolean hasIfMatchElement() {
            return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public boolean hasIfMatch() {
            return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public BundleEntryRequestComponent setIfMatchElement(StringType value) {
            this.ifMatch = value;
            return this;
        }

        public String getIfMatch() {
            return this.ifMatch == null ? null : (String)this.ifMatch.getValue();
        }

        public BundleEntryRequestComponent setIfMatch(String value) {
            if (Utilities.noString((String)value)) {
                this.ifMatch = null;
            } else {
                if (this.ifMatch == null) {
                    this.ifMatch = new StringType();
                }
                this.ifMatch.setValue(value);
            }
            return this;
        }

        public StringType getIfNoneExistElement() {
            if (this.ifNoneExist == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneExist");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifNoneExist = new StringType();
                }
            }
            return this.ifNoneExist;
        }

        public boolean hasIfNoneExistElement() {
            return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public boolean hasIfNoneExist() {
            return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public BundleEntryRequestComponent setIfNoneExistElement(StringType value) {
            this.ifNoneExist = value;
            return this;
        }

        public String getIfNoneExist() {
            return this.ifNoneExist == null ? null : (String)this.ifNoneExist.getValue();
        }

        public BundleEntryRequestComponent setIfNoneExist(String value) {
            if (Utilities.noString((String)value)) {
                this.ifNoneExist = null;
            } else {
                if (this.ifNoneExist == null) {
                    this.ifNoneExist = new StringType();
                }
                this.ifNoneExist.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("method", "code", "In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.", 0, 1, this.method));
            children.add(new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, 1, this.url));
            children.add(new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifNoneMatch));
            children.add(new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifModifiedSince));
            children.add(new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, 1, this.ifMatch));
            children.add(new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, 1, this.ifNoneExist));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1077554975: {
                    return new Property("method", "code", "In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.", 0, 1, this.method);
                }
                case 116079: {
                    return new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, 1, this.url);
                }
                case 171868368: {
                    return new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifNoneMatch);
                }
                case -2061602860: {
                    return new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifModifiedSince);
                }
                case 1692894888: {
                    return new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, 1, this.ifMatch);
                }
                case 165155330: {
                    return new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, 1, this.ifNoneExist);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.method;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 171868368: {
                    Base[] baseArray;
                    if (this.ifNoneMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.ifNoneMatch;
                    }
                    return baseArray;
                }
                case -2061602860: {
                    Base[] baseArray;
                    if (this.ifModifiedSince == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.ifModifiedSince;
                    }
                    return baseArray;
                }
                case 1692894888: {
                    Base[] baseArray;
                    if (this.ifMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.ifMatch;
                    }
                    return baseArray;
                }
                case 165155330: {
                    Base[] baseArray;
                    if (this.ifNoneExist == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.ifNoneExist;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    value = new HTTPVerbEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.method = value;
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUri(value);
                    return value;
                }
                case 171868368: {
                    this.ifNoneMatch = TypeConvertor.castToString(value);
                    return value;
                }
                case -2061602860: {
                    this.ifModifiedSince = TypeConvertor.castToInstant(value);
                    return value;
                }
                case 1692894888: {
                    this.ifMatch = TypeConvertor.castToString(value);
                    return value;
                }
                case 165155330: {
                    this.ifNoneExist = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                value = new HTTPVerbEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.method = value;
            } else if (name.equals("url")) {
                this.url = TypeConvertor.castToUri(value);
            } else if (name.equals("ifNoneMatch")) {
                this.ifNoneMatch = TypeConvertor.castToString(value);
            } else if (name.equals("ifModifiedSince")) {
                this.ifModifiedSince = TypeConvertor.castToInstant(value);
            } else if (name.equals("ifMatch")) {
                this.ifMatch = TypeConvertor.castToString(value);
            } else if (name.equals("ifNoneExist")) {
                this.ifNoneExist = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return this.getMethodElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 171868368: {
                    return this.getIfNoneMatchElement();
                }
                case -2061602860: {
                    return this.getIfModifiedSinceElement();
                }
                case 1692894888: {
                    return this.getIfMatchElement();
                }
                case 165155330: {
                    return this.getIfNoneExistElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return new String[]{"code"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
                case 171868368: {
                    return new String[]{"string"};
                }
                case -2061602860: {
                    return new String[]{"instant"};
                }
                case 1692894888: {
                    return new String[]{"string"};
                }
                case 165155330: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("method")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.request.method");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.request.url");
            }
            if (name.equals("ifNoneMatch")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.request.ifNoneMatch");
            }
            if (name.equals("ifModifiedSince")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.request.ifModifiedSince");
            }
            if (name.equals("ifMatch")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.request.ifMatch");
            }
            if (name.equals("ifNoneExist")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.request.ifNoneExist");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryRequestComponent copy() {
            BundleEntryRequestComponent dst = new BundleEntryRequestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntryRequestComponent dst) {
            super.copyValues(dst);
            dst.method = this.method == null ? null : this.method.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.ifNoneMatch = this.ifNoneMatch == null ? null : this.ifNoneMatch.copy();
            dst.ifModifiedSince = this.ifModifiedSince == null ? null : this.ifModifiedSince.copy();
            dst.ifMatch = this.ifMatch == null ? null : this.ifMatch.copy();
            dst.ifNoneExist = this.ifNoneExist == null ? null : this.ifNoneExist.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryRequestComponent)) {
                return false;
            }
            BundleEntryRequestComponent o = (BundleEntryRequestComponent)other_;
            return BundleEntryRequestComponent.compareDeep(this.method, o.method, true) && BundleEntryRequestComponent.compareDeep(this.url, o.url, true) && BundleEntryRequestComponent.compareDeep(this.ifNoneMatch, o.ifNoneMatch, true) && BundleEntryRequestComponent.compareDeep(this.ifModifiedSince, o.ifModifiedSince, true) && BundleEntryRequestComponent.compareDeep(this.ifMatch, o.ifMatch, true) && BundleEntryRequestComponent.compareDeep(this.ifNoneExist, o.ifNoneExist, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryRequestComponent)) {
                return false;
            }
            BundleEntryRequestComponent o = (BundleEntryRequestComponent)other_;
            return BundleEntryRequestComponent.compareValues(this.method, o.method, true) && BundleEntryRequestComponent.compareValues(this.url, o.url, true) && BundleEntryRequestComponent.compareValues(this.ifNoneMatch, o.ifNoneMatch, true) && BundleEntryRequestComponent.compareValues(this.ifModifiedSince, o.ifModifiedSince, true) && BundleEntryRequestComponent.compareValues(this.ifMatch, o.ifMatch, true) && BundleEntryRequestComponent.compareValues(this.ifNoneExist, o.ifNoneExist, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.method, this.url, this.ifNoneMatch, this.ifModifiedSince, this.ifMatch, this.ifNoneExist});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.request";
        }
    }

    @Block
    public static class BundleEntrySearchComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="match | include | outcome - why this is in the result set", formalDefinition="Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-entry-mode")
        protected Enumeration<SearchEntryMode> mode;
        @Child(name="score", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search ranking (between 0 and 1)", formalDefinition="When searching, the server's search ranking score for the entry.")
        protected DecimalType score;
        private static final long serialVersionUID = 837739866L;

        public Enumeration<SearchEntryMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntrySearchComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public BundleEntrySearchComponent setModeElement(Enumeration<SearchEntryMode> value) {
            this.mode = value;
            return this;
        }

        public SearchEntryMode getMode() {
            return this.mode == null ? null : (SearchEntryMode)((Object)this.mode.getValue());
        }

        public BundleEntrySearchComponent setMode(SearchEntryMode value) {
            if (value == null) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
                }
                this.mode.setValue((Object)value);
            }
            return this;
        }

        public DecimalType getScoreElement() {
            if (this.score == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntrySearchComponent.score");
                }
                if (Configuration.doAutoCreate()) {
                    this.score = new DecimalType();
                }
            }
            return this.score;
        }

        public boolean hasScoreElement() {
            return this.score != null && !this.score.isEmpty();
        }

        public boolean hasScore() {
            return this.score != null && !this.score.isEmpty();
        }

        public BundleEntrySearchComponent setScoreElement(DecimalType value) {
            this.score = value;
            return this;
        }

        public BigDecimal getScore() {
            return this.score == null ? null : (BigDecimal)this.score.getValue();
        }

        public BundleEntrySearchComponent setScore(BigDecimal value) {
            if (value == null) {
                this.score = null;
            } else {
                if (this.score == null) {
                    this.score = new DecimalType();
                }
                this.score.setValue(value);
            }
            return this;
        }

        public BundleEntrySearchComponent setScore(long value) {
            this.score = new DecimalType();
            this.score.setValue(value);
            return this;
        }

        public BundleEntrySearchComponent setScore(double value) {
            this.score = new DecimalType();
            this.score.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", 0, 1, this.mode));
            children.add(new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, 1, this.score));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", 0, 1, this.mode);
                }
                case 109264530: {
                    return new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, 1, this.score);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 109264530: {
                    Base[] baseArray;
                    if (this.score == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.score;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new SearchEntryModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 109264530: {
                    this.score = TypeConvertor.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new SearchEntryModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("score")) {
                this.score = TypeConvertor.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 109264530: {
                    return this.getScoreElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 109264530: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.search.mode");
            }
            if (name.equals("score")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.search.score");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntrySearchComponent copy() {
            BundleEntrySearchComponent dst = new BundleEntrySearchComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntrySearchComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.score = this.score == null ? null : this.score.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntrySearchComponent)) {
                return false;
            }
            BundleEntrySearchComponent o = (BundleEntrySearchComponent)other_;
            return BundleEntrySearchComponent.compareDeep(this.mode, o.mode, true) && BundleEntrySearchComponent.compareDeep(this.score, o.score, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntrySearchComponent)) {
                return false;
            }
            BundleEntrySearchComponent o = (BundleEntrySearchComponent)other_;
            return BundleEntrySearchComponent.compareValues(this.mode, o.mode, true) && BundleEntrySearchComponent.compareValues(this.score, o.score, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.score});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.search";
        }
    }

    @Block
    public static class BundleEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="link", type={BundleLinkComponent.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Links related to this entry", formalDefinition="A series of links that provide context to this entry.")
        protected List<BundleLinkComponent> link;
        @Child(name="fullUrl", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URI for resource (e.g. the absolute URL server address, URI for UUID/OID, etc.)", formalDefinition="The Absolute URL for the resource.  The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: \n* invoking a create\n* invoking or responding to an operation where the body is not a single identified resource\n* invoking or returning the results of a search or history operation.")
        protected UriType fullUrl;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource in the bundle", formalDefinition="The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.")
        protected Resource resource;
        @Child(name="search", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search related information", formalDefinition="Information about the search process that lead to the creation of this entry.")
        protected BundleEntrySearchComponent search;
        @Child(name="request", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional execution information (transaction/batch/history)", formalDefinition="Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.")
        protected BundleEntryRequestComponent request;
        @Child(name="response", type={}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Results of execution (transaction/batch/history)", formalDefinition="Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.")
        protected BundleEntryResponseComponent response;
        private static final long serialVersionUID = 517783054L;

        public List<BundleLinkComponent> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            return this.link;
        }

        public BundleEntryComponent setLink(List<BundleLinkComponent> theLink) {
            this.link = theLink;
            return this;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (BundleLinkComponent item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BundleLinkComponent addLink() {
            BundleLinkComponent t = new BundleLinkComponent();
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            this.link.add(t);
            return t;
        }

        public BundleEntryComponent addLink(BundleLinkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            this.link.add(t);
            return this;
        }

        public BundleLinkComponent getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                this.addLink();
            }
            return this.getLink().get(0);
        }

        public UriType getFullUrlElement() {
            if (this.fullUrl == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.fullUrl");
                }
                if (Configuration.doAutoCreate()) {
                    this.fullUrl = new UriType();
                }
            }
            return this.fullUrl;
        }

        public boolean hasFullUrlElement() {
            return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public boolean hasFullUrl() {
            return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public BundleEntryComponent setFullUrlElement(UriType value) {
            this.fullUrl = value;
            return this;
        }

        public String getFullUrl() {
            return this.fullUrl == null ? null : (String)this.fullUrl.getValue();
        }

        public BundleEntryComponent setFullUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.fullUrl = null;
            } else {
                if (this.fullUrl == null) {
                    this.fullUrl = new UriType();
                }
                this.fullUrl.setValue(value);
            }
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public BundleEntryComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public BundleEntrySearchComponent getSearch() {
            if (this.search == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.search");
                }
                if (Configuration.doAutoCreate()) {
                    this.search = new BundleEntrySearchComponent();
                }
            }
            return this.search;
        }

        public boolean hasSearch() {
            return this.search != null && !this.search.isEmpty();
        }

        public BundleEntryComponent setSearch(BundleEntrySearchComponent value) {
            this.search = value;
            return this;
        }

        public BundleEntryRequestComponent getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new BundleEntryRequestComponent();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public BundleEntryComponent setRequest(BundleEntryRequestComponent value) {
            this.request = value;
            return this;
        }

        public BundleEntryResponseComponent getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new BundleEntryResponseComponent();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public BundleEntryComponent setResponse(BundleEntryResponseComponent value) {
            this.response = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, Integer.MAX_VALUE, this.link));
            children.add(new Property("fullUrl", "uri", "The Absolute URL for the resource.  The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: \n* invoking a create\n* invoking or responding to an operation where the body is not a single identified resource\n* invoking or returning the results of a search or history operation.", 0, 1, this.fullUrl));
            children.add(new Property("resource", "Resource", "The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.", 0, 1, this.resource));
            children.add(new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, 1, this.search));
            children.add(new Property("request", "", "Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.", 0, 1, this.request));
            children.add(new Property("response", "", "Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.", 0, 1, this.response));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3321850: {
                    return new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, Integer.MAX_VALUE, this.link);
                }
                case -511251360: {
                    return new Property("fullUrl", "uri", "The Absolute URL for the resource.  The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: \n* invoking a create\n* invoking or responding to an operation where the body is not a single identified resource\n* invoking or returning the results of a search or history operation.", 0, 1, this.fullUrl);
                }
                case -341064690: {
                    return new Property("resource", "Resource", "The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.", 0, 1, this.resource);
                }
                case -906336856: {
                    return new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, 1, this.search);
                }
                case 1095692943: {
                    return new Property("request", "", "Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.", 0, 1, this.request);
                }
                case -340323263: {
                    return new Property("response", "", "Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.", 0, 1, this.response);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case -511251360: {
                    Base[] baseArray;
                    if (this.fullUrl == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.fullUrl;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case -906336856: {
                    Base[] baseArray;
                    if (this.search == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.search;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.response;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    this.getLink().add((BundleLinkComponent)value);
                    return value;
                }
                case -511251360: {
                    this.fullUrl = TypeConvertor.castToUri(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToResource(value);
                    return value;
                }
                case -906336856: {
                    this.search = (BundleEntrySearchComponent)value;
                    return value;
                }
                case 1095692943: {
                    this.request = (BundleEntryRequestComponent)value;
                    return value;
                }
                case -340323263: {
                    this.response = (BundleEntryResponseComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("link")) {
                this.getLink().add((BundleLinkComponent)value);
            } else if (name.equals("fullUrl")) {
                this.fullUrl = TypeConvertor.castToUri(value);
            } else if (name.equals("resource")) {
                this.resource = TypeConvertor.castToResource(value);
            } else if (name.equals("search")) {
                this.search = (BundleEntrySearchComponent)value;
            } else if (name.equals("request")) {
                this.request = (BundleEntryRequestComponent)value;
            } else if (name.equals("response")) {
                this.response = (BundleEntryResponseComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.addLink();
                }
                case -511251360: {
                    return this.getFullUrlElement();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case -906336856: {
                    return this.getSearch();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case -340323263: {
                    return this.getResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return new String[]{"@Bundle.link"};
                }
                case -511251360: {
                    return new String[]{"uri"};
                }
                case -341064690: {
                    return new String[]{"Resource"};
                }
                case -906336856: {
                    return new String[0];
                }
                case 1095692943: {
                    return new String[0];
                }
                case -340323263: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("link")) {
                return this.addLink();
            }
            if (name.equals("fullUrl")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.entry.fullUrl");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type Bundle.entry.resource");
            }
            if (name.equals("search")) {
                this.search = new BundleEntrySearchComponent();
                return this.search;
            }
            if (name.equals("request")) {
                this.request = new BundleEntryRequestComponent();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new BundleEntryResponseComponent();
                return this.response;
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryComponent copy() {
            BundleEntryComponent dst = new BundleEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntryComponent dst) {
            super.copyValues(dst);
            if (this.link != null) {
                dst.link = new ArrayList<BundleLinkComponent>();
                for (BundleLinkComponent i : this.link) {
                    dst.link.add(i.copy());
                }
            }
            dst.fullUrl = this.fullUrl == null ? null : this.fullUrl.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.search = this.search == null ? null : this.search.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryComponent)) {
                return false;
            }
            BundleEntryComponent o = (BundleEntryComponent)other_;
            return BundleEntryComponent.compareDeep(this.link, o.link, true) && BundleEntryComponent.compareDeep(this.fullUrl, o.fullUrl, true) && BundleEntryComponent.compareDeep(this.resource, o.resource, true) && BundleEntryComponent.compareDeep(this.search, o.search, true) && BundleEntryComponent.compareDeep(this.request, o.request, true) && BundleEntryComponent.compareDeep(this.response, o.response, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryComponent)) {
                return false;
            }
            BundleEntryComponent o = (BundleEntryComponent)other_;
            return BundleEntryComponent.compareValues(this.fullUrl, o.fullUrl, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.link, this.fullUrl, this.resource, this.search, this.request, this.response});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry";
        }

        public BundleLinkComponent getLink(String theRelation) {
            Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
            for (BundleLinkComponent next : this.getLink()) {
                if (!theRelation.equals((Object)next.getRelation())) continue;
                return next;
            }
            return null;
        }

        public BundleLinkComponent getLinkOrCreate(String theRelation) {
            Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
            for (BundleLinkComponent next : this.getLink()) {
                if (!theRelation.equals((Object)next.getRelation())) continue;
                return next;
            }
            BundleLinkComponent retVal = new BundleLinkComponent();
            retVal.setRelation(LinkRelationTypes.fromCode(theRelation));
            this.getLink().add(retVal);
            return retVal;
        }
    }

    @Block
    public static class BundleLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relation", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="See http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1", formalDefinition="A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/iana-link-relations")
        protected Enumeration<LinkRelationTypes> relation;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference details for the link", formalDefinition="The reference details for the link.")
        protected UriType url;
        private static final long serialVersionUID = -878418349L;

        public BundleLinkComponent() {
        }

        public BundleLinkComponent(LinkRelationTypes relation, String url) {
            this.setRelation(relation);
            this.setUrl(url);
        }

        public Enumeration<LinkRelationTypes> getRelationElement() {
            if (this.relation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleLinkComponent.relation");
                }
                if (Configuration.doAutoCreate()) {
                    this.relation = new Enumeration<LinkRelationTypes>(new LinkRelationTypesEnumFactory());
                }
            }
            return this.relation;
        }

        public boolean hasRelationElement() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public boolean hasRelation() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public BundleLinkComponent setRelationElement(Enumeration<LinkRelationTypes> value) {
            this.relation = value;
            return this;
        }

        public LinkRelationTypes getRelation() {
            return this.relation == null ? null : (LinkRelationTypes)((Object)this.relation.getValue());
        }

        public BundleLinkComponent setRelation(LinkRelationTypes value) {
            if (this.relation == null) {
                this.relation = new Enumeration<LinkRelationTypes>(new LinkRelationTypesEnumFactory());
            }
            this.relation.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleLinkComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public BundleLinkComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public BundleLinkComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relation", "code", "A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).", 0, 1, this.relation));
            children.add(new Property("url", "uri", "The reference details for the link.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -554436100: {
                    return new Property("relation", "code", "A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).", 0, 1, this.relation);
                }
                case 116079: {
                    return new Property("url", "uri", "The reference details for the link.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    Base[] baseArray;
                    if (this.relation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relation;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    value = new LinkRelationTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relation = value;
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relation")) {
                value = new LinkRelationTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relation = value;
            } else if (name.equals("url")) {
                this.url = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    return this.getRelationElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    return new String[]{"code"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.link.relation");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.link.url");
            }
            return super.addChild(name);
        }

        @Override
        public BundleLinkComponent copy() {
            BundleLinkComponent dst = new BundleLinkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleLinkComponent dst) {
            super.copyValues(dst);
            dst.relation = this.relation == null ? null : this.relation.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleLinkComponent)) {
                return false;
            }
            BundleLinkComponent o = (BundleLinkComponent)other_;
            return BundleLinkComponent.compareDeep(this.relation, o.relation, true) && BundleLinkComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleLinkComponent)) {
                return false;
            }
            BundleLinkComponent o = (BundleLinkComponent)other_;
            return BundleLinkComponent.compareValues(this.relation, o.relation, true) && BundleLinkComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relation, this.url});
        }

        @Override
        public String fhirType() {
            return "Bundle.link";
        }
    }

    public static class SearchEntryModeEnumFactory
    implements EnumFactory<SearchEntryMode> {
        @Override
        public SearchEntryMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("match".equals(codeString)) {
                return SearchEntryMode.MATCH;
            }
            if ("include".equals(codeString)) {
                return SearchEntryMode.INCLUDE;
            }
            if ("outcome".equals(codeString)) {
                return SearchEntryMode.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        public Enumeration<SearchEntryMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SearchEntryMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("match".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.MATCH);
            }
            if ("include".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.INCLUDE);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.OUTCOME);
            }
            throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchEntryMode code) {
            if (code == SearchEntryMode.MATCH) {
                return "match";
            }
            if (code == SearchEntryMode.INCLUDE) {
                return "include";
            }
            if (code == SearchEntryMode.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(SearchEntryMode code) {
            return code.getSystem();
        }
    }

    public static enum SearchEntryMode {
        MATCH,
        INCLUDE,
        OUTCOME,
        NULL;


        public static SearchEntryMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("match".equals(codeString)) {
                return MATCH;
            }
            if ("include".equals(codeString)) {
                return INCLUDE;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MATCH: {
                    return "match";
                }
                case INCLUDE: {
                    return "include";
                }
                case OUTCOME: {
                    return "outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MATCH: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case INCLUDE: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MATCH: {
                    return "This resource matched the search specification.";
                }
                case INCLUDE: {
                    return "This resource is returned because it is referred to from another resource in the search set.";
                }
                case OUTCOME: {
                    return "An OperationOutcome that provides additional information about the processing of a search.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MATCH: {
                    return "Match";
                }
                case INCLUDE: {
                    return "Include";
                }
                case OUTCOME: {
                    return "Outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class LinkRelationTypesEnumFactory
    implements EnumFactory<LinkRelationTypes> {
        @Override
        public LinkRelationTypes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("about".equals(codeString)) {
                return LinkRelationTypes.ABOUT;
            }
            if ("acl".equals(codeString)) {
                return LinkRelationTypes.ACL;
            }
            if ("alternate".equals(codeString)) {
                return LinkRelationTypes.ALTERNATE;
            }
            if ("amphtml".equals(codeString)) {
                return LinkRelationTypes.AMPHTML;
            }
            if ("appendix".equals(codeString)) {
                return LinkRelationTypes.APPENDIX;
            }
            if ("apple-touch-icon".equals(codeString)) {
                return LinkRelationTypes.APPLETOUCHICON;
            }
            if ("apple-touch-startup-image".equals(codeString)) {
                return LinkRelationTypes.APPLETOUCHSTARTUPIMAGE;
            }
            if ("archives".equals(codeString)) {
                return LinkRelationTypes.ARCHIVES;
            }
            if ("author".equals(codeString)) {
                return LinkRelationTypes.AUTHOR;
            }
            if ("blocked-by".equals(codeString)) {
                return LinkRelationTypes.BLOCKEDBY;
            }
            if ("bookmark".equals(codeString)) {
                return LinkRelationTypes.BOOKMARK;
            }
            if ("canonical".equals(codeString)) {
                return LinkRelationTypes.CANONICAL;
            }
            if ("chapter".equals(codeString)) {
                return LinkRelationTypes.CHAPTER;
            }
            if ("cite-as".equals(codeString)) {
                return LinkRelationTypes.CITEAS;
            }
            if ("collection".equals(codeString)) {
                return LinkRelationTypes.COLLECTION;
            }
            if ("contents".equals(codeString)) {
                return LinkRelationTypes.CONTENTS;
            }
            if ("convertedFrom".equals(codeString)) {
                return LinkRelationTypes.CONVERTEDFROM;
            }
            if ("copyright".equals(codeString)) {
                return LinkRelationTypes.COPYRIGHT;
            }
            if ("create-form".equals(codeString)) {
                return LinkRelationTypes.CREATEFORM;
            }
            if ("current".equals(codeString)) {
                return LinkRelationTypes.CURRENT;
            }
            if ("describedby".equals(codeString)) {
                return LinkRelationTypes.DESCRIBEDBY;
            }
            if ("describes".equals(codeString)) {
                return LinkRelationTypes.DESCRIBES;
            }
            if ("disclosure".equals(codeString)) {
                return LinkRelationTypes.DISCLOSURE;
            }
            if ("dns-prefetch".equals(codeString)) {
                return LinkRelationTypes.DNSPREFETCH;
            }
            if ("duplicate".equals(codeString)) {
                return LinkRelationTypes.DUPLICATE;
            }
            if ("edit".equals(codeString)) {
                return LinkRelationTypes.EDIT;
            }
            if ("edit-form".equals(codeString)) {
                return LinkRelationTypes.EDITFORM;
            }
            if ("edit-media".equals(codeString)) {
                return LinkRelationTypes.EDITMEDIA;
            }
            if ("enclosure".equals(codeString)) {
                return LinkRelationTypes.ENCLOSURE;
            }
            if ("external".equals(codeString)) {
                return LinkRelationTypes.EXTERNAL;
            }
            if ("first".equals(codeString)) {
                return LinkRelationTypes.FIRST;
            }
            if ("glossary".equals(codeString)) {
                return LinkRelationTypes.GLOSSARY;
            }
            if ("help".equals(codeString)) {
                return LinkRelationTypes.HELP;
            }
            if ("hosts".equals(codeString)) {
                return LinkRelationTypes.HOSTS;
            }
            if ("hub".equals(codeString)) {
                return LinkRelationTypes.HUB;
            }
            if ("icon".equals(codeString)) {
                return LinkRelationTypes.ICON;
            }
            if ("index".equals(codeString)) {
                return LinkRelationTypes.INDEX;
            }
            if ("intervalAfter".equals(codeString)) {
                return LinkRelationTypes.INTERVALAFTER;
            }
            if ("intervalBefore".equals(codeString)) {
                return LinkRelationTypes.INTERVALBEFORE;
            }
            if ("intervalContains".equals(codeString)) {
                return LinkRelationTypes.INTERVALCONTAINS;
            }
            if ("intervalDisjoint".equals(codeString)) {
                return LinkRelationTypes.INTERVALDISJOINT;
            }
            if ("intervalDuring".equals(codeString)) {
                return LinkRelationTypes.INTERVALDURING;
            }
            if ("intervalEquals".equals(codeString)) {
                return LinkRelationTypes.INTERVALEQUALS;
            }
            if ("intervalFinishedBy".equals(codeString)) {
                return LinkRelationTypes.INTERVALFINISHEDBY;
            }
            if ("intervalFinishes".equals(codeString)) {
                return LinkRelationTypes.INTERVALFINISHES;
            }
            if ("intervalIn".equals(codeString)) {
                return LinkRelationTypes.INTERVALIN;
            }
            if ("intervalMeets".equals(codeString)) {
                return LinkRelationTypes.INTERVALMEETS;
            }
            if ("intervalMetBy".equals(codeString)) {
                return LinkRelationTypes.INTERVALMETBY;
            }
            if ("intervalOverlappedBy".equals(codeString)) {
                return LinkRelationTypes.INTERVALOVERLAPPEDBY;
            }
            if ("intervalOverlaps".equals(codeString)) {
                return LinkRelationTypes.INTERVALOVERLAPS;
            }
            if ("intervalStartedBy".equals(codeString)) {
                return LinkRelationTypes.INTERVALSTARTEDBY;
            }
            if ("intervalStarts".equals(codeString)) {
                return LinkRelationTypes.INTERVALSTARTS;
            }
            if ("item".equals(codeString)) {
                return LinkRelationTypes.ITEM;
            }
            if ("last".equals(codeString)) {
                return LinkRelationTypes.LAST;
            }
            if ("latest-version".equals(codeString)) {
                return LinkRelationTypes.LATESTVERSION;
            }
            if ("license".equals(codeString)) {
                return LinkRelationTypes.LICENSE;
            }
            if ("linkset".equals(codeString)) {
                return LinkRelationTypes.LINKSET;
            }
            if ("lrdd".equals(codeString)) {
                return LinkRelationTypes.LRDD;
            }
            if ("manifest".equals(codeString)) {
                return LinkRelationTypes.MANIFEST;
            }
            if ("mask-icon".equals(codeString)) {
                return LinkRelationTypes.MASKICON;
            }
            if ("media-feed".equals(codeString)) {
                return LinkRelationTypes.MEDIAFEED;
            }
            if ("memento".equals(codeString)) {
                return LinkRelationTypes.MEMENTO;
            }
            if ("micropub".equals(codeString)) {
                return LinkRelationTypes.MICROPUB;
            }
            if ("modulepreload".equals(codeString)) {
                return LinkRelationTypes.MODULEPRELOAD;
            }
            if ("monitor".equals(codeString)) {
                return LinkRelationTypes.MONITOR;
            }
            if ("monitor-group".equals(codeString)) {
                return LinkRelationTypes.MONITORGROUP;
            }
            if ("next".equals(codeString)) {
                return LinkRelationTypes.NEXT;
            }
            if ("next-archive".equals(codeString)) {
                return LinkRelationTypes.NEXTARCHIVE;
            }
            if ("nofollow".equals(codeString)) {
                return LinkRelationTypes.NOFOLLOW;
            }
            if ("noopener".equals(codeString)) {
                return LinkRelationTypes.NOOPENER;
            }
            if ("noreferrer".equals(codeString)) {
                return LinkRelationTypes.NOREFERRER;
            }
            if ("opener".equals(codeString)) {
                return LinkRelationTypes.OPENER;
            }
            if ("openid2.local_id".equals(codeString)) {
                return LinkRelationTypes.OPENID2_LOCALID;
            }
            if ("openid2.provider".equals(codeString)) {
                return LinkRelationTypes.OPENID2_PROVIDER;
            }
            if ("original".equals(codeString)) {
                return LinkRelationTypes.ORIGINAL;
            }
            if ("P3Pv1".equals(codeString)) {
                return LinkRelationTypes.P3PV1;
            }
            if ("payment".equals(codeString)) {
                return LinkRelationTypes.PAYMENT;
            }
            if ("pingback".equals(codeString)) {
                return LinkRelationTypes.PINGBACK;
            }
            if ("preconnect".equals(codeString)) {
                return LinkRelationTypes.PRECONNECT;
            }
            if ("predecessor-version".equals(codeString)) {
                return LinkRelationTypes.PREDECESSORVERSION;
            }
            if ("prefetch".equals(codeString)) {
                return LinkRelationTypes.PREFETCH;
            }
            if ("preload".equals(codeString)) {
                return LinkRelationTypes.PRELOAD;
            }
            if ("prerender".equals(codeString)) {
                return LinkRelationTypes.PRERENDER;
            }
            if ("prev".equals(codeString)) {
                return LinkRelationTypes.PREV;
            }
            if ("preview".equals(codeString)) {
                return LinkRelationTypes.PREVIEW;
            }
            if ("previous".equals(codeString)) {
                return LinkRelationTypes.PREVIOUS;
            }
            if ("prev-archive".equals(codeString)) {
                return LinkRelationTypes.PREVARCHIVE;
            }
            if ("privacy-policy".equals(codeString)) {
                return LinkRelationTypes.PRIVACYPOLICY;
            }
            if ("profile".equals(codeString)) {
                return LinkRelationTypes.PROFILE;
            }
            if ("publication".equals(codeString)) {
                return LinkRelationTypes.PUBLICATION;
            }
            if ("related".equals(codeString)) {
                return LinkRelationTypes.RELATED;
            }
            if ("restconf".equals(codeString)) {
                return LinkRelationTypes.RESTCONF;
            }
            if ("replies".equals(codeString)) {
                return LinkRelationTypes.REPLIES;
            }
            if ("ruleinput".equals(codeString)) {
                return LinkRelationTypes.RULEINPUT;
            }
            if ("search".equals(codeString)) {
                return LinkRelationTypes.SEARCH;
            }
            if ("section".equals(codeString)) {
                return LinkRelationTypes.SECTION;
            }
            if ("self".equals(codeString)) {
                return LinkRelationTypes.SELF;
            }
            if ("service".equals(codeString)) {
                return LinkRelationTypes.SERVICE;
            }
            if ("service-desc".equals(codeString)) {
                return LinkRelationTypes.SERVICEDESC;
            }
            if ("service-doc".equals(codeString)) {
                return LinkRelationTypes.SERVICEDOC;
            }
            if ("service-meta".equals(codeString)) {
                return LinkRelationTypes.SERVICEMETA;
            }
            if ("sponsored".equals(codeString)) {
                return LinkRelationTypes.SPONSORED;
            }
            if ("start".equals(codeString)) {
                return LinkRelationTypes.START;
            }
            if ("status".equals(codeString)) {
                return LinkRelationTypes.STATUS;
            }
            if ("stylesheet".equals(codeString)) {
                return LinkRelationTypes.STYLESHEET;
            }
            if ("subsection".equals(codeString)) {
                return LinkRelationTypes.SUBSECTION;
            }
            if ("successor-version".equals(codeString)) {
                return LinkRelationTypes.SUCCESSORVERSION;
            }
            if ("sunset".equals(codeString)) {
                return LinkRelationTypes.SUNSET;
            }
            if ("tag".equals(codeString)) {
                return LinkRelationTypes.TAG;
            }
            if ("terms-of-service".equals(codeString)) {
                return LinkRelationTypes.TERMSOFSERVICE;
            }
            if ("timegate".equals(codeString)) {
                return LinkRelationTypes.TIMEGATE;
            }
            if ("timemap".equals(codeString)) {
                return LinkRelationTypes.TIMEMAP;
            }
            if (Bundle.SP_TYPE.equals(codeString)) {
                return LinkRelationTypes.TYPE;
            }
            if ("ugc".equals(codeString)) {
                return LinkRelationTypes.UGC;
            }
            if ("up".equals(codeString)) {
                return LinkRelationTypes.UP;
            }
            if ("version-history".equals(codeString)) {
                return LinkRelationTypes.VERSIONHISTORY;
            }
            if ("via".equals(codeString)) {
                return LinkRelationTypes.VIA;
            }
            if ("webmention".equals(codeString)) {
                return LinkRelationTypes.WEBMENTION;
            }
            if ("working-copy".equals(codeString)) {
                return LinkRelationTypes.WORKINGCOPY;
            }
            if ("working-copy-of".equals(codeString)) {
                return LinkRelationTypes.WORKINGCOPYOF;
            }
            throw new IllegalArgumentException("Unknown LinkRelationTypes code '" + codeString + "'");
        }

        public Enumeration<LinkRelationTypes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<LinkRelationTypes>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("about".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ABOUT);
            }
            if ("acl".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ACL);
            }
            if ("alternate".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ALTERNATE);
            }
            if ("amphtml".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.AMPHTML);
            }
            if ("appendix".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.APPENDIX);
            }
            if ("apple-touch-icon".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.APPLETOUCHICON);
            }
            if ("apple-touch-startup-image".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.APPLETOUCHSTARTUPIMAGE);
            }
            if ("archives".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ARCHIVES);
            }
            if ("author".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.AUTHOR);
            }
            if ("blocked-by".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.BLOCKEDBY);
            }
            if ("bookmark".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.BOOKMARK);
            }
            if ("canonical".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CANONICAL);
            }
            if ("chapter".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CHAPTER);
            }
            if ("cite-as".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CITEAS);
            }
            if ("collection".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.COLLECTION);
            }
            if ("contents".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CONTENTS);
            }
            if ("convertedFrom".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CONVERTEDFROM);
            }
            if ("copyright".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.COPYRIGHT);
            }
            if ("create-form".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CREATEFORM);
            }
            if ("current".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CURRENT);
            }
            if ("describedby".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DESCRIBEDBY);
            }
            if ("describes".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DESCRIBES);
            }
            if ("disclosure".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DISCLOSURE);
            }
            if ("dns-prefetch".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DNSPREFETCH);
            }
            if ("duplicate".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DUPLICATE);
            }
            if ("edit".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EDIT);
            }
            if ("edit-form".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EDITFORM);
            }
            if ("edit-media".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EDITMEDIA);
            }
            if ("enclosure".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ENCLOSURE);
            }
            if ("external".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EXTERNAL);
            }
            if ("first".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.FIRST);
            }
            if ("glossary".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.GLOSSARY);
            }
            if ("help".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.HELP);
            }
            if ("hosts".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.HOSTS);
            }
            if ("hub".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.HUB);
            }
            if ("icon".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ICON);
            }
            if ("index".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INDEX);
            }
            if ("intervalAfter".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALAFTER);
            }
            if ("intervalBefore".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALBEFORE);
            }
            if ("intervalContains".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALCONTAINS);
            }
            if ("intervalDisjoint".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALDISJOINT);
            }
            if ("intervalDuring".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALDURING);
            }
            if ("intervalEquals".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALEQUALS);
            }
            if ("intervalFinishedBy".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALFINISHEDBY);
            }
            if ("intervalFinishes".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALFINISHES);
            }
            if ("intervalIn".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALIN);
            }
            if ("intervalMeets".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALMEETS);
            }
            if ("intervalMetBy".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALMETBY);
            }
            if ("intervalOverlappedBy".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALOVERLAPPEDBY);
            }
            if ("intervalOverlaps".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALOVERLAPS);
            }
            if ("intervalStartedBy".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALSTARTEDBY);
            }
            if ("intervalStarts".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALSTARTS);
            }
            if ("item".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ITEM);
            }
            if ("last".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LAST);
            }
            if ("latest-version".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LATESTVERSION);
            }
            if ("license".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LICENSE);
            }
            if ("linkset".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LINKSET);
            }
            if ("lrdd".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LRDD);
            }
            if ("manifest".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MANIFEST);
            }
            if ("mask-icon".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MASKICON);
            }
            if ("media-feed".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MEDIAFEED);
            }
            if ("memento".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MEMENTO);
            }
            if ("micropub".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MICROPUB);
            }
            if ("modulepreload".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MODULEPRELOAD);
            }
            if ("monitor".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MONITOR);
            }
            if ("monitor-group".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MONITORGROUP);
            }
            if ("next".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NEXT);
            }
            if ("next-archive".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NEXTARCHIVE);
            }
            if ("nofollow".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NOFOLLOW);
            }
            if ("noopener".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NOOPENER);
            }
            if ("noreferrer".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NOREFERRER);
            }
            if ("opener".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.OPENER);
            }
            if ("openid2.local_id".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.OPENID2_LOCALID);
            }
            if ("openid2.provider".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.OPENID2_PROVIDER);
            }
            if ("original".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ORIGINAL);
            }
            if ("P3Pv1".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.P3PV1);
            }
            if ("payment".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PAYMENT);
            }
            if ("pingback".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PINGBACK);
            }
            if ("preconnect".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRECONNECT);
            }
            if ("predecessor-version".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREDECESSORVERSION);
            }
            if ("prefetch".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREFETCH);
            }
            if ("preload".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRELOAD);
            }
            if ("prerender".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRERENDER);
            }
            if ("prev".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREV);
            }
            if ("preview".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREVIEW);
            }
            if ("previous".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREVIOUS);
            }
            if ("prev-archive".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREVARCHIVE);
            }
            if ("privacy-policy".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRIVACYPOLICY);
            }
            if ("profile".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PROFILE);
            }
            if ("publication".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PUBLICATION);
            }
            if ("related".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.RELATED);
            }
            if ("restconf".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.RESTCONF);
            }
            if ("replies".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.REPLIES);
            }
            if ("ruleinput".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.RULEINPUT);
            }
            if ("search".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SEARCH);
            }
            if ("section".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SECTION);
            }
            if ("self".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SELF);
            }
            if ("service".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICE);
            }
            if ("service-desc".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICEDESC);
            }
            if ("service-doc".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICEDOC);
            }
            if ("service-meta".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICEMETA);
            }
            if ("sponsored".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SPONSORED);
            }
            if ("start".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.START);
            }
            if ("status".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.STATUS);
            }
            if ("stylesheet".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.STYLESHEET);
            }
            if ("subsection".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SUBSECTION);
            }
            if ("successor-version".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SUCCESSORVERSION);
            }
            if ("sunset".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SUNSET);
            }
            if ("tag".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TAG);
            }
            if ("terms-of-service".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TERMSOFSERVICE);
            }
            if ("timegate".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TIMEGATE);
            }
            if ("timemap".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TIMEMAP);
            }
            if (Bundle.SP_TYPE.equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TYPE);
            }
            if ("ugc".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.UGC);
            }
            if ("up".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.UP);
            }
            if ("version-history".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.VERSIONHISTORY);
            }
            if ("via".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.VIA);
            }
            if ("webmention".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.WEBMENTION);
            }
            if ("working-copy".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.WORKINGCOPY);
            }
            if ("working-copy-of".equals(codeString)) {
                return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.WORKINGCOPYOF);
            }
            throw new FHIRException("Unknown LinkRelationTypes code '" + codeString + "'");
        }

        @Override
        public String toCode(LinkRelationTypes code) {
            if (code == LinkRelationTypes.ABOUT) {
                return "about";
            }
            if (code == LinkRelationTypes.ACL) {
                return "acl";
            }
            if (code == LinkRelationTypes.ALTERNATE) {
                return "alternate";
            }
            if (code == LinkRelationTypes.AMPHTML) {
                return "amphtml";
            }
            if (code == LinkRelationTypes.APPENDIX) {
                return "appendix";
            }
            if (code == LinkRelationTypes.APPLETOUCHICON) {
                return "apple-touch-icon";
            }
            if (code == LinkRelationTypes.APPLETOUCHSTARTUPIMAGE) {
                return "apple-touch-startup-image";
            }
            if (code == LinkRelationTypes.ARCHIVES) {
                return "archives";
            }
            if (code == LinkRelationTypes.AUTHOR) {
                return "author";
            }
            if (code == LinkRelationTypes.BLOCKEDBY) {
                return "blocked-by";
            }
            if (code == LinkRelationTypes.BOOKMARK) {
                return "bookmark";
            }
            if (code == LinkRelationTypes.CANONICAL) {
                return "canonical";
            }
            if (code == LinkRelationTypes.CHAPTER) {
                return "chapter";
            }
            if (code == LinkRelationTypes.CITEAS) {
                return "cite-as";
            }
            if (code == LinkRelationTypes.COLLECTION) {
                return "collection";
            }
            if (code == LinkRelationTypes.CONTENTS) {
                return "contents";
            }
            if (code == LinkRelationTypes.CONVERTEDFROM) {
                return "convertedFrom";
            }
            if (code == LinkRelationTypes.COPYRIGHT) {
                return "copyright";
            }
            if (code == LinkRelationTypes.CREATEFORM) {
                return "create-form";
            }
            if (code == LinkRelationTypes.CURRENT) {
                return "current";
            }
            if (code == LinkRelationTypes.DESCRIBEDBY) {
                return "describedby";
            }
            if (code == LinkRelationTypes.DESCRIBES) {
                return "describes";
            }
            if (code == LinkRelationTypes.DISCLOSURE) {
                return "disclosure";
            }
            if (code == LinkRelationTypes.DNSPREFETCH) {
                return "dns-prefetch";
            }
            if (code == LinkRelationTypes.DUPLICATE) {
                return "duplicate";
            }
            if (code == LinkRelationTypes.EDIT) {
                return "edit";
            }
            if (code == LinkRelationTypes.EDITFORM) {
                return "edit-form";
            }
            if (code == LinkRelationTypes.EDITMEDIA) {
                return "edit-media";
            }
            if (code == LinkRelationTypes.ENCLOSURE) {
                return "enclosure";
            }
            if (code == LinkRelationTypes.EXTERNAL) {
                return "external";
            }
            if (code == LinkRelationTypes.FIRST) {
                return "first";
            }
            if (code == LinkRelationTypes.GLOSSARY) {
                return "glossary";
            }
            if (code == LinkRelationTypes.HELP) {
                return "help";
            }
            if (code == LinkRelationTypes.HOSTS) {
                return "hosts";
            }
            if (code == LinkRelationTypes.HUB) {
                return "hub";
            }
            if (code == LinkRelationTypes.ICON) {
                return "icon";
            }
            if (code == LinkRelationTypes.INDEX) {
                return "index";
            }
            if (code == LinkRelationTypes.INTERVALAFTER) {
                return "intervalAfter";
            }
            if (code == LinkRelationTypes.INTERVALBEFORE) {
                return "intervalBefore";
            }
            if (code == LinkRelationTypes.INTERVALCONTAINS) {
                return "intervalContains";
            }
            if (code == LinkRelationTypes.INTERVALDISJOINT) {
                return "intervalDisjoint";
            }
            if (code == LinkRelationTypes.INTERVALDURING) {
                return "intervalDuring";
            }
            if (code == LinkRelationTypes.INTERVALEQUALS) {
                return "intervalEquals";
            }
            if (code == LinkRelationTypes.INTERVALFINISHEDBY) {
                return "intervalFinishedBy";
            }
            if (code == LinkRelationTypes.INTERVALFINISHES) {
                return "intervalFinishes";
            }
            if (code == LinkRelationTypes.INTERVALIN) {
                return "intervalIn";
            }
            if (code == LinkRelationTypes.INTERVALMEETS) {
                return "intervalMeets";
            }
            if (code == LinkRelationTypes.INTERVALMETBY) {
                return "intervalMetBy";
            }
            if (code == LinkRelationTypes.INTERVALOVERLAPPEDBY) {
                return "intervalOverlappedBy";
            }
            if (code == LinkRelationTypes.INTERVALOVERLAPS) {
                return "intervalOverlaps";
            }
            if (code == LinkRelationTypes.INTERVALSTARTEDBY) {
                return "intervalStartedBy";
            }
            if (code == LinkRelationTypes.INTERVALSTARTS) {
                return "intervalStarts";
            }
            if (code == LinkRelationTypes.ITEM) {
                return "item";
            }
            if (code == LinkRelationTypes.LAST) {
                return "last";
            }
            if (code == LinkRelationTypes.LATESTVERSION) {
                return "latest-version";
            }
            if (code == LinkRelationTypes.LICENSE) {
                return "license";
            }
            if (code == LinkRelationTypes.LINKSET) {
                return "linkset";
            }
            if (code == LinkRelationTypes.LRDD) {
                return "lrdd";
            }
            if (code == LinkRelationTypes.MANIFEST) {
                return "manifest";
            }
            if (code == LinkRelationTypes.MASKICON) {
                return "mask-icon";
            }
            if (code == LinkRelationTypes.MEDIAFEED) {
                return "media-feed";
            }
            if (code == LinkRelationTypes.MEMENTO) {
                return "memento";
            }
            if (code == LinkRelationTypes.MICROPUB) {
                return "micropub";
            }
            if (code == LinkRelationTypes.MODULEPRELOAD) {
                return "modulepreload";
            }
            if (code == LinkRelationTypes.MONITOR) {
                return "monitor";
            }
            if (code == LinkRelationTypes.MONITORGROUP) {
                return "monitor-group";
            }
            if (code == LinkRelationTypes.NEXT) {
                return "next";
            }
            if (code == LinkRelationTypes.NEXTARCHIVE) {
                return "next-archive";
            }
            if (code == LinkRelationTypes.NOFOLLOW) {
                return "nofollow";
            }
            if (code == LinkRelationTypes.NOOPENER) {
                return "noopener";
            }
            if (code == LinkRelationTypes.NOREFERRER) {
                return "noreferrer";
            }
            if (code == LinkRelationTypes.OPENER) {
                return "opener";
            }
            if (code == LinkRelationTypes.OPENID2_LOCALID) {
                return "openid2.local_id";
            }
            if (code == LinkRelationTypes.OPENID2_PROVIDER) {
                return "openid2.provider";
            }
            if (code == LinkRelationTypes.ORIGINAL) {
                return "original";
            }
            if (code == LinkRelationTypes.P3PV1) {
                return "P3Pv1";
            }
            if (code == LinkRelationTypes.PAYMENT) {
                return "payment";
            }
            if (code == LinkRelationTypes.PINGBACK) {
                return "pingback";
            }
            if (code == LinkRelationTypes.PRECONNECT) {
                return "preconnect";
            }
            if (code == LinkRelationTypes.PREDECESSORVERSION) {
                return "predecessor-version";
            }
            if (code == LinkRelationTypes.PREFETCH) {
                return "prefetch";
            }
            if (code == LinkRelationTypes.PRELOAD) {
                return "preload";
            }
            if (code == LinkRelationTypes.PRERENDER) {
                return "prerender";
            }
            if (code == LinkRelationTypes.PREV) {
                return "prev";
            }
            if (code == LinkRelationTypes.PREVIEW) {
                return "preview";
            }
            if (code == LinkRelationTypes.PREVIOUS) {
                return "previous";
            }
            if (code == LinkRelationTypes.PREVARCHIVE) {
                return "prev-archive";
            }
            if (code == LinkRelationTypes.PRIVACYPOLICY) {
                return "privacy-policy";
            }
            if (code == LinkRelationTypes.PROFILE) {
                return "profile";
            }
            if (code == LinkRelationTypes.PUBLICATION) {
                return "publication";
            }
            if (code == LinkRelationTypes.RELATED) {
                return "related";
            }
            if (code == LinkRelationTypes.RESTCONF) {
                return "restconf";
            }
            if (code == LinkRelationTypes.REPLIES) {
                return "replies";
            }
            if (code == LinkRelationTypes.RULEINPUT) {
                return "ruleinput";
            }
            if (code == LinkRelationTypes.SEARCH) {
                return "search";
            }
            if (code == LinkRelationTypes.SECTION) {
                return "section";
            }
            if (code == LinkRelationTypes.SELF) {
                return "self";
            }
            if (code == LinkRelationTypes.SERVICE) {
                return "service";
            }
            if (code == LinkRelationTypes.SERVICEDESC) {
                return "service-desc";
            }
            if (code == LinkRelationTypes.SERVICEDOC) {
                return "service-doc";
            }
            if (code == LinkRelationTypes.SERVICEMETA) {
                return "service-meta";
            }
            if (code == LinkRelationTypes.SPONSORED) {
                return "sponsored";
            }
            if (code == LinkRelationTypes.START) {
                return "start";
            }
            if (code == LinkRelationTypes.STATUS) {
                return "status";
            }
            if (code == LinkRelationTypes.STYLESHEET) {
                return "stylesheet";
            }
            if (code == LinkRelationTypes.SUBSECTION) {
                return "subsection";
            }
            if (code == LinkRelationTypes.SUCCESSORVERSION) {
                return "successor-version";
            }
            if (code == LinkRelationTypes.SUNSET) {
                return "sunset";
            }
            if (code == LinkRelationTypes.TAG) {
                return "tag";
            }
            if (code == LinkRelationTypes.TERMSOFSERVICE) {
                return "terms-of-service";
            }
            if (code == LinkRelationTypes.TIMEGATE) {
                return "timegate";
            }
            if (code == LinkRelationTypes.TIMEMAP) {
                return "timemap";
            }
            if (code == LinkRelationTypes.TYPE) {
                return Bundle.SP_TYPE;
            }
            if (code == LinkRelationTypes.UGC) {
                return "ugc";
            }
            if (code == LinkRelationTypes.UP) {
                return "up";
            }
            if (code == LinkRelationTypes.VERSIONHISTORY) {
                return "version-history";
            }
            if (code == LinkRelationTypes.VIA) {
                return "via";
            }
            if (code == LinkRelationTypes.WEBMENTION) {
                return "webmention";
            }
            if (code == LinkRelationTypes.WORKINGCOPY) {
                return "working-copy";
            }
            if (code == LinkRelationTypes.WORKINGCOPYOF) {
                return "working-copy-of";
            }
            return "?";
        }

        @Override
        public String toSystem(LinkRelationTypes code) {
            return code.getSystem();
        }
    }

    public static enum LinkRelationTypes {
        ABOUT,
        ACL,
        ALTERNATE,
        AMPHTML,
        APPENDIX,
        APPLETOUCHICON,
        APPLETOUCHSTARTUPIMAGE,
        ARCHIVES,
        AUTHOR,
        BLOCKEDBY,
        BOOKMARK,
        CANONICAL,
        CHAPTER,
        CITEAS,
        COLLECTION,
        CONTENTS,
        CONVERTEDFROM,
        COPYRIGHT,
        CREATEFORM,
        CURRENT,
        DESCRIBEDBY,
        DESCRIBES,
        DISCLOSURE,
        DNSPREFETCH,
        DUPLICATE,
        EDIT,
        EDITFORM,
        EDITMEDIA,
        ENCLOSURE,
        EXTERNAL,
        FIRST,
        GLOSSARY,
        HELP,
        HOSTS,
        HUB,
        ICON,
        INDEX,
        INTERVALAFTER,
        INTERVALBEFORE,
        INTERVALCONTAINS,
        INTERVALDISJOINT,
        INTERVALDURING,
        INTERVALEQUALS,
        INTERVALFINISHEDBY,
        INTERVALFINISHES,
        INTERVALIN,
        INTERVALMEETS,
        INTERVALMETBY,
        INTERVALOVERLAPPEDBY,
        INTERVALOVERLAPS,
        INTERVALSTARTEDBY,
        INTERVALSTARTS,
        ITEM,
        LAST,
        LATESTVERSION,
        LICENSE,
        LINKSET,
        LRDD,
        MANIFEST,
        MASKICON,
        MEDIAFEED,
        MEMENTO,
        MICROPUB,
        MODULEPRELOAD,
        MONITOR,
        MONITORGROUP,
        NEXT,
        NEXTARCHIVE,
        NOFOLLOW,
        NOOPENER,
        NOREFERRER,
        OPENER,
        OPENID2_LOCALID,
        OPENID2_PROVIDER,
        ORIGINAL,
        P3PV1,
        PAYMENT,
        PINGBACK,
        PRECONNECT,
        PREDECESSORVERSION,
        PREFETCH,
        PRELOAD,
        PRERENDER,
        PREV,
        PREVIEW,
        PREVIOUS,
        PREVARCHIVE,
        PRIVACYPOLICY,
        PROFILE,
        PUBLICATION,
        RELATED,
        RESTCONF,
        REPLIES,
        RULEINPUT,
        SEARCH,
        SECTION,
        SELF,
        SERVICE,
        SERVICEDESC,
        SERVICEDOC,
        SERVICEMETA,
        SPONSORED,
        START,
        STATUS,
        STYLESHEET,
        SUBSECTION,
        SUCCESSORVERSION,
        SUNSET,
        TAG,
        TERMSOFSERVICE,
        TIMEGATE,
        TIMEMAP,
        TYPE,
        UGC,
        UP,
        VERSIONHISTORY,
        VIA,
        WEBMENTION,
        WORKINGCOPY,
        WORKINGCOPYOF,
        NULL;


        public static LinkRelationTypes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("about".equals(codeString)) {
                return ABOUT;
            }
            if ("acl".equals(codeString)) {
                return ACL;
            }
            if ("alternate".equals(codeString)) {
                return ALTERNATE;
            }
            if ("amphtml".equals(codeString)) {
                return AMPHTML;
            }
            if ("appendix".equals(codeString)) {
                return APPENDIX;
            }
            if ("apple-touch-icon".equals(codeString)) {
                return APPLETOUCHICON;
            }
            if ("apple-touch-startup-image".equals(codeString)) {
                return APPLETOUCHSTARTUPIMAGE;
            }
            if ("archives".equals(codeString)) {
                return ARCHIVES;
            }
            if ("author".equals(codeString)) {
                return AUTHOR;
            }
            if ("blocked-by".equals(codeString)) {
                return BLOCKEDBY;
            }
            if ("bookmark".equals(codeString)) {
                return BOOKMARK;
            }
            if ("canonical".equals(codeString)) {
                return CANONICAL;
            }
            if ("chapter".equals(codeString)) {
                return CHAPTER;
            }
            if ("cite-as".equals(codeString)) {
                return CITEAS;
            }
            if ("collection".equals(codeString)) {
                return COLLECTION;
            }
            if ("contents".equals(codeString)) {
                return CONTENTS;
            }
            if ("convertedFrom".equals(codeString)) {
                return CONVERTEDFROM;
            }
            if ("copyright".equals(codeString)) {
                return COPYRIGHT;
            }
            if ("create-form".equals(codeString)) {
                return CREATEFORM;
            }
            if ("current".equals(codeString)) {
                return CURRENT;
            }
            if ("describedby".equals(codeString)) {
                return DESCRIBEDBY;
            }
            if ("describes".equals(codeString)) {
                return DESCRIBES;
            }
            if ("disclosure".equals(codeString)) {
                return DISCLOSURE;
            }
            if ("dns-prefetch".equals(codeString)) {
                return DNSPREFETCH;
            }
            if ("duplicate".equals(codeString)) {
                return DUPLICATE;
            }
            if ("edit".equals(codeString)) {
                return EDIT;
            }
            if ("edit-form".equals(codeString)) {
                return EDITFORM;
            }
            if ("edit-media".equals(codeString)) {
                return EDITMEDIA;
            }
            if ("enclosure".equals(codeString)) {
                return ENCLOSURE;
            }
            if ("external".equals(codeString)) {
                return EXTERNAL;
            }
            if ("first".equals(codeString)) {
                return FIRST;
            }
            if ("glossary".equals(codeString)) {
                return GLOSSARY;
            }
            if ("help".equals(codeString)) {
                return HELP;
            }
            if ("hosts".equals(codeString)) {
                return HOSTS;
            }
            if ("hub".equals(codeString)) {
                return HUB;
            }
            if ("icon".equals(codeString)) {
                return ICON;
            }
            if ("index".equals(codeString)) {
                return INDEX;
            }
            if ("intervalAfter".equals(codeString)) {
                return INTERVALAFTER;
            }
            if ("intervalBefore".equals(codeString)) {
                return INTERVALBEFORE;
            }
            if ("intervalContains".equals(codeString)) {
                return INTERVALCONTAINS;
            }
            if ("intervalDisjoint".equals(codeString)) {
                return INTERVALDISJOINT;
            }
            if ("intervalDuring".equals(codeString)) {
                return INTERVALDURING;
            }
            if ("intervalEquals".equals(codeString)) {
                return INTERVALEQUALS;
            }
            if ("intervalFinishedBy".equals(codeString)) {
                return INTERVALFINISHEDBY;
            }
            if ("intervalFinishes".equals(codeString)) {
                return INTERVALFINISHES;
            }
            if ("intervalIn".equals(codeString)) {
                return INTERVALIN;
            }
            if ("intervalMeets".equals(codeString)) {
                return INTERVALMEETS;
            }
            if ("intervalMetBy".equals(codeString)) {
                return INTERVALMETBY;
            }
            if ("intervalOverlappedBy".equals(codeString)) {
                return INTERVALOVERLAPPEDBY;
            }
            if ("intervalOverlaps".equals(codeString)) {
                return INTERVALOVERLAPS;
            }
            if ("intervalStartedBy".equals(codeString)) {
                return INTERVALSTARTEDBY;
            }
            if ("intervalStarts".equals(codeString)) {
                return INTERVALSTARTS;
            }
            if ("item".equals(codeString)) {
                return ITEM;
            }
            if ("last".equals(codeString)) {
                return LAST;
            }
            if ("latest-version".equals(codeString)) {
                return LATESTVERSION;
            }
            if ("license".equals(codeString)) {
                return LICENSE;
            }
            if ("linkset".equals(codeString)) {
                return LINKSET;
            }
            if ("lrdd".equals(codeString)) {
                return LRDD;
            }
            if ("manifest".equals(codeString)) {
                return MANIFEST;
            }
            if ("mask-icon".equals(codeString)) {
                return MASKICON;
            }
            if ("media-feed".equals(codeString)) {
                return MEDIAFEED;
            }
            if ("memento".equals(codeString)) {
                return MEMENTO;
            }
            if ("micropub".equals(codeString)) {
                return MICROPUB;
            }
            if ("modulepreload".equals(codeString)) {
                return MODULEPRELOAD;
            }
            if ("monitor".equals(codeString)) {
                return MONITOR;
            }
            if ("monitor-group".equals(codeString)) {
                return MONITORGROUP;
            }
            if ("next".equals(codeString)) {
                return NEXT;
            }
            if ("next-archive".equals(codeString)) {
                return NEXTARCHIVE;
            }
            if ("nofollow".equals(codeString)) {
                return NOFOLLOW;
            }
            if ("noopener".equals(codeString)) {
                return NOOPENER;
            }
            if ("noreferrer".equals(codeString)) {
                return NOREFERRER;
            }
            if ("opener".equals(codeString)) {
                return OPENER;
            }
            if ("openid2.local_id".equals(codeString)) {
                return OPENID2_LOCALID;
            }
            if ("openid2.provider".equals(codeString)) {
                return OPENID2_PROVIDER;
            }
            if ("original".equals(codeString)) {
                return ORIGINAL;
            }
            if ("P3Pv1".equals(codeString)) {
                return P3PV1;
            }
            if ("payment".equals(codeString)) {
                return PAYMENT;
            }
            if ("pingback".equals(codeString)) {
                return PINGBACK;
            }
            if ("preconnect".equals(codeString)) {
                return PRECONNECT;
            }
            if ("predecessor-version".equals(codeString)) {
                return PREDECESSORVERSION;
            }
            if ("prefetch".equals(codeString)) {
                return PREFETCH;
            }
            if ("preload".equals(codeString)) {
                return PRELOAD;
            }
            if ("prerender".equals(codeString)) {
                return PRERENDER;
            }
            if ("prev".equals(codeString)) {
                return PREV;
            }
            if ("preview".equals(codeString)) {
                return PREVIEW;
            }
            if ("previous".equals(codeString)) {
                return PREVIOUS;
            }
            if ("prev-archive".equals(codeString)) {
                return PREVARCHIVE;
            }
            if ("privacy-policy".equals(codeString)) {
                return PRIVACYPOLICY;
            }
            if ("profile".equals(codeString)) {
                return PROFILE;
            }
            if ("publication".equals(codeString)) {
                return PUBLICATION;
            }
            if ("related".equals(codeString)) {
                return RELATED;
            }
            if ("restconf".equals(codeString)) {
                return RESTCONF;
            }
            if ("replies".equals(codeString)) {
                return REPLIES;
            }
            if ("ruleinput".equals(codeString)) {
                return RULEINPUT;
            }
            if ("search".equals(codeString)) {
                return SEARCH;
            }
            if ("section".equals(codeString)) {
                return SECTION;
            }
            if ("self".equals(codeString)) {
                return SELF;
            }
            if ("service".equals(codeString)) {
                return SERVICE;
            }
            if ("service-desc".equals(codeString)) {
                return SERVICEDESC;
            }
            if ("service-doc".equals(codeString)) {
                return SERVICEDOC;
            }
            if ("service-meta".equals(codeString)) {
                return SERVICEMETA;
            }
            if ("sponsored".equals(codeString)) {
                return SPONSORED;
            }
            if ("start".equals(codeString)) {
                return START;
            }
            if ("status".equals(codeString)) {
                return STATUS;
            }
            if ("stylesheet".equals(codeString)) {
                return STYLESHEET;
            }
            if ("subsection".equals(codeString)) {
                return SUBSECTION;
            }
            if ("successor-version".equals(codeString)) {
                return SUCCESSORVERSION;
            }
            if ("sunset".equals(codeString)) {
                return SUNSET;
            }
            if ("tag".equals(codeString)) {
                return TAG;
            }
            if ("terms-of-service".equals(codeString)) {
                return TERMSOFSERVICE;
            }
            if ("timegate".equals(codeString)) {
                return TIMEGATE;
            }
            if ("timemap".equals(codeString)) {
                return TIMEMAP;
            }
            if (Bundle.SP_TYPE.equals(codeString)) {
                return TYPE;
            }
            if ("ugc".equals(codeString)) {
                return UGC;
            }
            if ("up".equals(codeString)) {
                return UP;
            }
            if ("version-history".equals(codeString)) {
                return VERSIONHISTORY;
            }
            if ("via".equals(codeString)) {
                return VIA;
            }
            if ("webmention".equals(codeString)) {
                return WEBMENTION;
            }
            if ("working-copy".equals(codeString)) {
                return WORKINGCOPY;
            }
            if ("working-copy-of".equals(codeString)) {
                return WORKINGCOPYOF;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown LinkRelationTypes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ABOUT: {
                    return "about";
                }
                case ACL: {
                    return "acl";
                }
                case ALTERNATE: {
                    return "alternate";
                }
                case AMPHTML: {
                    return "amphtml";
                }
                case APPENDIX: {
                    return "appendix";
                }
                case APPLETOUCHICON: {
                    return "apple-touch-icon";
                }
                case APPLETOUCHSTARTUPIMAGE: {
                    return "apple-touch-startup-image";
                }
                case ARCHIVES: {
                    return "archives";
                }
                case AUTHOR: {
                    return "author";
                }
                case BLOCKEDBY: {
                    return "blocked-by";
                }
                case BOOKMARK: {
                    return "bookmark";
                }
                case CANONICAL: {
                    return "canonical";
                }
                case CHAPTER: {
                    return "chapter";
                }
                case CITEAS: {
                    return "cite-as";
                }
                case COLLECTION: {
                    return "collection";
                }
                case CONTENTS: {
                    return "contents";
                }
                case CONVERTEDFROM: {
                    return "convertedFrom";
                }
                case COPYRIGHT: {
                    return "copyright";
                }
                case CREATEFORM: {
                    return "create-form";
                }
                case CURRENT: {
                    return "current";
                }
                case DESCRIBEDBY: {
                    return "describedby";
                }
                case DESCRIBES: {
                    return "describes";
                }
                case DISCLOSURE: {
                    return "disclosure";
                }
                case DNSPREFETCH: {
                    return "dns-prefetch";
                }
                case DUPLICATE: {
                    return "duplicate";
                }
                case EDIT: {
                    return "edit";
                }
                case EDITFORM: {
                    return "edit-form";
                }
                case EDITMEDIA: {
                    return "edit-media";
                }
                case ENCLOSURE: {
                    return "enclosure";
                }
                case EXTERNAL: {
                    return "external";
                }
                case FIRST: {
                    return "first";
                }
                case GLOSSARY: {
                    return "glossary";
                }
                case HELP: {
                    return "help";
                }
                case HOSTS: {
                    return "hosts";
                }
                case HUB: {
                    return "hub";
                }
                case ICON: {
                    return "icon";
                }
                case INDEX: {
                    return "index";
                }
                case INTERVALAFTER: {
                    return "intervalAfter";
                }
                case INTERVALBEFORE: {
                    return "intervalBefore";
                }
                case INTERVALCONTAINS: {
                    return "intervalContains";
                }
                case INTERVALDISJOINT: {
                    return "intervalDisjoint";
                }
                case INTERVALDURING: {
                    return "intervalDuring";
                }
                case INTERVALEQUALS: {
                    return "intervalEquals";
                }
                case INTERVALFINISHEDBY: {
                    return "intervalFinishedBy";
                }
                case INTERVALFINISHES: {
                    return "intervalFinishes";
                }
                case INTERVALIN: {
                    return "intervalIn";
                }
                case INTERVALMEETS: {
                    return "intervalMeets";
                }
                case INTERVALMETBY: {
                    return "intervalMetBy";
                }
                case INTERVALOVERLAPPEDBY: {
                    return "intervalOverlappedBy";
                }
                case INTERVALOVERLAPS: {
                    return "intervalOverlaps";
                }
                case INTERVALSTARTEDBY: {
                    return "intervalStartedBy";
                }
                case INTERVALSTARTS: {
                    return "intervalStarts";
                }
                case ITEM: {
                    return "item";
                }
                case LAST: {
                    return "last";
                }
                case LATESTVERSION: {
                    return "latest-version";
                }
                case LICENSE: {
                    return "license";
                }
                case LINKSET: {
                    return "linkset";
                }
                case LRDD: {
                    return "lrdd";
                }
                case MANIFEST: {
                    return "manifest";
                }
                case MASKICON: {
                    return "mask-icon";
                }
                case MEDIAFEED: {
                    return "media-feed";
                }
                case MEMENTO: {
                    return "memento";
                }
                case MICROPUB: {
                    return "micropub";
                }
                case MODULEPRELOAD: {
                    return "modulepreload";
                }
                case MONITOR: {
                    return "monitor";
                }
                case MONITORGROUP: {
                    return "monitor-group";
                }
                case NEXT: {
                    return "next";
                }
                case NEXTARCHIVE: {
                    return "next-archive";
                }
                case NOFOLLOW: {
                    return "nofollow";
                }
                case NOOPENER: {
                    return "noopener";
                }
                case NOREFERRER: {
                    return "noreferrer";
                }
                case OPENER: {
                    return "opener";
                }
                case OPENID2_LOCALID: {
                    return "openid2.local_id";
                }
                case OPENID2_PROVIDER: {
                    return "openid2.provider";
                }
                case ORIGINAL: {
                    return "original";
                }
                case P3PV1: {
                    return "P3Pv1";
                }
                case PAYMENT: {
                    return "payment";
                }
                case PINGBACK: {
                    return "pingback";
                }
                case PRECONNECT: {
                    return "preconnect";
                }
                case PREDECESSORVERSION: {
                    return "predecessor-version";
                }
                case PREFETCH: {
                    return "prefetch";
                }
                case PRELOAD: {
                    return "preload";
                }
                case PRERENDER: {
                    return "prerender";
                }
                case PREV: {
                    return "prev";
                }
                case PREVIEW: {
                    return "preview";
                }
                case PREVIOUS: {
                    return "previous";
                }
                case PREVARCHIVE: {
                    return "prev-archive";
                }
                case PRIVACYPOLICY: {
                    return "privacy-policy";
                }
                case PROFILE: {
                    return "profile";
                }
                case PUBLICATION: {
                    return "publication";
                }
                case RELATED: {
                    return "related";
                }
                case RESTCONF: {
                    return "restconf";
                }
                case REPLIES: {
                    return "replies";
                }
                case RULEINPUT: {
                    return "ruleinput";
                }
                case SEARCH: {
                    return "search";
                }
                case SECTION: {
                    return "section";
                }
                case SELF: {
                    return "self";
                }
                case SERVICE: {
                    return "service";
                }
                case SERVICEDESC: {
                    return "service-desc";
                }
                case SERVICEDOC: {
                    return "service-doc";
                }
                case SERVICEMETA: {
                    return "service-meta";
                }
                case SPONSORED: {
                    return "sponsored";
                }
                case START: {
                    return "start";
                }
                case STATUS: {
                    return "status";
                }
                case STYLESHEET: {
                    return "stylesheet";
                }
                case SUBSECTION: {
                    return "subsection";
                }
                case SUCCESSORVERSION: {
                    return "successor-version";
                }
                case SUNSET: {
                    return "sunset";
                }
                case TAG: {
                    return "tag";
                }
                case TERMSOFSERVICE: {
                    return "terms-of-service";
                }
                case TIMEGATE: {
                    return "timegate";
                }
                case TIMEMAP: {
                    return "timemap";
                }
                case TYPE: {
                    return Bundle.SP_TYPE;
                }
                case UGC: {
                    return "ugc";
                }
                case UP: {
                    return "up";
                }
                case VERSIONHISTORY: {
                    return "version-history";
                }
                case VIA: {
                    return "via";
                }
                case WEBMENTION: {
                    return "webmention";
                }
                case WORKINGCOPY: {
                    return "working-copy";
                }
                case WORKINGCOPYOF: {
                    return "working-copy-of";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ABOUT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ACL: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ALTERNATE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case AMPHTML: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case APPENDIX: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case APPLETOUCHICON: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case APPLETOUCHSTARTUPIMAGE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ARCHIVES: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case AUTHOR: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case BLOCKEDBY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case BOOKMARK: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CANONICAL: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CHAPTER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CITEAS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case COLLECTION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CONTENTS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CONVERTEDFROM: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case COPYRIGHT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CREATEFORM: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case CURRENT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case DESCRIBEDBY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case DESCRIBES: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case DISCLOSURE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case DNSPREFETCH: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case DUPLICATE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case EDIT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case EDITFORM: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case EDITMEDIA: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ENCLOSURE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case EXTERNAL: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case FIRST: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case GLOSSARY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case HELP: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case HOSTS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case HUB: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ICON: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INDEX: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALAFTER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALBEFORE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALCONTAINS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALDISJOINT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALDURING: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALEQUALS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALFINISHEDBY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALFINISHES: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALIN: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALMEETS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALMETBY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALOVERLAPPEDBY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALOVERLAPS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALSTARTEDBY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case INTERVALSTARTS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ITEM: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case LAST: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case LATESTVERSION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case LICENSE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case LINKSET: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case LRDD: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MANIFEST: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MASKICON: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MEDIAFEED: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MEMENTO: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MICROPUB: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MODULEPRELOAD: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MONITOR: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case MONITORGROUP: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case NEXT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case NEXTARCHIVE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case NOFOLLOW: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case NOOPENER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case NOREFERRER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case OPENER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case OPENID2_LOCALID: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case OPENID2_PROVIDER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case ORIGINAL: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case P3PV1: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PAYMENT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PINGBACK: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PRECONNECT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PREDECESSORVERSION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PREFETCH: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PRELOAD: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PRERENDER: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PREV: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PREVIEW: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PREVIOUS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PREVARCHIVE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PRIVACYPOLICY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PROFILE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case PUBLICATION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case RELATED: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case RESTCONF: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case REPLIES: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case RULEINPUT: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SEARCH: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SECTION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SELF: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SERVICE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SERVICEDESC: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SERVICEDOC: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SERVICEMETA: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SPONSORED: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case START: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case STATUS: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case STYLESHEET: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SUBSECTION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SUCCESSORVERSION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case SUNSET: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case TAG: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case TERMSOFSERVICE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case TIMEGATE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case TIMEMAP: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case TYPE: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case UGC: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case UP: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case VERSIONHISTORY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case VIA: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case WEBMENTION: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case WORKINGCOPY: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case WORKINGCOPYOF: {
                    return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ABOUT: {
                    return "Refers to a resource that is the subject of the link's context.";
                }
                case ACL: {
                    return "Asserts that the link target provides an access control description for the link context.";
                }
                case ALTERNATE: {
                    return "Refers to a substitute for this context";
                }
                case AMPHTML: {
                    return "Used to reference alternative content that uses the AMP profile of the HTML format.";
                }
                case APPENDIX: {
                    return "Refers to an appendix.";
                }
                case APPLETOUCHICON: {
                    return "Refers to an icon for the context. Synonym for icon.";
                }
                case APPLETOUCHSTARTUPIMAGE: {
                    return "Refers to a launch screen for the context.";
                }
                case ARCHIVES: {
                    return "Refers to a collection of records, documents, or other\n      materials of historical interest.";
                }
                case AUTHOR: {
                    return "Refers to the context's author.";
                }
                case BLOCKEDBY: {
                    return "Identifies the entity that blocks access to a resource\n      following receipt of a legal demand.";
                }
                case BOOKMARK: {
                    return "Gives a permanent link to use for bookmarking purposes.";
                }
                case CANONICAL: {
                    return "Designates the preferred version of a resource (the IRI and its contents).";
                }
                case CHAPTER: {
                    return "Refers to a chapter in a collection of resources.";
                }
                case CITEAS: {
                    return "Indicates that the link target is preferred over the link context for the purpose of permanent citation.";
                }
                case COLLECTION: {
                    return "The target IRI points to a resource which represents the collection resource for the context IRI.";
                }
                case CONTENTS: {
                    return "Refers to a table of contents.";
                }
                case CONVERTEDFROM: {
                    return "The document linked to was later converted to the\n      document that contains this link relation.  For example, an RFC can\n      have a link to the Internet-Draft that became the RFC; in that case,\n      the link relation would be \"convertedFrom\".";
                }
                case COPYRIGHT: {
                    return "Refers to a copyright statement that applies to the\n    link's context.";
                }
                case CREATEFORM: {
                    return "The target IRI points to a resource where a submission form can be obtained.";
                }
                case CURRENT: {
                    return "Refers to a resource containing the most recent\n      item(s) in a collection of resources.";
                }
                case DESCRIBEDBY: {
                    return "Refers to a resource providing information about the\n      link's context.";
                }
                case DESCRIBES: {
                    return "The relationship A 'describes' B asserts that\n      resource A provides a description of resource B. There are no\n      constraints on the format or representation of either A or B,\n      neither are there any further constraints on either resource.";
                }
                case DISCLOSURE: {
                    return "Refers to a list of patent disclosures made with respect to \n      material for which 'disclosure' relation is specified.";
                }
                case DNSPREFETCH: {
                    return "Used to indicate an origin that will be used to fetch required \n      resources for the link context, and that the user agent ought to resolve \n      as early as possible.";
                }
                case DUPLICATE: {
                    return "Refers to a resource whose available representations\n      are byte-for-byte identical with the corresponding representations of\n      the context IRI.";
                }
                case EDIT: {
                    return "Refers to a resource that can be used to edit the\n      link's context.";
                }
                case EDITFORM: {
                    return "The target IRI points to a resource where a submission form for\n      editing associated resource can be obtained.";
                }
                case EDITMEDIA: {
                    return "Refers to a resource that can be used to edit media\n      associated with the link's context.";
                }
                case ENCLOSURE: {
                    return "Identifies a related resource that is potentially\n      large and might require special handling.";
                }
                case EXTERNAL: {
                    return "Refers to a resource that is not part of the same site as the current context.";
                }
                case FIRST: {
                    return "An IRI that refers to the furthest preceding resource\n    in a series of resources.";
                }
                case GLOSSARY: {
                    return "Refers to a glossary of terms.";
                }
                case HELP: {
                    return "Refers to context-sensitive help.";
                }
                case HOSTS: {
                    return "Refers to a resource hosted by the server indicated by\n      the link context.";
                }
                case HUB: {
                    return "Refers to a hub that enables registration for\n    notification of updates to the context.";
                }
                case ICON: {
                    return "Refers to an icon representing the link's context.";
                }
                case INDEX: {
                    return "Refers to an index.";
                }
                case INTERVALAFTER: {
                    return "refers to a resource associated with a time interval that ends before the beginning of the time interval associated with the context resource";
                }
                case INTERVALBEFORE: {
                    return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource";
                }
                case INTERVALCONTAINS: {
                    return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
                }
                case INTERVALDISJOINT: {
                    return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource, or ends before the beginning of the time interval associated with the context resource";
                }
                case INTERVALDURING: {
                    return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
                }
                case INTERVALEQUALS: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALFINISHEDBY: {
                    return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALFINISHES: {
                    return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALIN: {
                    return "refers to a resource associated with a time interval that begins before or is coincident with the beginning of the time interval associated with the context resource, and ends after or is coincident with the end of the time interval associated with the context resource";
                }
                case INTERVALMEETS: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALMETBY: {
                    return "refers to a resource associated with a time interval whose end coincides with the beginning of the time interval associated with the context resource";
                }
                case INTERVALOVERLAPPEDBY: {
                    return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the beginning of the time interval associated with the context resource";
                }
                case INTERVALOVERLAPS: {
                    return "refers to a resource associated with a time interval that begins before the end of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
                }
                case INTERVALSTARTEDBY: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
                }
                case INTERVALSTARTS: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
                }
                case ITEM: {
                    return "The target IRI points to a resource that is a member of the collection represented by the context IRI.";
                }
                case LAST: {
                    return "An IRI that refers to the furthest following resource\n      in a series of resources.";
                }
                case LATESTVERSION: {
                    return "Points to a resource containing the latest (e.g.,\n      current) version of the context.";
                }
                case LICENSE: {
                    return "Refers to a license associated with this context.";
                }
                case LINKSET: {
                    return "The link target of a link with the \"linkset\" relation\n      type provides a set of links, including links in which the link\n      context of the link participates.\n    ";
                }
                case LRDD: {
                    return "Refers to further information about the link's context,\n      expressed as a LRDD (\"Link-based Resource Descriptor Document\")\n      resource.  See  for information about\n      processing this relation type in host-meta documents. When used\n      elsewhere, it refers to additional links and other metadata.\n      Multiple instances indicate additional LRDD resources. LRDD\n      resources MUST have an \"application/xrd+xml\" representation, and\n      MAY have others.";
                }
                case MANIFEST: {
                    return "Links to a manifest file for the context.";
                }
                case MASKICON: {
                    return "Refers to a mask that can be applied to the icon for the context.";
                }
                case MEDIAFEED: {
                    return "Refers to a feed of personalised media recommendations relevant to the link context.";
                }
                case MEMENTO: {
                    return "The Target IRI points to a Memento, a fixed resource that will not change state anymore.";
                }
                case MICROPUB: {
                    return "Links to the context's Micropub endpoint.";
                }
                case MODULEPRELOAD: {
                    return "Refers to a module that the user agent is to preemptively fetch and store for use in the current context.";
                }
                case MONITOR: {
                    return "Refers to a resource that can be used to monitor changes in an HTTP resource.\n    ";
                }
                case MONITORGROUP: {
                    return "Refers to a resource that can be used to monitor changes in a specified group of HTTP resources.\n    ";
                }
                case NEXT: {
                    return "Indicates that the link's context is a part of a series, and\n      that the next in the series is the link target.\n    ";
                }
                case NEXTARCHIVE: {
                    return "Refers to the immediately following archive resource.";
                }
                case NOFOLLOW: {
                    return "Indicates that the context\u2019s original author or publisher does not endorse the link target.";
                }
                case NOOPENER: {
                    return "Indicates that any newly created top-level browsing context which results from following the link will not be an auxiliary browsing context.";
                }
                case NOREFERRER: {
                    return "Indicates that no referrer information is to be leaked when following the link.";
                }
                case OPENER: {
                    return "Indicates that any newly created top-level browsing context which results from following the link will be an auxiliary browsing context.";
                }
                case OPENID2_LOCALID: {
                    return "Refers to an OpenID Authentication server on which the context relies for an assertion that the end user controls an Identifier.";
                }
                case OPENID2_PROVIDER: {
                    return "Refers to a resource which accepts OpenID Authentication protocol messages for the context.";
                }
                case ORIGINAL: {
                    return "The Target IRI points to an Original Resource.";
                }
                case P3PV1: {
                    return "Refers to a P3P privacy policy for the context.";
                }
                case PAYMENT: {
                    return "Indicates a resource where payment is accepted.";
                }
                case PINGBACK: {
                    return "Gives the address of the pingback resource for the link context.";
                }
                case PRECONNECT: {
                    return "Used to indicate an origin that will be used to fetch required \n      resources for the link context. Initiating an early connection, which \n      includes the DNS lookup, TCP handshake, and optional TLS negotiation, \n      allows the user agent to mask the high latency costs of establishing a \n      connection.";
                }
                case PREDECESSORVERSION: {
                    return "Points to a resource containing the predecessor\n      version in the version history.\n    ";
                }
                case PREFETCH: {
                    return "The prefetch link relation type is used to identify a resource \n      that might be required by the next navigation from the link context, and \n      that the user agent ought to fetch, such that the user agent can deliver a \n      faster response once the resource is requested in the future.";
                }
                case PRELOAD: {
                    return "Refers to a resource that should be loaded early in the \n      processing of the link's context, without blocking rendering.";
                }
                case PRERENDER: {
                    return "Used to identify a resource that might be required by the next \n      navigation from the link context, and that the user agent ought to fetch \n      and execute, such that the user agent can deliver a faster response once \n      the resource is requested in the future.";
                }
                case PREV: {
                    return "Indicates that the link's context is a part of a series, and\n      that the previous in the series is the link target.\n    ";
                }
                case PREVIEW: {
                    return "Refers to a resource that provides a preview of the link's context.";
                }
                case PREVIOUS: {
                    return "Refers to the previous resource in an ordered series\n      of resources.  Synonym for \"prev\".";
                }
                case PREVARCHIVE: {
                    return "Refers to the immediately preceding archive resource.";
                }
                case PRIVACYPOLICY: {
                    return "Refers to a privacy policy associated with the link's context.";
                }
                case PROFILE: {
                    return "Identifying that a resource representation conforms\nto a certain profile, without affecting the non-profile semantics\nof the resource representation.";
                }
                case PUBLICATION: {
                    return "Links to a publication manifest. A manifest represents \n      structured information about a publication, such as informative metadata, \n      a list of resources, and a default reading order.";
                }
                case RELATED: {
                    return "Identifies a related resource.";
                }
                case RESTCONF: {
                    return "Identifies the root of RESTCONF API as configured on this HTTP server.\n      The \"restconf\" relation defines the root of the API defined in RFC8040.\n      Subsequent revisions of RESTCONF will use alternate relation values to support \n      protocol versioning.";
                }
                case REPLIES: {
                    return "Identifies a resource that is a reply to the context\n      of the link.\n    ";
                }
                case RULEINPUT: {
                    return "The resource identified by the link target provides an input value to an \n    instance of a rule, where the resource which represents the rule instance is \n    identified by the link context.\n    ";
                }
                case SEARCH: {
                    return "Refers to a resource that can be used to search through\n      the link's context and related resources.";
                }
                case SECTION: {
                    return "Refers to a section in a collection of resources.";
                }
                case SELF: {
                    return "Conveys an identifier for the link's context.\n    ";
                }
                case SERVICE: {
                    return "Indicates a URI that can be used to retrieve a\n      service document.";
                }
                case SERVICEDESC: {
                    return "Identifies service description for the context that\n      is primarily intended for consumption by machines.";
                }
                case SERVICEDOC: {
                    return "Identifies service documentation for the context that\n      is primarily intended for human consumption.";
                }
                case SERVICEMETA: {
                    return "Identifies general metadata for the context that is\n      primarily intended for consumption by machines.";
                }
                case SPONSORED: {
                    return "Refers to a resource that is within a context that is \n\t\tsponsored (such as advertising or another compensation agreement).";
                }
                case START: {
                    return "Refers to the first resource in a collection of\n      resources.";
                }
                case STATUS: {
                    return "Identifies a resource that represents the context's\n      status.";
                }
                case STYLESHEET: {
                    return "Refers to a stylesheet.";
                }
                case SUBSECTION: {
                    return "Refers to a resource serving as a subsection in a\n      collection of resources.";
                }
                case SUCCESSORVERSION: {
                    return "Points to a resource containing the successor version\n      in the version history.\n    ";
                }
                case SUNSET: {
                    return "Identifies a resource that provides information about\n      the context's retirement policy.\n    ";
                }
                case TAG: {
                    return "Gives a tag (identified by the given address) that applies to\n      the current document.\n    ";
                }
                case TERMSOFSERVICE: {
                    return "Refers to the terms of service associated with the link's context.";
                }
                case TIMEGATE: {
                    return "The Target IRI points to a TimeGate for an Original Resource.";
                }
                case TIMEMAP: {
                    return "The Target IRI points to a TimeMap for an Original Resource.";
                }
                case TYPE: {
                    return "Refers to a resource identifying the abstract semantic type of which the link's context is considered to be an instance.";
                }
                case UGC: {
                    return "Refers to a resource that is within a context that is User Generated Content.\n    ";
                }
                case UP: {
                    return "Refers to a parent document in a hierarchy of\n      documents.\n    ";
                }
                case VERSIONHISTORY: {
                    return "Points to a resource containing the version history\n      for the context.\n    ";
                }
                case VIA: {
                    return "Identifies a resource that is the source of the\n      information in the link's context.\n    ";
                }
                case WEBMENTION: {
                    return "Identifies a target URI that supports the Webmention protocol.\n    This allows clients that mention a resource in some form of publishing process\n    to contact that endpoint and inform it that this resource has been mentioned.";
                }
                case WORKINGCOPY: {
                    return "Points to a working copy for this resource.";
                }
                case WORKINGCOPYOF: {
                    return "Points to the versioned resource from which this\n      working copy was obtained.\n    ";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ABOUT: {
                    return "Refers to a resource that is the subject of the link's context.";
                }
                case ACL: {
                    return "Asserts that the link target provides an access control description for the link context.";
                }
                case ALTERNATE: {
                    return "Refers to a substitute for this context";
                }
                case AMPHTML: {
                    return "Used to reference alternative content that uses the AMP profile of the HTML format.";
                }
                case APPENDIX: {
                    return "Refers to an appendix.";
                }
                case APPLETOUCHICON: {
                    return "Refers to an icon for the context. Synonym for icon.";
                }
                case APPLETOUCHSTARTUPIMAGE: {
                    return "Refers to a launch screen for the context.";
                }
                case ARCHIVES: {
                    return "Refers to a collection of records, documents, or other\n      materials of historical interest.";
                }
                case AUTHOR: {
                    return "Refers to the context's author.";
                }
                case BLOCKEDBY: {
                    return "Identifies the entity that blocks access to a resource\n      following receipt of a legal demand.";
                }
                case BOOKMARK: {
                    return "Gives a permanent link to use for bookmarking purposes.";
                }
                case CANONICAL: {
                    return "Designates the preferred version of a resource (the IRI and its contents).";
                }
                case CHAPTER: {
                    return "Refers to a chapter in a collection of resources.";
                }
                case CITEAS: {
                    return "Indicates that the link target is preferred over the link context for the purpose of permanent citation.";
                }
                case COLLECTION: {
                    return "The target IRI points to a resource which represents the collection resource for the context IRI.";
                }
                case CONTENTS: {
                    return "Refers to a table of contents.";
                }
                case CONVERTEDFROM: {
                    return "The document linked to was later converted to the\n      document that contains this link relation.  For example, an RFC can\n      have a link to the Internet-Draft that became the RFC; in that case,\n      the link relation would be \"convertedFrom\".";
                }
                case COPYRIGHT: {
                    return "Refers to a copyright statement that applies to the\n    link's context.";
                }
                case CREATEFORM: {
                    return "The target IRI points to a resource where a submission form can be obtained.";
                }
                case CURRENT: {
                    return "Refers to a resource containing the most recent\n      item(s) in a collection of resources.";
                }
                case DESCRIBEDBY: {
                    return "Refers to a resource providing information about the\n      link's context.";
                }
                case DESCRIBES: {
                    return "The relationship A 'describes' B asserts that\n      resource A provides a description of resource B. There are no\n      constraints on the format or representation of either A or B,\n      neither are there any further constraints on either resource.";
                }
                case DISCLOSURE: {
                    return "Refers to a list of patent disclosures made with respect to \n      material for which 'disclosure' relation is specified.";
                }
                case DNSPREFETCH: {
                    return "Used to indicate an origin that will be used to fetch required \n      resources for the link context, and that the user agent ought to resolve \n      as early as possible.";
                }
                case DUPLICATE: {
                    return "Refers to a resource whose available representations\n      are byte-for-byte identical with the corresponding representations of\n      the context IRI.";
                }
                case EDIT: {
                    return "Refers to a resource that can be used to edit the\n      link's context.";
                }
                case EDITFORM: {
                    return "The target IRI points to a resource where a submission form for\n      editing associated resource can be obtained.";
                }
                case EDITMEDIA: {
                    return "Refers to a resource that can be used to edit media\n      associated with the link's context.";
                }
                case ENCLOSURE: {
                    return "Identifies a related resource that is potentially\n      large and might require special handling.";
                }
                case EXTERNAL: {
                    return "Refers to a resource that is not part of the same site as the current context.";
                }
                case FIRST: {
                    return "An IRI that refers to the furthest preceding resource\n    in a series of resources.";
                }
                case GLOSSARY: {
                    return "Refers to a glossary of terms.";
                }
                case HELP: {
                    return "Refers to context-sensitive help.";
                }
                case HOSTS: {
                    return "Refers to a resource hosted by the server indicated by\n      the link context.";
                }
                case HUB: {
                    return "Refers to a hub that enables registration for\n    notification of updates to the context.";
                }
                case ICON: {
                    return "Refers to an icon representing the link's context.";
                }
                case INDEX: {
                    return "Refers to an index.";
                }
                case INTERVALAFTER: {
                    return "refers to a resource associated with a time interval that ends before the beginning of the time interval associated with the context resource";
                }
                case INTERVALBEFORE: {
                    return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource";
                }
                case INTERVALCONTAINS: {
                    return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
                }
                case INTERVALDISJOINT: {
                    return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource, or ends before the beginning of the time interval associated with the context resource";
                }
                case INTERVALDURING: {
                    return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
                }
                case INTERVALEQUALS: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALFINISHEDBY: {
                    return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALFINISHES: {
                    return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALIN: {
                    return "refers to a resource associated with a time interval that begins before or is coincident with the beginning of the time interval associated with the context resource, and ends after or is coincident with the end of the time interval associated with the context resource";
                }
                case INTERVALMEETS: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the end of the time interval associated with the context resource";
                }
                case INTERVALMETBY: {
                    return "refers to a resource associated with a time interval whose end coincides with the beginning of the time interval associated with the context resource";
                }
                case INTERVALOVERLAPPEDBY: {
                    return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the beginning of the time interval associated with the context resource";
                }
                case INTERVALOVERLAPS: {
                    return "refers to a resource associated with a time interval that begins before the end of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
                }
                case INTERVALSTARTEDBY: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
                }
                case INTERVALSTARTS: {
                    return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
                }
                case ITEM: {
                    return "The target IRI points to a resource that is a member of the collection represented by the context IRI.";
                }
                case LAST: {
                    return "An IRI that refers to the furthest following resource\n      in a series of resources.";
                }
                case LATESTVERSION: {
                    return "Points to a resource containing the latest (e.g.,\n      current) version of the context.";
                }
                case LICENSE: {
                    return "Refers to a license associated with this context.";
                }
                case LINKSET: {
                    return "The link target of a link with the \"linkset\" relation\n      type provides a set of links, including links in which the link\n      context of the link participates.\n    ";
                }
                case LRDD: {
                    return "Refers to further information about the link's context,\n      expressed as a LRDD (\"Link-based Resource Descriptor Document\")\n      resource.  See  for information about\n      processing this relation type in host-meta documents. When used\n      elsewhere, it refers to additional links and other metadata.\n      Multiple instances indicate additional LRDD resources. LRDD\n      resources MUST have an \"application/xrd+xml\" representation, and\n      MAY have others.";
                }
                case MANIFEST: {
                    return "Links to a manifest file for the context.";
                }
                case MASKICON: {
                    return "Refers to a mask that can be applied to the icon for the context.";
                }
                case MEDIAFEED: {
                    return "Refers to a feed of personalised media recommendations relevant to the link context.";
                }
                case MEMENTO: {
                    return "The Target IRI points to a Memento, a fixed resource that will not change state anymore.";
                }
                case MICROPUB: {
                    return "Links to the context's Micropub endpoint.";
                }
                case MODULEPRELOAD: {
                    return "Refers to a module that the user agent is to preemptively fetch and store for use in the current context.";
                }
                case MONITOR: {
                    return "Refers to a resource that can be used to monitor changes in an HTTP resource.\n    ";
                }
                case MONITORGROUP: {
                    return "Refers to a resource that can be used to monitor changes in a specified group of HTTP resources.\n    ";
                }
                case NEXT: {
                    return "Indicates that the link's context is a part of a series, and\n      that the next in the series is the link target.\n    ";
                }
                case NEXTARCHIVE: {
                    return "Refers to the immediately following archive resource.";
                }
                case NOFOLLOW: {
                    return "Indicates that the context\u2019s original author or publisher does not endorse the link target.";
                }
                case NOOPENER: {
                    return "Indicates that any newly created top-level browsing context which results from following the link will not be an auxiliary browsing context.";
                }
                case NOREFERRER: {
                    return "Indicates that no referrer information is to be leaked when following the link.";
                }
                case OPENER: {
                    return "Indicates that any newly created top-level browsing context which results from following the link will be an auxiliary browsing context.";
                }
                case OPENID2_LOCALID: {
                    return "Refers to an OpenID Authentication server on which the context relies for an assertion that the end user controls an Identifier.";
                }
                case OPENID2_PROVIDER: {
                    return "Refers to a resource which accepts OpenID Authentication protocol messages for the context.";
                }
                case ORIGINAL: {
                    return "The Target IRI points to an Original Resource.";
                }
                case P3PV1: {
                    return "Refers to a P3P privacy policy for the context.";
                }
                case PAYMENT: {
                    return "Indicates a resource where payment is accepted.";
                }
                case PINGBACK: {
                    return "Gives the address of the pingback resource for the link context.";
                }
                case PRECONNECT: {
                    return "Used to indicate an origin that will be used to fetch required \n      resources for the link context. Initiating an early connection, which \n      includes the DNS lookup, TCP handshake, and optional TLS negotiation, \n      allows the user agent to mask the high latency costs of establishing a \n      connection.";
                }
                case PREDECESSORVERSION: {
                    return "Points to a resource containing the predecessor\n      version in the version history.\n    ";
                }
                case PREFETCH: {
                    return "The prefetch link relation type is used to identify a resource \n      that might be required by the next navigation from the link context, and \n      that the user agent ought to fetch, such that the user agent can deliver a \n      faster response once the resource is requested in the future.";
                }
                case PRELOAD: {
                    return "Refers to a resource that should be loaded early in the \n      processing of the link's context, without blocking rendering.";
                }
                case PRERENDER: {
                    return "Used to identify a resource that might be required by the next \n      navigation from the link context, and that the user agent ought to fetch \n      and execute, such that the user agent can deliver a faster response once \n      the resource is requested in the future.";
                }
                case PREV: {
                    return "Indicates that the link's context is a part of a series, and\n      that the previous in the series is the link target.\n    ";
                }
                case PREVIEW: {
                    return "Refers to a resource that provides a preview of the link's context.";
                }
                case PREVIOUS: {
                    return "Refers to the previous resource in an ordered series\n      of resources.  Synonym for \"prev\".";
                }
                case PREVARCHIVE: {
                    return "Refers to the immediately preceding archive resource.";
                }
                case PRIVACYPOLICY: {
                    return "Refers to a privacy policy associated with the link's context.";
                }
                case PROFILE: {
                    return "Identifying that a resource representation conforms\nto a certain profile, without affecting the non-profile semantics\nof the resource representation.";
                }
                case PUBLICATION: {
                    return "Links to a publication manifest. A manifest represents \n      structured information about a publication, such as informative metadata, \n      a list of resources, and a default reading order.";
                }
                case RELATED: {
                    return "Identifies a related resource.";
                }
                case RESTCONF: {
                    return "Identifies the root of RESTCONF API as configured on this HTTP server.\n      The \"restconf\" relation defines the root of the API defined in RFC8040.\n      Subsequent revisions of RESTCONF will use alternate relation values to support \n      protocol versioning.";
                }
                case REPLIES: {
                    return "Identifies a resource that is a reply to the context\n      of the link.\n    ";
                }
                case RULEINPUT: {
                    return "The resource identified by the link target provides an input value to an \n    instance of a rule, where the resource which represents the rule instance is \n    identified by the link context.\n    ";
                }
                case SEARCH: {
                    return "Refers to a resource that can be used to search through\n      the link's context and related resources.";
                }
                case SECTION: {
                    return "Refers to a section in a collection of resources.";
                }
                case SELF: {
                    return "Conveys an identifier for the link's context.\n    ";
                }
                case SERVICE: {
                    return "Indicates a URI that can be used to retrieve a\n      service document.";
                }
                case SERVICEDESC: {
                    return "Identifies service description for the context that\n      is primarily intended for consumption by machines.";
                }
                case SERVICEDOC: {
                    return "Identifies service documentation for the context that\n      is primarily intended for human consumption.";
                }
                case SERVICEMETA: {
                    return "Identifies general metadata for the context that is\n      primarily intended for consumption by machines.";
                }
                case SPONSORED: {
                    return "Refers to a resource that is within a context that is \n\t\tsponsored (such as advertising or another compensation agreement).";
                }
                case START: {
                    return "Refers to the first resource in a collection of\n      resources.";
                }
                case STATUS: {
                    return "Identifies a resource that represents the context's\n      status.";
                }
                case STYLESHEET: {
                    return "Refers to a stylesheet.";
                }
                case SUBSECTION: {
                    return "Refers to a resource serving as a subsection in a\n      collection of resources.";
                }
                case SUCCESSORVERSION: {
                    return "Points to a resource containing the successor version\n      in the version history.\n    ";
                }
                case SUNSET: {
                    return "Identifies a resource that provides information about\n      the context's retirement policy.\n    ";
                }
                case TAG: {
                    return "Gives a tag (identified by the given address) that applies to\n      the current document.\n    ";
                }
                case TERMSOFSERVICE: {
                    return "Refers to the terms of service associated with the link's context.";
                }
                case TIMEGATE: {
                    return "The Target IRI points to a TimeGate for an Original Resource.";
                }
                case TIMEMAP: {
                    return "The Target IRI points to a TimeMap for an Original Resource.";
                }
                case TYPE: {
                    return "Refers to a resource identifying the abstract semantic type of which the link's context is considered to be an instance.";
                }
                case UGC: {
                    return "Refers to a resource that is within a context that is User Generated Content.\n    ";
                }
                case UP: {
                    return "Refers to a parent document in a hierarchy of\n      documents.\n    ";
                }
                case VERSIONHISTORY: {
                    return "Points to a resource containing the version history\n      for the context.\n    ";
                }
                case VIA: {
                    return "Identifies a resource that is the source of the\n      information in the link's context.\n    ";
                }
                case WEBMENTION: {
                    return "Identifies a target URI that supports the Webmention protocol.\n    This allows clients that mention a resource in some form of publishing process\n    to contact that endpoint and inform it that this resource has been mentioned.";
                }
                case WORKINGCOPY: {
                    return "Points to a working copy for this resource.";
                }
                case WORKINGCOPYOF: {
                    return "Points to the versioned resource from which this\n      working copy was obtained.\n    ";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class HTTPVerbEnumFactory
    implements EnumFactory<HTTPVerb> {
        @Override
        public HTTPVerb fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return HTTPVerb.GET;
            }
            if ("HEAD".equals(codeString)) {
                return HTTPVerb.HEAD;
            }
            if ("POST".equals(codeString)) {
                return HTTPVerb.POST;
            }
            if ("PUT".equals(codeString)) {
                return HTTPVerb.PUT;
            }
            if ("DELETE".equals(codeString)) {
                return HTTPVerb.DELETE;
            }
            if ("PATCH".equals(codeString)) {
                return HTTPVerb.PATCH;
            }
            throw new IllegalArgumentException("Unknown HTTPVerb code '" + codeString + "'");
        }

        public Enumeration<HTTPVerb> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<HTTPVerb>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.GET);
            }
            if ("HEAD".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.HEAD);
            }
            if ("POST".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.POST);
            }
            if ("PUT".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.PUT);
            }
            if ("DELETE".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.DELETE);
            }
            if ("PATCH".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.PATCH);
            }
            throw new FHIRException("Unknown HTTPVerb code '" + codeString + "'");
        }

        @Override
        public String toCode(HTTPVerb code) {
            if (code == HTTPVerb.GET) {
                return "GET";
            }
            if (code == HTTPVerb.HEAD) {
                return "HEAD";
            }
            if (code == HTTPVerb.POST) {
                return "POST";
            }
            if (code == HTTPVerb.PUT) {
                return "PUT";
            }
            if (code == HTTPVerb.DELETE) {
                return "DELETE";
            }
            if (code == HTTPVerb.PATCH) {
                return "PATCH";
            }
            return "?";
        }

        @Override
        public String toSystem(HTTPVerb code) {
            return code.getSystem();
        }
    }

    public static enum HTTPVerb {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        PATCH,
        NULL;


        public static HTTPVerb fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return GET;
            }
            if ("HEAD".equals(codeString)) {
                return HEAD;
            }
            if ("POST".equals(codeString)) {
                return POST;
            }
            if ("PUT".equals(codeString)) {
                return PUT;
            }
            if ("DELETE".equals(codeString)) {
                return DELETE;
            }
            if ("PATCH".equals(codeString)) {
                return PATCH;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown HTTPVerb code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GET: {
                    return "GET";
                }
                case HEAD: {
                    return "HEAD";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case DELETE: {
                    return "DELETE";
                }
                case PATCH: {
                    return "PATCH";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GET: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case HEAD: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case POST: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case PUT: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case PATCH: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GET: {
                    return "HTTP GET Command.";
                }
                case HEAD: {
                    return "HTTP HEAD Command.";
                }
                case POST: {
                    return "HTTP POST Command.";
                }
                case PUT: {
                    return "HTTP PUT Command.";
                }
                case DELETE: {
                    return "HTTP DELETE Command.";
                }
                case PATCH: {
                    return "HTTP PATCH Command.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GET: {
                    return "GET";
                }
                case HEAD: {
                    return "HEAD";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case DELETE: {
                    return "DELETE";
                }
                case PATCH: {
                    return "PATCH";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class BundleTypeEnumFactory
    implements EnumFactory<BundleType> {
        @Override
        public BundleType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("document".equals(codeString)) {
                return BundleType.DOCUMENT;
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return BundleType.MESSAGE;
            }
            if ("transaction".equals(codeString)) {
                return BundleType.TRANSACTION;
            }
            if ("transaction-response".equals(codeString)) {
                return BundleType.TRANSACTIONRESPONSE;
            }
            if ("batch".equals(codeString)) {
                return BundleType.BATCH;
            }
            if ("batch-response".equals(codeString)) {
                return BundleType.BATCHRESPONSE;
            }
            if ("history".equals(codeString)) {
                return BundleType.HISTORY;
            }
            if ("searchset".equals(codeString)) {
                return BundleType.SEARCHSET;
            }
            if ("collection".equals(codeString)) {
                return BundleType.COLLECTION;
            }
            if ("subscription-notification".equals(codeString)) {
                return BundleType.SUBSCRIPTIONNOTIFICATION;
            }
            throw new IllegalArgumentException("Unknown BundleType code '" + codeString + "'");
        }

        public Enumeration<BundleType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BundleType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("document".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.DOCUMENT);
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.MESSAGE);
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.TRANSACTION);
            }
            if ("transaction-response".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.TRANSACTIONRESPONSE);
            }
            if ("batch".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.BATCH);
            }
            if ("batch-response".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.BATCHRESPONSE);
            }
            if ("history".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.HISTORY);
            }
            if ("searchset".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.SEARCHSET);
            }
            if ("collection".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.COLLECTION);
            }
            if ("subscription-notification".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.SUBSCRIPTIONNOTIFICATION);
            }
            throw new FHIRException("Unknown BundleType code '" + codeString + "'");
        }

        @Override
        public String toCode(BundleType code) {
            if (code == BundleType.DOCUMENT) {
                return "document";
            }
            if (code == BundleType.MESSAGE) {
                return Bundle.SP_MESSAGE;
            }
            if (code == BundleType.TRANSACTION) {
                return "transaction";
            }
            if (code == BundleType.TRANSACTIONRESPONSE) {
                return "transaction-response";
            }
            if (code == BundleType.BATCH) {
                return "batch";
            }
            if (code == BundleType.BATCHRESPONSE) {
                return "batch-response";
            }
            if (code == BundleType.HISTORY) {
                return "history";
            }
            if (code == BundleType.SEARCHSET) {
                return "searchset";
            }
            if (code == BundleType.COLLECTION) {
                return "collection";
            }
            if (code == BundleType.SUBSCRIPTIONNOTIFICATION) {
                return "subscription-notification";
            }
            return "?";
        }

        @Override
        public String toSystem(BundleType code) {
            return code.getSystem();
        }
    }

    public static enum BundleType {
        DOCUMENT,
        MESSAGE,
        TRANSACTION,
        TRANSACTIONRESPONSE,
        BATCH,
        BATCHRESPONSE,
        HISTORY,
        SEARCHSET,
        COLLECTION,
        SUBSCRIPTIONNOTIFICATION,
        NULL;


        public static BundleType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("document".equals(codeString)) {
                return DOCUMENT;
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return MESSAGE;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("transaction-response".equals(codeString)) {
                return TRANSACTIONRESPONSE;
            }
            if ("batch".equals(codeString)) {
                return BATCH;
            }
            if ("batch-response".equals(codeString)) {
                return BATCHRESPONSE;
            }
            if ("history".equals(codeString)) {
                return HISTORY;
            }
            if ("searchset".equals(codeString)) {
                return SEARCHSET;
            }
            if ("collection".equals(codeString)) {
                return COLLECTION;
            }
            if ("subscription-notification".equals(codeString)) {
                return SUBSCRIPTIONNOTIFICATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BundleType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DOCUMENT: {
                    return "document";
                }
                case MESSAGE: {
                    return Bundle.SP_MESSAGE;
                }
                case TRANSACTION: {
                    return "transaction";
                }
                case TRANSACTIONRESPONSE: {
                    return "transaction-response";
                }
                case BATCH: {
                    return "batch";
                }
                case BATCHRESPONSE: {
                    return "batch-response";
                }
                case HISTORY: {
                    return "history";
                }
                case SEARCHSET: {
                    return "searchset";
                }
                case COLLECTION: {
                    return "collection";
                }
                case SUBSCRIPTIONNOTIFICATION: {
                    return "subscription-notification";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DOCUMENT: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case MESSAGE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case TRANSACTION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case TRANSACTIONRESPONSE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case BATCH: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case BATCHRESPONSE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case HISTORY: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case SEARCHSET: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case COLLECTION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case SUBSCRIPTIONNOTIFICATION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DOCUMENT: {
                    return "The bundle is a document. The first resource is a Composition.";
                }
                case MESSAGE: {
                    return "The bundle is a message. The first resource is a MessageHeader.";
                }
                case TRANSACTION: {
                    return "The bundle is a transaction - intended to be processed by a server as an atomic commit.";
                }
                case TRANSACTIONRESPONSE: {
                    return "The bundle is a transaction response. Because the response is a transaction response, the transaction has succeeded, and all responses are error free.";
                }
                case BATCH: {
                    return "The bundle is a set of actions - intended to be processed by a server as a group of independent actions.";
                }
                case BATCHRESPONSE: {
                    return "The bundle is a batch response. Note that as a batch, some responses may indicate failure and others success.";
                }
                case HISTORY: {
                    return "The bundle is a list of resources from a history interaction on a server.";
                }
                case SEARCHSET: {
                    return "The bundle is a list of resources returned as a result of a search/query interaction, operation, or message.";
                }
                case COLLECTION: {
                    return "The bundle is a set of resources collected into a single package for ease of distribution that imposes no processing obligations or behavioral rules beyond persistence.";
                }
                case SUBSCRIPTIONNOTIFICATION: {
                    return "The bundle has been generated by a Subscription to communicate information to a client.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DOCUMENT: {
                    return "Document";
                }
                case MESSAGE: {
                    return "Message";
                }
                case TRANSACTION: {
                    return "Transaction";
                }
                case TRANSACTIONRESPONSE: {
                    return "Transaction Response";
                }
                case BATCH: {
                    return "Batch";
                }
                case BATCHRESPONSE: {
                    return "Batch Response";
                }
                case HISTORY: {
                    return "History List";
                }
                case SEARCHSET: {
                    return "Search Results";
                }
                case COLLECTION: {
                    return "Collection";
                }
                case SUBSCRIPTIONNOTIFICATION: {
                    return "Subscription Notification";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

