/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ChargeItemDefinition", profile="http://hl7.org/fhir/StructureDefinition/ChargeItemDefinition")
public class ChargeItemDefinition
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this charge item definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this charge item definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this charge item definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the charge item definition is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the charge item definition", formalDefinition="A formal identifier that is used to identify this charge item definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the charge item definition", formalDefinition="The identifier that is used to identify this version of the charge item definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the charge item definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this charge item definition (computer friendly)", formalDefinition="A natural language name identifying the ChargeItemDefinition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this charge item definition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the charge item definition.")
    protected StringType title;
    @Child(name="derivedFromUri", type={UriType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Underlying externally-defined charge item definition", formalDefinition="The URL pointing to an externally-defined charge item definition that is adhered to in whole or in part by this definition.")
    protected List<UriType> derivedFromUri;
    @Child(name="partOf", type={CanonicalType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A larger definition of which this particular definition is a component or step", formalDefinition="A larger definition of which this particular definition is a component or step.")
    protected List<CanonicalType> partOf;
    @Child(name="replaces", type={CanonicalType.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Completed or terminated request(s) whose function is taken by this new request", formalDefinition="As new versions of a protocol or guideline are defined, allows identification of what versions are replaced by a new instance.")
    protected List<CanonicalType> replaces;
    @Child(name="status", type={CodeType.class}, order=8, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the ChargeItemDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this charge item definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the charge item definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the charge item definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the charge item definition.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the charge item definition", formalDefinition="A free text natural language description of the charge item definition from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate charge item definition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for charge item definition (if applicable)", formalDefinition="A legal or geographic region in which the charge item definition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this charge item definition is defined", formalDefinition="Explanation of why this charge item definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the charge item definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the charge item definition.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the charge item definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the charge item definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="code", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Billing code or product type this definition applies to", formalDefinition="The defined billing details in this resource pertain to the given billing code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/chargeitem-billingcodes")
    protected CodeableConcept code;
    @Child(name="instance", type={Medication.class, Substance.class, Device.class, DeviceDefinition.class, ActivityDefinition.class, PlanDefinition.class, HealthcareService.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instances this definition applies to", formalDefinition="The defined billing details in this resource pertain to the given product instance(s).")
    protected List<Reference> instance;
    @Child(name="applicability", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Whether or not the billing code is applicable", formalDefinition="Expressions that describe applicability criteria for the billing code.")
    protected List<ChargeItemDefinitionApplicabilityComponent> applicability;
    @Child(name="propertyGroup", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Group of properties which are applicable under the same conditions", formalDefinition="Group of properties which are applicable under the same conditions. If no applicability rules are established for the group, then all properties always apply.")
    protected List<ChargeItemDefinitionPropertyGroupComponent> propertyGroup;
    private static final long serialVersionUID = 1866277744L;
    @SearchParamDefinition(name="context-quantity", path="(ChargeItemDefinition.useContext.value as Quantity) | (ChargeItemDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the charge item definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ChargeItemDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the charge item definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ChargeItemDefinition.useContext", description="A use context type and value assigned to the charge item definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ChargeItemDefinition.useContext.code", description="A type of use context assigned to the charge item definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ChargeItemDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the charge item definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ChargeItemDefinition.date", description="The charge item definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ChargeItemDefinition.description", description="The description of the charge item definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="effective", path="ChargeItemDefinition.applicability.effectivePeriod", description="The time during which the charge item definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="identifier", path="ChargeItemDefinition.identifier", description="External identifier for the charge item definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ChargeItemDefinition.jurisdiction", description="Intended jurisdiction for the charge item definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="publisher", path="ChargeItemDefinition.publisher", description="Name of the publisher of the charge item definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ChargeItemDefinition.status", description="The current status of the charge item definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ChargeItemDefinition.title", description="The human-friendly name of the charge item definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ChargeItemDefinition.url", description="The uri that identifies the charge item definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ChargeItemDefinition.version", description="The business version of the charge item definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ChargeItemDefinition() {
    }

    public ChargeItemDefinition(String url, Enumerations.PublicationStatus status) {
        this.setUrl(url);
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ChargeItemDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ChargeItemDefinition setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ChargeItemDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ChargeItemDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ChargeItemDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ChargeItemDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ChargeItemDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ChargeItemDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ChargeItemDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<UriType> getDerivedFromUri() {
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        return this.derivedFromUri;
    }

    public ChargeItemDefinition setDerivedFromUri(List<UriType> theDerivedFromUri) {
        this.derivedFromUri = theDerivedFromUri;
        return this;
    }

    public boolean hasDerivedFromUri() {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType item : this.derivedFromUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDerivedFromUriElement() {
        UriType t = new UriType();
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return t;
    }

    public ChargeItemDefinition addDerivedFromUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return this;
    }

    public boolean hasDerivedFromUri(String value) {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType v : this.derivedFromUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<CanonicalType>();
        }
        return this.partOf;
    }

    public ChargeItemDefinition setPartOf(List<CanonicalType> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (CanonicalType item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addPartOfElement() {
        CanonicalType t = new CanonicalType();
        if (this.partOf == null) {
            this.partOf = new ArrayList<CanonicalType>();
        }
        this.partOf.add(t);
        return t;
    }

    public ChargeItemDefinition addPartOf(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.partOf == null) {
            this.partOf = new ArrayList<CanonicalType>();
        }
        this.partOf.add(t);
        return this;
    }

    public boolean hasPartOf(String value) {
        if (this.partOf == null) {
            return false;
        }
        for (CanonicalType v : this.partOf) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        return this.replaces;
    }

    public ChargeItemDefinition setReplaces(List<CanonicalType> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (CanonicalType item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addReplacesElement() {
        CanonicalType t = new CanonicalType();
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        this.replaces.add(t);
        return t;
    }

    public ChargeItemDefinition addReplaces(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        this.replaces.add(t);
        return this;
    }

    public boolean hasReplaces(String value) {
        if (this.replaces == null) {
            return false;
        }
        for (CanonicalType v : this.replaces) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ChargeItemDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ChargeItemDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ChargeItemDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ChargeItemDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ChargeItemDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ChargeItemDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ChargeItemDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ChargeItemDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ChargeItemDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ChargeItemDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ChargeItemDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ChargeItemDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ChargeItemDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ChargeItemDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ChargeItemDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ChargeItemDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ChargeItemDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public ChargeItemDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public ChargeItemDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public ChargeItemDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public ChargeItemDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ChargeItemDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<Reference> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<Reference>();
        }
        return this.instance;
    }

    public ChargeItemDefinition setInstance(List<Reference> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (Reference item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInstance() {
        Reference t = new Reference();
        if (this.instance == null) {
            this.instance = new ArrayList<Reference>();
        }
        this.instance.add(t);
        return t;
    }

    public ChargeItemDefinition addInstance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<Reference>();
        }
        this.instance.add(t);
        return this;
    }

    public Reference getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<ChargeItemDefinitionApplicabilityComponent> getApplicability() {
        if (this.applicability == null) {
            this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
        }
        return this.applicability;
    }

    public ChargeItemDefinition setApplicability(List<ChargeItemDefinitionApplicabilityComponent> theApplicability) {
        this.applicability = theApplicability;
        return this;
    }

    public boolean hasApplicability() {
        if (this.applicability == null) {
            return false;
        }
        for (ChargeItemDefinitionApplicabilityComponent item : this.applicability) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChargeItemDefinitionApplicabilityComponent addApplicability() {
        ChargeItemDefinitionApplicabilityComponent t = new ChargeItemDefinitionApplicabilityComponent();
        if (this.applicability == null) {
            this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
        }
        this.applicability.add(t);
        return t;
    }

    public ChargeItemDefinition addApplicability(ChargeItemDefinitionApplicabilityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.applicability == null) {
            this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
        }
        this.applicability.add(t);
        return this;
    }

    public ChargeItemDefinitionApplicabilityComponent getApplicabilityFirstRep() {
        if (this.getApplicability().isEmpty()) {
            this.addApplicability();
        }
        return this.getApplicability().get(0);
    }

    public List<ChargeItemDefinitionPropertyGroupComponent> getPropertyGroup() {
        if (this.propertyGroup == null) {
            this.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
        }
        return this.propertyGroup;
    }

    public ChargeItemDefinition setPropertyGroup(List<ChargeItemDefinitionPropertyGroupComponent> thePropertyGroup) {
        this.propertyGroup = thePropertyGroup;
        return this;
    }

    public boolean hasPropertyGroup() {
        if (this.propertyGroup == null) {
            return false;
        }
        for (ChargeItemDefinitionPropertyGroupComponent item : this.propertyGroup) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChargeItemDefinitionPropertyGroupComponent addPropertyGroup() {
        ChargeItemDefinitionPropertyGroupComponent t = new ChargeItemDefinitionPropertyGroupComponent();
        if (this.propertyGroup == null) {
            this.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
        }
        this.propertyGroup.add(t);
        return t;
    }

    public ChargeItemDefinition addPropertyGroup(ChargeItemDefinitionPropertyGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.propertyGroup == null) {
            this.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
        }
        this.propertyGroup.add(t);
        return this;
    }

    public ChargeItemDefinitionPropertyGroupComponent getPropertyGroupFirstRep() {
        if (this.getPropertyGroup().isEmpty()) {
            this.addPropertyGroup();
        }
        return this.getPropertyGroup().get(0);
    }

    @Override
    public int getVersionAlgorithmMax() {
        return 0;
    }

    @Override
    public DataType getVersionAlgorithm() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public StringType getVersionAlgorithmStringType() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return false;
    }

    @Override
    public Coding getVersionAlgorithmCoding() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return false;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return false;
    }

    @Override
    public ChargeItemDefinition setVersionAlgorithm(DataType value) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public int getCopyrightLabelMax() {
        return 0;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return false;
    }

    @Override
    public boolean hasCopyrightLabel() {
        return false;
    }

    @Override
    public ChargeItemDefinition setCopyrightLabelElement(StringType value) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public String getCopyrightLabel() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public ChargeItemDefinition setCopyrightLabel(String value) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public ChargeItemDefinition setEffectivePeriod(Period value) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public int getTopicMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public ChargeItemDefinition setTopic(List<CodeableConcept> theTopic) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public boolean hasTopic() {
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public ChargeItemDefinition addTopic(CodeableConcept t) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public int getAuthorMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getAuthor() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ChargeItemDefinition setAuthor(List<ContactDetail> theAuthor) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"author\"");
    }

    @Override
    public boolean hasAuthor() {
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"author\"");
    }

    @Override
    public ChargeItemDefinition addAuthor(ContactDetail t) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"author\"");
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"author\"");
    }

    @Override
    public int getEditorMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getEditor() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ChargeItemDefinition setEditor(List<ContactDetail> theEditor) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public boolean hasEditor() {
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public ChargeItemDefinition addEditor(ContactDetail t) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public int getReviewerMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getReviewer() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ChargeItemDefinition setReviewer(List<ContactDetail> theReviewer) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public boolean hasReviewer() {
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public ChargeItemDefinition addReviewer(ContactDetail t) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public int getEndorserMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getEndorser() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ChargeItemDefinition setEndorser(List<ContactDetail> theEndorser) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public boolean hasEndorser() {
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public ChargeItemDefinition addEndorser(ContactDetail t) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public int getRelatedArtifactMax() {
        return 0;
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        return new ArrayList<RelatedArtifact>();
    }

    @Override
    public ChargeItemDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public boolean hasRelatedArtifact() {
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public ChargeItemDefinition addRelatedArtifact(RelatedArtifact t) {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        throw new Error("The resource type \"ChargeItemDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this charge item definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this charge item definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the charge item definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this charge item definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the charge item definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the charge item definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version));
        children.add(new Property("name", "string", "A natural language name identifying the ChargeItemDefinition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the charge item definition.", 0, 1, this.title));
        children.add(new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined charge item definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri));
        children.add(new Property("partOf", "canonical(ChargeItemDefinition)", "A larger definition of which this particular definition is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property("replaces", "canonical(ChargeItemDefinition)", "As new versions of a protocol or guideline are defined, allows identification of what versions are replaced by a new instance.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property(SP_STATUS, "code", "The current state of the ChargeItemDefinition.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this charge item definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the charge item definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the charge item definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the charge item definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the charge item definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate charge item definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the charge item definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this charge item definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the charge item definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the charge item definition.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("code", "CodeableConcept", "The defined billing details in this resource pertain to the given billing code.", 0, 1, this.code));
        children.add(new Property("instance", "Reference(Medication|Substance|Device|DeviceDefinition|ActivityDefinition|PlanDefinition|HealthcareService)", "The defined billing details in this resource pertain to the given product instance(s).", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("applicability", "", "Expressions that describe applicability criteria for the billing code.", 0, Integer.MAX_VALUE, this.applicability));
        children.add(new Property("propertyGroup", "", "Group of properties which are applicable under the same conditions. If no applicability rules are established for the group, then all properties always apply.", 0, Integer.MAX_VALUE, this.propertyGroup));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this charge item definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this charge item definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the charge item definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this charge item definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the charge item definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the charge item definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the ChargeItemDefinition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the charge item definition.", 0, 1, this.title);
            }
            case -1076333435: {
                return new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined charge item definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri);
            }
            case -995410646: {
                return new Property("partOf", "canonical(ChargeItemDefinition)", "A larger definition of which this particular definition is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -430332865: {
                return new Property("replaces", "canonical(ChargeItemDefinition)", "As new versions of a protocol or guideline are defined, allows identification of what versions are replaced by a new instance.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the ChargeItemDefinition.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this charge item definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the charge item definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the charge item definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the charge item definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the charge item definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate charge item definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the charge item definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this charge item definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the charge item definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the charge item definition.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "The defined billing details in this resource pertain to the given billing code.", 0, 1, this.code);
            }
            case 555127957: {
                return new Property("instance", "Reference(Medication|Substance|Device|DeviceDefinition|ActivityDefinition|PlanDefinition|HealthcareService)", "The defined billing details in this resource pertain to the given product instance(s).", 0, Integer.MAX_VALUE, this.instance);
            }
            case -1526770491: {
                return new Property("applicability", "", "Expressions that describe applicability criteria for the billing code.", 0, Integer.MAX_VALUE, this.applicability);
            }
            case -1041594966: {
                return new Property("propertyGroup", "", "Group of properties which are applicable under the same conditions. If no applicability rules are established for the group, then all properties always apply.", 0, Integer.MAX_VALUE, this.propertyGroup);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -1076333435: {
                return this.derivedFromUri == null ? new Base[]{} : this.derivedFromUri.toArray(new Base[this.derivedFromUri.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.code;
                }
                return baseArray;
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case -1526770491: {
                return this.applicability == null ? new Base[]{} : this.applicability.toArray(new Base[this.applicability.size()]);
            }
            case -1041594966: {
                return this.propertyGroup == null ? new Base[]{} : this.propertyGroup.toArray(new Base[this.propertyGroup.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -1076333435: {
                this.getDerivedFromUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 555127957: {
                this.getInstance().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1526770491: {
                this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)((Object)value));
                return value;
            }
            case -1041594966: {
                this.getPropertyGroup().add((ChargeItemDefinitionPropertyGroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFromUri")) {
            this.getDerivedFromUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("replaces")) {
            this.getReplaces().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("instance")) {
            this.getInstance().add(TypeConvertor.castToReference(value));
        } else if (name.equals("applicability")) {
            this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)((Object)value));
        } else if (name.equals("propertyGroup")) {
            this.getPropertyGroup().add((ChargeItemDefinitionPropertyGroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1076333435: {
                return this.addDerivedFromUriElement();
            }
            case -995410646: {
                return this.addPartOfElement();
            }
            case -430332865: {
                return this.addReplacesElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case 555127957: {
                return this.addInstance();
            }
            case -1526770491: {
                return this.addApplicability();
            }
            case -1041594966: {
                return this.addPropertyGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1076333435: {
                return new String[]{"uri"};
            }
            case -995410646: {
                return new String[]{"canonical"};
            }
            case -430332865: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 555127957: {
                return new String[]{"Reference"};
            }
            case -1526770491: {
                return new String[0];
            }
            case -1041594966: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.version");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.title");
        }
        if (name.equals("derivedFromUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.derivedFromUri");
        }
        if (name.equals("partOf")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.partOf");
        }
        if (name.equals("replaces")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.replaces");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.lastReviewDate");
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("applicability")) {
            return this.addApplicability();
        }
        if (name.equals("propertyGroup")) {
            return this.addPropertyGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ChargeItemDefinition";
    }

    @Override
    public ChargeItemDefinition copy() {
        ChargeItemDefinition dst = new ChargeItemDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ChargeItemDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFromUri != null) {
            dst.derivedFromUri = new ArrayList<UriType>();
            for (UriType uriType2 : this.derivedFromUri) {
                dst.derivedFromUri.add(uriType2.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.partOf) {
                dst.partOf.add(canonicalType.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.replaces) {
                dst.replaces.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.instance != null) {
            dst.instance = new ArrayList<Reference>();
            for (Reference reference : this.instance) {
                dst.instance.add(reference.copy());
            }
        }
        if (this.applicability != null) {
            dst.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            for (ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : this.applicability) {
                dst.applicability.add(chargeItemDefinitionApplicabilityComponent.copy());
            }
        }
        if (this.propertyGroup != null) {
            dst.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
            for (ChargeItemDefinitionPropertyGroupComponent chargeItemDefinitionPropertyGroupComponent : this.propertyGroup) {
                dst.propertyGroup.add(chargeItemDefinitionPropertyGroupComponent.copy());
            }
        }
    }

    protected ChargeItemDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItemDefinition)) {
            return false;
        }
        ChargeItemDefinition o = (ChargeItemDefinition)other_;
        return ChargeItemDefinition.compareDeep(this.url, o.url, true) && ChargeItemDefinition.compareDeep(this.identifier, o.identifier, true) && ChargeItemDefinition.compareDeep(this.version, o.version, true) && ChargeItemDefinition.compareDeep(this.name, o.name, true) && ChargeItemDefinition.compareDeep(this.title, o.title, true) && ChargeItemDefinition.compareDeep(this.derivedFromUri, o.derivedFromUri, true) && ChargeItemDefinition.compareDeep(this.partOf, o.partOf, true) && ChargeItemDefinition.compareDeep(this.replaces, o.replaces, true) && ChargeItemDefinition.compareDeep(this.status, o.status, true) && ChargeItemDefinition.compareDeep(this.experimental, o.experimental, true) && ChargeItemDefinition.compareDeep(this.date, o.date, true) && ChargeItemDefinition.compareDeep(this.publisher, o.publisher, true) && ChargeItemDefinition.compareDeep(this.contact, o.contact, true) && ChargeItemDefinition.compareDeep(this.description, o.description, true) && ChargeItemDefinition.compareDeep(this.useContext, o.useContext, true) && ChargeItemDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && ChargeItemDefinition.compareDeep(this.purpose, o.purpose, true) && ChargeItemDefinition.compareDeep(this.copyright, o.copyright, true) && ChargeItemDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && ChargeItemDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ChargeItemDefinition.compareDeep(this.code, o.code, true) && ChargeItemDefinition.compareDeep(this.instance, o.instance, true) && ChargeItemDefinition.compareDeep(this.applicability, o.applicability, true) && ChargeItemDefinition.compareDeep(this.propertyGroup, o.propertyGroup, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItemDefinition)) {
            return false;
        }
        ChargeItemDefinition o = (ChargeItemDefinition)other_;
        return ChargeItemDefinition.compareValues(this.url, o.url, true) && ChargeItemDefinition.compareValues(this.version, o.version, true) && ChargeItemDefinition.compareValues(this.name, o.name, true) && ChargeItemDefinition.compareValues(this.title, o.title, true) && ChargeItemDefinition.compareValues(this.derivedFromUri, o.derivedFromUri, true) && ChargeItemDefinition.compareValues(this.partOf, o.partOf, true) && ChargeItemDefinition.compareValues(this.replaces, o.replaces, true) && ChargeItemDefinition.compareValues(this.status, o.status, true) && ChargeItemDefinition.compareValues(this.experimental, o.experimental, true) && ChargeItemDefinition.compareValues(this.date, o.date, true) && ChargeItemDefinition.compareValues(this.publisher, o.publisher, true) && ChargeItemDefinition.compareValues(this.description, o.description, true) && ChargeItemDefinition.compareValues(this.purpose, o.purpose, true) && ChargeItemDefinition.compareValues(this.copyright, o.copyright, true) && ChargeItemDefinition.compareValues(this.approvalDate, o.approvalDate, true) && ChargeItemDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.derivedFromUri, this.partOf, this.replaces, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.code, this.instance, this.applicability, this.propertyGroup});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ChargeItemDefinition;
    }

    @Block
    public static class ChargeItemDefinitionPropertyGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="applicability", type={ChargeItemDefinitionApplicabilityComponent.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Conditions under which the priceComponent is applicable", formalDefinition="Expressions that describe applicability criteria for the priceComponent.")
        protected List<ChargeItemDefinitionApplicabilityComponent> applicability;
        @Child(name="priceComponent", type={MonetaryComponent.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Components of total line item price", formalDefinition="The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.")
        protected List<MonetaryComponent> priceComponent;
        private static final long serialVersionUID = -1829474901L;

        public List<ChargeItemDefinitionApplicabilityComponent> getApplicability() {
            if (this.applicability == null) {
                this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            }
            return this.applicability;
        }

        public ChargeItemDefinitionPropertyGroupComponent setApplicability(List<ChargeItemDefinitionApplicabilityComponent> theApplicability) {
            this.applicability = theApplicability;
            return this;
        }

        public boolean hasApplicability() {
            if (this.applicability == null) {
                return false;
            }
            for (ChargeItemDefinitionApplicabilityComponent item : this.applicability) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ChargeItemDefinitionApplicabilityComponent addApplicability() {
            ChargeItemDefinitionApplicabilityComponent t = new ChargeItemDefinitionApplicabilityComponent();
            if (this.applicability == null) {
                this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            }
            this.applicability.add(t);
            return t;
        }

        public ChargeItemDefinitionPropertyGroupComponent addApplicability(ChargeItemDefinitionApplicabilityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.applicability == null) {
                this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            }
            this.applicability.add(t);
            return this;
        }

        public ChargeItemDefinitionApplicabilityComponent getApplicabilityFirstRep() {
            if (this.getApplicability().isEmpty()) {
                this.addApplicability();
            }
            return this.getApplicability().get(0);
        }

        public List<MonetaryComponent> getPriceComponent() {
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<MonetaryComponent>();
            }
            return this.priceComponent;
        }

        public ChargeItemDefinitionPropertyGroupComponent setPriceComponent(List<MonetaryComponent> thePriceComponent) {
            this.priceComponent = thePriceComponent;
            return this;
        }

        public boolean hasPriceComponent() {
            if (this.priceComponent == null) {
                return false;
            }
            for (MonetaryComponent item : this.priceComponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MonetaryComponent addPriceComponent() {
            MonetaryComponent t = new MonetaryComponent();
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<MonetaryComponent>();
            }
            this.priceComponent.add(t);
            return t;
        }

        public ChargeItemDefinitionPropertyGroupComponent addPriceComponent(MonetaryComponent t) {
            if (t == null) {
                return this;
            }
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<MonetaryComponent>();
            }
            this.priceComponent.add(t);
            return this;
        }

        public MonetaryComponent getPriceComponentFirstRep() {
            if (this.getPriceComponent().isEmpty()) {
                this.addPriceComponent();
            }
            return this.getPriceComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("applicability", "@ChargeItemDefinition.applicability", "Expressions that describe applicability criteria for the priceComponent.", 0, Integer.MAX_VALUE, this.applicability));
            children.add(new Property("priceComponent", "MonetaryComponent", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1526770491: {
                    return new Property("applicability", "@ChargeItemDefinition.applicability", "Expressions that describe applicability criteria for the priceComponent.", 0, Integer.MAX_VALUE, this.applicability);
                }
                case 1219095988: {
                    return new Property("priceComponent", "MonetaryComponent", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    return this.applicability == null ? new Base[]{} : this.applicability.toArray(new Base[this.applicability.size()]);
                }
                case 1219095988: {
                    return this.priceComponent == null ? new Base[]{} : this.priceComponent.toArray(new Base[this.priceComponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)value);
                    return value;
                }
                case 1219095988: {
                    this.getPriceComponent().add(TypeConvertor.castToMonetaryComponent(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("applicability")) {
                this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)value);
            } else if (name.equals("priceComponent")) {
                this.getPriceComponent().add(TypeConvertor.castToMonetaryComponent(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    return this.addApplicability();
                }
                case 1219095988: {
                    return this.addPriceComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    return new String[]{"@ChargeItemDefinition.applicability"};
                }
                case 1219095988: {
                    return new String[]{"MonetaryComponent"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("applicability")) {
                return this.addApplicability();
            }
            if (name.equals("priceComponent")) {
                return this.addPriceComponent();
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemDefinitionPropertyGroupComponent copy() {
            ChargeItemDefinitionPropertyGroupComponent dst = new ChargeItemDefinitionPropertyGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ChargeItemDefinitionPropertyGroupComponent dst) {
            super.copyValues(dst);
            if (this.applicability != null) {
                dst.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
                for (ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : this.applicability) {
                    dst.applicability.add(chargeItemDefinitionApplicabilityComponent.copy());
                }
            }
            if (this.priceComponent != null) {
                dst.priceComponent = new ArrayList<MonetaryComponent>();
                for (MonetaryComponent monetaryComponent : this.priceComponent) {
                    dst.priceComponent.add(monetaryComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionPropertyGroupComponent)) {
                return false;
            }
            ChargeItemDefinitionPropertyGroupComponent o = (ChargeItemDefinitionPropertyGroupComponent)other_;
            return ChargeItemDefinitionPropertyGroupComponent.compareDeep(this.applicability, o.applicability, true) && ChargeItemDefinitionPropertyGroupComponent.compareDeep(this.priceComponent, o.priceComponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionPropertyGroupComponent)) {
                return false;
            }
            ChargeItemDefinitionPropertyGroupComponent o = (ChargeItemDefinitionPropertyGroupComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.applicability, this.priceComponent});
        }

        @Override
        public String fhirType() {
            return "ChargeItemDefinition.propertyGroup";
        }
    }

    @Block
    public static class ChargeItemDefinitionApplicabilityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="condition", type={Expression.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether the condition is satisfied. When using FHIRPath expressions, the %context environment variable must be replaced at runtime with the ChargeItem resource to which this definition is applied.")
        protected Expression condition;
        @Child(name="effectivePeriod", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the charge item definition is expected to be used", formalDefinition="The period during which the charge item definition content was or is planned to be in active use.")
        protected Period effectivePeriod;
        @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to / quotation of the external source of the group of properties", formalDefinition="Reference to / quotation of the external source of the group of properties.")
        protected RelatedArtifact relatedArtifact;
        private static final long serialVersionUID = -1706427366L;

        public Expression getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionApplicabilityComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new Expression();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public ChargeItemDefinitionApplicabilityComponent setCondition(Expression value) {
            this.condition = value;
            return this;
        }

        public Period getEffectivePeriod() {
            if (this.effectivePeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionApplicabilityComponent.effectivePeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectivePeriod = new Period();
                }
            }
            return this.effectivePeriod;
        }

        public boolean hasEffectivePeriod() {
            return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
        }

        public ChargeItemDefinitionApplicabilityComponent setEffectivePeriod(Period value) {
            this.effectivePeriod = value;
            return this;
        }

        public RelatedArtifact getRelatedArtifact() {
            if (this.relatedArtifact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionApplicabilityComponent.relatedArtifact");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedArtifact = new RelatedArtifact();
                }
            }
            return this.relatedArtifact;
        }

        public boolean hasRelatedArtifact() {
            return this.relatedArtifact != null && !this.relatedArtifact.isEmpty();
        }

        public ChargeItemDefinitionApplicabilityComponent setRelatedArtifact(RelatedArtifact value) {
            this.relatedArtifact = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("condition", "Expression", "An expression that returns true or false, indicating whether the condition is satisfied. When using FHIRPath expressions, the %context environment variable must be replaced at runtime with the ChargeItem resource to which this definition is applied.", 0, 1, this.condition));
            children.add(new Property("effectivePeriod", "Period", "The period during which the charge item definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
            children.add(new Property("relatedArtifact", "RelatedArtifact", "Reference to / quotation of the external source of the group of properties.", 0, 1, this.relatedArtifact));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -861311717: {
                    return new Property("condition", "Expression", "An expression that returns true or false, indicating whether the condition is satisfied. When using FHIRPath expressions, the %context environment variable must be replaced at runtime with the ChargeItem resource to which this definition is applied.", 0, 1, this.condition);
                }
                case -403934648: {
                    return new Property("effectivePeriod", "Period", "The period during which the charge item definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
                }
                case 666807069: {
                    return new Property("relatedArtifact", "RelatedArtifact", "Reference to / quotation of the external source of the group of properties.", 0, 1, this.relatedArtifact);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.condition;
                    }
                    return baseArray;
                }
                case -403934648: {
                    Base[] baseArray;
                    if (this.effectivePeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.effectivePeriod;
                    }
                    return baseArray;
                }
                case 666807069: {
                    Base[] baseArray;
                    if (this.relatedArtifact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relatedArtifact;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    this.condition = TypeConvertor.castToExpression(value);
                    return value;
                }
                case -403934648: {
                    this.effectivePeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 666807069: {
                    this.relatedArtifact = TypeConvertor.castToRelatedArtifact(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("condition")) {
                this.condition = TypeConvertor.castToExpression(value);
            } else if (name.equals("effectivePeriod")) {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals("relatedArtifact")) {
                this.relatedArtifact = TypeConvertor.castToRelatedArtifact(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.getCondition();
                }
                case -403934648: {
                    return this.getEffectivePeriod();
                }
                case 666807069: {
                    return this.getRelatedArtifact();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return new String[]{"Expression"};
                }
                case -403934648: {
                    return new String[]{"Period"};
                }
                case 666807069: {
                    return new String[]{"RelatedArtifact"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("condition")) {
                this.condition = new Expression();
                return this.condition;
            }
            if (name.equals("effectivePeriod")) {
                this.effectivePeriod = new Period();
                return this.effectivePeriod;
            }
            if (name.equals("relatedArtifact")) {
                this.relatedArtifact = new RelatedArtifact();
                return this.relatedArtifact;
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemDefinitionApplicabilityComponent copy() {
            ChargeItemDefinitionApplicabilityComponent dst = new ChargeItemDefinitionApplicabilityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ChargeItemDefinitionApplicabilityComponent dst) {
            super.copyValues(dst);
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
            dst.relatedArtifact = this.relatedArtifact == null ? null : this.relatedArtifact.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionApplicabilityComponent)) {
                return false;
            }
            ChargeItemDefinitionApplicabilityComponent o = (ChargeItemDefinitionApplicabilityComponent)other_;
            return ChargeItemDefinitionApplicabilityComponent.compareDeep(this.condition, o.condition, true) && ChargeItemDefinitionApplicabilityComponent.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ChargeItemDefinitionApplicabilityComponent.compareDeep(this.relatedArtifact, o.relatedArtifact, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionApplicabilityComponent)) {
                return false;
            }
            ChargeItemDefinitionApplicabilityComponent o = (ChargeItemDefinitionApplicabilityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.condition, this.effectivePeriod, this.relatedArtifact});
        }

        @Override
        public String fhirType() {
            return "ChargeItemDefinition.applicability";
        }
    }
}

