/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationAdministration", profile="http://hl7.org/fhir/StructureDefinition/MedicationAdministration")
public class MedicationAdministration
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plan this is fulfilled by this administration", formalDefinition="A plan that is fulfilled in whole or in part by this MedicationAdministration.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={MedicationAdministration.class, Procedure.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | not-done | on-hold | completed | entered-in-error | stopped | unknown", formalDefinition="Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-status")
    protected Enumeration<MedicationAdministrationStatusCodes> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason administration not performed", formalDefinition="A code indicating why the administration was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-not-given-codes")
    protected List<CodeableConcept> statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Type of medication administration", formalDefinition="The type of medication administration (for example, drug classification like ATC, where meds would be administered, legal category of the medication).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-location")
    protected List<CodeableConcept> category;
    @Child(name="medication", type={CodeableReference.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What was administered", formalDefinition="Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableReference medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who received medication", formalDefinition="The person or animal or group receiving the medication.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter administered as part of", formalDefinition="The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.")
    protected Reference encounter;
    @Child(name="supportingInformation", type={Reference.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information to support administration", formalDefinition="Additional information (for example, patient height and weight) that supports the administration of the medication.  This attribute can be used to provide documentation of specific characteristics of the patient present at the time of administration.  For example, if the dose says \"give \"x\" if the heartrate exceeds \"y\"\", then the heart rate can be included using this attribute.")
    protected List<Reference> supportingInformation;
    @Child(name="occurence", type={DateTimeType.class, Period.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end time of administration", formalDefinition="A specific date/time or interval of time during which the administration took place (or did not take place). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.")
    protected DataType occurence;
    @Child(name="recorded", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the MedicationAdministration was first captured in the subject's record", formalDefinition="The date the occurrence of the  MedicationAdministration was first captured in the record - potentially significantly after the occurrence of the event.")
    protected DateTimeType recorded;
    @Child(name="isSubPotent", type={BooleanType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Full dose was not administered", formalDefinition="An indication that the full dose was not administered.")
    protected BooleanType isSubPotent;
    @Child(name="subPotentReason", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason full dose was not administered", formalDefinition="The reason or reasons why the full dose was not administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administration-subpotent-reason")
    protected List<CodeableConcept> subPotentReason;
    @Child(name="performer", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what performed the medication administration and what type of performance they did", formalDefinition="Indicates who or what performed the medication administration and how they were involved. For devices, this is the device that is actually performing the administration of the medication.  An IV Pump would be an example of a device that is performing the administration.  Both the IV Pump and the practitioner that set the rate or bolus on the pump can be listed as performers.")
    protected List<MedicationAdministrationPerformerComponent> performer;
    @Child(name="reason", type={CodeableReference.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Concept, condition or observation that supports why the medication was administered", formalDefinition="A code, Condition or observation that supports why the medication was administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-given-codes")
    protected List<CodeableReference> reason;
    @Child(name="request", type={MedicationRequest.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request administration performed against", formalDefinition="The original request, instruction or authority to perform the administration.")
    protected Reference request;
    @Child(name="device", type={Device.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device used to administer", formalDefinition="The device used in administering the medication to the patient.  For example, a particular infusion pump.")
    protected List<Reference> device;
    @Child(name="note", type={Annotation.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the administration", formalDefinition="Extra information about the medication administration that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosage", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of how medication was taken", formalDefinition="Describes the medication dosage information details e.g. dose, rate, site, route, etc.")
    protected MedicationAdministrationDosageComponent dosage;
    @Child(name="eventHistory", type={Provenance.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="A summary of the events of interest that have occurred, such as when the administration was verified.")
    protected List<Reference> eventHistory;
    private static final long serialVersionUID = 97286510L;
    @SearchParamDefinition(name="device", path="MedicationAdministration.device", description="Return administrations with this administration device identity", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device")}, target={Device.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("MedicationAdministration:device").toLocked();
    @SearchParamDefinition(name="performer", path="MedicationAdministration.performer.actor", description="The identity of the individual who administered the medication", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("MedicationAdministration:performer").toLocked();
    @SearchParamDefinition(name="reason-given-code", path="MedicationAdministration.reason.concept", description="Reasons for administering the medication", type="token")
    public static final String SP_REASON_GIVEN_CODE = "reason-given-code";
    public static final TokenClientParam REASON_GIVEN_CODE = new TokenClientParam("reason-given-code");
    @SearchParamDefinition(name="reason-given", path="MedicationAdministration.reason.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_REASON_GIVEN = "reason-given";
    public static final ReferenceClientParam REASON_GIVEN = new ReferenceClientParam("reason-given");
    public static final Include INCLUDE_REASON_GIVEN = new Include("MedicationAdministration:reason-given").toLocked();
    @SearchParamDefinition(name="reason-not-given", path="MedicationAdministration.statusReason", description="Reasons for not administering the medication", type="token")
    public static final String SP_REASON_NOT_GIVEN = "reason-not-given";
    public static final TokenClientParam REASON_NOT_GIVEN = new TokenClientParam("reason-not-given");
    @SearchParamDefinition(name="request", path="MedicationAdministration.request", description="The identity of a request to list administrations from", type="reference", target={MedicationRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("MedicationAdministration:request").toLocked();
    @SearchParamDefinition(name="subject", path="MedicationAdministration.subject", description="The identity of the individual or group to list administrations for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationAdministration:subject").toLocked();
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationAdministration:patient").toLocked();
    @SearchParamDefinition(name="date", path="MedicationAdministration.occurence", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Date administration happened (or did not happen)\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="MedicationAdministration.encounter | MedicationRequest.encounter", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations that share this encounter\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationAdministration:encounter").toLocked();
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medication.reference | MedicationDispense.medication.reference | MedicationRequest.medication.reference | MedicationUsage.medication.reference", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication reference\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine resource\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions for this medication reference\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication reference\r\n", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationAdministration:medication").toLocked();
    @SearchParamDefinition(name="status", path="MedicationAdministration.status | MedicationDispense.status | MedicationRequest.status | MedicationUsage.status", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): MedicationAdministration event status (for example one of active/paused/completed/nullified)\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specified dispense status\r\n* [MedicationRequest](medicationrequest.html): Status of the prescription\r\n* [MedicationUsage](medicationusage.html): Return statements that match the given status\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationAdministration() {
    }

    public MedicationAdministration(MedicationAdministrationStatusCodes status, CodeableReference medication, Reference subject, DataType occurence) {
        this.setStatus(status);
        this.setMedication(medication);
        this.setSubject(subject);
        this.setOccurence(occurence);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationAdministration setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationAdministration addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public MedicationAdministration setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public MedicationAdministration addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public MedicationAdministration setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public MedicationAdministration addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<MedicationAdministrationStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationAdministrationStatusCodes>(new MedicationAdministrationStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationAdministration setStatusElement(Enumeration<MedicationAdministrationStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationAdministrationStatusCodes getStatus() {
        return this.status == null ? null : (MedicationAdministrationStatusCodes)((Object)this.status.getValue());
    }

    public MedicationAdministration setStatus(MedicationAdministrationStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationAdministrationStatusCodes>(new MedicationAdministrationStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getStatusReason() {
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        return this.statusReason;
    }

    public MedicationAdministration setStatusReason(List<CodeableConcept> theStatusReason) {
        this.statusReason = theStatusReason;
        return this;
    }

    public boolean hasStatusReason() {
        if (this.statusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.statusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return t;
    }

    public MedicationAdministration addStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return this;
    }

    public CodeableConcept getStatusReasonFirstRep() {
        if (this.getStatusReason().isEmpty()) {
            this.addStatusReason();
        }
        return this.getStatusReason().get(0);
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public MedicationAdministration setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public MedicationAdministration addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableReference getMedication() {
        if (this.medication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.medication");
            }
            if (Configuration.doAutoCreate()) {
                this.medication = new CodeableReference();
            }
        }
        return this.medication;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationAdministration setMedication(CodeableReference value) {
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationAdministration setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public MedicationAdministration setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public MedicationAdministration setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationAdministration addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public DataType getOccurence() {
        return this.occurence;
    }

    public DateTimeType getOccurenceDateTimeType() throws FHIRException {
        if (this.occurence == null) {
            this.occurence = new DateTimeType();
        }
        if (!(this.occurence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurence;
    }

    public boolean hasOccurenceDateTimeType() {
        return this != null && this.occurence instanceof DateTimeType;
    }

    public Period getOccurencePeriod() throws FHIRException {
        if (this.occurence == null) {
            this.occurence = new Period();
        }
        if (!(this.occurence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurence;
    }

    public boolean hasOccurencePeriod() {
        return this != null && this.occurence instanceof Period;
    }

    public boolean hasOccurence() {
        return this.occurence != null && !this.occurence.isEmpty();
    }

    public MedicationAdministration setOccurence(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for MedicationAdministration.occurence[x]: " + value.fhirType());
        }
        this.occurence = value;
        return this;
    }

    public DateTimeType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new DateTimeType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public MedicationAdministration setRecordedElement(DateTimeType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public MedicationAdministration setRecorded(Date value) {
        if (value == null) {
            this.recorded = null;
        } else {
            if (this.recorded == null) {
                this.recorded = new DateTimeType();
            }
            this.recorded.setValue(value);
        }
        return this;
    }

    public BooleanType getIsSubPotentElement() {
        if (this.isSubPotent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.isSubPotent");
            }
            if (Configuration.doAutoCreate()) {
                this.isSubPotent = new BooleanType();
            }
        }
        return this.isSubPotent;
    }

    public boolean hasIsSubPotentElement() {
        return this.isSubPotent != null && !this.isSubPotent.isEmpty();
    }

    public boolean hasIsSubPotent() {
        return this.isSubPotent != null && !this.isSubPotent.isEmpty();
    }

    public MedicationAdministration setIsSubPotentElement(BooleanType value) {
        this.isSubPotent = value;
        return this;
    }

    public boolean getIsSubPotent() {
        return this.isSubPotent == null || this.isSubPotent.isEmpty() ? false : (Boolean)this.isSubPotent.getValue();
    }

    public MedicationAdministration setIsSubPotent(boolean value) {
        if (this.isSubPotent == null) {
            this.isSubPotent = new BooleanType();
        }
        this.isSubPotent.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getSubPotentReason() {
        if (this.subPotentReason == null) {
            this.subPotentReason = new ArrayList<CodeableConcept>();
        }
        return this.subPotentReason;
    }

    public MedicationAdministration setSubPotentReason(List<CodeableConcept> theSubPotentReason) {
        this.subPotentReason = theSubPotentReason;
        return this;
    }

    public boolean hasSubPotentReason() {
        if (this.subPotentReason == null) {
            return false;
        }
        for (CodeableConcept item : this.subPotentReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubPotentReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.subPotentReason == null) {
            this.subPotentReason = new ArrayList<CodeableConcept>();
        }
        this.subPotentReason.add(t);
        return t;
    }

    public MedicationAdministration addSubPotentReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subPotentReason == null) {
            this.subPotentReason = new ArrayList<CodeableConcept>();
        }
        this.subPotentReason.add(t);
        return this;
    }

    public CodeableConcept getSubPotentReasonFirstRep() {
        if (this.getSubPotentReason().isEmpty()) {
            this.addSubPotentReason();
        }
        return this.getSubPotentReason().get(0);
    }

    public List<MedicationAdministrationPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        return this.performer;
    }

    public MedicationAdministration setPerformer(List<MedicationAdministrationPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (MedicationAdministrationPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationAdministrationPerformerComponent addPerformer() {
        MedicationAdministrationPerformerComponent t = new MedicationAdministrationPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public MedicationAdministration addPerformer(MedicationAdministrationPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public MedicationAdministrationPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public MedicationAdministration setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public MedicationAdministration addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public MedicationAdministration setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public MedicationAdministration setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicationAdministration addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationAdministration setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationAdministration addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public MedicationAdministrationDosageComponent getDosage() {
        if (this.dosage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.dosage");
            }
            if (Configuration.doAutoCreate()) {
                this.dosage = new MedicationAdministrationDosageComponent();
            }
        }
        return this.dosage;
    }

    public boolean hasDosage() {
        return this.dosage != null && !this.dosage.isEmpty();
    }

    public MedicationAdministration setDosage(MedicationAdministrationDosageComponent value) {
        this.dosage = value;
        return this;
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public MedicationAdministration setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public MedicationAdministration addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan)", "A plan that is fulfilled in whole or in part by this MedicationAdministration.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(MedicationAdministration|Procedure)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.statusReason));
        children.add(new Property("category", "CodeableConcept", "The type of medication administration (for example, drug classification like ATC, where meds would be administered, legal category of the medication).", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_MEDICATION, "CodeableReference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person or animal or group receiving the medication.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.", 0, 1, this.encounter));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information (for example, patient height and weight) that supports the administration of the medication.  This attribute can be used to provide documentation of specific characteristics of the patient present at the time of administration.  For example, if the dose says \"give \"x\" if the heartrate exceeds \"y\"\", then the heart rate can be included using this attribute.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("occurence[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.occurence));
        children.add(new Property("recorded", "dateTime", "The date the occurrence of the  MedicationAdministration was first captured in the record - potentially significantly after the occurrence of the event.", 0, 1, this.recorded));
        children.add(new Property("isSubPotent", "boolean", "An indication that the full dose was not administered.", 0, 1, this.isSubPotent));
        children.add(new Property("subPotentReason", "CodeableConcept", "The reason or reasons why the full dose was not administered.", 0, Integer.MAX_VALUE, this.subPotentReason));
        children.add(new Property(SP_PERFORMER, "", "Indicates who or what performed the medication administration and how they were involved. For devices, this is the device that is actually performing the administration of the medication.  An IV Pump would be an example of a device that is performing the administration.  Both the IV Pump and the practitioner that set the rate or bolus on the pump can be listed as performers.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport)", "A code, Condition or observation that supports why the medication was administered.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property(SP_REQUEST, "Reference(MedicationRequest)", "The original request, instruction or authority to perform the administration.", 0, 1, this.request));
        children.add(new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("note", "Annotation", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, 1, this.dosage));
        children.add(new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the administration was verified.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan)", "A plan that is fulfilled in whole or in part by this MedicationAdministration.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(MedicationAdministration|Procedure)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.statusReason);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "The type of medication administration (for example, drug classification like ATC, where meds would be administered, legal category of the medication).", 0, Integer.MAX_VALUE, this.category);
            }
            case 1998965455: {
                return new Property(SP_MEDICATION, "CodeableReference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person or animal or group receiving the medication.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.", 0, 1, this.encounter);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information (for example, patient height and weight) that supports the administration of the medication.  This attribute can be used to provide documentation of specific characteristics of the patient present at the time of administration.  For example, if the dose says \"give \"x\" if the heartrate exceeds \"y\"\", then the heart rate can be included using this attribute.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case 144188521: {
                return new Property("occurence[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.occurence);
            }
            case -1192857417: {
                return new Property("occurence[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.occurence);
            }
            case -820552334: {
                return new Property("occurence[x]", "dateTime", "A specific date/time or interval of time during which the administration took place (or did not take place). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.occurence);
            }
            case 221195608: {
                return new Property("occurence[x]", "Period", "A specific date/time or interval of time during which the administration took place (or did not take place). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, 1, this.occurence);
            }
            case -799233872: {
                return new Property("recorded", "dateTime", "The date the occurrence of the  MedicationAdministration was first captured in the record - potentially significantly after the occurrence of the event.", 0, 1, this.recorded);
            }
            case 702379724: {
                return new Property("isSubPotent", "boolean", "An indication that the full dose was not administered.", 0, 1, this.isSubPotent);
            }
            case 969489082: {
                return new Property("subPotentReason", "CodeableConcept", "The reason or reasons why the full dose was not administered.", 0, Integer.MAX_VALUE, this.subPotentReason);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Indicates who or what performed the medication administration and how they were involved. For devices, this is the device that is actually performing the administration of the medication.  An IV Pump would be an example of a device that is performing the administration.  Both the IV Pump and the practitioner that set the rate or bolus on the pump can be listed as performers.", 0, Integer.MAX_VALUE, this.performer);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport)", "A code, Condition or observation that supports why the medication was administered.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(MedicationRequest)", "The original request, instruction or authority to perform the administration.", 0, 1, this.request);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1326018889: {
                return new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, 1, this.dosage);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the administration was verified.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case -1192857417: {
                Base[] baseArray;
                if (this.occurence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.occurence;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.recorded;
                }
                return baseArray;
            }
            case 702379724: {
                Base[] baseArray;
                if (this.isSubPotent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.isSubPotent;
                }
                return baseArray;
            }
            case 969489082: {
                return this.subPotentReason == null ? new Base[]{} : this.subPotentReason.toArray(new Base[this.subPotentReason.size()]);
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.request;
                }
                return baseArray;
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1326018889: {
                Base[] baseArray;
                if (this.dosage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.dosage;
                }
                return baseArray;
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new MedicationAdministrationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1998965455: {
                this.medication = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1192857417: {
                this.occurence = TypeConvertor.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 702379724: {
                this.isSubPotent = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 969489082: {
                this.getSubPotentReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 481140686: {
                this.getPerformer().add((MedicationAdministrationPerformerComponent)((Object)value));
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1095692943: {
                this.request = TypeConvertor.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.getDevice().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1326018889: {
                this.dosage = (MedicationAdministrationDosageComponent)((Object)value);
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationAdministrationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_MEDICATION)) {
            this.medication = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("occurence[x]")) {
            this.occurence = TypeConvertor.castToType(value);
        } else if (name.equals("recorded")) {
            this.recorded = TypeConvertor.castToDateTime(value);
        } else if (name.equals("isSubPotent")) {
            this.isSubPotent = TypeConvertor.castToBoolean(value);
        } else if (name.equals("subPotentReason")) {
            this.getSubPotentReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((MedicationAdministrationPerformerComponent)((Object)value));
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_REQUEST)) {
            this.request = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.getDevice().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("dosage")) {
            this.dosage = (MedicationAdministrationDosageComponent)((Object)value);
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.addStatusReason();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case 144188521: {
                return this.getOccurence();
            }
            case -1192857417: {
                return this.getOccurence();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case 702379724: {
                return this.getIsSubPotentElement();
            }
            case 969489082: {
                return this.addSubPotentReason();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1326018889: {
                return this.getDosage();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1998965455: {
                return new String[]{"CodeableReference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case -1192857417: {
                return new String[]{"dateTime", "Period"};
            }
            case -799233872: {
                return new String[]{"dateTime"};
            }
            case 702379724: {
                return new String[]{"boolean"};
            }
            case 969489082: {
                return new String[]{"CodeableConcept"};
            }
            case 481140686: {
                return new String[0];
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1326018889: {
                return new String[0];
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.status");
        }
        if (name.equals("statusReason")) {
            return this.addStatusReason();
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_MEDICATION)) {
            this.medication = new CodeableReference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("occurenceDateTime")) {
            this.occurence = new DateTimeType();
            return this.occurence;
        }
        if (name.equals("occurencePeriod")) {
            this.occurence = new Period();
            return this.occurence;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.recorded");
        }
        if (name.equals("isSubPotent")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.isSubPotent");
        }
        if (name.equals("subPotentReason")) {
            return this.addSubPotentReason();
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_DEVICE)) {
            return this.addDevice();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosage")) {
            this.dosage = new MedicationAdministrationDosageComponent();
            return this.dosage;
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationAdministration";
    }

    @Override
    public MedicationAdministration copy() {
        MedicationAdministration dst = new MedicationAdministration();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationAdministration dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<MedicationAdministrationStatusCodes> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusReason != null) {
            dst.statusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.statusReason) {
                dst.statusReason.add(codeableConcept.copy());
            }
        }
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference2 : this.supportingInformation) {
                dst.supportingInformation.add(reference2.copy());
            }
        }
        dst.occurence = this.occurence == null ? null : this.occurence.copy();
        dst.recorded = this.recorded == null ? null : this.recorded.copy();
        BooleanType booleanType = dst.isSubPotent = this.isSubPotent == null ? null : this.isSubPotent.copy();
        if (this.subPotentReason != null) {
            dst.subPotentReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.subPotentReason) {
                dst.subPotentReason.add(codeableConcept.copy());
            }
        }
        if (this.performer != null) {
            dst.performer = new ArrayList<MedicationAdministrationPerformerComponent>();
            for (MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : this.performer) {
                dst.performer.add(medicationAdministrationPerformerComponent.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        Reference reference3 = dst.request = this.request == null ? null : this.request.copy();
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference4 : this.device) {
                dst.device.add(reference4.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = dst.dosage = this.dosage == null ? null : this.dosage.copy();
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference5 : this.eventHistory) {
                dst.eventHistory.add(reference5.copy());
            }
        }
    }

    protected MedicationAdministration typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other_;
        return MedicationAdministration.compareDeep(this.identifier, o.identifier, true) && MedicationAdministration.compareDeep(this.basedOn, o.basedOn, true) && MedicationAdministration.compareDeep(this.partOf, o.partOf, true) && MedicationAdministration.compareDeep(this.status, o.status, true) && MedicationAdministration.compareDeep(this.statusReason, o.statusReason, true) && MedicationAdministration.compareDeep(this.category, o.category, true) && MedicationAdministration.compareDeep(this.medication, o.medication, true) && MedicationAdministration.compareDeep(this.subject, o.subject, true) && MedicationAdministration.compareDeep(this.encounter, o.encounter, true) && MedicationAdministration.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationAdministration.compareDeep(this.occurence, o.occurence, true) && MedicationAdministration.compareDeep(this.recorded, o.recorded, true) && MedicationAdministration.compareDeep(this.isSubPotent, o.isSubPotent, true) && MedicationAdministration.compareDeep(this.subPotentReason, o.subPotentReason, true) && MedicationAdministration.compareDeep(this.performer, o.performer, true) && MedicationAdministration.compareDeep(this.reason, o.reason, true) && MedicationAdministration.compareDeep(this.request, o.request, true) && MedicationAdministration.compareDeep(this.device, o.device, true) && MedicationAdministration.compareDeep(this.note, o.note, true) && MedicationAdministration.compareDeep(this.dosage, o.dosage, true) && MedicationAdministration.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other_;
        return MedicationAdministration.compareValues(this.status, o.status, true) && MedicationAdministration.compareValues(this.recorded, o.recorded, true) && MedicationAdministration.compareValues(this.isSubPotent, o.isSubPotent, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.status, this.statusReason, this.category, this.medication, this.subject, this.encounter, this.supportingInformation, this.occurence, this.recorded, this.isSubPotent, this.subPotentReason, this.performer, this.reason, this.request, this.device, this.note, this.dosage, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationAdministration;
    }

    @Block
    public static class MedicationAdministrationDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Free text dosage instructions e.g. SIG", formalDefinition="Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.")
        protected StringType text;
        @Child(name="site", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Body site administered to", formalDefinition="A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
        protected CodeableConcept site;
        @Child(name="route", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path of substance into body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How drug was administered", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
        protected CodeableConcept method;
        @Child(name="dose", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.")
        protected Quantity dose;
        @Child(name="rate", type={Ratio.class, Quantity.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected DataType rate;
        private static final long serialVersionUID = -484090956L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationAdministrationDosageComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationAdministrationDosageComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getSite() {
            if (this.site == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.site");
                }
                if (Configuration.doAutoCreate()) {
                    this.site = new CodeableConcept();
                }
            }
            return this.site;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationAdministrationDosageComponent setSite(CodeableConcept value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationAdministrationDosageComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public Quantity getDose() {
            if (this.dose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.dose");
                }
                if (Configuration.doAutoCreate()) {
                    this.dose = new Quantity();
                }
            }
            return this.dose;
        }

        public boolean hasDose() {
            return this.dose != null && !this.dose.isEmpty();
        }

        public MedicationAdministrationDosageComponent setDose(Quantity value) {
            this.dose = value;
            return this;
        }

        public DataType getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Ratio();
            }
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this != null && this.rate instanceof Ratio;
        }

        public Quantity getRateQuantity() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Quantity();
            }
            if (!(this.rate instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Quantity)this.rate;
        }

        public boolean hasRateQuantity() {
            return this != null && this.rate instanceof Quantity;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRate(DataType value) {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for MedicationAdministration.dosage.rate[x]: " + value.fhirType());
            }
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("text", "string", "Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.", 0, 1, this.text));
            children.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, 1, this.site));
            children.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, 1, this.route));
            children.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, 1, this.method));
            children.add(new Property("dose", "Quantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, 1, this.dose));
            children.add(new Property("rate[x]", "Ratio|Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3556653: {
                    return new Property("text", "string", "Free text dosage can be used for cases where the dosage administered is too complex to code. When coded dosage is present, the free text dosage may still be present for display to humans.\r\rThe dosage instructions should reflect the dosage of the medication that was administered.", 0, 1, this.text);
                }
                case 3530567: {
                    return new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, 1, this.site);
                }
                case 108704329: {
                    return new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, 1, this.route);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, 1, this.method);
                }
                case 3089437: {
                    return new Property("dose", "Quantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, 1, this.dose);
                }
                case 983460768: {
                    return new Property("rate[x]", "Ratio|Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case 3493088: {
                    return new Property("rate[x]", "Ratio|Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case 204021515: {
                    return new Property("rate[x]", "Ratio", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
                case -1085459061: {
                    return new Property("rate[x]", "Quantity", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically, the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time, e.g. 500 ml per 2 hours.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, 1, this.rate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.text;
                    }
                    return baseArray;
                }
                case 3530567: {
                    Base[] baseArray;
                    if (this.site == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.site;
                    }
                    return baseArray;
                }
                case 108704329: {
                    Base[] baseArray;
                    if (this.route == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.route;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.method;
                    }
                    return baseArray;
                }
                case 3089437: {
                    Base[] baseArray;
                    if (this.dose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.dose;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.rate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
                case 3530567: {
                    this.site = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 108704329: {
                    this.route = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1077554975: {
                    this.method = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3089437: {
                    this.dose = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3493088: {
                    this.rate = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else if (name.equals("site")) {
                this.site = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("route")) {
                this.route = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dose")) {
                this.dose = TypeConvertor.castToQuantity(value);
            } else if (name.equals("rate[x]")) {
                this.rate = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    return this.getTextElement();
                }
                case 3530567: {
                    return this.getSite();
                }
                case 108704329: {
                    return this.getRoute();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case 3089437: {
                    return this.getDose();
                }
                case 983460768: {
                    return this.getRate();
                }
                case 3493088: {
                    return this.getRate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    return new String[]{"string"};
                }
                case 3530567: {
                    return new String[]{"CodeableConcept"};
                }
                case 108704329: {
                    return new String[]{"CodeableConcept"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 3089437: {
                    return new String[]{"Quantity"};
                }
                case 3493088: {
                    return new String[]{"Ratio", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationAdministration.dosage.text");
            }
            if (name.equals("site")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("dose")) {
                this.dose = new Quantity();
                return this.dose;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateQuantity")) {
                this.rate = new Quantity();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationDosageComponent copy() {
            MedicationAdministrationDosageComponent dst = new MedicationAdministrationDosageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationAdministrationDosageComponent dst) {
            super.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.dose = this.dose == null ? null : this.dose.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other_;
            return MedicationAdministrationDosageComponent.compareDeep(this.text, o.text, true) && MedicationAdministrationDosageComponent.compareDeep(this.site, o.site, true) && MedicationAdministrationDosageComponent.compareDeep(this.route, o.route, true) && MedicationAdministrationDosageComponent.compareDeep(this.method, o.method, true) && MedicationAdministrationDosageComponent.compareDeep(this.dose, o.dose, true) && MedicationAdministrationDosageComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other_;
            return MedicationAdministrationDosageComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.text, this.site, this.route, this.method, this.dose, this.rate});
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.dosage";
        }
    }

    @Block
    public static class MedicationAdministrationPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of performance", formalDefinition="Distinguishes the type of involvement of the performer in the medication administration.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/med-admin-perform-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Device.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the medication administration", formalDefinition="Indicates who or what performed the medication administration.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public MedicationAdministrationPerformerComponent() {
        }

        public MedicationAdministrationPerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public MedicationAdministrationPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public MedicationAdministrationPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the medication administration.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device)", "Indicates who or what performed the medication administration.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the medication administration.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device)", "Indicates who or what performed the medication administration.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationPerformerComponent copy() {
            MedicationAdministrationPerformerComponent dst = new MedicationAdministrationPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationAdministrationPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationPerformerComponent)) {
                return false;
            }
            MedicationAdministrationPerformerComponent o = (MedicationAdministrationPerformerComponent)other_;
            return MedicationAdministrationPerformerComponent.compareDeep(this.function, o.function, true) && MedicationAdministrationPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationAdministrationPerformerComponent)) {
                return false;
            }
            MedicationAdministrationPerformerComponent o = (MedicationAdministrationPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.performer";
        }
    }

    public static class MedicationAdministrationStatusCodesEnumFactory
    implements EnumFactory<MedicationAdministrationStatusCodes> {
        @Override
        public MedicationAdministrationStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return MedicationAdministrationStatusCodes.INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return MedicationAdministrationStatusCodes.NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationAdministrationStatusCodes.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationAdministrationStatusCodes.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationAdministrationStatusCodes.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationAdministrationStatusCodes.STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return MedicationAdministrationStatusCodes.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MedicationAdministrationStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationAdministrationStatusCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.INPROGRESS);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.NOTDONE);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.STOPPED);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatusCodes>(this, MedicationAdministrationStatusCodes.UNKNOWN);
            }
            throw new FHIRException("Unknown MedicationAdministrationStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationAdministrationStatusCodes code) {
            if (code == MedicationAdministrationStatusCodes.INPROGRESS) {
                return "in-progress";
            }
            if (code == MedicationAdministrationStatusCodes.NOTDONE) {
                return "not-done";
            }
            if (code == MedicationAdministrationStatusCodes.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationAdministrationStatusCodes.COMPLETED) {
                return "completed";
            }
            if (code == MedicationAdministrationStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationAdministrationStatusCodes.STOPPED) {
                return "stopped";
            }
            if (code == MedicationAdministrationStatusCodes.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationAdministrationStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationAdministrationStatusCodes {
        INPROGRESS,
        NOTDONE,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        UNKNOWN,
        NULL;


        public static MedicationAdministrationStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationAdministrationStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The administration has started but has not yet completed.";
                }
                case NOTDONE: {
                    return "The administration was terminated prior to any impact on the subject (though preparatory actions may have been taken)";
                }
                case ONHOLD: {
                    return "Actions implied by the administration have been temporarily halted, but are expected to continue later. May also be called 'suspended'.";
                }
                case COMPLETED: {
                    return "All actions that are implied by the administration have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The administration was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the administration have been permanently halted, before all of them occurred.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for 'other' - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case NOTDONE: {
                    return "Not Done";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

