/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="MonetaryComponent")
public class MonetaryComponent
extends DataType
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="base | surcharge | deduction | discount | tax | informational", formalDefinition="base | surcharge | deduction | discount | tax | informational.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/price-component-type")
    protected Enumeration<PriceComponentType> type;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", formalDefinition="Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.")
    protected CodeableConcept code;
    @Child(name="factor", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Factor used for calculating this component", formalDefinition="Factor used for calculating this component.")
    protected DecimalType factor;
    @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Explicit value amount to be used", formalDefinition="Explicit value amount to be used.")
    protected Money amount;
    private static final long serialVersionUID = 576423679L;

    public MonetaryComponent() {
    }

    public MonetaryComponent(PriceComponentType type) {
        this.setType(type);
    }

    public Enumeration<PriceComponentType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MonetaryComponent.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<PriceComponentType>(new PriceComponentTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MonetaryComponent setTypeElement(Enumeration<PriceComponentType> value) {
        this.type = value;
        return this;
    }

    public PriceComponentType getType() {
        return this.type == null ? null : (PriceComponentType)((Object)this.type.getValue());
    }

    public MonetaryComponent setType(PriceComponentType value) {
        if (this.type == null) {
            this.type = new Enumeration<PriceComponentType>(new PriceComponentTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MonetaryComponent.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public MonetaryComponent setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public DecimalType getFactorElement() {
        if (this.factor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MonetaryComponent.factor");
            }
            if (Configuration.doAutoCreate()) {
                this.factor = new DecimalType();
            }
        }
        return this.factor;
    }

    public boolean hasFactorElement() {
        return this.factor != null && !this.factor.isEmpty();
    }

    public boolean hasFactor() {
        return this.factor != null && !this.factor.isEmpty();
    }

    public MonetaryComponent setFactorElement(DecimalType value) {
        this.factor = value;
        return this;
    }

    public BigDecimal getFactor() {
        return this.factor == null ? null : (BigDecimal)this.factor.getValue();
    }

    public MonetaryComponent setFactor(BigDecimal value) {
        if (value == null) {
            this.factor = null;
        } else {
            if (this.factor == null) {
                this.factor = new DecimalType();
            }
            this.factor.setValue(value);
        }
        return this;
    }

    public MonetaryComponent setFactor(long value) {
        this.factor = new DecimalType();
        this.factor.setValue(value);
        return this;
    }

    public MonetaryComponent setFactor(double value) {
        this.factor = new DecimalType();
        this.factor.setValue(value);
        return this;
    }

    public Money getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MonetaryComponent.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new Money();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public MonetaryComponent setAmount(Money value) {
        this.amount = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "code", "base | surcharge | deduction | discount | tax | informational.", 0, 1, this.type));
        children.add(new Property("code", "CodeableConcept", "Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", 0, 1, this.code));
        children.add(new Property("factor", "decimal", "Factor used for calculating this component.", 0, 1, this.factor));
        children.add(new Property("amount", "Money", "Explicit value amount to be used.", 0, 1, this.amount));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "code", "base | surcharge | deduction | discount | tax | informational.", 0, 1, this.type);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", 0, 1, this.code);
            }
            case -1282148017: {
                return new Property("factor", "decimal", "Factor used for calculating this component.", 0, 1, this.factor);
            }
            case -1413853096: {
                return new Property("amount", "Money", "Explicit value amount to be used.", 0, 1, this.amount);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1282148017: {
                Base[] baseArray;
                if (this.factor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.factor;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.amount;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                value = new PriceComponentTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1282148017: {
                this.factor = TypeConvertor.castToDecimal(value);
                return value;
            }
            case -1413853096: {
                this.amount = TypeConvertor.castToMoney(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            value = new PriceComponentTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("factor")) {
            this.factor = TypeConvertor.castToDecimal(value);
        } else if (name.equals("amount")) {
            this.amount = TypeConvertor.castToMoney(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1282148017: {
                return this.getFactorElement();
            }
            case -1413853096: {
                return this.getAmount();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1282148017: {
                return new String[]{"decimal"};
            }
            case -1413853096: {
                return new String[]{"Money"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type MonetaryComponent.type");
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("factor")) {
            throw new FHIRException("Cannot call addChild on a primitive type MonetaryComponent.factor");
        }
        if (name.equals("amount")) {
            this.amount = new Money();
            return this.amount;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MonetaryComponent";
    }

    @Override
    public MonetaryComponent copy() {
        MonetaryComponent dst = new MonetaryComponent();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MonetaryComponent dst) {
        super.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.factor = this.factor == null ? null : this.factor.copy();
        dst.amount = this.amount == null ? null : this.amount.copy();
    }

    protected MonetaryComponent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MonetaryComponent)) {
            return false;
        }
        MonetaryComponent o = (MonetaryComponent)other_;
        return MonetaryComponent.compareDeep(this.type, o.type, true) && MonetaryComponent.compareDeep(this.code, o.code, true) && MonetaryComponent.compareDeep(this.factor, o.factor, true) && MonetaryComponent.compareDeep(this.amount, o.amount, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MonetaryComponent)) {
            return false;
        }
        MonetaryComponent o = (MonetaryComponent)other_;
        return MonetaryComponent.compareValues(this.type, o.type, true) && MonetaryComponent.compareValues(this.factor, o.factor, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.code, this.factor, this.amount});
    }

    public static class PriceComponentTypeEnumFactory
    implements EnumFactory<PriceComponentType> {
        @Override
        public PriceComponentType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("base".equals(codeString)) {
                return PriceComponentType.BASE;
            }
            if ("surcharge".equals(codeString)) {
                return PriceComponentType.SURCHARGE;
            }
            if ("deduction".equals(codeString)) {
                return PriceComponentType.DEDUCTION;
            }
            if ("discount".equals(codeString)) {
                return PriceComponentType.DISCOUNT;
            }
            if ("tax".equals(codeString)) {
                return PriceComponentType.TAX;
            }
            if ("informational".equals(codeString)) {
                return PriceComponentType.INFORMATIONAL;
            }
            throw new IllegalArgumentException("Unknown PriceComponentType code '" + codeString + "'");
        }

        public Enumeration<PriceComponentType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PriceComponentType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("base".equals(codeString)) {
                return new Enumeration<PriceComponentType>(this, PriceComponentType.BASE);
            }
            if ("surcharge".equals(codeString)) {
                return new Enumeration<PriceComponentType>(this, PriceComponentType.SURCHARGE);
            }
            if ("deduction".equals(codeString)) {
                return new Enumeration<PriceComponentType>(this, PriceComponentType.DEDUCTION);
            }
            if ("discount".equals(codeString)) {
                return new Enumeration<PriceComponentType>(this, PriceComponentType.DISCOUNT);
            }
            if ("tax".equals(codeString)) {
                return new Enumeration<PriceComponentType>(this, PriceComponentType.TAX);
            }
            if ("informational".equals(codeString)) {
                return new Enumeration<PriceComponentType>(this, PriceComponentType.INFORMATIONAL);
            }
            throw new FHIRException("Unknown PriceComponentType code '" + codeString + "'");
        }

        @Override
        public String toCode(PriceComponentType code) {
            if (code == PriceComponentType.BASE) {
                return "base";
            }
            if (code == PriceComponentType.SURCHARGE) {
                return "surcharge";
            }
            if (code == PriceComponentType.DEDUCTION) {
                return "deduction";
            }
            if (code == PriceComponentType.DISCOUNT) {
                return "discount";
            }
            if (code == PriceComponentType.TAX) {
                return "tax";
            }
            if (code == PriceComponentType.INFORMATIONAL) {
                return "informational";
            }
            return "?";
        }

        @Override
        public String toSystem(PriceComponentType code) {
            return code.getSystem();
        }
    }

    public static enum PriceComponentType {
        BASE,
        SURCHARGE,
        DEDUCTION,
        DISCOUNT,
        TAX,
        INFORMATIONAL,
        NULL;


        public static PriceComponentType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("base".equals(codeString)) {
                return BASE;
            }
            if ("surcharge".equals(codeString)) {
                return SURCHARGE;
            }
            if ("deduction".equals(codeString)) {
                return DEDUCTION;
            }
            if ("discount".equals(codeString)) {
                return DISCOUNT;
            }
            if ("tax".equals(codeString)) {
                return TAX;
            }
            if ("informational".equals(codeString)) {
                return INFORMATIONAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PriceComponentType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BASE: {
                    return "base";
                }
                case SURCHARGE: {
                    return "surcharge";
                }
                case DEDUCTION: {
                    return "deduction";
                }
                case DISCOUNT: {
                    return "discount";
                }
                case TAX: {
                    return "tax";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BASE: {
                    return "http://hl7.org/fhir/price-component-type";
                }
                case SURCHARGE: {
                    return "http://hl7.org/fhir/price-component-type";
                }
                case DEDUCTION: {
                    return "http://hl7.org/fhir/price-component-type";
                }
                case DISCOUNT: {
                    return "http://hl7.org/fhir/price-component-type";
                }
                case TAX: {
                    return "http://hl7.org/fhir/price-component-type";
                }
                case INFORMATIONAL: {
                    return "http://hl7.org/fhir/price-component-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BASE: {
                    return "the amount is the base price used for calculating the total price before applying surcharges, discount or taxes.";
                }
                case SURCHARGE: {
                    return "the amount is a surcharge applied on the base price.";
                }
                case DEDUCTION: {
                    return "the amount is a deduction applied on the base price.";
                }
                case DISCOUNT: {
                    return "the amount is a discount applied on the base price.";
                }
                case TAX: {
                    return "the amount is the tax component of the total price.";
                }
                case INFORMATIONAL: {
                    return "the amount is of informational character, it has not been applied in the calculation of the total price.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BASE: {
                    return "base price";
                }
                case SURCHARGE: {
                    return "surcharge";
                }
                case DEDUCTION: {
                    return "deduction";
                }
                case DISCOUNT: {
                    return "discount";
                }
                case TAX: {
                    return "tax";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

