/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchSubject", profile="http://hl7.org/fhir/StructureDefinition/ResearchSubject")
public class ResearchSubject
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for research subject in a study", formalDefinition="Identifiers assigned to this research subject for a study.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The publication state of the resource (not of the subject).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="progress", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Subject status", formalDefinition="The current state (status) of the subject and resons for status change where appropriate.")
    protected List<ResearchSubjectProgressComponent> progress;
    @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end of participation", formalDefinition="The dates the subject began and ended their participation in the study.")
    protected Period period;
    @Child(name="study", type={ResearchStudy.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Study subject is part of", formalDefinition="Reference to the study the subject is participating in.")
    protected Reference study;
    @Child(name="subject", type={Patient.class, Group.class, Specimen.class, Device.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what is part of study", formalDefinition="The record of the person, animal or other entity involved in the study.")
    protected Reference subject;
    @Child(name="assignedArm", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path should be followed", formalDefinition="The name of the arm in the study the subject is expected to follow as part of this study.")
    protected StringType assignedArm;
    @Child(name="actualArm", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path was followed", formalDefinition="The name of the arm in the study the subject actually followed as part of this study.")
    protected StringType actualArm;
    @Child(name="consent", type={Consent.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Agreement to participate in study", formalDefinition="A record of the patient's informed agreement to participate in the study.")
    protected Reference consent;
    private static final long serialVersionUID = -398870757L;
    @SearchParamDefinition(name="date", path="ResearchSubject.period", description="Start and end of participation", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ResearchSubject.identifier", description="Business Identifier for research subject in a study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="ResearchSubject.subject", description="Who or what is part of study", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Medication.class, Patient.class, Specimen.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ResearchSubject:patient").toLocked();
    @SearchParamDefinition(name="status", path="ResearchSubject.status", description="draft | active | retired | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="study", path="ResearchSubject.study", description="Study subject is part of", type="reference", target={ResearchStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("ResearchSubject:study").toLocked();
    @SearchParamDefinition(name="subject", path="ResearchSubject.subject", description="Who or what is part of study", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Medication.class, Patient.class, Specimen.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ResearchSubject:subject").toLocked();
    @SearchParamDefinition(name="subject_state", path="ResearchSubject.progress.subjectState", description="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", type="token")
    public static final String SP_SUBJECTSTATE = "subject_state";
    public static final TokenClientParam SUBJECTSTATE = new TokenClientParam("subject_state");

    public ResearchSubject() {
    }

    public ResearchSubject(Enumerations.PublicationStatus status, Reference study, Reference subject) {
        this.setStatus(status);
        this.setStudy(study);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchSubject setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchSubject addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchSubject setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public ResearchSubject setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<ResearchSubjectProgressComponent> getProgress() {
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        return this.progress;
    }

    public ResearchSubject setProgress(List<ResearchSubjectProgressComponent> theProgress) {
        this.progress = theProgress;
        return this;
    }

    public boolean hasProgress() {
        if (this.progress == null) {
            return false;
        }
        for (ResearchSubjectProgressComponent item : this.progress) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchSubjectProgressComponent addProgress() {
        ResearchSubjectProgressComponent t = new ResearchSubjectProgressComponent();
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        this.progress.add(t);
        return t;
    }

    public ResearchSubject addProgress(ResearchSubjectProgressComponent t) {
        if (t == null) {
            return this;
        }
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        this.progress.add(t);
        return this;
    }

    public ResearchSubjectProgressComponent getProgressFirstRep() {
        if (this.getProgress().isEmpty()) {
            this.addProgress();
        }
        return this.getProgress().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchSubject setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getStudy() {
        if (this.study == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.study");
            }
            if (Configuration.doAutoCreate()) {
                this.study = new Reference();
            }
        }
        return this.study;
    }

    public boolean hasStudy() {
        return this.study != null && !this.study.isEmpty();
    }

    public ResearchSubject setStudy(Reference value) {
        this.study = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ResearchSubject setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public StringType getAssignedArmElement() {
        if (this.assignedArm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.assignedArm");
            }
            if (Configuration.doAutoCreate()) {
                this.assignedArm = new StringType();
            }
        }
        return this.assignedArm;
    }

    public boolean hasAssignedArmElement() {
        return this.assignedArm != null && !this.assignedArm.isEmpty();
    }

    public boolean hasAssignedArm() {
        return this.assignedArm != null && !this.assignedArm.isEmpty();
    }

    public ResearchSubject setAssignedArmElement(StringType value) {
        this.assignedArm = value;
        return this;
    }

    public String getAssignedArm() {
        return this.assignedArm == null ? null : (String)this.assignedArm.getValue();
    }

    public ResearchSubject setAssignedArm(String value) {
        if (Utilities.noString((String)value)) {
            this.assignedArm = null;
        } else {
            if (this.assignedArm == null) {
                this.assignedArm = new StringType();
            }
            this.assignedArm.setValue(value);
        }
        return this;
    }

    public StringType getActualArmElement() {
        if (this.actualArm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.actualArm");
            }
            if (Configuration.doAutoCreate()) {
                this.actualArm = new StringType();
            }
        }
        return this.actualArm;
    }

    public boolean hasActualArmElement() {
        return this.actualArm != null && !this.actualArm.isEmpty();
    }

    public boolean hasActualArm() {
        return this.actualArm != null && !this.actualArm.isEmpty();
    }

    public ResearchSubject setActualArmElement(StringType value) {
        this.actualArm = value;
        return this;
    }

    public String getActualArm() {
        return this.actualArm == null ? null : (String)this.actualArm.getValue();
    }

    public ResearchSubject setActualArm(String value) {
        if (Utilities.noString((String)value)) {
            this.actualArm = null;
        } else {
            if (this.actualArm == null) {
                this.actualArm = new StringType();
            }
            this.actualArm.setValue(value);
        }
        return this;
    }

    public Reference getConsent() {
        if (this.consent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.consent");
            }
            if (Configuration.doAutoCreate()) {
                this.consent = new Reference();
            }
        }
        return this.consent;
    }

    public boolean hasConsent() {
        return this.consent != null && !this.consent.isEmpty();
    }

    public ResearchSubject setConsent(Reference value) {
        this.consent = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research subject for a study.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The publication state of the resource (not of the subject).", 0, 1, this.status));
        children.add(new Property("progress", "", "The current state (status) of the subject and resons for status change where appropriate.", 0, Integer.MAX_VALUE, this.progress));
        children.add(new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period));
        children.add(new Property(SP_STUDY, "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Specimen|Device|Medication|Substance|BiologicallyDerivedProduct)", "The record of the person, animal or other entity involved in the study.", 0, 1, this.subject));
        children.add(new Property("assignedArm", "string", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedArm));
        children.add(new Property("actualArm", "string", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualArm));
        children.add(new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, 1, this.consent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research subject for a study.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The publication state of the resource (not of the subject).", 0, 1, this.status);
            }
            case -1001078227: {
                return new Property("progress", "", "The current state (status) of the subject and resons for status change where appropriate.", 0, Integer.MAX_VALUE, this.progress);
            }
            case -991726143: {
                return new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Specimen|Device|Medication|Substance|BiologicallyDerivedProduct)", "The record of the person, animal or other entity involved in the study.", 0, 1, this.subject);
            }
            case 1741912494: {
                return new Property("assignedArm", "string", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedArm);
            }
            case 528827886: {
                return new Property("actualArm", "string", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualArm);
            }
            case 951500826: {
                return new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, 1, this.consent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1001078227: {
                return this.progress == null ? new Base[]{} : this.progress.toArray(new Base[this.progress.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 109776329: {
                Base[] baseArray;
                if (this.study == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.study;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1741912494: {
                Base[] baseArray;
                if (this.assignedArm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.assignedArm;
                }
                return baseArray;
            }
            case 528827886: {
                Base[] baseArray;
                if (this.actualArm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.actualArm;
                }
                return baseArray;
            }
            case 951500826: {
                Base[] baseArray;
                if (this.consent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.consent;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1001078227: {
                this.getProgress().add((ResearchSubjectProgressComponent)((Object)value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 109776329: {
                this.study = TypeConvertor.castToReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1741912494: {
                this.assignedArm = TypeConvertor.castToString(value);
                return value;
            }
            case 528827886: {
                this.actualArm = TypeConvertor.castToString(value);
                return value;
            }
            case 951500826: {
                this.consent = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("progress")) {
            this.getProgress().add((ResearchSubjectProgressComponent)((Object)value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_STUDY)) {
            this.study = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("assignedArm")) {
            this.assignedArm = TypeConvertor.castToString(value);
        } else if (name.equals("actualArm")) {
            this.actualArm = TypeConvertor.castToString(value);
        } else if (name.equals("consent")) {
            this.consent = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1001078227: {
                return this.addProgress();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 109776329: {
                return this.getStudy();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1741912494: {
                return this.getAssignedArmElement();
            }
            case 528827886: {
                return this.getActualArmElement();
            }
            case 951500826: {
                return this.getConsent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1001078227: {
                return new String[0];
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1741912494: {
                return new String[]{"string"};
            }
            case 528827886: {
                return new String[]{"string"};
            }
            case 951500826: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.status");
        }
        if (name.equals("progress")) {
            return this.addProgress();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_STUDY)) {
            this.study = new Reference();
            return this.study;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("assignedArm")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.assignedArm");
        }
        if (name.equals("actualArm")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.actualArm");
        }
        if (name.equals("consent")) {
            this.consent = new Reference();
            return this.consent;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchSubject";
    }

    @Override
    public ResearchSubject copy() {
        ResearchSubject dst = new ResearchSubject();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ResearchSubject dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.progress != null) {
            dst.progress = new ArrayList<ResearchSubjectProgressComponent>();
            for (ResearchSubjectProgressComponent researchSubjectProgressComponent : this.progress) {
                dst.progress.add(researchSubjectProgressComponent.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.study = this.study == null ? null : this.study.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.assignedArm = this.assignedArm == null ? null : this.assignedArm.copy();
        dst.actualArm = this.actualArm == null ? null : this.actualArm.copy();
        dst.consent = this.consent == null ? null : this.consent.copy();
    }

    protected ResearchSubject typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareDeep(this.identifier, o.identifier, true) && ResearchSubject.compareDeep(this.status, o.status, true) && ResearchSubject.compareDeep(this.progress, o.progress, true) && ResearchSubject.compareDeep(this.period, o.period, true) && ResearchSubject.compareDeep(this.study, o.study, true) && ResearchSubject.compareDeep(this.subject, o.subject, true) && ResearchSubject.compareDeep(this.assignedArm, o.assignedArm, true) && ResearchSubject.compareDeep(this.actualArm, o.actualArm, true) && ResearchSubject.compareDeep(this.consent, o.consent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareValues(this.status, o.status, true) && ResearchSubject.compareValues(this.assignedArm, o.assignedArm, true) && ResearchSubject.compareValues(this.actualArm, o.actualArm, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.progress, this.period, this.study, this.subject, this.assignedArm, this.actualArm, this.consent});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchSubject;
    }

    @Block
    public static class ResearchSubjectProgressComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="state | milestone", formalDefinition="Identifies the aspect of the subject's journey that the state refers to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-state-type")
        protected CodeableConcept type;
        @Child(name="subjectState", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", formalDefinition="The current state of the subject.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-state")
        protected CodeableConcept subjectState;
        @Child(name="milestone", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="SignedUp | Screened | Randomized", formalDefinition="The milestones the subject has passed through.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-milestone")
        protected CodeableConcept milestone;
        @Child(name="reason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change reason", formalDefinition="The reason for the state change.  If coded it should follow the formal subject state model.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/state-change-reason")
        protected CodeableConcept reason;
        @Child(name="startDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change date", formalDefinition="The date when the new status started.")
        protected DateTimeType startDate;
        @Child(name="endDate", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change date", formalDefinition="The date when the state ended.")
        protected DateTimeType endDate;
        private static final long serialVersionUID = -330838916L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchSubjectProgressComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getSubjectState() {
            if (this.subjectState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.subjectState");
                }
                if (Configuration.doAutoCreate()) {
                    this.subjectState = new CodeableConcept();
                }
            }
            return this.subjectState;
        }

        public boolean hasSubjectState() {
            return this.subjectState != null && !this.subjectState.isEmpty();
        }

        public ResearchSubjectProgressComponent setSubjectState(CodeableConcept value) {
            this.subjectState = value;
            return this;
        }

        public CodeableConcept getMilestone() {
            if (this.milestone == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.milestone");
                }
                if (Configuration.doAutoCreate()) {
                    this.milestone = new CodeableConcept();
                }
            }
            return this.milestone;
        }

        public boolean hasMilestone() {
            return this.milestone != null && !this.milestone.isEmpty();
        }

        public ResearchSubjectProgressComponent setMilestone(CodeableConcept value) {
            this.milestone = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public ResearchSubjectProgressComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public DateTimeType getStartDateElement() {
            if (this.startDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.startDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.startDate = new DateTimeType();
                }
            }
            return this.startDate;
        }

        public boolean hasStartDateElement() {
            return this.startDate != null && !this.startDate.isEmpty();
        }

        public boolean hasStartDate() {
            return this.startDate != null && !this.startDate.isEmpty();
        }

        public ResearchSubjectProgressComponent setStartDateElement(DateTimeType value) {
            this.startDate = value;
            return this;
        }

        public Date getStartDate() {
            return this.startDate == null ? null : (Date)this.startDate.getValue();
        }

        public ResearchSubjectProgressComponent setStartDate(Date value) {
            if (value == null) {
                this.startDate = null;
            } else {
                if (this.startDate == null) {
                    this.startDate = new DateTimeType();
                }
                this.startDate.setValue(value);
            }
            return this;
        }

        public DateTimeType getEndDateElement() {
            if (this.endDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.endDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.endDate = new DateTimeType();
                }
            }
            return this.endDate;
        }

        public boolean hasEndDateElement() {
            return this.endDate != null && !this.endDate.isEmpty();
        }

        public boolean hasEndDate() {
            return this.endDate != null && !this.endDate.isEmpty();
        }

        public ResearchSubjectProgressComponent setEndDateElement(DateTimeType value) {
            this.endDate = value;
            return this;
        }

        public Date getEndDate() {
            return this.endDate == null ? null : (Date)this.endDate.getValue();
        }

        public ResearchSubjectProgressComponent setEndDate(Date value) {
            if (value == null) {
                this.endDate = null;
            } else {
                if (this.endDate == null) {
                    this.endDate = new DateTimeType();
                }
                this.endDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Identifies the aspect of the subject's journey that the state refers to.", 0, 1, this.type));
            children.add(new Property("subjectState", "CodeableConcept", "The current state of the subject.", 0, 1, this.subjectState));
            children.add(new Property("milestone", "CodeableConcept", "The milestones the subject has passed through.", 0, 1, this.milestone));
            children.add(new Property("reason", "CodeableConcept", "The reason for the state change.  If coded it should follow the formal subject state model.", 0, 1, this.reason));
            children.add(new Property("startDate", "dateTime", "The date when the new status started.", 0, 1, this.startDate));
            children.add(new Property("endDate", "dateTime", "The date when the state ended.", 0, 1, this.endDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Identifies the aspect of the subject's journey that the state refers to.", 0, 1, this.type);
                }
                case -1520444731: {
                    return new Property("subjectState", "CodeableConcept", "The current state of the subject.", 0, 1, this.subjectState);
                }
                case -1065084560: {
                    return new Property("milestone", "CodeableConcept", "The milestones the subject has passed through.", 0, 1, this.milestone);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "The reason for the state change.  If coded it should follow the formal subject state model.", 0, 1, this.reason);
                }
                case -2129778896: {
                    return new Property("startDate", "dateTime", "The date when the new status started.", 0, 1, this.startDate);
                }
                case -1607727319: {
                    return new Property("endDate", "dateTime", "The date when the state ended.", 0, 1, this.endDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1520444731: {
                    Base[] baseArray;
                    if (this.subjectState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subjectState;
                    }
                    return baseArray;
                }
                case -1065084560: {
                    Base[] baseArray;
                    if (this.milestone == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.milestone;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reason;
                    }
                    return baseArray;
                }
                case -2129778896: {
                    Base[] baseArray;
                    if (this.startDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.startDate;
                    }
                    return baseArray;
                }
                case -1607727319: {
                    Base[] baseArray;
                    if (this.endDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.endDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1520444731: {
                    this.subjectState = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1065084560: {
                    this.milestone = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2129778896: {
                    this.startDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1607727319: {
                    this.endDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("subjectState")) {
                this.subjectState = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("milestone")) {
                this.milestone = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("startDate")) {
                this.startDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("endDate")) {
                this.endDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1520444731: {
                    return this.getSubjectState();
                }
                case -1065084560: {
                    return this.getMilestone();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -2129778896: {
                    return this.getStartDateElement();
                }
                case -1607727319: {
                    return this.getEndDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1520444731: {
                    return new String[]{"CodeableConcept"};
                }
                case -1065084560: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -2129778896: {
                    return new String[]{"dateTime"};
                }
                case -1607727319: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("subjectState")) {
                this.subjectState = new CodeableConcept();
                return this.subjectState;
            }
            if (name.equals("milestone")) {
                this.milestone = new CodeableConcept();
                return this.milestone;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("startDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.progress.startDate");
            }
            if (name.equals("endDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.progress.endDate");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchSubjectProgressComponent copy() {
            ResearchSubjectProgressComponent dst = new ResearchSubjectProgressComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchSubjectProgressComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.subjectState = this.subjectState == null ? null : this.subjectState.copy();
            dst.milestone = this.milestone == null ? null : this.milestone.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.startDate = this.startDate == null ? null : this.startDate.copy();
            dst.endDate = this.endDate == null ? null : this.endDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchSubjectProgressComponent)) {
                return false;
            }
            ResearchSubjectProgressComponent o = (ResearchSubjectProgressComponent)other_;
            return ResearchSubjectProgressComponent.compareDeep(this.type, o.type, true) && ResearchSubjectProgressComponent.compareDeep(this.subjectState, o.subjectState, true) && ResearchSubjectProgressComponent.compareDeep(this.milestone, o.milestone, true) && ResearchSubjectProgressComponent.compareDeep(this.reason, o.reason, true) && ResearchSubjectProgressComponent.compareDeep(this.startDate, o.startDate, true) && ResearchSubjectProgressComponent.compareDeep(this.endDate, o.endDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchSubjectProgressComponent)) {
                return false;
            }
            ResearchSubjectProgressComponent o = (ResearchSubjectProgressComponent)other_;
            return ResearchSubjectProgressComponent.compareValues(this.startDate, o.startDate, true) && ResearchSubjectProgressComponent.compareValues(this.endDate, o.endDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.subjectState, this.milestone, this.reason, this.startDate, this.endDate});
        }

        @Override
        public String fhirType() {
            return "ResearchSubject.progress";
        }
    }
}

