/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class BinaryRenderer {
    private String folder;
    private List<String> filenames = new ArrayList<String>();

    public BinaryRenderer(String folder) {
        this.folder = folder;
    }

    public String getFolder() {
        return this.folder;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public static String getBinContentAsString(Binary bin) {
        return new String(bin.getContent(), StandardCharsets.UTF_8);
    }

    public String display(Binary bin) throws IOException {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        this.render(div, bin);
        return new XhtmlComposer(false, true).compose(div);
    }

    public void render(XhtmlNode x, Binary bin) throws IOException {
        this.filenames.clear();
        if (!bin.hasContentType()) {
            this.error(x, "No Content Type");
        } else if (bin.getContentType().startsWith("image/")) {
            this.image(x, bin);
        } else if (this.isXml(bin.getContentType())) {
            this.xml(x, bin);
        } else if (this.isJson(bin.getContentType())) {
            this.json(x, bin);
        } else if (this.isTtl(bin.getContentType())) {
            this.ttl(x, bin);
        } else if (this.isText(bin.getContentType())) {
            this.text(x, bin);
        } else {
            this.error(x, "The Content Type '" + bin.getContentType() + "' is not rendered in this context");
        }
    }

    private void image(XhtmlNode x, Binary bin) throws IOException {
        String ext = null;
        if (bin.getContentType().startsWith("image/png")) {
            ext = ".png";
        } else if (bin.getContentType().startsWith("image/jpeg")) {
            ext = ".jpg";
        } else if (bin.getContentType().startsWith("image/gif")) {
            ext = ".gif";
        } else if (bin.getContentType().startsWith("image/svg")) {
            ext = ".svg";
        }
        if (ext == null) {
            this.error(x, "The Image Type '" + bin.getContentType() + "' is not rendered in this context");
        } else {
            String fn = "Binary-Native-" + bin.getId() + ext;
            TextFile.bytesToFile((byte[])bin.getContent(), (String)Utilities.path((String[])new String[]{this.folder, fn}));
            this.filenames.add(fn);
            x.img("Binary-Native-" + bin.getId() + ext, "binary");
        }
    }

    private void error(XhtmlNode x, String message) {
        x.tx("[" + message + "]");
    }

    private boolean isXml(String ct) {
        return ct.startsWith("text/xml") || ct.startsWith("application/xml") || ct.contains("+xml");
    }

    private void xml(XhtmlNode x, Binary bin) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(bin);
        XhtmlNode pre = x.pre("xml");
        pre.code(content);
    }

    private boolean isJson(String ct) {
        return ct.startsWith("text/json") || ct.startsWith("application/json") || ct.contains("+json");
    }

    private void json(XhtmlNode x, Binary bin) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(bin);
        XhtmlNode pre = x.pre("json");
        pre.code(content);
    }

    private boolean isTtl(String ct) {
        return ct.startsWith("text/rdf") || ct.contains("+turtle");
    }

    private void ttl(XhtmlNode x, Binary bin) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(bin);
        XhtmlNode pre = x.pre("rdf language-turtle");
        pre.code(content);
    }

    private boolean isText(String ct) {
        return ct.startsWith("text/");
    }

    private void text(XhtmlNode x, Binary bin) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(bin);
        XhtmlNode pre = x.pre();
        pre.code(content);
    }
}

