/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.structuremap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.utils.structuremap.StringPair;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class TargetWriter {
    private Map<String, String> newResources = new HashMap<String, String>();
    private List<StringPair> assignments = new ArrayList<StringPair>();
    private List<StringPair> keyProps = new ArrayList<StringPair>();
    private CommaSeparatedStringBuilder txt = new CommaSeparatedStringBuilder();

    public void newResource(String var, String name) {
        this.newResources.put(var, name);
        this.txt.append("new " + name);
    }

    public void valueAssignment(String context, String desc) {
        this.assignments.add(new StringPair(context, desc));
        this.txt.append(desc);
    }

    public void keyAssignment(String context, String desc) {
        this.keyProps.add(new StringPair(context, desc));
        this.txt.append(desc);
    }

    public void commit(XhtmlNode xt) {
        if (this.newResources.size() == 1 && this.assignments.size() == 1 && this.newResources.containsKey(this.assignments.get(0).getVar()) && this.keyProps.size() == 1 && this.newResources.containsKey(this.keyProps.get(0).getVar())) {
            xt.addText("new " + this.assignments.get(0).getDesc() + " (" + this.keyProps.get(0).getDesc().substring(this.keyProps.get(0).getDesc().indexOf(".") + 1) + ")");
        } else if (this.newResources.size() == 1 && this.assignments.size() == 1 && this.newResources.containsKey(this.assignments.get(0).getVar()) && this.keyProps.size() == 0) {
            xt.addText("new " + this.assignments.get(0).getDesc());
        } else {
            xt.addText(this.txt.toString());
        }
    }
}

