/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;

@ResourceDef(name="Procedure", profile="http://hl7.org/fhir/StructureDefinition/Procedure")
public class Procedure
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Identifiers for this procedure", formalDefinition="Business identifiers assigned to this procedure by the performer or other systems which remain constant as the resource is updated and is propagated from server to server.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={CarePlan.class, ServiceRequest.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A request for this procedure", formalDefinition="A reference to a resource that contains details of the request for this procedure.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={Procedure.class, Observation.class, MedicationAdministration.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular procedure is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", formalDefinition="A code specifying the state of the procedure. Generally, this will be the in-progress or completed state.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<Enumerations.EventStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the procedure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-not-performed-reason")
    protected CodeableConcept statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the procedure", formalDefinition="A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the procedure", formalDefinition="The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Practitioner.class, Organization.class, Location.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual or entity the procedure was performed on", formalDefinition="On whom or on what the procedure was performed. This is usually an individual human, but can also be performed on animals, groups of humans or animals, organizations or practitioners (for licensing), locations or devices (for safety inspections or regulatory authorizations).  If the actual focus of the procedure is different from the subject, the focus element specifies the actual focus of the procedure.")
    protected Reference subject;
    @Child(name="focus", type={Patient.class, Group.class, RelatedPerson.class, Practitioner.class, Organization.class, CareTeam.class, PractitionerRole.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is the target of the procedure when it is not the subject of record only", formalDefinition="Who is the target of the procedure when it is not the subject of record only.  If focus is not present, then subject is the focus.  If focus is present and the subject is one of the targets of the procedure, include subject as a focus as well. If focus is present and the subject is not included in focus, it implies that the procedure was only targeted on the focus. For example, when a caregiver is given education for a patient, the caregiver would be the focus and the procedure record is associated with the subject (e.g. patient).  For example, use focus when recording the target of the education, training, or counseling is the parent or relative of a patient.")
    protected Reference focus;
    @Child(name="encounter", type={Encounter.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Encounter during which this Procedure was created", formalDefinition="The Encounter during which this Procedure was created or performed or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, StringType.class, Age.class, Range.class, Timing.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the procedure occurred or is occurring", formalDefinition="Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.")
    protected DataType occurrence;
    @Child(name="recorded", type={DateTimeType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the procedure was first captured in the subject's record", formalDefinition="The date the occurrence of the procedure was first captured in the record regardless of Procedure.status (potentially after the occurrence of the event).")
    protected DateTimeType recorded;
    @Child(name="recorder", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who recorded the procedure", formalDefinition="Individual who recorded the record and takes responsibility for its content.")
    protected Reference recorder;
    @Child(name="reported", type={BooleanType.class, Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reported rather than primary record", formalDefinition="Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.")
    protected DataType reported;
    @Child(name="performer", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The people who performed the procedure", formalDefinition="Limited to \"real\" people rather than equipment.")
    protected List<ProcedurePerformerComponent> performer;
    @Child(name="location", type={Location.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the procedure happened", formalDefinition="The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.")
    protected Reference location;
    @Child(name="reason", type={CodeableReference.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The justification that the procedure was performed", formalDefinition="The coded reason or reference why the procedure was performed. This may be a coded entity of some type, be present as text, or be a reference to one of several resources that justify the procedure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected List<CodeableReference> reason;
    @Child(name="bodySite", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Target body sites", formalDefinition="Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="outcome", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The result of procedure", formalDefinition="The outcome of the procedure - did it resolve the reasons for the procedure being performed?")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-outcome")
    protected CodeableConcept outcome;
    @Child(name="report", type={DiagnosticReport.class, DocumentReference.class, Composition.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Any report resulting from the procedure", formalDefinition="This could be a histology result, pathology report, surgical report, etc.")
    protected List<Reference> report;
    @Child(name="complication", type={CodeableReference.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Complication following the procedure", formalDefinition="Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableReference> complication;
    @Child(name="followUp", type={CodeableConcept.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instructions for follow up", formalDefinition="If the procedure required specific follow up - e.g. removal of sutures. The follow up may be represented as a simple note or could potentially be more complex, in which case the CarePlan resource can be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-followup")
    protected List<CodeableConcept> followUp;
    @Child(name="note", type={Annotation.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about the procedure", formalDefinition="Any other notes and comments about the procedure.")
    protected List<Annotation> note;
    @Child(name="focalDevice", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Manipulated, implanted, or removed device", formalDefinition="A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.")
    protected List<ProcedureFocalDeviceComponent> focalDevice;
    @Child(name="used", type={CodeableReference.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Items used during procedure", formalDefinition="Identifies medications, devices and any other substance used as part of the procedure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
    protected List<CodeableReference> used;
    @Child(name="supportingInfo", type={Reference.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Extra information relevant to the procedure", formalDefinition="Other resources from the patient record that may be relevant to the procedure.  The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available.")
    protected List<Reference> supportingInfo;
    private static final long serialVersionUID = 372127918L;
    @SearchParamDefinition(name="based-on", path="Procedure.basedOn", description="A request for this procedure", type="reference", target={CarePlan.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Procedure:based-on").toLocked();
    @SearchParamDefinition(name="category", path="Procedure.category", description="Classification of the procedure", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="instantiates-canonical", path="Procedure.instantiatesCanonical", description="Instantiates FHIR protocol or definition", type="reference", target={ActivityDefinition.class, Measure.class, OperationDefinition.class, PlanDefinition.class, Questionnaire.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("Procedure:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="Procedure.instantiatesUri", description="Instantiates external protocol or definition", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="location", path="Procedure.location", description="Where the procedure happened", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Procedure:location").toLocked();
    @SearchParamDefinition(name="part-of", path="Procedure.partOf", description="Part of referenced event", type="reference", target={MedicationAdministration.class, Observation.class, Procedure.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Procedure:part-of").toLocked();
    @SearchParamDefinition(name="performer", path="Procedure.performer.actor", description="Who performed the procedure", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Procedure:performer").toLocked();
    @SearchParamDefinition(name="reason-code", path="Procedure.reason.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="Procedure.reason.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("Procedure:reason-reference").toLocked();
    @SearchParamDefinition(name="report", path="Procedure.report", description="Any report resulting from the procedure", type="reference", target={Composition.class, DiagnosticReport.class, DocumentReference.class})
    public static final String SP_REPORT = "report";
    public static final ReferenceClientParam REPORT = new ReferenceClientParam("report");
    public static final Include INCLUDE_REPORT = new Include("Procedure:report").toLocked();
    @SearchParamDefinition(name="status", path="Procedure.status", description="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Procedure.subject", description="Search by subject", type="reference", target={Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Procedure:subject").toLocked();
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.as(dateTime) | DiagnosticReport.effective.as(Period) | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective.as(dateTime) | Observation.effective.as(Period) | Observation.effective.as(Timing) | Observation.effective.as(instant) | Procedure.occurrence.as(dateTime) | Procedure.occurrence.as(Period) | Procedure.occurrence.as(Timing) | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Procedure:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Procedure:patient").toLocked();

    public Procedure() {
    }

    public Procedure(Enumerations.EventStatus status, Reference subject) {
        this.setStatus(status);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Procedure setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Procedure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public Procedure setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public Procedure addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public Procedure setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public Procedure addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Procedure setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Procedure addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Procedure setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Procedure addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<Enumerations.EventStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Procedure setStatusElement(Enumeration<Enumerations.EventStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.EventStatus getStatus() {
        return this.status == null ? null : (Enumerations.EventStatus)((Object)this.status.getValue());
    }

    public Procedure setStatus(Enumerations.EventStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Procedure setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Procedure setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Procedure addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Procedure setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Procedure setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getFocus() {
        if (this.focus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.focus");
            }
            if (Configuration.doAutoCreate()) {
                this.focus = new Reference();
            }
        }
        return this.focus;
    }

    public boolean hasFocus() {
        return this.focus != null && !this.focus.isEmpty();
    }

    public Procedure setFocus(Reference value) {
        this.focus = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Procedure setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public StringType getOccurrenceStringType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new StringType();
        }
        if (!(this.occurrence instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (StringType)this.occurrence;
    }

    public boolean hasOccurrenceStringType() {
        return this != null && this.occurrence instanceof StringType;
    }

    public Age getOccurrenceAge() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Age();
        }
        if (!(this.occurrence instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Age)this.occurrence;
    }

    public boolean hasOccurrenceAge() {
        return this != null && this.occurrence instanceof Age;
    }

    public Range getOccurrenceRange() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Range();
        }
        if (!(this.occurrence instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Range)this.occurrence;
    }

    public boolean hasOccurrenceRange() {
        return this != null && this.occurrence instanceof Range;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Timing();
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public Procedure setOccurrence(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof StringType || value instanceof Age || value instanceof Range || value instanceof Timing)) {
            throw new Error("Not the right type for Procedure.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new DateTimeType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public Procedure setRecordedElement(DateTimeType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public Procedure setRecorded(Date value) {
        if (value == null) {
            this.recorded = null;
        } else {
            if (this.recorded == null) {
                this.recorded = new DateTimeType();
            }
            this.recorded.setValue(value);
        }
        return this;
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public Procedure setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public DataType getReported() {
        return this.reported;
    }

    public BooleanType getReportedBooleanType() throws FHIRException {
        if (this.reported == null) {
            this.reported = new BooleanType();
        }
        if (!(this.reported instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.reported.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.reported;
    }

    public boolean hasReportedBooleanType() {
        return this != null && this.reported instanceof BooleanType;
    }

    public Reference getReportedReference() throws FHIRException {
        if (this.reported == null) {
            this.reported = new Reference();
        }
        if (!(this.reported instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reported.getClass().getName() + " was encountered");
        }
        return (Reference)this.reported;
    }

    public boolean hasReportedReference() {
        return this != null && this.reported instanceof Reference;
    }

    public boolean hasReported() {
        return this.reported != null && !this.reported.isEmpty();
    }

    public Procedure setReported(DataType value) {
        if (value != null && !(value instanceof BooleanType) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Procedure.reported[x]: " + value.fhirType());
        }
        this.reported = value;
        return this;
    }

    public List<ProcedurePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        return this.performer;
    }

    public Procedure setPerformer(List<ProcedurePerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ProcedurePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedurePerformerComponent addPerformer() {
        ProcedurePerformerComponent t = new ProcedurePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public Procedure addPerformer(ProcedurePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public ProcedurePerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Procedure setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public Procedure setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public Procedure addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public Procedure setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public Procedure addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public Procedure setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public List<Reference> getReport() {
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        return this.report;
    }

    public Procedure setReport(List<Reference> theReport) {
        this.report = theReport;
        return this;
    }

    public boolean hasReport() {
        if (this.report == null) {
            return false;
        }
        for (Reference item : this.report) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReport() {
        Reference t = new Reference();
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        this.report.add(t);
        return t;
    }

    public Procedure addReport(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        this.report.add(t);
        return this;
    }

    public Reference getReportFirstRep() {
        if (this.getReport().isEmpty()) {
            this.addReport();
        }
        return this.getReport().get(0);
    }

    public List<CodeableReference> getComplication() {
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableReference>();
        }
        return this.complication;
    }

    public Procedure setComplication(List<CodeableReference> theComplication) {
        this.complication = theComplication;
        return this;
    }

    public boolean hasComplication() {
        if (this.complication == null) {
            return false;
        }
        for (CodeableReference item : this.complication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addComplication() {
        CodeableReference t = new CodeableReference();
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableReference>();
        }
        this.complication.add(t);
        return t;
    }

    public Procedure addComplication(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableReference>();
        }
        this.complication.add(t);
        return this;
    }

    public CodeableReference getComplicationFirstRep() {
        if (this.getComplication().isEmpty()) {
            this.addComplication();
        }
        return this.getComplication().get(0);
    }

    public List<CodeableConcept> getFollowUp() {
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        return this.followUp;
    }

    public Procedure setFollowUp(List<CodeableConcept> theFollowUp) {
        this.followUp = theFollowUp;
        return this;
    }

    public boolean hasFollowUp() {
        if (this.followUp == null) {
            return false;
        }
        for (CodeableConcept item : this.followUp) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFollowUp() {
        CodeableConcept t = new CodeableConcept();
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        this.followUp.add(t);
        return t;
    }

    public Procedure addFollowUp(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        this.followUp.add(t);
        return this;
    }

    public CodeableConcept getFollowUpFirstRep() {
        if (this.getFollowUp().isEmpty()) {
            this.addFollowUp();
        }
        return this.getFollowUp().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Procedure setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Procedure addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<ProcedureFocalDeviceComponent> getFocalDevice() {
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        return this.focalDevice;
    }

    public Procedure setFocalDevice(List<ProcedureFocalDeviceComponent> theFocalDevice) {
        this.focalDevice = theFocalDevice;
        return this;
    }

    public boolean hasFocalDevice() {
        if (this.focalDevice == null) {
            return false;
        }
        for (ProcedureFocalDeviceComponent item : this.focalDevice) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureFocalDeviceComponent addFocalDevice() {
        ProcedureFocalDeviceComponent t = new ProcedureFocalDeviceComponent();
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        this.focalDevice.add(t);
        return t;
    }

    public Procedure addFocalDevice(ProcedureFocalDeviceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        this.focalDevice.add(t);
        return this;
    }

    public ProcedureFocalDeviceComponent getFocalDeviceFirstRep() {
        if (this.getFocalDevice().isEmpty()) {
            this.addFocalDevice();
        }
        return this.getFocalDevice().get(0);
    }

    public List<CodeableReference> getUsed() {
        if (this.used == null) {
            this.used = new ArrayList<CodeableReference>();
        }
        return this.used;
    }

    public Procedure setUsed(List<CodeableReference> theUsed) {
        this.used = theUsed;
        return this;
    }

    public boolean hasUsed() {
        if (this.used == null) {
            return false;
        }
        for (CodeableReference item : this.used) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addUsed() {
        CodeableReference t = new CodeableReference();
        if (this.used == null) {
            this.used = new ArrayList<CodeableReference>();
        }
        this.used.add(t);
        return t;
    }

    public Procedure addUsed(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.used == null) {
            this.used = new ArrayList<CodeableReference>();
        }
        this.used.add(t);
        return this;
    }

    public CodeableReference getUsedFirstRep() {
        if (this.getUsed().isEmpty()) {
            this.addUsed();
        }
        return this.getUsed().get(0);
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public Procedure setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public Procedure addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this procedure by the performer or other systems which remain constant as the resource is updated and is propagated from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition|ActivityDefinition|Measure|OperationDefinition|Questionnaire)", "The URL pointing to a FHIR-defined protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(CarePlan|ServiceRequest)", "A reference to a resource that contains details of the request for this procedure.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(Procedure|Observation|MedicationAdministration)", "A larger event of which this particular procedure is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the state of the procedure. Generally, this will be the in-progress or completed state.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the procedure.", 0, 1, this.statusReason));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Practitioner|Organization|Location)", "On whom or on what the procedure was performed. This is usually an individual human, but can also be performed on animals, groups of humans or animals, organizations or practitioners (for licensing), locations or devices (for safety inspections or regulatory authorizations).  If the actual focus of the procedure is different from the subject, the focus element specifies the actual focus of the procedure.", 0, 1, this.subject));
        children.add(new Property("focus", "Reference(Patient|Group|RelatedPerson|Practitioner|Organization|CareTeam|PractitionerRole)", "Who is the target of the procedure when it is not the subject of record only.  If focus is not present, then subject is the focus.  If focus is present and the subject is one of the targets of the procedure, include subject as a focus as well. If focus is present and the subject is not included in focus, it implies that the procedure was only targeted on the focus. For example, when a caregiver is given education for a patient, the caregiver would be the focus and the procedure record is associated with the subject (e.g. patient).  For example, use focus when recording the target of the education, training, or counseling is the parent or relative of a patient.", 0, 1, this.focus));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this Procedure was created or performed or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|Period|string|Age|Range|Timing", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence));
        children.add(new Property("recorded", "dateTime", "The date the occurrence of the procedure was first captured in the record regardless of Procedure.status (potentially after the occurrence of the event).", 0, 1, this.recorded));
        children.add(new Property("recorder", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole)", "Individual who recorded the record and takes responsibility for its content.", 0, 1, this.recorder));
        children.add(new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported));
        children.add(new Property(SP_PERFORMER, "", "Limited to \"real\" people rather than equipment.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.", 0, 1, this.location));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|Procedure|DiagnosticReport|DocumentReference)", "The coded reason or reference why the procedure was performed. This may be a coded entity of some type, be present as text, or be a reference to one of several resources that justify the procedure.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("bodySite", "CodeableConcept", "Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property("outcome", "CodeableConcept", "The outcome of the procedure - did it resolve the reasons for the procedure being performed?", 0, 1, this.outcome));
        children.add(new Property(SP_REPORT, "Reference(DiagnosticReport|DocumentReference|Composition)", "This could be a histology result, pathology report, surgical report, etc.", 0, Integer.MAX_VALUE, this.report));
        children.add(new Property("complication", "CodeableReference(Condition)", "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.", 0, Integer.MAX_VALUE, this.complication));
        children.add(new Property("followUp", "CodeableConcept", "If the procedure required specific follow up - e.g. removal of sutures. The follow up may be represented as a simple note or could potentially be more complex, in which case the CarePlan resource can be used.", 0, Integer.MAX_VALUE, this.followUp));
        children.add(new Property("note", "Annotation", "Any other notes and comments about the procedure.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("focalDevice", "", "A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.", 0, Integer.MAX_VALUE, this.focalDevice));
        children.add(new Property("used", "CodeableReference(Device|Medication|Substance|BiologicallyDerivedProduct)", "Identifies medications, devices and any other substance used as part of the procedure.", 0, Integer.MAX_VALUE, this.used));
        children.add(new Property("supportingInfo", "Reference(Any)", "Other resources from the patient record that may be relevant to the procedure.  The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available.", 0, Integer.MAX_VALUE, this.supportingInfo));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this procedure by the performer or other systems which remain constant as the resource is updated and is propagated from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(PlanDefinition|ActivityDefinition|Measure|OperationDefinition|Questionnaire)", "The URL pointing to a FHIR-defined protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ServiceRequest)", "A reference to a resource that contains details of the request for this procedure.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Procedure|Observation|MedicationAdministration)", "A larger event of which this particular procedure is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the state of the procedure. Generally, this will be the in-progress or completed state.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the procedure.", 0, 1, this.statusReason);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Practitioner|Organization|Location)", "On whom or on what the procedure was performed. This is usually an individual human, but can also be performed on animals, groups of humans or animals, organizations or practitioners (for licensing), locations or devices (for safety inspections or regulatory authorizations).  If the actual focus of the procedure is different from the subject, the focus element specifies the actual focus of the procedure.", 0, 1, this.subject);
            }
            case 97604824: {
                return new Property("focus", "Reference(Patient|Group|RelatedPerson|Practitioner|Organization|CareTeam|PractitionerRole)", "Who is the target of the procedure when it is not the subject of record only.  If focus is not present, then subject is the focus.  If focus is present and the subject is one of the targets of the procedure, include subject as a focus as well. If focus is present and the subject is not included in focus, it implies that the procedure was only targeted on the focus. For example, when a caregiver is given education for a patient, the caregiver would be the focus and the procedure record is associated with the subject (e.g. patient).  For example, use focus when recording the target of the education, training, or counseling is the parent or relative of a patient.", 0, 1, this.focus);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this Procedure was created or performed or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|string|Age|Range|Timing", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|string|Age|Range|Timing", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case 1496896834: {
                return new Property("occurrence[x]", "string", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case -2022672018: {
                return new Property("occurrence[x]", "Age", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case 1847908844: {
                return new Property("occurrence[x]", "Range", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "Timing", "Estimated or actual date, date-time, period, or age when the procedure did occur or is occurring.  Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.occurrence);
            }
            case -799233872: {
                return new Property("recorded", "dateTime", "The date the occurrence of the procedure was first captured in the record regardless of Procedure.status (potentially after the occurrence of the event).", 0, 1, this.recorded);
            }
            case -799233858: {
                return new Property("recorder", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole)", "Individual who recorded the record and takes responsibility for its content.", 0, 1, this.recorder);
            }
            case -241505587: {
                return new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
            }
            case -427039533: {
                return new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
            }
            case 1219992533: {
                return new Property("reported[x]", "boolean", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
            }
            case 1198143416: {
                return new Property("reported[x]", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Limited to \"real\" people rather than equipment.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.", 0, 1, this.location);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|Procedure|DiagnosticReport|DocumentReference)", "The coded reason or reference why the procedure was performed. This may be a coded entity of some type, be present as text, or be a reference to one of several resources that justify the procedure.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableConcept", "The outcome of the procedure - did it resolve the reasons for the procedure being performed?", 0, 1, this.outcome);
            }
            case -934521548: {
                return new Property(SP_REPORT, "Reference(DiagnosticReport|DocumentReference|Composition)", "This could be a histology result, pathology report, surgical report, etc.", 0, Integer.MAX_VALUE, this.report);
            }
            case -1644401602: {
                return new Property("complication", "CodeableReference(Condition)", "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.", 0, Integer.MAX_VALUE, this.complication);
            }
            case 301801004: {
                return new Property("followUp", "CodeableConcept", "If the procedure required specific follow up - e.g. removal of sutures. The follow up may be represented as a simple note or could potentially be more complex, in which case the CarePlan resource can be used.", 0, Integer.MAX_VALUE, this.followUp);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Any other notes and comments about the procedure.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1129235173: {
                return new Property("focalDevice", "", "A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.", 0, Integer.MAX_VALUE, this.focalDevice);
            }
            case 3599293: {
                return new Property("used", "CodeableReference(Device|Medication|Substance|BiologicallyDerivedProduct)", "Identifies medications, devices and any other substance used as part of the procedure.", 0, Integer.MAX_VALUE, this.used);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Other resources from the patient record that may be relevant to the procedure.  The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statusReason;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 97604824: {
                Base[] baseArray;
                if (this.focus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.focus;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.occurrence;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.recorded;
                }
                return baseArray;
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.recorder;
                }
                return baseArray;
            }
            case -427039533: {
                Base[] baseArray;
                if (this.reported == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.reported;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.location;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.outcome;
                }
                return baseArray;
            }
            case -934521548: {
                return this.report == null ? new Base[]{} : this.report.toArray(new Base[this.report.size()]);
            }
            case -1644401602: {
                return this.complication == null ? new Base[]{} : this.complication.toArray(new Base[this.complication.size()]);
            }
            case 301801004: {
                return this.followUp == null ? new Base[]{} : this.followUp.toArray(new Base[this.followUp.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1129235173: {
                return this.focalDevice == null ? new Base[]{} : this.focalDevice.toArray(new Base[this.focalDevice.size()]);
            }
            case 3599293: {
                return this.used == null ? new Base[]{} : this.used.toArray(new Base[this.used.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.EventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 97604824: {
                this.focus = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -799233858: {
                this.recorder = TypeConvertor.castToReference(value);
                return value;
            }
            case -427039533: {
                this.reported = TypeConvertor.castToType(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((ProcedurePerformerComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1106507950: {
                this.outcome = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -934521548: {
                this.getReport().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1644401602: {
                this.getComplication().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 301801004: {
                this.getFollowUp().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1129235173: {
                this.getFocalDevice().add((ProcedureFocalDeviceComponent)((Object)value));
                return value;
            }
            case 3599293: {
                this.getUsed().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.EventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("focus")) {
            this.focus = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("recorded")) {
            this.recorded = TypeConvertor.castToDateTime(value);
        } else if (name.equals("recorder")) {
            this.recorder = TypeConvertor.castToReference(value);
        } else if (name.equals("reported[x]")) {
            this.reported = TypeConvertor.castToType(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((ProcedurePerformerComponent)((Object)value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("outcome")) {
            this.outcome = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_REPORT)) {
            this.getReport().add(TypeConvertor.castToReference(value));
        } else if (name.equals("complication")) {
            this.getComplication().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("followUp")) {
            this.getFollowUp().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("focalDevice")) {
            this.getFocalDevice().add((ProcedureFocalDeviceComponent)((Object)value));
        } else if (name.equals("used")) {
            this.getUsed().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 97604824: {
                return this.getFocus();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case -241505587: {
                return this.getReported();
            }
            case -427039533: {
                return this.getReported();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case -934521548: {
                return this.addReport();
            }
            case -1644401602: {
                return this.addComplication();
            }
            case 301801004: {
                return this.addFollowUp();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1129235173: {
                return this.addFocalDevice();
            }
            case 3599293: {
                return this.addUsed();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "string", "Age", "Range", "Timing"};
            }
            case -799233872: {
                return new String[]{"dateTime"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case -427039533: {
                return new String[]{"boolean", "Reference"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case -934521548: {
                return new String[]{"Reference"};
            }
            case -1644401602: {
                return new String[]{"CodeableReference"};
            }
            case 301801004: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1129235173: {
                return new String[0];
            }
            case 3599293: {
                return new String[]{"CodeableReference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type Procedure.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type Procedure.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Procedure.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("focus")) {
            this.focus = new Reference();
            return this.focus;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceString")) {
            this.occurrence = new StringType();
            return this.occurrence;
        }
        if (name.equals("occurrenceAge")) {
            this.occurrence = new Age();
            return this.occurrence;
        }
        if (name.equals("occurrenceRange")) {
            this.occurrence = new Range();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a primitive type Procedure.recorded");
        }
        if (name.equals("recorder")) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals("reportedBoolean")) {
            this.reported = new BooleanType();
            return this.reported;
        }
        if (name.equals("reportedReference")) {
            this.reported = new Reference();
            return this.reported;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("outcome")) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals(SP_REPORT)) {
            return this.addReport();
        }
        if (name.equals("complication")) {
            return this.addComplication();
        }
        if (name.equals("followUp")) {
            return this.addFollowUp();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("focalDevice")) {
            return this.addFocalDevice();
        }
        if (name.equals("used")) {
            return this.addUsed();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Procedure";
    }

    @Override
    public Procedure copy() {
        Procedure dst = new Procedure();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Procedure dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.focus = this.focus == null ? null : this.focus.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.recorded = this.recorded == null ? null : this.recorded.copy();
        dst.recorder = this.recorder == null ? null : this.recorder.copy();
        DataType dataType = dst.reported = this.reported == null ? null : this.reported.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ProcedurePerformerComponent>();
            for (ProcedurePerformerComponent procedurePerformerComponent : this.performer) {
                dst.performer.add(procedurePerformerComponent.copy());
            }
        }
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.bodySite) {
                dst.bodySite.add(codeableConcept3.copy());
            }
        }
        CodeableConcept codeableConcept4 = dst.outcome = this.outcome == null ? null : this.outcome.copy();
        if (this.report != null) {
            dst.report = new ArrayList<Reference>();
            for (Reference reference2 : this.report) {
                dst.report.add(reference2.copy());
            }
        }
        if (this.complication != null) {
            dst.complication = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.complication) {
                dst.complication.add(codeableReference.copy());
            }
        }
        if (this.followUp != null) {
            dst.followUp = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept5 : this.followUp) {
                dst.followUp.add(codeableConcept5.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.focalDevice != null) {
            dst.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
            for (ProcedureFocalDeviceComponent procedureFocalDeviceComponent : this.focalDevice) {
                dst.focalDevice.add(procedureFocalDeviceComponent.copy());
            }
        }
        if (this.used != null) {
            dst.used = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.used) {
                dst.used.add(codeableReference.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference3 : this.supportingInfo) {
                dst.supportingInfo.add(reference3.copy());
            }
        }
    }

    protected Procedure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Procedure)) {
            return false;
        }
        Procedure o = (Procedure)other_;
        return Procedure.compareDeep(this.identifier, o.identifier, true) && Procedure.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && Procedure.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && Procedure.compareDeep(this.basedOn, o.basedOn, true) && Procedure.compareDeep(this.partOf, o.partOf, true) && Procedure.compareDeep(this.status, o.status, true) && Procedure.compareDeep(this.statusReason, o.statusReason, true) && Procedure.compareDeep(this.category, o.category, true) && Procedure.compareDeep(this.code, o.code, true) && Procedure.compareDeep(this.subject, o.subject, true) && Procedure.compareDeep(this.focus, o.focus, true) && Procedure.compareDeep(this.encounter, o.encounter, true) && Procedure.compareDeep(this.occurrence, o.occurrence, true) && Procedure.compareDeep(this.recorded, o.recorded, true) && Procedure.compareDeep(this.recorder, o.recorder, true) && Procedure.compareDeep(this.reported, o.reported, true) && Procedure.compareDeep(this.performer, o.performer, true) && Procedure.compareDeep(this.location, o.location, true) && Procedure.compareDeep(this.reason, o.reason, true) && Procedure.compareDeep(this.bodySite, o.bodySite, true) && Procedure.compareDeep(this.outcome, o.outcome, true) && Procedure.compareDeep(this.report, o.report, true) && Procedure.compareDeep(this.complication, o.complication, true) && Procedure.compareDeep(this.followUp, o.followUp, true) && Procedure.compareDeep(this.note, o.note, true) && Procedure.compareDeep(this.focalDevice, o.focalDevice, true) && Procedure.compareDeep(this.used, o.used, true) && Procedure.compareDeep(this.supportingInfo, o.supportingInfo, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Procedure)) {
            return false;
        }
        Procedure o = (Procedure)other_;
        return Procedure.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && Procedure.compareValues(this.instantiatesUri, o.instantiatesUri, true) && Procedure.compareValues(this.status, o.status, true) && Procedure.compareValues(this.recorded, o.recorded, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.partOf, this.status, this.statusReason, this.category, this.code, this.subject, this.focus, this.encounter, this.occurrence, this.recorded, this.recorder, this.reported, this.performer, this.location, this.reason, this.bodySite, this.outcome, this.report, this.complication, this.followUp, this.note, this.focalDevice, this.used, this.supportingInfo});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Procedure;
    }

    @Block
    public static class ProcedureFocalDeviceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of change to device", formalDefinition="The kind of change that happened to the device during the procedure.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-action")
        protected CodeableConcept action;
        @Child(name="manipulated", type={Device.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device that was changed", formalDefinition="The device that was manipulated (changed) during the procedure.")
        protected Reference manipulated;
        private static final long serialVersionUID = -217582010L;

        public ProcedureFocalDeviceComponent() {
        }

        public ProcedureFocalDeviceComponent(Reference manipulated) {
            this.setManipulated(manipulated);
        }

        public CodeableConcept getAction() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new CodeableConcept();
                }
            }
            return this.action;
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public ProcedureFocalDeviceComponent setAction(CodeableConcept value) {
            this.action = value;
            return this;
        }

        public Reference getManipulated() {
            if (this.manipulated == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.manipulated");
                }
                if (Configuration.doAutoCreate()) {
                    this.manipulated = new Reference();
                }
            }
            return this.manipulated;
        }

        public boolean hasManipulated() {
            return this.manipulated != null && !this.manipulated.isEmpty();
        }

        public ProcedureFocalDeviceComponent setManipulated(Reference value) {
            this.manipulated = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "CodeableConcept", "The kind of change that happened to the device during the procedure.", 0, 1, this.action));
            children.add(new Property("manipulated", "Reference(Device)", "The device that was manipulated (changed) during the procedure.", 0, 1, this.manipulated));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "CodeableConcept", "The kind of change that happened to the device during the procedure.", 0, 1, this.action);
                }
                case 947372650: {
                    return new Property("manipulated", "Reference(Device)", "The device that was manipulated (changed) during the procedure.", 0, 1, this.manipulated);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    Base[] baseArray;
                    if (this.action == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.action;
                    }
                    return baseArray;
                }
                case 947372650: {
                    Base[] baseArray;
                    if (this.manipulated == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.manipulated;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.action = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 947372650: {
                    this.manipulated = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("manipulated")) {
                this.manipulated = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.getAction();
                }
                case 947372650: {
                    return this.getManipulated();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case 947372650: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                this.action = new CodeableConcept();
                return this.action;
            }
            if (name.equals("manipulated")) {
                this.manipulated = new Reference();
                return this.manipulated;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureFocalDeviceComponent copy() {
            ProcedureFocalDeviceComponent dst = new ProcedureFocalDeviceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProcedureFocalDeviceComponent dst) {
            super.copyValues(dst);
            dst.action = this.action == null ? null : this.action.copy();
            dst.manipulated = this.manipulated == null ? null : this.manipulated.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureFocalDeviceComponent)) {
                return false;
            }
            ProcedureFocalDeviceComponent o = (ProcedureFocalDeviceComponent)other_;
            return ProcedureFocalDeviceComponent.compareDeep(this.action, o.action, true) && ProcedureFocalDeviceComponent.compareDeep(this.manipulated, o.manipulated, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureFocalDeviceComponent)) {
                return false;
            }
            ProcedureFocalDeviceComponent o = (ProcedureFocalDeviceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.action, this.manipulated});
        }

        @Override
        public String fhirType() {
            return "Procedure.focalDevice";
        }
    }

    @Block
    public static class ProcedurePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of performance", formalDefinition="Distinguishes the type of involvement of the performer in the procedure. For example, surgeon, anaesthetist, endoscopist.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, RelatedPerson.class, Device.class, CareTeam.class, HealthcareService.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the procedure", formalDefinition="Indicates who or what performed the procedure.")
        protected Reference actor;
        @Child(name="onBehalfOf", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization the device or practitioner was acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the performer performed the procedure", formalDefinition="Time period during which the performer performed the procedure.")
        protected Period period;
        private static final long serialVersionUID = -1329650986L;

        public ProcedurePerformerComponent() {
        }

        public ProcedurePerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ProcedurePerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ProcedurePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public ProcedurePerformerComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ProcedurePerformerComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the procedure. For example, surgeon, anaesthetist, endoscopist.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device|CareTeam|HealthcareService)", "Indicates who or what performed the procedure.", 0, 1, this.actor));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf));
            children.add(new Property("period", "Period", "Time period during which the performer performed the procedure.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the procedure. For example, surgeon, anaesthetist, endoscopist.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device|CareTeam|HealthcareService)", "Indicates who or what performed the procedure.", 0, 1, this.actor);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf);
                }
                case -991726143: {
                    return new Property("period", "Period", "Time period during which the performer performed the procedure.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = TypeConvertor.castToReference(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = TypeConvertor.castToReference(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedurePerformerComponent copy() {
            ProcedurePerformerComponent dst = new ProcedurePerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProcedurePerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedurePerformerComponent)) {
                return false;
            }
            ProcedurePerformerComponent o = (ProcedurePerformerComponent)other_;
            return ProcedurePerformerComponent.compareDeep(this.function, o.function, true) && ProcedurePerformerComponent.compareDeep(this.actor, o.actor, true) && ProcedurePerformerComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true) && ProcedurePerformerComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedurePerformerComponent)) {
                return false;
            }
            ProcedurePerformerComponent o = (ProcedurePerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor, this.onBehalfOf, this.period});
        }

        @Override
        public String fhirType() {
            return "Procedure.performer";
        }
    }
}

