/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationRequest", profile="http://hl7.org/fhir/StructureDefinition/MedicationRequest")
public class MedicationRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External ids for this request", formalDefinition="Identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, MedicationRequest.class, ServiceRequest.class, ImmunizationRecommendation.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A plan or request that is fulfilled in whole or in part by this medication request", formalDefinition="A plan or request that is fulfilled in whole or in part by this medication request.")
    protected List<Reference> basedOn;
    @Child(name="priorPrescription", type={MedicationRequest.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to an order/prescription that is being replaced by this MedicationRequest", formalDefinition="Reference to an order/prescription that is being replaced by this MedicationRequest.")
    protected Reference priorPrescription;
    @Child(name="groupIdentifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | on-hold | ended | stopped | completed | cancelled | entered-in-error | draft | unknown", formalDefinition="A code specifying the current state of the order.  Generally, this will be active or completed state.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-status")
    protected Enumeration<MedicationrequestStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the MedicationRequest.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-status-reason")
    protected CodeableConcept statusReason;
    @Child(name="statusChanged", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the status was changed", formalDefinition="The date (and perhaps time) when the status was changed.")
    protected DateTimeType statusChanged;
    @Child(name="intent", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Whether the request is a proposal, plan, or an original order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-intent")
    protected Enumeration<MedicationRequestIntent> intent;
    @Child(name="category", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Grouping or category of medication request", formalDefinition="An arbitrary categorization or grouping of the medication request.  It could be used for indicating where meds are intended to be administered, eg. in an inpatient setting or in a patient's home, or a legal category of the medication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-admin-location")
    protected List<CodeableConcept> category;
    @Child(name="priority", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the Medication Request should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<Enumerations.RequestPriority> priority;
    @Child(name="doNotPerform", type={BooleanType.class}, order=10, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if patient is to stop taking or not to start taking the medication", formalDefinition="If true, indicates that the provider is asking for the patient to either stop taking or to not start taking the specified medication. For example, the patient is taking an existing medication and the provider is changing their medication. They want to create two seperate requests: one to stop using the current medication and another to start the new medication.")
    protected BooleanType doNotPerform;
    @Child(name="medication", type={CodeableReference.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication to be taken", formalDefinition="Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableReference medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual or group for whom the medication has been requested", formalDefinition="The individual or group for whom the medication has been requested.")
    protected Reference subject;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Organization.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The person or organization who provided the information about this request, if the source is someone other than the requestor", formalDefinition="The person or organization who provided the information about this request, if the source is someone other than the requestor.  This is often used when the MedicationRequest is reported by another person.")
    protected List<Reference> informationSource;
    @Child(name="encounter", type={Encounter.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter created as part of encounter/admission/stay", formalDefinition="The Encounter during which this [x] was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="supportingInformation", type={Reference.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information to support fulfilling of the medication", formalDefinition="Information to support fulfilling (i.e. dispensing or administering) of the medication, for example, patient height and weight, a MedicationStatement for the patient).")
    protected List<Reference> supportingInformation;
    @Child(name="authoredOn", type={DateTimeType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When request was initially authored", formalDefinition="The date (and perhaps time) when the prescription was initially written or authored on.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What requested the Request", formalDefinition="The individual, organization, or device that initiated the request and has responsibility for its activation.")
    protected Reference requester;
    @Child(name="reported", type={BooleanType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reported rather than primary record", formalDefinition="Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.")
    protected BooleanType reported;
    @Child(name="performerType", type={CodeableConcept.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Desired kind of performer of the medication administration", formalDefinition="Indicates the type of performer of the administration of the medication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-intended-performer-role")
    protected CodeableConcept performerType;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, DeviceDefinition.class, RelatedPerson.class, CareTeam.class, HealthcareService.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Intended performer of administration", formalDefinition="The specified desired performer of the medication treatment (e.g. the performer of the medication administration).  For devices, this is the device that is intended to perform the administration of the medication.  An IV Pump would be an example of a device that is performing the administration.  Both the IV Pump and the practitioner that set the rate or bolus on the pump can be listed as performers.")
    protected List<Reference> performer;
    @Child(name="device", type={CodeableReference.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Intended type of device for the administration", formalDefinition="The intended type of device that is to be used for the administration of the medication (for example, PCA Pump).")
    protected List<CodeableReference> device;
    @Child(name="recorder", type={Practitioner.class, PractitionerRole.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Person who entered the request", formalDefinition="The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.")
    protected Reference recorder;
    @Child(name="reason", type={CodeableReference.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason or indication for ordering or not ordering the medication", formalDefinition="The reason or the indication for ordering or not ordering the medication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableReference> reason;
    @Child(name="courseOfTherapyType", type={CodeableConcept.class}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Overall pattern of medication administration", formalDefinition="The description of the overall pattern of the administration of the medication to the patient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-course-of-therapy")
    protected CodeableConcept courseOfTherapyType;
    @Child(name="insurance", type={Coverage.class, ClaimResponse.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated insurance coverage", formalDefinition="Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.")
    protected List<Reference> insurance;
    @Child(name="note", type={Annotation.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the prescription", formalDefinition="Extra information about the prescription that could not be conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="renderedDosageInstruction", type={MarkdownType.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Full representation of the dosage instructions", formalDefinition="The full representation of the dose of the medication included in all dosage instructions.  To be used when multiple dosage instructions are included to represent complex dosing such as increasing or tapering doses.")
    protected MarkdownType renderedDosageInstruction;
    @Child(name="effectiveDosePeriod", type={Period.class}, order=28, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period over which the medication is to be taken", formalDefinition="The period over which the medication is to be taken.  Where there are multiple dosageInstruction lines (for example, tapering doses), this is the earliest date and the latest end date of the dosageInstructions.")
    protected Period effectiveDosePeriod;
    @Child(name="dosageInstruction", type={Dosage.class}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specific instructions for how the medication should be taken", formalDefinition="Specific instructions for how the medication is to be used by the patient.")
    protected List<Dosage> dosageInstruction;
    @Child(name="dispenseRequest", type={}, order=30, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Medication supply authorization", formalDefinition="Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order).  Note that this information is not always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.")
    protected MedicationRequestDispenseRequestComponent dispenseRequest;
    @Child(name="substitution", type={}, order=31, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any restrictions on medication substitution", formalDefinition="Indicates whether or not substitution can or should be part of the dispense. In some cases, substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.")
    protected MedicationRequestSubstitutionComponent substitution;
    @Child(name="eventHistory", type={Provenance.class}, order=32, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.")
    protected List<Reference> eventHistory;
    private static final long serialVersionUID = 1013423544L;
    @SearchParamDefinition(name="authoredon", path="MedicationRequest.authoredOn", description="Return prescriptions written on this date", type="date")
    public static final String SP_AUTHOREDON = "authoredon";
    public static final DateClientParam AUTHOREDON = new DateClientParam("authoredon");
    @SearchParamDefinition(name="category", path="MedicationRequest.category", description="Returns prescriptions with different categories", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="combo-date", path="MedicationRequest.dosageInstruction.timing.event | (MedicationRequest.dosageInstruction.timing.repeat.bounds.ofType(Period))", description="Returns medication request to be administered on a specific date or within a date range", type="date")
    public static final String SP_COMBO_DATE = "combo-date";
    public static final DateClientParam COMBO_DATE = new DateClientParam("combo-date");
    @SearchParamDefinition(name="group-identifier", path="MedicationRequest.groupIdentifier", description="Composite request this is part of", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="intended-dispenser", path="MedicationRequest.dispenseRequest.dispenser", description="Returns prescriptions intended to be dispensed by this Organization", type="reference", target={Organization.class})
    public static final String SP_INTENDED_DISPENSER = "intended-dispenser";
    public static final ReferenceClientParam INTENDED_DISPENSER = new ReferenceClientParam("intended-dispenser");
    public static final Include INCLUDE_INTENDED_DISPENSER = new Include("MedicationRequest:intended-dispenser").toLocked();
    @SearchParamDefinition(name="intended-performer", path="MedicationRequest.performer", description="Returns the intended performer of the administration of the medication request", type="reference", target={CareTeam.class, DeviceDefinition.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_INTENDED_PERFORMER = "intended-performer";
    public static final ReferenceClientParam INTENDED_PERFORMER = new ReferenceClientParam("intended-performer");
    public static final Include INCLUDE_INTENDED_PERFORMER = new Include("MedicationRequest:intended-performer").toLocked();
    @SearchParamDefinition(name="intended-performertype", path="MedicationRequest.performerType", description="Returns requests for a specific type of performer", type="token")
    public static final String SP_INTENDED_PERFORMERTYPE = "intended-performertype";
    public static final TokenClientParam INTENDED_PERFORMERTYPE = new TokenClientParam("intended-performertype");
    @SearchParamDefinition(name="intent", path="MedicationRequest.intent", description="Returns prescriptions with different intents", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="priority", path="MedicationRequest.priority", description="Returns prescriptions with different priorities", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="requester", path="MedicationRequest.requester", description="Returns prescriptions prescribed by this prescriber", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("MedicationRequest:requester").toLocked();
    @SearchParamDefinition(name="subject", path="MedicationRequest.subject", description="The identity of a patient to list orders  for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationRequest:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationRequest:patient").toLocked();
    @SearchParamDefinition(name="encounter", path="MedicationAdministration.encounter | MedicationRequest.encounter", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations that share this encounter\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationRequest:encounter").toLocked();
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medication.reference | MedicationDispense.medication.reference | MedicationRequest.medication.reference | MedicationStatement.medication.reference", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication reference\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine resource\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions for this medication reference\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication reference\r\n", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationRequest:medication").toLocked();
    @SearchParamDefinition(name="status", path="MedicationAdministration.status | MedicationDispense.status | MedicationRequest.status | MedicationStatement.status", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): MedicationAdministration event status (for example one of active/paused/completed/nullified)\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specified dispense status\r\n* [MedicationRequest](medicationrequest.html): Status of the prescription\r\n* [MedicationStatement](medicationstatement.html): Return statements that match the given status\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationRequest() {
    }

    public MedicationRequest(MedicationrequestStatus status, MedicationRequestIntent intent, CodeableReference medication, Reference subject) {
        this.setStatus(status);
        this.setIntent(intent);
        this.setMedication(medication);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public MedicationRequest setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public MedicationRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getPriorPrescription() {
        if (this.priorPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.priorPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.priorPrescription = new Reference();
            }
        }
        return this.priorPrescription;
    }

    public boolean hasPriorPrescription() {
        return this.priorPrescription != null && !this.priorPrescription.isEmpty();
    }

    public MedicationRequest setPriorPrescription(Reference value) {
        this.priorPrescription = value;
        return this;
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public MedicationRequest setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<MedicationrequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationrequestStatus>(new MedicationrequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationRequest setStatusElement(Enumeration<MedicationrequestStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationrequestStatus getStatus() {
        return this.status == null ? null : (MedicationrequestStatus)((Object)this.status.getValue());
    }

    public MedicationRequest setStatus(MedicationrequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationrequestStatus>(new MedicationrequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public MedicationRequest setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public DateTimeType getStatusChangedElement() {
        if (this.statusChanged == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.statusChanged");
            }
            if (Configuration.doAutoCreate()) {
                this.statusChanged = new DateTimeType();
            }
        }
        return this.statusChanged;
    }

    public boolean hasStatusChangedElement() {
        return this.statusChanged != null && !this.statusChanged.isEmpty();
    }

    public boolean hasStatusChanged() {
        return this.statusChanged != null && !this.statusChanged.isEmpty();
    }

    public MedicationRequest setStatusChangedElement(DateTimeType value) {
        this.statusChanged = value;
        return this;
    }

    public Date getStatusChanged() {
        return this.statusChanged == null ? null : (Date)this.statusChanged.getValue();
    }

    public MedicationRequest setStatusChanged(Date value) {
        if (value == null) {
            this.statusChanged = null;
        } else {
            if (this.statusChanged == null) {
                this.statusChanged = new DateTimeType();
            }
            this.statusChanged.setValue(value);
        }
        return this;
    }

    public Enumeration<MedicationRequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<MedicationRequestIntent>(new MedicationRequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public MedicationRequest setIntentElement(Enumeration<MedicationRequestIntent> value) {
        this.intent = value;
        return this;
    }

    public MedicationRequestIntent getIntent() {
        return this.intent == null ? null : (MedicationRequestIntent)((Object)this.intent.getValue());
    }

    public MedicationRequest setIntent(MedicationRequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<MedicationRequestIntent>(new MedicationRequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public MedicationRequest setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public MedicationRequest addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public MedicationRequest setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public Enumerations.RequestPriority getPriority() {
        return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
    }

    public MedicationRequest setPriority(Enumerations.RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getDoNotPerformElement() {
        if (this.doNotPerform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.doNotPerform");
            }
            if (Configuration.doAutoCreate()) {
                this.doNotPerform = new BooleanType();
            }
        }
        return this.doNotPerform;
    }

    public boolean hasDoNotPerformElement() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public boolean hasDoNotPerform() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public MedicationRequest setDoNotPerformElement(BooleanType value) {
        this.doNotPerform = value;
        return this;
    }

    public boolean getDoNotPerform() {
        return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
    }

    public MedicationRequest setDoNotPerform(boolean value) {
        if (this.doNotPerform == null) {
            this.doNotPerform = new BooleanType();
        }
        this.doNotPerform.setValue((Object)value);
        return this;
    }

    public CodeableReference getMedication() {
        if (this.medication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.medication");
            }
            if (Configuration.doAutoCreate()) {
                this.medication = new CodeableReference();
            }
        }
        return this.medication;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationRequest setMedication(CodeableReference value) {
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<Reference> getInformationSource() {
        if (this.informationSource == null) {
            this.informationSource = new ArrayList<Reference>();
        }
        return this.informationSource;
    }

    public MedicationRequest setInformationSource(List<Reference> theInformationSource) {
        this.informationSource = theInformationSource;
        return this;
    }

    public boolean hasInformationSource() {
        if (this.informationSource == null) {
            return false;
        }
        for (Reference item : this.informationSource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInformationSource() {
        Reference t = new Reference();
        if (this.informationSource == null) {
            this.informationSource = new ArrayList<Reference>();
        }
        this.informationSource.add(t);
        return t;
    }

    public MedicationRequest addInformationSource(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.informationSource == null) {
            this.informationSource = new ArrayList<Reference>();
        }
        this.informationSource.add(t);
        return this;
    }

    public Reference getInformationSourceFirstRep() {
        if (this.getInformationSource().isEmpty()) {
            this.addInformationSource();
        }
        return this.getInformationSource().get(0);
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public MedicationRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public MedicationRequest setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationRequest addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public MedicationRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public MedicationRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public MedicationRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public BooleanType getReportedElement() {
        if (this.reported == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.reported");
            }
            if (Configuration.doAutoCreate()) {
                this.reported = new BooleanType();
            }
        }
        return this.reported;
    }

    public boolean hasReportedElement() {
        return this.reported != null && !this.reported.isEmpty();
    }

    public boolean hasReported() {
        return this.reported != null && !this.reported.isEmpty();
    }

    public MedicationRequest setReportedElement(BooleanType value) {
        this.reported = value;
        return this;
    }

    public boolean getReported() {
        return this.reported == null || this.reported.isEmpty() ? false : (Boolean)this.reported.getValue();
    }

    public MedicationRequest setReported(boolean value) {
        if (this.reported == null) {
            this.reported = new BooleanType();
        }
        this.reported.setValue((Object)value);
        return this;
    }

    public CodeableConcept getPerformerType() {
        if (this.performerType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.performerType");
            }
            if (Configuration.doAutoCreate()) {
                this.performerType = new CodeableConcept();
            }
        }
        return this.performerType;
    }

    public boolean hasPerformerType() {
        return this.performerType != null && !this.performerType.isEmpty();
    }

    public MedicationRequest setPerformerType(CodeableConcept value) {
        this.performerType = value;
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public MedicationRequest setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public MedicationRequest addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<CodeableReference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<CodeableReference>();
        }
        return this.device;
    }

    public MedicationRequest setDevice(List<CodeableReference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (CodeableReference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addDevice() {
        CodeableReference t = new CodeableReference();
        if (this.device == null) {
            this.device = new ArrayList<CodeableReference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicationRequest addDevice(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<CodeableReference>();
        }
        this.device.add(t);
        return this;
    }

    public CodeableReference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public MedicationRequest setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public MedicationRequest setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public MedicationRequest addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableConcept getCourseOfTherapyType() {
        if (this.courseOfTherapyType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.courseOfTherapyType");
            }
            if (Configuration.doAutoCreate()) {
                this.courseOfTherapyType = new CodeableConcept();
            }
        }
        return this.courseOfTherapyType;
    }

    public boolean hasCourseOfTherapyType() {
        return this.courseOfTherapyType != null && !this.courseOfTherapyType.isEmpty();
    }

    public MedicationRequest setCourseOfTherapyType(CodeableConcept value) {
        this.courseOfTherapyType = value;
        return this;
    }

    public List<Reference> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        return this.insurance;
    }

    public MedicationRequest setInsurance(List<Reference> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (Reference item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInsurance() {
        Reference t = new Reference();
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return t;
    }

    public MedicationRequest addInsurance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return this;
    }

    public Reference getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationRequest setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationRequest addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public MarkdownType getRenderedDosageInstructionElement() {
        if (this.renderedDosageInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.renderedDosageInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.renderedDosageInstruction = new MarkdownType();
            }
        }
        return this.renderedDosageInstruction;
    }

    public boolean hasRenderedDosageInstructionElement() {
        return this.renderedDosageInstruction != null && !this.renderedDosageInstruction.isEmpty();
    }

    public boolean hasRenderedDosageInstruction() {
        return this.renderedDosageInstruction != null && !this.renderedDosageInstruction.isEmpty();
    }

    public MedicationRequest setRenderedDosageInstructionElement(MarkdownType value) {
        this.renderedDosageInstruction = value;
        return this;
    }

    public String getRenderedDosageInstruction() {
        return this.renderedDosageInstruction == null ? null : (String)this.renderedDosageInstruction.getValue();
    }

    public MedicationRequest setRenderedDosageInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.renderedDosageInstruction = null;
        } else {
            if (this.renderedDosageInstruction == null) {
                this.renderedDosageInstruction = new MarkdownType();
            }
            this.renderedDosageInstruction.setValue(value);
        }
        return this;
    }

    public Period getEffectiveDosePeriod() {
        if (this.effectiveDosePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.effectiveDosePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectiveDosePeriod = new Period();
            }
        }
        return this.effectiveDosePeriod;
    }

    public boolean hasEffectiveDosePeriod() {
        return this.effectiveDosePeriod != null && !this.effectiveDosePeriod.isEmpty();
    }

    public MedicationRequest setEffectiveDosePeriod(Period value) {
        this.effectiveDosePeriod = value;
        return this;
    }

    public List<Dosage> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        return this.dosageInstruction;
    }

    public MedicationRequest setDosageInstruction(List<Dosage> theDosageInstruction) {
        this.dosageInstruction = theDosageInstruction;
        return this;
    }

    public boolean hasDosageInstruction() {
        if (this.dosageInstruction == null) {
            return false;
        }
        for (Dosage item : this.dosageInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosageInstruction() {
        Dosage t = new Dosage();
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        this.dosageInstruction.add(t);
        return t;
    }

    public MedicationRequest addDosageInstruction(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<Dosage>();
        }
        this.dosageInstruction.add(t);
        return this;
    }

    public Dosage getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            this.addDosageInstruction();
        }
        return this.getDosageInstruction().get(0);
    }

    public MedicationRequestDispenseRequestComponent getDispenseRequest() {
        if (this.dispenseRequest == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.dispenseRequest");
            }
            if (Configuration.doAutoCreate()) {
                this.dispenseRequest = new MedicationRequestDispenseRequestComponent();
            }
        }
        return this.dispenseRequest;
    }

    public boolean hasDispenseRequest() {
        return this.dispenseRequest != null && !this.dispenseRequest.isEmpty();
    }

    public MedicationRequest setDispenseRequest(MedicationRequestDispenseRequestComponent value) {
        this.dispenseRequest = value;
        return this;
    }

    public MedicationRequestSubstitutionComponent getSubstitution() {
        if (this.substitution == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationRequest.substitution");
            }
            if (Configuration.doAutoCreate()) {
                this.substitution = new MedicationRequestSubstitutionComponent();
            }
        }
        return this.substitution;
    }

    public boolean hasSubstitution() {
        return this.substitution != null && !this.substitution.isEmpty();
    }

    public MedicationRequest setSubstitution(MedicationRequestSubstitutionComponent value) {
        this.substitution = value;
        return this;
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public MedicationRequest setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public MedicationRequest addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan|MedicationRequest|ServiceRequest|ImmunizationRecommendation)", "A plan or request that is fulfilled in whole or in part by this medication request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("priorPrescription", "Reference(MedicationRequest)", "Reference to an order/prescription that is being replaced by this MedicationRequest.", 0, 1, this.priorPrescription));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.", 0, 1, this.groupIdentifier));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the current state of the order.  Generally, this will be active or completed state.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the MedicationRequest.", 0, 1, this.statusReason));
        children.add(new Property("statusChanged", "dateTime", "The date (and perhaps time) when the status was changed.", 0, 1, this.statusChanged));
        children.add(new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, or an original order.", 0, 1, this.intent));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "An arbitrary categorization or grouping of the medication request.  It could be used for indicating where meds are intended to be administered, eg. in an inpatient setting or in a patient's home, or a legal category of the medication.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Medication Request should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("doNotPerform", "boolean", "If true, indicates that the provider is asking for the patient to either stop taking or to not start taking the specified medication. For example, the patient is taking an existing medication and the provider is changing their medication. They want to create two seperate requests: one to stop using the current medication and another to start the new medication.", 0, 1, this.doNotPerform));
        children.add(new Property(SP_MEDICATION, "CodeableReference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or group for whom the medication has been requested.", 0, 1, this.subject));
        children.add(new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "The person or organization who provided the information about this request, if the source is someone other than the requestor.  This is often used when the MedicationRequest is reported by another person.", 0, Integer.MAX_VALUE, this.informationSource));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this [x] was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("supportingInformation", "Reference(Any)", "Information to support fulfilling (i.e. dispensing or administering) of the medication, for example, patient height and weight, a MedicationStatement for the patient).", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("authoredOn", "dateTime", "The date (and perhaps time) when the prescription was initially written or authored on.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device)", "The individual, organization, or device that initiated the request and has responsibility for its activation.", 0, 1, this.requester));
        children.add(new Property("reported", "boolean", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported));
        children.add(new Property("performerType", "CodeableConcept", "Indicates the type of performer of the administration of the medication.", 0, 1, this.performerType));
        children.add(new Property("performer", "Reference(Practitioner|PractitionerRole|Organization|Patient|DeviceDefinition|RelatedPerson|CareTeam|HealthcareService)", "The specified desired performer of the medication treatment (e.g. the performer of the medication administration).  For devices, this is the device that is intended to perform the administration of the medication.  An IV Pump would be an example of a device that is performing the administration.  Both the IV Pump and the practitioner that set the rate or bolus on the pump can be listed as performers.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("device", "CodeableReference(DeviceDefinition)", "The intended type of device that is to be used for the administration of the medication (for example, PCA Pump).", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("recorder", "Reference(Practitioner|PractitionerRole)", "The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.", 0, 1, this.recorder));
        children.add(new Property("reason", "CodeableReference(Condition|Observation)", "The reason or the indication for ordering or not ordering the medication.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("courseOfTherapyType", "CodeableConcept", "The description of the overall pattern of the administration of the medication to the patient.", 0, 1, this.courseOfTherapyType));
        children.add(new Property("insurance", "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("note", "Annotation", "Extra information about the prescription that could not be conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("renderedDosageInstruction", "markdown", "The full representation of the dose of the medication included in all dosage instructions.  To be used when multiple dosage instructions are included to represent complex dosing such as increasing or tapering doses.", 0, 1, this.renderedDosageInstruction));
        children.add(new Property("effectiveDosePeriod", "Period", "The period over which the medication is to be taken.  Where there are multiple dosageInstruction lines (for example, tapering doses), this is the earliest date and the latest end date of the dosageInstructions.", 0, 1, this.effectiveDosePeriod));
        children.add(new Property("dosageInstruction", "Dosage", "Specific instructions for how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction));
        children.add(new Property("dispenseRequest", "", "Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order).  Note that this information is not always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.", 0, 1, this.dispenseRequest));
        children.add(new Property("substitution", "", "Indicates whether or not substitution can or should be part of the dispense. In some cases, substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.", 0, 1, this.substitution));
        children.add(new Property("eventHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|MedicationRequest|ServiceRequest|ImmunizationRecommendation)", "A plan or request that is fulfilled in whole or in part by this medication request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -486355964: {
                return new Property("priorPrescription", "Reference(MedicationRequest)", "Reference to an order/prescription that is being replaced by this MedicationRequest.", 0, 1, this.priorPrescription);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the current state of the order.  Generally, this will be active or completed state.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the MedicationRequest.", 0, 1, this.statusReason);
            }
            case -1174686110: {
                return new Property("statusChanged", "dateTime", "The date (and perhaps time) when the status was changed.", 0, 1, this.statusChanged);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, or an original order.", 0, 1, this.intent);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "An arbitrary categorization or grouping of the medication request.  It could be used for indicating where meds are intended to be administered, eg. in an inpatient setting or in a patient's home, or a legal category of the medication.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Medication Request should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case -1788508167: {
                return new Property("doNotPerform", "boolean", "If true, indicates that the provider is asking for the patient to either stop taking or to not start taking the specified medication. For example, the patient is taking an existing medication and the provider is changing their medication. They want to create two seperate requests: one to stop using the current medication and another to start the new medication.", 0, 1, this.doNotPerform);
            }
            case 1998965455: {
                return new Property(SP_MEDICATION, "CodeableReference(Medication)", "Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or group for whom the medication has been requested.", 0, 1, this.subject);
            }
            case -2123220889: {
                return new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "The person or organization who provided the information about this request, if the source is someone other than the requestor.  This is often used when the MedicationRequest is reported by another person.", 0, Integer.MAX_VALUE, this.informationSource);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this [x] was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Information to support fulfilling (i.e. dispensing or administering) of the medication, for example, patient height and weight, a MedicationStatement for the patient).", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "The date (and perhaps time) when the prescription was initially written or authored on.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device)", "The individual, organization, or device that initiated the request and has responsibility for its activation.", 0, 1, this.requester);
            }
            case -427039533: {
                return new Property("reported", "boolean", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
            }
            case -901444568: {
                return new Property("performerType", "CodeableConcept", "Indicates the type of performer of the administration of the medication.", 0, 1, this.performerType);
            }
            case 481140686: {
                return new Property("performer", "Reference(Practitioner|PractitionerRole|Organization|Patient|DeviceDefinition|RelatedPerson|CareTeam|HealthcareService)", "The specified desired performer of the medication treatment (e.g. the performer of the medication administration).  For devices, this is the device that is intended to perform the administration of the medication.  An IV Pump would be an example of a device that is performing the administration.  Both the IV Pump and the practitioner that set the rate or bolus on the pump can be listed as performers.", 0, Integer.MAX_VALUE, this.performer);
            }
            case -1335157162: {
                return new Property("device", "CodeableReference(DeviceDefinition)", "The intended type of device that is to be used for the administration of the medication (for example, PCA Pump).", 0, Integer.MAX_VALUE, this.device);
            }
            case -799233858: {
                return new Property("recorder", "Reference(Practitioner|PractitionerRole)", "The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.", 0, 1, this.recorder);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation)", "The reason or the indication for ordering or not ordering the medication.", 0, Integer.MAX_VALUE, this.reason);
            }
            case -447282031: {
                return new Property("courseOfTherapyType", "CodeableConcept", "The description of the overall pattern of the administration of the medication to the patient.", 0, 1, this.courseOfTherapyType);
            }
            case 73049818: {
                return new Property("insurance", "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the prescription that could not be conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1718902050: {
                return new Property("renderedDosageInstruction", "markdown", "The full representation of the dose of the medication included in all dosage instructions.  To be used when multiple dosage instructions are included to represent complex dosing such as increasing or tapering doses.", 0, 1, this.renderedDosageInstruction);
            }
            case 322608453: {
                return new Property("effectiveDosePeriod", "Period", "The period over which the medication is to be taken.  Where there are multiple dosageInstruction lines (for example, tapering doses), this is the earliest date and the latest end date of the dosageInstructions.", 0, 1, this.effectiveDosePeriod);
            }
            case -1201373865: {
                return new Property("dosageInstruction", "Dosage", "Specific instructions for how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction);
            }
            case 824620658: {
                return new Property("dispenseRequest", "", "Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order).  Note that this information is not always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.", 0, 1, this.dispenseRequest);
            }
            case 826147581: {
                return new Property("substitution", "", "Indicates whether or not substitution can or should be part of the dispense. In some cases, substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.", 0, 1, this.substitution);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -486355964: {
                Base[] baseArray;
                if (this.priorPrescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.priorPrescription;
                }
                return baseArray;
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.statusReason;
                }
                return baseArray;
            }
            case -1174686110: {
                Base[] baseArray;
                if (this.statusChanged == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.statusChanged;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.intent;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.priority;
                }
                return baseArray;
            }
            case -1788508167: {
                Base[] baseArray;
                if (this.doNotPerform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.doNotPerform;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.subject;
                }
                return baseArray;
            }
            case -2123220889: {
                return this.informationSource == null ? new Base[]{} : this.informationSource.toArray(new Base[this.informationSource.size()]);
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.encounter;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.requester;
                }
                return baseArray;
            }
            case -427039533: {
                Base[] baseArray;
                if (this.reported == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.reported;
                }
                return baseArray;
            }
            case -901444568: {
                Base[] baseArray;
                if (this.performerType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.performerType;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.recorder;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -447282031: {
                Base[] baseArray;
                if (this.courseOfTherapyType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.courseOfTherapyType;
                }
                return baseArray;
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1718902050: {
                Base[] baseArray;
                if (this.renderedDosageInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.renderedDosageInstruction;
                }
                return baseArray;
            }
            case 322608453: {
                Base[] baseArray;
                if (this.effectiveDosePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.effectiveDosePeriod;
                }
                return baseArray;
            }
            case -1201373865: {
                return this.dosageInstruction == null ? new Base[]{} : this.dosageInstruction.toArray(new Base[this.dosageInstruction.size()]);
            }
            case 824620658: {
                Base[] baseArray;
                if (this.dispenseRequest == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.dispenseRequest;
                }
                return baseArray;
            }
            case 826147581: {
                Base[] baseArray;
                if (this.substitution == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.substitution;
                }
                return baseArray;
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -486355964: {
                this.priorPrescription = TypeConvertor.castToReference(value);
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new MedicationrequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1174686110: {
                this.statusChanged = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1183762788: {
                value = new MedicationRequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1165461084: {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1788508167: {
                this.doNotPerform = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 1998965455: {
                this.medication = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -2123220889: {
                this.getInformationSource().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = TypeConvertor.castToReference(value);
                return value;
            }
            case -427039533: {
                this.reported = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -901444568: {
                this.performerType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1335157162: {
                this.getDevice().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -799233858: {
                this.recorder = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -447282031: {
                this.courseOfTherapyType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 73049818: {
                this.getInsurance().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1718902050: {
                this.renderedDosageInstruction = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 322608453: {
                this.effectiveDosePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1201373865: {
                this.getDosageInstruction().add(TypeConvertor.castToDosage(value));
                return value;
            }
            case 824620658: {
                this.dispenseRequest = (MedicationRequestDispenseRequestComponent)((Object)value);
                return value;
            }
            case 826147581: {
                this.substitution = (MedicationRequestSubstitutionComponent)((Object)value);
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("priorPrescription")) {
            this.priorPrescription = TypeConvertor.castToReference(value);
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationrequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusChanged")) {
            this.statusChanged = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_INTENT)) {
            value = new MedicationRequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_PRIORITY)) {
            value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.priority = value;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_MEDICATION)) {
            this.medication = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("informationSource")) {
            this.getInformationSource().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = TypeConvertor.castToReference(value);
        } else if (name.equals("reported")) {
            this.reported = TypeConvertor.castToBoolean(value);
        } else if (name.equals("performerType")) {
            this.performerType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("performer")) {
            this.getPerformer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("device")) {
            this.getDevice().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("recorder")) {
            this.recorder = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("courseOfTherapyType")) {
            this.courseOfTherapyType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("insurance")) {
            this.getInsurance().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("renderedDosageInstruction")) {
            this.renderedDosageInstruction = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("effectiveDosePeriod")) {
            this.effectiveDosePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("dosageInstruction")) {
            this.getDosageInstruction().add(TypeConvertor.castToDosage(value));
        } else if (name.equals("dispenseRequest")) {
            this.dispenseRequest = (MedicationRequestDispenseRequestComponent)((Object)value);
        } else if (name.equals("substitution")) {
            this.substitution = (MedicationRequestSubstitutionComponent)((Object)value);
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -486355964: {
                return this.getPriorPrescription();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case -1174686110: {
                return this.getStatusChangedElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1788508167: {
                return this.getDoNotPerformElement();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -2123220889: {
                return this.addInformationSource();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -427039533: {
                return this.getReportedElement();
            }
            case -901444568: {
                return this.getPerformerType();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case -934964668: {
                return this.addReason();
            }
            case -447282031: {
                return this.getCourseOfTherapyType();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1718902050: {
                return this.getRenderedDosageInstructionElement();
            }
            case 322608453: {
                return this.getEffectiveDosePeriod();
            }
            case -1201373865: {
                return this.addDosageInstruction();
            }
            case 824620658: {
                return this.getDispenseRequest();
            }
            case 826147581: {
                return this.getSubstitution();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -486355964: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case -1174686110: {
                return new String[]{"dateTime"};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case -1788508167: {
                return new String[]{"boolean"};
            }
            case 1998965455: {
                return new String[]{"CodeableReference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -2123220889: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[]{"Reference"};
            }
            case -427039533: {
                return new String[]{"boolean"};
            }
            case -901444568: {
                return new String[]{"CodeableConcept"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"CodeableReference"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case -447282031: {
                return new String[]{"CodeableConcept"};
            }
            case 73049818: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1718902050: {
                return new String[]{"markdown"};
            }
            case 322608453: {
                return new String[]{"Period"};
            }
            case -1201373865: {
                return new String[]{"Dosage"};
            }
            case 824620658: {
                return new String[0];
            }
            case 826147581: {
                return new String[0];
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("priorPrescription")) {
            this.priorPrescription = new Reference();
            return this.priorPrescription;
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("statusChanged")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.statusChanged");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.intent");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.priority");
        }
        if (name.equals("doNotPerform")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.doNotPerform");
        }
        if (name.equals(SP_MEDICATION)) {
            this.medication = new CodeableReference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("informationSource")) {
            return this.addInformationSource();
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals("reported")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.reported");
        }
        if (name.equals("performerType")) {
            this.performerType = new CodeableConcept();
            return this.performerType;
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals("device")) {
            return this.addDevice();
        }
        if (name.equals("recorder")) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("courseOfTherapyType")) {
            this.courseOfTherapyType = new CodeableConcept();
            return this.courseOfTherapyType;
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("renderedDosageInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.renderedDosageInstruction");
        }
        if (name.equals("effectiveDosePeriod")) {
            this.effectiveDosePeriod = new Period();
            return this.effectiveDosePeriod;
        }
        if (name.equals("dosageInstruction")) {
            return this.addDosageInstruction();
        }
        if (name.equals("dispenseRequest")) {
            this.dispenseRequest = new MedicationRequestDispenseRequestComponent();
            return this.dispenseRequest;
        }
        if (name.equals("substitution")) {
            this.substitution = new MedicationRequestSubstitutionComponent();
            return this.substitution;
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationRequest";
    }

    @Override
    public MedicationRequest copy() {
        MedicationRequest dst = new MedicationRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationRequest dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.priorPrescription = this.priorPrescription == null ? null : this.priorPrescription.copy();
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.statusChanged = this.statusChanged == null ? null : this.statusChanged.copy();
        Enumeration<MedicationRequestIntent> enumeration = dst.intent = this.intent == null ? null : this.intent.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.informationSource != null) {
            dst.informationSource = new ArrayList<Reference>();
            for (Reference reference2 : this.informationSource) {
                dst.informationSource.add(reference2.copy());
            }
        }
        Reference reference3 = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference4 : this.supportingInformation) {
                dst.supportingInformation.add(reference4.copy());
            }
        }
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        dst.reported = this.reported == null ? null : this.reported.copy();
        CodeableConcept codeableConcept = dst.performerType = this.performerType == null ? null : this.performerType.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference5 : this.performer) {
                dst.performer.add(reference5.copy());
            }
        }
        if (this.device != null) {
            dst.device = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.device) {
                dst.device.add(codeableReference.copy());
            }
        }
        Reference reference6 = dst.recorder = this.recorder == null ? null : this.recorder.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        CodeableConcept codeableConcept2 = dst.courseOfTherapyType = this.courseOfTherapyType == null ? null : this.courseOfTherapyType.copy();
        if (this.insurance != null) {
            dst.insurance = new ArrayList<Reference>();
            for (Reference reference7 : this.insurance) {
                dst.insurance.add(reference7.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.renderedDosageInstruction = this.renderedDosageInstruction == null ? null : this.renderedDosageInstruction.copy();
        Period period = dst.effectiveDosePeriod = this.effectiveDosePeriod == null ? null : this.effectiveDosePeriod.copy();
        if (this.dosageInstruction != null) {
            dst.dosageInstruction = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosageInstruction) {
                dst.dosageInstruction.add(dosage.copy());
            }
        }
        dst.dispenseRequest = this.dispenseRequest == null ? null : this.dispenseRequest.copy();
        MedicationRequestSubstitutionComponent medicationRequestSubstitutionComponent = dst.substitution = this.substitution == null ? null : this.substitution.copy();
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference8 : this.eventHistory) {
                dst.eventHistory.add(reference8.copy());
            }
        }
    }

    protected MedicationRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationRequest)) {
            return false;
        }
        MedicationRequest o = (MedicationRequest)other_;
        return MedicationRequest.compareDeep(this.identifier, o.identifier, true) && MedicationRequest.compareDeep(this.basedOn, o.basedOn, true) && MedicationRequest.compareDeep(this.priorPrescription, o.priorPrescription, true) && MedicationRequest.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && MedicationRequest.compareDeep(this.status, o.status, true) && MedicationRequest.compareDeep(this.statusReason, o.statusReason, true) && MedicationRequest.compareDeep(this.statusChanged, o.statusChanged, true) && MedicationRequest.compareDeep(this.intent, o.intent, true) && MedicationRequest.compareDeep(this.category, o.category, true) && MedicationRequest.compareDeep(this.priority, o.priority, true) && MedicationRequest.compareDeep(this.doNotPerform, o.doNotPerform, true) && MedicationRequest.compareDeep(this.medication, o.medication, true) && MedicationRequest.compareDeep(this.subject, o.subject, true) && MedicationRequest.compareDeep(this.informationSource, o.informationSource, true) && MedicationRequest.compareDeep(this.encounter, o.encounter, true) && MedicationRequest.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationRequest.compareDeep(this.authoredOn, o.authoredOn, true) && MedicationRequest.compareDeep(this.requester, o.requester, true) && MedicationRequest.compareDeep(this.reported, o.reported, true) && MedicationRequest.compareDeep(this.performerType, o.performerType, true) && MedicationRequest.compareDeep(this.performer, o.performer, true) && MedicationRequest.compareDeep(this.device, o.device, true) && MedicationRequest.compareDeep(this.recorder, o.recorder, true) && MedicationRequest.compareDeep(this.reason, o.reason, true) && MedicationRequest.compareDeep(this.courseOfTherapyType, o.courseOfTherapyType, true) && MedicationRequest.compareDeep(this.insurance, o.insurance, true) && MedicationRequest.compareDeep(this.note, o.note, true) && MedicationRequest.compareDeep(this.renderedDosageInstruction, o.renderedDosageInstruction, true) && MedicationRequest.compareDeep(this.effectiveDosePeriod, o.effectiveDosePeriod, true) && MedicationRequest.compareDeep(this.dosageInstruction, o.dosageInstruction, true) && MedicationRequest.compareDeep(this.dispenseRequest, o.dispenseRequest, true) && MedicationRequest.compareDeep(this.substitution, o.substitution, true) && MedicationRequest.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationRequest)) {
            return false;
        }
        MedicationRequest o = (MedicationRequest)other_;
        return MedicationRequest.compareValues(this.status, o.status, true) && MedicationRequest.compareValues(this.statusChanged, o.statusChanged, true) && MedicationRequest.compareValues(this.intent, o.intent, true) && MedicationRequest.compareValues(this.priority, o.priority, true) && MedicationRequest.compareValues(this.doNotPerform, o.doNotPerform, true) && MedicationRequest.compareValues(this.authoredOn, o.authoredOn, true) && MedicationRequest.compareValues(this.reported, o.reported, true) && MedicationRequest.compareValues(this.renderedDosageInstruction, o.renderedDosageInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.priorPrescription, this.groupIdentifier, this.status, this.statusReason, this.statusChanged, this.intent, this.category, this.priority, this.doNotPerform, this.medication, this.subject, this.informationSource, this.encounter, this.supportingInformation, this.authoredOn, this.requester, this.reported, this.performerType, this.performer, this.device, this.recorder, this.reason, this.courseOfTherapyType, this.insurance, this.note, this.renderedDosageInstruction, this.effectiveDosePeriod, this.dosageInstruction, this.dispenseRequest, this.substitution, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationRequest;
    }

    @Block
    public static class MedicationRequestSubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="allowed", type={BooleanType.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether substitution is allowed or not", formalDefinition="True if the prescriber allows a different drug to be dispensed from what was prescribed.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode")
        protected DataType allowed;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why should (not) substitution be made", formalDefinition="Indicates the reason for the substitution, or why substitution must or must not be performed.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason")
        protected CodeableConcept reason;
        private static final long serialVersionUID = -855005751L;

        public MedicationRequestSubstitutionComponent() {
        }

        public MedicationRequestSubstitutionComponent(DataType allowed) {
            this.setAllowed(allowed);
        }

        public DataType getAllowed() {
            return this.allowed;
        }

        public BooleanType getAllowedBooleanType() throws FHIRException {
            if (this.allowed == null) {
                this.allowed = new BooleanType();
            }
            if (!(this.allowed instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.allowed;
        }

        public boolean hasAllowedBooleanType() {
            return this != null && this.allowed instanceof BooleanType;
        }

        public CodeableConcept getAllowedCodeableConcept() throws FHIRException {
            if (this.allowed == null) {
                this.allowed = new CodeableConcept();
            }
            if (!(this.allowed instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.allowed;
        }

        public boolean hasAllowedCodeableConcept() {
            return this != null && this.allowed instanceof CodeableConcept;
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public MedicationRequestSubstitutionComponent setAllowed(DataType value) {
            if (value != null && !(value instanceof BooleanType) && !(value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for MedicationRequest.substitution.allowed[x]: " + value.fhirType());
            }
            this.allowed = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestSubstitutionComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public MedicationRequestSubstitutionComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("allowed[x]", "boolean|CodeableConcept", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed));
            children.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution, or why substitution must or must not be performed.", 0, 1, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1336663592: {
                    return new Property("allowed[x]", "boolean|CodeableConcept", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed);
                }
                case -911343192: {
                    return new Property("allowed[x]", "boolean|CodeableConcept", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed);
                }
                case 177755488: {
                    return new Property("allowed[x]", "boolean", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed);
                }
                case 963125465: {
                    return new Property("allowed[x]", "CodeableConcept", "True if the prescriber allows a different drug to be dispensed from what was prescribed.", 0, 1, this.allowed);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Indicates the reason for the substitution, or why substitution must or must not be performed.", 0, 1, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.allowed;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    this.allowed = TypeConvertor.castToType(value);
                    return value;
                }
                case -934964668: {
                    this.reason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("allowed[x]")) {
                this.allowed = TypeConvertor.castToType(value);
            } else if (name.equals("reason")) {
                this.reason = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1336663592: {
                    return this.getAllowed();
                }
                case -911343192: {
                    return this.getAllowed();
                }
                case -934964668: {
                    return this.getReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -911343192: {
                    return new String[]{"boolean", "CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("allowedBoolean")) {
                this.allowed = new BooleanType();
                return this.allowed;
            }
            if (name.equals("allowedCodeableConcept")) {
                this.allowed = new CodeableConcept();
                return this.allowed;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationRequestSubstitutionComponent copy() {
            MedicationRequestSubstitutionComponent dst = new MedicationRequestSubstitutionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationRequestSubstitutionComponent dst) {
            super.copyValues(dst);
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestSubstitutionComponent)) {
                return false;
            }
            MedicationRequestSubstitutionComponent o = (MedicationRequestSubstitutionComponent)other_;
            return MedicationRequestSubstitutionComponent.compareDeep(this.allowed, o.allowed, true) && MedicationRequestSubstitutionComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestSubstitutionComponent)) {
                return false;
            }
            MedicationRequestSubstitutionComponent o = (MedicationRequestSubstitutionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.allowed, this.reason});
        }

        @Override
        public String fhirType() {
            return "MedicationRequest.substitution";
        }
    }

    @Block
    public static class MedicationRequestDispenseRequestInitialFillComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="First fill quantity", formalDefinition="The amount or quantity to provide as part of the first dispense.")
        protected Quantity quantity;
        @Child(name="duration", type={Duration.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="First fill duration", formalDefinition="The length of time that the first dispense is expected to last.")
        protected Duration duration;
        private static final long serialVersionUID = 1223227956L;

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestInitialFillComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationRequestDispenseRequestInitialFillComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestInitialFillComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Duration();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public MedicationRequestDispenseRequestInitialFillComponent setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The amount or quantity to provide as part of the first dispense.", 0, 1, this.quantity));
            children.add(new Property("duration", "Duration", "The length of time that the first dispense is expected to last.", 0, 1, this.duration));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The amount or quantity to provide as part of the first dispense.", 0, 1, this.quantity);
                }
                case -1992012396: {
                    return new Property("duration", "Duration", "The length of time that the first dispense is expected to last.", 0, 1, this.duration);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.duration;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("duration")) {
                this.duration = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1992012396: {
                    return this.getDuration();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1992012396: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("duration")) {
                this.duration = new Duration();
                return this.duration;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationRequestDispenseRequestInitialFillComponent copy() {
            MedicationRequestDispenseRequestInitialFillComponent dst = new MedicationRequestDispenseRequestInitialFillComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationRequestDispenseRequestInitialFillComponent dst) {
            super.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestDispenseRequestInitialFillComponent)) {
                return false;
            }
            MedicationRequestDispenseRequestInitialFillComponent o = (MedicationRequestDispenseRequestInitialFillComponent)other_;
            return MedicationRequestDispenseRequestInitialFillComponent.compareDeep(this.quantity, o.quantity, true) && MedicationRequestDispenseRequestInitialFillComponent.compareDeep(this.duration, o.duration, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestDispenseRequestInitialFillComponent)) {
                return false;
            }
            MedicationRequestDispenseRequestInitialFillComponent o = (MedicationRequestDispenseRequestInitialFillComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.quantity, this.duration});
        }

        @Override
        public String fhirType() {
            return "MedicationRequest.dispenseRequest.initialFill";
        }
    }

    @Block
    public static class MedicationRequestDispenseRequestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="initialFill", type={}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="First fill details", formalDefinition="Indicates the quantity or duration for the first dispense of the medication.")
        protected MedicationRequestDispenseRequestInitialFillComponent initialFill;
        @Child(name="dispenseInterval", type={Duration.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum period of time between dispenses", formalDefinition="The minimum period of time that must occur between dispenses of the medication.")
        protected Duration dispenseInterval;
        @Child(name="validityPeriod", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time period supply is authorized for", formalDefinition="This indicates the validity period of a prescription (stale dating the Prescription).")
        protected Period validityPeriod;
        @Child(name="numberOfRepeatsAllowed", type={UnsignedIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of refills authorized", formalDefinition="An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.  A prescriber may explicitly say that zero refills are permitted after the initial dispense.")
        protected UnsignedIntType numberOfRepeatsAllowed;
        @Child(name="quantity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of medication to supply per dispense", formalDefinition="The amount that is to be dispensed for one fill.")
        protected Quantity quantity;
        @Child(name="expectedSupplyDuration", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of days supply per dispense", formalDefinition="Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.")
        protected Duration expectedSupplyDuration;
        @Child(name="dispenser", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Intended performer of dispense", formalDefinition="Indicates the intended performing Organization that will dispense the medication as specified by the prescriber.")
        protected Reference dispenser;
        @Child(name="dispenserInstruction", type={Annotation.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information for the dispenser", formalDefinition="Provides additional information to the dispenser, for example, counselling to be provided to the patient.")
        protected List<Annotation> dispenserInstruction;
        @Child(name="doseAdministrationAid", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of adherence packaging to use for the dispense", formalDefinition="Provides information about the type of adherence packaging to be supplied for the medication dispense.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-dose-aid")
        protected CodeableConcept doseAdministrationAid;
        private static final long serialVersionUID = -916083616L;

        public MedicationRequestDispenseRequestInitialFillComponent getInitialFill() {
            if (this.initialFill == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.initialFill");
                }
                if (Configuration.doAutoCreate()) {
                    this.initialFill = new MedicationRequestDispenseRequestInitialFillComponent();
                }
            }
            return this.initialFill;
        }

        public boolean hasInitialFill() {
            return this.initialFill != null && !this.initialFill.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setInitialFill(MedicationRequestDispenseRequestInitialFillComponent value) {
            this.initialFill = value;
            return this;
        }

        public Duration getDispenseInterval() {
            if (this.dispenseInterval == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.dispenseInterval");
                }
                if (Configuration.doAutoCreate()) {
                    this.dispenseInterval = new Duration();
                }
            }
            return this.dispenseInterval;
        }

        public boolean hasDispenseInterval() {
            return this.dispenseInterval != null && !this.dispenseInterval.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setDispenseInterval(Duration value) {
            this.dispenseInterval = value;
            return this;
        }

        public Period getValidityPeriod() {
            if (this.validityPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.validityPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.validityPeriod = new Period();
                }
            }
            return this.validityPeriod;
        }

        public boolean hasValidityPeriod() {
            return this.validityPeriod != null && !this.validityPeriod.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setValidityPeriod(Period value) {
            this.validityPeriod = value;
            return this;
        }

        public UnsignedIntType getNumberOfRepeatsAllowedElement() {
            if (this.numberOfRepeatsAllowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.numberOfRepeatsAllowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfRepeatsAllowed = new UnsignedIntType();
                }
            }
            return this.numberOfRepeatsAllowed;
        }

        public boolean hasNumberOfRepeatsAllowedElement() {
            return this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty();
        }

        public boolean hasNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setNumberOfRepeatsAllowedElement(UnsignedIntType value) {
            this.numberOfRepeatsAllowed = value;
            return this;
        }

        public int getNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed == null || this.numberOfRepeatsAllowed.isEmpty() ? 0 : (Integer)this.numberOfRepeatsAllowed.getValue();
        }

        public MedicationRequestDispenseRequestComponent setNumberOfRepeatsAllowed(int value) {
            if (this.numberOfRepeatsAllowed == null) {
                this.numberOfRepeatsAllowed = new UnsignedIntType();
            }
            this.numberOfRepeatsAllowed.setValue((Object)value);
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getExpectedSupplyDuration() {
            if (this.expectedSupplyDuration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.expectedSupplyDuration");
                }
                if (Configuration.doAutoCreate()) {
                    this.expectedSupplyDuration = new Duration();
                }
            }
            return this.expectedSupplyDuration;
        }

        public boolean hasExpectedSupplyDuration() {
            return this.expectedSupplyDuration != null && !this.expectedSupplyDuration.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setExpectedSupplyDuration(Duration value) {
            this.expectedSupplyDuration = value;
            return this;
        }

        public Reference getDispenser() {
            if (this.dispenser == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.dispenser");
                }
                if (Configuration.doAutoCreate()) {
                    this.dispenser = new Reference();
                }
            }
            return this.dispenser;
        }

        public boolean hasDispenser() {
            return this.dispenser != null && !this.dispenser.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setDispenser(Reference value) {
            this.dispenser = value;
            return this;
        }

        public List<Annotation> getDispenserInstruction() {
            if (this.dispenserInstruction == null) {
                this.dispenserInstruction = new ArrayList<Annotation>();
            }
            return this.dispenserInstruction;
        }

        public MedicationRequestDispenseRequestComponent setDispenserInstruction(List<Annotation> theDispenserInstruction) {
            this.dispenserInstruction = theDispenserInstruction;
            return this;
        }

        public boolean hasDispenserInstruction() {
            if (this.dispenserInstruction == null) {
                return false;
            }
            for (Annotation item : this.dispenserInstruction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addDispenserInstruction() {
            Annotation t = new Annotation();
            if (this.dispenserInstruction == null) {
                this.dispenserInstruction = new ArrayList<Annotation>();
            }
            this.dispenserInstruction.add(t);
            return t;
        }

        public MedicationRequestDispenseRequestComponent addDispenserInstruction(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.dispenserInstruction == null) {
                this.dispenserInstruction = new ArrayList<Annotation>();
            }
            this.dispenserInstruction.add(t);
            return this;
        }

        public Annotation getDispenserInstructionFirstRep() {
            if (this.getDispenserInstruction().isEmpty()) {
                this.addDispenserInstruction();
            }
            return this.getDispenserInstruction().get(0);
        }

        public CodeableConcept getDoseAdministrationAid() {
            if (this.doseAdministrationAid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationRequestDispenseRequestComponent.doseAdministrationAid");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseAdministrationAid = new CodeableConcept();
                }
            }
            return this.doseAdministrationAid;
        }

        public boolean hasDoseAdministrationAid() {
            return this.doseAdministrationAid != null && !this.doseAdministrationAid.isEmpty();
        }

        public MedicationRequestDispenseRequestComponent setDoseAdministrationAid(CodeableConcept value) {
            this.doseAdministrationAid = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("initialFill", "", "Indicates the quantity or duration for the first dispense of the medication.", 0, 1, this.initialFill));
            children.add(new Property("dispenseInterval", "Duration", "The minimum period of time that must occur between dispenses of the medication.", 0, 1, this.dispenseInterval));
            children.add(new Property("validityPeriod", "Period", "This indicates the validity period of a prescription (stale dating the Prescription).", 0, 1, this.validityPeriod));
            children.add(new Property("numberOfRepeatsAllowed", "unsignedInt", "An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.  A prescriber may explicitly say that zero refills are permitted after the initial dispense.", 0, 1, this.numberOfRepeatsAllowed));
            children.add(new Property("quantity", "Quantity", "The amount that is to be dispensed for one fill.", 0, 1, this.quantity));
            children.add(new Property("expectedSupplyDuration", "Duration", "Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.", 0, 1, this.expectedSupplyDuration));
            children.add(new Property("dispenser", "Reference(Organization)", "Indicates the intended performing Organization that will dispense the medication as specified by the prescriber.", 0, 1, this.dispenser));
            children.add(new Property("dispenserInstruction", "Annotation", "Provides additional information to the dispenser, for example, counselling to be provided to the patient.", 0, Integer.MAX_VALUE, this.dispenserInstruction));
            children.add(new Property("doseAdministrationAid", "CodeableConcept", "Provides information about the type of adherence packaging to be supplied for the medication dispense.", 0, 1, this.doseAdministrationAid));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1232961255: {
                    return new Property("initialFill", "", "Indicates the quantity or duration for the first dispense of the medication.", 0, 1, this.initialFill);
                }
                case 757112130: {
                    return new Property("dispenseInterval", "Duration", "The minimum period of time that must occur between dispenses of the medication.", 0, 1, this.dispenseInterval);
                }
                case -1434195053: {
                    return new Property("validityPeriod", "Period", "This indicates the validity period of a prescription (stale dating the Prescription).", 0, 1, this.validityPeriod);
                }
                case -239736976: {
                    return new Property("numberOfRepeatsAllowed", "unsignedInt", "An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.  A prescriber may explicitly say that zero refills are permitted after the initial dispense.", 0, 1, this.numberOfRepeatsAllowed);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The amount that is to be dispensed for one fill.", 0, 1, this.quantity);
                }
                case -1910182789: {
                    return new Property("expectedSupplyDuration", "Duration", "Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.", 0, 1, this.expectedSupplyDuration);
                }
                case 241511093: {
                    return new Property("dispenser", "Reference(Organization)", "Indicates the intended performing Organization that will dispense the medication as specified by the prescriber.", 0, 1, this.dispenser);
                }
                case 2073630361: {
                    return new Property("dispenserInstruction", "Annotation", "Provides additional information to the dispenser, for example, counselling to be provided to the patient.", 0, Integer.MAX_VALUE, this.dispenserInstruction);
                }
                case 390821217: {
                    return new Property("doseAdministrationAid", "CodeableConcept", "Provides information about the type of adherence packaging to be supplied for the medication dispense.", 0, 1, this.doseAdministrationAid);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1232961255: {
                    Base[] baseArray;
                    if (this.initialFill == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.initialFill;
                    }
                    return baseArray;
                }
                case 757112130: {
                    Base[] baseArray;
                    if (this.dispenseInterval == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.dispenseInterval;
                    }
                    return baseArray;
                }
                case -1434195053: {
                    Base[] baseArray;
                    if (this.validityPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.validityPeriod;
                    }
                    return baseArray;
                }
                case -239736976: {
                    Base[] baseArray;
                    if (this.numberOfRepeatsAllowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.numberOfRepeatsAllowed;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1910182789: {
                    Base[] baseArray;
                    if (this.expectedSupplyDuration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.expectedSupplyDuration;
                    }
                    return baseArray;
                }
                case 241511093: {
                    Base[] baseArray;
                    if (this.dispenser == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.dispenser;
                    }
                    return baseArray;
                }
                case 2073630361: {
                    return this.dispenserInstruction == null ? new Base[]{} : this.dispenserInstruction.toArray(new Base[this.dispenserInstruction.size()]);
                }
                case 390821217: {
                    Base[] baseArray;
                    if (this.doseAdministrationAid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.doseAdministrationAid;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1232961255: {
                    this.initialFill = (MedicationRequestDispenseRequestInitialFillComponent)value;
                    return value;
                }
                case 757112130: {
                    this.dispenseInterval = TypeConvertor.castToDuration(value);
                    return value;
                }
                case -1434195053: {
                    this.validityPeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -239736976: {
                    this.numberOfRepeatsAllowed = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1910182789: {
                    this.expectedSupplyDuration = TypeConvertor.castToDuration(value);
                    return value;
                }
                case 241511093: {
                    this.dispenser = TypeConvertor.castToReference(value);
                    return value;
                }
                case 2073630361: {
                    this.getDispenserInstruction().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 390821217: {
                    this.doseAdministrationAid = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("initialFill")) {
                this.initialFill = (MedicationRequestDispenseRequestInitialFillComponent)value;
            } else if (name.equals("dispenseInterval")) {
                this.dispenseInterval = TypeConvertor.castToDuration(value);
            } else if (name.equals("validityPeriod")) {
                this.validityPeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals("numberOfRepeatsAllowed")) {
                this.numberOfRepeatsAllowed = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("expectedSupplyDuration")) {
                this.expectedSupplyDuration = TypeConvertor.castToDuration(value);
            } else if (name.equals("dispenser")) {
                this.dispenser = TypeConvertor.castToReference(value);
            } else if (name.equals("dispenserInstruction")) {
                this.getDispenserInstruction().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("doseAdministrationAid")) {
                this.doseAdministrationAid = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1232961255: {
                    return this.getInitialFill();
                }
                case 757112130: {
                    return this.getDispenseInterval();
                }
                case -1434195053: {
                    return this.getValidityPeriod();
                }
                case -239736976: {
                    return this.getNumberOfRepeatsAllowedElement();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1910182789: {
                    return this.getExpectedSupplyDuration();
                }
                case 241511093: {
                    return this.getDispenser();
                }
                case 2073630361: {
                    return this.addDispenserInstruction();
                }
                case 390821217: {
                    return this.getDoseAdministrationAid();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1232961255: {
                    return new String[0];
                }
                case 757112130: {
                    return new String[]{"Duration"};
                }
                case -1434195053: {
                    return new String[]{"Period"};
                }
                case -239736976: {
                    return new String[]{"unsignedInt"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1910182789: {
                    return new String[]{"Duration"};
                }
                case 241511093: {
                    return new String[]{"Reference"};
                }
                case 2073630361: {
                    return new String[]{"Annotation"};
                }
                case 390821217: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("initialFill")) {
                this.initialFill = new MedicationRequestDispenseRequestInitialFillComponent();
                return this.initialFill;
            }
            if (name.equals("dispenseInterval")) {
                this.dispenseInterval = new Duration();
                return this.dispenseInterval;
            }
            if (name.equals("validityPeriod")) {
                this.validityPeriod = new Period();
                return this.validityPeriod;
            }
            if (name.equals("numberOfRepeatsAllowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationRequest.dispenseRequest.numberOfRepeatsAllowed");
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("expectedSupplyDuration")) {
                this.expectedSupplyDuration = new Duration();
                return this.expectedSupplyDuration;
            }
            if (name.equals("dispenser")) {
                this.dispenser = new Reference();
                return this.dispenser;
            }
            if (name.equals("dispenserInstruction")) {
                return this.addDispenserInstruction();
            }
            if (name.equals("doseAdministrationAid")) {
                this.doseAdministrationAid = new CodeableConcept();
                return this.doseAdministrationAid;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationRequestDispenseRequestComponent copy() {
            MedicationRequestDispenseRequestComponent dst = new MedicationRequestDispenseRequestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationRequestDispenseRequestComponent dst) {
            super.copyValues(dst);
            dst.initialFill = this.initialFill == null ? null : this.initialFill.copy();
            dst.dispenseInterval = this.dispenseInterval == null ? null : this.dispenseInterval.copy();
            dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
            dst.numberOfRepeatsAllowed = this.numberOfRepeatsAllowed == null ? null : this.numberOfRepeatsAllowed.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.expectedSupplyDuration = this.expectedSupplyDuration == null ? null : this.expectedSupplyDuration.copy();
            Reference reference = dst.dispenser = this.dispenser == null ? null : this.dispenser.copy();
            if (this.dispenserInstruction != null) {
                dst.dispenserInstruction = new ArrayList<Annotation>();
                for (Annotation i : this.dispenserInstruction) {
                    dst.dispenserInstruction.add(i.copy());
                }
            }
            dst.doseAdministrationAid = this.doseAdministrationAid == null ? null : this.doseAdministrationAid.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestDispenseRequestComponent)) {
                return false;
            }
            MedicationRequestDispenseRequestComponent o = (MedicationRequestDispenseRequestComponent)other_;
            return MedicationRequestDispenseRequestComponent.compareDeep(this.initialFill, o.initialFill, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.dispenseInterval, o.dispenseInterval, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.validityPeriod, o.validityPeriod, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.numberOfRepeatsAllowed, o.numberOfRepeatsAllowed, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.quantity, o.quantity, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.expectedSupplyDuration, o.expectedSupplyDuration, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.dispenser, o.dispenser, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.dispenserInstruction, o.dispenserInstruction, true) && MedicationRequestDispenseRequestComponent.compareDeep(this.doseAdministrationAid, o.doseAdministrationAid, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationRequestDispenseRequestComponent)) {
                return false;
            }
            MedicationRequestDispenseRequestComponent o = (MedicationRequestDispenseRequestComponent)other_;
            return MedicationRequestDispenseRequestComponent.compareValues(this.numberOfRepeatsAllowed, o.numberOfRepeatsAllowed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.initialFill, this.dispenseInterval, this.validityPeriod, this.numberOfRepeatsAllowed, this.quantity, this.expectedSupplyDuration, this.dispenser, this.dispenserInstruction, this.doseAdministrationAid});
        }

        @Override
        public String fhirType() {
            return "MedicationRequest.dispenseRequest";
        }
    }

    public static class MedicationrequestStatusEnumFactory
    implements EnumFactory<MedicationrequestStatus> {
        @Override
        public MedicationrequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationrequestStatus.ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationrequestStatus.ONHOLD;
            }
            if ("ended".equals(codeString)) {
                return MedicationrequestStatus.ENDED;
            }
            if ("stopped".equals(codeString)) {
                return MedicationrequestStatus.STOPPED;
            }
            if ("completed".equals(codeString)) {
                return MedicationrequestStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return MedicationrequestStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationrequestStatus.ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return MedicationrequestStatus.DRAFT;
            }
            if ("unknown".equals(codeString)) {
                return MedicationrequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MedicationrequestStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationrequestStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.ACTIVE, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.ONHOLD, code);
            }
            if ("ended".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.ENDED, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.STOPPED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.COMPLETED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.CANCELLED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.ENTEREDINERROR, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.DRAFT, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MedicationrequestStatus>(this, MedicationrequestStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown MedicationrequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationrequestStatus code) {
            if (code == MedicationrequestStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationrequestStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationrequestStatus.ENDED) {
                return "ended";
            }
            if (code == MedicationrequestStatus.STOPPED) {
                return "stopped";
            }
            if (code == MedicationrequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationrequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == MedicationrequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationrequestStatus.DRAFT) {
                return "draft";
            }
            if (code == MedicationrequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationrequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationrequestStatus {
        ACTIVE,
        ONHOLD,
        ENDED,
        STOPPED,
        COMPLETED,
        CANCELLED,
        ENTEREDINERROR,
        DRAFT,
        UNKNOWN,
        NULL;


        public static MedicationrequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("ended".equals(codeString)) {
                return ENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationrequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case ENDED: {
                    return "ended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case DRAFT: {
                    return "draft";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case ENDED: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The request is 'actionable', but not all actions that are implied by it have occurred yet.";
                }
                case ONHOLD: {
                    return "Actions implied by the request are to be temporarily halted. The request might or might not be resumed. May also be called 'suspended'.";
                }
                case ENDED: {
                    return "The request is no longer active and the subject should no longer be taking the medication.";
                }
                case STOPPED: {
                    return "Actions implied by the request are to be permanently halted, before all of the administrations occurred. This should not be used if the original order was entered in error";
                }
                case COMPLETED: {
                    return "All actions that are implied by the request have occurred.";
                }
                case CANCELLED: {
                    return "The request has been withdrawn before any administrations have occurred";
                }
                case ENTEREDINERROR: {
                    return "The request was recorded against the wrong patient or for some reason should not have been recorded (e.g. wrong medication, wrong dose, etc.). Some of the actions that are implied by the medication request may have occurred. For example, the medication may have been dispensed and the patient may have taken some of the medication.";
                }
                case DRAFT: {
                    return "The request is not yet 'actionable', e.g. it is a work in progress, requires sign-off, verification\u00a0or\u00a0needs to be run through decision support process.";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this request. Note: This concept is not to be used for 'other' - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case ENDED: {
                    return "Ended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case DRAFT: {
                    return "Draft";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MedicationRequestIntentEnumFactory
    implements EnumFactory<MedicationRequestIntent> {
        @Override
        public MedicationRequestIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return MedicationRequestIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return MedicationRequestIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return MedicationRequestIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return MedicationRequestIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return MedicationRequestIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return MedicationRequestIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return MedicationRequestIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return MedicationRequestIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown MedicationRequestIntent code '" + codeString + "'");
        }

        public Enumeration<MedicationRequestIntent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.NULL, code);
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.PROPOSAL, code);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.PLAN, code);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.ORDER, code);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.ORIGINALORDER, code);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.REFLEXORDER, code);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.FILLERORDER, code);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.INSTANCEORDER, code);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<MedicationRequestIntent>(this, MedicationRequestIntent.OPTION, code);
            }
            throw new FHIRException("Unknown MedicationRequestIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationRequestIntent code) {
            if (code == MedicationRequestIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == MedicationRequestIntent.PLAN) {
                return "plan";
            }
            if (code == MedicationRequestIntent.ORDER) {
                return "order";
            }
            if (code == MedicationRequestIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == MedicationRequestIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == MedicationRequestIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == MedicationRequestIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == MedicationRequestIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationRequestIntent code) {
            return code.getSystem();
        }
    }

    public static enum MedicationRequestIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static MedicationRequestIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationRequestIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/CodeSystem/medicationrequest-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action";
                }
                case ORIGINALORDER: {
                    return "The request represents the original authorization for the medication request.";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization..";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order.";
                }
                case INSTANCEORDER: {
                    return "The request represents an instance for the particular order and is used to generate a schedule of requests on a medication administration record (MAR).";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestOrchestration that establishes timing, conditionality and/or  other constraints among a set of requests.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

