/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Transport", profile="http://hl7.org/fhir/StructureDefinition/Transport")
public class Transport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier for the transport event that is used to identify it across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal definition of transport", formalDefinition="The URL pointing to a *FHIR*-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Transport.")
    protected CanonicalType instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal definition of transport", formalDefinition="The URL pointing to an *externally* maintained  protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Transport.")
    protected UriType instantiatesUri;
    @Child(name="basedOn", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled by this transport", formalDefinition="BasedOn refers to a higher-level authorization that triggered the creation of the transport.  It references a \"request\" resource such as a ServiceRequest or Transport, which is distinct from the \"request\" resource the Transport is seeking to fulfill.  This latter resource is referenced by FocusOn.  For example, based on a ServiceRequest (= BasedOn), a transport is created to fulfill a procedureRequest ( = FocusOn ) to transport a specimen to the lab.")
    protected List<Reference> basedOn;
    @Child(name="groupIdentifier", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requisition or grouper id", formalDefinition="A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.")
    protected Identifier groupIdentifier;
    @Child(name="partOf", type={Transport.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | abandoned | cancelled | planned | entered-in-error", formalDefinition="A code specifying the state of the transport event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/transport-status")
    protected Enumeration<TransportStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for current status", formalDefinition="An explanation as to why this transport is held, failed, was refused, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/transport-status-reason")
    protected CodeableConcept statusReason;
    @Child(name="intent", type={CodeType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="unknown | proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Indicates the \"level\" of actionability associated with the Transport, i.e. i+R[9]Cs this a proposed transport, a planned transport, an actionable transport, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/transport-intent")
    protected Enumeration<TransportIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the Transport should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<Enumerations.RequestPriority> priority;
    @Child(name="code", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Transport Type", formalDefinition="A name or code (or both) briefly describing what the transport involves.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/transport-code")
    protected CodeableConcept code;
    @Child(name="description", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable explanation of transport", formalDefinition="A free-text description of what is to be performed.")
    protected StringType description;
    @Child(name="focus", type={Reference.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What transport is acting on", formalDefinition="The request being actioned or the resource being manipulated by this transport.")
    protected Reference focus;
    @Child(name="for", type={Reference.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Beneficiary of the Transport", formalDefinition="The entity who benefits from the performance of the service specified in the transport (e.g., the patient).")
    protected Reference for_;
    @Child(name="encounter", type={Encounter.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Healthcare event during which this transport originated", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this transport was created.")
    protected Reference encounter;
    @Child(name="completionTime", type={DateTimeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Completion time of the event (the occurrence)", formalDefinition="Identifies the completion time of the event (the occurrence).")
    protected DateTimeType completionTime;
    @Child(name="authoredOn", type={DateTimeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Transport Creation Date", formalDefinition="The date and time this transport was created.")
    protected DateTimeType authoredOn;
    @Child(name="lastModified", type={DateTimeType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Transport Last Modified Date", formalDefinition="The date and time of last modification to this transport.")
    protected DateTimeType lastModified;
    @Child(name="requester", type={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is asking for transport to be done", formalDefinition="The creator of the transport.")
    protected Reference requester;
    @Child(name="performerType", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Requested performer", formalDefinition="The kind of participant that should perform the transport.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
    protected List<CodeableConcept> performerType;
    @Child(name="owner", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, HealthcareService.class, Patient.class, Device.class, RelatedPerson.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible individual", formalDefinition="Individual organization or Device currently responsible for transport execution.")
    protected Reference owner;
    @Child(name="location", type={Location.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where transport occurs", formalDefinition="Principal physical location where this transport is performed.")
    protected Reference location;
    @Child(name="insurance", type={Coverage.class, ClaimResponse.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated insurance coverage", formalDefinition="Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Transport.")
    protected List<Reference> insurance;
    @Child(name="note", type={Annotation.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the transport", formalDefinition="Free-text information captured about the transport as it progresses.")
    protected List<Annotation> note;
    @Child(name="relevantHistory", type={Provenance.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Key events in history of the Transport", formalDefinition="Links to Provenance records for past versions of this Transport that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the transport.")
    protected List<Reference> relevantHistory;
    @Child(name="restriction", type={}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Constraints on fulfillment transports", formalDefinition="If the Transport.focus is a request resource and the transport is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.")
    protected TransportRestrictionComponent restriction;
    @Child(name="input", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information used to perform transport", formalDefinition="Additional information that may be needed in the execution of the transport.")
    protected List<ParameterComponent> input;
    @Child(name="output", type={}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information produced as part of transport", formalDefinition="Outputs produced by the Transport.")
    protected List<TransportOutputComponent> output;
    @Child(name="requestedLocation", type={Location.class}, order=28, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The desired location", formalDefinition="The desired or final location for the transport.")
    protected Reference requestedLocation;
    @Child(name="currentLocation", type={Location.class}, order=29, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The entity current location", formalDefinition="The current location for the entity to be transported.")
    protected Reference currentLocation;
    @Child(name="reason", type={CodeableReference.class}, order=30, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why transport is needed", formalDefinition="A resource reference indicating why this transport needs to be performed.")
    protected CodeableReference reason;
    @Child(name="history", type={Transport.class}, order=31, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Parent (or preceding) transport", formalDefinition="The transport event prior to this one.")
    protected Reference history;
    private static final long serialVersionUID = -2095581755L;
    @SearchParamDefinition(name="identifier", path="Transport.identifier", description="External identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Transport.status", description="in-progress | completed | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Transport() {
    }

    public Transport(TransportIntent intent, Reference requestedLocation, Reference currentLocation) {
        this.setIntent(intent);
        this.setRequestedLocation(requestedLocation);
        this.setCurrentLocation(currentLocation);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Transport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Transport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CanonicalType getInstantiatesCanonicalElement() {
        if (this.instantiatesCanonical == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.instantiatesCanonical");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesCanonical = new CanonicalType();
            }
        }
        return this.instantiatesCanonical;
    }

    public boolean hasInstantiatesCanonicalElement() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public boolean hasInstantiatesCanonical() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public Transport setInstantiatesCanonicalElement(CanonicalType value) {
        this.instantiatesCanonical = value;
        return this;
    }

    public String getInstantiatesCanonical() {
        return this.instantiatesCanonical == null ? null : (String)this.instantiatesCanonical.getValue();
    }

    public Transport setInstantiatesCanonical(String value) {
        if (Utilities.noString((String)value)) {
            this.instantiatesCanonical = null;
        } else {
            if (this.instantiatesCanonical == null) {
                this.instantiatesCanonical = new CanonicalType();
            }
            this.instantiatesCanonical.setValue(value);
        }
        return this;
    }

    public UriType getInstantiatesUriElement() {
        if (this.instantiatesUri == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.instantiatesUri");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesUri = new UriType();
            }
        }
        return this.instantiatesUri;
    }

    public boolean hasInstantiatesUriElement() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public boolean hasInstantiatesUri() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public Transport setInstantiatesUriElement(UriType value) {
        this.instantiatesUri = value;
        return this;
    }

    public String getInstantiatesUri() {
        return this.instantiatesUri == null ? null : (String)this.instantiatesUri.getValue();
    }

    public Transport setInstantiatesUri(String value) {
        if (Utilities.noString((String)value)) {
            this.instantiatesUri = null;
        } else {
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new UriType();
            }
            this.instantiatesUri.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Transport setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Transport addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public Transport setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Transport setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Transport addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<TransportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<TransportStatus>(new TransportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Transport setStatusElement(Enumeration<TransportStatus> value) {
        this.status = value;
        return this;
    }

    public TransportStatus getStatus() {
        return this.status == null ? null : (TransportStatus)((Object)this.status.getValue());
    }

    public Transport setStatus(TransportStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<TransportStatus>(new TransportStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Transport setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public Enumeration<TransportIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<TransportIntent>(new TransportIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public Transport setIntentElement(Enumeration<TransportIntent> value) {
        this.intent = value;
        return this;
    }

    public TransportIntent getIntent() {
        return this.intent == null ? null : (TransportIntent)((Object)this.intent.getValue());
    }

    public Transport setIntent(TransportIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<TransportIntent>(new TransportIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Transport setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public Enumerations.RequestPriority getPriority() {
        return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
    }

    public Transport setPriority(Enumerations.RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Transport setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Transport setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Transport setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getFocus() {
        if (this.focus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.focus");
            }
            if (Configuration.doAutoCreate()) {
                this.focus = new Reference();
            }
        }
        return this.focus;
    }

    public boolean hasFocus() {
        return this.focus != null && !this.focus.isEmpty();
    }

    public Transport setFocus(Reference value) {
        this.focus = value;
        return this;
    }

    public Reference getFor() {
        if (this.for_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.for_");
            }
            if (Configuration.doAutoCreate()) {
                this.for_ = new Reference();
            }
        }
        return this.for_;
    }

    public boolean hasFor() {
        return this.for_ != null && !this.for_.isEmpty();
    }

    public Transport setFor(Reference value) {
        this.for_ = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Transport setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getCompletionTimeElement() {
        if (this.completionTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.completionTime");
            }
            if (Configuration.doAutoCreate()) {
                this.completionTime = new DateTimeType();
            }
        }
        return this.completionTime;
    }

    public boolean hasCompletionTimeElement() {
        return this.completionTime != null && !this.completionTime.isEmpty();
    }

    public boolean hasCompletionTime() {
        return this.completionTime != null && !this.completionTime.isEmpty();
    }

    public Transport setCompletionTimeElement(DateTimeType value) {
        this.completionTime = value;
        return this;
    }

    public Date getCompletionTime() {
        return this.completionTime == null ? null : (Date)this.completionTime.getValue();
    }

    public Transport setCompletionTime(Date value) {
        if (value == null) {
            this.completionTime = null;
        } else {
            if (this.completionTime == null) {
                this.completionTime = new DateTimeType();
            }
            this.completionTime.setValue(value);
        }
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public Transport setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public Transport setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public DateTimeType getLastModifiedElement() {
        if (this.lastModified == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.lastModified");
            }
            if (Configuration.doAutoCreate()) {
                this.lastModified = new DateTimeType();
            }
        }
        return this.lastModified;
    }

    public boolean hasLastModifiedElement() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public boolean hasLastModified() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public Transport setLastModifiedElement(DateTimeType value) {
        this.lastModified = value;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified == null ? null : (Date)this.lastModified.getValue();
    }

    public Transport setLastModified(Date value) {
        if (value == null) {
            this.lastModified = null;
        } else {
            if (this.lastModified == null) {
                this.lastModified = new DateTimeType();
            }
            this.lastModified.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public Transport setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public List<CodeableConcept> getPerformerType() {
        if (this.performerType == null) {
            this.performerType = new ArrayList<CodeableConcept>();
        }
        return this.performerType;
    }

    public Transport setPerformerType(List<CodeableConcept> thePerformerType) {
        this.performerType = thePerformerType;
        return this;
    }

    public boolean hasPerformerType() {
        if (this.performerType == null) {
            return false;
        }
        for (CodeableConcept item : this.performerType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPerformerType() {
        CodeableConcept t = new CodeableConcept();
        if (this.performerType == null) {
            this.performerType = new ArrayList<CodeableConcept>();
        }
        this.performerType.add(t);
        return t;
    }

    public Transport addPerformerType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.performerType == null) {
            this.performerType = new ArrayList<CodeableConcept>();
        }
        this.performerType.add(t);
        return this;
    }

    public CodeableConcept getPerformerTypeFirstRep() {
        if (this.getPerformerType().isEmpty()) {
            this.addPerformerType();
        }
        return this.getPerformerType().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Transport setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Transport setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<Reference> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        return this.insurance;
    }

    public Transport setInsurance(List<Reference> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (Reference item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInsurance() {
        Reference t = new Reference();
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return t;
    }

    public Transport addInsurance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return this;
    }

    public Reference getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Transport setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Transport addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public Transport setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public Transport addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    public TransportRestrictionComponent getRestriction() {
        if (this.restriction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.restriction");
            }
            if (Configuration.doAutoCreate()) {
                this.restriction = new TransportRestrictionComponent();
            }
        }
        return this.restriction;
    }

    public boolean hasRestriction() {
        return this.restriction != null && !this.restriction.isEmpty();
    }

    public Transport setRestriction(TransportRestrictionComponent value) {
        this.restriction = value;
        return this;
    }

    public List<ParameterComponent> getInput() {
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        return this.input;
    }

    public Transport setInput(List<ParameterComponent> theInput) {
        this.input = theInput;
        return this;
    }

    public boolean hasInput() {
        if (this.input == null) {
            return false;
        }
        for (ParameterComponent item : this.input) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParameterComponent addInput() {
        ParameterComponent t = new ParameterComponent();
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        this.input.add(t);
        return t;
    }

    public Transport addInput(ParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        this.input.add(t);
        return this;
    }

    public ParameterComponent getInputFirstRep() {
        if (this.getInput().isEmpty()) {
            this.addInput();
        }
        return this.getInput().get(0);
    }

    public List<TransportOutputComponent> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<TransportOutputComponent>();
        }
        return this.output;
    }

    public Transport setOutput(List<TransportOutputComponent> theOutput) {
        this.output = theOutput;
        return this;
    }

    public boolean hasOutput() {
        if (this.output == null) {
            return false;
        }
        for (TransportOutputComponent item : this.output) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TransportOutputComponent addOutput() {
        TransportOutputComponent t = new TransportOutputComponent();
        if (this.output == null) {
            this.output = new ArrayList<TransportOutputComponent>();
        }
        this.output.add(t);
        return t;
    }

    public Transport addOutput(TransportOutputComponent t) {
        if (t == null) {
            return this;
        }
        if (this.output == null) {
            this.output = new ArrayList<TransportOutputComponent>();
        }
        this.output.add(t);
        return this;
    }

    public TransportOutputComponent getOutputFirstRep() {
        if (this.getOutput().isEmpty()) {
            this.addOutput();
        }
        return this.getOutput().get(0);
    }

    public Reference getRequestedLocation() {
        if (this.requestedLocation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.requestedLocation");
            }
            if (Configuration.doAutoCreate()) {
                this.requestedLocation = new Reference();
            }
        }
        return this.requestedLocation;
    }

    public boolean hasRequestedLocation() {
        return this.requestedLocation != null && !this.requestedLocation.isEmpty();
    }

    public Transport setRequestedLocation(Reference value) {
        this.requestedLocation = value;
        return this;
    }

    public Reference getCurrentLocation() {
        if (this.currentLocation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.currentLocation");
            }
            if (Configuration.doAutoCreate()) {
                this.currentLocation = new Reference();
            }
        }
        return this.currentLocation;
    }

    public boolean hasCurrentLocation() {
        return this.currentLocation != null && !this.currentLocation.isEmpty();
    }

    public Transport setCurrentLocation(Reference value) {
        this.currentLocation = value;
        return this;
    }

    public CodeableReference getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableReference();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Transport setReason(CodeableReference value) {
        this.reason = value;
        return this;
    }

    public Reference getHistory() {
        if (this.history == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Transport.history");
            }
            if (Configuration.doAutoCreate()) {
                this.history = new Reference();
            }
        }
        return this.history;
    }

    public boolean hasHistory() {
        return this.history != null && !this.history.isEmpty();
    }

    public Transport setHistory(Reference value) {
        this.history = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the transport event that is used to identify it across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(ActivityDefinition)", "The URL pointing to a *FHIR*-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Transport.", 0, 1, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an *externally* maintained  protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Transport.", 0, 1, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(Any)", "BasedOn refers to a higher-level authorization that triggered the creation of the transport.  It references a \"request\" resource such as a ServiceRequest or Transport, which is distinct from the \"request\" resource the Transport is seeking to fulfill.  This latter resource is referenced by FocusOn.  For example, based on a ServiceRequest (= BasedOn), a transport is created to fulfill a procedureRequest ( = FocusOn ) to transport a specimen to the lab.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.", 0, 1, this.groupIdentifier));
        children.add(new Property("partOf", "Reference(Transport)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "A code specifying the state of the transport event.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "An explanation as to why this transport is held, failed, was refused, etc.", 0, 1, this.statusReason));
        children.add(new Property("intent", "code", "Indicates the \"level\" of actionability associated with the Transport, i.e. i+R[9]Cs this a proposed transport, a planned transport, an actionable transport, etc.", 0, 1, this.intent));
        children.add(new Property("priority", "code", "Indicates how quickly the Transport should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("code", "CodeableConcept", "A name or code (or both) briefly describing what the transport involves.", 0, 1, this.code));
        children.add(new Property("description", "string", "A free-text description of what is to be performed.", 0, 1, this.description));
        children.add(new Property("focus", "Reference(Any)", "The request being actioned or the resource being manipulated by this transport.", 0, 1, this.focus));
        children.add(new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the transport (e.g., the patient).", 0, 1, this.for_));
        children.add(new Property("encounter", "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this transport was created.", 0, 1, this.encounter));
        children.add(new Property("completionTime", "dateTime", "Identifies the completion time of the event (the occurrence).", 0, 1, this.completionTime));
        children.add(new Property("authoredOn", "dateTime", "The date and time this transport was created.", 0, 1, this.authoredOn));
        children.add(new Property("lastModified", "dateTime", "The date and time of last modification to this transport.", 0, 1, this.lastModified));
        children.add(new Property("requester", "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The creator of the transport.", 0, 1, this.requester));
        children.add(new Property("performerType", "CodeableConcept", "The kind of participant that should perform the transport.", 0, Integer.MAX_VALUE, this.performerType));
        children.add(new Property("owner", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "Individual organization or Device currently responsible for transport execution.", 0, 1, this.owner));
        children.add(new Property("location", "Reference(Location)", "Principal physical location where this transport is performed.", 0, 1, this.location));
        children.add(new Property("insurance", "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Transport.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("note", "Annotation", "Free-text information captured about the transport as it progresses.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Transport that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the transport.", 0, Integer.MAX_VALUE, this.relevantHistory));
        children.add(new Property("restriction", "", "If the Transport.focus is a request resource and the transport is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.", 0, 1, this.restriction));
        children.add(new Property("input", "", "Additional information that may be needed in the execution of the transport.", 0, Integer.MAX_VALUE, this.input));
        children.add(new Property("output", "", "Outputs produced by the Transport.", 0, Integer.MAX_VALUE, this.output));
        children.add(new Property("requestedLocation", "Reference(Location)", "The desired or final location for the transport.", 0, 1, this.requestedLocation));
        children.add(new Property("currentLocation", "Reference(Location)", "The current location for the entity to be transported.", 0, 1, this.currentLocation));
        children.add(new Property("reason", "CodeableReference(Any)", "A resource reference indicating why this transport needs to be performed.", 0, 1, this.reason));
        children.add(new Property("history", "Reference(Transport)", "The transport event prior to this one.", 0, 1, this.history));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the transport event that is used to identify it across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(ActivityDefinition)", "The URL pointing to a *FHIR*-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Transport.", 0, 1, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an *externally* maintained  protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Transport.", 0, 1, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "BasedOn refers to a higher-level authorization that triggered the creation of the transport.  It references a \"request\" resource such as a ServiceRequest or Transport, which is distinct from the \"request\" resource the Transport is seeking to fulfill.  This latter resource is referenced by FocusOn.  For example, based on a ServiceRequest (= BasedOn), a transport is created to fulfill a procedureRequest ( = FocusOn ) to transport a specimen to the lab.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.", 0, 1, this.groupIdentifier);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Transport)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "A code specifying the state of the transport event.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "An explanation as to why this transport is held, failed, was refused, etc.", 0, 1, this.statusReason);
            }
            case -1183762788: {
                return new Property("intent", "code", "Indicates the \"level\" of actionability associated with the Transport, i.e. i+R[9]Cs this a proposed transport, a planned transport, an actionable transport, etc.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property("priority", "code", "Indicates how quickly the Transport should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "A name or code (or both) briefly describing what the transport involves.", 0, 1, this.code);
            }
            case -1724546052: {
                return new Property("description", "string", "A free-text description of what is to be performed.", 0, 1, this.description);
            }
            case 97604824: {
                return new Property("focus", "Reference(Any)", "The request being actioned or the resource being manipulated by this transport.", 0, 1, this.focus);
            }
            case 101577: {
                return new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the transport (e.g., the patient).", 0, 1, this.for_);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this transport was created.", 0, 1, this.encounter);
            }
            case 1146641609: {
                return new Property("completionTime", "dateTime", "Identifies the completion time of the event (the occurrence).", 0, 1, this.completionTime);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "The date and time this transport was created.", 0, 1, this.authoredOn);
            }
            case 1959003007: {
                return new Property("lastModified", "dateTime", "The date and time of last modification to this transport.", 0, 1, this.lastModified);
            }
            case 693933948: {
                return new Property("requester", "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The creator of the transport.", 0, 1, this.requester);
            }
            case -901444568: {
                return new Property("performerType", "CodeableConcept", "The kind of participant that should perform the transport.", 0, Integer.MAX_VALUE, this.performerType);
            }
            case 106164915: {
                return new Property("owner", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "Individual organization or Device currently responsible for transport execution.", 0, 1, this.owner);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "Principal physical location where this transport is performed.", 0, 1, this.location);
            }
            case 73049818: {
                return new Property("insurance", "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Transport.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Free-text information captured about the transport as it progresses.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1538891575: {
                return new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Transport that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the transport.", 0, Integer.MAX_VALUE, this.relevantHistory);
            }
            case -1561062452: {
                return new Property("restriction", "", "If the Transport.focus is a request resource and the transport is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.", 0, 1, this.restriction);
            }
            case 100358090: {
                return new Property("input", "", "Additional information that may be needed in the execution of the transport.", 0, Integer.MAX_VALUE, this.input);
            }
            case -1005512447: {
                return new Property("output", "", "Outputs produced by the Transport.", 0, Integer.MAX_VALUE, this.output);
            }
            case -1788392125: {
                return new Property("requestedLocation", "Reference(Location)", "The desired or final location for the transport.", 0, 1, this.requestedLocation);
            }
            case -140429234: {
                return new Property("currentLocation", "Reference(Location)", "The current location for the entity to be transported.", 0, 1, this.currentLocation);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Any)", "A resource reference indicating why this transport needs to be performed.", 0, 1, this.reason);
            }
            case 926934164: {
                return new Property("history", "Reference(Transport)", "The transport event prior to this one.", 0, 1, this.history);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                Base[] baseArray;
                if (this.instantiatesCanonical == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.instantiatesCanonical;
                }
                return baseArray;
            }
            case -1926393373: {
                Base[] baseArray;
                if (this.instantiatesUri == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.instantiatesUri;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.statusReason;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.priority;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.code;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case 97604824: {
                Base[] baseArray;
                if (this.focus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.focus;
                }
                return baseArray;
            }
            case 101577: {
                Base[] baseArray;
                if (this.for_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.for_;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.encounter;
                }
                return baseArray;
            }
            case 1146641609: {
                Base[] baseArray;
                if (this.completionTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.completionTime;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 1959003007: {
                Base[] baseArray;
                if (this.lastModified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.lastModified;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.requester;
                }
                return baseArray;
            }
            case -901444568: {
                return this.performerType == null ? new Base[]{} : this.performerType.toArray(new Base[this.performerType.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.owner;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.location;
                }
                return baseArray;
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
            case -1561062452: {
                Base[] baseArray;
                if (this.restriction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.restriction;
                }
                return baseArray;
            }
            case 100358090: {
                return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
            }
            case -1005512447: {
                return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
            }
            case -1788392125: {
                Base[] baseArray;
                if (this.requestedLocation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.requestedLocation;
                }
                return baseArray;
            }
            case -140429234: {
                Base[] baseArray;
                if (this.currentLocation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.currentLocation;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.reason;
                }
                return baseArray;
            }
            case 926934164: {
                Base[] baseArray;
                if (this.history == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.history;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -1926393373: {
                this.instantiatesUri = TypeConvertor.castToUri(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new TransportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1183762788: {
                value = new TransportIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case 97604824: {
                this.focus = TypeConvertor.castToReference(value);
                return value;
            }
            case 101577: {
                this.for_ = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1146641609: {
                this.completionTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1959003007: {
                this.lastModified = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = TypeConvertor.castToReference(value);
                return value;
            }
            case -901444568: {
                this.getPerformerType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 106164915: {
                this.owner = TypeConvertor.castToReference(value);
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case 73049818: {
                this.getInsurance().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1561062452: {
                this.restriction = (TransportRestrictionComponent)((Object)value);
                return value;
            }
            case 100358090: {
                this.getInput().add((ParameterComponent)((Object)value));
                return value;
            }
            case -1005512447: {
                this.getOutput().add((TransportOutputComponent)((Object)value));
                return value;
            }
            case -1788392125: {
                this.requestedLocation = TypeConvertor.castToReference(value);
                return value;
            }
            case -140429234: {
                this.currentLocation = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case 926934164: {
                this.history = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
        } else if (name.equals("instantiatesUri")) {
            this.instantiatesUri = TypeConvertor.castToUri(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new TransportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("intent")) {
            value = new TransportIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals("priority")) {
            value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.priority = value;
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("focus")) {
            this.focus = TypeConvertor.castToReference(value);
        } else if (name.equals("for")) {
            this.for_ = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("completionTime")) {
            this.completionTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals("lastModified")) {
            this.lastModified = TypeConvertor.castToDateTime(value);
        } else if (name.equals("requester")) {
            this.requester = TypeConvertor.castToReference(value);
        } else if (name.equals("performerType")) {
            this.getPerformerType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("owner")) {
            this.owner = TypeConvertor.castToReference(value);
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("insurance")) {
            this.getInsurance().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(TypeConvertor.castToReference(value));
        } else if (name.equals("restriction")) {
            this.restriction = (TransportRestrictionComponent)((Object)value);
        } else if (name.equals("input")) {
            this.getInput().add((ParameterComponent)((Object)value));
        } else if (name.equals("output")) {
            this.getOutput().add((TransportOutputComponent)((Object)value));
        } else if (name.equals("requestedLocation")) {
            this.requestedLocation = TypeConvertor.castToReference(value);
        } else if (name.equals("currentLocation")) {
            this.currentLocation = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.reason = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("history")) {
            this.history = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.getInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.getInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 97604824: {
                return this.getFocus();
            }
            case 101577: {
                return this.getFor();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1146641609: {
                return this.getCompletionTimeElement();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 1959003007: {
                return this.getLastModifiedElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -901444568: {
                return this.addPerformerType();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
            case -1561062452: {
                return this.getRestriction();
            }
            case 100358090: {
                return this.addInput();
            }
            case -1005512447: {
                return this.addOutput();
            }
            case -1788392125: {
                return this.getRequestedLocation();
            }
            case -140429234: {
                return this.getCurrentLocation();
            }
            case -934964668: {
                return this.getReason();
            }
            case 926934164: {
                return this.getHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 101577: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1146641609: {
                return new String[]{"dateTime"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 1959003007: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[]{"Reference"};
            }
            case -901444568: {
                return new String[]{"CodeableConcept"};
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 73049818: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
            case -1561062452: {
                return new String[0];
            }
            case 100358090: {
                return new String[0];
            }
            case -1005512447: {
                return new String[0];
            }
            case -1788392125: {
                return new String[]{"Reference"};
            }
            case -140429234: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 926934164: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("intent")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.intent");
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.priority");
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.description");
        }
        if (name.equals("focus")) {
            this.focus = new Reference();
            return this.focus;
        }
        if (name.equals("for")) {
            this.for_ = new Reference();
            return this.for_;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("completionTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.completionTime");
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.authoredOn");
        }
        if (name.equals("lastModified")) {
            throw new FHIRException("Cannot call addChild on a primitive type Transport.lastModified");
        }
        if (name.equals("requester")) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals("performerType")) {
            return this.addPerformerType();
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        if (name.equals("restriction")) {
            this.restriction = new TransportRestrictionComponent();
            return this.restriction;
        }
        if (name.equals("input")) {
            return this.addInput();
        }
        if (name.equals("output")) {
            return this.addOutput();
        }
        if (name.equals("requestedLocation")) {
            this.requestedLocation = new Reference();
            return this.requestedLocation;
        }
        if (name.equals("currentLocation")) {
            this.currentLocation = new Reference();
            return this.currentLocation;
        }
        if (name.equals("reason")) {
            this.reason = new CodeableReference();
            return this.reason;
        }
        if (name.equals("history")) {
            this.history = new Reference();
            return this.history;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Transport";
    }

    @Override
    public Transport copy() {
        Transport dst = new Transport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Transport dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.instantiatesCanonical = this.instantiatesCanonical == null ? null : this.instantiatesCanonical.copy();
        UriType uriType = dst.instantiatesUri = this.instantiatesUri == null ? null : this.instantiatesUri.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Identifier identifier = dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.focus = this.focus == null ? null : this.focus.copy();
        dst.for_ = this.for_ == null ? null : this.for_.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.completionTime = this.completionTime == null ? null : this.completionTime.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
        Reference reference = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.performerType != null) {
            dst.performerType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.performerType) {
                dst.performerType.add(codeableConcept.copy());
            }
        }
        dst.owner = this.owner == null ? null : this.owner.copy();
        Reference reference2 = dst.location = this.location == null ? null : this.location.copy();
        if (this.insurance != null) {
            dst.insurance = new ArrayList<Reference>();
            for (Reference reference3 : this.insurance) {
                dst.insurance.add(reference3.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference4 : this.relevantHistory) {
                dst.relevantHistory.add(reference4.copy());
            }
        }
        TransportRestrictionComponent transportRestrictionComponent = dst.restriction = this.restriction == null ? null : this.restriction.copy();
        if (this.input != null) {
            dst.input = new ArrayList<ParameterComponent>();
            for (ParameterComponent parameterComponent : this.input) {
                dst.input.add(parameterComponent.copy());
            }
        }
        if (this.output != null) {
            dst.output = new ArrayList<TransportOutputComponent>();
            for (TransportOutputComponent transportOutputComponent : this.output) {
                dst.output.add(transportOutputComponent.copy());
            }
        }
        dst.requestedLocation = this.requestedLocation == null ? null : this.requestedLocation.copy();
        dst.currentLocation = this.currentLocation == null ? null : this.currentLocation.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.history = this.history == null ? null : this.history.copy();
    }

    protected Transport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Transport)) {
            return false;
        }
        Transport o = (Transport)other_;
        return Transport.compareDeep(this.identifier, o.identifier, true) && Transport.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && Transport.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && Transport.compareDeep(this.basedOn, o.basedOn, true) && Transport.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && Transport.compareDeep(this.partOf, o.partOf, true) && Transport.compareDeep(this.status, o.status, true) && Transport.compareDeep(this.statusReason, o.statusReason, true) && Transport.compareDeep(this.intent, o.intent, true) && Transport.compareDeep(this.priority, o.priority, true) && Transport.compareDeep(this.code, o.code, true) && Transport.compareDeep(this.description, o.description, true) && Transport.compareDeep(this.focus, o.focus, true) && Transport.compareDeep(this.for_, o.for_, true) && Transport.compareDeep(this.encounter, o.encounter, true) && Transport.compareDeep(this.completionTime, o.completionTime, true) && Transport.compareDeep(this.authoredOn, o.authoredOn, true) && Transport.compareDeep(this.lastModified, o.lastModified, true) && Transport.compareDeep(this.requester, o.requester, true) && Transport.compareDeep(this.performerType, o.performerType, true) && Transport.compareDeep(this.owner, o.owner, true) && Transport.compareDeep(this.location, o.location, true) && Transport.compareDeep(this.insurance, o.insurance, true) && Transport.compareDeep(this.note, o.note, true) && Transport.compareDeep(this.relevantHistory, o.relevantHistory, true) && Transport.compareDeep(this.restriction, o.restriction, true) && Transport.compareDeep(this.input, o.input, true) && Transport.compareDeep(this.output, o.output, true) && Transport.compareDeep(this.requestedLocation, o.requestedLocation, true) && Transport.compareDeep(this.currentLocation, o.currentLocation, true) && Transport.compareDeep(this.reason, o.reason, true) && Transport.compareDeep(this.history, o.history, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Transport)) {
            return false;
        }
        Transport o = (Transport)other_;
        return Transport.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && Transport.compareValues(this.instantiatesUri, o.instantiatesUri, true) && Transport.compareValues(this.status, o.status, true) && Transport.compareValues(this.intent, o.intent, true) && Transport.compareValues(this.priority, o.priority, true) && Transport.compareValues(this.description, o.description, true) && Transport.compareValues(this.completionTime, o.completionTime, true) && Transport.compareValues(this.authoredOn, o.authoredOn, true) && Transport.compareValues(this.lastModified, o.lastModified, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.groupIdentifier, this.partOf, this.status, this.statusReason, this.intent, this.priority, this.code, this.description, this.focus, this.for_, this.encounter, this.completionTime, this.authoredOn, this.lastModified, this.requester, this.performerType, this.owner, this.location, this.insurance, this.note, this.relevantHistory, this.restriction, this.input, this.output, this.requestedLocation, this.currentLocation, this.reason, this.history});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Transport;
    }

    @Block
    public static class TransportOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for output", formalDefinition="The name of the Output parameter.")
        protected CodeableConcept type;
        @Child(name="value", type={Base64BinaryType.class, BooleanType.class, CanonicalType.class, CodeType.class, DateType.class, DateTimeType.class, DecimalType.class, IdType.class, InstantType.class, IntegerType.class, Integer64Type.class, MarkdownType.class, OidType.class, PositiveIntType.class, StringType.class, TimeType.class, UnsignedIntType.class, UriType.class, UrlType.class, UuidType.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Availability.class, ExtendedContactDetail.class, Dosage.class, Meta.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Result of output", formalDefinition="The value of the Output parameter as a basic type.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public TransportOutputComponent() {
        }

        public TransportOutputComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TransportOutputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TransportOutputComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public CanonicalType getValueCanonicalType() throws FHIRException {
            if (this.value == null) {
                this.value = new CanonicalType();
            }
            if (!(this.value instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.value;
        }

        public boolean hasValueCanonicalType() {
            return this != null && this.value instanceof CanonicalType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (this.value == null) {
                this.value = new InstantType();
            }
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this != null && this.value instanceof InstantType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Integer64Type getValueInteger64Type() throws FHIRException {
            if (this.value == null) {
                this.value = new Integer64Type();
            }
            if (!(this.value instanceof Integer64Type)) {
                throw new FHIRException("Type mismatch: the type Integer64Type was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Integer64Type)this.value;
        }

        public boolean hasValueInteger64Type() {
            return this != null && this.value instanceof Integer64Type;
        }

        public MarkdownType getValueMarkdownType() throws FHIRException {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            if (!(this.value instanceof MarkdownType)) {
                throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (MarkdownType)this.value;
        }

        public boolean hasValueMarkdownType() {
            return this != null && this.value instanceof MarkdownType;
        }

        public OidType getValueOidType() throws FHIRException {
            if (this.value == null) {
                this.value = new OidType();
            }
            if (!(this.value instanceof OidType)) {
                throw new FHIRException("Type mismatch: the type OidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (OidType)this.value;
        }

        public boolean hasValueOidType() {
            return this != null && this.value instanceof OidType;
        }

        public PositiveIntType getValuePositiveIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new PositiveIntType();
            }
            if (!(this.value instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.value;
        }

        public boolean hasValuePositiveIntType() {
            return this != null && this.value instanceof PositiveIntType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public UnsignedIntType getValueUnsignedIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new UnsignedIntType();
            }
            if (!(this.value instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.value;
        }

        public boolean hasValueUnsignedIntType() {
            return this != null && this.value instanceof UnsignedIntType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public UrlType getValueUrlType() throws FHIRException {
            if (this.value == null) {
                this.value = new UrlType();
            }
            if (!(this.value instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UrlType)this.value;
        }

        public boolean hasValueUrlType() {
            return this != null && this.value instanceof UrlType;
        }

        public UuidType getValueUuidType() throws FHIRException {
            if (this.value == null) {
                this.value = new UuidType();
            }
            if (!(this.value instanceof UuidType)) {
                throw new FHIRException("Type mismatch: the type UuidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UuidType)this.value;
        }

        public boolean hasValueUuidType() {
            return this != null && this.value instanceof UuidType;
        }

        public Address getValueAddress() throws FHIRException {
            if (this.value == null) {
                this.value = new Address();
            }
            if (!(this.value instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Address)this.value;
        }

        public boolean hasValueAddress() {
            return this != null && this.value instanceof Address;
        }

        public Age getValueAge() throws FHIRException {
            if (this.value == null) {
                this.value = new Age();
            }
            if (!(this.value instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Age)this.value;
        }

        public boolean hasValueAge() {
            return this != null && this.value instanceof Age;
        }

        public Annotation getValueAnnotation() throws FHIRException {
            if (this.value == null) {
                this.value = new Annotation();
            }
            if (!(this.value instanceof Annotation)) {
                throw new FHIRException("Type mismatch: the type Annotation was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Annotation)this.value;
        }

        public boolean hasValueAnnotation() {
            return this != null && this.value instanceof Annotation;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public CodeableReference getValueCodeableReference() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableReference();
            }
            if (!(this.value instanceof CodeableReference)) {
                throw new FHIRException("Type mismatch: the type CodeableReference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableReference)this.value;
        }

        public boolean hasValueCodeableReference() {
            return this != null && this.value instanceof CodeableReference;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public ContactPoint getValueContactPoint() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactPoint();
            }
            if (!(this.value instanceof ContactPoint)) {
                throw new FHIRException("Type mismatch: the type ContactPoint was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactPoint)this.value;
        }

        public boolean hasValueContactPoint() {
            return this != null && this.value instanceof ContactPoint;
        }

        public Count getValueCount() throws FHIRException {
            if (this.value == null) {
                this.value = new Count();
            }
            if (!(this.value instanceof Count)) {
                throw new FHIRException("Type mismatch: the type Count was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Count)this.value;
        }

        public boolean hasValueCount() {
            return this != null && this.value instanceof Count;
        }

        public Distance getValueDistance() throws FHIRException {
            if (this.value == null) {
                this.value = new Distance();
            }
            if (!(this.value instanceof Distance)) {
                throw new FHIRException("Type mismatch: the type Distance was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Distance)this.value;
        }

        public boolean hasValueDistance() {
            return this != null && this.value instanceof Distance;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public HumanName getValueHumanName() throws FHIRException {
            if (this.value == null) {
                this.value = new HumanName();
            }
            if (!(this.value instanceof HumanName)) {
                throw new FHIRException("Type mismatch: the type HumanName was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (HumanName)this.value;
        }

        public boolean hasValueHumanName() {
            return this != null && this.value instanceof HumanName;
        }

        public Identifier getValueIdentifier() throws FHIRException {
            if (this.value == null) {
                this.value = new Identifier();
            }
            if (!(this.value instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Identifier)this.value;
        }

        public boolean hasValueIdentifier() {
            return this != null && this.value instanceof Identifier;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this != null && this.value instanceof Money;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public RatioRange getValueRatioRange() throws FHIRException {
            if (this.value == null) {
                this.value = new RatioRange();
            }
            if (!(this.value instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.value;
        }

        public boolean hasValueRatioRange() {
            return this != null && this.value instanceof RatioRange;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (this.value == null) {
                this.value = new SampledData();
            }
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this != null && this.value instanceof SampledData;
        }

        public Signature getValueSignature() throws FHIRException {
            if (this.value == null) {
                this.value = new Signature();
            }
            if (!(this.value instanceof Signature)) {
                throw new FHIRException("Type mismatch: the type Signature was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Signature)this.value;
        }

        public boolean hasValueSignature() {
            return this != null && this.value instanceof Signature;
        }

        public Timing getValueTiming() throws FHIRException {
            if (this.value == null) {
                this.value = new Timing();
            }
            if (!(this.value instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Timing)this.value;
        }

        public boolean hasValueTiming() {
            return this != null && this.value instanceof Timing;
        }

        public ContactDetail getValueContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactDetail();
            }
            if (!(this.value instanceof ContactDetail)) {
                throw new FHIRException("Type mismatch: the type ContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactDetail)this.value;
        }

        public boolean hasValueContactDetail() {
            return this != null && this.value instanceof ContactDetail;
        }

        public DataRequirement getValueDataRequirement() throws FHIRException {
            if (this.value == null) {
                this.value = new DataRequirement();
            }
            if (!(this.value instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.value;
        }

        public boolean hasValueDataRequirement() {
            return this != null && this.value instanceof DataRequirement;
        }

        public Expression getValueExpression() throws FHIRException {
            if (this.value == null) {
                this.value = new Expression();
            }
            if (!(this.value instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Expression)this.value;
        }

        public boolean hasValueExpression() {
            return this != null && this.value instanceof Expression;
        }

        public ParameterDefinition getValueParameterDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new ParameterDefinition();
            }
            if (!(this.value instanceof ParameterDefinition)) {
                throw new FHIRException("Type mismatch: the type ParameterDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ParameterDefinition)this.value;
        }

        public boolean hasValueParameterDefinition() {
            return this != null && this.value instanceof ParameterDefinition;
        }

        public RelatedArtifact getValueRelatedArtifact() throws FHIRException {
            if (this.value == null) {
                this.value = new RelatedArtifact();
            }
            if (!(this.value instanceof RelatedArtifact)) {
                throw new FHIRException("Type mismatch: the type RelatedArtifact was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RelatedArtifact)this.value;
        }

        public boolean hasValueRelatedArtifact() {
            return this != null && this.value instanceof RelatedArtifact;
        }

        public TriggerDefinition getValueTriggerDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new TriggerDefinition();
            }
            if (!(this.value instanceof TriggerDefinition)) {
                throw new FHIRException("Type mismatch: the type TriggerDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TriggerDefinition)this.value;
        }

        public boolean hasValueTriggerDefinition() {
            return this != null && this.value instanceof TriggerDefinition;
        }

        public UsageContext getValueUsageContext() throws FHIRException {
            if (this.value == null) {
                this.value = new UsageContext();
            }
            if (!(this.value instanceof UsageContext)) {
                throw new FHIRException("Type mismatch: the type UsageContext was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UsageContext)this.value;
        }

        public boolean hasValueUsageContext() {
            return this != null && this.value instanceof UsageContext;
        }

        public Availability getValueAvailability() throws FHIRException {
            if (this.value == null) {
                this.value = new Availability();
            }
            if (!(this.value instanceof Availability)) {
                throw new FHIRException("Type mismatch: the type Availability was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Availability)this.value;
        }

        public boolean hasValueAvailability() {
            return this != null && this.value instanceof Availability;
        }

        public ExtendedContactDetail getValueExtendedContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ExtendedContactDetail();
            }
            if (!(this.value instanceof ExtendedContactDetail)) {
                throw new FHIRException("Type mismatch: the type ExtendedContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ExtendedContactDetail)this.value;
        }

        public boolean hasValueExtendedContactDetail() {
            return this != null && this.value instanceof ExtendedContactDetail;
        }

        public Dosage getValueDosage() throws FHIRException {
            if (this.value == null) {
                this.value = new Dosage();
            }
            if (!(this.value instanceof Dosage)) {
                throw new FHIRException("Type mismatch: the type Dosage was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Dosage)this.value;
        }

        public boolean hasValueDosage() {
            return this != null && this.value instanceof Dosage;
        }

        public Meta getValueMeta() throws FHIRException {
            if (this.value == null) {
                this.value = new Meta();
            }
            if (!(this.value instanceof Meta)) {
                throw new FHIRException("Type mismatch: the type Meta was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Meta)this.value;
        }

        public boolean hasValueMeta() {
            return this != null && this.value instanceof Meta;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TransportOutputComponent setValue(DataType value) {
            if (!(value == null || value instanceof Base64BinaryType || value instanceof BooleanType || value instanceof CanonicalType || value instanceof CodeType || value instanceof DateType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof IdType || value instanceof InstantType || value instanceof IntegerType || value instanceof Integer64Type || value instanceof MarkdownType || value instanceof OidType || value instanceof PositiveIntType || value instanceof StringType || value instanceof TimeType || value instanceof UnsignedIntType || value instanceof UriType || value instanceof UrlType || value instanceof UuidType || value instanceof Address || value instanceof Age || value instanceof Annotation || value instanceof Attachment || value instanceof CodeableConcept || value instanceof CodeableReference || value instanceof Coding || value instanceof ContactPoint || value instanceof Count || value instanceof Distance || value instanceof Duration || value instanceof HumanName || value instanceof Identifier || value instanceof Money || value instanceof Period || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof RatioRange || value instanceof Reference || value instanceof SampledData || value instanceof Signature || value instanceof Timing || value instanceof ContactDetail || value instanceof DataRequirement || value instanceof Expression || value instanceof ParameterDefinition || value instanceof RelatedArtifact || value instanceof TriggerDefinition || value instanceof UsageContext || value instanceof Availability || value instanceof ExtendedContactDetail || value instanceof Dosage || value instanceof Meta)) {
                throw new FHIRException("Not the right type for Transport.output.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The name of the Output parameter.", 0, 1, this.type));
            children.add(new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The name of the Output parameter.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "canonical", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "code", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "instant", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1122120181: {
                    return new Property("value[x]", "integer64", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "markdown", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "oid", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "positiveInt", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "unsignedInt", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "url", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "uuid", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "Address", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410191922: {
                    return new Property("value[x]", "Age", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "Annotation", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -257955629: {
                    return new Property("value[x]", "CodeableReference", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "ContactPoint", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2017332766: {
                    return new Property("value[x]", "Count", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -456359802: {
                    return new Property("value[x]", "Distance", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "HumanName", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "Identifier", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -706454461: {
                    return new Property("value[x]", "RatioRange", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "SampledData", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "Signature", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "Timing", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1125200224: {
                    return new Property("value[x]", "ContactDetail", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1710554248: {
                    return new Property("value[x]", "DataRequirement", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -307517719: {
                    return new Property("value[x]", "Expression", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1387478187: {
                    return new Property("value[x]", "ParameterDefinition", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1748214124: {
                    return new Property("value[x]", "RelatedArtifact", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 976830394: {
                    return new Property("value[x]", "TriggerDefinition", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 588000479: {
                    return new Property("value[x]", "UsageContext", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1678530924: {
                    return new Property("value[x]", "Availability", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1567222041: {
                    return new Property("value[x]", "ExtendedContactDetail", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "Dosage", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765920490: {
                    return new Property("value[x]", "Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid", "Address", "Age", "Annotation", "Attachment", "CodeableConcept", "CodeableReference", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "RatioRange", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext", "Availability", "ExtendedContactDetail", "Dosage", "Meta"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueInteger64")) {
                this.value = new Integer64Type();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueUuid")) {
                this.value = new UuidType();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueAge")) {
                this.value = new Age();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCodeableReference")) {
                this.value = new CodeableReference();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueCount")) {
                this.value = new Count();
                return this.value;
            }
            if (name.equals("valueDistance")) {
                this.value = new Distance();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueRatioRange")) {
                this.value = new RatioRange();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueContactDetail")) {
                this.value = new ContactDetail();
                return this.value;
            }
            if (name.equals("valueDataRequirement")) {
                this.value = new DataRequirement();
                return this.value;
            }
            if (name.equals("valueExpression")) {
                this.value = new Expression();
                return this.value;
            }
            if (name.equals("valueParameterDefinition")) {
                this.value = new ParameterDefinition();
                return this.value;
            }
            if (name.equals("valueRelatedArtifact")) {
                this.value = new RelatedArtifact();
                return this.value;
            }
            if (name.equals("valueTriggerDefinition")) {
                this.value = new TriggerDefinition();
                return this.value;
            }
            if (name.equals("valueUsageContext")) {
                this.value = new UsageContext();
                return this.value;
            }
            if (name.equals("valueAvailability")) {
                this.value = new Availability();
                return this.value;
            }
            if (name.equals("valueExtendedContactDetail")) {
                this.value = new ExtendedContactDetail();
                return this.value;
            }
            if (name.equals("valueDosage")) {
                this.value = new Dosage();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public TransportOutputComponent copy() {
            TransportOutputComponent dst = new TransportOutputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TransportOutputComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TransportOutputComponent)) {
                return false;
            }
            TransportOutputComponent o = (TransportOutputComponent)other_;
            return TransportOutputComponent.compareDeep(this.type, o.type, true) && TransportOutputComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TransportOutputComponent)) {
                return false;
            }
            TransportOutputComponent o = (TransportOutputComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "Transport.output";
        }
    }

    @Block
    public static class ParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for the input", formalDefinition="A code or description indicating how the input is intended to be used as part of the transport execution.")
        protected CodeableConcept type;
        @Child(name="value", type={Base64BinaryType.class, BooleanType.class, CanonicalType.class, CodeType.class, DateType.class, DateTimeType.class, DecimalType.class, IdType.class, InstantType.class, IntegerType.class, Integer64Type.class, MarkdownType.class, OidType.class, PositiveIntType.class, StringType.class, TimeType.class, UnsignedIntType.class, UriType.class, UrlType.class, UuidType.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Availability.class, ExtendedContactDetail.class, Dosage.class, Meta.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Content to use in performing the transport", formalDefinition="The value of the input parameter as a basic type.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public ParameterComponent() {
        }

        public ParameterComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ParameterComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ParameterComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public CanonicalType getValueCanonicalType() throws FHIRException {
            if (this.value == null) {
                this.value = new CanonicalType();
            }
            if (!(this.value instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.value;
        }

        public boolean hasValueCanonicalType() {
            return this != null && this.value instanceof CanonicalType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (this.value == null) {
                this.value = new InstantType();
            }
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this != null && this.value instanceof InstantType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Integer64Type getValueInteger64Type() throws FHIRException {
            if (this.value == null) {
                this.value = new Integer64Type();
            }
            if (!(this.value instanceof Integer64Type)) {
                throw new FHIRException("Type mismatch: the type Integer64Type was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Integer64Type)this.value;
        }

        public boolean hasValueInteger64Type() {
            return this != null && this.value instanceof Integer64Type;
        }

        public MarkdownType getValueMarkdownType() throws FHIRException {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            if (!(this.value instanceof MarkdownType)) {
                throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (MarkdownType)this.value;
        }

        public boolean hasValueMarkdownType() {
            return this != null && this.value instanceof MarkdownType;
        }

        public OidType getValueOidType() throws FHIRException {
            if (this.value == null) {
                this.value = new OidType();
            }
            if (!(this.value instanceof OidType)) {
                throw new FHIRException("Type mismatch: the type OidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (OidType)this.value;
        }

        public boolean hasValueOidType() {
            return this != null && this.value instanceof OidType;
        }

        public PositiveIntType getValuePositiveIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new PositiveIntType();
            }
            if (!(this.value instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.value;
        }

        public boolean hasValuePositiveIntType() {
            return this != null && this.value instanceof PositiveIntType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public UnsignedIntType getValueUnsignedIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new UnsignedIntType();
            }
            if (!(this.value instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.value;
        }

        public boolean hasValueUnsignedIntType() {
            return this != null && this.value instanceof UnsignedIntType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public UrlType getValueUrlType() throws FHIRException {
            if (this.value == null) {
                this.value = new UrlType();
            }
            if (!(this.value instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UrlType)this.value;
        }

        public boolean hasValueUrlType() {
            return this != null && this.value instanceof UrlType;
        }

        public UuidType getValueUuidType() throws FHIRException {
            if (this.value == null) {
                this.value = new UuidType();
            }
            if (!(this.value instanceof UuidType)) {
                throw new FHIRException("Type mismatch: the type UuidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UuidType)this.value;
        }

        public boolean hasValueUuidType() {
            return this != null && this.value instanceof UuidType;
        }

        public Address getValueAddress() throws FHIRException {
            if (this.value == null) {
                this.value = new Address();
            }
            if (!(this.value instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Address)this.value;
        }

        public boolean hasValueAddress() {
            return this != null && this.value instanceof Address;
        }

        public Age getValueAge() throws FHIRException {
            if (this.value == null) {
                this.value = new Age();
            }
            if (!(this.value instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Age)this.value;
        }

        public boolean hasValueAge() {
            return this != null && this.value instanceof Age;
        }

        public Annotation getValueAnnotation() throws FHIRException {
            if (this.value == null) {
                this.value = new Annotation();
            }
            if (!(this.value instanceof Annotation)) {
                throw new FHIRException("Type mismatch: the type Annotation was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Annotation)this.value;
        }

        public boolean hasValueAnnotation() {
            return this != null && this.value instanceof Annotation;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public CodeableReference getValueCodeableReference() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableReference();
            }
            if (!(this.value instanceof CodeableReference)) {
                throw new FHIRException("Type mismatch: the type CodeableReference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableReference)this.value;
        }

        public boolean hasValueCodeableReference() {
            return this != null && this.value instanceof CodeableReference;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public ContactPoint getValueContactPoint() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactPoint();
            }
            if (!(this.value instanceof ContactPoint)) {
                throw new FHIRException("Type mismatch: the type ContactPoint was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactPoint)this.value;
        }

        public boolean hasValueContactPoint() {
            return this != null && this.value instanceof ContactPoint;
        }

        public Count getValueCount() throws FHIRException {
            if (this.value == null) {
                this.value = new Count();
            }
            if (!(this.value instanceof Count)) {
                throw new FHIRException("Type mismatch: the type Count was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Count)this.value;
        }

        public boolean hasValueCount() {
            return this != null && this.value instanceof Count;
        }

        public Distance getValueDistance() throws FHIRException {
            if (this.value == null) {
                this.value = new Distance();
            }
            if (!(this.value instanceof Distance)) {
                throw new FHIRException("Type mismatch: the type Distance was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Distance)this.value;
        }

        public boolean hasValueDistance() {
            return this != null && this.value instanceof Distance;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public HumanName getValueHumanName() throws FHIRException {
            if (this.value == null) {
                this.value = new HumanName();
            }
            if (!(this.value instanceof HumanName)) {
                throw new FHIRException("Type mismatch: the type HumanName was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (HumanName)this.value;
        }

        public boolean hasValueHumanName() {
            return this != null && this.value instanceof HumanName;
        }

        public Identifier getValueIdentifier() throws FHIRException {
            if (this.value == null) {
                this.value = new Identifier();
            }
            if (!(this.value instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Identifier)this.value;
        }

        public boolean hasValueIdentifier() {
            return this != null && this.value instanceof Identifier;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this != null && this.value instanceof Money;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public RatioRange getValueRatioRange() throws FHIRException {
            if (this.value == null) {
                this.value = new RatioRange();
            }
            if (!(this.value instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.value;
        }

        public boolean hasValueRatioRange() {
            return this != null && this.value instanceof RatioRange;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (this.value == null) {
                this.value = new SampledData();
            }
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this != null && this.value instanceof SampledData;
        }

        public Signature getValueSignature() throws FHIRException {
            if (this.value == null) {
                this.value = new Signature();
            }
            if (!(this.value instanceof Signature)) {
                throw new FHIRException("Type mismatch: the type Signature was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Signature)this.value;
        }

        public boolean hasValueSignature() {
            return this != null && this.value instanceof Signature;
        }

        public Timing getValueTiming() throws FHIRException {
            if (this.value == null) {
                this.value = new Timing();
            }
            if (!(this.value instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Timing)this.value;
        }

        public boolean hasValueTiming() {
            return this != null && this.value instanceof Timing;
        }

        public ContactDetail getValueContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactDetail();
            }
            if (!(this.value instanceof ContactDetail)) {
                throw new FHIRException("Type mismatch: the type ContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactDetail)this.value;
        }

        public boolean hasValueContactDetail() {
            return this != null && this.value instanceof ContactDetail;
        }

        public DataRequirement getValueDataRequirement() throws FHIRException {
            if (this.value == null) {
                this.value = new DataRequirement();
            }
            if (!(this.value instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.value;
        }

        public boolean hasValueDataRequirement() {
            return this != null && this.value instanceof DataRequirement;
        }

        public Expression getValueExpression() throws FHIRException {
            if (this.value == null) {
                this.value = new Expression();
            }
            if (!(this.value instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Expression)this.value;
        }

        public boolean hasValueExpression() {
            return this != null && this.value instanceof Expression;
        }

        public ParameterDefinition getValueParameterDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new ParameterDefinition();
            }
            if (!(this.value instanceof ParameterDefinition)) {
                throw new FHIRException("Type mismatch: the type ParameterDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ParameterDefinition)this.value;
        }

        public boolean hasValueParameterDefinition() {
            return this != null && this.value instanceof ParameterDefinition;
        }

        public RelatedArtifact getValueRelatedArtifact() throws FHIRException {
            if (this.value == null) {
                this.value = new RelatedArtifact();
            }
            if (!(this.value instanceof RelatedArtifact)) {
                throw new FHIRException("Type mismatch: the type RelatedArtifact was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RelatedArtifact)this.value;
        }

        public boolean hasValueRelatedArtifact() {
            return this != null && this.value instanceof RelatedArtifact;
        }

        public TriggerDefinition getValueTriggerDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new TriggerDefinition();
            }
            if (!(this.value instanceof TriggerDefinition)) {
                throw new FHIRException("Type mismatch: the type TriggerDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TriggerDefinition)this.value;
        }

        public boolean hasValueTriggerDefinition() {
            return this != null && this.value instanceof TriggerDefinition;
        }

        public UsageContext getValueUsageContext() throws FHIRException {
            if (this.value == null) {
                this.value = new UsageContext();
            }
            if (!(this.value instanceof UsageContext)) {
                throw new FHIRException("Type mismatch: the type UsageContext was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UsageContext)this.value;
        }

        public boolean hasValueUsageContext() {
            return this != null && this.value instanceof UsageContext;
        }

        public Availability getValueAvailability() throws FHIRException {
            if (this.value == null) {
                this.value = new Availability();
            }
            if (!(this.value instanceof Availability)) {
                throw new FHIRException("Type mismatch: the type Availability was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Availability)this.value;
        }

        public boolean hasValueAvailability() {
            return this != null && this.value instanceof Availability;
        }

        public ExtendedContactDetail getValueExtendedContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ExtendedContactDetail();
            }
            if (!(this.value instanceof ExtendedContactDetail)) {
                throw new FHIRException("Type mismatch: the type ExtendedContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ExtendedContactDetail)this.value;
        }

        public boolean hasValueExtendedContactDetail() {
            return this != null && this.value instanceof ExtendedContactDetail;
        }

        public Dosage getValueDosage() throws FHIRException {
            if (this.value == null) {
                this.value = new Dosage();
            }
            if (!(this.value instanceof Dosage)) {
                throw new FHIRException("Type mismatch: the type Dosage was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Dosage)this.value;
        }

        public boolean hasValueDosage() {
            return this != null && this.value instanceof Dosage;
        }

        public Meta getValueMeta() throws FHIRException {
            if (this.value == null) {
                this.value = new Meta();
            }
            if (!(this.value instanceof Meta)) {
                throw new FHIRException("Type mismatch: the type Meta was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Meta)this.value;
        }

        public boolean hasValueMeta() {
            return this != null && this.value instanceof Meta;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ParameterComponent setValue(DataType value) {
            if (!(value == null || value instanceof Base64BinaryType || value instanceof BooleanType || value instanceof CanonicalType || value instanceof CodeType || value instanceof DateType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof IdType || value instanceof InstantType || value instanceof IntegerType || value instanceof Integer64Type || value instanceof MarkdownType || value instanceof OidType || value instanceof PositiveIntType || value instanceof StringType || value instanceof TimeType || value instanceof UnsignedIntType || value instanceof UriType || value instanceof UrlType || value instanceof UuidType || value instanceof Address || value instanceof Age || value instanceof Annotation || value instanceof Attachment || value instanceof CodeableConcept || value instanceof CodeableReference || value instanceof Coding || value instanceof ContactPoint || value instanceof Count || value instanceof Distance || value instanceof Duration || value instanceof HumanName || value instanceof Identifier || value instanceof Money || value instanceof Period || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof RatioRange || value instanceof Reference || value instanceof SampledData || value instanceof Signature || value instanceof Timing || value instanceof ContactDetail || value instanceof DataRequirement || value instanceof Expression || value instanceof ParameterDefinition || value instanceof RelatedArtifact || value instanceof TriggerDefinition || value instanceof UsageContext || value instanceof Availability || value instanceof ExtendedContactDetail || value instanceof Dosage || value instanceof Meta)) {
                throw new FHIRException("Not the right type for Transport.input.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code or description indicating how the input is intended to be used as part of the transport execution.", 0, 1, this.type));
            children.add(new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the input parameter as a basic type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code or description indicating how the input is intended to be used as part of the transport execution.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "canonical", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "code", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "instant", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1122120181: {
                    return new Property("value[x]", "integer64", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "markdown", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "oid", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "positiveInt", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "unsignedInt", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "url", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "uuid", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "Address", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410191922: {
                    return new Property("value[x]", "Age", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "Annotation", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -257955629: {
                    return new Property("value[x]", "CodeableReference", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "ContactPoint", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2017332766: {
                    return new Property("value[x]", "Count", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -456359802: {
                    return new Property("value[x]", "Distance", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "HumanName", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "Identifier", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -706454461: {
                    return new Property("value[x]", "RatioRange", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "SampledData", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "Signature", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "Timing", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1125200224: {
                    return new Property("value[x]", "ContactDetail", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1710554248: {
                    return new Property("value[x]", "DataRequirement", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -307517719: {
                    return new Property("value[x]", "Expression", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1387478187: {
                    return new Property("value[x]", "ParameterDefinition", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1748214124: {
                    return new Property("value[x]", "RelatedArtifact", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 976830394: {
                    return new Property("value[x]", "TriggerDefinition", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 588000479: {
                    return new Property("value[x]", "UsageContext", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1678530924: {
                    return new Property("value[x]", "Availability", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1567222041: {
                    return new Property("value[x]", "ExtendedContactDetail", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "Dosage", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765920490: {
                    return new Property("value[x]", "Meta", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid", "Address", "Age", "Annotation", "Attachment", "CodeableConcept", "CodeableReference", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "RatioRange", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext", "Availability", "ExtendedContactDetail", "Dosage", "Meta"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueInteger64")) {
                this.value = new Integer64Type();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueUuid")) {
                this.value = new UuidType();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueAge")) {
                this.value = new Age();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCodeableReference")) {
                this.value = new CodeableReference();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueCount")) {
                this.value = new Count();
                return this.value;
            }
            if (name.equals("valueDistance")) {
                this.value = new Distance();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueRatioRange")) {
                this.value = new RatioRange();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueContactDetail")) {
                this.value = new ContactDetail();
                return this.value;
            }
            if (name.equals("valueDataRequirement")) {
                this.value = new DataRequirement();
                return this.value;
            }
            if (name.equals("valueExpression")) {
                this.value = new Expression();
                return this.value;
            }
            if (name.equals("valueParameterDefinition")) {
                this.value = new ParameterDefinition();
                return this.value;
            }
            if (name.equals("valueRelatedArtifact")) {
                this.value = new RelatedArtifact();
                return this.value;
            }
            if (name.equals("valueTriggerDefinition")) {
                this.value = new TriggerDefinition();
                return this.value;
            }
            if (name.equals("valueUsageContext")) {
                this.value = new UsageContext();
                return this.value;
            }
            if (name.equals("valueAvailability")) {
                this.value = new Availability();
                return this.value;
            }
            if (name.equals("valueExtendedContactDetail")) {
                this.value = new ExtendedContactDetail();
                return this.value;
            }
            if (name.equals("valueDosage")) {
                this.value = new Dosage();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ParameterComponent copy() {
            ParameterComponent dst = new ParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ParameterComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ParameterComponent)) {
                return false;
            }
            ParameterComponent o = (ParameterComponent)other_;
            return ParameterComponent.compareDeep(this.type, o.type, true) && ParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ParameterComponent)) {
                return false;
            }
            ParameterComponent o = (ParameterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "Transport.input";
        }
    }

    @Block
    public static class TransportRestrictionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="repetitions", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many times to repeat", formalDefinition="Indicates the number of times the requested action should occur.")
        protected PositiveIntType repetitions;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When fulfillment sought", formalDefinition="Over what time-period is fulfillment sought.")
        protected Period period;
        @Child(name="recipient", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Group.class, Organization.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="For whom is fulfillment sought?", formalDefinition="For requests that are targeted to more than one potential recipient/target, to identify who is fulfillment is sought for.")
        protected List<Reference> recipient;
        private static final long serialVersionUID = 1673996066L;

        public PositiveIntType getRepetitionsElement() {
            if (this.repetitions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TransportRestrictionComponent.repetitions");
                }
                if (Configuration.doAutoCreate()) {
                    this.repetitions = new PositiveIntType();
                }
            }
            return this.repetitions;
        }

        public boolean hasRepetitionsElement() {
            return this.repetitions != null && !this.repetitions.isEmpty();
        }

        public boolean hasRepetitions() {
            return this.repetitions != null && !this.repetitions.isEmpty();
        }

        public TransportRestrictionComponent setRepetitionsElement(PositiveIntType value) {
            this.repetitions = value;
            return this;
        }

        public int getRepetitions() {
            return this.repetitions == null || this.repetitions.isEmpty() ? 0 : (Integer)this.repetitions.getValue();
        }

        public TransportRestrictionComponent setRepetitions(int value) {
            if (this.repetitions == null) {
                this.repetitions = new PositiveIntType();
            }
            this.repetitions.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TransportRestrictionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public TransportRestrictionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getRecipient() {
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            return this.recipient;
        }

        public TransportRestrictionComponent setRecipient(List<Reference> theRecipient) {
            this.recipient = theRecipient;
            return this;
        }

        public boolean hasRecipient() {
            if (this.recipient == null) {
                return false;
            }
            for (Reference item : this.recipient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRecipient() {
            Reference t = new Reference();
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            this.recipient.add(t);
            return t;
        }

        public TransportRestrictionComponent addRecipient(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            this.recipient.add(t);
            return this;
        }

        public Reference getRecipientFirstRep() {
            if (this.getRecipient().isEmpty()) {
                this.addRecipient();
            }
            return this.getRecipient().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("repetitions", "positiveInt", "Indicates the number of times the requested action should occur.", 0, 1, this.repetitions));
            children.add(new Property("period", "Period", "Over what time-period is fulfillment sought.", 0, 1, this.period));
            children.add(new Property("recipient", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Group|Organization)", "For requests that are targeted to more than one potential recipient/target, to identify who is fulfillment is sought for.", 0, Integer.MAX_VALUE, this.recipient));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 984367650: {
                    return new Property("repetitions", "positiveInt", "Indicates the number of times the requested action should occur.", 0, 1, this.repetitions);
                }
                case -991726143: {
                    return new Property("period", "Period", "Over what time-period is fulfillment sought.", 0, 1, this.period);
                }
                case 820081177: {
                    return new Property("recipient", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Group|Organization)", "For requests that are targeted to more than one potential recipient/target, to identify who is fulfillment is sought for.", 0, Integer.MAX_VALUE, this.recipient);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    Base[] baseArray;
                    if (this.repetitions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.repetitions;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 820081177: {
                    return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    this.repetitions = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 820081177: {
                    this.getRecipient().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("repetitions")) {
                this.repetitions = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("recipient")) {
                this.getRecipient().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    return this.getRepetitionsElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 820081177: {
                    return this.addRecipient();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    return new String[]{"positiveInt"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 820081177: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("repetitions")) {
                throw new FHIRException("Cannot call addChild on a primitive type Transport.restriction.repetitions");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("recipient")) {
                return this.addRecipient();
            }
            return super.addChild(name);
        }

        @Override
        public TransportRestrictionComponent copy() {
            TransportRestrictionComponent dst = new TransportRestrictionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TransportRestrictionComponent dst) {
            super.copyValues(dst);
            dst.repetitions = this.repetitions == null ? null : this.repetitions.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.recipient != null) {
                dst.recipient = new ArrayList<Reference>();
                for (Reference i : this.recipient) {
                    dst.recipient.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TransportRestrictionComponent)) {
                return false;
            }
            TransportRestrictionComponent o = (TransportRestrictionComponent)other_;
            return TransportRestrictionComponent.compareDeep(this.repetitions, o.repetitions, true) && TransportRestrictionComponent.compareDeep(this.period, o.period, true) && TransportRestrictionComponent.compareDeep(this.recipient, o.recipient, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TransportRestrictionComponent)) {
                return false;
            }
            TransportRestrictionComponent o = (TransportRestrictionComponent)other_;
            return TransportRestrictionComponent.compareValues(this.repetitions, o.repetitions, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.repetitions, this.period, this.recipient});
        }

        @Override
        public String fhirType() {
            return "Transport.restriction";
        }
    }

    public static class TransportStatusEnumFactory
    implements EnumFactory<TransportStatus> {
        @Override
        public TransportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return TransportStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return TransportStatus.COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return TransportStatus.ABANDONED;
            }
            if ("cancelled".equals(codeString)) {
                return TransportStatus.CANCELLED;
            }
            if ("planned".equals(codeString)) {
                return TransportStatus.PLANNED;
            }
            if ("entered-in-error".equals(codeString)) {
                return TransportStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown TransportStatus code '" + codeString + "'");
        }

        public Enumeration<TransportStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TransportStatus>(this, TransportStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.NULL, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.INPROGRESS, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.COMPLETED, code);
            }
            if ("abandoned".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.ABANDONED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.CANCELLED, code);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.PLANNED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<TransportStatus>(this, TransportStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown TransportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(TransportStatus code) {
            if (code == TransportStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == TransportStatus.COMPLETED) {
                return "completed";
            }
            if (code == TransportStatus.ABANDONED) {
                return "abandoned";
            }
            if (code == TransportStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == TransportStatus.PLANNED) {
                return "planned";
            }
            if (code == TransportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(TransportStatus code) {
            return code.getSystem();
        }
    }

    public static enum TransportStatus {
        INPROGRESS,
        COMPLETED,
        ABANDONED,
        CANCELLED,
        PLANNED,
        ENTEREDINERROR,
        NULL;


        public static TransportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return ABANDONED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TransportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ABANDONED: {
                    return "abandoned";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case PLANNED: {
                    return "planned";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/transport-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/transport-status";
                }
                case ABANDONED: {
                    return "http://hl7.org/fhir/transport-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/transport-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/transport-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/transport-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "Transport has started but not completed.";
                }
                case COMPLETED: {
                    return "Transport has been completed.";
                }
                case ABANDONED: {
                    return "Transport was started but not completed.";
                }
                case CANCELLED: {
                    return "Transport was cancelled before started.";
                }
                case PLANNED: {
                    return "Planned transport that is not yet requested.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"abandoned\" rather than \"entered-in-error\".).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ABANDONED: {
                    return "Abandoned";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case PLANNED: {
                    return "Planned";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class TransportIntentEnumFactory
    implements EnumFactory<TransportIntent> {
        @Override
        public TransportIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unknown".equals(codeString)) {
                return TransportIntent.UNKNOWN;
            }
            if ("proposal".equals(codeString)) {
                return TransportIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return TransportIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return TransportIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return TransportIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return TransportIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return TransportIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return TransportIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return TransportIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown TransportIntent code '" + codeString + "'");
        }

        public Enumeration<TransportIntent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TransportIntent>(this, TransportIntent.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.NULL, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.UNKNOWN, code);
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.PROPOSAL, code);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.PLAN, code);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.ORDER, code);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.ORIGINALORDER, code);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.REFLEXORDER, code);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.FILLERORDER, code);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.INSTANCEORDER, code);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<TransportIntent>(this, TransportIntent.OPTION, code);
            }
            throw new FHIRException("Unknown TransportIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(TransportIntent code) {
            if (code == TransportIntent.UNKNOWN) {
                return "unknown";
            }
            if (code == TransportIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == TransportIntent.PLAN) {
                return "plan";
            }
            if (code == TransportIntent.ORDER) {
                return "order";
            }
            if (code == TransportIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == TransportIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == TransportIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == TransportIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == TransportIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(TransportIntent code) {
            return code.getSystem();
        }
    }

    public static enum TransportIntent {
        UNKNOWN,
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static TransportIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TransportIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UNKNOWN: {
                    return "unknown";
                }
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UNKNOWN: {
                    return "http://hl7.org/fhir/transport-intent";
                }
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UNKNOWN: {
                    return "The intent is not known.  When dealing with Transport, it's not always known (or relevant) how the transport was initiated - i.e. whether it was proposed, planned, ordered or just done spontaneously.";
                }
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that does not have an intention to ensure it occurs and without providing an authorization to act.";
                }
                case PLAN: {
                    return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action by the requestor.";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action.";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization.";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order.";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestOrchestration that establishes timing, conditionality and/or other constraints among a set of requests.  Refer to [[[RequestOrchestration]]] for additional information on how this status is used.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UNKNOWN: {
                    return "Unknown";
                }
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

