/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemProvider;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.SpecialCodeSystem;
import org.hl7.fhir.r5.terminologies.URICodeSystem;
import org.hl7.fhir.r5.terminologies.ValueSetChecker;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetWorker;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class ValueSetCheckerSimple
extends ValueSetWorker
implements ValueSetChecker {
    private ValueSet valueset;
    private IWorkerContext context;
    private Map<String, ValueSetCheckerSimple> inner = new HashMap<String, ValueSetCheckerSimple>();
    private ValidationOptions options;
    private ValidationContextCarrier localContext;
    private List<CodeSystem> localSystems = new ArrayList<CodeSystem>();

    public ValueSetCheckerSimple(ValidationOptions options, ValueSet source, IWorkerContext context) {
        this.valueset = source;
        this.context = context;
        this.options = options;
    }

    public ValueSetCheckerSimple(ValidationOptions options, ValueSet source, IWorkerContext context, ValidationContextCarrier ctxt) {
        this.valueset = source;
        this.context = context;
        this.options = options.copy();
        this.options.setEnglishOk(true);
        this.localContext = ctxt;
        this.analyseValueSet();
    }

    private void analyseValueSet() {
        if (this.localContext != null && this.valueset != null) {
            for (ValueSet.ConceptSetComponent i : this.valueset.getCompose().getInclude()) {
                this.analyseComponent(i);
            }
            for (ValueSet.ConceptSetComponent i : this.valueset.getCompose().getExclude()) {
                this.analyseComponent(i);
            }
        }
    }

    private void analyseComponent(ValueSet.ConceptSetComponent i) {
        if (i.getSystemElement().hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-system")) {
            String ref = i.getSystemElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-system");
            if (ref.startsWith("#")) {
                String id = ref.substring(1);
                for (ValidationContextCarrier.ValidationContextResourceProxy t : this.localContext.getResources()) {
                    CodeSystem cs = (CodeSystem)t.loadContainedResource(id, CodeSystem.class);
                    if (cs == null) continue;
                    this.localSystems.add(cs);
                }
            } else {
                throw new Error("Not done yet #2: " + ref);
            }
        }
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        return this.validateCode("CodeableConcept", code);
    }

    public IWorkerContext.ValidationResult validateCode(String path, CodeableConcept code) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent cd;
        ValueSetChecker.ValidationProcessInfo info = new ValueSetChecker.ValidationProcessInfo();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            int i = 0;
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) {
                    info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.UNKNOWN, path, this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0])));
                }
                CodeSystem cs = this.resolveCodeSystem(c.getSystem(), c.getVersion());
                IWorkerContext.ValidationResult res = null;
                if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) {
                    if (this.context.isNoTerminologyServer()) {
                        String msg;
                        if (c.hasVersion()) {
                            msg = this.context.formatMessage("UNKNOWN_CODESYSTEM_VERSION", c.getSystem(), c.getVersion(), this.resolveCodeSystemVersions(c.getSystem()).toString());
                            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "].system", msg));
                        } else {
                            msg = this.context.formatMessage("UNKNOWN_CODESYSTEM", c.getSystem(), c.getVersion());
                            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "].system", msg));
                        }
                    } else {
                        res = this.context.validateCode(this.options.withNoClient(), c, null);
                    }
                } else {
                    res = this.validateCode(path + ".coding[" + i + "]", c, cs);
                }
                info.getIssues().addAll(res.getIssues());
                ++i;
            }
        }
        Coding foundCoding = null;
        if (this.valueset != null && this.options.getValueSetMode() != ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) {
            String msg;
            Boolean result = false;
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(", ");
            for (Coding c : code.getCoding()) {
                b.append(c.getSystem() + (String)(c.hasVersion() ? "|" + c.getVersion() : "") + "#" + c.getCode());
                Boolean ok = this.codeInValueSet(c.getSystem(), c.getVersion(), c.getCode(), info);
                if (ok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!ok.booleanValue()) continue;
                result = true;
                foundCoding = c;
            }
            if (result == null) {
                msg = this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_", this.valueset.getUrl(), b.toString());
                info.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path, msg));
            } else if (!result.booleanValue()) {
                msg = this.context.formatMessagePlural(code.getCoding().size(), "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getUrl(), b.toString());
                info.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path, msg));
            }
        }
        if (info.hasErrors()) {
            IWorkerContext.ValidationResult res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, info.summary(), info.getIssues());
            if (foundCoding != null) {
                cd = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
                cd.setDisplay(this.lookupDisplay(foundCoding));
                res.setDefinition(cd);
                res.setSystem(foundCoding.getSystem());
                res.setDisplay(cd.getDisplay());
            }
            return res;
        }
        if (foundCoding == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Internal Error that should not happen", this.makeIssue(ValidationMessage.IssueSeverity.FATAL, OperationOutcome.IssueType.EXCEPTION, path, "Internal Error that should not happen"));
        }
        if (info.getIssues().size() > 0) {
            String disp = this.lookupDisplay(foundCoding);
            cd = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
            cd.setDisplay(disp);
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, info.summary(), foundCoding.getSystem(), cd, disp, info.getIssues());
        }
        CodeSystem.ConceptDefinitionComponent cd2 = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
        cd2.setDisplay(this.lookupDisplay(foundCoding));
        return new IWorkerContext.ValidationResult(foundCoding.getSystem(), cd2, this.getPreferredDisplay(cd2, null));
    }

    private String lookupDisplay(Coding c) {
        CodeSystem.ConceptDefinitionComponent cd;
        CodeSystem cs = this.resolveCodeSystem(c.getSystem(), c.getVersion());
        if (cs != null && (cd = CodeSystemUtilities.getCode(cs, c.getCode())) != null) {
            return this.getPreferredDisplay(cd, cs);
        }
        return null;
    }

    public CodeSystem resolveCodeSystem(String system, String version) {
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !this.versionsMatch(version, t.getVersion())) continue;
            return t;
        }
        CodeSystem cs = this.context.fetchCodeSystem(system, version);
        if (cs == null) {
            cs = this.findSpecialCodeSystem(system, version);
        }
        return cs;
    }

    public List<String> resolveCodeSystemVersions(String system) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !t.hasVersion()) continue;
            res.add(t.getVersion());
        }
        res.addAll(new ContextUtilities(this.context).fetchCodeSystemVersions(system));
        return res;
    }

    private boolean versionsMatch(String versionTest, String versionActual) {
        return versionTest == null && VersionUtilities.versionsMatch((String)versionTest, (String)versionActual);
    }

    private List<OperationOutcome.OperationOutcomeIssueComponent> makeIssue(ValidationMessage.IssueSeverity level, OperationOutcome.IssueType type, String location, String message) {
        OperationOutcome.OperationOutcomeIssueComponent result = new OperationOutcome.OperationOutcomeIssueComponent();
        switch (level) {
            case ERROR: {
                result.setSeverity(OperationOutcome.IssueSeverity.ERROR);
                break;
            }
            case FATAL: {
                result.setSeverity(OperationOutcome.IssueSeverity.FATAL);
                break;
            }
            case INFORMATION: {
                result.setSeverity(OperationOutcome.IssueSeverity.INFORMATION);
                break;
            }
            case WARNING: {
                result.setSeverity(OperationOutcome.IssueSeverity.WARNING);
            }
        }
        result.setCode(type);
        result.addLocation(location);
        result.getDetails().setText(message);
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> list = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        list.add(result);
        return list;
    }

    public IWorkerContext.ValidationResult validateCode(Coding code) throws FHIRException {
        return this.validateCode("Coding", code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IWorkerContext.ValidationResult validateCode(String path, Coding code) throws FHIRException {
        String system;
        Object warningMessage = null;
        IWorkerContext.ValidationResult res = null;
        boolean inExpansion = false;
        boolean inInclude = false;
        String string = system = code.hasSystem() ? code.getSystem() : this.getValueSetSystemOrNull();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            if (system == null && !code.hasDisplay()) {
                ArrayList<String> problems = new ArrayList<String>();
                system = this.systemForCodeInValueSet(code.getCode(), problems);
                if (system == null) {
                    if (problems.size() == 0) {
                        throw new Error("Unable to resolve systems but no reason why");
                    }
                    if (problems.size() == 1) {
                        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, (String)problems.get(0), this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.UNKNOWN, path, (String)problems.get(0)));
                    }
                    IWorkerContext.ValidationResult vr = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)problems).toString(), null);
                    Iterator iterator = problems.iterator();
                    while (iterator.hasNext()) {
                        String s = (String)iterator.next();
                        vr.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.UNKNOWN, path, s));
                    }
                    return vr;
                }
            }
            if (!code.hasSystem()) {
                if (this.options.isGuessSystem() && system == null && Utilities.isAbsoluteUrl((String)code.getCode())) {
                    system = "urn:ietf:rfc:3986";
                }
                code.setSystem(system);
            }
            inExpansion = this.checkExpansion(code);
            inInclude = this.checkInclude(code);
            CodeSystem cs = this.resolveCodeSystem(system, code.getVersion());
            if (cs == null) {
                warningMessage = code.getVersion() == null ? this.context.formatMessage("UNKNOWN_CODESYSTEM", system) : this.context.formatMessage("UNKNOWN_CODESYSTEM_VERSION", system, code.getVersion(), this.resolveCodeSystemVersions(system).toString());
                if (!inExpansion) {
                    if (this.valueset != null && this.valueset.hasExpansion()) {
                        String msg = this.context.formatMessage("CODESYSTEM_CS_UNK_EXPANSION", this.valueset.getUrl(), code.getSystem(), code.getCode().toString());
                        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
                        issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path, msg));
                        throw new VSCheckerException(msg, issues);
                    }
                    ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
                    issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".system", (String)warningMessage));
                    if (this.valueset == null) {
                        throw new VSCheckerException((String)warningMessage, issues);
                    }
                    String msg = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getUrl(), code.toString());
                    issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path, msg));
                    throw new VSCheckerException((String)warningMessage + "; " + msg, issues);
                }
            }
            if (cs != null && cs.hasSupplements()) {
                String msg = this.context.formatMessage("CODESYSTEM_CS_NO_SUPPLEMENT", cs.getUrl());
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path, msg));
            }
            if (cs != null && cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) {
                warningMessage = "Resolved system " + system + (String)(cs.hasVersion() ? " (v" + cs.getVersion() + ")" : "") + ", but the definition is not complete";
                if (!inExpansion && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                    throw new VSCheckerException((String)warningMessage, null);
                }
            }
            if (cs != null) {
                if (cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                    if (!inInclude) throw new FHIRException("Unable to evaluate based on empty code system");
                    ValueSet.ConceptReferenceComponent cc = this.findInInclude(code);
                    if (cc == null) throw new FHIRException("Unable to evaluate based on empty code system");
                    String disp = this.getPreferredDisplay(cc);
                    res = new IWorkerContext.ValidationResult(system, new CodeSystem.ConceptDefinitionComponent().setCode(cc.getCode()).setDisplay(disp), disp);
                    res.setMessage("Resolved system " + system + ", but the definition is not complete, so assuming value set include is correct");
                    return res;
                }
                res = this.validateCode(path, code, cs);
            } else {
                if (cs != null) throw new FHIRException("No try the server");
                if (!this.valueset.hasExpansion()) throw new FHIRException("No try the server");
                if (!inExpansion) throw new FHIRException("No try the server");
                res = new IWorkerContext.ValidationResult(system, new CodeSystem.ConceptDefinitionComponent().setCode(code.getCode()).setDisplay(code.getDisplay()), code.getDisplay());
            }
        } else {
            inExpansion = this.checkExpansion(code);
            inInclude = this.checkInclude(code);
        }
        ValueSetChecker.ValidationProcessInfo info = new ValueSetChecker.ValidationProcessInfo();
        if (this.valueset == null) return res;
        if (this.options.getValueSetMode() == ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) return res;
        if (res == null || res.isOk()) {
            Boolean ok = this.codeInValueSet(system, code.getVersion(), code.getCode(), info);
            if (ok != null) {
                if (ok != false) return res;
            }
            if (res == null) {
                res = new IWorkerContext.ValidationResult((ValidationMessage.IssueSeverity)null, null, info.getIssues());
            }
            if (info.getErr() != null) {
                res.setErrorClass(info.getErr());
            }
            if (ok == null) {
                res.setMessage("Unable to check whether code is in value set " + this.valueset.getUrl() + ": " + info.summary()).setSeverity(ValidationMessage.IssueSeverity.WARNING);
                res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage()));
                return res;
            } else if (!inExpansion && !inInclude) {
                if (!info.getIssues().isEmpty()) {
                    res.setMessage("Not in value set " + this.valueset.getUrl() + ": " + info.summary()).setSeverity(ValidationMessage.IssueSeverity.ERROR);
                    res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path, res.getMessage()));
                    return res;
                } else {
                    String msg = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getUrl(), code.toString());
                    res.setMessage(msg).setSeverity(ValidationMessage.IssueSeverity.ERROR);
                    res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path, msg));
                    res.setDefinition(null);
                    res.setSystem(null);
                    res.setDisplay(null);
                }
                return res;
            } else {
                if (warningMessage != null) {
                    String msg = this.context.formatMessage("Code_found_in_expansion_however_", warningMessage);
                    return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, msg));
                }
                if (inExpansion) {
                    res.setMessage("Code found in expansion, however: " + res.getMessage());
                    res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage()));
                    return res;
                } else {
                    if (!inInclude) return res;
                    res.setMessage("Code found in include, however: " + res.getMessage());
                    res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage()));
                }
            }
            return res;
        } else {
            if (res == null) return res;
            if (res.isOk()) return res;
            String msg = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getUrl(), code.toString());
            res.setMessage(res.getMessage() + "; " + msg);
            res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path, msg));
        }
        return res;
    }

    private boolean checkInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return false;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getExclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return false;
            }
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSet.ConceptReferenceComponent findInInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem findSpecialCodeSystem(String system, String version) {
        if ("urn:ietf:rfc:3986".equals(system)) {
            CodeSystem cs = new CodeSystem();
            cs.setUrl(system);
            cs.setUserData("tx.cs.special", new URICodeSystem());
            cs.setContent(Enumerations.CodeSystemContentMode.COMPLETE);
            return cs;
        }
        return null;
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return null;
        }
        return this.findCodeInExpansion(code, this.valueset.getExpansion().getContains());
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            IWorkerContext.ValidationResult res;
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                CodeSystem.ConceptDefinitionComponent ccd = new CodeSystem.ConceptDefinitionComponent();
                ccd.setCode(containsComponent.getCode());
                ccd.setDisplay(containsComponent.getDisplay());
                IWorkerContext.ValidationResult res2 = new IWorkerContext.ValidationResult(code.getSystem(), ccd, this.getPreferredDisplay(ccd, null));
                return res2;
            }
            if (!containsComponent.hasContains() || (res = this.findCodeInExpansion(code, containsComponent.getContains())) == null) continue;
            return res;
        }
        return null;
    }

    private boolean checkExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return false;
        }
        return this.checkExpansion(code, this.valueset.getExpansion().getContains());
    }

    private boolean checkExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                return true;
            }
            if (!containsComponent.hasContains() || !this.checkExpansion(code, containsComponent.getContains())) continue;
            return true;
        }
        return false;
    }

    private IWorkerContext.ValidationResult validateCode(String path, Coding code, CodeSystem cs) {
        String msg;
        ConceptReferencePair vs;
        CodeSystem.ConceptDefinitionComponent cc;
        CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = cc = cs.hasUserData("tx.cs.special") ? ((SpecialCodeSystem)cs.getUserData("tx.cs.special")).findConcept(code) : this.findCodeInConcept(cs.getConcept(), code.getCode());
        if (cc == null) {
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                String msg2 = this.context.formatMessage("UNKNOWN_CODE__IN_FRAGMENT", code.getCode(), cs.getUrl());
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg2, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path + ".code", msg2));
            }
            String msg3 = this.context.formatMessage("Unknown_Code__in_", code.getCode(), cs.getUrl());
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg3, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path + ".code", msg3));
        }
        if (code.getDisplay() == null) {
            return new IWorkerContext.ValidationResult(code.getSystem(), cc, this.getPreferredDisplay(cc, cs));
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay() && this.isOkLanguage(cs.getLanguage())) {
            b.append(cc.getDisplay());
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(code.getSystem(), cc, this.getPreferredDisplay(cc, cs));
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            if (!this.isOkLanguage(ds.getLanguage())) continue;
            b.append(ds.getValue());
            if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(code.getSystem(), cc, this.getPreferredDisplay(cc, cs));
        }
        if (this.options.isUseValueSetDisplays() && (vs = this.findValueSetRef(code.getSystem(), code.getCode())) != null && (vs.getCc().hasDisplay() || vs.getCc().hasDesignation())) {
            if (vs.getCc().hasDisplay() && this.isOkLanguage(vs.getValueset().getLanguage())) {
                b.append(vs.getCc().getDisplay());
                if (code.getDisplay().equalsIgnoreCase(vs.getCc().getDisplay())) {
                    return new IWorkerContext.ValidationResult(code.getSystem(), cc, this.getPreferredDisplay(cc, cs));
                }
            }
            for (ValueSet.ConceptReferenceDesignationComponent ds : vs.getCc().getDesignation()) {
                if (!this.isOkLanguage(ds.getLanguage())) continue;
                b.append(ds.getValue());
                if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
                return new IWorkerContext.ValidationResult(code.getSystem(), cc, this.getPreferredDisplay(cc, cs));
            }
        }
        if (b.count() == 0) {
            msg = this.context.formatMessagePlural(this.options.getLanguages().size(), "NO_VALID_DISPLAY_FOUND", code.getSystem(), code.getCode(), code.getDisplay(), this.options.langSummary());
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, code.getSystem(), cc, this.getPreferredDisplay(cc, cs), this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path + ".display", msg));
        }
        msg = this.context.formatMessagePlural(b.count(), "Display_Name_for__should_be_one_of__instead_of", code.getSystem(), code.getCode(), b.toString(), code.getDisplay(), this.options.langSummary());
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, code.getSystem(), cc, this.getPreferredDisplay(cc, cs), this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path + ".display", msg));
    }

    private boolean isOkLanguage(String language) {
        if (!this.options.hasLanguages()) {
            return true;
        }
        if (this.options.getLanguages().contains(language)) {
            return true;
        }
        return language == null && (this.options.getLanguages().contains("en") || this.options.getLanguages().contains("en-US") || this.options.isEnglishOk());
    }

    private ConceptReferencePair findValueSetRef(String system, String code) {
        if (this.valueset == null) {
            return null;
        }
        for (ValueSet.ValueSetExpansionContainsComponent exp : this.valueset.getExpansion().getContains()) {
            if (!system.equals(exp.getSystem()) || !code.equals(exp.getCode())) continue;
            ValueSet.ConceptReferenceComponent cc = new ValueSet.ConceptReferenceComponent();
            cc.setDisplay(exp.getDisplay());
            cc.setDesignation(exp.getDesignation());
            return new ConceptReferencePair(this.valueset, cc);
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (system.equals(inc.getSystem())) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    if (!cc.getCode().equals(code)) continue;
                    return new ConceptReferencePair(this.valueset, cc);
                }
            }
            for (CanonicalType url : inc.getValueSet()) {
                ConceptReferencePair cc = this.getVs(url.asStringValue()).findValueSetRef(system, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private String gen(Coding code) {
        if (code.hasSystem()) {
            return code.getSystem() + "#" + code.getCode();
        }
        return null;
    }

    private String getValueSetSystemOrNull() throws FHIRException {
        if (this.valueset == null) {
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            if (!this.valueset.hasExpansion() || this.valueset.getExpansion().getContains().size() == 0) {
                return null;
            }
            String cs = this.valueset.getExpansion().getContains().get(0).getSystem();
            if (cs != null && this.checkSystem(this.valueset.getExpansion().getContains(), cs)) {
                return cs;
            }
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                return null;
            }
            if (inc.hasSystem()) continue;
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private boolean checkSystem(List<ValueSet.ValueSetExpansionContainsComponent> containsList, String system) {
        for (ValueSet.ValueSetExpansionContainsComponent contains : containsList) {
            if (contains.getSystem().equals(system) && (!contains.hasContains() || this.checkSystem(contains.getContains(), system))) continue;
            return false;
        }
        return true;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(CodeSystem.ConceptDefinitionComponent concept, String code) {
        if (code.equals(concept.getCode())) {
            return concept;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(concept.getConcept(), code);
        if (cc != null) {
            return cc;
        }
        if (concept.hasUserData("cs.utils.cross.link")) {
            List children = (List)concept.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                cc = this.findCodeInConcept(c, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc, code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String systemForCodeInValueSet(String code, List<String> problems) {
        HashSet<String> sys = new HashSet<String>();
        if (!this.scanForCodeInValueSet(code, sys, problems)) {
            return null;
        }
        if (sys.size() != 1) {
            problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_multiple_matches", ((Object)sys).toString()));
            return null;
        }
        return (String)sys.iterator().next();
    }

    private boolean scanForCodeInValueSet(String code, Set<String> sys, List<String> problems) {
        if (this.valueset.hasCompose()) {
            if (!this.valueset.getCompose().hasInclude() && !this.valueset.getExpansion().hasContains()) {
                problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_no_includes_or_expansion", this.valueset.getVersionedUrl()));
            }
            int i = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                if (vsi.hasValueSet()) {
                    for (CanonicalType u : vsi.getValueSet()) {
                        if (this.checkForCodeInValueSet(code, (String)u.getValue(), sys, problems)) continue;
                        return false;
                    }
                } else if (!vsi.hasSystem()) {
                    problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", this.valueset.getVersionedUrl(), i));
                    return false;
                }
                if (vsi.hasSystem()) {
                    if (vsi.hasFilter()) {
                        problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", this.valueset.getVersionedUrl(), i, vsi.getSystem()));
                        return false;
                    }
                    CodeSystemProvider csp = CodeSystemProvider.factory(vsi.getSystem());
                    if (csp != null) {
                        Boolean ok = csp.checkCode(code);
                        if (ok == null) {
                            problems.add(this.context.formatMessage("UNABLE_TO_RESOLVE_SYSTEM_SYSTEM_IS_INDETERMINATE", this.valueset.getVersionedUrl(), vsi.getSystem()));
                            sys.add(vsi.getSystem());
                        } else if (ok.booleanValue()) {
                            sys.add(vsi.getSystem());
                        }
                    } else {
                        boolean match;
                        CodeSystem cs = this.resolveCodeSystem(vsi.getSystem(), vsi.getVersion());
                        if (cs != null && cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE) {
                            if (vsi.hasConcept()) {
                                for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                                    match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                                    if (!match) continue;
                                    sys.add(vsi.getSystem());
                                }
                            } else {
                                CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code);
                                if (cc != null) {
                                    sys.add(vsi.getSystem());
                                }
                            }
                        } else if (vsi.hasConcept()) {
                            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                                match = cc.getCode().equals(code);
                                if (!match) continue;
                                sys.add(vsi.getSystem());
                            }
                        } else {
                            ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(vsi, false, false);
                            if (vse.isOk()) {
                                if (!this.checkSystems(vse.getValueset().getExpansion().getContains(), code, sys, problems)) {
                                    return false;
                                }
                            } else {
                                problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_unknown_system", this.valueset.getVersionedUrl(), i, vsi.getSystem(), vse.getAllErrors().toString()));
                                return false;
                            }
                        }
                    }
                }
                ++i;
            }
        } else if (this.valueset.hasExpansion() && !this.checkSystems(this.valueset.getExpansion().getContains(), code, sys, problems)) {
            return false;
        }
        return true;
    }

    private boolean checkForCodeInValueSet(String code, String uri, Set<String> sys, List<String> problems) {
        ValueSetCheckerSimple vs = this.getVs(uri);
        return vs.scanForCodeInValueSet(code, sys, problems);
    }

    private boolean checkSystems(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code, Set<String> systems, List<String> problems) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            if (c.getCode().equals(code)) {
                systems.add(c.getSystem());
            }
            if (!c.hasContains()) continue;
            this.checkSystems(c.getContains(), code, systems, problems);
        }
        return true;
    }

    @Override
    public Boolean codeInValueSet(String system, String version, String code, ValueSetChecker.ValidationProcessInfo info) throws FHIRException {
        return this.codeInValueSet("code", system, version, code, info);
    }

    public Boolean codeInValueSet(String path, String system, String version, String code, ValueSetChecker.ValidationProcessInfo info) throws FHIRException {
        if (this.valueset == null) {
            return false;
        }
        Boolean result = false;
        if (this.valueset.hasExpansion()) {
            return this.checkExpansion(new Coding(system, code, null));
        }
        if (this.valueset.hasCompose()) {
            int i = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                Boolean ok = this.inComponent(path, vsi, i, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i;
                if (ok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!ok.booleanValue()) continue;
                result = true;
                break;
            }
            i = this.valueset.getCompose().getInclude().size();
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                Boolean nok = this.inComponent(path, vsi, i, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i;
                if (nok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (nok == null || !nok.booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    private Boolean inComponent(String path, ValueSet.ConceptSetComponent vsi, int vsiIndex, String system, String version, String code, boolean only, ValueSetChecker.ValidationProcessInfo info) throws FHIRException {
        List<CodeSystem.ConceptDefinitionComponent> list;
        boolean ok = true;
        if (vsi.hasValueSet()) {
            if (this.isValueSetUnionImports()) {
                ok = false;
                for (UriType uriType : vsi.getValueSet()) {
                    if (!this.inImport((String)uriType.getValue(), system, version, code)) continue;
                    return true;
                }
            } else {
                ok = this.inImport((String)vsi.getValueSet().get(0).getValue(), system, version, code);
                for (int i = 1; i < vsi.getValueSet().size(); ++i) {
                    UriType uriType = vsi.getValueSet().get(i);
                    ok = ok && this.inImport((String)uriType.getValue(), system, version, code);
                }
            }
        }
        if (!vsi.hasSystem() || !ok) {
            return ok;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (system == null || !system.equals(vsi.getSystem())) {
            return false;
        }
        CodeSystem cs = this.resolveCodeSystem(system, version);
        if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            ValueSet valueSet = new ValueSet();
            valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
            valueSet.setUrl(this.valueset.getUrl() + "--" + vsiIndex);
            valueSet.setVersion(this.valueset.getVersion());
            valueSet.getCompose().addInclude(vsi);
            IWorkerContext.ValidationResult res = this.context.validateCode(this.options.withNoClient(), new Coding(system, code, null), valueSet);
            if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN || res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED || res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED) {
                if (info != null && res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                    info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.UNKNOWN, path, this.context.formatMessage("Terminology_TX_System_NotKnown", system)));
                    for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                        if (!cc.getCode().equals(code)) continue;
                        return true;
                    }
                    info.setErr(ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                }
                return false;
            }
            if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE) {
                throw new NoTerminologyServiceException();
            }
            return res.isOk();
        }
        if (vsi.hasFilter()) {
            ok = true;
            for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
                if (this.codeInFilter(cs, system, f, code)) continue;
                return false;
            }
        }
        if ((ok = this.validateCodeInConceptList(code, cs, list = cs.getConcept())) && vsi.hasConcept()) {
            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                if (!cc.getCode().equals(code)) continue;
                return true;
            }
            return false;
        }
        return ok;
    }

    protected boolean isValueSetUnionImports() {
        PackageInformation p = this.valueset.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    private boolean codeInFilter(CodeSystem cs, String system, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        if ("concept".equals(f.getProperty())) {
            return this.codeInConceptFilter(cs, f, code);
        }
        if ("code".equals(f.getProperty()) && f.getOp() == Enumerations.FilterOperator.REGEX) {
            return this.codeInRegexFilter(cs, f, code);
        }
        System.out.println("todo: handle filters with property = " + f.getProperty() + " " + f.getOp().toCode());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__filter_with_property__", cs.getUrl(), f.getProperty(), f.getOp().toCode()));
    }

    private boolean codeInRegexFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        return code.matches(f.getValue());
    }

    private boolean codeInConceptFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        switch (f.getOp()) {
            case ISA: {
                return this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case ISNOTA: {
                return !this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case DESCENDENTOF: {
                return this.codeInConceptIsAFilter(cs, f, code, true);
            }
        }
        System.out.println("todo: handle concept filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__concept_filter_with_op__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInConceptIsAFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code, boolean rootOnly) {
        if (!rootOnly && code.equals(f.getProperty())) {
            return true;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), f.getValue());
        if (cc == null) {
            return false;
        }
        return (cc = this.findCodeInConcept(cc, code)) != null;
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list) {
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSetCheckerSimple getVs(String url) {
        if (this.inner.containsKey(url)) {
            return this.inner.get(url);
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, url, this.valueset);
        ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(this.options, vs, this.context, this.localContext);
        this.inner.put(url, vsc);
        return vsc;
    }

    private boolean inImport(String uri, String system, String version, String code) throws FHIRException {
        ValueSetCheckerSimple vs = this.getVs(uri);
        if (vs == null) {
            return false;
        }
        Boolean ok = vs.codeInValueSet(system, version, code, null);
        return ok != null && ok != false;
    }

    private String getPreferredDisplay(ValueSet.ConceptReferenceComponent cc) {
        if (!this.options.hasLanguages()) {
            return cc.getDisplay();
        }
        if (this.options.getLanguages().contains(this.valueset.getLanguage())) {
            return cc.getDisplay();
        }
        if (this.valueset.getLanguage() == null && (this.options.getLanguages().contains("en") || this.options.getLanguages().contains("en-US"))) {
            return cc.getDisplay();
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
            if (d.hasUse() || !this.options.getLanguages().contains(d.getLanguage())) continue;
            return d.getValue();
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
            if (!this.options.getLanguages().contains(d.getLanguage())) continue;
            return d.getValue();
        }
        return cc.getDisplay();
    }

    private String getPreferredDisplay(CodeSystem.ConceptDefinitionComponent cc, CodeSystem cs) {
        if (!this.options.hasLanguages()) {
            return cc.getDisplay();
        }
        if (cs != null && this.options.getLanguages().contains(cs.getLanguage())) {
            return cc.getDisplay();
        }
        if ((cs == null || cs.getLanguage() == null) && (this.options.getLanguages().contains("en") || this.options.getLanguages().contains("en-US"))) {
            return cc.getDisplay();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (d.hasUse() || !this.options.getLanguages().contains(d.getLanguage())) continue;
            return d.getValue();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (!this.options.getLanguages().contains(d.getLanguage())) continue;
            return d.getValue();
        }
        return cc.getDisplay();
    }

    public class ConceptReferencePair {
        private ValueSet valueset;
        private ValueSet.ConceptReferenceComponent cc;

        public ConceptReferencePair(ValueSet valueset, ValueSet.ConceptReferenceComponent cc) {
            this.valueset = valueset;
            this.cc = cc;
        }

        public ValueSet getValueset() {
            return this.valueset;
        }

        public ValueSet.ConceptReferenceComponent getCc() {
            return this.cc;
        }
    }

    public static class VSCheckerException
    extends FHIRException {
        private List<OperationOutcome.OperationOutcomeIssueComponent> issues;
        private static final long serialVersionUID = -5889505119633054187L;

        public VSCheckerException(String message, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
            super(message);
            this.issues = issues;
        }

        public List<OperationOutcome.OperationOutcomeIssueComponent> getIssues() {
            return this.issues;
        }
    }
}

