/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.CanonicalResourceComparer;
import org.hl7.fhir.r5.comparison.CapabilityStatementComparer;
import org.hl7.fhir.r5.comparison.CodeSystemComparer;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructureDefinitionComparer;
import org.hl7.fhir.r5.comparison.ValueSetComparer;
import org.hl7.fhir.r5.comparison.VersionComparisonAnnotation;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;

public class ComparisonSession {
    private Map<String, ResourceComparer.ResourceComparison> compares = new HashMap<String, ResourceComparer.ResourceComparison>();
    private IWorkerContext contextLeft;
    private IWorkerContext contextRight;
    private String sessiondId;
    private int count;
    private boolean debug;
    private boolean annotate;
    private String title;
    private ProfileKnowledgeProvider pkpLeft;
    private ProfileKnowledgeProvider pkpRight;

    public ComparisonSession(IWorkerContext contextLeft, IWorkerContext contextRight, String title, ProfileKnowledgeProvider pkpLeft, ProfileKnowledgeProvider pkpRight) {
        this.contextLeft = contextLeft;
        this.contextRight = contextRight;
        this.sessiondId = UUID.randomUUID().toString().toLowerCase();
        this.title = title;
        this.pkpLeft = pkpLeft;
        this.pkpRight = pkpRight;
        this.debug = false;
    }

    public IWorkerContext getContextLeft() {
        return this.contextLeft;
    }

    public IWorkerContext getContextRight() {
        return this.contextRight;
    }

    public String getTitle() {
        return this.title;
    }

    public ResourceComparer.ResourceComparison compare(String left, Resource leftSource, String right, Resource rightSource) throws DefinitionException, FHIRFormatError, IOException {
        CanonicalResource l = (CanonicalResource)this.contextLeft.fetchResource(Resource.class, left, leftSource);
        if (l == null) {
            throw new DefinitionException("Unable to resolve " + left);
        }
        CanonicalResource r = (CanonicalResource)this.contextRight.fetchResource(Resource.class, right, rightSource);
        if (r == null) {
            throw new DefinitionException("Unable to resolve " + right);
        }
        return this.compare(l, r);
    }

    public ResourceComparer.ResourceComparison compare(CanonicalResource left, CanonicalResource right) throws DefinitionException, FHIRFormatError, IOException {
        if (left != null && right != null) {
            String key = this.key(left.getUrl(), left.getVersion(), right.getUrl(), right.getVersion());
            if (this.compares.containsKey(key)) {
                return this.compares.get(key);
            }
            this.compares.put(key, null);
            try {
                if (left instanceof CodeSystem && right instanceof CodeSystem) {
                    CodeSystemComparer cs = new CodeSystemComparer(this);
                    CodeSystemComparer.CodeSystemComparison csc = cs.compare((CodeSystem)left, (CodeSystem)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                if (left instanceof ValueSet && right instanceof ValueSet) {
                    ValueSetComparer cs = new ValueSetComparer(this);
                    ValueSetComparer.ValueSetComparison csc = cs.compare((ValueSet)left, (ValueSet)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                if (left instanceof StructureDefinition && right instanceof StructureDefinition) {
                    StructureDefinitionComparer cs = new StructureDefinitionComparer(this, new ProfileUtilities(this.contextLeft, null, this.pkpLeft), new ProfileUtilities(this.contextRight, null, this.pkpRight));
                    StructureDefinitionComparer.ProfileComparison csc = cs.compare((StructureDefinition)left, (StructureDefinition)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                if (left instanceof CapabilityStatement && right instanceof CapabilityStatement) {
                    CapabilityStatementComparer cs = new CapabilityStatementComparer(this);
                    CapabilityStatementComparer.CapabilityStatementComparison csc = cs.compare((CapabilityStatement)left, (CapabilityStatement)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                throw new FHIRException("Unable to compare resources of type " + left.fhirType() + " and " + right.fhirType());
            }
            catch (Throwable e) {
                e.printStackTrace();
                ResourceComparer.PlaceHolderComparison csc = new ResourceComparer.PlaceHolderComparison(left, right, e);
                this.compares.put(key, csc);
                return csc;
            }
        }
        if (left != null) {
            this.markDeleted(null, left.fhirType(), left);
            String key = this.key(left.getUrl(), left.getVersion(), left.getUrl(), left.getVersion());
            if (this.compares.containsKey(key)) {
                return this.compares.get(key);
            }
            ResourceComparer.PlaceHolderComparison csc = new ResourceComparer.PlaceHolderComparison(left, right);
            this.compares.put(key, csc);
            return csc;
        }
        this.markAdded(right);
        String key = this.key(right.getUrl(), right.getVersion(), right.getUrl(), right.getVersion());
        if (this.compares.containsKey(key)) {
            return this.compares.get(key);
        }
        ResourceComparer.PlaceHolderComparison csc = new ResourceComparer.PlaceHolderComparison(left, right);
        this.compares.put(key, csc);
        return csc;
    }

    private String key(String urlL, String verL, String urlR, String verR) {
        return urlL + "|" + verL + "||" + urlR + "|" + verR;
    }

    public void identify(CanonicalResource res) {
        ++this.count;
        res.setId(this.sessiondId + "-" + this.count);
        res.setUrl("http://hl7.org/fhir/comparison/" + res.fhirType() + "/" + res.getId());
    }

    public void identify(ResourceComparer.ResourceComparison res) {
        ++this.count;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Map<String, ResourceComparer.ResourceComparison> getCompares() {
        return this.compares;
    }

    public ProfileKnowledgeProvider getPkpLeft() {
        return this.pkpLeft;
    }

    public ProfileKnowledgeProvider getPkpRight() {
        return this.pkpRight;
    }

    public boolean isAnnotate() {
        return this.annotate;
    }

    public void setAnnotate(boolean annotate) {
        this.annotate = annotate;
    }

    private VersionComparisonAnnotation getAnnotation(Base b) {
        if (b.hasUserData("version-annotation")) {
            return (VersionComparisonAnnotation)b.getUserData("version-annotation");
        }
        VersionComparisonAnnotation vca = new VersionComparisonAnnotation(VersionComparisonAnnotation.AnotationType.NoChange);
        b.setUserData("version-annotation", vca);
        return vca;
    }

    public void markAdded(Base focus) {
        if (this.isAnnotate()) {
            this.getAnnotation(focus).added();
        }
    }

    public void markChanged(Base focus, Base original) {
        if (this.isAnnotate()) {
            this.getAnnotation(focus).changed(original);
        }
    }

    public void markDeleted(Base parent, String name, Base other) {
        if (this.isAnnotate() && other != null) {
            this.getAnnotation(parent).deleted(name, other);
            this.getAnnotation(other).deleted();
        }
    }

    public void annotate(Base base, CanonicalResourceComparer.CanonicalResourceComparison<? extends CanonicalResource> comp) {
        if (this.isAnnotate()) {
            this.getAnnotation(base).comp(comp);
        }
    }
}

