/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class R5ExtensionsLoader {
    private BasePackageCacheManager pcm;
    private int count;
    private NpmPackage pckCore;
    private Map<String, Loadable<ValueSet>> valueSets;
    private Map<String, Loadable<CodeSystem>> codeSystems;
    private List<Loadable<StructureDefinition>> structures;
    private IWorkerContext context;
    private JsonParser json;

    public R5ExtensionsLoader(BasePackageCacheManager pcm, IWorkerContext context) {
        this.pcm = pcm;
        this.context = context;
        this.valueSets = new HashMap<String, Loadable<ValueSet>>();
        this.codeSystems = new HashMap<String, Loadable<CodeSystem>>();
        this.structures = new ArrayList<Loadable<StructureDefinition>>();
    }

    public void load() throws FHIRException, IOException {
        this.pckCore = this.pcm.loadPackage("hl7.fhir.r5.core", "5.0.0");
        this.loadDetails(this.pckCore);
    }

    private void loadDetails(NpmPackage pck) throws IOException {
        this.json = new JsonParser();
        String[] types = new String[]{"StructureDefinition", "ValueSet", "CodeSystem"};
        for (NpmPackage.PackageResourceInformation pri : pck.listIndexedResources(types)) {
            if (pri.getResourceType().equals("CodeSystem")) {
                this.codeSystems.put(pri.getUrl(), new Loadable(pri, pck));
                this.codeSystems.put(pri.getUrl() + "|" + pri.getVersion(), new Loadable(pri, pck));
                continue;
            }
            if (pri.getResourceType().equals("ValueSet")) {
                this.valueSets.put(pri.getUrl(), new Loadable(pri, pck));
                this.valueSets.put(pri.getUrl() + "|" + pri.getVersion(), new Loadable(pri, pck));
                continue;
            }
            if (!pri.getResourceType().equals("StructureDefinition")) continue;
            this.structures.add(new Loadable(pri, pck));
        }
    }

    public void loadR5SpecialTypes(List<String> types) throws FHIRException, IOException {
        for (Loadable<StructureDefinition> lsd : this.structures) {
            if (!Utilities.existsInList((String)lsd.info.getId(), types)) continue;
            StructureDefinition sd = lsd.getResource();
            ++this.count;
            ArrayList<ElementDefinition> rl = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                if (this.stripTypes(ed, sd, types)) continue;
                rl.add(ed);
            }
            sd.getDifferential().getElement().removeAll(rl);
            rl.clear();
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (this.stripTypes(ed, sd, types)) continue;
                rl.add(ed);
            }
            sd.getSnapshot().getElement().removeAll(rl);
            sd.setWebPath(Utilities.pathURL((String[])new String[]{lsd.source.getWebLocation(), sd.getId().toLowerCase() + ".html"}));
            this.registerTerminologies(sd);
            this.context.cacheResourceFromPackage(sd, new PackageInformation(lsd.source));
        }
    }

    private boolean stripTypes(ElementDefinition ed, StructureDefinition sd, List<String> types) {
        if (!ed.getPath().contains(".") || !ed.hasType()) {
            return true;
        }
        ed.getType().removeIf(tr -> this.context.fetchTypeDefinition(tr.getWorkingCode()) == null);
        if (!ed.hasType()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent tr2 : ed.getType()) {
            if (!tr2.hasTargetProfile()) continue;
            tr2.getTargetProfile().removeIf(n -> !this.context.hasResource(StructureDefinition.class, n.asStringValue()) && !n.asStringValue().equals(sd.getUrl()) && !types.contains(this.tail(n.asStringValue())));
            if (tr2.hasTargetProfile()) continue;
            return false;
        }
        return true;
    }

    private Object tail(String s) {
        if (s == null || !s.contains("/")) {
            return s;
        }
        return s.substring(s.lastIndexOf("/") + 1);
    }

    private void registerTerminologies(StructureDefinition sd) throws FHIRFormatError, FileNotFoundException, IOException {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.hasBinding() || !ed.getBinding().hasValueSet()) continue;
            String vsu = ed.getBinding().getValueSet();
            ValueSet vs = this.context.fetchResource(ValueSet.class, vsu);
            if (vs == null) {
                this.loadValueSet(vsu, this.context, this.valueSets, this.codeSystems);
                continue;
            }
            if (!vs.hasVersion()) continue;
            ed.getBinding().setValueSet(vs.getUrl() + "|" + vs.getVersion());
        }
    }

    private void loadValueSet(String url, IWorkerContext context, Map<String, Loadable<ValueSet>> valueSets, Map<String, Loadable<CodeSystem>> codeSystems) throws FHIRFormatError, FileNotFoundException, IOException {
        if (valueSets.containsKey(url)) {
            ValueSet vs = valueSets.get(url).getResource();
            context.cacheResourceFromPackage(vs, vs.getSourcePackage());
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                for (CanonicalType t : inc.getValueSet()) {
                    this.loadValueSet(t.asStringValue(), context, valueSets, codeSystems);
                }
                if (!inc.hasSystem()) continue;
                if (!inc.hasVersion()) {
                    if (!codeSystems.containsKey(inc.getSystem())) continue;
                    CodeSystem cs = codeSystems.get(inc.getSystem()).getResource();
                    CodeSystem csAlready = context.fetchCodeSystem(inc.getSystem());
                    if (csAlready != null) continue;
                    context.cacheResourceFromPackage(cs, cs.getSourcePackage());
                    continue;
                }
                if (context.fetchResource(CodeSystem.class, inc.getSystem(), inc.getVersion()) != null || !codeSystems.containsKey(inc.getSystem() + "|" + inc.getVersion())) continue;
                CodeSystem cs1 = codeSystems.get(inc.getSystem() + "|" + inc.getVersion()).getResource();
                context.cacheResourceFromPackage(cs1, cs1.getSourcePackage());
            }
        }
    }

    private boolean survivesStrippingTypes(StructureDefinition sd, IWorkerContext context, List<String> typeNames) {
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.stripTypes(ed, context, typeNames);
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (this.stripTypes(ed, context, typeNames)) continue;
            return false;
        }
        return true;
    }

    private boolean stripTypes(ElementDefinition ed, IWorkerContext context, List<String> typeNames) {
        if (!ed.getPath().contains(".") || !ed.hasType()) {
            return true;
        }
        ed.getType().removeIf(tr -> !typeNames.contains(tr.getWorkingCode()));
        if (!ed.hasType()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent tr2 : ed.getType()) {
            if (!tr2.hasTargetProfile()) continue;
            tr2.getTargetProfile().removeIf(n -> !context.hasResource(StructureDefinition.class, n.asStringValue()));
            if (tr2.hasTargetProfile()) continue;
            return false;
        }
        return true;
    }

    public BasePackageCacheManager getPcm() {
        return this.pcm;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getMap() throws IOException {
        return this.pckCore.hasFile("other", "spec.internals") ? TextFile.streamToBytes((InputStream)this.pckCore.load("other", "spec.internals")) : null;
    }

    public NpmPackage getPckCore() {
        return this.pckCore;
    }

    public class Loadable<T extends CanonicalResource> {
        private T resource;
        private NpmPackage source;
        private NpmPackage.PackageResourceInformation info;

        public Loadable(NpmPackage.PackageResourceInformation info, NpmPackage source) {
            this.info = info;
            this.source = source;
        }

        public T getResource() throws FHIRFormatError, FileNotFoundException, IOException {
            if (this.resource == null) {
                CanonicalResource r = (CanonicalResource)R5ExtensionsLoader.this.json.parse(this.source.load(this.info));
                r.setWebPath(Utilities.pathURL((String[])new String[]{this.source.getWebLocation(), r.fhirType().toLowerCase() + "-" + r.getId().toLowerCase() + ".html"}));
                this.resource = r;
            }
            return this.resource;
        }
    }

    public static class CanonicalResourceSortByUrl<T extends CanonicalResource>
    implements Comparator<Loadable<T>> {
        @Override
        public int compare(Loadable<T> arg0, Loadable<T> arg1) {
            return arg0.info.getUrl().compareTo(arg1.info.getUrl());
        }
    }
}

