/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ElementRedirection;
import org.hl7.fhir.r5.conformance.profile.BaseTypeSlice;
import org.hl7.fhir.r5.conformance.profile.PathSlicingParams;
import org.hl7.fhir.r5.conformance.profile.ProfilePathProcessorState;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.conformance.profile.TypeSlice;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ProfilePathProcessor {
    protected final ProfileUtilities profileUtilities;
    final String debugIndent;
    final StructureDefinition.StructureDefinitionSnapshotComponent result;
    final StructureDefinition.StructureDefinitionDifferentialComponent differential;
    final int baseLimit;
    final int diffLimit;
    final String url;
    final String webUrl;
    final String profileName;
    final String contextPathSource;
    final String contextPathTarget;
    final boolean trimDifferential;
    final List<ElementRedirection> redirector;
    final StructureDefinition sourceStructureDefinition;
    final StructureDefinition derived;
    final PathSlicingParams slicing;

    private ProfilePathProcessor(ProfileUtilities profileUtilities) {
        this.profileUtilities = profileUtilities;
        this.debugIndent = "";
        this.result = null;
        this.differential = null;
        this.baseLimit = 0;
        this.diffLimit = 0;
        this.url = null;
        this.webUrl = null;
        this.profileName = null;
        this.contextPathSource = null;
        this.contextPathTarget = null;
        this.trimDifferential = false;
        this.redirector = null;
        this.sourceStructureDefinition = null;
        this.derived = null;
        this.slicing = null;
    }

    public static ProfilePathProcessor getInstance(ProfileUtilities profileUtilities) {
        return new ProfilePathProcessor(profileUtilities);
    }

    public ProfilePathProcessor incrementDebugIndent() {
        return this.withDebugIndent(this.debugIndent + " ".repeat(2));
    }

    protected static void processPaths(ProfileUtilities profileUtilities, StructureDefinition base, StructureDefinition derived, String url, String webUrl, StructureDefinition.StructureDefinitionDifferentialComponent differential, StructureDefinition.StructureDefinitionSnapshotComponent baseSnapshot) {
        ProfilePathProcessorState cursors = new ProfilePathProcessorState(baseSnapshot, 0, 0, base.getUrl(), null);
        ProfilePathProcessor.getInstance(profileUtilities).withResult(derived.getSnapshot()).withDifferential(differential).withBaseLimit(baseSnapshot.getElement().size() - 1).withDiffLimit(derived.getDifferential().hasElement() ? derived.getDifferential().getElement().size() - 1 : -1).withUrl(url).withWebUrl(webUrl).withProfileName(derived.present()).withContextPathSource(null).withContextPathTarget(null).withTrimDifferential(false).withRedirector(new ArrayList<ElementRedirection>()).withSourceStructureDefinition(base).withDerived(derived).withSlicing(new PathSlicingParams()).processPaths(cursors);
    }

    private ElementDefinition processPaths(ProfilePathProcessorState cursors) throws FHIRException {
        this.debugProcessPathsEntry(cursors);
        ElementDefinition res = null;
        ArrayList<TypeSlice> typeList = new ArrayList<TypeSlice>();
        while (cursors.baseCursor <= this.getBaseLimit()) {
            ElementDefinition currentBase = cursors.base.getElement().get(cursors.baseCursor);
            String currentBasePath = this.profileUtilities.fixedPathSource(this.getContextPathSource(), currentBase.getPath(), this.getRedirector());
            this.debugProcessPathsIteration(cursors, currentBasePath);
            List<ElementDefinition> diffMatches = this.profileUtilities.getDiffMatches(this.getDifferential(), currentBasePath, cursors.diffCursor, this.getDiffLimit(), this.getProfileName());
            if (!currentBase.hasSlicing() || currentBasePath.equals(this.getSlicing().getPath())) {
                ElementDefinition currentRes = this.processSimplePath(currentBase, currentBasePath, diffMatches, typeList, cursors);
                if (res != null) continue;
                res = currentRes;
                continue;
            }
            this.processPathWithSlicedBase(currentBase, currentBasePath, diffMatches, typeList, cursors);
        }
        int i = 0;
        for (ElementDefinition e : this.getResult().getElement()) {
            ++i;
            if (!e.hasMinElement() || e.getMinElement().getValue() != null) continue;
            throw new Error(this.profileUtilities.getContext().formatMessage("null_min", new Object[0]));
        }
        return res;
    }

    private void debugProcessPathsIteration(ProfilePathProcessorState cursors, String currentBasePath) {
        if (this.profileUtilities.isDebug()) {
            System.out.println(this.getDebugIndent() + " - " + currentBasePath + ": base = " + cursors.baseCursor + " (" + this.profileUtilities.descED(cursors.base.getElement(), cursors.baseCursor) + ") to " + this.getBaseLimit() + " (" + this.profileUtilities.descED(cursors.base.getElement(), this.getBaseLimit()) + "), diff = " + cursors.diffCursor + " (" + this.profileUtilities.descED(this.getDifferential().getElement(), cursors.diffCursor) + ") to " + this.getDiffLimit() + " (" + this.profileUtilities.descED(this.getDifferential().getElement(), this.getDiffLimit()) + ") (slicingDone = " + this.getSlicing().isDone() + ") (diffpath= " + (this.getDifferential().getElement().size() > cursors.diffCursor ? this.getDifferential().getElement().get(cursors.diffCursor).getPath() : "n/a") + ")");
            String string = cursors.diffCursor >= 0 && cursors.diffCursor < this.getDifferential().getElement().size() ? this.getDifferential().getElement().get(cursors.diffCursor).present() : null;
        }
    }

    private void debugProcessPathsEntry(ProfilePathProcessorState cursors) {
        if (this.profileUtilities.isDebug()) {
            System.out.println(this.getDebugIndent() + "PP @ " + cursors.resultPathBase + " / " + this.getContextPathSource() + " : base = " + cursors.baseCursor + " to " + this.getBaseLimit() + ", diff = " + cursors.diffCursor + " to " + this.getDiffLimit() + " (slicing = " + this.getSlicing().isDone() + ", k " + (this.getRedirector() == null ? "null" : this.getRedirector().toString()) + ")");
        }
    }

    public ElementDefinition processSimplePath(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, List<TypeSlice> typeList, ProfilePathProcessorState cursors) throws FHIRException {
        ElementDefinition res = null;
        if (diffMatches.isEmpty()) {
            this.processSimplePathWithEmptyDiffMatches(currentBase, currentBasePath, diffMatches, cursors);
        } else if (this.oneMatchingElementInDifferential(this.getSlicing().isDone(), currentBasePath, diffMatches)) {
            res = this.processSimplePathWithOneMatchingElementInDifferential(currentBase, currentBasePath, diffMatches, cursors);
        } else if (this.profileUtilities.diffsConstrainTypes(diffMatches, currentBasePath, typeList)) {
            this.processSimplePathWhereDiffsConstrainTypes(currentBasePath, diffMatches, typeList, cursors);
        } else {
            this.processSimplePathDefault(currentBase, currentBasePath, diffMatches, cursors);
        }
        return res;
    }

    private void processSimplePathDefault(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, ProfilePathProcessorState cursors) {
        ElementDefinition slicerElement;
        int newDiffLimit;
        int newDiffCursor;
        if (!this.profileUtilities.unbounded(currentBase) && !this.profileUtilities.isSlicedToOneOnly(diffMatches.get(0))) {
            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Attempt_to_a_slice_an_element_that_does_not_repeat__from__in_", currentBase.getPath(), currentBase.getPath(), cursors.contextName, diffMatches.get(0).getId(), this.profileUtilities.sliceNames(diffMatches)));
        }
        if (!diffMatches.get(0).hasSlicing() && !this.profileUtilities.isExtension(currentBase)) {
            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Differential_does_not_have_a_slice__b_of_____in_profile_", currentBase.getPath(), cursors.baseCursor, this.getBaseLimit(), cursors.diffCursor, this.getDiffLimit(), this.getUrl(), currentBasePath));
        }
        int start = 0;
        int newBaseLimit = this.profileUtilities.findEndOfElement(cursors.base, cursors.baseCursor);
        if (diffMatches.size() > 1 && diffMatches.get(0).hasSlicing() && (newBaseLimit > cursors.baseCursor || this.getDifferential().getElement().indexOf(diffMatches.get(1)) > this.getDifferential().getElement().indexOf(diffMatches.get(0)) + 1)) {
            newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(0));
            newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
            ElementDefinition e = this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withSlicing(new PathSlicingParams(true, null, null)).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor, newDiffCursor, cursors.contextName, cursors.resultPathBase));
            if (e == null) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Did_not_find_single_slice_", diffMatches.get(0).getPath()));
            }
            e.setSlicing(diffMatches.get(0).getSlicing());
            slicerElement = e;
            ++start;
        } else {
            ElementDefinition outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), currentBase.copy());
            outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
            this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
            if (!diffMatches.get(0).hasSlicing()) {
                outcome.setSlicing(this.profileUtilities.makeExtensionSlicing());
                outcome.setUserData("auto-added-slicing", true);
            } else {
                outcome.setSlicing(diffMatches.get(0).getSlicing().copy());
                for (int i = 1; i < diffMatches.size(); ++i) {
                    if (!diffMatches.get(i).hasSlicing()) continue;
                    if (!this.slicingMatches(diffMatches.get(0).getSlicing(), diffMatches.get(i).getSlicing())) {
                        this.profileUtilities.getMessages().add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, diffMatches.get(0).getPath(), this.profileUtilities.getContext().formatMessage("ATTEMPT_TO_CHANGE_SLICING", diffMatches.get(0).getId(), this.slicingSummary(diffMatches.get(0).getSlicing()), diffMatches.get(i).getId(), this.slicingSummary(diffMatches.get(i).getSlicing())), ValidationMessage.IssueSeverity.ERROR));
                        continue;
                    }
                    this.profileUtilities.getMessages().add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, diffMatches.get(0).getPath(), this.profileUtilities.getContext().formatMessage("ATTEMPT_TO_CHANGE_SLICING", diffMatches.get(0).getId(), diffMatches.get(i).getId()), ValidationMessage.IssueSeverity.INFORMATION));
                }
            }
            if (cursors.resultPathBase != null && !outcome.getPath().startsWith(cursors.resultPathBase)) {
                throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path", new Object[0]));
            }
            this.debugCheck(outcome);
            this.getResult().getElement().add(outcome);
            slicerElement = outcome;
            if (!diffMatches.get(0).hasSliceName()) {
                this.profileUtilities.updateFromDefinition(outcome, diffMatches.get(0), this.getProfileName(), this.isTrimDifferential(), this.getUrl(), this.getSourceStructureDefinition(), this.getDerived(), this.diffPath(diffMatches.get(0)));
                this.profileUtilities.removeStatusExtensions(outcome);
                if (!outcome.hasContentReference() && !outcome.hasType() && outcome.getPath().contains(".")) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Not_done_yet", new Object[0]));
                }
                if (this.profileUtilities.hasInnerDiffMatches(this.getDifferential(), currentBasePath, cursors.diffCursor, this.getDiffLimit(), cursors.base.getElement(), false)) {
                    if (this.baseHasChildren(cursors.base, currentBase)) {
                        if (cursors.diffCursor == 0) {
                            throw new DefinitionException("Error: The profile has slicing at the root ('" + currentBase.getPath() + "'), which is illegal");
                        }
                        throw new Error("This situation is not yet handled (constrain slicing to 1..1 and fix base slice for inline structure - please report issue to grahame@fhir.org along with a test case that reproduces this error (@ " + currentBasePath + " | " + currentBase.getPath() + ")");
                    }
                    StructureDefinition dt = this.profileUtilities.getTypeForElement(this.getDifferential(), cursors.diffCursor, this.getProfileName(), diffMatches, outcome, this.getWebUrl(), this.getDerived());
                    cursors.contextName = dt.getUrl();
                    ++cursors.diffCursor;
                    start = cursors.diffCursor;
                    while (this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), currentBasePath + ".")) {
                        ++cursors.diffCursor;
                    }
                    --cursors.diffCursor;
                    this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(cursors.diffCursor).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withContextPathSource(currentBasePath).withContextPathTarget(outcome.getPath()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, start, cursors.contextName, cursors.resultPathBase));
                }
                ++start;
            } else {
                this.profileUtilities.checkExtensionDoco(outcome);
            }
        }
        newDiffCursor = cursors.diffCursor;
        newDiffLimit = cursors.diffCursor;
        for (int i = start; i < diffMatches.size(); ++i) {
            newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(i));
            newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
            this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, i)).withSlicing(new PathSlicingParams(true, slicerElement, null)).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor, newDiffCursor, cursors.contextName, cursors.resultPathBase));
        }
        cursors.baseCursor = newBaseLimit + 1;
        cursors.diffCursor = newDiffLimit + 1;
    }

    private String diffPath(ElementDefinition ed) {
        return "StructureDefinition.differential.element[" + this.differential.getElement().indexOf(ed) + "]";
    }

    private String slicingSummary(ElementDefinition.ElementDefinitionSlicingComponent s) {
        return s.toString();
    }

    private boolean slicingMatches(ElementDefinition.ElementDefinitionSlicingComponent s1, ElementDefinition.ElementDefinitionSlicingComponent s2) {
        if (!s1.hasOrdered() && s2.hasOrdered() || s1.hasOrdered() && s2.hasOrdered() && !Base.compareDeep(s1.getOrderedElement(), s2.getOrderedElement(), false)) {
            return false;
        }
        if (!s1.hasRules() && s2.hasRules() || s1.hasRules() && s2.hasRules() && !Base.compareDeep(s1.getRulesElement(), s2.getRulesElement(), false)) {
            return false;
        }
        return Base.compareDeep(s1.getDiscriminator(), s2.getDiscriminator(), false);
    }

    private void processSimplePathWhereDiffsConstrainTypes(String currentBasePath, List<ElementDefinition> diffMatches, List<TypeSlice> typeList, ProfilePathProcessorState cursors) {
        int start = 0;
        int newBaseLimit = this.profileUtilities.findEndOfElement(cursors.base, cursors.baseCursor);
        int newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(0));
        ElementDefinition elementToRemove = null;
        boolean shortCut = !typeList.isEmpty() && typeList.get(0).getType() != null;
        String path = diffMatches.get(0).getPath();
        if (shortCut) {
            ElementDefinition ed;
            if (!VersionUtilities.isR4Plus((String)this.profileUtilities.getContext().getVersion()) || !this.profileUtilities.isNewSlicingProcessing()) {
                ed = new ElementDefinition();
                ed.setPath(this.profileUtilities.determineTypeSlicePath(path, currentBasePath));
                for (TypeSlice ts : typeList) {
                    ed.addType().setCode(ts.getType());
                }
                ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                ed.getSlicing().setOrdered(false);
                diffMatches.add(0, ed);
                this.getDifferential().getElement().add(newDiffCursor, ed);
                elementToRemove = ed;
            } else {
                ed = new ElementDefinition();
                ed.setPath(this.profileUtilities.determineTypeSlicePath(path, currentBasePath));
                ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                ed.getSlicing().setOrdered(false);
                diffMatches.add(0, ed);
                this.getDifferential().getElement().add(newDiffCursor, ed);
                elementToRemove = ed;
            }
        } else {
            Object t2;
            String t1 = currentBasePath.substring(currentBasePath.lastIndexOf(".") + 1);
            if (!t1.equals(t2 = path.substring(path.lastIndexOf(".") + 1))) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("ED_PATH_WRONG_TYPE_MATCH", path.replace((CharSequence)t2, t1), path));
            }
        }
        int newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
        if (diffMatches.get(0).getSlicing().hasOrdered() && diffMatches.get(0).getSlicing().getOrdered()) {
            throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingordered__true", currentBasePath, this.getUrl()));
        }
        if (diffMatches.get(0).getSlicing().hasDiscriminator()) {
            if (diffMatches.get(0).getSlicing().getDiscriminator().size() != 1) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorcount__1", currentBasePath, this.getUrl()));
            }
            if (diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getType() != ElementDefinition.DiscriminatorType.TYPE) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatortype__type", currentBasePath, this.getUrl()));
            }
            if (!"$this".equals(diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getPath())) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorpath__this", currentBasePath, this.getUrl()));
            }
        }
        for (TypeSlice ts : typeList) {
            if (ts.getType() == null) continue;
            String tn = this.profileUtilities.rootName(currentBasePath) + Utilities.capitalize((String)ts.getType());
            if (!ts.defn.hasSliceName()) {
                ts.defn.setSliceName(tn);
            } else if (!ts.defn.getSliceName().equals(tn)) {
                if (this.profileUtilities.isAutoFixSliceNames()) {
                    ts.defn.setSliceName(tn);
                } else {
                    throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__Slice_name_must_be__but_is_", !Utilities.noString((String)this.getContextPathSource()) ? this.getContextPathSource() : currentBasePath, tn, ts.defn.getSliceName()));
                }
            }
            if (!ts.defn.hasType()) {
                ts.defn.addType().setCode(ts.type);
                continue;
            }
            if (ts.defn.getType().size() > 1) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__Slice_for_type__has_more_than_one_type_", !Utilities.noString((String)this.getContextPathSource()) ? this.getContextPathSource() : currentBasePath, tn, ts.defn.typeSummary()));
            }
            if (ts.defn.getType().get(0).getCode().equals(ts.type)) continue;
            throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__Slice_for_type__has_wrong_type_", !Utilities.noString((String)this.getContextPathSource()) ? this.getContextPathSource() : currentBasePath, tn, ts.defn.typeSummary()));
        }
        ElementDefinition elementDefinition = this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withSlicing(new PathSlicingParams(true, null, null)).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor, newDiffCursor, cursors.contextName, cursors.resultPathBase));
        if (elementDefinition == null) {
            throw new FHIRException(this.profileUtilities.getContext().formatMessage("Did_not_find_type_root_", path));
        }
        elementDefinition.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
        elementDefinition.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
        elementDefinition.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
        elementDefinition.getSlicing().setOrdered(false);
        String fixedType = null;
        for (int i = ++start; i < diffMatches.size(); ++i) {
            if (diffMatches.get(i).getMin() > 0) {
                if (diffMatches.size() > i + 1) {
                    throw new FHIRException(this.profileUtilities.getContext().formatMessage("Invalid_slicing__there_is_more_than_one_type_slice_at__but_one_of_them__has_min__1_so_the_other_slices_cannot_exist", diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
                }
                elementDefinition.setMin(1);
                fixedType = this.profileUtilities.determineFixedType(diffMatches, fixedType, i);
            }
            newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(i));
            newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
            ElementDefinition typeSliceElement = this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, i)).withSlicing(new PathSlicingParams(true, elementDefinition, null)).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor, newDiffCursor, cursors.contextName, cursors.resultPathBase));
            if (typeList.size() <= start + 1) continue;
            typeSliceElement.setMin(0);
        }
        if (elementToRemove != null) {
            this.getDifferential().getElement().remove(elementToRemove);
            --newDiffLimit;
        }
        if (fixedType != null) {
            Iterator<ElementDefinition.TypeRefComponent> iter = elementDefinition.getType().iterator();
            while (iter.hasNext()) {
                ElementDefinition.TypeRefComponent tr = iter.next();
                if (tr.getCode().equals(fixedType)) continue;
                iter.remove();
            }
        }
        if (!"0".equals(elementDefinition.getMax())) {
            Set<String> allowedTypes = this.profileUtilities.getListOfTypes(elementDefinition);
            for (TypeSlice t : typeList) {
                if (t.type != null) {
                    allowedTypes.remove(t.type);
                    continue;
                }
                if (!t.getDefn().hasSliceName() || t.getDefn().getType().size() != 1) continue;
                allowedTypes.remove(t.getDefn().getType().get(0).getCode());
            }
            if (!allowedTypes.isEmpty()) {
                if (currentBasePath.contains("xtension.value")) {
                    Iterator<ElementDefinition.TypeRefComponent> iter = elementDefinition.getType().iterator();
                    while (iter.hasNext()) {
                        ElementDefinition.TypeRefComponent tr = iter.next();
                        if (!allowedTypes.contains(tr.getCode())) continue;
                        iter.remove();
                    }
                } else {
                    elementDefinition.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN);
                }
            }
        }
        cursors.baseCursor = newBaseLimit + 1;
        cursors.diffCursor = newDiffLimit + 1;
    }

    private ElementDefinition processSimplePathWithOneMatchingElementInDifferential(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, ProfilePathProcessorState cursors) {
        ElementDefinition template = null;
        if (diffMatches.get(0).hasType() && "Reference".equals(diffMatches.get(0).getType().get(0).getWorkingCode()) && !this.profileUtilities.isValidType(diffMatches.get(0).getType().get(0), currentBase)) {
            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("VALIDATION_VAL_ILLEGAL_TYPE_CONSTRAINT", this.getUrl(), diffMatches.get(0).getPath(), diffMatches.get(0).getType().get(0), currentBase.typeSummary()));
        }
        String id = diffMatches.get(0).getId();
        String lid = this.profileUtilities.tail(id);
        if (lid.contains("/")) {
            this.profileUtilities.generateIds(this.getResult().getElement(), this.getUrl(), this.getSourceStructureDefinition().getType(), this.getSourceStructureDefinition());
            String baseId = id.substring(0, id.length() - lid.length()) + lid.substring(0, lid.indexOf("/"));
            template = this.profileUtilities.getById(this.getResult().getElement(), baseId);
        } else if (diffMatches.get(0).hasType() && diffMatches.get(0).getType().size() == 1 && diffMatches.get(0).getType().get(0).hasProfile() && !"Reference".equals(diffMatches.get(0).getType().get(0).getWorkingCode())) {
            CanonicalType firstTypeProfile = diffMatches.get(0).getType().get(0).getProfile().get(0);
            StructureDefinition firstTypeStructureDefinition = this.profileUtilities.getContext().fetchResource(StructureDefinition.class, (String)firstTypeProfile.getValue());
            if (firstTypeStructureDefinition == null && this.profileUtilities.getXver() != null && this.profileUtilities.getXver().matchingUrl((String)firstTypeProfile.getValue())) {
                switch (this.profileUtilities.getXver().status((String)firstTypeProfile.getValue())) {
                    case BadVersion: {
                        throw new FHIRException("Reference to invalid version in extension url " + (String)firstTypeProfile.getValue());
                    }
                    case Invalid: {
                        throw new FHIRException("Reference to invalid extension " + (String)firstTypeProfile.getValue());
                    }
                    case Unknown: {
                        throw new FHIRException("Reference to unknown extension " + (String)firstTypeProfile.getValue());
                    }
                    case Valid: {
                        firstTypeStructureDefinition = this.profileUtilities.getXver().makeDefinition((String)firstTypeProfile.getValue());
                        this.profileUtilities.generateSnapshot(this.profileUtilities.getContext().fetchTypeDefinition("Extension"), firstTypeStructureDefinition, firstTypeStructureDefinition.getUrl(), this.getWebUrl(), firstTypeStructureDefinition.getName());
                    }
                }
            }
            if (firstTypeStructureDefinition != null) {
                ElementDefinition src;
                if (!this.profileUtilities.isMatchingType(firstTypeStructureDefinition, diffMatches.get(0).getType(), firstTypeProfile.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"))) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Validation_VAL_Profile_WrongType2", firstTypeStructureDefinition.getUrl(), diffMatches.get(0).getPath(), firstTypeStructureDefinition.getType(), firstTypeProfile.getValue(), diffMatches.get(0).getType().get(0).getWorkingCode()));
                }
                if (this.profileUtilities.isGenerating(firstTypeStructureDefinition)) {
                    if (firstTypeStructureDefinition.getSnapshot().getElementFirstRep().isEmpty()) {
                        throw new FHIRException(this.profileUtilities.getContext().formatMessage("Attempt_to_use_a_snapshot_on_profile__as__before_it_is_generated", firstTypeStructureDefinition.getUrl(), "Source for first element"));
                    }
                } else if (!firstTypeStructureDefinition.hasSnapshot()) {
                    StructureDefinition sdb = this.profileUtilities.getContext().fetchResource(StructureDefinition.class, firstTypeStructureDefinition.getBaseDefinition());
                    if (sdb == null) {
                        throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Unable_to_find_base__for_", firstTypeStructureDefinition.getBaseDefinition(), firstTypeStructureDefinition.getUrl()));
                    }
                    this.profileUtilities.checkNotGenerating(sdb, "an extension base");
                    this.profileUtilities.generateSnapshot(sdb, firstTypeStructureDefinition, firstTypeStructureDefinition.getUrl(), sdb.hasWebPath() ? Utilities.extractBaseUrl((String)sdb.getWebPath()) : this.getWebUrl(), firstTypeStructureDefinition.getName());
                }
                if (firstTypeProfile.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                    src = null;
                    String eid = firstTypeProfile.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element");
                    for (ElementDefinition t : firstTypeStructureDefinition.getSnapshot().getElement()) {
                        if (!eid.equals(t.getId())) continue;
                        src = t;
                    }
                    if (src == null) {
                        throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Unable_to_find_element__in_", eid, firstTypeProfile.getValue()));
                    }
                } else {
                    if (firstTypeStructureDefinition.getSnapshot().getElement().isEmpty()) {
                        throw new FHIRException(this.profileUtilities.getContext().formatMessage("SNAPSHOT_IS_EMPTY", firstTypeStructureDefinition.getVersionedUrl(), "Source for first element"));
                    }
                    src = firstTypeStructureDefinition.getSnapshot().getElement().get(0);
                }
                template = src.copy().setPath(currentBase.getPath());
                template.setSliceName(null);
                if (!"Extension".equals(diffMatches.get(0).getType().get(0).getCode())) {
                    template.setMin(currentBase.getMin());
                    template.setMax(currentBase.getMax());
                }
            }
        }
        template = template == null ? currentBase.copy() : this.profileUtilities.fillOutFromBase(template, currentBase);
        ElementDefinition outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), template);
        outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
        ElementDefinition res = outcome;
        this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
        if (diffMatches.get(0).hasSliceName()) {
            template = currentBase.copy();
            template = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), template);
            template.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), template.getPath(), this.getRedirector(), this.getContextPathSource()));
            this.checkToSeeIfSlicingExists(diffMatches.get(0), template);
            outcome.setSliceName(diffMatches.get(0).getSliceName());
            if (!(diffMatches.get(0).hasMin() || diffMatches.size() <= 1 && this.getSlicing().getElementDefinition() != null && this.getSlicing().getElementDefinition().getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED || currentBase.hasSliceName() || currentBasePath.endsWith("xtension.value[x]"))) {
                outcome.setMin(0);
            }
        }
        this.profileUtilities.updateFromDefinition(outcome, diffMatches.get(0), this.getProfileName(), this.isTrimDifferential(), this.getUrl(), this.getSourceStructureDefinition(), this.getDerived(), this.diffPath(diffMatches.get(0)));
        this.profileUtilities.removeStatusExtensions(outcome);
        outcome.setSlicing(null);
        if (cursors.resultPathBase == null) {
            cursors.resultPathBase = outcome.getPath();
        } else if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path", new Object[0]));
        }
        this.debugCheck(outcome);
        this.getResult().getElement().add(outcome);
        ++cursors.baseCursor;
        cursors.diffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(0)) + 1;
        if (this.getDiffLimit() >= cursors.diffCursor && outcome.getPath().contains(".") && (this.profileUtilities.isDataType(outcome.getType()) || this.profileUtilities.isBaseResource(outcome.getType()) || outcome.hasContentReference()) && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), diffMatches.get(0).getPath() + ".") && !this.profileUtilities.baseWalksInto(cursors.base.getElement(), cursors.baseCursor)) {
            if (outcome.getType().size() > 1) {
                if (outcome.getPath().endsWith("[x]") && !diffMatches.get(0).getPath().endsWith("[x]")) {
                    Object ntr;
                    String en = this.profileUtilities.tail(outcome.getPath());
                    String tn = this.profileUtilities.tail(diffMatches.get(0).getPath());
                    String t = tn.substring(en.length() - 3);
                    if (this.profileUtilities.isPrimitive(Utilities.uncapitalize((String)t))) {
                        t = Utilities.uncapitalize((String)t);
                    }
                    if ((ntr = this.profileUtilities.getByTypeName(outcome.getType(), t)).isEmpty()) {
                        ntr.add(new ElementDefinition.TypeRefComponent().setCode(t));
                    }
                    outcome.getType().clear();
                    outcome.getType().addAll((Collection<ElementDefinition.TypeRefComponent>)ntr);
                }
                if (outcome.getType().size() > 1) {
                    for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                        if (t.getCode().equals("Reference")) continue;
                        boolean nonExtension = false;
                        for (ElementDefinition ed : diffMatches) {
                            if (ed == diffMatches.get(0) || ed.getPath().endsWith(".extension")) continue;
                            nonExtension = true;
                        }
                        if (!nonExtension) continue;
                        Object[] objectArray = new Object[4];
                        objectArray[0] = diffMatches.get(0).getPath();
                        objectArray[1] = this.getDifferential().getElement().get(cursors.diffCursor).getPath();
                        objectArray[2] = ProfileUtilities.typeCode(outcome.getType());
                        objectArray[3] = this.getProfileName();
                        throw new DefinitionException(this.profileUtilities.getContext().formatMessage("_has_children__and_multiple_types__in_profile_", objectArray));
                    }
                }
            }
            int start = cursors.diffCursor;
            while (cursors.diffCursor <= this.getDiffLimit() && this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                ++cursors.diffCursor;
            }
            if (outcome.hasContentReference()) {
                ProfileUtilities.ElementDefinitionResolution target = this.profileUtilities.getElementById(this.getSourceStructureDefinition(), cursors.base.getElement(), outcome.getContentReference());
                if (target == null) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Unable_to_resolve_reference_to_", outcome.getContentReference()));
                }
                this.profileUtilities.replaceFromContentReference(outcome, target.getElement());
                if (target.getSource() != this.getSourceStructureDefinition()) {
                    int newBaseCursor;
                    int newBaseLimit;
                    cursors.base = target.getSource().getSnapshot();
                    for (newBaseLimit = newBaseCursor = cursors.base.getElement().indexOf(target.getElement()) + 1; newBaseLimit < cursors.base.getElement().size() && cursors.base.getElement().get(newBaseLimit).getPath().startsWith(target.getElement().getPath() + "."); ++newBaseLimit) {
                    }
                    this.incrementDebugIndent().withBaseLimit(newBaseLimit - 1).withDiffLimit(cursors.diffCursor - 1).withContextPathSource(target.getElement().getPath()).withContextPathTarget(diffMatches.get(0).getPath()).withRedirector(this.profileUtilities.redirectorStack(this.getRedirector(), outcome, currentBasePath)).withSourceStructureDefinition(target.getSource()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, newBaseCursor, start - 1, cursors.contextName, cursors.resultPathBase));
                } else {
                    int newBaseCursor;
                    int newBaseLimit;
                    for (newBaseLimit = newBaseCursor = cursors.base.getElement().indexOf(target.getElement()) + 1; newBaseLimit < cursors.base.getElement().size() && cursors.base.getElement().get(newBaseLimit).getPath().startsWith(target.getElement().getPath() + "."); ++newBaseLimit) {
                    }
                    this.incrementDebugIndent().withBaseLimit(newBaseLimit - 1).withDiffLimit(cursors.diffCursor - 1).withContextPathSource(target.getElement().getPath()).withContextPathTarget(diffMatches.get(0).getPath()).withRedirector(this.profileUtilities.redirectorStack(this.getRedirector(), outcome, currentBasePath)).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, newBaseCursor, start - 1, cursors.contextName, cursors.resultPathBase));
                }
            } else {
                StructureDefinition dt;
                StructureDefinition structureDefinition = dt = outcome.getType().size() == 1 ? this.profileUtilities.getProfileForDataType(outcome.getType().get(0), this.getWebUrl(), this.getDerived()) : this.profileUtilities.getProfileForDataType("Element");
                if (dt == null) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = diffMatches.isEmpty() ? "??" : diffMatches.get(0).getPath();
                    objectArray[1] = this.getDifferential().getElement().get(cursors.diffCursor).getPath();
                    objectArray[2] = ProfileUtilities.typeCode(outcome.getType());
                    objectArray[3] = this.getProfileName();
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("_has_children__for_type__in_profile__but_cant_find_type", objectArray));
                }
                cursors.contextName = dt.getUrl();
                this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(cursors.diffCursor - 1).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withContextPathSource(diffMatches.get(0).getPath()).withContextPathTarget(outcome.getPath()).withRedirector(new ArrayList<ElementRedirection>()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, start, cursors.contextName, cursors.resultPathBase));
            }
        }
        return res;
    }

    private void checkToSeeIfSlicingExists(ElementDefinition ed, ElementDefinition template) {
        List<ElementDefinition> ss = this.result.getElement();
        ElementDefinition m = null;
        for (int i = ss.size() - 1; i >= 0; --i) {
            ElementDefinition t = ss.get(i);
            if (this.pathsMatch(t.getPath(), ed.getPath()) && (t.hasSlicing() || t.hasSliceName() || t.getPath().endsWith("[x]"))) {
                m = t;
                break;
            }
            if (t.getPath().length() < ed.getPath().length()) break;
        }
        if (m == null) {
            if (template.getPath().endsWith(".extension")) {
                template.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN);
                template.getSlicing().setOrdered(false);
                template.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("url");
                this.result.getElement().add(template);
            } else {
                System.err.println("checkToSeeIfSlicingExists: " + ed.getPath() + ":" + ed.getSliceName() + " is not sliced");
            }
        }
    }

    private boolean pathsMatch(String path1, String path2) {
        String[] p2;
        String[] p1 = path1.split("\\.");
        if (p1.length != (p2 = path2.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            String pp1 = p1[i];
            String pp2 = p2[i];
            if (pp1.equals(pp2)) continue;
            if (pp1.endsWith("[x]")) {
                if (pp2.startsWith(pp1.substring(0, pp1.length() - 3))) continue;
                return false;
            }
            if (pp2.endsWith("[x]")) {
                if (pp1.startsWith(pp2.substring(0, pp2.length() - 3))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private int indexOfFirstNonChild(StructureDefinition.StructureDefinitionSnapshotComponent base, ElementDefinition currentBase, int i, int baseLimit) {
        return baseLimit + 1;
    }

    private boolean baseHasChildren(StructureDefinition.StructureDefinitionSnapshotComponent base, ElementDefinition ed) {
        int index = base.getElement().indexOf(ed);
        if (index == -1 || index >= base.getElement().size() - 1) {
            return false;
        }
        String p = base.getElement().get(index + 1).getPath();
        return this.isChildOf(p, ed.getPath());
    }

    private boolean isChildOf(String sub, String focus) {
        if (focus.endsWith("[x]")) {
            focus = focus.substring(0, focus.length() - 3);
            return sub.startsWith(focus);
        }
        return sub.startsWith(focus + ".");
    }

    private void processSimplePathWithEmptyDiffMatches(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, ProfilePathProcessorState cursors) {
        ElementDefinition outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), currentBase.copy());
        outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
        this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
        this.profileUtilities.updateConstraintSources(outcome, this.getSourceStructureDefinition().getUrl());
        this.profileUtilities.updateFromObligationProfiles(outcome);
        this.profileUtilities.updateURLs(this.url, this.webUrl, outcome);
        this.profileUtilities.markDerived(outcome);
        if (cursors.resultPathBase == null) {
            cursors.resultPathBase = outcome.getPath();
        } else if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path__outcomegetPath___resultPathBase__", outcome.getPath(), cursors.resultPathBase));
        }
        this.debugCheck(outcome);
        this.getResult().getElement().add(outcome);
        if (this.profileUtilities.hasInnerDiffMatches(this.getDifferential(), currentBasePath, cursors.diffCursor, this.getDiffLimit(), cursors.base.getElement(), true)) {
            if (this.baseHasChildren(cursors.base, currentBase)) {
                this.incrementDebugIndent().withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor + 1, cursors.diffCursor, cursors.contextName, cursors.resultPathBase));
                cursors.baseCursor = this.indexOfFirstNonChild(cursors.base, currentBase, cursors.baseCursor + 1, this.getBaseLimit());
            } else {
                if (outcome.getType().size() == 0 && !outcome.hasContentReference()) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("_has_no_children__and_no_types_in_profile_", currentBasePath, this.getDifferential().getElement().get(cursors.diffCursor).getPath(), this.getProfileName()));
                }
                boolean nonExtension = false;
                if (outcome.getType().size() > 1) {
                    for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                        if (t.getWorkingCode().equals("Reference")) continue;
                        for (ElementDefinition ed : diffMatches) {
                            if (ed == diffMatches.get(0) || ed.getPath().endsWith(".extension")) continue;
                            nonExtension = true;
                        }
                    }
                }
                if (!this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), currentBasePath + ".")) {
                    ++cursors.diffCursor;
                }
                int start = cursors.diffCursor;
                while (this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), currentBasePath + ".")) {
                    ++cursors.diffCursor;
                }
                if (nonExtension) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = currentBasePath;
                    objectArray[1] = this.getDifferential().getElement().get(cursors.diffCursor).getPath();
                    objectArray[2] = ProfileUtilities.typeCode(outcome.getType());
                    objectArray[3] = this.getProfileName();
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("_has_children__and_multiple_types__in_profile_", objectArray));
                }
                if (outcome.hasContentReference()) {
                    ProfileUtilities.ElementDefinitionResolution tgt = this.profileUtilities.getElementById(this.getSourceStructureDefinition(), cursors.base.getElement(), outcome.getContentReference());
                    if (tgt == null) {
                        throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Unable_to_resolve_reference_to_", outcome.getContentReference()));
                    }
                    this.profileUtilities.replaceFromContentReference(outcome, tgt.getElement());
                    if (tgt.getSource() != this.getSourceStructureDefinition()) {
                        int newBaseCursor;
                        int newBaseLimit;
                        cursors.base = tgt.getSource().getSnapshot();
                        for (newBaseLimit = newBaseCursor = cursors.base.getElement().indexOf(tgt.getElement()) + 1; newBaseLimit < cursors.base.getElement().size() && cursors.base.getElement().get(newBaseLimit).getPath().startsWith(tgt.getElement().getPath() + "."); ++newBaseLimit) {
                        }
                        this.incrementDebugIndent().withBaseLimit(newBaseLimit - 1).withDiffLimit(cursors.diffCursor - 1).withContextPathSource(tgt.getElement().getPath()).withContextPathTarget(diffMatches.get(0).getPath()).withRedirector(this.profileUtilities.redirectorStack(this.getRedirector(), outcome, currentBasePath)).withSourceStructureDefinition(tgt.getSource()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, newBaseCursor, start - 1, cursors.contextName, cursors.resultPathBase));
                    } else {
                        int newBaseCursor;
                        int newBaseLimit;
                        for (newBaseLimit = newBaseCursor = cursors.base.getElement().indexOf(tgt.getElement()) + 1; newBaseLimit < cursors.base.getElement().size() && cursors.base.getElement().get(newBaseLimit).getPath().startsWith(tgt.getElement().getPath() + "."); ++newBaseLimit) {
                        }
                        this.incrementDebugIndent().withBaseLimit(newBaseLimit - 1).withDiffLimit(cursors.diffCursor - 1).withContextPathSource(tgt.getElement().getPath()).withContextPathTarget(outcome.getPath()).withRedirector(this.profileUtilities.redirectorStack(this.getRedirector(), outcome, currentBasePath)).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, newBaseCursor, start, cursors.contextName, cursors.resultPathBase));
                    }
                } else {
                    StructureDefinition dt;
                    StructureDefinition structureDefinition = dt = outcome.getType().size() > 1 ? this.profileUtilities.getContext().fetchTypeDefinition("Element") : this.profileUtilities.getProfileForDataType(outcome.getType().get(0), this.getWebUrl(), this.getDerived());
                    if (dt == null) {
                        throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Unknown_type__at_", outcome.getType().get(0), currentBasePath));
                    }
                    cursors.contextName = dt.getUrl();
                    if (this.getRedirector() == null || this.getRedirector().isEmpty()) {
                        this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(cursors.diffCursor - 1).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withContextPathSource(currentBasePath).withContextPathTarget(outcome.getPath()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, start, cursors.contextName, cursors.resultPathBase));
                    } else {
                        this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(cursors.diffCursor - 1).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withContextPathSource(currentBasePath).withContextPathTarget(outcome.getPath()).withRedirector(this.profileUtilities.redirectorStack(this.getRedirector(), currentBase, currentBasePath)).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, start, cursors.contextName, cursors.resultPathBase));
                    }
                }
            }
        }
        ++cursors.baseCursor;
    }

    private void processPathWithSlicedBase(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, List<TypeSlice> typeList, ProfilePathProcessorState cursors) {
        String path = currentBase.getPath();
        if (diffMatches.isEmpty()) {
            this.processPathWithSlicedBaseAndEmptyDiffMatches(currentBase, currentBasePath, diffMatches, cursors, path);
        } else if (this.profileUtilities.diffsConstrainTypes(diffMatches, currentBasePath, typeList)) {
            this.processPathWithSlicedBaseWhereDiffsConstrainTypes(currentBasePath, diffMatches, typeList, cursors);
        } else {
            this.processPathWithSlicedBaseDefault(currentBase, currentBasePath, diffMatches, cursors, path);
        }
    }

    private void processPathWithSlicedBaseDefault(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, ProfilePathProcessorState cursors, String path) {
        boolean closed = currentBase.getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED;
        int diffpos = 0;
        if (diffMatches.get(0).hasSlicing()) {
            ElementDefinition.ElementDefinitionSlicingComponent dSlice = diffMatches.get(0).getSlicing();
            ElementDefinition.ElementDefinitionSlicingComponent bSlice = currentBase.getSlicing();
            if (dSlice.hasOrderedElement() && bSlice.hasOrderedElement() && !this.profileUtilities.orderMatches(dSlice.getOrderedElement(), bSlice.getOrderedElement())) {
                Object[] objectArray = new Object[4];
                objectArray[0] = ProfileUtilities.summarizeSlicing(dSlice);
                objectArray[1] = ProfileUtilities.summarizeSlicing(bSlice);
                objectArray[2] = path;
                objectArray[3] = cursors.contextName;
                throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Slicing_rules_on_differential__do_not_match_those_on_base___order___", objectArray));
            }
            if (!this.profileUtilities.discriminatorMatches(dSlice.getDiscriminator(), bSlice.getDiscriminator())) {
                Object[] objectArray = new Object[4];
                objectArray[0] = ProfileUtilities.summarizeSlicing(dSlice);
                objectArray[1] = ProfileUtilities.summarizeSlicing(bSlice);
                objectArray[2] = path;
                objectArray[3] = this.url;
                throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Slicing_rules_on_differential__do_not_match_those_on_base___disciminator___", objectArray));
            }
            if (!currentBase.isChoice() && !this.profileUtilities.ruleMatches(dSlice.getRules(), bSlice.getRules())) {
                Object[] objectArray = new Object[4];
                objectArray[0] = ProfileUtilities.summarizeSlicing(dSlice);
                objectArray[1] = ProfileUtilities.summarizeSlicing(bSlice);
                objectArray[2] = path;
                objectArray[3] = cursors.contextName;
                throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Slicing_rules_on_differential__do_not_match_those_on_base___rule___", objectArray));
            }
        }
        ElementDefinition outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), currentBase.copy());
        outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
        this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
        if (diffMatches.get(0).hasSlicing() || !diffMatches.get(0).hasSliceName()) {
            this.profileUtilities.updateFromSlicing(outcome.getSlicing(), diffMatches.get(0).getSlicing());
            this.profileUtilities.updateFromDefinition(outcome, diffMatches.get(0), this.getProfileName(), closed, this.getUrl(), this.getSourceStructureDefinition(), this.getDerived(), this.diffPath(diffMatches.get(0)));
            this.profileUtilities.removeStatusExtensions(outcome);
        } else if (!diffMatches.get(0).hasSliceName()) {
            diffMatches.get(0).setUserData("profileutilities.snapshot.processed", outcome);
        } else {
            outcome.setUserData("auto-added-slicing", true);
        }
        this.debugCheck(outcome);
        this.getResult().getElement().add(outcome);
        if (!diffMatches.get(0).hasSliceName()) {
            ++diffpos;
        }
        if (this.profileUtilities.hasInnerDiffMatches(this.getDifferential(), currentBasePath, cursors.diffCursor, this.getDiffLimit(), cursors.base.getElement(), false)) {
            int newBaseLimit = this.profileUtilities.findEndOfElement(cursors.base, cursors.baseCursor);
            int ndx = this.getDifferential().getElement().indexOf(diffMatches.get(0));
            int newDiffCursor = ndx + (diffMatches.get(0).hasSlicing() ? 1 : 0);
            int newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), ndx);
            if (newBaseLimit == cursors.baseCursor) {
                if (cursors.base.getElement().get(cursors.baseCursor).getType().size() != 1) {
                    throw new Error(this.profileUtilities.getContext().formatMessage("Differential_walks_into____but_the_base_does_not_and_there_is_not_a_single_fixed_type_The_type_is__This_is_not_handled_yet", currentBasePath, diffMatches.get(0).toString(), cursors.base.getElement().get(cursors.baseCursor).typeSummary()));
                }
                StructureDefinition dt = this.profileUtilities.getProfileForDataType(cursors.base.getElement().get(cursors.baseCursor).getType().get(0), this.getWebUrl(), this.getDerived());
                if (dt == null) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Unknown_type__at_", outcome.getType().get(0), diffMatches.get(0).getPath()));
                }
                cursors.contextName = dt.getUrl();
                while (this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), currentBasePath + ".")) {
                    ++cursors.diffCursor;
                }
                this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(newDiffLimit).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withContextPathSource(currentBasePath).withContextPathTarget(outcome.getPath()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, newDiffCursor, cursors.contextName, cursors.resultPathBase));
            } else {
                this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withRedirector(null).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor + 1, newDiffCursor, cursors.contextName, cursors.resultPathBase));
            }
        } else if (currentBase.getType().get(0).getCode().equals("BackboneElement")) {
            int newBaseLimit = this.profileUtilities.findEndOfElement(cursors.base, cursors.baseCursor);
            for (int i = cursors.baseCursor + 1; i <= newBaseLimit; ++i) {
                outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), cursors.base.getElement().get(i).copy());
                outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
                this.debugCheck(outcome);
                this.getResult().getElement().add(outcome);
            }
        }
        List<ElementDefinition> baseMatches = this.profileUtilities.getSiblings(cursors.base.getElement(), currentBase);
        for (ElementDefinition baseItem : baseMatches) {
            cursors.baseCursor = cursors.base.getElement().indexOf(baseItem);
            outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), baseItem.copy());
            this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
            outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
            outcome.setSlicing(null);
            if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
                throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path", new Object[0]));
            }
            if (diffpos < diffMatches.size() && diffMatches.get(diffpos).hasSliceName() && diffMatches.get(diffpos).getSliceName().equals(outcome.getSliceName())) {
                int newBaseLimit = this.profileUtilities.findEndOfElement(cursors.base, cursors.baseCursor);
                int newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(diffpos));
                int newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
                this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, diffpos)).withTrimDifferential(closed).withSlicing(new PathSlicingParams(true, null, null)).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor, newDiffCursor, cursors.contextName, cursors.resultPathBase));
                cursors.baseCursor = newBaseLimit;
                cursors.diffCursor = newDiffLimit + 1;
                ++diffpos;
                continue;
            }
            this.debugCheck(outcome);
            this.getResult().getElement().add(outcome);
            ++cursors.baseCursor;
            while (cursors.baseCursor < cursors.base.getElement().size() && cursors.base.getElement().get(cursors.baseCursor).getPath().startsWith(path) && !cursors.base.getElement().get(cursors.baseCursor).getPath().equals(path)) {
                outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), cursors.base.getElement().get(cursors.baseCursor).copy());
                outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
                if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path", new Object[0]));
                }
                outcome.setUserData("base.path", outcome.getPath());
                outcome.setUserData("base.model", this.getSourceStructureDefinition().getUrl());
                this.debugCheck(outcome);
                this.getResult().getElement().add(outcome);
                ++cursors.baseCursor;
            }
            --cursors.baseCursor;
        }
        if (closed && diffpos < diffMatches.size() && !currentBase.getPath().endsWith("[x]")) {
            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("The_base_snapshot_marks_a_slicing_as_closed_but_the_differential_tries_to_extend_it_in__at__", this.getProfileName(), path, currentBasePath));
        }
        if (diffpos != diffMatches.size()) {
            while (diffpos < diffMatches.size()) {
                ElementDefinition diffItem = diffMatches.get(diffpos);
                for (ElementDefinition baseItem : baseMatches) {
                    if (!baseItem.getSliceName().equals(diffItem.getSliceName())) continue;
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Named_items_are_out_of_order_in_the_slice", new Object[0]));
                }
                outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), currentBase.copy());
                outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
                this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
                outcome.setSlicing(null);
                outcome.setMin(0);
                if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path", new Object[0]));
                }
                this.debugCheck(outcome);
                this.getResult().getElement().add(outcome);
                this.profileUtilities.updateFromDefinition(outcome, diffItem, this.getProfileName(), this.isTrimDifferential(), this.getUrl(), this.getSourceStructureDefinition(), this.getDerived(), this.diffPath(diffItem));
                this.profileUtilities.removeStatusExtensions(outcome);
                cursors.diffCursor = this.getDifferential().getElement().indexOf(diffItem) + 1;
                if (!outcome.getType().isEmpty() && this.getDifferential().getElement().size() > cursors.diffCursor && outcome.getPath().contains(".") && !this.profileUtilities.baseWalksInto(cursors.base.getElement(), cursors.baseCursor) && this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                    ElementDefinition.TypeRefComponent t;
                    if (outcome.getType().size() > 1) {
                        for (ElementDefinition.TypeRefComponent t2 : outcome.getType()) {
                            if (t2.getCode().equals("Reference")) continue;
                            Object[] objectArray = new Object[4];
                            objectArray[0] = diffMatches.get(0).getPath();
                            objectArray[1] = this.getDifferential().getElement().get(cursors.diffCursor).getPath();
                            objectArray[2] = ProfileUtilities.typeCode(outcome.getType());
                            objectArray[3] = this.getProfileName();
                            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("_has_children__and_multiple_types__in_profile_", objectArray));
                        }
                    }
                    if ((t = outcome.getType().get(0)).getCode().equals("BackboneElement")) {
                        int baseMax;
                        int baseStart = cursors.base.getElement().indexOf(currentBase) + 1;
                        for (baseMax = baseStart + 1; baseMax < cursors.base.getElement().size() && cursors.base.getElement().get(baseMax).getPath().startsWith(currentBase.getPath() + "."); ++baseMax) {
                        }
                        int start = cursors.diffCursor;
                        while (this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                            ++cursors.diffCursor;
                        }
                        this.incrementDebugIndent().withBaseLimit(baseMax - 1).withDiffLimit(cursors.diffCursor - 1).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withContextPathSource(cursors.base.getElement().get(0).getPath()).withContextPathTarget(cursors.base.getElement().get(0).getPath()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, baseStart, start - 1, cursors.contextName, cursors.resultPathBase));
                    } else {
                        StructureDefinition dt = this.profileUtilities.getProfileForDataType(outcome.getType().get(0), this.getWebUrl(), this.getDerived());
                        if (dt == null) {
                            Object[] objectArray = new Object[4];
                            objectArray[0] = diffMatches.get(0).getPath();
                            objectArray[1] = this.getDifferential().getElement().get(cursors.diffCursor).getPath();
                            objectArray[2] = ProfileUtilities.typeCode(outcome.getType());
                            objectArray[3] = this.getProfileName();
                            throw new DefinitionException(this.profileUtilities.getContext().formatMessage("_has_children__for_type__in_profile__but_cant_find_type", objectArray));
                        }
                        cursors.contextName = dt.getUrl();
                        int start = cursors.diffCursor;
                        while (this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                            ++cursors.diffCursor;
                        }
                        this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(cursors.diffCursor - 1).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withContextPathSource(diffMatches.get(0).getPath()).withContextPathTarget(outcome.getPath()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, start - 1, cursors.contextName, cursors.resultPathBase));
                    }
                }
                ++diffpos;
            }
        }
        ++cursors.baseCursor;
    }

    private void debugCheck(ElementDefinition outcome) {
        if (outcome.getPath().startsWith("List.") && "http://nictiz.nl/fhir/StructureDefinition/Bundle-MedicationOverview".equals(this.url)) {
            System.out.println("wrong!");
        }
    }

    private void processPathWithSlicedBaseWhereDiffsConstrainTypes(String currentBasePath, List<ElementDefinition> diffMatches, List<TypeSlice> typeList, ProfilePathProcessorState cursors) {
        boolean shortCut;
        int start = 0;
        int newBaseLimit = this.profileUtilities.findEndOfElement(cursors.base, cursors.baseCursor);
        int newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(0));
        ElementDefinition elementToRemove = null;
        boolean bl = shortCut = !typeList.isEmpty() && typeList.get((int)0).type != null || diffMatches.get(0).hasSliceName() && !diffMatches.get(0).hasSlicing();
        if (shortCut) {
            ElementDefinition ed;
            if (!VersionUtilities.isR4Plus((String)this.profileUtilities.getContext().getVersion()) || !this.profileUtilities.isNewSlicingProcessing()) {
                ed = new ElementDefinition();
                ed.setPath(this.profileUtilities.determineTypeSlicePath(diffMatches.get(0).getPath(), currentBasePath));
                for (TypeSlice ts : typeList) {
                    ed.addType().setCode(ts.type);
                }
                ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                ed.getSlicing().setOrdered(false);
                diffMatches.add(0, ed);
                this.getDifferential().getElement().add(newDiffCursor, ed);
                elementToRemove = ed;
            } else {
                ed = new ElementDefinition();
                ed.setPath(this.profileUtilities.determineTypeSlicePath(diffMatches.get(0).getPath(), currentBasePath));
                ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                ed.getSlicing().setOrdered(false);
                diffMatches.add(0, ed);
                this.getDifferential().getElement().add(newDiffCursor, ed);
                elementToRemove = ed;
            }
        }
        int newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
        if (diffMatches.get(0).getSlicing().hasOrdered() && diffMatches.get(0).getSlicing().getOrdered()) {
            throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingordered__true", currentBasePath, this.getUrl()));
        }
        if (diffMatches.get(0).getSlicing().hasDiscriminator()) {
            if (diffMatches.get(0).getSlicing().getDiscriminator().size() != 1) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorcount__1", currentBasePath, this.getUrl()));
            }
            if (diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getType() != ElementDefinition.DiscriminatorType.TYPE) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatortype__type", currentBasePath, this.getUrl()));
            }
            if (!"$this".equals(diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getPath())) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorpath__this", currentBasePath, this.getUrl()));
            }
        }
        for (TypeSlice ts : typeList) {
            if (ts.type == null) continue;
            String tn = this.profileUtilities.rootName(currentBasePath) + Utilities.capitalize((String)ts.type);
            if (!ts.defn.hasSliceName()) {
                ts.defn.setSliceName(tn);
            } else if (!ts.defn.getSliceName().equals(tn)) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__Slice_name_must_be__but_is_", !Utilities.noString((String)this.getContextPathSource()) ? this.getContextPathSource() : currentBasePath, tn, ts.defn.getSliceName()));
            }
            if (!ts.defn.hasType()) {
                ts.defn.addType().setCode(ts.type);
                continue;
            }
            if (ts.defn.getType().size() > 1) {
                throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__Slice_for_type__has_more_than_one_type_", !Utilities.noString((String)this.getContextPathSource()) ? this.getContextPathSource() : currentBasePath, tn, ts.defn.typeSummary()));
            }
            if (ts.defn.getType().get(0).getCode().equals(ts.type)) continue;
            throw new FHIRException(this.profileUtilities.getContext().formatMessage("Error_at_path__Slice_for_type__has_wrong_type_", !Utilities.noString((String)this.getContextPathSource()) ? this.getContextPathSource() : currentBasePath, tn, ts.defn.typeSummary()));
        }
        ElementDefinition e = this.incrementDebugIndent().withBaseLimit(newBaseLimit).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, 0)).withSlicing(new PathSlicingParams(true, null, currentBasePath)).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor, newDiffCursor, cursors.contextName, cursors.resultPathBase));
        if (e == null) {
            throw new FHIRException(this.profileUtilities.getContext().formatMessage("Did_not_find_type_root_", diffMatches.get(0).getPath()));
        }
        e.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
        e.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
        e.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
        e.getSlicing().setOrdered(false);
        String fixedType = null;
        List<BaseTypeSlice> baseSlices = this.profileUtilities.findBaseSlices(cursors.base, newBaseLimit);
        for (int i = ++start; i < diffMatches.size(); ++i) {
            String type = this.profileUtilities.determineFixedType(diffMatches, fixedType, i);
            if (diffMatches.get(i).getMin() > 0) {
                if (diffMatches.size() > i + 1) {
                    throw new FHIRException(this.profileUtilities.getContext().formatMessage("Invalid_slicing__there_is_more_than_one_type_slice_at__but_one_of_them__has_min__1_so_the_other_slices_cannot_exist", diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
                }
                fixedType = type;
            }
            newDiffCursor = this.getDifferential().getElement().indexOf(diffMatches.get(i));
            newDiffLimit = this.profileUtilities.findEndOfElement(this.getDifferential(), newDiffCursor);
            int sStart = cursors.baseCursor;
            int sEnd = newBaseLimit;
            BaseTypeSlice bs = this.profileUtilities.chooseMatchingBaseSlice(baseSlices, type);
            if (bs != null) {
                sStart = bs.getStart();
                sEnd = bs.getEnd();
                bs.setHandled(true);
            }
            this.incrementDebugIndent().withBaseLimit(sEnd).withDiffLimit(newDiffLimit).withProfileName(this.getProfileName() + this.profileUtilities.pathTail(diffMatches, i)).withSlicing(new PathSlicingParams(true, e, currentBasePath)).processPaths(new ProfilePathProcessorState(cursors.base, sStart, newDiffCursor, cursors.contextName, cursors.resultPathBase));
        }
        if (elementToRemove != null) {
            this.getDifferential().getElement().remove(elementToRemove);
            --newDiffLimit;
        }
        if (fixedType != null) {
            Iterator<ElementDefinition.TypeRefComponent> iter = e.getType().iterator();
            while (iter.hasNext()) {
                ElementDefinition.TypeRefComponent tr = iter.next();
                if (tr.getCode().equals(fixedType)) continue;
                iter.remove();
            }
        }
        for (BaseTypeSlice bs : baseSlices) {
            if (bs.isHandled()) continue;
            StructureDefinition.StructureDefinitionDifferentialComponent fakeDiff = new StructureDefinition.StructureDefinitionDifferentialComponent();
            fakeDiff.getElementFirstRep().setPath(bs.getDefn().getPath());
            this.incrementDebugIndent().withDifferential(fakeDiff).withBaseLimit(bs.getEnd()).withDiffLimit(0).withProfileName(this.getProfileName() + this.profileUtilities.tail(bs.getDefn().getPath())).withSlicing(new PathSlicingParams(true, e, currentBasePath)).processPaths(new ProfilePathProcessorState(cursors.base, bs.getStart(), 0, cursors.contextName, cursors.resultPathBase));
        }
        cursors.baseCursor = baseSlices.get(baseSlices.size() - 1).getEnd() + 1;
        cursors.diffCursor = newDiffLimit + 1;
    }

    private void processPathWithSlicedBaseAndEmptyDiffMatches(ElementDefinition currentBase, String currentBasePath, List<ElementDefinition> diffMatches, ProfilePathProcessorState cursors, String path) {
        if (this.profileUtilities.hasInnerDiffMatches(this.getDifferential(), path, cursors.diffCursor, this.getDiffLimit(), cursors.base.getElement(), true)) {
            ElementDefinition outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), currentBase.copy());
            outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
            this.profileUtilities.updateFromBase(outcome, currentBase, this.getSourceStructureDefinition().getUrl());
            this.profileUtilities.markDerived(outcome);
            if (cursors.resultPathBase == null) {
                cursors.resultPathBase = outcome.getPath();
            } else if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
                throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path", new Object[0]));
            }
            this.debugCheck(outcome);
            this.getResult().getElement().add(outcome);
            if (this.baseHasChildren(cursors.base, currentBase)) {
                this.incrementDebugIndent().withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(cursors.base, cursors.baseCursor + 1, cursors.diffCursor, cursors.contextName, cursors.resultPathBase));
                cursors.baseCursor = this.indexOfFirstNonChild(cursors.base, currentBase, cursors.baseCursor, this.getBaseLimit());
            } else {
                StructureDefinition dt = this.profileUtilities.getTypeForElement(this.getDifferential(), cursors.diffCursor, this.getProfileName(), diffMatches, outcome, this.getWebUrl(), this.getDerived());
                cursors.contextName = dt.getUrl();
                int start = cursors.diffCursor;
                if (this.getDifferential().getElement().get(cursors.diffCursor).getPath().equals(currentBasePath)) {
                    ++cursors.diffCursor;
                }
                while (this.getDifferential().getElement().size() > cursors.diffCursor && this.profileUtilities.pathStartsWith(this.getDifferential().getElement().get(cursors.diffCursor).getPath(), currentBasePath + ".")) {
                    ++cursors.diffCursor;
                }
                if (cursors.diffCursor > start) {
                    this.incrementDebugIndent().withBaseLimit(dt.getSnapshot().getElement().size() - 1).withDiffLimit(cursors.diffCursor - 1).withWebUrl(this.profileUtilities.getWebUrl(dt, this.getWebUrl())).withContextPathSource(currentBasePath).withContextPathTarget(outcome.getPath()).withSlicing(new PathSlicingParams()).processPaths(new ProfilePathProcessorState(dt.getSnapshot(), 1, start, cursors.contextName, cursors.resultPathBase));
                }
            }
            ++cursors.baseCursor;
        } else {
            while (cursors.baseCursor < cursors.base.getElement().size() && cursors.base.getElement().get(cursors.baseCursor).getPath().startsWith(path)) {
                ElementDefinition outcome = this.profileUtilities.updateURLs(this.getUrl(), this.getWebUrl(), cursors.base.getElement().get(cursors.baseCursor).copy());
                outcome.setPath(this.profileUtilities.fixedPathDest(this.getContextPathTarget(), outcome.getPath(), this.getRedirector(), this.getContextPathSource()));
                if (!outcome.getPath().startsWith(cursors.resultPathBase)) {
                    throw new DefinitionException(this.profileUtilities.getContext().formatMessage("Adding_wrong_path_in_profile___vs_", this.getProfileName(), outcome.getPath(), cursors.resultPathBase));
                }
                this.debugCheck(outcome);
                this.getResult().getElement().add(outcome);
                outcome.setUserData("base.model", this.getSourceStructureDefinition().getUrl());
                outcome.setUserData("base.path", cursors.resultPathBase);
                ++cursors.baseCursor;
            }
        }
    }

    private boolean oneMatchingElementInDifferential(boolean slicingDone, String path, List<ElementDefinition> diffMatches) {
        if (diffMatches.size() != 1) {
            return false;
        }
        if (slicingDone) {
            return true;
        }
        if (this.profileUtilities.isImplicitSlicing(diffMatches.get(0), path)) {
            return false;
        }
        return !diffMatches.get(0).hasSlicing() && (!this.profileUtilities.isExtension(diffMatches.get(0)) || !diffMatches.get(0).hasSliceName());
    }

    private ProfilePathProcessor(ProfileUtilities profileUtilities, String debugIndent, StructureDefinition.StructureDefinitionSnapshotComponent result, StructureDefinition.StructureDefinitionDifferentialComponent differential, int baseLimit, int diffLimit, String url, String webUrl, String profileName, String contextPathSource, String contextPathTarget, boolean trimDifferential, List<ElementRedirection> redirector, StructureDefinition sourceStructureDefinition, StructureDefinition derived, PathSlicingParams slicing) {
        this.profileUtilities = profileUtilities;
        this.debugIndent = debugIndent;
        this.result = result;
        this.differential = differential;
        this.baseLimit = baseLimit;
        this.diffLimit = diffLimit;
        this.url = url;
        this.webUrl = webUrl;
        this.profileName = profileName;
        this.contextPathSource = contextPathSource;
        this.contextPathTarget = contextPathTarget;
        this.trimDifferential = trimDifferential;
        this.redirector = redirector;
        this.sourceStructureDefinition = sourceStructureDefinition;
        this.derived = derived;
        this.slicing = slicing;
    }

    public ProfileUtilities getProfileUtilities() {
        return this.profileUtilities;
    }

    public String getDebugIndent() {
        return this.debugIndent;
    }

    public ProfilePathProcessor withDebugIndent(String debugIndent) {
        return this.debugIndent == debugIndent ? this : new ProfilePathProcessor(this.profileUtilities, debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public StructureDefinition.StructureDefinitionSnapshotComponent getResult() {
        return this.result;
    }

    public ProfilePathProcessor withResult(StructureDefinition.StructureDefinitionSnapshotComponent result) {
        return this.result == result ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public StructureDefinition.StructureDefinitionDifferentialComponent getDifferential() {
        return this.differential;
    }

    public ProfilePathProcessor withDifferential(StructureDefinition.StructureDefinitionDifferentialComponent differential) {
        return this.differential == differential ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public int getBaseLimit() {
        return this.baseLimit;
    }

    public ProfilePathProcessor withBaseLimit(int baseLimit) {
        return this.baseLimit == baseLimit ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public int getDiffLimit() {
        return this.diffLimit;
    }

    public ProfilePathProcessor withDiffLimit(int diffLimit) {
        return this.diffLimit == diffLimit ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public String getUrl() {
        return this.url;
    }

    public ProfilePathProcessor withUrl(String url) {
        return this.url == url ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public ProfilePathProcessor withWebUrl(String webUrl) {
        return this.webUrl == webUrl ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public ProfilePathProcessor withProfileName(String profileName) {
        return this.profileName == profileName ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public String getContextPathSource() {
        return this.contextPathSource;
    }

    public ProfilePathProcessor withContextPathSource(String contextPathSource) {
        return this.contextPathSource == contextPathSource ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public String getContextPathTarget() {
        return this.contextPathTarget;
    }

    public ProfilePathProcessor withContextPathTarget(String contextPathTarget) {
        return this.contextPathTarget == contextPathTarget ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public boolean isTrimDifferential() {
        return this.trimDifferential;
    }

    public ProfilePathProcessor withTrimDifferential(boolean trimDifferential) {
        return this.trimDifferential == trimDifferential ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public List<ElementRedirection> getRedirector() {
        return this.redirector;
    }

    public ProfilePathProcessor withRedirector(List<ElementRedirection> redirector) {
        return this.redirector == redirector ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, redirector, this.sourceStructureDefinition, this.derived, this.slicing);
    }

    public StructureDefinition getSourceStructureDefinition() {
        return this.sourceStructureDefinition;
    }

    public ProfilePathProcessor withSourceStructureDefinition(StructureDefinition sourceStructureDefinition) {
        return this.sourceStructureDefinition == sourceStructureDefinition ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, sourceStructureDefinition, this.derived, this.slicing);
    }

    public StructureDefinition getDerived() {
        return this.derived;
    }

    public ProfilePathProcessor withDerived(StructureDefinition derived) {
        return this.derived == derived ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, derived, this.slicing);
    }

    public PathSlicingParams getSlicing() {
        return this.slicing;
    }

    public ProfilePathProcessor withSlicing(PathSlicingParams slicing) {
        return this.slicing == slicing ? this : new ProfilePathProcessor(this.profileUtilities, this.debugIndent, this.result, this.differential, this.baseLimit, this.diffLimit, this.url, this.webUrl, this.profileName, this.contextPathSource, this.contextPathTarget, this.trimDifferential, this.redirector, this.sourceStructureDefinition, this.derived, slicing);
    }
}

