/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class TerminologyCache {
    public static final boolean TRANSIENT = false;
    public static final boolean PERMANENT = true;
    private static final String NAME_FOR_NO_SYSTEM = "all-systems";
    private static final String ENTRY_MARKER = "-------------------------------------------------------------------------------------";
    private static final String BREAK = "####";
    private static final String CACHE_FILE_EXTENSION = ".cache";
    private static final String CAPABILITY_STATEMENT_TITLE = ".capabilityStatement";
    private static final String TERMINOLOGY_CAPABILITIES_TITLE = ".terminologyCapabilities";
    private SystemNameKeyGenerator systemNameKeyGenerator = new SystemNameKeyGenerator();
    private Object lock;
    private String folder;
    private int requestCount;
    private int hitCount;
    private int networkCount;
    private CapabilityStatement capabilityStatementCache = null;
    private TerminologyCapabilities terminologyCapabilitiesCache = null;
    private Map<String, NamedCache> caches = new HashMap<String, NamedCache>();
    private static boolean noCaching;
    private static boolean cacheErrors;

    protected SystemNameKeyGenerator getSystemNameKeyGenerator() {
        return this.systemNameKeyGenerator;
    }

    public TerminologyCache(Object lock, String folder) throws FileNotFoundException, IOException, FHIRException {
        this.lock = lock;
        this.folder = folder;
        this.requestCount = 0;
        this.hitCount = 0;
        this.networkCount = 0;
        if (folder != null) {
            this.load();
        }
    }

    public boolean hasCapabilityStatement() {
        return this.capabilityStatementCache != null;
    }

    public CapabilityStatement getCapabilityStatement() {
        return this.capabilityStatementCache;
    }

    public void cacheCapabilityStatement(CapabilityStatement capabilityStatement) {
        if (noCaching) {
            return;
        }
        this.capabilityStatementCache = capabilityStatement;
        this.save(this.capabilityStatementCache, CAPABILITY_STATEMENT_TITLE);
    }

    public boolean hasTerminologyCapabilities() {
        return this.terminologyCapabilitiesCache != null;
    }

    public TerminologyCapabilities getTerminologyCapabilities() {
        return this.terminologyCapabilitiesCache;
    }

    public void cacheTerminologyCapabilities(TerminologyCapabilities terminologyCapabilities) {
        if (noCaching) {
            return;
        }
        this.terminologyCapabilitiesCache = terminologyCapabilities;
        this.save(this.terminologyCapabilitiesCache, TERMINOLOGY_CAPABILITIES_TITLE);
    }

    public void clear() {
        this.caches.clear();
    }

    public CacheToken generateValidationToken(ValidationOptions options, Coding code, ValueSet vs, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            if (code.hasSystem()) {
                ct.setName(code.getSystem());
                ct.hasVersion = code.hasVersion();
            } else {
                ct.name = NAME_FOR_NO_SYSTEM;
            }
            this.nameCacheToken(vs, ct);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            if (vs != null && vs.hasUrl() && vs.hasVersion()) {
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"url\": \"" + Utilities.escapeJson((String)vs.getUrl()) + "\", \"version\": \"" + Utilities.escapeJson((String)vs.getVersion()) + "\"" + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}\r\n";
            } else {
                ValueSet vsc = this.getVSEssense(vs);
                ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + (vsc == null ? "null" : this.extracted(json, vsc)) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            }
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public CacheToken generateValidationToken(ValidationOptions options, Coding code, String vsUrl, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            if (code.hasSystem()) {
                ct.setName(code.getSystem());
                ct.hasVersion = code.hasVersion();
            } else {
                ct.name = NAME_FOR_NO_SYSTEM;
            }
            ct.setName(vsUrl);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + (vsUrl == null ? "null" : vsUrl) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String extracted(JsonParser json, ValueSet vsc) throws IOException {
        String s = null;
        s = vsc.getExpansion().getContains().size() > 1000 || vsc.getCompose().getIncludeFirstRep().getConcept().size() > 1000 ? vsc.getUrl() : json.composeString(vsc);
        return s;
    }

    public CacheToken generateValidationToken(ValidationOptions options, CodeableConcept code, ValueSet vs, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) continue;
                ct.setName(c.getSystem());
                ct.hasVersion = c.hasVersion();
            }
            this.nameCacheToken(vs, ct);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            if (vs != null && vs.hasUrl() && vs.hasVersion()) {
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"url\": \"" + Utilities.escapeJson((String)vs.getUrl()) + "\", \"version\": \"" + Utilities.escapeJson((String)vs.getVersion()) + "\"" + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}\r\n";
            } else {
                ValueSet vsc = this.getVSEssense(vs);
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"valueSet\" :" + this.extracted(json, vsc) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            }
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public ValueSet getVSEssense(ValueSet vs) {
        if (vs == null) {
            return null;
        }
        ValueSet vsc = new ValueSet();
        vsc.setCompose(vs.getCompose());
        if (vs.hasExpansion()) {
            vsc.getExpansion().getParameter().addAll(vs.getExpansion().getParameter());
            vsc.getExpansion().getContains().addAll(vs.getExpansion().getContains());
        }
        return vsc;
    }

    public CacheToken generateExpandToken(ValueSet vs, boolean hierarchical) {
        CacheToken ct = new CacheToken();
        this.nameCacheToken(vs, ct);
        if (vs.hasUrl() && vs.hasVersion()) {
            ct.request = "{\"hierarchical\" : " + (hierarchical ? "true" : "false") + ", \"url\": \"" + Utilities.escapeJson((String)vs.getUrl()) + "\", \"version\": \"" + Utilities.escapeJson((String)vs.getVersion()) + "\"}\r\n";
        } else {
            ValueSet vsc = this.getVSEssense(vs);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            try {
                ct.request = "{\"hierarchical\" : " + (hierarchical ? "true" : "false") + ", \"valueSet\" :" + this.extracted(json, vsc) + "}\r\n";
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        ct.key = String.valueOf(this.hashJson(ct.request));
        return ct;
    }

    public void nameCacheToken(ValueSet vs, CacheToken ct) {
        if (vs != null) {
            for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getInclude()) {
                if (!conceptSetComponent.hasSystem()) continue;
                ct.setName(conceptSetComponent.getSystem());
                ct.hasVersion = conceptSetComponent.hasVersion();
            }
            for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getExclude()) {
                if (!conceptSetComponent.hasSystem()) continue;
                ct.setName(conceptSetComponent.getSystem());
                ct.hasVersion = conceptSetComponent.hasVersion();
            }
            for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : vs.getExpansion().getContains()) {
                if (!valueSetExpansionContainsComponent.hasSystem()) continue;
                ct.setName(valueSetExpansionContainsComponent.getSystem());
                ct.hasVersion = valueSetExpansionContainsComponent.hasVersion();
            }
        }
    }

    private String normalizeSystemPath(String path) {
        return path.replace("/", "").replace('|', 'X');
    }

    public NamedCache getNamedCache(CacheToken cacheToken) {
        String cacheName = cacheToken.name == null ? "null" : cacheToken.name;
        NamedCache nc = this.caches.get(cacheName);
        if (nc == null) {
            nc = new NamedCache();
            nc.name = cacheName;
            this.caches.put(nc.name, nc);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSetExpansionOutcome getExpansion(CacheToken cacheToken) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                return null;
            }
            return e.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheExpansion(CacheToken cacheToken, ValueSetExpansionOutcome res, boolean persistent) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = new CacheEntry();
            e.request = cacheToken.request;
            e.persistent = persistent;
            e.e = res;
            this.store(cacheToken, persistent, nc, e);
        }
    }

    public void store(CacheToken cacheToken, boolean persistent, NamedCache nc, CacheEntry e) {
        if (noCaching) {
            return;
        }
        if (!cacheErrors && e.v != null && e.v.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED && !cacheToken.hasVersion) {
            return;
        }
        boolean n = nc.map.containsKey(cacheToken.key);
        nc.map.put(cacheToken.key, e);
        if (persistent) {
            if (n) {
                for (int i = nc.list.size() - 1; i >= 0; --i) {
                    if (!nc.list.get((int)i).request.equals(e.request)) continue;
                    nc.list.remove(i);
                }
            }
            nc.list.add(e);
            this.save(nc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkerContext.ValidationResult getValidation(CacheToken cacheToken) {
        if (cacheToken.key == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            ++this.requestCount;
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                ++this.networkCount;
                return null;
            }
            ++this.hitCount;
            return e.v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheValidation(CacheToken cacheToken, IWorkerContext.ValidationResult res, boolean persistent) {
        if (cacheToken.key != null) {
            Object object = this.lock;
            synchronized (object) {
                NamedCache nc = this.getNamedCache(cacheToken);
                CacheEntry e = new CacheEntry();
                e.request = cacheToken.request;
                e.persistent = persistent;
                e.v = res;
                this.store(cacheToken, persistent, nc, e);
            }
        }
    }

    public void save() {
    }

    private <K extends Resource> void save(K resource, String title) {
        if (this.folder == null) {
            return;
        }
        try {
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.folder, title + CACHE_FILE_EXTENSION})), "UTF-8");
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            sw.write(json.composeString(resource).trim());
            sw.close();
        }
        catch (Exception e) {
            System.out.println("error saving capability statement " + e.getMessage());
        }
    }

    private void save(NamedCache nc) {
        if (this.folder == null) {
            return;
        }
        try {
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.folder, nc.name + CACHE_FILE_EXTENSION})), "UTF-8");
            sw.write("-------------------------------------------------------------------------------------\r\n");
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            for (CacheEntry ce : nc.list) {
                sw.write(ce.request.trim());
                sw.write("####\r\n");
                if (ce.e != null) {
                    sw.write("e: {\r\n");
                    if (ce.e.getValueset() != null) {
                        sw.write("  \"valueSet\" : " + json.composeString(ce.e.getValueset()).trim() + ",\r\n");
                    }
                    sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.e.getError()).trim() + "\"\r\n}\r\n");
                } else {
                    sw.write("v: {\r\n");
                    boolean first = true;
                    if (ce.v.getDisplay() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"display\" : \"" + Utilities.escapeJson((String)ce.v.getDisplay()).trim() + "\"");
                    }
                    if (ce.v.getCode() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"code\" : \"" + Utilities.escapeJson((String)ce.v.getCode()).trim() + "\"");
                    }
                    if (ce.v.getSystem() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"system\" : \"" + Utilities.escapeJson((String)ce.v.getSystem()).trim() + "\"");
                    }
                    if (ce.v.getVersion() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"version\" : \"" + Utilities.escapeJson((String)ce.v.getVersion()).trim() + "\"");
                    }
                    if (ce.v.getSeverity() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"severity\" : \"" + ce.v.getSeverity().toCode().trim() + "\"");
                    }
                    if (ce.v.getMessage() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.v.getMessage()).trim() + "\"");
                    }
                    if (ce.v.getErrorClass() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"class\" : \"" + Utilities.escapeJson((String)ce.v.getErrorClass().toString()) + "\"");
                    }
                    if (ce.v.getDefinition() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"definition\" : \"" + Utilities.escapeJson((String)ce.v.getDefinition()).trim() + "\"");
                    }
                    if (ce.v.getUnknownSystems() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"unknown-systems\" : \"" + Utilities.escapeJson((String)CommaSeparatedStringBuilder.join((String)",", ce.v.getUnknownSystems())).trim() + "\"");
                    }
                    if (ce.v.getIssues() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        OperationOutcome oo = new OperationOutcome();
                        oo.setIssue(ce.v.getIssues());
                        sw.write("  \"issues\" : " + json.composeString(oo).trim() + "\r\n");
                    }
                    sw.write("\r\n}\r\n");
                }
                sw.write("-------------------------------------------------------------------------------------\r\n");
            }
            sw.close();
        }
        catch (Exception e) {
            System.out.println("error saving " + nc.name + ": " + e.getMessage());
        }
    }

    private boolean isCapabilityCache(String fn) {
        if (fn == null) {
            return false;
        }
        return fn.startsWith(CAPABILITY_STATEMENT_TITLE) || fn.startsWith(TERMINOLOGY_CAPABILITIES_TITLE);
    }

    private void loadCapabilityCache(String fn) {
        try {
            String src = TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, fn}));
            JsonObject o = (JsonObject)new com.google.gson.JsonParser().parse(src);
            Resource resource = new JsonParser().parse(o);
            if (fn.startsWith(CAPABILITY_STATEMENT_TITLE)) {
                this.capabilityStatementCache = (CapabilityStatement)resource;
            } else if (fn.startsWith(TERMINOLOGY_CAPABILITIES_TITLE)) {
                this.terminologyCapabilitiesCache = (TerminologyCapabilities)resource;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FHIRException("Error loading " + fn + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private CacheEntry getCacheEntry(String request, String resultString) throws IOException {
        CacheEntry ce = new CacheEntry();
        ce.persistent = true;
        ce.request = request;
        boolean e = resultString.charAt(0) == 'e';
        resultString = resultString.substring(3);
        JsonObject o = (JsonObject)new com.google.gson.JsonParser().parse(resultString);
        String error = this.loadJS(o.get("error"));
        if (e) {
            ce.e = o.has("valueSet") ? new ValueSetExpansionOutcome((ValueSet)new JsonParser().parse(o.getAsJsonObject("valueSet")), error, TerminologyServiceErrorClass.UNKNOWN) : new ValueSetExpansionOutcome(error, TerminologyServiceErrorClass.UNKNOWN);
        } else {
            String t = this.loadJS(o.get("severity"));
            ValidationMessage.IssueSeverity severity = t == null ? null : ValidationMessage.IssueSeverity.fromCode((String)t);
            String display = this.loadJS(o.get("display"));
            String code = this.loadJS(o.get("code"));
            String system = this.loadJS(o.get("system"));
            String version = this.loadJS(o.get("version"));
            String definition = this.loadJS(o.get("definition"));
            String unknownSystems = this.loadJS(o.get("unknown-systems"));
            OperationOutcome oo = o.has("issues") ? (OperationOutcome)new JsonParser().parse(o.getAsJsonObject("issues")) : null;
            t = this.loadJS(o.get("class"));
            TerminologyServiceErrorClass errorClass = t == null ? null : TerminologyServiceErrorClass.valueOf(t);
            ce.v = new IWorkerContext.ValidationResult(severity, error, system, version, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setDefinition(definition).setCode(code), display, null).setErrorClass(errorClass);
            ce.v.setUnknownSystems(CommaSeparatedStringBuilder.toSet((String)unknownSystems));
            if (oo != null) {
                ce.v.setIssues(oo.getIssue());
            }
        }
        return ce;
    }

    private void loadNamedCache(String fn) {
        int c = 0;
        try {
            String src = TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, fn}));
            String title = fn.substring(0, fn.lastIndexOf("."));
            NamedCache nc = new NamedCache();
            nc.name = title;
            if (src.startsWith("?")) {
                src = src.substring(1);
            }
            int i = src.indexOf(ENTRY_MARKER);
            while (i > -1) {
                ++c;
                String s = src.substring(0, i);
                src = src.substring(i + ENTRY_MARKER.length() + 1);
                i = src.indexOf(ENTRY_MARKER);
                if (!Utilities.noString((String)s)) {
                    int j = s.indexOf(BREAK);
                    String request = s.substring(0, j);
                    String p = s.substring(j + BREAK.length() + 1).trim();
                    CacheEntry cacheEntry = this.getCacheEntry(request, p);
                    nc.map.put(String.valueOf(this.hashJson(cacheEntry.request)), cacheEntry);
                    nc.list.add(cacheEntry);
                }
                this.caches.put(nc.name, nc);
            }
        }
        catch (Exception e) {
            System.out.println("Error loading " + fn + ": " + e.getMessage() + " entry " + c + " - ignoring it");
            e.printStackTrace();
        }
    }

    private void load() throws FHIRException {
        for (String fn : new File(this.folder).list()) {
            if (!fn.endsWith(CACHE_FILE_EXTENSION) || fn.equals("validation.cache")) continue;
            if (this.isCapabilityCache(fn)) {
                this.loadCapabilityCache(fn);
                continue;
            }
            this.loadNamedCache(fn);
        }
    }

    private String loadJS(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (!(e instanceof JsonPrimitive)) {
            return null;
        }
        String s = e.getAsString();
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    protected String hashJson(String s) {
        return String.valueOf(s.trim().hashCode());
    }

    public String summary(ValueSet vs) {
        if (vs == null) {
            return "null";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            b.append("Include " + this.getIncSummary(cc));
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getExclude()) {
            b.append("Exclude " + this.getIncSummary(cc));
        }
        return b.toString();
    }

    private String getIncSummary(ValueSet.ConceptSetComponent cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (UriType uriType : cc.getValueSet()) {
            b.append(uriType.asStringValue());
        }
        String vsd = b.length() > 0 ? " where the codes are in the value sets (" + b.toString() + ")" : "";
        String string = cc.getSystem();
        if (cc.hasConcept()) {
            return Integer.toString(cc.getConcept().size()) + " codes from " + string + vsd;
        }
        if (cc.hasFilter()) {
            Object s = "";
            for (ValueSet.ConceptSetFilterComponent f : cc.getFilter()) {
                if (!Utilities.noString((String)s)) {
                    s = (String)s + " & ";
                }
                s = (String)s + f.getProperty() + " " + (f.hasOp() ? f.getOp().toCode() : "?") + " " + f.getValue();
            }
            return "from " + string + " where " + (String)s + vsd;
        }
        return "All codes from " + string + vsd;
    }

    public String summary(Coding code) {
        return code.getSystem() + "#" + code.getCode() + ": \"" + code.getDisplay() + "\"";
    }

    public String summary(CodeableConcept code) {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (Coding c : code.getCoding()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.summary(c));
        }
        b.append("}: \"");
        b.append(code.getText());
        b.append("\"");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCS(String url) {
        Object object = this.lock;
        synchronized (object) {
            String name = this.getSystemNameKeyGenerator().getNameForSystem(url);
            if (this.caches.containsKey(name)) {
                this.caches.remove(name);
            }
        }
    }

    public String getFolder() {
        return this.folder;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getNetworkCount() {
        return this.networkCount;
    }

    public static boolean isNoCaching() {
        return noCaching;
    }

    public static void setNoCaching(boolean noCaching) {
        TerminologyCache.noCaching = noCaching;
    }

    public static boolean isCacheErrors() {
        return cacheErrors;
    }

    public static void setCacheErrors(boolean cacheErrors) {
        TerminologyCache.cacheErrors = cacheErrors;
    }

    private class NamedCache {
        private String name;
        private List<CacheEntry> list = new ArrayList<CacheEntry>();
        private Map<String, CacheEntry> map = new HashMap<String, CacheEntry>();

        private NamedCache() {
        }
    }

    private class CacheEntry {
        private String request;
        private boolean persistent;
        private IWorkerContext.ValidationResult v;
        private ValueSetExpansionOutcome e;

        private CacheEntry() {
        }
    }

    public class SystemNameKeyGenerator {
        public static final String SNOMED_SCT_CODESYSTEM_URL = "http://snomed.info/sct";
        public static final String RXNORM_CODESYSTEM_URL = "http://www.nlm.nih.gov/research/umls/rxnorm";
        public static final String LOINC_CODESYSTEM_URL = "http://loinc.org";
        public static final String UCUM_CODESYSTEM_URL = "http://unitsofmeasure.org";
        public static final String HL7_TERMINOLOGY_CODESYSTEM_BASE_URL = "http://terminology.hl7.org/CodeSystem/";
        public static final String HL7_SID_CODESYSTEM_BASE_URL = "http://hl7.org/fhir/sid/";
        public static final String HL7_FHIR_CODESYSTEM_BASE_URL = "http://hl7.org/fhir/";
        public static final String ISO_CODESYSTEM_URN = "urn:iso:std:iso:";
        public static final String LANG_CODESYSTEM_URN = "urn:ietf:bcp:47";
        public static final String MIMETYPES_CODESYSTEM_URN = "urn:ietf:bcp:13";
        public static final String _11073_CODESYSTEM_URN = "urn:iso:std:iso:11073:10101";
        public static final String DICOM_CODESYSTEM_URL = "http://dicom.nema.org/resources/ontology/DCM";

        public String getNameForSystem(String system) {
            String systemVersion;
            int lastPipe = system.lastIndexOf(124);
            String systemBaseName = lastPipe == -1 ? system : system.substring(0, lastPipe);
            String string = systemVersion = lastPipe == -1 ? null : system.substring(lastPipe + 1);
            if (systemBaseName.equals(SNOMED_SCT_CODESYSTEM_URL)) {
                return this.getVersionedSystem("snomed", systemVersion);
            }
            if (systemBaseName.equals(RXNORM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("rxnorm", systemVersion);
            }
            if (systemBaseName.equals(LOINC_CODESYSTEM_URL)) {
                return this.getVersionedSystem("loinc", systemVersion);
            }
            if (systemBaseName.equals(UCUM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("ucum", systemVersion);
            }
            if (systemBaseName.startsWith(HL7_SID_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_SID_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.equals(_11073_CODESYSTEM_URN)) {
                return this.getVersionedSystem("11073", systemVersion);
            }
            if (systemBaseName.startsWith(ISO_CODESYSTEM_URN)) {
                return this.getVersionedSystem("iso" + systemBaseName.substring(ISO_CODESYSTEM_URN.length()).replace(":", ""), systemVersion);
            }
            if (systemBaseName.startsWith(HL7_TERMINOLOGY_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_TERMINOLOGY_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.startsWith(HL7_FHIR_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_FHIR_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.equals(LANG_CODESYSTEM_URN)) {
                return this.getVersionedSystem("lang", systemVersion);
            }
            if (systemBaseName.equals(MIMETYPES_CODESYSTEM_URN)) {
                return this.getVersionedSystem("mimetypes", systemVersion);
            }
            if (systemBaseName.equals(DICOM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("dicom", systemVersion);
            }
            return this.getVersionedSystem(systemBaseName.replace("/", "_").replace(":", "_").replace("?", "X").replace("#", "X"), systemVersion);
        }

        public String normalizeBaseURL(String baseUrl, String fullUrl) {
            return fullUrl.substring(baseUrl.length()).replace("/", "");
        }

        public String getVersionedSystem(String baseSystem, String version) {
            if (version != null) {
                return baseSystem + "_" + version;
            }
            return baseSystem;
        }
    }

    public class CacheToken {
        private String name;
        private String key;
        private String request;
        private boolean hasVersion;

        public void setName(String n) {
            String systemName = TerminologyCache.this.getSystemNameKeyGenerator().getNameForSystem(n);
            if (this.name == null) {
                this.name = systemName;
            } else if (!systemName.equals(this.name)) {
                this.name = TerminologyCache.NAME_FOR_NO_SYSTEM;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getRequest() {
            return this.request;
        }

        public boolean hasVersion() {
            return this.hasVersion;
        }
    }
}

