/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="AdverseEvent", profile="http://hl7.org/fhir/StructureDefinition/AdverseEvent")
public class AdverseEvent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the event", formalDefinition="Business identifiers assigned to this adverse event by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | entered-in-error | unknown", formalDefinition="The current state of the adverse event or potential adverse event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-status")
    protected Enumeration<AdverseEventStatus> status;
    @Child(name="actuality", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="actual | potential", formalDefinition="Whether the event actually happened or was a near miss. Note that this is independent of whether anyone was affected or harmed or how severely.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-actuality")
    protected Enumeration<AdverseEventActuality> actuality;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="wrong-patient | procedure-mishap | medication-mishap | device | unsafe-physical-environment | hospital-aquired-infection | wrong-body-site", formalDefinition="The overall type of event, intended for search and filtering purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Event or incident that occurred or was averted", formalDefinition="Specific event that occurred or that was averted, such as patient fall, wrong organ removed, or wrong blood transfused.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-type")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Practitioner.class, RelatedPerson.class, ResearchSubject.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subject impacted by event", formalDefinition="This subject or group impacted by the event.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Encounter associated with the start of the AdverseEvent", formalDefinition="The Encounter associated with the start of the AdverseEvent.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event occurred", formalDefinition="The date (and perhaps time) when the adverse event occurred.")
    protected DataType occurrence;
    @Child(name="detected", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event was detected", formalDefinition="Estimated or actual date the AdverseEvent began, in the opinion of the reporter.")
    protected DateTimeType detected;
    @Child(name="recordedDate", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event was recorded", formalDefinition="The date on which the existence of the AdverseEvent was first recorded.")
    protected DateTimeType recordedDate;
    @Child(name="resultingEffect", type={Condition.class, Observation.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Effect on the subject due to this event", formalDefinition="Information about the condition that occurred as a result of the adverse event, such as hives due to the exposure to a substance (for example, a drug or a chemical) or a broken leg as a result of the fall.")
    protected List<Reference> resultingEffect;
    @Child(name="location", type={Location.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Location where adverse event occurred", formalDefinition="The information about where the adverse event occurred.")
    protected Reference location;
    @Child(name="seriousness", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Seriousness or gravity of the event", formalDefinition="Assessment whether this event, or averted event, was of clinical importance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-seriousness")
    protected CodeableConcept seriousness;
    @Child(name="outcome", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of outcome from the adverse event", formalDefinition="Describes the type of outcome from the adverse event, such as resolved, recovering, ongoing, resolved-with-sequelae, or fatal.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-outcome")
    protected List<CodeableConcept> outcome;
    @Child(name="recorder", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, ResearchSubject.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who recorded the adverse event", formalDefinition="Information on who recorded the adverse event.  May be the patient or a practitioner.")
    protected Reference recorder;
    @Child(name="participant", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who was involved in the adverse event or the potential adverse event and what they did", formalDefinition="Indicates who or what participated in the adverse event and how they were involved.")
    protected List<AdverseEventParticipantComponent> participant;
    @Child(name="study", type={ResearchStudy.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Research study that the subject is enrolled in", formalDefinition="The research study that the subject is enrolled in.")
    protected List<Reference> study;
    @Child(name="expectedInResearchStudy", type={BooleanType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Considered likely or probable or anticipated in the research study", formalDefinition="Considered likely or probable or anticipated in the research study.  Whether the reported event matches any of the outcomes for the patient that are considered by the study as known or likely.")
    protected BooleanType expectedInResearchStudy;
    @Child(name="suspectEntity", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The suspected agent causing the adverse event", formalDefinition="Describes the entity that is suspected to have caused the adverse event.")
    protected List<AdverseEventSuspectEntityComponent> suspectEntity;
    @Child(name="contributingFactor", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contributing factors suspected to have increased the probability or severity of the adverse event", formalDefinition="The contributing factors suspected to have increased the probability or severity of the adverse event.")
    protected List<AdverseEventContributingFactorComponent> contributingFactor;
    @Child(name="preventiveAction", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Preventive actions that contributed to avoiding the adverse event", formalDefinition="Preventive actions that contributed to avoiding the adverse event.")
    protected List<AdverseEventPreventiveActionComponent> preventiveAction;
    @Child(name="mitigatingAction", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Ameliorating actions taken after the adverse event occured in order to reduce the extent of harm", formalDefinition="The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.")
    protected List<AdverseEventMitigatingActionComponent> mitigatingAction;
    @Child(name="supportingInfo", type={}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting information relevant to the event", formalDefinition="Supporting information relevant to the event.")
    protected List<AdverseEventSupportingInfoComponent> supportingInfo;
    @Child(name="note", type={Annotation.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Comment on adverse event", formalDefinition="Comments made about the adverse event by the performer, subject or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -1861590732L;
    @SearchParamDefinition(name="actuality", path="AdverseEvent.actuality", description="actual | potential", type="token")
    public static final String SP_ACTUALITY = "actuality";
    public static final TokenClientParam ACTUALITY = new TokenClientParam("actuality");
    @SearchParamDefinition(name="category", path="AdverseEvent.category", description="wrong-patient | procedure-mishap | medication-mishap | device | unsafe-physical-environment | hospital-aquired-infection | wrong-body-site", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="location", path="AdverseEvent.location", description="Location where adverse event occurred", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("AdverseEvent:location").toLocked();
    @SearchParamDefinition(name="recorder", path="AdverseEvent.recorder", description="Who recorded the adverse event", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, ResearchSubject.class})
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("AdverseEvent:recorder").toLocked();
    @SearchParamDefinition(name="resultingeffect", path="AdverseEvent.resultingEffect", description="Effect on the subject due to this event", type="reference", target={Condition.class, Observation.class})
    public static final String SP_RESULTINGEFFECT = "resultingeffect";
    public static final ReferenceClientParam RESULTINGEFFECT = new ReferenceClientParam("resultingeffect");
    public static final Include INCLUDE_RESULTINGEFFECT = new Include("AdverseEvent:resultingeffect").toLocked();
    @SearchParamDefinition(name="seriousness", path="AdverseEvent.seriousness", description="Seriousness or gravity of the event", type="token")
    public static final String SP_SERIOUSNESS = "seriousness";
    public static final TokenClientParam SERIOUSNESS = new TokenClientParam("seriousness");
    @SearchParamDefinition(name="status", path="AdverseEvent.status", description="in-progress | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="study", path="AdverseEvent.study", description="Research study that the subject is enrolled in", type="reference", target={ResearchStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("AdverseEvent:study").toLocked();
    @SearchParamDefinition(name="subject", path="AdverseEvent.subject", description="Subject impacted by event", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class, Practitioner.class, RelatedPerson.class, ResearchSubject.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("AdverseEvent:subject").toLocked();
    @SearchParamDefinition(name="substance", path="(AdverseEvent.suspectEntity.instance as Reference)", description="Refers to the specific entity that caused the adverse event", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Immunization.class, Medication.class, MedicationAdministration.class, MedicationStatement.class, Procedure.class, ResearchStudy.class, Substance.class})
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_SUBSTANCE = new Include("AdverseEvent:substance").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AdverseEvent:patient").toLocked();

    public AdverseEvent() {
    }

    public AdverseEvent(AdverseEventStatus status, AdverseEventActuality actuality, Reference subject) {
        this.setStatus(status);
        this.setActuality(actuality);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AdverseEvent setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AdverseEvent addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<AdverseEventStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AdverseEventStatus>(new AdverseEventStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public AdverseEvent setStatusElement(Enumeration<AdverseEventStatus> value) {
        this.status = value;
        return this;
    }

    public AdverseEventStatus getStatus() {
        return this.status == null ? null : (AdverseEventStatus)((Object)this.status.getValue());
    }

    public AdverseEvent setStatus(AdverseEventStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<AdverseEventStatus>(new AdverseEventStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<AdverseEventActuality> getActualityElement() {
        if (this.actuality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.actuality");
            }
            if (Configuration.doAutoCreate()) {
                this.actuality = new Enumeration<AdverseEventActuality>(new AdverseEventActualityEnumFactory());
            }
        }
        return this.actuality;
    }

    public boolean hasActualityElement() {
        return this.actuality != null && !this.actuality.isEmpty();
    }

    public boolean hasActuality() {
        return this.actuality != null && !this.actuality.isEmpty();
    }

    public AdverseEvent setActualityElement(Enumeration<AdverseEventActuality> value) {
        this.actuality = value;
        return this;
    }

    public AdverseEventActuality getActuality() {
        return this.actuality == null ? null : (AdverseEventActuality)((Object)this.actuality.getValue());
    }

    public AdverseEvent setActuality(AdverseEventActuality value) {
        if (this.actuality == null) {
            this.actuality = new Enumeration<AdverseEventActuality>(new AdverseEventActualityEnumFactory());
        }
        this.actuality.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public AdverseEvent setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public AdverseEvent addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public AdverseEvent setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public AdverseEvent setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public AdverseEvent setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Timing();
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public AdverseEvent setOccurrence(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRException("Not the right type for AdverseEvent.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getDetectedElement() {
        if (this.detected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.detected");
            }
            if (Configuration.doAutoCreate()) {
                this.detected = new DateTimeType();
            }
        }
        return this.detected;
    }

    public boolean hasDetectedElement() {
        return this.detected != null && !this.detected.isEmpty();
    }

    public boolean hasDetected() {
        return this.detected != null && !this.detected.isEmpty();
    }

    public AdverseEvent setDetectedElement(DateTimeType value) {
        this.detected = value;
        return this;
    }

    public Date getDetected() {
        return this.detected == null ? null : (Date)this.detected.getValue();
    }

    public AdverseEvent setDetected(Date value) {
        if (value == null) {
            this.detected = null;
        } else {
            if (this.detected == null) {
                this.detected = new DateTimeType();
            }
            this.detected.setValue(value);
        }
        return this;
    }

    public DateTimeType getRecordedDateElement() {
        if (this.recordedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.recordedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedDate = new DateTimeType();
            }
        }
        return this.recordedDate;
    }

    public boolean hasRecordedDateElement() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public boolean hasRecordedDate() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public AdverseEvent setRecordedDateElement(DateTimeType value) {
        this.recordedDate = value;
        return this;
    }

    public Date getRecordedDate() {
        return this.recordedDate == null ? null : (Date)this.recordedDate.getValue();
    }

    public AdverseEvent setRecordedDate(Date value) {
        if (value == null) {
            this.recordedDate = null;
        } else {
            if (this.recordedDate == null) {
                this.recordedDate = new DateTimeType();
            }
            this.recordedDate.setValue(value);
        }
        return this;
    }

    public List<Reference> getResultingEffect() {
        if (this.resultingEffect == null) {
            this.resultingEffect = new ArrayList<Reference>();
        }
        return this.resultingEffect;
    }

    public AdverseEvent setResultingEffect(List<Reference> theResultingEffect) {
        this.resultingEffect = theResultingEffect;
        return this;
    }

    public boolean hasResultingEffect() {
        if (this.resultingEffect == null) {
            return false;
        }
        for (Reference item : this.resultingEffect) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResultingEffect() {
        Reference t = new Reference();
        if (this.resultingEffect == null) {
            this.resultingEffect = new ArrayList<Reference>();
        }
        this.resultingEffect.add(t);
        return t;
    }

    public AdverseEvent addResultingEffect(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.resultingEffect == null) {
            this.resultingEffect = new ArrayList<Reference>();
        }
        this.resultingEffect.add(t);
        return this;
    }

    public Reference getResultingEffectFirstRep() {
        if (this.getResultingEffect().isEmpty()) {
            this.addResultingEffect();
        }
        return this.getResultingEffect().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public AdverseEvent setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public CodeableConcept getSeriousness() {
        if (this.seriousness == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.seriousness");
            }
            if (Configuration.doAutoCreate()) {
                this.seriousness = new CodeableConcept();
            }
        }
        return this.seriousness;
    }

    public boolean hasSeriousness() {
        return this.seriousness != null && !this.seriousness.isEmpty();
    }

    public AdverseEvent setSeriousness(CodeableConcept value) {
        this.seriousness = value;
        return this;
    }

    public List<CodeableConcept> getOutcome() {
        if (this.outcome == null) {
            this.outcome = new ArrayList<CodeableConcept>();
        }
        return this.outcome;
    }

    public AdverseEvent setOutcome(List<CodeableConcept> theOutcome) {
        this.outcome = theOutcome;
        return this;
    }

    public boolean hasOutcome() {
        if (this.outcome == null) {
            return false;
        }
        for (CodeableConcept item : this.outcome) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addOutcome() {
        CodeableConcept t = new CodeableConcept();
        if (this.outcome == null) {
            this.outcome = new ArrayList<CodeableConcept>();
        }
        this.outcome.add(t);
        return t;
    }

    public AdverseEvent addOutcome(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.outcome == null) {
            this.outcome = new ArrayList<CodeableConcept>();
        }
        this.outcome.add(t);
        return this;
    }

    public CodeableConcept getOutcomeFirstRep() {
        if (this.getOutcome().isEmpty()) {
            this.addOutcome();
        }
        return this.getOutcome().get(0);
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public AdverseEvent setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public List<AdverseEventParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AdverseEventParticipantComponent>();
        }
        return this.participant;
    }

    public AdverseEvent setParticipant(List<AdverseEventParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (AdverseEventParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventParticipantComponent addParticipant() {
        AdverseEventParticipantComponent t = new AdverseEventParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<AdverseEventParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public AdverseEvent addParticipant(AdverseEventParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<AdverseEventParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public AdverseEventParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<Reference> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        return this.study;
    }

    public AdverseEvent setStudy(List<Reference> theStudy) {
        this.study = theStudy;
        return this;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (Reference item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addStudy() {
        Reference t = new Reference();
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return t;
    }

    public AdverseEvent addStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return this;
    }

    public Reference getStudyFirstRep() {
        if (this.getStudy().isEmpty()) {
            this.addStudy();
        }
        return this.getStudy().get(0);
    }

    public BooleanType getExpectedInResearchStudyElement() {
        if (this.expectedInResearchStudy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdverseEvent.expectedInResearchStudy");
            }
            if (Configuration.doAutoCreate()) {
                this.expectedInResearchStudy = new BooleanType();
            }
        }
        return this.expectedInResearchStudy;
    }

    public boolean hasExpectedInResearchStudyElement() {
        return this.expectedInResearchStudy != null && !this.expectedInResearchStudy.isEmpty();
    }

    public boolean hasExpectedInResearchStudy() {
        return this.expectedInResearchStudy != null && !this.expectedInResearchStudy.isEmpty();
    }

    public AdverseEvent setExpectedInResearchStudyElement(BooleanType value) {
        this.expectedInResearchStudy = value;
        return this;
    }

    public boolean getExpectedInResearchStudy() {
        return this.expectedInResearchStudy == null || this.expectedInResearchStudy.isEmpty() ? false : (Boolean)this.expectedInResearchStudy.getValue();
    }

    public AdverseEvent setExpectedInResearchStudy(boolean value) {
        if (this.expectedInResearchStudy == null) {
            this.expectedInResearchStudy = new BooleanType();
        }
        this.expectedInResearchStudy.setValue((Object)value);
        return this;
    }

    public List<AdverseEventSuspectEntityComponent> getSuspectEntity() {
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        return this.suspectEntity;
    }

    public AdverseEvent setSuspectEntity(List<AdverseEventSuspectEntityComponent> theSuspectEntity) {
        this.suspectEntity = theSuspectEntity;
        return this;
    }

    public boolean hasSuspectEntity() {
        if (this.suspectEntity == null) {
            return false;
        }
        for (AdverseEventSuspectEntityComponent item : this.suspectEntity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventSuspectEntityComponent addSuspectEntity() {
        AdverseEventSuspectEntityComponent t = new AdverseEventSuspectEntityComponent();
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        this.suspectEntity.add(t);
        return t;
    }

    public AdverseEvent addSuspectEntity(AdverseEventSuspectEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.suspectEntity == null) {
            this.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
        }
        this.suspectEntity.add(t);
        return this;
    }

    public AdverseEventSuspectEntityComponent getSuspectEntityFirstRep() {
        if (this.getSuspectEntity().isEmpty()) {
            this.addSuspectEntity();
        }
        return this.getSuspectEntity().get(0);
    }

    public List<AdverseEventContributingFactorComponent> getContributingFactor() {
        if (this.contributingFactor == null) {
            this.contributingFactor = new ArrayList<AdverseEventContributingFactorComponent>();
        }
        return this.contributingFactor;
    }

    public AdverseEvent setContributingFactor(List<AdverseEventContributingFactorComponent> theContributingFactor) {
        this.contributingFactor = theContributingFactor;
        return this;
    }

    public boolean hasContributingFactor() {
        if (this.contributingFactor == null) {
            return false;
        }
        for (AdverseEventContributingFactorComponent item : this.contributingFactor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventContributingFactorComponent addContributingFactor() {
        AdverseEventContributingFactorComponent t = new AdverseEventContributingFactorComponent();
        if (this.contributingFactor == null) {
            this.contributingFactor = new ArrayList<AdverseEventContributingFactorComponent>();
        }
        this.contributingFactor.add(t);
        return t;
    }

    public AdverseEvent addContributingFactor(AdverseEventContributingFactorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contributingFactor == null) {
            this.contributingFactor = new ArrayList<AdverseEventContributingFactorComponent>();
        }
        this.contributingFactor.add(t);
        return this;
    }

    public AdverseEventContributingFactorComponent getContributingFactorFirstRep() {
        if (this.getContributingFactor().isEmpty()) {
            this.addContributingFactor();
        }
        return this.getContributingFactor().get(0);
    }

    public List<AdverseEventPreventiveActionComponent> getPreventiveAction() {
        if (this.preventiveAction == null) {
            this.preventiveAction = new ArrayList<AdverseEventPreventiveActionComponent>();
        }
        return this.preventiveAction;
    }

    public AdverseEvent setPreventiveAction(List<AdverseEventPreventiveActionComponent> thePreventiveAction) {
        this.preventiveAction = thePreventiveAction;
        return this;
    }

    public boolean hasPreventiveAction() {
        if (this.preventiveAction == null) {
            return false;
        }
        for (AdverseEventPreventiveActionComponent item : this.preventiveAction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventPreventiveActionComponent addPreventiveAction() {
        AdverseEventPreventiveActionComponent t = new AdverseEventPreventiveActionComponent();
        if (this.preventiveAction == null) {
            this.preventiveAction = new ArrayList<AdverseEventPreventiveActionComponent>();
        }
        this.preventiveAction.add(t);
        return t;
    }

    public AdverseEvent addPreventiveAction(AdverseEventPreventiveActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.preventiveAction == null) {
            this.preventiveAction = new ArrayList<AdverseEventPreventiveActionComponent>();
        }
        this.preventiveAction.add(t);
        return this;
    }

    public AdverseEventPreventiveActionComponent getPreventiveActionFirstRep() {
        if (this.getPreventiveAction().isEmpty()) {
            this.addPreventiveAction();
        }
        return this.getPreventiveAction().get(0);
    }

    public List<AdverseEventMitigatingActionComponent> getMitigatingAction() {
        if (this.mitigatingAction == null) {
            this.mitigatingAction = new ArrayList<AdverseEventMitigatingActionComponent>();
        }
        return this.mitigatingAction;
    }

    public AdverseEvent setMitigatingAction(List<AdverseEventMitigatingActionComponent> theMitigatingAction) {
        this.mitigatingAction = theMitigatingAction;
        return this;
    }

    public boolean hasMitigatingAction() {
        if (this.mitigatingAction == null) {
            return false;
        }
        for (AdverseEventMitigatingActionComponent item : this.mitigatingAction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventMitigatingActionComponent addMitigatingAction() {
        AdverseEventMitigatingActionComponent t = new AdverseEventMitigatingActionComponent();
        if (this.mitigatingAction == null) {
            this.mitigatingAction = new ArrayList<AdverseEventMitigatingActionComponent>();
        }
        this.mitigatingAction.add(t);
        return t;
    }

    public AdverseEvent addMitigatingAction(AdverseEventMitigatingActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mitigatingAction == null) {
            this.mitigatingAction = new ArrayList<AdverseEventMitigatingActionComponent>();
        }
        this.mitigatingAction.add(t);
        return this;
    }

    public AdverseEventMitigatingActionComponent getMitigatingActionFirstRep() {
        if (this.getMitigatingAction().isEmpty()) {
            this.addMitigatingAction();
        }
        return this.getMitigatingAction().get(0);
    }

    public List<AdverseEventSupportingInfoComponent> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<AdverseEventSupportingInfoComponent>();
        }
        return this.supportingInfo;
    }

    public AdverseEvent setSupportingInfo(List<AdverseEventSupportingInfoComponent> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (AdverseEventSupportingInfoComponent item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdverseEventSupportingInfoComponent addSupportingInfo() {
        AdverseEventSupportingInfoComponent t = new AdverseEventSupportingInfoComponent();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<AdverseEventSupportingInfoComponent>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public AdverseEvent addSupportingInfo(AdverseEventSupportingInfoComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<AdverseEventSupportingInfoComponent>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public AdverseEventSupportingInfoComponent getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public AdverseEvent setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public AdverseEvent addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this adverse event by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "The current state of the adverse event or potential adverse event.", 0, 1, this.status));
        children.add(new Property(SP_ACTUALITY, SP_CODE, "Whether the event actually happened or was a near miss. Note that this is independent of whether anyone was affected or harmed or how severely.", 0, 1, this.actuality));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "The overall type of event, intended for search and filtering purposes.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Specific event that occurred or that was averted, such as patient fall, wrong organ removed, or wrong blood transfused.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Practitioner|RelatedPerson|ResearchSubject)", "This subject or group impacted by the event.", 0, 1, this.subject));
        children.add(new Property("encounter", "Reference(Encounter)", "The Encounter associated with the start of the AdverseEvent.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.occurrence));
        children.add(new Property("detected", "dateTime", "Estimated or actual date the AdverseEvent began, in the opinion of the reporter.", 0, 1, this.detected));
        children.add(new Property("recordedDate", "dateTime", "The date on which the existence of the AdverseEvent was first recorded.", 0, 1, this.recordedDate));
        children.add(new Property("resultingEffect", "Reference(Condition|Observation)", "Information about the condition that occurred as a result of the adverse event, such as hives due to the exposure to a substance (for example, a drug or a chemical) or a broken leg as a result of the fall.", 0, Integer.MAX_VALUE, this.resultingEffect));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The information about where the adverse event occurred.", 0, 1, this.location));
        children.add(new Property(SP_SERIOUSNESS, "CodeableConcept", "Assessment whether this event, or averted event, was of clinical importance.", 0, 1, this.seriousness));
        children.add(new Property("outcome", "CodeableConcept", "Describes the type of outcome from the adverse event, such as resolved, recovering, ongoing, resolved-with-sequelae, or fatal.", 0, Integer.MAX_VALUE, this.outcome));
        children.add(new Property(SP_RECORDER, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|ResearchSubject)", "Information on who recorded the adverse event.  May be the patient or a practitioner.", 0, 1, this.recorder));
        children.add(new Property("participant", "", "Indicates who or what participated in the adverse event and how they were involved.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_STUDY, "Reference(ResearchStudy)", "The research study that the subject is enrolled in.", 0, Integer.MAX_VALUE, this.study));
        children.add(new Property("expectedInResearchStudy", "boolean", "Considered likely or probable or anticipated in the research study.  Whether the reported event matches any of the outcomes for the patient that are considered by the study as known or likely.", 0, 1, this.expectedInResearchStudy));
        children.add(new Property("suspectEntity", "", "Describes the entity that is suspected to have caused the adverse event.", 0, Integer.MAX_VALUE, this.suspectEntity));
        children.add(new Property("contributingFactor", "", "The contributing factors suspected to have increased the probability or severity of the adverse event.", 0, Integer.MAX_VALUE, this.contributingFactor));
        children.add(new Property("preventiveAction", "", "Preventive actions that contributed to avoiding the adverse event.", 0, Integer.MAX_VALUE, this.preventiveAction));
        children.add(new Property("mitigatingAction", "", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, Integer.MAX_VALUE, this.mitigatingAction));
        children.add(new Property("supportingInfo", "", "Supporting information relevant to the event.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("note", "Annotation", "Comments made about the adverse event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this adverse event by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The current state of the adverse event or potential adverse event.", 0, 1, this.status);
            }
            case 528866400: {
                return new Property(SP_ACTUALITY, SP_CODE, "Whether the event actually happened or was a near miss. Note that this is independent of whether anyone was affected or harmed or how severely.", 0, 1, this.actuality);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "The overall type of event, intended for search and filtering purposes.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Specific event that occurred or that was averted, such as patient fall, wrong organ removed, or wrong blood transfused.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Practitioner|RelatedPerson|ResearchSubject)", "This subject or group impacted by the event.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The Encounter associated with the start of the AdverseEvent.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "Timing", "The date (and perhaps time) when the adverse event occurred.", 0, 1, this.occurrence);
            }
            case 1048254082: {
                return new Property("detected", "dateTime", "Estimated or actual date the AdverseEvent began, in the opinion of the reporter.", 0, 1, this.detected);
            }
            case -1952893826: {
                return new Property("recordedDate", "dateTime", "The date on which the existence of the AdverseEvent was first recorded.", 0, 1, this.recordedDate);
            }
            case -2113579882: {
                return new Property("resultingEffect", "Reference(Condition|Observation)", "Information about the condition that occurred as a result of the adverse event, such as hives due to the exposure to a substance (for example, a drug or a chemical) or a broken leg as a result of the fall.", 0, Integer.MAX_VALUE, this.resultingEffect);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The information about where the adverse event occurred.", 0, 1, this.location);
            }
            case -1551003909: {
                return new Property(SP_SERIOUSNESS, "CodeableConcept", "Assessment whether this event, or averted event, was of clinical importance.", 0, 1, this.seriousness);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableConcept", "Describes the type of outcome from the adverse event, such as resolved, recovering, ongoing, resolved-with-sequelae, or fatal.", 0, Integer.MAX_VALUE, this.outcome);
            }
            case -799233858: {
                return new Property(SP_RECORDER, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|ResearchSubject)", "Information on who recorded the adverse event.  May be the patient or a practitioner.", 0, 1, this.recorder);
            }
            case 767422259: {
                return new Property("participant", "", "Indicates who or what participated in the adverse event and how they were involved.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(ResearchStudy)", "The research study that the subject is enrolled in.", 0, Integer.MAX_VALUE, this.study);
            }
            case -1071467023: {
                return new Property("expectedInResearchStudy", "boolean", "Considered likely or probable or anticipated in the research study.  Whether the reported event matches any of the outcomes for the patient that are considered by the study as known or likely.", 0, 1, this.expectedInResearchStudy);
            }
            case -1957422662: {
                return new Property("suspectEntity", "", "Describes the entity that is suspected to have caused the adverse event.", 0, Integer.MAX_VALUE, this.suspectEntity);
            }
            case -219647527: {
                return new Property("contributingFactor", "", "The contributing factors suspected to have increased the probability or severity of the adverse event.", 0, Integer.MAX_VALUE, this.contributingFactor);
            }
            case 2052341334: {
                return new Property("preventiveAction", "", "Preventive actions that contributed to avoiding the adverse event.", 0, Integer.MAX_VALUE, this.preventiveAction);
            }
            case 1992862383: {
                return new Property("mitigatingAction", "", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, Integer.MAX_VALUE, this.mitigatingAction);
            }
            case 1922406657: {
                return new Property("supportingInfo", "", "Supporting information relevant to the event.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the adverse event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 528866400: {
                Base[] baseArray;
                if (this.actuality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.actuality;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrence;
                }
                return baseArray;
            }
            case 1048254082: {
                Base[] baseArray;
                if (this.detected == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.detected;
                }
                return baseArray;
            }
            case -1952893826: {
                Base[] baseArray;
                if (this.recordedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.recordedDate;
                }
                return baseArray;
            }
            case -2113579882: {
                return this.resultingEffect == null ? new Base[]{} : this.resultingEffect.toArray(new Base[this.resultingEffect.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.location;
                }
                return baseArray;
            }
            case -1551003909: {
                Base[] baseArray;
                if (this.seriousness == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.seriousness;
                }
                return baseArray;
            }
            case -1106507950: {
                return this.outcome == null ? new Base[]{} : this.outcome.toArray(new Base[this.outcome.size()]);
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.recorder;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
            case -1071467023: {
                Base[] baseArray;
                if (this.expectedInResearchStudy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.expectedInResearchStudy;
                }
                return baseArray;
            }
            case -1957422662: {
                return this.suspectEntity == null ? new Base[]{} : this.suspectEntity.toArray(new Base[this.suspectEntity.size()]);
            }
            case -219647527: {
                return this.contributingFactor == null ? new Base[]{} : this.contributingFactor.toArray(new Base[this.contributingFactor.size()]);
            }
            case 2052341334: {
                return this.preventiveAction == null ? new Base[]{} : this.preventiveAction.toArray(new Base[this.preventiveAction.size()]);
            }
            case 1992862383: {
                return this.mitigatingAction == null ? new Base[]{} : this.mitigatingAction.toArray(new Base[this.mitigatingAction.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new AdverseEventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 528866400: {
                value = new AdverseEventActualityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.actuality = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case 1048254082: {
                this.detected = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1952893826: {
                this.recordedDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -2113579882: {
                this.getResultingEffect().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -1551003909: {
                this.seriousness = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1106507950: {
                this.getOutcome().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -799233858: {
                this.recorder = TypeConvertor.castToReference(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((AdverseEventParticipantComponent)((Object)value));
                return value;
            }
            case 109776329: {
                this.getStudy().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1071467023: {
                this.expectedInResearchStudy = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1957422662: {
                this.getSuspectEntity().add((AdverseEventSuspectEntityComponent)((Object)value));
                return value;
            }
            case -219647527: {
                this.getContributingFactor().add((AdverseEventContributingFactorComponent)((Object)value));
                return value;
            }
            case 2052341334: {
                this.getPreventiveAction().add((AdverseEventPreventiveActionComponent)((Object)value));
                return value;
            }
            case 1992862383: {
                this.getMitigatingAction().add((AdverseEventMitigatingActionComponent)((Object)value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add((AdverseEventSupportingInfoComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new AdverseEventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_ACTUALITY)) {
            value = new AdverseEventActualityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.actuality = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("detected")) {
            this.detected = TypeConvertor.castToDateTime(value);
        } else if (name.equals("recordedDate")) {
            this.recordedDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("resultingEffect")) {
            this.getResultingEffect().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SERIOUSNESS)) {
            this.seriousness = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("outcome")) {
            this.getOutcome().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_RECORDER)) {
            this.recorder = TypeConvertor.castToReference(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((AdverseEventParticipantComponent)((Object)value));
        } else if (name.equals(SP_STUDY)) {
            this.getStudy().add(TypeConvertor.castToReference(value));
        } else if (name.equals("expectedInResearchStudy")) {
            this.expectedInResearchStudy = TypeConvertor.castToBoolean(value);
        } else if (name.equals("suspectEntity")) {
            this.getSuspectEntity().add((AdverseEventSuspectEntityComponent)((Object)value));
        } else if (name.equals("contributingFactor")) {
            this.getContributingFactor().add((AdverseEventContributingFactorComponent)((Object)value));
        } else if (name.equals("preventiveAction")) {
            this.getPreventiveAction().add((AdverseEventPreventiveActionComponent)((Object)value));
        } else if (name.equals("mitigatingAction")) {
            this.getMitigatingAction().add((AdverseEventMitigatingActionComponent)((Object)value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add((AdverseEventSupportingInfoComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 528866400: {
                return this.getActualityElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case 1048254082: {
                return this.getDetectedElement();
            }
            case -1952893826: {
                return this.getRecordedDateElement();
            }
            case -2113579882: {
                return this.addResultingEffect();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1551003909: {
                return this.getSeriousness();
            }
            case -1106507950: {
                return this.addOutcome();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 109776329: {
                return this.addStudy();
            }
            case -1071467023: {
                return this.getExpectedInResearchStudyElement();
            }
            case -1957422662: {
                return this.addSuspectEntity();
            }
            case -219647527: {
                return this.addContributingFactor();
            }
            case 2052341334: {
                return this.addPreventiveAction();
            }
            case 1992862383: {
                return this.addMitigatingAction();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 528866400: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case 1048254082: {
                return new String[]{"dateTime"};
            }
            case -1952893826: {
                return new String[]{"dateTime"};
            }
            case -2113579882: {
                return new String[]{"Reference"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1551003909: {
                return new String[]{"CodeableConcept"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
            case -1071467023: {
                return new String[]{"boolean"};
            }
            case -1957422662: {
                return new String[0];
            }
            case -219647527: {
                return new String[0];
            }
            case 2052341334: {
                return new String[0];
            }
            case 1992862383: {
                return new String[0];
            }
            case 1922406657: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.status");
        }
        if (name.equals(SP_ACTUALITY)) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.actuality");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("detected")) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.detected");
        }
        if (name.equals("recordedDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.recordedDate");
        }
        if (name.equals("resultingEffect")) {
            return this.addResultingEffect();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_SERIOUSNESS)) {
            this.seriousness = new CodeableConcept();
            return this.seriousness;
        }
        if (name.equals("outcome")) {
            return this.addOutcome();
        }
        if (name.equals(SP_RECORDER)) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals(SP_STUDY)) {
            return this.addStudy();
        }
        if (name.equals("expectedInResearchStudy")) {
            throw new FHIRException("Cannot call addChild on a singleton property AdverseEvent.expectedInResearchStudy");
        }
        if (name.equals("suspectEntity")) {
            return this.addSuspectEntity();
        }
        if (name.equals("contributingFactor")) {
            return this.addContributingFactor();
        }
        if (name.equals("preventiveAction")) {
            return this.addPreventiveAction();
        }
        if (name.equals("mitigatingAction")) {
            return this.addMitigatingAction();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AdverseEvent";
    }

    @Override
    public AdverseEvent copy() {
        AdverseEvent dst = new AdverseEvent();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AdverseEvent dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        Enumeration<AdverseEventActuality> enumeration = dst.actuality = this.actuality == null ? null : this.actuality.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.detected = this.detected == null ? null : this.detected.copy();
        DateTimeType dateTimeType = dst.recordedDate = this.recordedDate == null ? null : this.recordedDate.copy();
        if (this.resultingEffect != null) {
            dst.resultingEffect = new ArrayList<Reference>();
            for (Reference reference : this.resultingEffect) {
                dst.resultingEffect.add(reference.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        CodeableConcept codeableConcept = dst.seriousness = this.seriousness == null ? null : this.seriousness.copy();
        if (this.outcome != null) {
            dst.outcome = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.outcome) {
                dst.outcome.add(codeableConcept2.copy());
            }
        }
        Reference reference = dst.recorder = this.recorder == null ? null : this.recorder.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<AdverseEventParticipantComponent>();
            for (AdverseEventParticipantComponent adverseEventParticipantComponent : this.participant) {
                dst.participant.add(adverseEventParticipantComponent.copy());
            }
        }
        if (this.study != null) {
            dst.study = new ArrayList<Reference>();
            for (Reference reference2 : this.study) {
                dst.study.add(reference2.copy());
            }
        }
        BooleanType booleanType = dst.expectedInResearchStudy = this.expectedInResearchStudy == null ? null : this.expectedInResearchStudy.copy();
        if (this.suspectEntity != null) {
            dst.suspectEntity = new ArrayList<AdverseEventSuspectEntityComponent>();
            for (AdverseEventSuspectEntityComponent adverseEventSuspectEntityComponent : this.suspectEntity) {
                dst.suspectEntity.add(adverseEventSuspectEntityComponent.copy());
            }
        }
        if (this.contributingFactor != null) {
            dst.contributingFactor = new ArrayList<AdverseEventContributingFactorComponent>();
            for (AdverseEventContributingFactorComponent adverseEventContributingFactorComponent : this.contributingFactor) {
                dst.contributingFactor.add(adverseEventContributingFactorComponent.copy());
            }
        }
        if (this.preventiveAction != null) {
            dst.preventiveAction = new ArrayList<AdverseEventPreventiveActionComponent>();
            for (AdverseEventPreventiveActionComponent adverseEventPreventiveActionComponent : this.preventiveAction) {
                dst.preventiveAction.add(adverseEventPreventiveActionComponent.copy());
            }
        }
        if (this.mitigatingAction != null) {
            dst.mitigatingAction = new ArrayList<AdverseEventMitigatingActionComponent>();
            for (AdverseEventMitigatingActionComponent adverseEventMitigatingActionComponent : this.mitigatingAction) {
                dst.mitigatingAction.add(adverseEventMitigatingActionComponent.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<AdverseEventSupportingInfoComponent>();
            for (AdverseEventSupportingInfoComponent adverseEventSupportingInfoComponent : this.supportingInfo) {
                dst.supportingInfo.add(adverseEventSupportingInfoComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected AdverseEvent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AdverseEvent)) {
            return false;
        }
        AdverseEvent o = (AdverseEvent)other_;
        return AdverseEvent.compareDeep(this.identifier, o.identifier, true) && AdverseEvent.compareDeep(this.status, o.status, true) && AdverseEvent.compareDeep(this.actuality, o.actuality, true) && AdverseEvent.compareDeep(this.category, o.category, true) && AdverseEvent.compareDeep(this.code, o.code, true) && AdverseEvent.compareDeep(this.subject, o.subject, true) && AdverseEvent.compareDeep(this.encounter, o.encounter, true) && AdverseEvent.compareDeep(this.occurrence, o.occurrence, true) && AdverseEvent.compareDeep(this.detected, o.detected, true) && AdverseEvent.compareDeep(this.recordedDate, o.recordedDate, true) && AdverseEvent.compareDeep(this.resultingEffect, o.resultingEffect, true) && AdverseEvent.compareDeep(this.location, o.location, true) && AdverseEvent.compareDeep(this.seriousness, o.seriousness, true) && AdverseEvent.compareDeep(this.outcome, o.outcome, true) && AdverseEvent.compareDeep(this.recorder, o.recorder, true) && AdverseEvent.compareDeep(this.participant, o.participant, true) && AdverseEvent.compareDeep(this.study, o.study, true) && AdverseEvent.compareDeep(this.expectedInResearchStudy, o.expectedInResearchStudy, true) && AdverseEvent.compareDeep(this.suspectEntity, o.suspectEntity, true) && AdverseEvent.compareDeep(this.contributingFactor, o.contributingFactor, true) && AdverseEvent.compareDeep(this.preventiveAction, o.preventiveAction, true) && AdverseEvent.compareDeep(this.mitigatingAction, o.mitigatingAction, true) && AdverseEvent.compareDeep(this.supportingInfo, o.supportingInfo, true) && AdverseEvent.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AdverseEvent)) {
            return false;
        }
        AdverseEvent o = (AdverseEvent)other_;
        return AdverseEvent.compareValues(this.status, o.status, true) && AdverseEvent.compareValues(this.actuality, o.actuality, true) && AdverseEvent.compareValues(this.detected, o.detected, true) && AdverseEvent.compareValues(this.recordedDate, o.recordedDate, true) && AdverseEvent.compareValues(this.expectedInResearchStudy, o.expectedInResearchStudy, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.actuality, this.category, this.code, this.subject, this.encounter, this.occurrence, this.detected, this.recordedDate, this.resultingEffect, this.location, this.seriousness, this.outcome, this.recorder, this.participant, this.study, this.expectedInResearchStudy, this.suspectEntity, this.contributingFactor, this.preventiveAction, this.mitigatingAction, this.supportingInfo, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AdverseEvent;
    }

    @Block
    public static class AdverseEventSupportingInfoComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={Condition.class, Observation.class, AllergyIntolerance.class, FamilyMemberHistory.class, Immunization.class, Procedure.class, DocumentReference.class, MedicationAdministration.class, MedicationStatement.class, QuestionnaireResponse.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Subject medical history or document relevant to this adverse event", formalDefinition="Relevant past history for the subject. In a clinical care context, an example being a patient had an adverse event following a pencillin administration and the patient had a previously documented penicillin allergy. In a clinical trials context, an example is a bunion or rash that was present prior to the study. Additionally, the supporting item can be a document that is relevant to this instance of the adverse event that is not part of the subject's medical history. For example, a clinical note, staff list, or material safety data sheet (MSDS).  Supporting information is not a contributing factor, preventive action, or mitigating action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-supporting-info")
        protected DataType item;
        private static final long serialVersionUID = 1847936859L;

        public AdverseEventSupportingInfoComponent() {
        }

        public AdverseEventSupportingInfoComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public AdverseEventSupportingInfoComponent setItem(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for AdverseEvent.supportingInfo.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationStatement|QuestionnaireResponse)|CodeableConcept", "Relevant past history for the subject. In a clinical care context, an example being a patient had an adverse event following a pencillin administration and the patient had a previously documented penicillin allergy. In a clinical trials context, an example is a bunion or rash that was present prior to the study. Additionally, the supporting item can be a document that is relevant to this instance of the adverse event that is not part of the subject's medical history. For example, a clinical note, staff list, or material safety data sheet (MSDS).  Supporting information is not a contributing factor, preventive action, or mitigating action.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationStatement|QuestionnaireResponse)|CodeableConcept", "Relevant past history for the subject. In a clinical care context, an example being a patient had an adverse event following a pencillin administration and the patient had a previously documented penicillin allergy. In a clinical trials context, an example is a bunion or rash that was present prior to the study. Additionally, the supporting item can be a document that is relevant to this instance of the adverse event that is not part of the subject's medical history. For example, a clinical note, staff list, or material safety data sheet (MSDS).  Supporting information is not a contributing factor, preventive action, or mitigating action.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationStatement|QuestionnaireResponse)|CodeableConcept", "Relevant past history for the subject. In a clinical care context, an example being a patient had an adverse event following a pencillin administration and the patient had a previously documented penicillin allergy. In a clinical trials context, an example is a bunion or rash that was present prior to the study. Additionally, the supporting item can be a document that is relevant to this instance of the adverse event that is not part of the subject's medical history. For example, a clinical note, staff list, or material safety data sheet (MSDS).  Supporting information is not a contributing factor, preventive action, or mitigating action.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationStatement|QuestionnaireResponse)", "Relevant past history for the subject. In a clinical care context, an example being a patient had an adverse event following a pencillin administration and the patient had a previously documented penicillin allergy. In a clinical trials context, an example is a bunion or rash that was present prior to the study. Additionally, the supporting item can be a document that is relevant to this instance of the adverse event that is not part of the subject's medical history. For example, a clinical note, staff list, or material safety data sheet (MSDS).  Supporting information is not a contributing factor, preventive action, or mitigating action.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "Relevant past history for the subject. In a clinical care context, an example being a patient had an adverse event following a pencillin administration and the patient had a previously documented penicillin allergy. In a clinical trials context, an example is a bunion or rash that was present prior to the study. Additionally, the supporting item can be a document that is relevant to this instance of the adverse event that is not part of the subject's medical history. For example, a clinical note, staff list, or material safety data sheet (MSDS).  Supporting information is not a contributing factor, preventive action, or mitigating action.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("item[x]")) {
                return super.setProperty(name, value);
            }
            this.item = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventSupportingInfoComponent copy() {
            AdverseEventSupportingInfoComponent dst = new AdverseEventSupportingInfoComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventSupportingInfoComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSupportingInfoComponent)) {
                return false;
            }
            AdverseEventSupportingInfoComponent o = (AdverseEventSupportingInfoComponent)other_;
            return AdverseEventSupportingInfoComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSupportingInfoComponent)) {
                return false;
            }
            AdverseEventSupportingInfoComponent o = (AdverseEventSupportingInfoComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.supportingInfo";
        }
    }

    @Block
    public static class AdverseEventMitigatingActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={Procedure.class, DocumentReference.class, MedicationAdministration.class, MedicationRequest.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Ameliorating action taken after the adverse event occured in order to reduce the extent of harm", formalDefinition="The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-mitigating-action")
        protected DataType item;
        private static final long serialVersionUID = 1847936859L;

        public AdverseEventMitigatingActionComponent() {
        }

        public AdverseEventMitigatingActionComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public AdverseEventMitigatingActionComponent setItem(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for AdverseEvent.mitigatingAction.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "Reference(Procedure|DocumentReference|MedicationAdministration|MedicationRequest)|CodeableConcept", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "Reference(Procedure|DocumentReference|MedicationAdministration|MedicationRequest)|CodeableConcept", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "Reference(Procedure|DocumentReference|MedicationAdministration|MedicationRequest)|CodeableConcept", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Procedure|DocumentReference|MedicationAdministration|MedicationRequest)", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "The ameliorating action taken after the adverse event occured in order to reduce the extent of harm.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("item[x]")) {
                return super.setProperty(name, value);
            }
            this.item = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventMitigatingActionComponent copy() {
            AdverseEventMitigatingActionComponent dst = new AdverseEventMitigatingActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventMitigatingActionComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventMitigatingActionComponent)) {
                return false;
            }
            AdverseEventMitigatingActionComponent o = (AdverseEventMitigatingActionComponent)other_;
            return AdverseEventMitigatingActionComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventMitigatingActionComponent)) {
                return false;
            }
            AdverseEventMitigatingActionComponent o = (AdverseEventMitigatingActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.mitigatingAction";
        }
    }

    @Block
    public static class AdverseEventPreventiveActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={Immunization.class, Procedure.class, DocumentReference.class, MedicationAdministration.class, MedicationRequest.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Action that contributed to avoiding the adverse event", formalDefinition="The action that contributed to avoiding the adverse event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-preventive-action")
        protected DataType item;
        private static final long serialVersionUID = 1847936859L;

        public AdverseEventPreventiveActionComponent() {
        }

        public AdverseEventPreventiveActionComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public AdverseEventPreventiveActionComponent setItem(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for AdverseEvent.preventiveAction.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "Reference(Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationRequest)|CodeableConcept", "The action that contributed to avoiding the adverse event.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "Reference(Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationRequest)|CodeableConcept", "The action that contributed to avoiding the adverse event.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "Reference(Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationRequest)|CodeableConcept", "The action that contributed to avoiding the adverse event.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Immunization|Procedure|DocumentReference|MedicationAdministration|MedicationRequest)", "The action that contributed to avoiding the adverse event.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "The action that contributed to avoiding the adverse event.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("item[x]")) {
                return super.setProperty(name, value);
            }
            this.item = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventPreventiveActionComponent copy() {
            AdverseEventPreventiveActionComponent dst = new AdverseEventPreventiveActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventPreventiveActionComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventPreventiveActionComponent)) {
                return false;
            }
            AdverseEventPreventiveActionComponent o = (AdverseEventPreventiveActionComponent)other_;
            return AdverseEventPreventiveActionComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventPreventiveActionComponent)) {
                return false;
            }
            AdverseEventPreventiveActionComponent o = (AdverseEventPreventiveActionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.preventiveAction";
        }
    }

    @Block
    public static class AdverseEventContributingFactorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={Condition.class, Observation.class, AllergyIntolerance.class, FamilyMemberHistory.class, Immunization.class, Procedure.class, Device.class, DeviceUsage.class, DocumentReference.class, MedicationAdministration.class, MedicationStatement.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Item suspected to have increased the probability or severity of the adverse event", formalDefinition="The item that is suspected to have increased the probability or severity of the adverse event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-contributing-factor")
        protected DataType item;
        private static final long serialVersionUID = 1847936859L;

        public AdverseEventContributingFactorComponent() {
        }

        public AdverseEventContributingFactorComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public AdverseEventContributingFactorComponent setItem(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for AdverseEvent.contributingFactor.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|Device|DeviceUsage|DocumentReference|MedicationAdministration|MedicationStatement)|CodeableConcept", "The item that is suspected to have increased the probability or severity of the adverse event.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|Device|DeviceUsage|DocumentReference|MedicationAdministration|MedicationStatement)|CodeableConcept", "The item that is suspected to have increased the probability or severity of the adverse event.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|Device|DeviceUsage|DocumentReference|MedicationAdministration|MedicationStatement)|CodeableConcept", "The item that is suspected to have increased the probability or severity of the adverse event.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Condition|Observation|AllergyIntolerance|FamilyMemberHistory|Immunization|Procedure|Device|DeviceUsage|DocumentReference|MedicationAdministration|MedicationStatement)", "The item that is suspected to have increased the probability or severity of the adverse event.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "The item that is suspected to have increased the probability or severity of the adverse event.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("item[x]")) {
                return super.setProperty(name, value);
            }
            this.item = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventContributingFactorComponent copy() {
            AdverseEventContributingFactorComponent dst = new AdverseEventContributingFactorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventContributingFactorComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventContributingFactorComponent)) {
                return false;
            }
            AdverseEventContributingFactorComponent o = (AdverseEventContributingFactorComponent)other_;
            return AdverseEventContributingFactorComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventContributingFactorComponent)) {
                return false;
            }
            AdverseEventContributingFactorComponent o = (AdverseEventContributingFactorComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.contributingFactor";
        }
    }

    @Block
    public static class AdverseEventSuspectEntityCausalityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="assessmentMethod", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Method of evaluating the relatedness of the suspected entity to the event", formalDefinition="The method of evaluating the relatedness of the suspected entity to the event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-method")
        protected CodeableConcept assessmentMethod;
        @Child(name="entityRelatedness", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Result of the assessment regarding the relatedness of the suspected entity to the event", formalDefinition="The result of the assessment regarding the relatedness of the suspected entity to the event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-assess")
        protected CodeableConcept entityRelatedness;
        @Child(name="author", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, ResearchSubject.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Author of the information on the possible cause of the event", formalDefinition="The author of the information on the possible cause of the event.")
        protected Reference author;
        private static final long serialVersionUID = 486112728L;

        public CodeableConcept getAssessmentMethod() {
            if (this.assessmentMethod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.assessmentMethod");
                }
                if (Configuration.doAutoCreate()) {
                    this.assessmentMethod = new CodeableConcept();
                }
            }
            return this.assessmentMethod;
        }

        public boolean hasAssessmentMethod() {
            return this.assessmentMethod != null && !this.assessmentMethod.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setAssessmentMethod(CodeableConcept value) {
            this.assessmentMethod = value;
            return this;
        }

        public CodeableConcept getEntityRelatedness() {
            if (this.entityRelatedness == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.entityRelatedness");
                }
                if (Configuration.doAutoCreate()) {
                    this.entityRelatedness = new CodeableConcept();
                }
            }
            return this.entityRelatedness;
        }

        public boolean hasEntityRelatedness() {
            return this.entityRelatedness != null && !this.entityRelatedness.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setEntityRelatedness(CodeableConcept value) {
            this.entityRelatedness = value;
            return this;
        }

        public Reference getAuthor() {
            if (this.author == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityCausalityComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.author = new Reference();
                }
            }
            return this.author;
        }

        public boolean hasAuthor() {
            return this.author != null && !this.author.isEmpty();
        }

        public AdverseEventSuspectEntityCausalityComponent setAuthor(Reference value) {
            this.author = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("assessmentMethod", "CodeableConcept", "The method of evaluating the relatedness of the suspected entity to the event.", 0, 1, this.assessmentMethod));
            children.add(new Property("entityRelatedness", "CodeableConcept", "The result of the assessment regarding the relatedness of the suspected entity to the event.", 0, 1, this.entityRelatedness));
            children.add(new Property("author", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|ResearchSubject)", "The author of the information on the possible cause of the event.", 0, 1, this.author));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1681283651: {
                    return new Property("assessmentMethod", "CodeableConcept", "The method of evaluating the relatedness of the suspected entity to the event.", 0, 1, this.assessmentMethod);
                }
                case 2000199967: {
                    return new Property("entityRelatedness", "CodeableConcept", "The result of the assessment regarding the relatedness of the suspected entity to the event.", 0, 1, this.entityRelatedness);
                }
                case -1406328437: {
                    return new Property("author", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|ResearchSubject)", "The author of the information on the possible cause of the event.", 0, 1, this.author);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1681283651: {
                    Base[] baseArray;
                    if (this.assessmentMethod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.assessmentMethod;
                    }
                    return baseArray;
                }
                case 2000199967: {
                    Base[] baseArray;
                    if (this.entityRelatedness == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.entityRelatedness;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    Base[] baseArray;
                    if (this.author == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.author;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1681283651: {
                    this.assessmentMethod = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 2000199967: {
                    this.entityRelatedness = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1406328437: {
                    this.author = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("assessmentMethod")) {
                this.assessmentMethod = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("entityRelatedness")) {
                this.entityRelatedness = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("author")) {
                this.author = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1681283651: {
                    return this.getAssessmentMethod();
                }
                case 2000199967: {
                    return this.getEntityRelatedness();
                }
                case -1406328437: {
                    return this.getAuthor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1681283651: {
                    return new String[]{"CodeableConcept"};
                }
                case 2000199967: {
                    return new String[]{"CodeableConcept"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("assessmentMethod")) {
                this.assessmentMethod = new CodeableConcept();
                return this.assessmentMethod;
            }
            if (name.equals("entityRelatedness")) {
                this.entityRelatedness = new CodeableConcept();
                return this.entityRelatedness;
            }
            if (name.equals("author")) {
                this.author = new Reference();
                return this.author;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventSuspectEntityCausalityComponent copy() {
            AdverseEventSuspectEntityCausalityComponent dst = new AdverseEventSuspectEntityCausalityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventSuspectEntityCausalityComponent dst) {
            super.copyValues(dst);
            dst.assessmentMethod = this.assessmentMethod == null ? null : this.assessmentMethod.copy();
            dst.entityRelatedness = this.entityRelatedness == null ? null : this.entityRelatedness.copy();
            dst.author = this.author == null ? null : this.author.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSuspectEntityCausalityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityCausalityComponent o = (AdverseEventSuspectEntityCausalityComponent)other_;
            return AdverseEventSuspectEntityCausalityComponent.compareDeep(this.assessmentMethod, o.assessmentMethod, true) && AdverseEventSuspectEntityCausalityComponent.compareDeep(this.entityRelatedness, o.entityRelatedness, true) && AdverseEventSuspectEntityCausalityComponent.compareDeep(this.author, o.author, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSuspectEntityCausalityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityCausalityComponent o = (AdverseEventSuspectEntityCausalityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.assessmentMethod, this.entityRelatedness, this.author});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.suspectEntity.causality";
        }
    }

    @Block
    public static class AdverseEventSuspectEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="instance", type={CodeableConcept.class, Immunization.class, Procedure.class, Substance.class, Medication.class, MedicationAdministration.class, MedicationStatement.class, Device.class, BiologicallyDerivedProduct.class, ResearchStudy.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Refers to the specific entity that caused the adverse event", formalDefinition="Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.")
        protected DataType instance;
        @Child(name="causality", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Information on the possible cause of the event", formalDefinition="Information on the possible cause of the event.")
        protected AdverseEventSuspectEntityCausalityComponent causality;
        private static final long serialVersionUID = -1455097004L;

        public AdverseEventSuspectEntityComponent() {
        }

        public AdverseEventSuspectEntityComponent(DataType instance) {
            this.setInstance(instance);
        }

        public DataType getInstance() {
            return this.instance;
        }

        public CodeableConcept getInstanceCodeableConcept() throws FHIRException {
            if (this.instance == null) {
                this.instance = new CodeableConcept();
            }
            if (!(this.instance instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.instance.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.instance;
        }

        public boolean hasInstanceCodeableConcept() {
            return this != null && this.instance instanceof CodeableConcept;
        }

        public Reference getInstanceReference() throws FHIRException {
            if (this.instance == null) {
                this.instance = new Reference();
            }
            if (!(this.instance instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.instance.getClass().getName() + " was encountered");
            }
            return (Reference)this.instance;
        }

        public boolean hasInstanceReference() {
            return this != null && this.instance instanceof Reference;
        }

        public boolean hasInstance() {
            return this.instance != null && !this.instance.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setInstance(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRException("Not the right type for AdverseEvent.suspectEntity.instance[x]: " + value.fhirType());
            }
            this.instance = value;
            return this;
        }

        public AdverseEventSuspectEntityCausalityComponent getCausality() {
            if (this.causality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventSuspectEntityComponent.causality");
                }
                if (Configuration.doAutoCreate()) {
                    this.causality = new AdverseEventSuspectEntityCausalityComponent();
                }
            }
            return this.causality;
        }

        public boolean hasCausality() {
            return this.causality != null && !this.causality.isEmpty();
        }

        public AdverseEventSuspectEntityComponent setCausality(AdverseEventSuspectEntityCausalityComponent value) {
            this.causality = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("instance[x]", "CodeableConcept|Reference(Immunization|Procedure|Substance|Medication|MedicationAdministration|MedicationStatement|Device|BiologicallyDerivedProduct|ResearchStudy)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance));
            children.add(new Property("causality", "", "Information on the possible cause of the event.", 0, 1, this.causality));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -2101998645: {
                    return new Property("instance[x]", "CodeableConcept|Reference(Immunization|Procedure|Substance|Medication|MedicationAdministration|MedicationStatement|Device|BiologicallyDerivedProduct|ResearchStudy)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance);
                }
                case 555127957: {
                    return new Property("instance[x]", "CodeableConcept|Reference(Immunization|Procedure|Substance|Medication|MedicationAdministration|MedicationStatement|Device|BiologicallyDerivedProduct|ResearchStudy)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance);
                }
                case 697546316: {
                    return new Property("instance[x]", "CodeableConcept", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance);
                }
                case -1675877834: {
                    return new Property("instance[x]", "Reference(Immunization|Procedure|Substance|Medication|MedicationAdministration|MedicationStatement|Device|BiologicallyDerivedProduct|ResearchStudy)", "Identifies the actual instance of what caused the adverse event.  May be a substance, medication, medication administration, medication statement or a device.", 0, 1, this.instance);
                }
                case -1446450521: {
                    return new Property("causality", "", "Information on the possible cause of the event.", 0, 1, this.causality);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    Base[] baseArray;
                    if (this.instance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.instance;
                    }
                    return baseArray;
                }
                case -1446450521: {
                    Base[] baseArray;
                    if (this.causality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.causality;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    this.instance = TypeConvertor.castToType(value);
                    return value;
                }
                case -1446450521: {
                    this.causality = (AdverseEventSuspectEntityCausalityComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("instance[x]")) {
                this.instance = TypeConvertor.castToType(value);
            } else if (name.equals("causality")) {
                this.causality = (AdverseEventSuspectEntityCausalityComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2101998645: {
                    return this.getInstance();
                }
                case 555127957: {
                    return this.getInstance();
                }
                case -1446450521: {
                    return this.getCausality();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 555127957: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -1446450521: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("instanceCodeableConcept")) {
                this.instance = new CodeableConcept();
                return this.instance;
            }
            if (name.equals("instanceReference")) {
                this.instance = new Reference();
                return this.instance;
            }
            if (name.equals("causality")) {
                this.causality = new AdverseEventSuspectEntityCausalityComponent();
                return this.causality;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventSuspectEntityComponent copy() {
            AdverseEventSuspectEntityComponent dst = new AdverseEventSuspectEntityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventSuspectEntityComponent dst) {
            super.copyValues(dst);
            dst.instance = this.instance == null ? null : this.instance.copy();
            dst.causality = this.causality == null ? null : this.causality.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSuspectEntityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityComponent o = (AdverseEventSuspectEntityComponent)other_;
            return AdverseEventSuspectEntityComponent.compareDeep(this.instance, o.instance, true) && AdverseEventSuspectEntityComponent.compareDeep(this.causality, o.causality, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventSuspectEntityComponent)) {
                return false;
            }
            AdverseEventSuspectEntityComponent o = (AdverseEventSuspectEntityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.instance, this.causality});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.suspectEntity";
        }
    }

    @Block
    public static class AdverseEventParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of involvement", formalDefinition="Distinguishes the type of involvement of the actor in the adverse event, such as contributor or informant.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adverse-event-participant-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class, ResearchSubject.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who was involved in the adverse event or the potential adverse event", formalDefinition="Indicates who or what participated in the event.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public AdverseEventParticipantComponent() {
        }

        public AdverseEventParticipantComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public AdverseEventParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdverseEventParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public AdverseEventParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the adverse event, such as contributor or informant.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson|ResearchSubject)", "Indicates who or what participated in the event.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the adverse event, such as contributor or informant.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson|ResearchSubject)", "Indicates who or what participated in the event.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public AdverseEventParticipantComponent copy() {
            AdverseEventParticipantComponent dst = new AdverseEventParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdverseEventParticipantComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventParticipantComponent)) {
                return false;
            }
            AdverseEventParticipantComponent o = (AdverseEventParticipantComponent)other_;
            return AdverseEventParticipantComponent.compareDeep(this.function, o.function, true) && AdverseEventParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdverseEventParticipantComponent)) {
                return false;
            }
            AdverseEventParticipantComponent o = (AdverseEventParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "AdverseEvent.participant";
        }
    }

    public static class AdverseEventStatusEnumFactory
    implements EnumFactory<AdverseEventStatus> {
        @Override
        public AdverseEventStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return AdverseEventStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return AdverseEventStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return AdverseEventStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return AdverseEventStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown AdverseEventStatus code '" + codeString + "'");
        }

        public Enumeration<AdverseEventStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AdverseEventStatus>(this, AdverseEventStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AdverseEventStatus>(this, AdverseEventStatus.NULL, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<AdverseEventStatus>(this, AdverseEventStatus.INPROGRESS, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<AdverseEventStatus>(this, AdverseEventStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AdverseEventStatus>(this, AdverseEventStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<AdverseEventStatus>(this, AdverseEventStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown AdverseEventStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AdverseEventStatus code) {
            if (code == AdverseEventStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == AdverseEventStatus.COMPLETED) {
                return "completed";
            }
            if (code == AdverseEventStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == AdverseEventStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(AdverseEventStatus code) {
            return code.getSystem();
        }
    }

    public static enum AdverseEventStatus {
        INPROGRESS,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static AdverseEventStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AdverseEventStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The event is currently occurring.";
                }
                case COMPLETED: {
                    return "The event has now concluded.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"stopped\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this event.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply,  but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AdverseEventActualityEnumFactory
    implements EnumFactory<AdverseEventActuality> {
        @Override
        public AdverseEventActuality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("actual".equals(codeString)) {
                return AdverseEventActuality.ACTUAL;
            }
            if ("potential".equals(codeString)) {
                return AdverseEventActuality.POTENTIAL;
            }
            throw new IllegalArgumentException("Unknown AdverseEventActuality code '" + codeString + "'");
        }

        public Enumeration<AdverseEventActuality> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AdverseEventActuality>(this, AdverseEventActuality.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AdverseEventActuality>(this, AdverseEventActuality.NULL, code);
            }
            if ("actual".equals(codeString)) {
                return new Enumeration<AdverseEventActuality>(this, AdverseEventActuality.ACTUAL, code);
            }
            if ("potential".equals(codeString)) {
                return new Enumeration<AdverseEventActuality>(this, AdverseEventActuality.POTENTIAL, code);
            }
            throw new FHIRException("Unknown AdverseEventActuality code '" + codeString + "'");
        }

        @Override
        public String toCode(AdverseEventActuality code) {
            if (code == AdverseEventActuality.ACTUAL) {
                return "actual";
            }
            if (code == AdverseEventActuality.POTENTIAL) {
                return "potential";
            }
            return "?";
        }

        @Override
        public String toSystem(AdverseEventActuality code) {
            return code.getSystem();
        }
    }

    public static enum AdverseEventActuality {
        ACTUAL,
        POTENTIAL,
        NULL;


        public static AdverseEventActuality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("actual".equals(codeString)) {
                return ACTUAL;
            }
            if ("potential".equals(codeString)) {
                return POTENTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AdverseEventActuality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTUAL: {
                    return "actual";
                }
                case POTENTIAL: {
                    return "potential";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTUAL: {
                    return "http://hl7.org/fhir/adverse-event-actuality";
                }
                case POTENTIAL: {
                    return "http://hl7.org/fhir/adverse-event-actuality";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTUAL: {
                    return "The adverse event actually happened regardless of whether anyone was affected or harmed.";
                }
                case POTENTIAL: {
                    return "A potential adverse event.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTUAL: {
                    return "Adverse Event";
                }
                case POTENTIAL: {
                    return "Potential Adverse Event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

