/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CareTeam", profile="http://hl7.org/fhir/StructureDefinition/CareTeam")
public class CareTeam
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this team", formalDefinition="Business identifiers assigned to this care team by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | active | suspended | inactive | entered-in-error", formalDefinition="Indicates the current state of the care team.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-team-status")
    protected Enumeration<CareTeamStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of team", formalDefinition="Identifies what kind of team.  This is to support differentiation between multiple co-existing teams, such as care plan team, episode of care team, longitudinal care team.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-team-category")
    protected List<CodeableConcept> category;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the team, such as crisis assessment team", formalDefinition="A label for human use intended to distinguish like teams.  E.g. the \"red\" vs. \"green\" trauma teams.")
    protected StringType name;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who care team is for", formalDefinition="Identifies the patient or group whose intended care is handled by the team.")
    protected Reference subject;
    @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period team covers", formalDefinition="Indicates when the team did (or is intended to) come into effect and end.")
    protected Period period;
    @Child(name="participant", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Members of the team", formalDefinition="Identifies all people and organizations who are expected to be involved in the care team.")
    protected List<CareTeamParticipantComponent> participant;
    @Child(name="reason", type={CodeableReference.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the care team exists", formalDefinition="Describes why the care team exists.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableReference> reason;
    @Child(name="managingOrganization", type={Organization.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Organization responsible for the care team", formalDefinition="The organization responsible for the care team.")
    protected List<Reference> managingOrganization;
    @Child(name="telecom", type={ContactPoint.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A contact detail for the care team (that applies to all members)", formalDefinition="A central contact detail for the care team (that applies to all members).")
    protected List<ContactPoint> telecom;
    @Child(name="note", type={Annotation.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the CareTeam", formalDefinition="Comments made about the CareTeam.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 1147350970L;
    @SearchParamDefinition(name="category", path="CareTeam.category", description="Type of team", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="name", path="CareTeam.name | CareTeam.extension('http://hl7.org/fhir/StructureDefinition/careteam-alias').value", description="Name of the team, such as crisis assessment team", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="participant", path="CareTeam.participant.member", description="Who is involved", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("CareTeam:participant").toLocked();
    @SearchParamDefinition(name="status", path="CareTeam.status", description="proposed | active | suspended | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="CareTeam.subject", description="Who care team is for", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("CareTeam:subject").toLocked();
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CareTeam:patient").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CareTeam setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CareTeam addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<CareTeamStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CareTeam.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CareTeamStatus>(new CareTeamStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CareTeam setStatusElement(Enumeration<CareTeamStatus> value) {
        this.status = value;
        return this;
    }

    public CareTeamStatus getStatus() {
        return this.status == null ? null : (CareTeamStatus)((Object)this.status.getValue());
    }

    public CareTeam setStatus(CareTeamStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<CareTeamStatus>(new CareTeamStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public CareTeam setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public CareTeam addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CareTeam.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public CareTeam setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public CareTeam setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CareTeam.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public CareTeam setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CareTeam.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public CareTeam setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<CareTeamParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<CareTeamParticipantComponent>();
        }
        return this.participant;
    }

    public CareTeam setParticipant(List<CareTeamParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (CareTeamParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CareTeamParticipantComponent addParticipant() {
        CareTeamParticipantComponent t = new CareTeamParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<CareTeamParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public CareTeam addParticipant(CareTeamParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<CareTeamParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public CareTeamParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public CareTeam setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public CareTeam addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getManagingOrganization() {
        if (this.managingOrganization == null) {
            this.managingOrganization = new ArrayList<Reference>();
        }
        return this.managingOrganization;
    }

    public CareTeam setManagingOrganization(List<Reference> theManagingOrganization) {
        this.managingOrganization = theManagingOrganization;
        return this;
    }

    public boolean hasManagingOrganization() {
        if (this.managingOrganization == null) {
            return false;
        }
        for (Reference item : this.managingOrganization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManagingOrganization() {
        Reference t = new Reference();
        if (this.managingOrganization == null) {
            this.managingOrganization = new ArrayList<Reference>();
        }
        this.managingOrganization.add(t);
        return t;
    }

    public CareTeam addManagingOrganization(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.managingOrganization == null) {
            this.managingOrganization = new ArrayList<Reference>();
        }
        this.managingOrganization.add(t);
        return this;
    }

    public Reference getManagingOrganizationFirstRep() {
        if (this.getManagingOrganization().isEmpty()) {
            this.addManagingOrganization();
        }
        return this.getManagingOrganization().get(0);
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public CareTeam setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public CareTeam addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public CareTeam setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public CareTeam addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this care team by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates the current state of the care team.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Identifies what kind of team.  This is to support differentiation between multiple co-existing teams, such as care plan team, episode of care team, longitudinal care team.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_NAME, "string", "A label for human use intended to distinguish like teams.  E.g. the \"red\" vs. \"green\" trauma teams.", 0, 1, this.name));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is handled by the team.", 0, 1, this.subject));
        children.add(new Property("period", "Period", "Indicates when the team did (or is intended to) come into effect and end.", 0, 1, this.period));
        children.add(new Property(SP_PARTICIPANT, "", "Identifies all people and organizations who are expected to be involved in the care team.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("reason", "CodeableReference(Condition)", "Describes why the care team exists.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("managingOrganization", "Reference(Organization)", "The organization responsible for the care team.", 0, Integer.MAX_VALUE, this.managingOrganization));
        children.add(new Property("telecom", "ContactPoint", "A central contact detail for the care team (that applies to all members).", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property("note", "Annotation", "Comments made about the CareTeam.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this care team by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current state of the care team.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Identifies what kind of team.  This is to support differentiation between multiple co-existing teams, such as care plan team, episode of care team, longitudinal care team.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A label for human use intended to distinguish like teams.  E.g. the \"red\" vs. \"green\" trauma teams.", 0, 1, this.name);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is handled by the team.", 0, 1, this.subject);
            }
            case -991726143: {
                return new Property("period", "Period", "Indicates when the team did (or is intended to) come into effect and end.", 0, 1, this.period);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "Identifies all people and organizations who are expected to be involved in the care team.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition)", "Describes why the care team exists.", 0, Integer.MAX_VALUE, this.reason);
            }
            case -2058947787: {
                return new Property("managingOrganization", "Reference(Organization)", "The organization responsible for the care team.", 0, Integer.MAX_VALUE, this.managingOrganization);
            }
            case -1429363305: {
                return new Property("telecom", "ContactPoint", "A central contact detail for the care team (that applies to all members).", 0, Integer.MAX_VALUE, this.telecom);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the CareTeam.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -2058947787: {
                return this.managingOrganization == null ? new Base[]{} : this.managingOrganization.toArray(new Base[this.managingOrganization.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new CareTeamStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((CareTeamParticipantComponent)((Object)value));
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -2058947787: {
                this.getManagingOrganization().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new CareTeamStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((CareTeamParticipantComponent)((Object)value));
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("managingOrganization")) {
            this.getManagingOrganization().add(TypeConvertor.castToReference(value));
        } else if (name.equals("telecom")) {
            this.getTelecom().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -934964668: {
                return this.addReason();
            }
            case -2058947787: {
                return this.addManagingOrganization();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 767422259: {
                return new String[0];
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property CareTeam.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property CareTeam.name");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("managingOrganization")) {
            return this.addManagingOrganization();
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CareTeam";
    }

    @Override
    public CareTeam copy() {
        CareTeam dst = new CareTeam();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CareTeam dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<CareTeamStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<CareTeamParticipantComponent>();
            for (CareTeamParticipantComponent careTeamParticipantComponent : this.participant) {
                dst.participant.add(careTeamParticipantComponent.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.managingOrganization != null) {
            dst.managingOrganization = new ArrayList<Reference>();
            for (Reference reference : this.managingOrganization) {
                dst.managingOrganization.add(reference.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected CareTeam typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CareTeam)) {
            return false;
        }
        CareTeam o = (CareTeam)other_;
        return CareTeam.compareDeep(this.identifier, o.identifier, true) && CareTeam.compareDeep(this.status, o.status, true) && CareTeam.compareDeep(this.category, o.category, true) && CareTeam.compareDeep(this.name, o.name, true) && CareTeam.compareDeep(this.subject, o.subject, true) && CareTeam.compareDeep(this.period, o.period, true) && CareTeam.compareDeep(this.participant, o.participant, true) && CareTeam.compareDeep(this.reason, o.reason, true) && CareTeam.compareDeep(this.managingOrganization, o.managingOrganization, true) && CareTeam.compareDeep(this.telecom, o.telecom, true) && CareTeam.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CareTeam)) {
            return false;
        }
        CareTeam o = (CareTeam)other_;
        return CareTeam.compareValues(this.status, o.status, true) && CareTeam.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.name, this.subject, this.period, this.participant, this.reason, this.managingOrganization, this.telecom, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CareTeam;
    }

    @Block
    public static class CareTeamParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of involvement", formalDefinition="Indicates specific responsibility of an individual within the care team, such as \"Primary care physician\", \"Trained social worker counselor\", \"Caregiver\", etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participant-role")
        protected CodeableConcept role;
        @Child(name="member", type={Practitioner.class, PractitionerRole.class, RelatedPerson.class, Patient.class, Organization.class, CareTeam.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who is involved", formalDefinition="The specific person or organization who is participating/expected to participate in the care team.")
        protected Reference member;
        @Child(name="onBehalfOf", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization of the practitioner", formalDefinition="The organization of the practitioner.")
        protected Reference onBehalfOf;
        @Child(name="coverage", type={Period.class, Timing.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the member is generally available within this care team", formalDefinition="When the member is generally available within this care team.")
        protected DataType coverage;
        private static final long serialVersionUID = 192079749L;

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CareTeamParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getMember() {
            if (this.member == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamParticipantComponent.member");
                }
                if (Configuration.doAutoCreate()) {
                    this.member = new Reference();
                }
            }
            return this.member;
        }

        public boolean hasMember() {
            return this.member != null && !this.member.isEmpty();
        }

        public CareTeamParticipantComponent setMember(Reference value) {
            this.member = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamParticipantComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public CareTeamParticipantComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public DataType getCoverage() {
            return this.coverage;
        }

        public Period getCoveragePeriod() throws FHIRException {
            if (this.coverage == null) {
                this.coverage = new Period();
            }
            if (!(this.coverage instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.coverage.getClass().getName() + " was encountered");
            }
            return (Period)this.coverage;
        }

        public boolean hasCoveragePeriod() {
            return this != null && this.coverage instanceof Period;
        }

        public Timing getCoverageTiming() throws FHIRException {
            if (this.coverage == null) {
                this.coverage = new Timing();
            }
            if (!(this.coverage instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.coverage.getClass().getName() + " was encountered");
            }
            return (Timing)this.coverage;
        }

        public boolean hasCoverageTiming() {
            return this != null && this.coverage instanceof Timing;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public CareTeamParticipantComponent setCoverage(DataType value) {
            if (value != null && !(value instanceof Period) && !(value instanceof Timing)) {
                throw new FHIRException("Not the right type for CareTeam.participant.coverage[x]: " + value.fhirType());
            }
            this.coverage = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Indicates specific responsibility of an individual within the care team, such as \"Primary care physician\", \"Trained social worker counselor\", \"Caregiver\", etc.", 0, 1, this.role));
            children.add(new Property("member", "Reference(Practitioner|PractitionerRole|RelatedPerson|Patient|Organization|CareTeam)", "The specific person or organization who is participating/expected to participate in the care team.", 0, 1, this.member));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization of the practitioner.", 0, 1, this.onBehalfOf));
            children.add(new Property("coverage[x]", "Period|Timing", "When the member is generally available within this care team.", 0, 1, this.coverage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Indicates specific responsibility of an individual within the care team, such as \"Primary care physician\", \"Trained social worker counselor\", \"Caregiver\", etc.", 0, 1, this.role);
                }
                case -1077769574: {
                    return new Property("member", "Reference(Practitioner|PractitionerRole|RelatedPerson|Patient|Organization|CareTeam)", "The specific person or organization who is participating/expected to participate in the care team.", 0, 1, this.member);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization of the practitioner.", 0, 1, this.onBehalfOf);
                }
                case 227689880: {
                    return new Property("coverage[x]", "Period|Timing", "When the member is generally available within this care team.", 0, 1, this.coverage);
                }
                case -351767064: {
                    return new Property("coverage[x]", "Period|Timing", "When the member is generally available within this care team.", 0, 1, this.coverage);
                }
                case 1024117193: {
                    return new Property("coverage[x]", "Period", "When the member is generally available within this care team.", 0, 1, this.coverage);
                }
                case 1142178898: {
                    return new Property("coverage[x]", "Timing", "When the member is generally available within this care team.", 0, 1, this.coverage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -1077769574: {
                    Base[] baseArray;
                    if (this.member == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.member;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.coverage;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1077769574: {
                    this.member = TypeConvertor.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = TypeConvertor.castToReference(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("member")) {
                this.member = TypeConvertor.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = TypeConvertor.castToReference(value);
            } else if (name.equals("coverage[x]")) {
                this.coverage = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -1077769574: {
                    return this.getMember();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
                case 227689880: {
                    return this.getCoverage();
                }
                case -351767064: {
                    return this.getCoverage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -1077769574: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
                case -351767064: {
                    return new String[]{"Period", "Timing"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("member")) {
                this.member = new Reference();
                return this.member;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            if (name.equals("coveragePeriod")) {
                this.coverage = new Period();
                return this.coverage;
            }
            if (name.equals("coverageTiming")) {
                this.coverage = new Timing();
                return this.coverage;
            }
            return super.addChild(name);
        }

        @Override
        public CareTeamParticipantComponent copy() {
            CareTeamParticipantComponent dst = new CareTeamParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CareTeamParticipantComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.member = this.member == null ? null : this.member.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamParticipantComponent)) {
                return false;
            }
            CareTeamParticipantComponent o = (CareTeamParticipantComponent)other_;
            return CareTeamParticipantComponent.compareDeep(this.role, o.role, true) && CareTeamParticipantComponent.compareDeep(this.member, o.member, true) && CareTeamParticipantComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true) && CareTeamParticipantComponent.compareDeep(this.coverage, o.coverage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamParticipantComponent)) {
                return false;
            }
            CareTeamParticipantComponent o = (CareTeamParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.member, this.onBehalfOf, this.coverage});
        }

        @Override
        public String fhirType() {
            return "CareTeam.participant";
        }
    }

    public static class CareTeamStatusEnumFactory
    implements EnumFactory<CareTeamStatus> {
        @Override
        public CareTeamStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return CareTeamStatus.PROPOSED;
            }
            if ("active".equals(codeString)) {
                return CareTeamStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return CareTeamStatus.SUSPENDED;
            }
            if ("inactive".equals(codeString)) {
                return CareTeamStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return CareTeamStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown CareTeamStatus code '" + codeString + "'");
        }

        public Enumeration<CareTeamStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.NULL, code);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.PROPOSED, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.ACTIVE, code);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.SUSPENDED, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CareTeamStatus>(this, CareTeamStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown CareTeamStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CareTeamStatus code) {
            if (code == CareTeamStatus.PROPOSED) {
                return "proposed";
            }
            if (code == CareTeamStatus.ACTIVE) {
                return "active";
            }
            if (code == CareTeamStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == CareTeamStatus.INACTIVE) {
                return "inactive";
            }
            if (code == CareTeamStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(CareTeamStatus code) {
            return code.getSystem();
        }
    }

    public static enum CareTeamStatus {
        PROPOSED,
        ACTIVE,
        SUSPENDED,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static CareTeamStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CareTeamStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/care-team-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/care-team-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/care-team-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/care-team-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/care-team-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The care team has been drafted and proposed, but not yet participating in the coordination and delivery of patient care.";
                }
                case ACTIVE: {
                    return "The care team is currently participating in the coordination and delivery of care.";
                }
                case SUSPENDED: {
                    return "The care team is temporarily on hold or suspended and not participating in the coordination and delivery of care.";
                }
                case INACTIVE: {
                    return "The care team was, but is no longer, participating in the coordination and delivery of care.";
                }
                case ENTEREDINERROR: {
                    return "The care team should have never existed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

