/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="DataRequirement")
public class DataRequirement
extends DataType
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of the required data", formalDefinition="The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-types")
    protected Enumeration<Enumerations.FHIRTypes> type;
    @Child(name="profile", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The profile of the required data", formalDefinition="The profile of the required data, specified as the uri of the profile definition.")
    protected List<CanonicalType> profile;
    @Child(name="subject", type={CodeableConcept.class, Group.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. Patient, Practitioner, RelatedPerson, Organization, Location, Device", formalDefinition="The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/participant-resource-types")
    protected DataType subject;
    @Child(name="mustSupport", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates specific structure elements that are referenced by the knowledge module", formalDefinition="Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. \n\nThe value of mustSupport SHALL be a FHIRPath resolvable on the type of the DataRequirement. The path SHALL consist only of identifiers, constant indexers, and .resolve() (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).")
    protected List<StringType> mustSupport;
    @Child(name="codeFilter", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What codes are expected", formalDefinition="Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.")
    protected List<DataRequirementCodeFilterComponent> codeFilter;
    @Child(name="dateFilter", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What dates/date ranges are expected", formalDefinition="Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.")
    protected List<DataRequirementDateFilterComponent> dateFilter;
    @Child(name="valueFilter", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What values are expected", formalDefinition="Value filters specify additional constraints on the data for elements other than code-valued or date-valued. Each value filter specifies an additional constraint on the data (i.e. valueFilters are AND'ed, not OR'ed).")
    protected List<DataRequirementValueFilterComponent> valueFilter;
    @Child(name="limit", type={PositiveIntType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of results", formalDefinition="Specifies a maximum number of results that are required (uses the _count search parameter).")
    protected PositiveIntType limit;
    @Child(name="sort", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Order of the results", formalDefinition="Specifies the order of the results to be returned.")
    protected List<DataRequirementSortComponent> sort;
    private static final long serialVersionUID = -2078097376L;

    public DataRequirement() {
    }

    public DataRequirement(Enumerations.FHIRTypes type) {
        this.setType(type);
    }

    public Enumeration<Enumerations.FHIRTypes> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataRequirement.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<Enumerations.FHIRTypes>(new Enumerations.FHIRTypesEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DataRequirement setTypeElement(Enumeration<Enumerations.FHIRTypes> value) {
        this.type = value;
        return this;
    }

    public Enumerations.FHIRTypes getType() {
        return this.type == null ? null : (Enumerations.FHIRTypes)((Object)this.type.getValue());
    }

    public DataRequirement setType(Enumerations.FHIRTypes value) {
        if (this.type == null) {
            this.type = new Enumeration<Enumerations.FHIRTypes>(new Enumerations.FHIRTypesEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public List<CanonicalType> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<CanonicalType>();
        }
        return this.profile;
    }

    public DataRequirement setProfile(List<CanonicalType> theProfile) {
        this.profile = theProfile;
        return this;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (CanonicalType item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addProfileElement() {
        CanonicalType t = new CanonicalType();
        if (this.profile == null) {
            this.profile = new ArrayList<CanonicalType>();
        }
        this.profile.add(t);
        return t;
    }

    public DataRequirement addProfile(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.profile == null) {
            this.profile = new ArrayList<CanonicalType>();
        }
        this.profile.add(t);
        return this;
    }

    public boolean hasProfile(String value) {
        if (this.profile == null) {
            return false;
        }
        for (CanonicalType v : this.profile) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public DataType getSubject() {
        return this.subject;
    }

    public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CodeableConcept();
        }
        if (!(this.subject instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.subject;
    }

    public boolean hasSubjectCodeableConcept() {
        return this != null && this.subject instanceof CodeableConcept;
    }

    public Reference getSubjectReference() throws FHIRException {
        if (this.subject == null) {
            this.subject = new Reference();
        }
        if (!(this.subject instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (Reference)this.subject;
    }

    public boolean hasSubjectReference() {
        return this != null && this.subject instanceof Reference;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DataRequirement setSubject(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRException("Not the right type for DataRequirement.subject[x]: " + value.fhirType());
        }
        this.subject = value;
        return this;
    }

    public List<StringType> getMustSupport() {
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        return this.mustSupport;
    }

    public DataRequirement setMustSupport(List<StringType> theMustSupport) {
        this.mustSupport = theMustSupport;
        return this;
    }

    public boolean hasMustSupport() {
        if (this.mustSupport == null) {
            return false;
        }
        for (StringType item : this.mustSupport) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addMustSupportElement() {
        StringType t = new StringType();
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        this.mustSupport.add(t);
        return t;
    }

    public DataRequirement addMustSupport(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        this.mustSupport.add(t);
        return this;
    }

    public boolean hasMustSupport(String value) {
        if (this.mustSupport == null) {
            return false;
        }
        for (StringType v : this.mustSupport) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<DataRequirementCodeFilterComponent> getCodeFilter() {
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        return this.codeFilter;
    }

    public DataRequirement setCodeFilter(List<DataRequirementCodeFilterComponent> theCodeFilter) {
        this.codeFilter = theCodeFilter;
        return this;
    }

    public boolean hasCodeFilter() {
        if (this.codeFilter == null) {
            return false;
        }
        for (DataRequirementCodeFilterComponent item : this.codeFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementCodeFilterComponent addCodeFilter() {
        DataRequirementCodeFilterComponent t = new DataRequirementCodeFilterComponent();
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        this.codeFilter.add(t);
        return t;
    }

    public DataRequirement addCodeFilter(DataRequirementCodeFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        this.codeFilter.add(t);
        return this;
    }

    public DataRequirementCodeFilterComponent getCodeFilterFirstRep() {
        if (this.getCodeFilter().isEmpty()) {
            this.addCodeFilter();
        }
        return this.getCodeFilter().get(0);
    }

    public List<DataRequirementDateFilterComponent> getDateFilter() {
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        return this.dateFilter;
    }

    public DataRequirement setDateFilter(List<DataRequirementDateFilterComponent> theDateFilter) {
        this.dateFilter = theDateFilter;
        return this;
    }

    public boolean hasDateFilter() {
        if (this.dateFilter == null) {
            return false;
        }
        for (DataRequirementDateFilterComponent item : this.dateFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementDateFilterComponent addDateFilter() {
        DataRequirementDateFilterComponent t = new DataRequirementDateFilterComponent();
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        this.dateFilter.add(t);
        return t;
    }

    public DataRequirement addDateFilter(DataRequirementDateFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        this.dateFilter.add(t);
        return this;
    }

    public DataRequirementDateFilterComponent getDateFilterFirstRep() {
        if (this.getDateFilter().isEmpty()) {
            this.addDateFilter();
        }
        return this.getDateFilter().get(0);
    }

    public List<DataRequirementValueFilterComponent> getValueFilter() {
        if (this.valueFilter == null) {
            this.valueFilter = new ArrayList<DataRequirementValueFilterComponent>();
        }
        return this.valueFilter;
    }

    public DataRequirement setValueFilter(List<DataRequirementValueFilterComponent> theValueFilter) {
        this.valueFilter = theValueFilter;
        return this;
    }

    public boolean hasValueFilter() {
        if (this.valueFilter == null) {
            return false;
        }
        for (DataRequirementValueFilterComponent item : this.valueFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementValueFilterComponent addValueFilter() {
        DataRequirementValueFilterComponent t = new DataRequirementValueFilterComponent();
        if (this.valueFilter == null) {
            this.valueFilter = new ArrayList<DataRequirementValueFilterComponent>();
        }
        this.valueFilter.add(t);
        return t;
    }

    public DataRequirement addValueFilter(DataRequirementValueFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.valueFilter == null) {
            this.valueFilter = new ArrayList<DataRequirementValueFilterComponent>();
        }
        this.valueFilter.add(t);
        return this;
    }

    public DataRequirementValueFilterComponent getValueFilterFirstRep() {
        if (this.getValueFilter().isEmpty()) {
            this.addValueFilter();
        }
        return this.getValueFilter().get(0);
    }

    public PositiveIntType getLimitElement() {
        if (this.limit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataRequirement.limit");
            }
            if (Configuration.doAutoCreate()) {
                this.limit = new PositiveIntType();
            }
        }
        return this.limit;
    }

    public boolean hasLimitElement() {
        return this.limit != null && !this.limit.isEmpty();
    }

    public boolean hasLimit() {
        return this.limit != null && !this.limit.isEmpty();
    }

    public DataRequirement setLimitElement(PositiveIntType value) {
        this.limit = value;
        return this;
    }

    public int getLimit() {
        return this.limit == null || this.limit.isEmpty() ? 0 : (Integer)this.limit.getValue();
    }

    public DataRequirement setLimit(int value) {
        if (this.limit == null) {
            this.limit = new PositiveIntType();
        }
        this.limit.setValue((Object)value);
        return this;
    }

    public List<DataRequirementSortComponent> getSort() {
        if (this.sort == null) {
            this.sort = new ArrayList<DataRequirementSortComponent>();
        }
        return this.sort;
    }

    public DataRequirement setSort(List<DataRequirementSortComponent> theSort) {
        this.sort = theSort;
        return this;
    }

    public boolean hasSort() {
        if (this.sort == null) {
            return false;
        }
        for (DataRequirementSortComponent item : this.sort) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementSortComponent addSort() {
        DataRequirementSortComponent t = new DataRequirementSortComponent();
        if (this.sort == null) {
            this.sort = new ArrayList<DataRequirementSortComponent>();
        }
        this.sort.add(t);
        return t;
    }

    public DataRequirement addSort(DataRequirementSortComponent t) {
        if (t == null) {
            return this;
        }
        if (this.sort == null) {
            this.sort = new ArrayList<DataRequirementSortComponent>();
        }
        this.sort.add(t);
        return this;
    }

    public DataRequirementSortComponent getSortFirstRep() {
        if (this.getSort().isEmpty()) {
            this.addSort();
        }
        return this.getSort().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "code", "The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.", 0, 1, this.type));
        children.add(new Property("profile", "canonical(StructureDefinition)", "The profile of the required data, specified as the uri of the profile definition.", 0, Integer.MAX_VALUE, this.profile));
        children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.", 0, 1, this.subject));
        children.add(new Property("mustSupport", "string", "Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. \n\nThe value of mustSupport SHALL be a FHIRPath resolvable on the type of the DataRequirement. The path SHALL consist only of identifiers, constant indexers, and .resolve() (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, Integer.MAX_VALUE, this.mustSupport));
        children.add(new Property("codeFilter", "", "Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.codeFilter));
        children.add(new Property("dateFilter", "", "Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.dateFilter));
        children.add(new Property("valueFilter", "", "Value filters specify additional constraints on the data for elements other than code-valued or date-valued. Each value filter specifies an additional constraint on the data (i.e. valueFilters are AND'ed, not OR'ed).", 0, Integer.MAX_VALUE, this.valueFilter));
        children.add(new Property("limit", "positiveInt", "Specifies a maximum number of results that are required (uses the _count search parameter).", 0, 1, this.limit));
        children.add(new Property("sort", "", "Specifies the order of the results to be returned.", 0, Integer.MAX_VALUE, this.sort));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "code", "The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.", 0, 1, this.type);
            }
            case -309425751: {
                return new Property("profile", "canonical(StructureDefinition)", "The profile of the required data, specified as the uri of the profile definition.", 0, Integer.MAX_VALUE, this.profile);
            }
            case -573640748: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.", 0, 1, this.subject);
            }
            case -1867885268: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.", 0, 1, this.subject);
            }
            case -1257122603: {
                return new Property("subject[x]", "CodeableConcept", "The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.", 0, 1, this.subject);
            }
            case 772938623: {
                return new Property("subject[x]", "Reference(Group)", "The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.", 0, 1, this.subject);
            }
            case -1402857082: {
                return new Property("mustSupport", "string", "Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. \n\nThe value of mustSupport SHALL be a FHIRPath resolvable on the type of the DataRequirement. The path SHALL consist only of identifiers, constant indexers, and .resolve() (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, Integer.MAX_VALUE, this.mustSupport);
            }
            case -1303674939: {
                return new Property("codeFilter", "", "Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.codeFilter);
            }
            case 149531846: {
                return new Property("dateFilter", "", "Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.", 0, Integer.MAX_VALUE, this.dateFilter);
            }
            case -1807110071: {
                return new Property("valueFilter", "", "Value filters specify additional constraints on the data for elements other than code-valued or date-valued. Each value filter specifies an additional constraint on the data (i.e. valueFilters are AND'ed, not OR'ed).", 0, Integer.MAX_VALUE, this.valueFilter);
            }
            case 102976443: {
                return new Property("limit", "positiveInt", "Specifies a maximum number of results that are required (uses the _count search parameter).", 0, 1, this.limit);
            }
            case 3536286: {
                return new Property("sort", "", "Specifies the order of the results to be returned.", 0, Integer.MAX_VALUE, this.sort);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -309425751: {
                return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case -1402857082: {
                return this.mustSupport == null ? new Base[]{} : this.mustSupport.toArray(new Base[this.mustSupport.size()]);
            }
            case -1303674939: {
                return this.codeFilter == null ? new Base[]{} : this.codeFilter.toArray(new Base[this.codeFilter.size()]);
            }
            case 149531846: {
                return this.dateFilter == null ? new Base[]{} : this.dateFilter.toArray(new Base[this.dateFilter.size()]);
            }
            case -1807110071: {
                return this.valueFilter == null ? new Base[]{} : this.valueFilter.toArray(new Base[this.valueFilter.size()]);
            }
            case 102976443: {
                Base[] baseArray;
                if (this.limit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.limit;
                }
                return baseArray;
            }
            case 3536286: {
                return this.sort == null ? new Base[]{} : this.sort.toArray(new Base[this.sort.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                value = new Enumerations.FHIRTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case -309425751: {
                this.getProfile().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToType(value);
                return value;
            }
            case -1402857082: {
                this.getMustSupport().add(TypeConvertor.castToString(value));
                return value;
            }
            case -1303674939: {
                this.getCodeFilter().add((DataRequirementCodeFilterComponent)((Object)value));
                return value;
            }
            case 149531846: {
                this.getDateFilter().add((DataRequirementDateFilterComponent)((Object)value));
                return value;
            }
            case -1807110071: {
                this.getValueFilter().add((DataRequirementValueFilterComponent)((Object)value));
                return value;
            }
            case 102976443: {
                this.limit = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 3536286: {
                this.getSort().add((DataRequirementSortComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            value = new Enumerations.FHIRTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("profile")) {
            this.getProfile().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("subject[x]")) {
            this.subject = TypeConvertor.castToType(value);
        } else if (name.equals("mustSupport")) {
            this.getMustSupport().add(TypeConvertor.castToString(value));
        } else if (name.equals("codeFilter")) {
            this.getCodeFilter().add((DataRequirementCodeFilterComponent)((Object)value));
        } else if (name.equals("dateFilter")) {
            this.getDateFilter().add((DataRequirementDateFilterComponent)((Object)value));
        } else if (name.equals("valueFilter")) {
            this.getValueFilter().add((DataRequirementValueFilterComponent)((Object)value));
        } else if (name.equals("limit")) {
            this.limit = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("sort")) {
            this.getSort().add((DataRequirementSortComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case -309425751: {
                return this.addProfileElement();
            }
            case -573640748: {
                return this.getSubject();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1402857082: {
                return this.addMustSupportElement();
            }
            case -1303674939: {
                return this.addCodeFilter();
            }
            case 149531846: {
                return this.addDateFilter();
            }
            case -1807110071: {
                return this.addValueFilter();
            }
            case 102976443: {
                return this.getLimitElement();
            }
            case 3536286: {
                return this.addSort();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case -309425751: {
                return new String[]{"canonical"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1402857082: {
                return new String[]{"string"};
            }
            case -1303674939: {
                return new String[0];
            }
            case 149531846: {
                return new String[0];
            }
            case -1807110071: {
                return new String[0];
            }
            case 102976443: {
                return new String[]{"positiveInt"};
            }
            case 3536286: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.type");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.profile");
        }
        if (name.equals("subjectCodeableConcept")) {
            this.subject = new CodeableConcept();
            return this.subject;
        }
        if (name.equals("subjectReference")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("mustSupport")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.mustSupport");
        }
        if (name.equals("codeFilter")) {
            return this.addCodeFilter();
        }
        if (name.equals("dateFilter")) {
            return this.addDateFilter();
        }
        if (name.equals("valueFilter")) {
            return this.addValueFilter();
        }
        if (name.equals("limit")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.limit");
        }
        if (name.equals("sort")) {
            return this.addSort();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DataRequirement";
    }

    @Override
    public DataRequirement copy() {
        DataRequirement dst = new DataRequirement();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DataRequirement dst) {
        super.copyValues(dst);
        Enumeration<Enumerations.FHIRTypes> enumeration = dst.type = this.type == null ? null : this.type.copy();
        if (this.profile != null) {
            dst.profile = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.profile) {
                dst.profile.add(canonicalType.copy());
            }
        }
        DataType dataType = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.mustSupport != null) {
            dst.mustSupport = new ArrayList<StringType>();
            for (StringType stringType : this.mustSupport) {
                dst.mustSupport.add(stringType.copy());
            }
        }
        if (this.codeFilter != null) {
            dst.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
            for (DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : this.codeFilter) {
                dst.codeFilter.add(dataRequirementCodeFilterComponent.copy());
            }
        }
        if (this.dateFilter != null) {
            dst.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
            for (DataRequirementDateFilterComponent dataRequirementDateFilterComponent : this.dateFilter) {
                dst.dateFilter.add(dataRequirementDateFilterComponent.copy());
            }
        }
        if (this.valueFilter != null) {
            dst.valueFilter = new ArrayList<DataRequirementValueFilterComponent>();
            for (DataRequirementValueFilterComponent dataRequirementValueFilterComponent : this.valueFilter) {
                dst.valueFilter.add(dataRequirementValueFilterComponent.copy());
            }
        }
        PositiveIntType positiveIntType = dst.limit = this.limit == null ? null : this.limit.copy();
        if (this.sort != null) {
            dst.sort = new ArrayList<DataRequirementSortComponent>();
            for (DataRequirementSortComponent dataRequirementSortComponent : this.sort) {
                dst.sort.add(dataRequirementSortComponent.copy());
            }
        }
    }

    protected DataRequirement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DataRequirement)) {
            return false;
        }
        DataRequirement o = (DataRequirement)other_;
        return DataRequirement.compareDeep(this.type, o.type, true) && DataRequirement.compareDeep(this.profile, o.profile, true) && DataRequirement.compareDeep(this.subject, o.subject, true) && DataRequirement.compareDeep(this.mustSupport, o.mustSupport, true) && DataRequirement.compareDeep(this.codeFilter, o.codeFilter, true) && DataRequirement.compareDeep(this.dateFilter, o.dateFilter, true) && DataRequirement.compareDeep(this.valueFilter, o.valueFilter, true) && DataRequirement.compareDeep(this.limit, o.limit, true) && DataRequirement.compareDeep(this.sort, o.sort, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DataRequirement)) {
            return false;
        }
        DataRequirement o = (DataRequirement)other_;
        return DataRequirement.compareValues(this.type, o.type, true) && DataRequirement.compareValues(this.profile, o.profile, true) && DataRequirement.compareValues(this.mustSupport, o.mustSupport, true) && DataRequirement.compareValues(this.limit, o.limit, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.profile, this.subject, this.mustSupport, this.codeFilter, this.dateFilter, this.valueFilter, this.limit, this.sort});
    }

    @Block
    public static class DataRequirementSortComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name of the attribute to perform the sort", formalDefinition="The attribute of the sort. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant.")
        protected StringType path;
        @Child(name="direction", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ascending | descending", formalDefinition="The direction of the sort, ascending or descending.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/sort-direction")
        protected Enumeration<SortDirection> direction;
        private static final long serialVersionUID = -694498683L;

        public DataRequirementSortComponent() {
        }

        public DataRequirementSortComponent(String path, SortDirection direction) {
            this.setPath(path);
            this.setDirection(direction);
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementSortComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementSortComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementSortComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Enumeration<SortDirection> getDirectionElement() {
            if (this.direction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementSortComponent.direction");
                }
                if (Configuration.doAutoCreate()) {
                    this.direction = new Enumeration<SortDirection>(new SortDirectionEnumFactory());
                }
            }
            return this.direction;
        }

        public boolean hasDirectionElement() {
            return this.direction != null && !this.direction.isEmpty();
        }

        public boolean hasDirection() {
            return this.direction != null && !this.direction.isEmpty();
        }

        public DataRequirementSortComponent setDirectionElement(Enumeration<SortDirection> value) {
            this.direction = value;
            return this;
        }

        public SortDirection getDirection() {
            return this.direction == null ? null : (SortDirection)((Object)this.direction.getValue());
        }

        public DataRequirementSortComponent setDirection(SortDirection value) {
            if (this.direction == null) {
                this.direction = new Enumeration<SortDirection>(new SortDirectionEnumFactory());
            }
            this.direction.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The attribute of the sort. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant.", 0, 1, this.path));
            children.add(new Property("direction", "code", "The direction of the sort, ascending or descending.", 0, 1, this.direction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The attribute of the sort. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant.", 0, 1, this.path);
                }
                case -962590849: {
                    return new Property("direction", "code", "The direction of the sort, ascending or descending.", 0, 1, this.direction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -962590849: {
                    Base[] baseArray;
                    if (this.direction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.direction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -962590849: {
                    value = new SortDirectionEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.direction = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("direction")) {
                value = new SortDirectionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.direction = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -962590849: {
                    return this.getDirectionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -962590849: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.sort.path");
            }
            if (name.equals("direction")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.sort.direction");
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementSortComponent copy() {
            DataRequirementSortComponent dst = new DataRequirementSortComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DataRequirementSortComponent dst) {
            super.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.direction = this.direction == null ? null : this.direction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementSortComponent)) {
                return false;
            }
            DataRequirementSortComponent o = (DataRequirementSortComponent)other_;
            return DataRequirementSortComponent.compareDeep(this.path, o.path, true) && DataRequirementSortComponent.compareDeep(this.direction, o.direction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementSortComponent)) {
                return false;
            }
            DataRequirementSortComponent o = (DataRequirementSortComponent)other_;
            return DataRequirementSortComponent.compareValues(this.path, o.path, true) && DataRequirementSortComponent.compareValues(this.direction, o.direction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.direction});
        }

        @Override
        public String fhirType() {
            return "DataRequirement.sort";
        }
    }

    @Block
    public static class DataRequirementValueFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An attribute to filter on", formalDefinition="The attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of a type that is comparable to the valueFilter.value[x] element for the filter.")
        protected StringType path;
        @Child(name="searchParam", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A parameter to search on", formalDefinition="A search parameter defined on the specified type of the DataRequirement, and which searches on elements of a type compatible with the type of the valueFilter.value[x] for the filter.")
        protected StringType searchParam;
        @Child(name="comparator", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="eq | gt | lt | ge | le | sa | eb", formalDefinition="The comparator to be used to determine whether the value is matching.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/value-filter-comparator")
        protected Enumeration<ValueFilterComparator> comparator;
        @Child(name="value", type={DateTimeType.class, Period.class, Duration.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The value of the filter, as a Period, DateTime, or Duration value", formalDefinition="The value of the filter.")
        protected DataType value;
        private static final long serialVersionUID = 2106988483L;

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementValueFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementValueFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementValueFilterComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public StringType getSearchParamElement() {
            if (this.searchParam == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementValueFilterComponent.searchParam");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchParam = new StringType();
                }
            }
            return this.searchParam;
        }

        public boolean hasSearchParamElement() {
            return this.searchParam != null && !this.searchParam.isEmpty();
        }

        public boolean hasSearchParam() {
            return this.searchParam != null && !this.searchParam.isEmpty();
        }

        public DataRequirementValueFilterComponent setSearchParamElement(StringType value) {
            this.searchParam = value;
            return this;
        }

        public String getSearchParam() {
            return this.searchParam == null ? null : (String)this.searchParam.getValue();
        }

        public DataRequirementValueFilterComponent setSearchParam(String value) {
            if (Utilities.noString((String)value)) {
                this.searchParam = null;
            } else {
                if (this.searchParam == null) {
                    this.searchParam = new StringType();
                }
                this.searchParam.setValue(value);
            }
            return this;
        }

        public Enumeration<ValueFilterComparator> getComparatorElement() {
            if (this.comparator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementValueFilterComponent.comparator");
                }
                if (Configuration.doAutoCreate()) {
                    this.comparator = new Enumeration<ValueFilterComparator>(new ValueFilterComparatorEnumFactory());
                }
            }
            return this.comparator;
        }

        public boolean hasComparatorElement() {
            return this.comparator != null && !this.comparator.isEmpty();
        }

        public boolean hasComparator() {
            return this.comparator != null && !this.comparator.isEmpty();
        }

        public DataRequirementValueFilterComponent setComparatorElement(Enumeration<ValueFilterComparator> value) {
            this.comparator = value;
            return this;
        }

        public ValueFilterComparator getComparator() {
            return this.comparator == null ? null : (ValueFilterComparator)((Object)this.comparator.getValue());
        }

        public DataRequirementValueFilterComponent setComparator(ValueFilterComparator value) {
            if (value == null) {
                this.comparator = null;
            } else {
                if (this.comparator == null) {
                    this.comparator = new Enumeration<ValueFilterComparator>(new ValueFilterComparatorEnumFactory());
                }
                this.comparator.setValue((Object)value);
            }
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DataRequirementValueFilterComponent setValue(DataType value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration)) {
                throw new FHIRException("Not the right type for DataRequirement.valueFilter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of a type that is comparable to the valueFilter.value[x] element for the filter.", 0, 1, this.path));
            children.add(new Property("searchParam", "string", "A search parameter defined on the specified type of the DataRequirement, and which searches on elements of a type compatible with the type of the valueFilter.value[x] for the filter.", 0, 1, this.searchParam));
            children.add(new Property("comparator", "code", "The comparator to be used to determine whether the value is matching.", 0, 1, this.comparator));
            children.add(new Property("value[x]", "dateTime|Period|Duration", "The value of the filter.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of a type that is comparable to the valueFilter.value[x] element for the filter.", 0, 1, this.path);
                }
                case -553645115: {
                    return new Property("searchParam", "string", "A search parameter defined on the specified type of the DataRequirement, and which searches on elements of a type compatible with the type of the valueFilter.value[x] for the filter.", 0, 1, this.searchParam);
                }
                case -844673834: {
                    return new Property("comparator", "code", "The comparator to be used to determine whether the value is matching.", 0, 1, this.comparator);
                }
                case -1410166417: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the filter.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The value of the filter.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the filter.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -553645115: {
                    Base[] baseArray;
                    if (this.searchParam == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.searchParam;
                    }
                    return baseArray;
                }
                case -844673834: {
                    Base[] baseArray;
                    if (this.comparator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.comparator;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -553645115: {
                    this.searchParam = TypeConvertor.castToString(value);
                    return value;
                }
                case -844673834: {
                    value = new ValueFilterComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.comparator = value;
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("searchParam")) {
                this.searchParam = TypeConvertor.castToString(value);
            } else if (name.equals("comparator")) {
                value = new ValueFilterComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.comparator = value;
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -553645115: {
                    return this.getSearchParamElement();
                }
                case -844673834: {
                    return this.getComparatorElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -553645115: {
                    return new String[]{"string"};
                }
                case -844673834: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"dateTime", "Period", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.valueFilter.path");
            }
            if (name.equals("searchParam")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.valueFilter.searchParam");
            }
            if (name.equals("comparator")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.valueFilter.comparator");
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementValueFilterComponent copy() {
            DataRequirementValueFilterComponent dst = new DataRequirementValueFilterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DataRequirementValueFilterComponent dst) {
            super.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.searchParam = this.searchParam == null ? null : this.searchParam.copy();
            dst.comparator = this.comparator == null ? null : this.comparator.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementValueFilterComponent)) {
                return false;
            }
            DataRequirementValueFilterComponent o = (DataRequirementValueFilterComponent)other_;
            return DataRequirementValueFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementValueFilterComponent.compareDeep(this.searchParam, o.searchParam, true) && DataRequirementValueFilterComponent.compareDeep(this.comparator, o.comparator, true) && DataRequirementValueFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementValueFilterComponent)) {
                return false;
            }
            DataRequirementValueFilterComponent o = (DataRequirementValueFilterComponent)other_;
            return DataRequirementValueFilterComponent.compareValues(this.path, o.path, true) && DataRequirementValueFilterComponent.compareValues(this.searchParam, o.searchParam, true) && DataRequirementValueFilterComponent.compareValues(this.comparator, o.comparator, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.searchParam, this.comparator, this.value});
        }

        @Override
        public String fhirType() {
            return "DataRequirement.valueFilter";
        }
    }

    @Block
    public static class DataRequirementDateFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A date-valued attribute to filter on", formalDefinition="The date-valued attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type date, dateTime, Period, Schedule, or Timing.")
        protected StringType path;
        @Child(name="searchParam", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A date valued parameter to search on", formalDefinition="A date parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type date, dateTime, Period, Schedule, or Timing.")
        protected StringType searchParam;
        @Child(name="value", type={DateTimeType.class, Period.class, Duration.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The value of the filter, as a Period, DateTime, or Duration value", formalDefinition="The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.")
        protected DataType value;
        private static final long serialVersionUID = 1649787979L;

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementDateFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementDateFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementDateFilterComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public StringType getSearchParamElement() {
            if (this.searchParam == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementDateFilterComponent.searchParam");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchParam = new StringType();
                }
            }
            return this.searchParam;
        }

        public boolean hasSearchParamElement() {
            return this.searchParam != null && !this.searchParam.isEmpty();
        }

        public boolean hasSearchParam() {
            return this.searchParam != null && !this.searchParam.isEmpty();
        }

        public DataRequirementDateFilterComponent setSearchParamElement(StringType value) {
            this.searchParam = value;
            return this;
        }

        public String getSearchParam() {
            return this.searchParam == null ? null : (String)this.searchParam.getValue();
        }

        public DataRequirementDateFilterComponent setSearchParam(String value) {
            if (Utilities.noString((String)value)) {
                this.searchParam = null;
            } else {
                if (this.searchParam == null) {
                    this.searchParam = new StringType();
                }
                this.searchParam.setValue(value);
            }
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DataRequirementDateFilterComponent setValue(DataType value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration)) {
                throw new FHIRException("Not the right type for DataRequirement.dateFilter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The date-valued attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type date, dateTime, Period, Schedule, or Timing.", 0, 1, this.path));
            children.add(new Property("searchParam", "string", "A date parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type date, dateTime, Period, Schedule, or Timing.", 0, 1, this.searchParam));
            children.add(new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The date-valued attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type date, dateTime, Period, Schedule, or Timing.", 0, 1, this.path);
                }
                case -553645115: {
                    return new Property("searchParam", "string", "A date parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type date, dateTime, Period, Schedule, or Timing.", 0, 1, this.searchParam);
                }
                case -1410166417: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "dateTime|Period|Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime. If a Duration is specified, the filter will return only those data items that fall within Duration before now.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -553645115: {
                    Base[] baseArray;
                    if (this.searchParam == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.searchParam;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -553645115: {
                    this.searchParam = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("searchParam")) {
                this.searchParam = TypeConvertor.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -553645115: {
                    return this.getSearchParamElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -553645115: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"dateTime", "Period", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.dateFilter.path");
            }
            if (name.equals("searchParam")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.dateFilter.searchParam");
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementDateFilterComponent copy() {
            DataRequirementDateFilterComponent dst = new DataRequirementDateFilterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DataRequirementDateFilterComponent dst) {
            super.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.searchParam = this.searchParam == null ? null : this.searchParam.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementDateFilterComponent)) {
                return false;
            }
            DataRequirementDateFilterComponent o = (DataRequirementDateFilterComponent)other_;
            return DataRequirementDateFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementDateFilterComponent.compareDeep(this.searchParam, o.searchParam, true) && DataRequirementDateFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementDateFilterComponent)) {
                return false;
            }
            DataRequirementDateFilterComponent o = (DataRequirementDateFilterComponent)other_;
            return DataRequirementDateFilterComponent.compareValues(this.path, o.path, true) && DataRequirementDateFilterComponent.compareValues(this.searchParam, o.searchParam, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.searchParam, this.value});
        }

        @Override
        public String fhirType() {
            return "DataRequirement.dateFilter";
        }
    }

    @Block
    public static class DataRequirementCodeFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code-valued attribute to filter on", formalDefinition="The code-valued attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.")
        protected StringType path;
        @Child(name="searchParam", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A coded (token) parameter to search on", formalDefinition="A token parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type code, Coding, or CodeableConcept.")
        protected StringType searchParam;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ValueSet for the filter", formalDefinition="The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.")
        protected CanonicalType valueSet;
        @Child(name="code", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="What code is expected", formalDefinition="The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.")
        protected List<Coding> code;
        private static final long serialVersionUID = -1286212752L;

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementCodeFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementCodeFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementCodeFilterComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public StringType getSearchParamElement() {
            if (this.searchParam == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementCodeFilterComponent.searchParam");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchParam = new StringType();
                }
            }
            return this.searchParam;
        }

        public boolean hasSearchParamElement() {
            return this.searchParam != null && !this.searchParam.isEmpty();
        }

        public boolean hasSearchParam() {
            return this.searchParam != null && !this.searchParam.isEmpty();
        }

        public DataRequirementCodeFilterComponent setSearchParamElement(StringType value) {
            this.searchParam = value;
            return this;
        }

        public String getSearchParam() {
            return this.searchParam == null ? null : (String)this.searchParam.getValue();
        }

        public DataRequirementCodeFilterComponent setSearchParam(String value) {
            if (Utilities.noString((String)value)) {
                this.searchParam = null;
            } else {
                if (this.searchParam == null) {
                    this.searchParam = new StringType();
                }
                this.searchParam.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementCodeFilterComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public DataRequirementCodeFilterComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public DataRequirementCodeFilterComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public List<Coding> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            return this.code;
        }

        public DataRequirementCodeFilterComponent setCode(List<Coding> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (Coding item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addCode() {
            Coding t = new Coding();
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return t;
        }

        public DataRequirementCodeFilterComponent addCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return this;
        }

        public Coding getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The code-valued attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.", 0, 1, this.path));
            children.add(new Property("searchParam", "string", "A token parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type code, Coding, or CodeableConcept.", 0, 1, this.searchParam));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet));
            children.add(new Property("code", "Coding", "The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.", 0, Integer.MAX_VALUE, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The code-valued attribute of the filter. The specified path SHALL be a FHIRPath resolvable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.", 0, 1, this.path);
                }
                case -553645115: {
                    return new Property("searchParam", "string", "A token parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type code, Coding, or CodeableConcept.", 0, 1, this.searchParam);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, 1, this.valueSet);
                }
                case 3059181: {
                    return new Property("code", "Coding", "The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.", 0, Integer.MAX_VALUE, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -553645115: {
                    Base[] baseArray;
                    if (this.searchParam == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.searchParam;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -553645115: {
                    this.searchParam = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCoding(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("searchParam")) {
                this.searchParam = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("code")) {
                this.getCode().add(TypeConvertor.castToCoding(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -553645115: {
                    return this.getSearchParamElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case 3059181: {
                    return this.addCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -553645115: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case 3059181: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.codeFilter.path");
            }
            if (name.equals("searchParam")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.codeFilter.searchParam");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.codeFilter.valueSet");
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementCodeFilterComponent copy() {
            DataRequirementCodeFilterComponent dst = new DataRequirementCodeFilterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DataRequirementCodeFilterComponent dst) {
            super.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.searchParam = this.searchParam == null ? null : this.searchParam.copy();
            CanonicalType canonicalType = dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            if (this.code != null) {
                dst.code = new ArrayList<Coding>();
                for (Coding i : this.code) {
                    dst.code.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementCodeFilterComponent)) {
                return false;
            }
            DataRequirementCodeFilterComponent o = (DataRequirementCodeFilterComponent)other_;
            return DataRequirementCodeFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementCodeFilterComponent.compareDeep(this.searchParam, o.searchParam, true) && DataRequirementCodeFilterComponent.compareDeep(this.valueSet, o.valueSet, true) && DataRequirementCodeFilterComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DataRequirementCodeFilterComponent)) {
                return false;
            }
            DataRequirementCodeFilterComponent o = (DataRequirementCodeFilterComponent)other_;
            return DataRequirementCodeFilterComponent.compareValues(this.path, o.path, true) && DataRequirementCodeFilterComponent.compareValues(this.searchParam, o.searchParam, true) && DataRequirementCodeFilterComponent.compareValues(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.path, this.searchParam, this.valueSet, this.code});
        }

        @Override
        public String fhirType() {
            return "DataRequirement.codeFilter";
        }
    }

    public static class ValueFilterComparatorEnumFactory
    implements EnumFactory<ValueFilterComparator> {
        @Override
        public ValueFilterComparator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return ValueFilterComparator.EQ;
            }
            if ("gt".equals(codeString)) {
                return ValueFilterComparator.GT;
            }
            if ("lt".equals(codeString)) {
                return ValueFilterComparator.LT;
            }
            if ("ge".equals(codeString)) {
                return ValueFilterComparator.GE;
            }
            if ("le".equals(codeString)) {
                return ValueFilterComparator.LE;
            }
            if ("sa".equals(codeString)) {
                return ValueFilterComparator.SA;
            }
            if ("eb".equals(codeString)) {
                return ValueFilterComparator.EB;
            }
            throw new IllegalArgumentException("Unknown ValueFilterComparator code '" + codeString + "'");
        }

        public Enumeration<ValueFilterComparator> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.NULL, code);
            }
            if ("eq".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.EQ, code);
            }
            if ("gt".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.GT, code);
            }
            if ("lt".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.LT, code);
            }
            if ("ge".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.GE, code);
            }
            if ("le".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.LE, code);
            }
            if ("sa".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.SA, code);
            }
            if ("eb".equals(codeString)) {
                return new Enumeration<ValueFilterComparator>(this, ValueFilterComparator.EB, code);
            }
            throw new FHIRException("Unknown ValueFilterComparator code '" + codeString + "'");
        }

        @Override
        public String toCode(ValueFilterComparator code) {
            if (code == ValueFilterComparator.EQ) {
                return "eq";
            }
            if (code == ValueFilterComparator.GT) {
                return "gt";
            }
            if (code == ValueFilterComparator.LT) {
                return "lt";
            }
            if (code == ValueFilterComparator.GE) {
                return "ge";
            }
            if (code == ValueFilterComparator.LE) {
                return "le";
            }
            if (code == ValueFilterComparator.SA) {
                return "sa";
            }
            if (code == ValueFilterComparator.EB) {
                return "eb";
            }
            return "?";
        }

        @Override
        public String toSystem(ValueFilterComparator code) {
            return code.getSystem();
        }
    }

    public static enum ValueFilterComparator {
        EQ,
        GT,
        LT,
        GE,
        LE,
        SA,
        EB,
        NULL;


        public static ValueFilterComparator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return EQ;
            }
            if ("gt".equals(codeString)) {
                return GT;
            }
            if ("lt".equals(codeString)) {
                return LT;
            }
            if ("ge".equals(codeString)) {
                return GE;
            }
            if ("le".equals(codeString)) {
                return LE;
            }
            if ("sa".equals(codeString)) {
                return SA;
            }
            if ("eb".equals(codeString)) {
                return EB;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ValueFilterComparator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQ: {
                    return "eq";
                }
                case GT: {
                    return "gt";
                }
                case LT: {
                    return "lt";
                }
                case GE: {
                    return "ge";
                }
                case LE: {
                    return "le";
                }
                case SA: {
                    return "sa";
                }
                case EB: {
                    return "eb";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQ: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case GT: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case LT: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case GE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case LE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case SA: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case EB: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQ: {
                    return "the value for the parameter in the resource is equal to the provided value.";
                }
                case GT: {
                    return "the value for the parameter in the resource is greater than the provided value.";
                }
                case LT: {
                    return "the value for the parameter in the resource is less than the provided value.";
                }
                case GE: {
                    return "the value for the parameter in the resource is greater or equal to the provided value.";
                }
                case LE: {
                    return "the value for the parameter in the resource is less or equal to the provided value.";
                }
                case SA: {
                    return "the value for the parameter in the resource starts after the provided value.";
                }
                case EB: {
                    return "the value for the parameter in the resource ends before the provided value.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQ: {
                    return "Equals";
                }
                case GT: {
                    return "Greater Than";
                }
                case LT: {
                    return "Less Than";
                }
                case GE: {
                    return "Greater or Equals";
                }
                case LE: {
                    return "Less of Equal";
                }
                case SA: {
                    return "Starts After";
                }
                case EB: {
                    return "Ends Before";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SortDirectionEnumFactory
    implements EnumFactory<SortDirection> {
        @Override
        public SortDirection fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ascending".equals(codeString)) {
                return SortDirection.ASCENDING;
            }
            if ("descending".equals(codeString)) {
                return SortDirection.DESCENDING;
            }
            throw new IllegalArgumentException("Unknown SortDirection code '" + codeString + "'");
        }

        public Enumeration<SortDirection> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SortDirection>(this, SortDirection.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SortDirection>(this, SortDirection.NULL, code);
            }
            if ("ascending".equals(codeString)) {
                return new Enumeration<SortDirection>(this, SortDirection.ASCENDING, code);
            }
            if ("descending".equals(codeString)) {
                return new Enumeration<SortDirection>(this, SortDirection.DESCENDING, code);
            }
            throw new FHIRException("Unknown SortDirection code '" + codeString + "'");
        }

        @Override
        public String toCode(SortDirection code) {
            if (code == SortDirection.ASCENDING) {
                return "ascending";
            }
            if (code == SortDirection.DESCENDING) {
                return "descending";
            }
            return "?";
        }

        @Override
        public String toSystem(SortDirection code) {
            return code.getSystem();
        }
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING,
        NULL;


        public static SortDirection fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ascending".equals(codeString)) {
                return ASCENDING;
            }
            if ("descending".equals(codeString)) {
                return DESCENDING;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SortDirection code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ASCENDING: {
                    return "ascending";
                }
                case DESCENDING: {
                    return "descending";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ASCENDING: {
                    return "http://hl7.org/fhir/sort-direction";
                }
                case DESCENDING: {
                    return "http://hl7.org/fhir/sort-direction";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ASCENDING: {
                    return "Sort by the value ascending, so that lower values appear first.";
                }
                case DESCENDING: {
                    return "Sort by the value descending, so that lower values appear last.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ASCENDING: {
                    return "Ascending";
                }
                case DESCENDING: {
                    return "Descending";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

