/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EnrollmentResponse", profile="http://hl7.org/fhir/StructureDefinition/EnrollmentResponse")
public class EnrollmentResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<Enumerations.FinancialResourceStatusCodes> status;
    @Child(name="request", type={EnrollmentRequest.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Claim reference", formalDefinition="Original request resource reference.")
    protected Reference request;
    @Child(name="outcome", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="Processing status: error, complete.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/enrollment-outcome")
    protected Enumeration<EnrollmentOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="created", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="organization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference organization;
    @Child(name="requestProvider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    private static final long serialVersionUID = -1503790623L;
    @SearchParamDefinition(name="identifier", path="EnrollmentResponse.identifier", description="The business identifier of the EnrollmentResponse", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="EnrollmentResponse.request", description="The reference to the claim", type="reference", target={EnrollmentRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("EnrollmentResponse:request").toLocked();
    @SearchParamDefinition(name="status", path="EnrollmentResponse.status", description="The status of the enrollment response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EnrollmentResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EnrollmentResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.FinancialResourceStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EnrollmentResponse setStatusElement(Enumeration<Enumerations.FinancialResourceStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.FinancialResourceStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.FinancialResourceStatusCodes)((Object)this.status.getValue());
    }

    public EnrollmentResponse setStatus(Enumerations.FinancialResourceStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public EnrollmentResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Enumeration<EnrollmentOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<EnrollmentOutcome>(new EnrollmentOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public EnrollmentResponse setOutcomeElement(Enumeration<EnrollmentOutcome> value) {
        this.outcome = value;
        return this;
    }

    public EnrollmentOutcome getOutcome() {
        return this.outcome == null ? null : (EnrollmentOutcome)((Object)this.outcome.getValue());
    }

    public EnrollmentResponse setOutcome(EnrollmentOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<EnrollmentOutcome>(new EnrollmentOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public EnrollmentResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public EnrollmentResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EnrollmentResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EnrollmentResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public EnrollmentResponse setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public EnrollmentResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_REQUEST, "Reference(EnrollmentRequest)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property("outcome", "code", "Processing status: error, complete.", 0, 1, this.outcome));
        children.add(new Property("disposition", "string", "A description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created));
        children.add(new Property("organization", "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.organization));
        children.add(new Property("requestProvider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(EnrollmentRequest)", "Original request resource reference.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property("outcome", "code", "Processing status: error, complete.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property("disposition", "string", "A description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created);
            }
            case 1178922291: {
                return new Property("organization", "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.organization);
            }
            case 1601527200: {
                return new Property("requestProvider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.disposition;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.organization;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.requestProvider;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1095692943: {
                this.request = TypeConvertor.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new EnrollmentOutcomeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = TypeConvertor.castToString(value);
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1178922291: {
                this.organization = TypeConvertor.castToReference(value);
                return value;
            }
            case 1601527200: {
                this.requestProvider = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_REQUEST)) {
            this.request = TypeConvertor.castToReference(value);
        } else if (name.equals("outcome")) {
            value = new EnrollmentOutcomeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.outcome = value;
        } else if (name.equals("disposition")) {
            this.disposition = TypeConvertor.castToString(value);
        } else if (name.equals("created")) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals("organization")) {
            this.organization = TypeConvertor.castToReference(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1601527200: {
                return this.getRequestProvider();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1601527200: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property EnrollmentResponse.status");
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("outcome")) {
            throw new FHIRException("Cannot call addChild on a singleton property EnrollmentResponse.outcome");
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a singleton property EnrollmentResponse.disposition");
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a singleton property EnrollmentResponse.created");
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EnrollmentResponse";
    }

    @Override
    public EnrollmentResponse copy() {
        EnrollmentResponse dst = new EnrollmentResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EnrollmentResponse dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
    }

    protected EnrollmentResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EnrollmentResponse)) {
            return false;
        }
        EnrollmentResponse o = (EnrollmentResponse)other_;
        return EnrollmentResponse.compareDeep(this.identifier, o.identifier, true) && EnrollmentResponse.compareDeep(this.status, o.status, true) && EnrollmentResponse.compareDeep(this.request, o.request, true) && EnrollmentResponse.compareDeep(this.outcome, o.outcome, true) && EnrollmentResponse.compareDeep(this.disposition, o.disposition, true) && EnrollmentResponse.compareDeep(this.created, o.created, true) && EnrollmentResponse.compareDeep(this.organization, o.organization, true) && EnrollmentResponse.compareDeep(this.requestProvider, o.requestProvider, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EnrollmentResponse)) {
            return false;
        }
        EnrollmentResponse o = (EnrollmentResponse)other_;
        return EnrollmentResponse.compareValues(this.status, o.status, true) && EnrollmentResponse.compareValues(this.outcome, o.outcome, true) && EnrollmentResponse.compareValues(this.disposition, o.disposition, true) && EnrollmentResponse.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.request, this.outcome, this.disposition, this.created, this.organization, this.requestProvider});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EnrollmentResponse;
    }

    public static class EnrollmentOutcomeEnumFactory
    implements EnumFactory<EnrollmentOutcome> {
        @Override
        public EnrollmentOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return EnrollmentOutcome.QUEUED;
            }
            if ("complete".equals(codeString)) {
                return EnrollmentOutcome.COMPLETE;
            }
            if ("error".equals(codeString)) {
                return EnrollmentOutcome.ERROR;
            }
            if ("partial".equals(codeString)) {
                return EnrollmentOutcome.PARTIAL;
            }
            throw new IllegalArgumentException("Unknown EnrollmentOutcome code '" + codeString + "'");
        }

        public Enumeration<EnrollmentOutcome> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EnrollmentOutcome>(this, EnrollmentOutcome.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EnrollmentOutcome>(this, EnrollmentOutcome.NULL, code);
            }
            if ("queued".equals(codeString)) {
                return new Enumeration<EnrollmentOutcome>(this, EnrollmentOutcome.QUEUED, code);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<EnrollmentOutcome>(this, EnrollmentOutcome.COMPLETE, code);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<EnrollmentOutcome>(this, EnrollmentOutcome.ERROR, code);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<EnrollmentOutcome>(this, EnrollmentOutcome.PARTIAL, code);
            }
            throw new FHIRException("Unknown EnrollmentOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(EnrollmentOutcome code) {
            if (code == EnrollmentOutcome.QUEUED) {
                return "queued";
            }
            if (code == EnrollmentOutcome.COMPLETE) {
                return "complete";
            }
            if (code == EnrollmentOutcome.ERROR) {
                return "error";
            }
            if (code == EnrollmentOutcome.PARTIAL) {
                return "partial";
            }
            return "?";
        }

        @Override
        public String toSystem(EnrollmentOutcome code) {
            return code.getSystem();
        }
    }

    public static enum EnrollmentOutcome {
        QUEUED,
        COMPLETE,
        ERROR,
        PARTIAL,
        NULL;


        public static EnrollmentOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return QUEUED;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EnrollmentOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case QUEUED: {
                    return "queued";
                }
                case COMPLETE: {
                    return "complete";
                }
                case ERROR: {
                    return "error";
                }
                case PARTIAL: {
                    return "partial";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case QUEUED: {
                    return "http://hl7.org/fhir/enrollment-outcome";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/enrollment-outcome";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/enrollment-outcome";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/enrollment-outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case QUEUED: {
                    return "The Claim/Pre-authorization/Pre-determination has been received but processing has not begun.";
                }
                case COMPLETE: {
                    return "The processing has completed without errors";
                }
                case ERROR: {
                    return "One or more errors have been detected in the Claim";
                }
                case PARTIAL: {
                    return "No errors have been detected in the Claim and some of the adjudication has been performed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case QUEUED: {
                    return "Queued";
                }
                case COMPLETE: {
                    return "Processing Complete";
                }
                case ERROR: {
                    return "Error";
                }
                case PARTIAL: {
                    return "Partial Processing";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

