/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="EpisodeOfCare", profile="http://hl7.org/fhir/StructureDefinition/EpisodeOfCare")
public class EpisodeOfCare
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier(s) relevant for this EpisodeOfCare", formalDefinition="The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | waitlist | active | onhold | finished | cancelled | entered-in-error", formalDefinition="planned | waitlist | active | onhold | finished | cancelled.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status")
    protected Enumeration<EpisodeOfCareStatus> status;
    @Child(name="statusHistory", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Past list of status codes (the current status may be included to cover the start date of the status)", formalDefinition="The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).")
    protected List<EpisodeOfCareStatusHistoryComponent> statusHistory;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type/class  - e.g. specialist referral, disease management", formalDefinition="A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/episodeofcare-type")
    protected List<CodeableConcept> type;
    @Child(name="reason", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of medical reasons that are expected to be addressed during the episode of care", formalDefinition="The list of medical reasons that are expected to be addressed during the episode of care.")
    protected List<ReasonComponent> reason;
    @Child(name="diagnosis", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of medical conditions that were addressed during the episode of care", formalDefinition="The list of medical conditions that were addressed during the episode of care.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="patient", type={Patient.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient who is the focus of this episode of care", formalDefinition="The patient who is the focus of this episode of care.")
    protected Reference patient;
    @Child(name="managingOrganization", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that assumes responsibility for care coordination", formalDefinition="The organization that has assumed the specific responsibilities for care coordination, care delivery, or other services for the specified duration.")
    protected Reference managingOrganization;
    @Child(name="period", type={Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval during responsibility is assumed", formalDefinition="The interval during which the managing organization assumes the defined responsibility.")
    protected Period period;
    @Child(name="referralRequest", type={ServiceRequest.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Originating Referral Request(s)", formalDefinition="Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.")
    protected List<Reference> referralRequest;
    @Child(name="careManager", type={Practitioner.class, PractitionerRole.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Care manager/care coordinator for the patient", formalDefinition="The practitioner that is the care manager/care coordinator for this patient.")
    protected Reference careManager;
    @Child(name="careTeam", type={CareTeam.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other practitioners facilitating this episode of care", formalDefinition="The list of practitioners that may be facilitating this episode of care for specific purposes.")
    protected List<Reference> careTeam;
    @Child(name="account", type={Account.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of accounts that may be used for billing for this EpisodeOfCare", formalDefinition="The set of accounts that may be used for billing for this EpisodeOfCare.")
    protected List<Reference> account;
    private static final long serialVersionUID = 678200746L;
    @SearchParamDefinition(name="care-manager", path="EpisodeOfCare.careManager.where(resolve() is Practitioner)", description="Care manager/care coordinator for the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class})
    public static final String SP_CARE_MANAGER = "care-manager";
    public static final ReferenceClientParam CARE_MANAGER = new ReferenceClientParam("care-manager");
    public static final Include INCLUDE_CARE_MANAGER = new Include("EpisodeOfCare:care-manager").toLocked();
    @SearchParamDefinition(name="diagnosis-code", path="EpisodeOfCare.diagnosis.condition.concept", description="Conditions/problems/diagnoses this episode of care is for (coded)", type="token")
    public static final String SP_DIAGNOSIS_CODE = "diagnosis-code";
    public static final TokenClientParam DIAGNOSIS_CODE = new TokenClientParam("diagnosis-code");
    @SearchParamDefinition(name="diagnosis-reference", path="EpisodeOfCare.diagnosis.condition.reference", description="Conditions/problems/diagnoses this episode of care is for (resource reference)", type="reference", target={Condition.class})
    public static final String SP_DIAGNOSIS_REFERENCE = "diagnosis-reference";
    public static final ReferenceClientParam DIAGNOSIS_REFERENCE = new ReferenceClientParam("diagnosis-reference");
    public static final Include INCLUDE_DIAGNOSIS_REFERENCE = new Include("EpisodeOfCare:diagnosis-reference").toLocked();
    @SearchParamDefinition(name="incoming-referral", path="EpisodeOfCare.referralRequest", description="Incoming Referral Request", type="reference", target={ServiceRequest.class})
    public static final String SP_INCOMING_REFERRAL = "incoming-referral";
    public static final ReferenceClientParam INCOMING_REFERRAL = new ReferenceClientParam("incoming-referral");
    public static final Include INCLUDE_INCOMING_REFERRAL = new Include("EpisodeOfCare:incoming-referral").toLocked();
    @SearchParamDefinition(name="organization", path="EpisodeOfCare.managingOrganization", description="The organization that has assumed the specific responsibilities of this EpisodeOfCare", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("EpisodeOfCare:organization").toLocked();
    @SearchParamDefinition(name="reason-code", path="EpisodeOfCare.reason.value.concept", description="Reference to a concept (coded)", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="EpisodeOfCare.reason.value.reference", description="Reference to a resource (resource reference)", type="reference", target={Condition.class, HealthcareService.class, Observation.class, Procedure.class})
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("EpisodeOfCare:reason-reference").toLocked();
    @SearchParamDefinition(name="status", path="EpisodeOfCare.status", description="The current status of the Episode of Care as provided (does not check the status history collection)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EpisodeOfCare:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public EpisodeOfCare() {
    }

    public EpisodeOfCare(EpisodeOfCareStatus status, Reference patient) {
        this.setStatus(status);
        this.setPatient(patient);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EpisodeOfCare setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EpisodeOfCare addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EpisodeOfCareStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EpisodeOfCare setStatusElement(Enumeration<EpisodeOfCareStatus> value) {
        this.status = value;
        return this;
    }

    public EpisodeOfCareStatus getStatus() {
        return this.status == null ? null : (EpisodeOfCareStatus)((Object)this.status.getValue());
    }

    public EpisodeOfCare setStatus(EpisodeOfCareStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<EpisodeOfCareStatusHistoryComponent> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        return this.statusHistory;
    }

    public EpisodeOfCare setStatusHistory(List<EpisodeOfCareStatusHistoryComponent> theStatusHistory) {
        this.statusHistory = theStatusHistory;
        return this;
    }

    public boolean hasStatusHistory() {
        if (this.statusHistory == null) {
            return false;
        }
        for (EpisodeOfCareStatusHistoryComponent item : this.statusHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EpisodeOfCareStatusHistoryComponent addStatusHistory() {
        EpisodeOfCareStatusHistoryComponent t = new EpisodeOfCareStatusHistoryComponent();
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return t;
    }

    public EpisodeOfCare addStatusHistory(EpisodeOfCareStatusHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return this;
    }

    public EpisodeOfCareStatusHistoryComponent getStatusHistoryFirstRep() {
        if (this.getStatusHistory().isEmpty()) {
            this.addStatusHistory();
        }
        return this.getStatusHistory().get(0);
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public EpisodeOfCare setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public EpisodeOfCare addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<ReasonComponent> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<ReasonComponent>();
        }
        return this.reason;
    }

    public EpisodeOfCare setReason(List<ReasonComponent> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (ReasonComponent item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ReasonComponent addReason() {
        ReasonComponent t = new ReasonComponent();
        if (this.reason == null) {
            this.reason = new ArrayList<ReasonComponent>();
        }
        this.reason.add(t);
        return t;
    }

    public EpisodeOfCare addReason(ReasonComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<ReasonComponent>();
        }
        this.reason.add(t);
        return this;
    }

    public ReasonComponent getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public EpisodeOfCare setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public EpisodeOfCare addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public EpisodeOfCare setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public EpisodeOfCare setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public EpisodeOfCare setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getReferralRequest() {
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        return this.referralRequest;
    }

    public EpisodeOfCare setReferralRequest(List<Reference> theReferralRequest) {
        this.referralRequest = theReferralRequest;
        return this;
    }

    public boolean hasReferralRequest() {
        if (this.referralRequest == null) {
            return false;
        }
        for (Reference item : this.referralRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReferralRequest() {
        Reference t = new Reference();
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        this.referralRequest.add(t);
        return t;
    }

    public EpisodeOfCare addReferralRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        this.referralRequest.add(t);
        return this;
    }

    public Reference getReferralRequestFirstRep() {
        if (this.getReferralRequest().isEmpty()) {
            this.addReferralRequest();
        }
        return this.getReferralRequest().get(0);
    }

    public Reference getCareManager() {
        if (this.careManager == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.careManager");
            }
            if (Configuration.doAutoCreate()) {
                this.careManager = new Reference();
            }
        }
        return this.careManager;
    }

    public boolean hasCareManager() {
        return this.careManager != null && !this.careManager.isEmpty();
    }

    public EpisodeOfCare setCareManager(Reference value) {
        this.careManager = value;
        return this;
    }

    public List<Reference> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        return this.careTeam;
    }

    public EpisodeOfCare setCareTeam(List<Reference> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (Reference item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCareTeam() {
        Reference t = new Reference();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return t;
    }

    public EpisodeOfCare addCareTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return this;
    }

    public Reference getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public EpisodeOfCare setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public EpisodeOfCare addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status));
        children.add(new Property("statusHistory", "", "The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).", 0, Integer.MAX_VALUE, this.statusHistory));
        children.add(new Property(SP_TYPE, "CodeableConcept", "A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("reason", "", "The list of medical reasons that are expected to be addressed during the episode of care.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("diagnosis", "", "The list of medical conditions that were addressed during the episode of care.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who is the focus of this episode of care.", 0, 1, this.patient));
        children.add(new Property("managingOrganization", "Reference(Organization)", "The organization that has assumed the specific responsibilities for care coordination, care delivery, or other services for the specified duration.", 0, 1, this.managingOrganization));
        children.add(new Property("period", "Period", "The interval during which the managing organization assumes the defined responsibility.", 0, 1, this.period));
        children.add(new Property("referralRequest", "Reference(ServiceRequest)", "Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.", 0, Integer.MAX_VALUE, this.referralRequest));
        children.add(new Property("careManager", "Reference(Practitioner|PractitionerRole)", "The practitioner that is the care manager/care coordinator for this patient.", 0, 1, this.careManager));
        children.add(new Property("careTeam", "Reference(CareTeam)", "The list of practitioners that may be facilitating this episode of care for specific purposes.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("account", "Reference(Account)", "The set of accounts that may be used for billing for this EpisodeOfCare.", 0, Integer.MAX_VALUE, this.account));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status);
            }
            case -986695614: {
                return new Property("statusHistory", "", "The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).", 0, Integer.MAX_VALUE, this.statusHistory);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.", 0, Integer.MAX_VALUE, this.type);
            }
            case -934964668: {
                return new Property("reason", "", "The list of medical reasons that are expected to be addressed during the episode of care.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "The list of medical conditions that were addressed during the episode of care.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient who is the focus of this episode of care.", 0, 1, this.patient);
            }
            case -2058947787: {
                return new Property("managingOrganization", "Reference(Organization)", "The organization that has assumed the specific responsibilities for care coordination, care delivery, or other services for the specified duration.", 0, 1, this.managingOrganization);
            }
            case -991726143: {
                return new Property("period", "Period", "The interval during which the managing organization assumes the defined responsibility.", 0, 1, this.period);
            }
            case -310299598: {
                return new Property("referralRequest", "Reference(ServiceRequest)", "Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.", 0, Integer.MAX_VALUE, this.referralRequest);
            }
            case -1147746468: {
                return new Property("careManager", "Reference(Practitioner|PractitionerRole)", "The practitioner that is the care manager/care coordinator for this patient.", 0, 1, this.careManager);
            }
            case -7323378: {
                return new Property("careTeam", "Reference(CareTeam)", "The list of practitioners that may be facilitating this episode of care for specific purposes.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case -1177318867: {
                return new Property("account", "Reference(Account)", "The set of accounts that may be used for billing for this EpisodeOfCare.", 0, Integer.MAX_VALUE, this.account);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -986695614: {
                return this.statusHistory == null ? new Base[]{} : this.statusHistory.toArray(new Base[this.statusHistory.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case -310299598: {
                return this.referralRequest == null ? new Base[]{} : this.referralRequest.toArray(new Base[this.referralRequest.size()]);
            }
            case -1147746468: {
                Base[] baseArray;
                if (this.careManager == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.careManager;
                }
                return baseArray;
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -986695614: {
                this.getStatusHistory().add((EpisodeOfCareStatusHistoryComponent)((Object)value));
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -934964668: {
                this.getReason().add((ReasonComponent)((Object)value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case -2058947787: {
                this.managingOrganization = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -310299598: {
                this.getReferralRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1147746468: {
                this.careManager = TypeConvertor.castToReference(value);
                return value;
            }
            case -7323378: {
                this.getCareTeam().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusHistory")) {
            this.getStatusHistory().add((EpisodeOfCareStatusHistoryComponent)((Object)value));
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("reason")) {
            this.getReason().add((ReasonComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("referralRequest")) {
            this.getReferralRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("careManager")) {
            this.careManager = TypeConvertor.castToReference(value);
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add(TypeConvertor.castToReference(value));
        } else if (name.equals("account")) {
            this.getAccount().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -986695614: {
                return this.addStatusHistory();
            }
            case 3575610: {
                return this.addType();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -310299598: {
                return this.addReferralRequest();
            }
            case -1147746468: {
                return this.getCareManager();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case -1177318867: {
                return this.addAccount();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -986695614: {
                return new String[0];
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -934964668: {
                return new String[0];
            }
            case 1196993265: {
                return new String[0];
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -310299598: {
                return new String[]{"Reference"};
            }
            case -1147746468: {
                return new String[]{"Reference"};
            }
            case -7323378: {
                return new String[]{"Reference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property EpisodeOfCare.status");
        }
        if (name.equals("statusHistory")) {
            return this.addStatusHistory();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("referralRequest")) {
            return this.addReferralRequest();
        }
        if (name.equals("careManager")) {
            this.careManager = new Reference();
            return this.careManager;
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("account")) {
            return this.addAccount();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EpisodeOfCare";
    }

    @Override
    public EpisodeOfCare copy() {
        EpisodeOfCare dst = new EpisodeOfCare();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EpisodeOfCare dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EpisodeOfCareStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusHistory != null) {
            dst.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
            for (EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : this.statusHistory) {
                dst.statusHistory.add(episodeOfCareStatusHistoryComponent.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<ReasonComponent>();
            for (ReasonComponent reasonComponent : this.reason) {
                dst.reason.add(reasonComponent.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.referralRequest != null) {
            dst.referralRequest = new ArrayList<Reference>();
            for (Reference reference : this.referralRequest) {
                dst.referralRequest.add(reference.copy());
            }
        }
        Reference reference = dst.careManager = this.careManager == null ? null : this.careManager.copy();
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<Reference>();
            for (Reference reference2 : this.careTeam) {
                dst.careTeam.add(reference2.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference3 : this.account) {
                dst.account.add(reference3.copy());
            }
        }
    }

    protected EpisodeOfCare typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EpisodeOfCare)) {
            return false;
        }
        EpisodeOfCare o = (EpisodeOfCare)other_;
        return EpisodeOfCare.compareDeep(this.identifier, o.identifier, true) && EpisodeOfCare.compareDeep(this.status, o.status, true) && EpisodeOfCare.compareDeep(this.statusHistory, o.statusHistory, true) && EpisodeOfCare.compareDeep(this.type, o.type, true) && EpisodeOfCare.compareDeep(this.reason, o.reason, true) && EpisodeOfCare.compareDeep(this.diagnosis, o.diagnosis, true) && EpisodeOfCare.compareDeep(this.patient, o.patient, true) && EpisodeOfCare.compareDeep(this.managingOrganization, o.managingOrganization, true) && EpisodeOfCare.compareDeep(this.period, o.period, true) && EpisodeOfCare.compareDeep(this.referralRequest, o.referralRequest, true) && EpisodeOfCare.compareDeep(this.careManager, o.careManager, true) && EpisodeOfCare.compareDeep(this.careTeam, o.careTeam, true) && EpisodeOfCare.compareDeep(this.account, o.account, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EpisodeOfCare)) {
            return false;
        }
        EpisodeOfCare o = (EpisodeOfCare)other_;
        return EpisodeOfCare.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.statusHistory, this.type, this.reason, this.diagnosis, this.patient, this.managingOrganization, this.period, this.referralRequest, this.careManager, this.careTeam, this.account});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EpisodeOfCare;
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="condition", type={CodeableReference.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The medical condition that was addressed during the episode of care", formalDefinition="The medical condition that was addressed during the episode of care, expressed as a text, code or a reference to another resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected List<CodeableReference> condition;
        @Child(name="use", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026)", formalDefinition="Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diagnosis-use")
        protected CodeableConcept use;
        private static final long serialVersionUID = -1997962887L;

        public List<CodeableReference> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<CodeableReference>();
            }
            return this.condition;
        }

        public DiagnosisComponent setCondition(List<CodeableReference> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (CodeableReference item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addCondition() {
            CodeableReference t = new CodeableReference();
            if (this.condition == null) {
                this.condition = new ArrayList<CodeableReference>();
            }
            this.condition.add(t);
            return t;
        }

        public DiagnosisComponent addCondition(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<CodeableReference>();
            }
            this.condition.add(t);
            return this;
        }

        public CodeableReference getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public CodeableConcept getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new CodeableConcept();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public DiagnosisComponent setUse(CodeableConcept value) {
            this.use = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("condition", "CodeableReference(Condition)", "The medical condition that was addressed during the episode of care, expressed as a text, code or a reference to another resource.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("use", "CodeableConcept", "Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026).", 0, 1, this.use));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -861311717: {
                    return new Property("condition", "CodeableReference(Condition)", "The medical condition that was addressed during the episode of care, expressed as a text, code or a reference to another resource.", 0, Integer.MAX_VALUE, this.condition);
                }
                case 116103: {
                    return new Property("use", "CodeableConcept", "Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026).", 0, 1, this.use);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.use;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    this.getCondition().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 116103: {
                    this.use = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("condition")) {
                this.getCondition().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("use")) {
                this.use = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.addCondition();
                }
                case 116103: {
                    return this.getUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return new String[]{"CodeableReference"};
                }
                case 116103: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("use")) {
                this.use = new CodeableConcept();
                return this.use;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosisComponent dst) {
            super.copyValues(dst);
            if (this.condition != null) {
                dst.condition = new ArrayList<CodeableReference>();
                for (CodeableReference i : this.condition) {
                    dst.condition.add(i.copy());
                }
            }
            dst.use = this.use == null ? null : this.use.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.condition, o.condition, true) && DiagnosisComponent.compareDeep(this.use, o.use, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.condition, this.use});
        }

        @Override
        public String fhirType() {
            return "EpisodeOfCare.diagnosis";
        }
    }

    @Block
    public static class ReasonComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="use", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What the reason value should be used for/as", formalDefinition="What the reason value should be used as e.g. Chief Complaint, Health Concern, Health Maintenance (including screening).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason-use")
        protected CodeableConcept use;
        @Child(name="value", type={CodeableReference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Medical reason to be addressed", formalDefinition="The medical reason that is expected to be addressed during the episode of care, expressed as a text, code or a reference to another resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
        protected List<CodeableReference> value;
        private static final long serialVersionUID = 322767075L;

        public CodeableConcept getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReasonComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new CodeableConcept();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ReasonComponent setUse(CodeableConcept value) {
            this.use = value;
            return this;
        }

        public List<CodeableReference> getValue() {
            if (this.value == null) {
                this.value = new ArrayList<CodeableReference>();
            }
            return this.value;
        }

        public ReasonComponent setValue(List<CodeableReference> theValue) {
            this.value = theValue;
            return this;
        }

        public boolean hasValue() {
            if (this.value == null) {
                return false;
            }
            for (CodeableReference item : this.value) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addValue() {
            CodeableReference t = new CodeableReference();
            if (this.value == null) {
                this.value = new ArrayList<CodeableReference>();
            }
            this.value.add(t);
            return t;
        }

        public ReasonComponent addValue(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.value == null) {
                this.value = new ArrayList<CodeableReference>();
            }
            this.value.add(t);
            return this;
        }

        public CodeableReference getValueFirstRep() {
            if (this.getValue().isEmpty()) {
                this.addValue();
            }
            return this.getValue().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("use", "CodeableConcept", "What the reason value should be used as e.g. Chief Complaint, Health Concern, Health Maintenance (including screening).", 0, 1, this.use));
            children.add(new Property("value", "CodeableReference(Condition|Procedure|Observation|HealthcareService)", "The medical reason that is expected to be addressed during the episode of care, expressed as a text, code or a reference to another resource.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116103: {
                    return new Property("use", "CodeableConcept", "What the reason value should be used as e.g. Chief Complaint, Health Concern, Health Maintenance (including screening).", 0, 1, this.use);
                }
                case 111972721: {
                    return new Property("value", "CodeableReference(Condition|Procedure|Observation|HealthcareService)", "The medical reason that is expected to be addressed during the episode of care, expressed as a text, code or a reference to another resource.", 0, Integer.MAX_VALUE, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.use;
                    }
                    return baseArray;
                }
                case 111972721: {
                    return this.value == null ? new Base[]{} : this.value.toArray(new Base[this.value.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116103: {
                    this.use = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.getValue().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("use")) {
                this.use = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.getValue().add(TypeConvertor.castToCodeableReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return this.getUse();
                }
                case 111972721: {
                    return this.addValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("use")) {
                this.use = new CodeableConcept();
                return this.use;
            }
            if (name.equals("value")) {
                return this.addValue();
            }
            return super.addChild(name);
        }

        @Override
        public ReasonComponent copy() {
            ReasonComponent dst = new ReasonComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ReasonComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.use = this.use == null ? null : this.use.copy();
            if (this.value != null) {
                dst.value = new ArrayList<CodeableReference>();
                for (CodeableReference i : this.value) {
                    dst.value.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ReasonComponent)) {
                return false;
            }
            ReasonComponent o = (ReasonComponent)other_;
            return ReasonComponent.compareDeep(this.use, o.use, true) && ReasonComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ReasonComponent)) {
                return false;
            }
            ReasonComponent o = (ReasonComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.use, this.value});
        }

        @Override
        public String fhirType() {
            return "EpisodeOfCare.reason";
        }
    }

    @Block
    public static class EpisodeOfCareStatusHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | waitlist | active | onhold | finished | cancelled | entered-in-error", formalDefinition="planned | waitlist | active | onhold | finished | cancelled.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status")
        protected Enumeration<EpisodeOfCareStatus> status;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Duration the EpisodeOfCare was in the specified status", formalDefinition="The period during this EpisodeOfCare that the specific status applied.")
        protected Period period;
        private static final long serialVersionUID = -1192432864L;

        public EpisodeOfCareStatusHistoryComponent() {
        }

        public EpisodeOfCareStatusHistoryComponent(EpisodeOfCareStatus status, Period period) {
            this.setStatus(status);
            this.setPeriod(period);
        }

        public Enumeration<EpisodeOfCareStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EpisodeOfCareStatusHistoryComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EpisodeOfCareStatusHistoryComponent setStatusElement(Enumeration<EpisodeOfCareStatus> value) {
            this.status = value;
            return this;
        }

        public EpisodeOfCareStatus getStatus() {
            return this.status == null ? null : (EpisodeOfCareStatus)((Object)this.status.getValue());
        }

        public EpisodeOfCareStatusHistoryComponent setStatus(EpisodeOfCareStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EpisodeOfCareStatusHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EpisodeOfCareStatusHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EpisodeOfCare.SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status));
            children.add(new Property("period", "Period", "The period during this EpisodeOfCare that the specific status applied.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(EpisodeOfCare.SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period during this EpisodeOfCare that the specific status applied.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_STATUS)) {
                value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatusElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a singleton property EpisodeOfCare.statusHistory.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EpisodeOfCareStatusHistoryComponent copy() {
            EpisodeOfCareStatusHistoryComponent dst = new EpisodeOfCareStatusHistoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EpisodeOfCareStatusHistoryComponent dst) {
            super.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EpisodeOfCareStatusHistoryComponent)) {
                return false;
            }
            EpisodeOfCareStatusHistoryComponent o = (EpisodeOfCareStatusHistoryComponent)other_;
            return EpisodeOfCareStatusHistoryComponent.compareDeep(this.status, o.status, true) && EpisodeOfCareStatusHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EpisodeOfCareStatusHistoryComponent)) {
                return false;
            }
            EpisodeOfCareStatusHistoryComponent o = (EpisodeOfCareStatusHistoryComponent)other_;
            return EpisodeOfCareStatusHistoryComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.status, this.period});
        }

        @Override
        public String fhirType() {
            return "EpisodeOfCare.statusHistory";
        }
    }

    public static class EpisodeOfCareStatusEnumFactory
    implements EnumFactory<EpisodeOfCareStatus> {
        @Override
        public EpisodeOfCareStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EpisodeOfCareStatus.PLANNED;
            }
            if ("waitlist".equals(codeString)) {
                return EpisodeOfCareStatus.WAITLIST;
            }
            if ("active".equals(codeString)) {
                return EpisodeOfCareStatus.ACTIVE;
            }
            if ("onhold".equals(codeString)) {
                return EpisodeOfCareStatus.ONHOLD;
            }
            if ("finished".equals(codeString)) {
                return EpisodeOfCareStatus.FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return EpisodeOfCareStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return EpisodeOfCareStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        public Enumeration<EpisodeOfCareStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.NULL, code);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.PLANNED, code);
            }
            if ("waitlist".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.WAITLIST, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ACTIVE, code);
            }
            if ("onhold".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ONHOLD, code);
            }
            if ("finished".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.FINISHED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.CANCELLED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EpisodeOfCareStatus code) {
            if (code == EpisodeOfCareStatus.PLANNED) {
                return "planned";
            }
            if (code == EpisodeOfCareStatus.WAITLIST) {
                return "waitlist";
            }
            if (code == EpisodeOfCareStatus.ACTIVE) {
                return "active";
            }
            if (code == EpisodeOfCareStatus.ONHOLD) {
                return "onhold";
            }
            if (code == EpisodeOfCareStatus.FINISHED) {
                return "finished";
            }
            if (code == EpisodeOfCareStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EpisodeOfCareStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EpisodeOfCareStatus code) {
            return code.getSystem();
        }
    }

    public static enum EpisodeOfCareStatus {
        PLANNED,
        WAITLIST,
        ACTIVE,
        ONHOLD,
        FINISHED,
        CANCELLED,
        ENTEREDINERROR,
        NULL;


        public static EpisodeOfCareStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("waitlist".equals(codeString)) {
                return WAITLIST;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("onhold".equals(codeString)) {
                return ONHOLD;
            }
            if ("finished".equals(codeString)) {
                return FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case WAITLIST: {
                    return "waitlist";
                }
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "onhold";
                }
                case FINISHED: {
                    return "finished";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case WAITLIST: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case FINISHED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "This episode of care is planned to start at the date specified in the period.start. During this status, an organization may perform assessments to determine if the patient is eligible to receive services, or be organizing to make resources available to provide care services.";
                }
                case WAITLIST: {
                    return "This episode has been placed on a waitlist, pending the episode being made active (or cancelled).";
                }
                case ACTIVE: {
                    return "This episode of care is current.";
                }
                case ONHOLD: {
                    return "This episode of care is on hold; the organization has limited responsibility for the patient (such as while on respite).";
                }
                case FINISHED: {
                    return "This episode of care is finished and the organization is not expecting to be providing further care to the patient. Can also be known as \"closed\", \"completed\" or other similar terms.";
                }
                case CANCELLED: {
                    return "The episode of care was cancelled, or withdrawn from service, often selected during the planned stage as the patient may have gone elsewhere, or the circumstances have changed and the organization is unable to provide the care. It indicates that services terminated outside the planned/expected workflow.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case WAITLIST: {
                    return "Waitlist";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case FINISHED: {
                    return "Finished";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

