/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Evidence", profile="http://hl7.org/fhir/StructureDefinition/Evidence")
public class Evidence
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this evidence, represented as a globally unique URI", formalDefinition="An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the summary", formalDefinition="A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of this summary", formalDefinition="The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name for this summary (machine friendly)", formalDefinition="A natural language name identifying the evidence. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this summary (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the summary.")
    protected StringType title;
    @Child(name="citeAs", type={Citation.class, MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Citation for this evidence", formalDefinition="Citation Resource or display of suggested citation for this evidence.")
    protected DataType citeAs;
    @Child(name="status", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this summary. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this resource is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the summary was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the summary changes.")
    protected DateTimeType date;
    @Child(name="approvalDate", type={DateType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the summary was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the summary was last reviewed by the publisher", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="publisher", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the evidence.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="author", type={ContactDetail.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual, organization, or device primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individiual, organization, or device primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individiual, organization, or device primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individiual, organization, or device responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="useContext", type={UsageContext.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.")
    protected List<UsageContext> useContext;
    @Child(name="purpose", type={MarkdownType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this Evidence is defined", formalDefinition="Explanation of why this Evidence is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the Evidence and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the Evidence.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link or citation to artifact associated with the summary", formalDefinition="Link or citation to artifact associated with the summary.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="description", type={MarkdownType.class}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the particular summary", formalDefinition="A free text natural language description of the evidence from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="assertion", type={MarkdownType.class}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Declarative description of the Evidence", formalDefinition="Declarative description of the Evidence.")
    protected MarkdownType assertion;
    @Child(name="note", type={Annotation.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
    protected List<Annotation> note;
    @Child(name="variableDefinition", type={}, order=26, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Evidence variable such as population, exposure, or outcome", formalDefinition="Evidence variable such as population, exposure, or outcome.")
    protected List<EvidenceVariableDefinitionComponent> variableDefinition;
    @Child(name="synthesisType", type={CodeableConcept.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The method to combine studies", formalDefinition="The method to combine studies.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/synthesis-type")
    protected CodeableConcept synthesisType;
    @Child(name="studyDesign", type={CodeableConcept.class}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The design of the study that produced this evidence", formalDefinition="The design of the study that produced this evidence. The design is described with any number of study design characteristics.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/study-design")
    protected List<CodeableConcept> studyDesign;
    @Child(name="statistic", type={}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Values and parameters for a single statistic", formalDefinition="Values and parameters for a single statistic.")
    protected List<EvidenceStatisticComponent> statistic;
    @Child(name="certainty", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Certainty or quality of the evidence", formalDefinition="Assessment of certainty, confidence in the estimates, or quality of the evidence.")
    protected List<EvidenceCertaintyComponent> certainty;
    private static final long serialVersionUID = 1427750968L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value.ofType(Quantity)) | (ActivityDefinition.useContext.value.ofType(Range)) | (ActorDefinition.useContext.value.ofType(Quantity)) | (ActorDefinition.useContext.value.ofType(Range)) | (CapabilityStatement.useContext.value.ofType(Quantity)) | (CapabilityStatement.useContext.value.ofType(Range)) | (ChargeItemDefinition.useContext.value.ofType(Quantity)) | (ChargeItemDefinition.useContext.value.ofType(Range)) | (Citation.useContext.value.ofType(Quantity)) | (Citation.useContext.value.ofType(Range)) | (CodeSystem.useContext.value.ofType(Quantity)) | (CodeSystem.useContext.value.ofType(Range)) | (CompartmentDefinition.useContext.value.ofType(Quantity)) | (CompartmentDefinition.useContext.value.ofType(Range)) | (ConceptMap.useContext.value.ofType(Quantity)) | (ConceptMap.useContext.value.ofType(Range)) | (ConditionDefinition.useContext.value.ofType(Quantity)) | (ConditionDefinition.useContext.value.ofType(Range)) | (EventDefinition.useContext.value.ofType(Quantity)) | (EventDefinition.useContext.value.ofType(Range)) | (Evidence.useContext.value.ofType(Quantity)) | (Evidence.useContext.value.ofType(Range)) | (EvidenceReport.useContext.value.ofType(Quantity)) | (EvidenceReport.useContext.value.ofType(Range)) | (EvidenceVariable.useContext.value.ofType(Quantity)) | (EvidenceVariable.useContext.value.ofType(Range)) | (ExampleScenario.useContext.value.ofType(Quantity)) | (ExampleScenario.useContext.value.ofType(Range)) | (GraphDefinition.useContext.value.ofType(Quantity)) | (GraphDefinition.useContext.value.ofType(Range)) | (ImplementationGuide.useContext.value.ofType(Quantity)) | (ImplementationGuide.useContext.value.ofType(Range)) | (Library.useContext.value.ofType(Quantity)) | (Library.useContext.value.ofType(Range)) | (Measure.useContext.value.ofType(Quantity)) | (Measure.useContext.value.ofType(Range)) | (MessageDefinition.useContext.value.ofType(Quantity)) | (MessageDefinition.useContext.value.ofType(Range)) | (NamingSystem.useContext.value.ofType(Quantity)) | (NamingSystem.useContext.value.ofType(Range)) | (OperationDefinition.useContext.value.ofType(Quantity)) | (OperationDefinition.useContext.value.ofType(Range)) | (PlanDefinition.useContext.value.ofType(Quantity)) | (PlanDefinition.useContext.value.ofType(Range)) | (Questionnaire.useContext.value.ofType(Quantity)) | (Questionnaire.useContext.value.ofType(Range)) | (Requirements.useContext.value.ofType(Quantity)) | (Requirements.useContext.value.ofType(Range)) | (SearchParameter.useContext.value.ofType(Quantity)) | (SearchParameter.useContext.value.ofType(Range)) | (StructureDefinition.useContext.value.ofType(Quantity)) | (StructureDefinition.useContext.value.ofType(Range)) | (StructureMap.useContext.value.ofType(Quantity)) | (StructureMap.useContext.value.ofType(Range)) | (TerminologyCapabilities.useContext.value.ofType(Quantity)) | (TerminologyCapabilities.useContext.value.ofType(Range)) | (TestScript.useContext.value.ofType(Quantity)) | (TestScript.useContext.value.ofType(Range)) | (ValueSet.useContext.value.ofType(Quantity)) | (ValueSet.useContext.value.ofType(Range))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value.ofType(CodeableConcept)) | (ActorDefinition.useContext.value.ofType(CodeableConcept)) | (CapabilityStatement.useContext.value.ofType(CodeableConcept)) | (ChargeItemDefinition.useContext.value.ofType(CodeableConcept)) | (Citation.useContext.value.ofType(CodeableConcept)) | (CodeSystem.useContext.value.ofType(CodeableConcept)) | (CompartmentDefinition.useContext.value.ofType(CodeableConcept)) | (ConceptMap.useContext.value.ofType(CodeableConcept)) | (ConditionDefinition.useContext.value.ofType(CodeableConcept)) | (EventDefinition.useContext.value.ofType(CodeableConcept)) | (Evidence.useContext.value.ofType(CodeableConcept)) | (EvidenceReport.useContext.value.ofType(CodeableConcept)) | (EvidenceVariable.useContext.value.ofType(CodeableConcept)) | (ExampleScenario.useContext.value.ofType(CodeableConcept)) | (GraphDefinition.useContext.value.ofType(CodeableConcept)) | (ImplementationGuide.useContext.value.ofType(CodeableConcept)) | (Library.useContext.value.ofType(CodeableConcept)) | (Measure.useContext.value.ofType(CodeableConcept)) | (MessageDefinition.useContext.value.ofType(CodeableConcept)) | (NamingSystem.useContext.value.ofType(CodeableConcept)) | (OperationDefinition.useContext.value.ofType(CodeableConcept)) | (PlanDefinition.useContext.value.ofType(CodeableConcept)) | (Questionnaire.useContext.value.ofType(CodeableConcept)) | (Requirements.useContext.value.ofType(CodeableConcept)) | (SearchParameter.useContext.value.ofType(CodeableConcept)) | (StructureDefinition.useContext.value.ofType(CodeableConcept)) | (StructureMap.useContext.value.ofType(CodeableConcept)) | (TerminologyCapabilities.useContext.value.ofType(CodeableConcept)) | (TestScript.useContext.value.ofType(CodeableConcept)) | (ValueSet.useContext.value.ofType(CodeableConcept))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description | ActorDefinition.description | CapabilityStatement.description | ChargeItemDefinition.description | Citation.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | ConditionDefinition.description | EventDefinition.description | Evidence.description | EvidenceVariable.description | GraphDefinition.description | ImplementationGuide.description | Library.description | Measure.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | PlanDefinition.description | Questionnaire.description | Requirements.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | TestScript.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The description of the activity definition\r\n* [ActorDefinition](actordefinition.html): The description of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The description of the charge item definition\r\n* [Citation](citation.html): The description of the citation\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The description of the condition definition\r\n* [EventDefinition](eventdefinition.html): The description of the event definition\r\n* [Evidence](evidence.html): The description of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The description of the evidence variable\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [Library](library.html): The description of the library\r\n* [Measure](measure.html): The description of the measure\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [PlanDefinition](plandefinition.html): The description of the plan definition\r\n* [Questionnaire](questionnaire.html): The description of the questionnaire\r\n* [Requirements](requirements.html): The description of the requirements\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [TestScript](testscript.html): The description of the test script\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public Evidence() {
    }

    public Evidence(Enumerations.PublicationStatus status, EvidenceVariableDefinitionComponent variableDefinition) {
        this.setStatus(status);
        this.addVariableDefinition(variableDefinition);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Evidence setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Evidence setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public Evidence setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public Evidence addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Evidence setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Evidence setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this != null && this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this != null && this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public Evidence setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for Evidence.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public Evidence setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public Evidence setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Evidence setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Evidence setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public DataType getCiteAs() {
        return this.citeAs;
    }

    public Reference getCiteAsReference() throws FHIRException {
        if (this.citeAs == null) {
            this.citeAs = new Reference();
        }
        if (!(this.citeAs instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.citeAs.getClass().getName() + " was encountered");
        }
        return (Reference)this.citeAs;
    }

    public boolean hasCiteAsReference() {
        return this != null && this.citeAs instanceof Reference;
    }

    public MarkdownType getCiteAsMarkdownType() throws FHIRException {
        if (this.citeAs == null) {
            this.citeAs = new MarkdownType();
        }
        if (!(this.citeAs instanceof MarkdownType)) {
            throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.citeAs.getClass().getName() + " was encountered");
        }
        return (MarkdownType)this.citeAs;
    }

    public boolean hasCiteAsMarkdownType() {
        return this != null && this.citeAs instanceof MarkdownType;
    }

    public boolean hasCiteAs() {
        return this.citeAs != null && !this.citeAs.isEmpty();
    }

    public Evidence setCiteAs(DataType value) {
        if (value != null && !(value instanceof Reference) && !(value instanceof MarkdownType)) {
            throw new FHIRException("Not the right type for Evidence.citeAs[x]: " + value.fhirType());
        }
        this.citeAs = value;
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Evidence setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Evidence setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public Evidence setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public Evidence setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Evidence setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Evidence setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public Evidence setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public Evidence setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public Evidence setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public Evidence setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public Evidence setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public Evidence setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public Evidence setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public Evidence addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public Evidence setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public Evidence addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public Evidence setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public Evidence addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public Evidence setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public Evidence addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public Evidence setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public Evidence addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public Evidence setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Evidence addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public Evidence setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public Evidence setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public Evidence setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public Evidence setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public Evidence setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public Evidence setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public Evidence setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public Evidence addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Evidence setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Evidence setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public MarkdownType getAssertionElement() {
        if (this.assertion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.assertion");
            }
            if (Configuration.doAutoCreate()) {
                this.assertion = new MarkdownType();
            }
        }
        return this.assertion;
    }

    public boolean hasAssertionElement() {
        return this.assertion != null && !this.assertion.isEmpty();
    }

    public boolean hasAssertion() {
        return this.assertion != null && !this.assertion.isEmpty();
    }

    public Evidence setAssertionElement(MarkdownType value) {
        this.assertion = value;
        return this;
    }

    public String getAssertion() {
        return this.assertion == null ? null : (String)this.assertion.getValue();
    }

    public Evidence setAssertion(String value) {
        if (Utilities.noString((String)value)) {
            this.assertion = null;
        } else {
            if (this.assertion == null) {
                this.assertion = new MarkdownType();
            }
            this.assertion.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Evidence setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Evidence addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<EvidenceVariableDefinitionComponent> getVariableDefinition() {
        if (this.variableDefinition == null) {
            this.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
        }
        return this.variableDefinition;
    }

    public Evidence setVariableDefinition(List<EvidenceVariableDefinitionComponent> theVariableDefinition) {
        this.variableDefinition = theVariableDefinition;
        return this;
    }

    public boolean hasVariableDefinition() {
        if (this.variableDefinition == null) {
            return false;
        }
        for (EvidenceVariableDefinitionComponent item : this.variableDefinition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceVariableDefinitionComponent addVariableDefinition() {
        EvidenceVariableDefinitionComponent t = new EvidenceVariableDefinitionComponent();
        if (this.variableDefinition == null) {
            this.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
        }
        this.variableDefinition.add(t);
        return t;
    }

    public Evidence addVariableDefinition(EvidenceVariableDefinitionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.variableDefinition == null) {
            this.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
        }
        this.variableDefinition.add(t);
        return this;
    }

    public EvidenceVariableDefinitionComponent getVariableDefinitionFirstRep() {
        if (this.getVariableDefinition().isEmpty()) {
            this.addVariableDefinition();
        }
        return this.getVariableDefinition().get(0);
    }

    public CodeableConcept getSynthesisType() {
        if (this.synthesisType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Evidence.synthesisType");
            }
            if (Configuration.doAutoCreate()) {
                this.synthesisType = new CodeableConcept();
            }
        }
        return this.synthesisType;
    }

    public boolean hasSynthesisType() {
        return this.synthesisType != null && !this.synthesisType.isEmpty();
    }

    public Evidence setSynthesisType(CodeableConcept value) {
        this.synthesisType = value;
        return this;
    }

    public List<CodeableConcept> getStudyDesign() {
        if (this.studyDesign == null) {
            this.studyDesign = new ArrayList<CodeableConcept>();
        }
        return this.studyDesign;
    }

    public Evidence setStudyDesign(List<CodeableConcept> theStudyDesign) {
        this.studyDesign = theStudyDesign;
        return this;
    }

    public boolean hasStudyDesign() {
        if (this.studyDesign == null) {
            return false;
        }
        for (CodeableConcept item : this.studyDesign) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStudyDesign() {
        CodeableConcept t = new CodeableConcept();
        if (this.studyDesign == null) {
            this.studyDesign = new ArrayList<CodeableConcept>();
        }
        this.studyDesign.add(t);
        return t;
    }

    public Evidence addStudyDesign(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.studyDesign == null) {
            this.studyDesign = new ArrayList<CodeableConcept>();
        }
        this.studyDesign.add(t);
        return this;
    }

    public CodeableConcept getStudyDesignFirstRep() {
        if (this.getStudyDesign().isEmpty()) {
            this.addStudyDesign();
        }
        return this.getStudyDesign().get(0);
    }

    public List<EvidenceStatisticComponent> getStatistic() {
        if (this.statistic == null) {
            this.statistic = new ArrayList<EvidenceStatisticComponent>();
        }
        return this.statistic;
    }

    public Evidence setStatistic(List<EvidenceStatisticComponent> theStatistic) {
        this.statistic = theStatistic;
        return this;
    }

    public boolean hasStatistic() {
        if (this.statistic == null) {
            return false;
        }
        for (EvidenceStatisticComponent item : this.statistic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceStatisticComponent addStatistic() {
        EvidenceStatisticComponent t = new EvidenceStatisticComponent();
        if (this.statistic == null) {
            this.statistic = new ArrayList<EvidenceStatisticComponent>();
        }
        this.statistic.add(t);
        return t;
    }

    public Evidence addStatistic(EvidenceStatisticComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statistic == null) {
            this.statistic = new ArrayList<EvidenceStatisticComponent>();
        }
        this.statistic.add(t);
        return this;
    }

    public EvidenceStatisticComponent getStatisticFirstRep() {
        if (this.getStatistic().isEmpty()) {
            this.addStatistic();
        }
        return this.getStatistic().get(0);
    }

    public List<EvidenceCertaintyComponent> getCertainty() {
        if (this.certainty == null) {
            this.certainty = new ArrayList<EvidenceCertaintyComponent>();
        }
        return this.certainty;
    }

    public Evidence setCertainty(List<EvidenceCertaintyComponent> theCertainty) {
        this.certainty = theCertainty;
        return this;
    }

    public boolean hasCertainty() {
        if (this.certainty == null) {
            return false;
        }
        for (EvidenceCertaintyComponent item : this.certainty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceCertaintyComponent addCertainty() {
        EvidenceCertaintyComponent t = new EvidenceCertaintyComponent();
        if (this.certainty == null) {
            this.certainty = new ArrayList<EvidenceCertaintyComponent>();
        }
        this.certainty.add(t);
        return t;
    }

    public Evidence addCertainty(EvidenceCertaintyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.certainty == null) {
            this.certainty = new ArrayList<EvidenceCertaintyComponent>();
        }
        this.certainty.add(t);
        return this;
    }

    public EvidenceCertaintyComponent getCertaintyFirstRep() {
        if (this.getCertainty().isEmpty()) {
            this.addCertainty();
        }
        return this.getCertainty().get(0);
    }

    @Override
    public int getJurisdictionMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public Evidence setJurisdiction(List<CodeableConcept> theJurisdiction) {
        throw new Error("The resource type \"Evidence\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public boolean hasJurisdiction() {
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        throw new Error("The resource type \"Evidence\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public Evidence addJurisdiction(CodeableConcept t) {
        throw new Error("The resource type \"Evidence\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        throw new Error("The resource type \"Evidence\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"Evidence\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public Evidence setEffectivePeriod(Period value) {
        throw new Error("The resource type \"Evidence\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public int getTopicMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public Evidence setTopic(List<CodeableConcept> theTopic) {
        throw new Error("The resource type \"Evidence\" does not implement the property \"topic\"");
    }

    @Override
    public boolean hasTopic() {
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        throw new Error("The resource type \"Evidence\" does not implement the property \"topic\"");
    }

    @Override
    public Evidence addTopic(CodeableConcept t) {
        throw new Error("The resource type \"Evidence\" does not implement the property \"topic\"");
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        throw new Error("The resource type \"Evidence\" does not implement the property \"topic\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property("name", "string", "A natural language name identifying the evidence. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the summary.", 0, 1, this.title));
        children.add(new Property("citeAs[x]", "Reference(Citation)|markdown", "Citation Resource or display of suggested citation for this evidence.", 0, 1, this.citeAs));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this resource is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the summary was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the summary changes.", 0, 1, this.date));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the evidence.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("author", "ContactDetail", "An individiual, organization, or device primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individiual, organization, or device primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individiual, organization, or device primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individiual, organization, or device responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("purpose", "markdown", "Explanation of why this Evidence is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the Evidence and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the Evidence.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Link or citation to artifact associated with the summary.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("assertion", "markdown", "Declarative description of the Evidence.", 0, 1, this.assertion));
        children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("variableDefinition", "", "Evidence variable such as population, exposure, or outcome.", 0, Integer.MAX_VALUE, this.variableDefinition));
        children.add(new Property("synthesisType", "CodeableConcept", "The method to combine studies.", 0, 1, this.synthesisType));
        children.add(new Property("studyDesign", "CodeableConcept", "The design of the study that produced this evidence. The design is described with any number of study design characteristics.", 0, Integer.MAX_VALUE, this.studyDesign));
        children.add(new Property("statistic", "", "Values and parameters for a single statistic.", 0, Integer.MAX_VALUE, this.statistic));
        children.add(new Property("certainty", "", "Assessment of certainty, confidence in the estimates, or quality of the evidence.", 0, Integer.MAX_VALUE, this.certainty));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the evidence. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the summary.", 0, 1, this.title);
            }
            case -1706539017: {
                return new Property("citeAs[x]", "Reference(Citation)|markdown", "Citation Resource or display of suggested citation for this evidence.", 0, 1, this.citeAs);
            }
            case -1360156695: {
                return new Property("citeAs[x]", "Reference(Citation)|markdown", "Citation Resource or display of suggested citation for this evidence.", 0, 1, this.citeAs);
            }
            case 1269009762: {
                return new Property("citeAs[x]", "Reference(Citation)", "Citation Resource or display of suggested citation for this evidence.", 0, 1, this.citeAs);
            }
            case 456265720: {
                return new Property("citeAs[x]", "markdown", "Citation Resource or display of suggested citation for this evidence.", 0, 1, this.citeAs);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this resource is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the summary was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the summary changes.", 0, 1, this.date);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the evidence.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual, organization, or device primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individiual, organization, or device primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individiual, organization, or device primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individiual, organization, or device responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this Evidence is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the Evidence and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the Evidence.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Link or citation to artifact associated with the summary.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence from a consumer's perspective.", 0, 1, this.description);
            }
            case 1314395906: {
                return new Property("assertion", "markdown", "Declarative description of the Evidence.", 0, 1, this.assertion);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1807222545: {
                return new Property("variableDefinition", "", "Evidence variable such as population, exposure, or outcome.", 0, Integer.MAX_VALUE, this.variableDefinition);
            }
            case 672726254: {
                return new Property("synthesisType", "CodeableConcept", "The method to combine studies.", 0, 1, this.synthesisType);
            }
            case 1709211879: {
                return new Property("studyDesign", "CodeableConcept", "The design of the study that produced this evidence. The design is described with any number of study design characteristics.", 0, Integer.MAX_VALUE, this.studyDesign);
            }
            case -2081261232: {
                return new Property("statistic", "", "Values and parameters for a single statistic.", 0, Integer.MAX_VALUE, this.statistic);
            }
            case -1404142937: {
                return new Property("certainty", "", "Assessment of certainty, confidence in the estimates, or quality of the evidence.", 0, Integer.MAX_VALUE, this.certainty);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -1360156695: {
                Base[] baseArray;
                if (this.citeAs == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.citeAs;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.date;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.description;
                }
                return baseArray;
            }
            case 1314395906: {
                Base[] baseArray;
                if (this.assertion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.assertion;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1807222545: {
                return this.variableDefinition == null ? new Base[]{} : this.variableDefinition.toArray(new Base[this.variableDefinition.size()]);
            }
            case 672726254: {
                Base[] baseArray;
                if (this.synthesisType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.synthesisType;
                }
                return baseArray;
            }
            case 1709211879: {
                return this.studyDesign == null ? new Base[]{} : this.studyDesign.toArray(new Base[this.studyDesign.size()]);
            }
            case -2081261232: {
                return this.statistic == null ? new Base[]{} : this.statistic.toArray(new Base[this.statistic.size()]);
            }
            case -1404142937: {
                return this.certainty == null ? new Base[]{} : this.certainty.toArray(new Base[this.certainty.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -1360156695: {
                this.citeAs = TypeConvertor.castToType(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1314395906: {
                this.assertion = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1807222545: {
                this.getVariableDefinition().add((EvidenceVariableDefinitionComponent)((Object)value));
                return value;
            }
            case 672726254: {
                this.synthesisType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1709211879: {
                this.getStudyDesign().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -2081261232: {
                this.getStatistic().add((EvidenceStatisticComponent)((Object)value));
                return value;
            }
            case -1404142937: {
                this.getCertainty().add((EvidenceCertaintyComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("citeAs[x]")) {
            this.citeAs = TypeConvertor.castToType(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("assertion")) {
            this.assertion = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("variableDefinition")) {
            this.getVariableDefinition().add((EvidenceVariableDefinitionComponent)((Object)value));
        } else if (name.equals("synthesisType")) {
            this.synthesisType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("studyDesign")) {
            this.getStudyDesign().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("statistic")) {
            this.getStatistic().add((EvidenceStatisticComponent)((Object)value));
        } else if (name.equals("certainty")) {
            this.getCertainty().add((EvidenceCertaintyComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1706539017: {
                return this.getCiteAs();
            }
            case -1360156695: {
                return this.getCiteAs();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 1314395906: {
                return this.getAssertionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1807222545: {
                return this.addVariableDefinition();
            }
            case 672726254: {
                return this.getSynthesisType();
            }
            case 1709211879: {
                return this.addStudyDesign();
            }
            case -2081261232: {
                return this.addStatistic();
            }
            case -1404142937: {
                return this.addCertainty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1360156695: {
                return new String[]{"Reference", "markdown"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 1314395906: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1807222545: {
                return new String[0];
            }
            case 672726254: {
                return new String[]{"CodeableConcept"};
            }
            case 1709211879: {
                return new String[]{"CodeableConcept"};
            }
            case -2081261232: {
                return new String[0];
            }
            case -1404142937: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.title");
        }
        if (name.equals("citeAsReference")) {
            this.citeAs = new Reference();
            return this.citeAs;
        }
        if (name.equals("citeAsMarkdown")) {
            this.citeAs = new MarkdownType();
            return this.citeAs;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.date");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.lastReviewDate");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.copyrightLabel");
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.description");
        }
        if (name.equals("assertion")) {
            throw new FHIRException("Cannot call addChild on a singleton property Evidence.assertion");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("variableDefinition")) {
            return this.addVariableDefinition();
        }
        if (name.equals("synthesisType")) {
            this.synthesisType = new CodeableConcept();
            return this.synthesisType;
        }
        if (name.equals("studyDesign")) {
            return this.addStudyDesign();
        }
        if (name.equals("statistic")) {
            return this.addStatistic();
        }
        if (name.equals("certainty")) {
            return this.addCertainty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Evidence";
    }

    @Override
    public Evidence copy() {
        Evidence dst = new Evidence();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Evidence dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.citeAs = this.citeAs == null ? null : this.citeAs.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        StringType stringType2 = dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        MarkdownType markdownType = dst.assertion = this.assertion == null ? null : this.assertion.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.variableDefinition != null) {
            dst.variableDefinition = new ArrayList<EvidenceVariableDefinitionComponent>();
            for (EvidenceVariableDefinitionComponent evidenceVariableDefinitionComponent : this.variableDefinition) {
                dst.variableDefinition.add(evidenceVariableDefinitionComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.synthesisType = this.synthesisType == null ? null : this.synthesisType.copy();
        if (this.studyDesign != null) {
            dst.studyDesign = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.studyDesign) {
                dst.studyDesign.add(codeableConcept2.copy());
            }
        }
        if (this.statistic != null) {
            dst.statistic = new ArrayList<EvidenceStatisticComponent>();
            for (EvidenceStatisticComponent evidenceStatisticComponent : this.statistic) {
                dst.statistic.add(evidenceStatisticComponent.copy());
            }
        }
        if (this.certainty != null) {
            dst.certainty = new ArrayList<EvidenceCertaintyComponent>();
            for (EvidenceCertaintyComponent evidenceCertaintyComponent : this.certainty) {
                dst.certainty.add(evidenceCertaintyComponent.copy());
            }
        }
    }

    protected Evidence typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Evidence)) {
            return false;
        }
        Evidence o = (Evidence)other_;
        return Evidence.compareDeep(this.url, o.url, true) && Evidence.compareDeep(this.identifier, o.identifier, true) && Evidence.compareDeep(this.version, o.version, true) && Evidence.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && Evidence.compareDeep(this.name, o.name, true) && Evidence.compareDeep(this.title, o.title, true) && Evidence.compareDeep(this.citeAs, o.citeAs, true) && Evidence.compareDeep(this.status, o.status, true) && Evidence.compareDeep(this.experimental, o.experimental, true) && Evidence.compareDeep(this.date, o.date, true) && Evidence.compareDeep(this.approvalDate, o.approvalDate, true) && Evidence.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Evidence.compareDeep(this.publisher, o.publisher, true) && Evidence.compareDeep(this.contact, o.contact, true) && Evidence.compareDeep(this.author, o.author, true) && Evidence.compareDeep(this.editor, o.editor, true) && Evidence.compareDeep(this.reviewer, o.reviewer, true) && Evidence.compareDeep(this.endorser, o.endorser, true) && Evidence.compareDeep(this.useContext, o.useContext, true) && Evidence.compareDeep(this.purpose, o.purpose, true) && Evidence.compareDeep(this.copyright, o.copyright, true) && Evidence.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && Evidence.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && Evidence.compareDeep(this.description, o.description, true) && Evidence.compareDeep(this.assertion, o.assertion, true) && Evidence.compareDeep(this.note, o.note, true) && Evidence.compareDeep(this.variableDefinition, o.variableDefinition, true) && Evidence.compareDeep(this.synthesisType, o.synthesisType, true) && Evidence.compareDeep(this.studyDesign, o.studyDesign, true) && Evidence.compareDeep(this.statistic, o.statistic, true) && Evidence.compareDeep(this.certainty, o.certainty, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Evidence)) {
            return false;
        }
        Evidence o = (Evidence)other_;
        return Evidence.compareValues(this.url, o.url, true) && Evidence.compareValues(this.version, o.version, true) && Evidence.compareValues(this.name, o.name, true) && Evidence.compareValues(this.title, o.title, true) && Evidence.compareValues(this.status, o.status, true) && Evidence.compareValues(this.experimental, o.experimental, true) && Evidence.compareValues(this.date, o.date, true) && Evidence.compareValues(this.approvalDate, o.approvalDate, true) && Evidence.compareValues(this.lastReviewDate, o.lastReviewDate, true) && Evidence.compareValues(this.publisher, o.publisher, true) && Evidence.compareValues(this.purpose, o.purpose, true) && Evidence.compareValues(this.copyright, o.copyright, true) && Evidence.compareValues(this.copyrightLabel, o.copyrightLabel, true) && Evidence.compareValues(this.description, o.description, true) && Evidence.compareValues(this.assertion, o.assertion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.citeAs, this.status, this.experimental, this.date, this.approvalDate, this.lastReviewDate, this.publisher, this.contact, this.author, this.editor, this.reviewer, this.endorser, this.useContext, this.purpose, this.copyright, this.copyrightLabel, this.relatedArtifact, this.description, this.assertion, this.note, this.variableDefinition, this.synthesisType, this.studyDesign, this.statistic, this.certainty});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Evidence;
    }

    @Block
    public static class EvidenceCertaintyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of certainty", formalDefinition="Textual description of certainty.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        protected List<Annotation> note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Aspect of certainty being rated", formalDefinition="Aspect of certainty being rated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-type")
        protected CodeableConcept type;
        @Child(name="rating", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Assessment or judgement of the aspect", formalDefinition="Assessment or judgement of the aspect.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-rating")
        protected CodeableConcept rating;
        @Child(name="rater", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual or group who did the rating", formalDefinition="Individual or group who did the rating.")
        protected StringType rater;
        @Child(name="subcomponent", type={EvidenceCertaintyComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A domain or subdomain of certainty", formalDefinition="A domain or subdomain of certainty.")
        protected List<EvidenceCertaintyComponent> subcomponent;
        private static final long serialVersionUID = -139300414L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceCertaintyComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceCertaintyComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceCertaintyComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceCertaintyComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public EvidenceCertaintyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getRating() {
            if (this.rating == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyComponent.rating");
                }
                if (Configuration.doAutoCreate()) {
                    this.rating = new CodeableConcept();
                }
            }
            return this.rating;
        }

        public boolean hasRating() {
            return this.rating != null && !this.rating.isEmpty();
        }

        public EvidenceCertaintyComponent setRating(CodeableConcept value) {
            this.rating = value;
            return this;
        }

        public StringType getRaterElement() {
            if (this.rater == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceCertaintyComponent.rater");
                }
                if (Configuration.doAutoCreate()) {
                    this.rater = new StringType();
                }
            }
            return this.rater;
        }

        public boolean hasRaterElement() {
            return this.rater != null && !this.rater.isEmpty();
        }

        public boolean hasRater() {
            return this.rater != null && !this.rater.isEmpty();
        }

        public EvidenceCertaintyComponent setRaterElement(StringType value) {
            this.rater = value;
            return this;
        }

        public String getRater() {
            return this.rater == null ? null : (String)this.rater.getValue();
        }

        public EvidenceCertaintyComponent setRater(String value) {
            if (Utilities.noString((String)value)) {
                this.rater = null;
            } else {
                if (this.rater == null) {
                    this.rater = new StringType();
                }
                this.rater.setValue(value);
            }
            return this;
        }

        public List<EvidenceCertaintyComponent> getSubcomponent() {
            if (this.subcomponent == null) {
                this.subcomponent = new ArrayList<EvidenceCertaintyComponent>();
            }
            return this.subcomponent;
        }

        public EvidenceCertaintyComponent setSubcomponent(List<EvidenceCertaintyComponent> theSubcomponent) {
            this.subcomponent = theSubcomponent;
            return this;
        }

        public boolean hasSubcomponent() {
            if (this.subcomponent == null) {
                return false;
            }
            for (EvidenceCertaintyComponent item : this.subcomponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceCertaintyComponent addSubcomponent() {
            EvidenceCertaintyComponent t = new EvidenceCertaintyComponent();
            if (this.subcomponent == null) {
                this.subcomponent = new ArrayList<EvidenceCertaintyComponent>();
            }
            this.subcomponent.add(t);
            return t;
        }

        public EvidenceCertaintyComponent addSubcomponent(EvidenceCertaintyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subcomponent == null) {
                this.subcomponent = new ArrayList<EvidenceCertaintyComponent>();
            }
            this.subcomponent.add(t);
            return this;
        }

        public EvidenceCertaintyComponent getSubcomponentFirstRep() {
            if (this.getSubcomponent().isEmpty()) {
                this.addSubcomponent();
            }
            return this.getSubcomponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "Textual description of certainty.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("type", "CodeableConcept", "Aspect of certainty being rated.", 0, 1, this.type));
            children.add(new Property("rating", "CodeableConcept", "Assessment or judgement of the aspect.", 0, 1, this.rating));
            children.add(new Property("rater", "string", "Individual or group who did the rating.", 0, 1, this.rater));
            children.add(new Property("subcomponent", "@Evidence.certainty", "A domain or subdomain of certainty.", 0, Integer.MAX_VALUE, this.subcomponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "Textual description of certainty.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Aspect of certainty being rated.", 0, 1, this.type);
                }
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "Assessment or judgement of the aspect.", 0, 1, this.rating);
                }
                case 108285842: {
                    return new Property("rater", "string", "Individual or group who did the rating.", 0, 1, this.rater);
                }
                case -1308662083: {
                    return new Property("subcomponent", "@Evidence.certainty", "A domain or subdomain of certainty.", 0, Integer.MAX_VALUE, this.subcomponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -938102371: {
                    Base[] baseArray;
                    if (this.rating == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rating;
                    }
                    return baseArray;
                }
                case 108285842: {
                    Base[] baseArray;
                    if (this.rater == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.rater;
                    }
                    return baseArray;
                }
                case -1308662083: {
                    return this.subcomponent == null ? new Base[]{} : this.subcomponent.toArray(new Base[this.subcomponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -938102371: {
                    this.rating = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 108285842: {
                    this.rater = TypeConvertor.castToString(value);
                    return value;
                }
                case -1308662083: {
                    this.getSubcomponent().add((EvidenceCertaintyComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("rating")) {
                this.rating = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("rater")) {
                this.rater = TypeConvertor.castToString(value);
            } else if (name.equals("subcomponent")) {
                this.getSubcomponent().add((EvidenceCertaintyComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 3575610: {
                    return this.getType();
                }
                case -938102371: {
                    return this.getRating();
                }
                case 108285842: {
                    return this.getRaterElement();
                }
                case -1308662083: {
                    return this.addSubcomponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
                case 108285842: {
                    return new String[]{"string"};
                }
                case -1308662083: {
                    return new String[]{"@Evidence.certainty"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.certainty.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("rating")) {
                this.rating = new CodeableConcept();
                return this.rating;
            }
            if (name.equals("rater")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.certainty.rater");
            }
            if (name.equals("subcomponent")) {
                return this.addSubcomponent();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceCertaintyComponent copy() {
            EvidenceCertaintyComponent dst = new EvidenceCertaintyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceCertaintyComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.rating = this.rating == null ? null : this.rating.copy();
            StringType stringType = dst.rater = this.rater == null ? null : this.rater.copy();
            if (this.subcomponent != null) {
                dst.subcomponent = new ArrayList<EvidenceCertaintyComponent>();
                for (EvidenceCertaintyComponent evidenceCertaintyComponent : this.subcomponent) {
                    dst.subcomponent.add(evidenceCertaintyComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceCertaintyComponent)) {
                return false;
            }
            EvidenceCertaintyComponent o = (EvidenceCertaintyComponent)other_;
            return EvidenceCertaintyComponent.compareDeep(this.description, o.description, true) && EvidenceCertaintyComponent.compareDeep(this.note, o.note, true) && EvidenceCertaintyComponent.compareDeep(this.type, o.type, true) && EvidenceCertaintyComponent.compareDeep(this.rating, o.rating, true) && EvidenceCertaintyComponent.compareDeep(this.rater, o.rater, true) && EvidenceCertaintyComponent.compareDeep(this.subcomponent, o.subcomponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceCertaintyComponent)) {
                return false;
            }
            EvidenceCertaintyComponent o = (EvidenceCertaintyComponent)other_;
            return EvidenceCertaintyComponent.compareValues(this.description, o.description, true) && EvidenceCertaintyComponent.compareValues(this.rater, o.rater, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.rating, this.rater, this.subcomponent});
        }

        @Override
        public String fhirType() {
            return "Evidence.certainty";
        }
    }

    @Block
    public static class EvidenceStatisticModelCharacteristicVariableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="variableDefinition", type={Group.class, EvidenceVariable.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the variable", formalDefinition="Description of the variable.")
        protected Reference variableDefinition;
        @Child(name="handling", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="continuous | dichotomous | ordinal | polychotomous", formalDefinition="How the variable is classified for use in adjusted analysis.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-handling")
        protected Enumeration<Enumerations.EvidenceVariableHandling> handling;
        @Child(name="valueCategory", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Description for grouping of ordinal or polychotomous variables", formalDefinition="Description for grouping of ordinal or polychotomous variables.")
        protected List<CodeableConcept> valueCategory;
        @Child(name="valueQuantity", type={Quantity.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Discrete value for grouping of ordinal or polychotomous variables", formalDefinition="Discrete value for grouping of ordinal or polychotomous variables.")
        protected List<Quantity> valueQuantity;
        @Child(name="valueRange", type={Range.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Range of values for grouping of ordinal or polychotomous variables", formalDefinition="Range of values for grouping of ordinal or polychotomous variables.")
        protected List<Range> valueRange;
        private static final long serialVersionUID = 1516174900L;

        public EvidenceStatisticModelCharacteristicVariableComponent() {
        }

        public EvidenceStatisticModelCharacteristicVariableComponent(Reference variableDefinition) {
            this.setVariableDefinition(variableDefinition);
        }

        public Reference getVariableDefinition() {
            if (this.variableDefinition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticModelCharacteristicVariableComponent.variableDefinition");
                }
                if (Configuration.doAutoCreate()) {
                    this.variableDefinition = new Reference();
                }
            }
            return this.variableDefinition;
        }

        public boolean hasVariableDefinition() {
            return this.variableDefinition != null && !this.variableDefinition.isEmpty();
        }

        public EvidenceStatisticModelCharacteristicVariableComponent setVariableDefinition(Reference value) {
            this.variableDefinition = value;
            return this;
        }

        public Enumeration<Enumerations.EvidenceVariableHandling> getHandlingElement() {
            if (this.handling == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticModelCharacteristicVariableComponent.handling");
                }
                if (Configuration.doAutoCreate()) {
                    this.handling = new Enumeration<Enumerations.EvidenceVariableHandling>(new Enumerations.EvidenceVariableHandlingEnumFactory());
                }
            }
            return this.handling;
        }

        public boolean hasHandlingElement() {
            return this.handling != null && !this.handling.isEmpty();
        }

        public boolean hasHandling() {
            return this.handling != null && !this.handling.isEmpty();
        }

        public EvidenceStatisticModelCharacteristicVariableComponent setHandlingElement(Enumeration<Enumerations.EvidenceVariableHandling> value) {
            this.handling = value;
            return this;
        }

        public Enumerations.EvidenceVariableHandling getHandling() {
            return this.handling == null ? null : (Enumerations.EvidenceVariableHandling)((Object)this.handling.getValue());
        }

        public EvidenceStatisticModelCharacteristicVariableComponent setHandling(Enumerations.EvidenceVariableHandling value) {
            if (value == null) {
                this.handling = null;
            } else {
                if (this.handling == null) {
                    this.handling = new Enumeration<Enumerations.EvidenceVariableHandling>(new Enumerations.EvidenceVariableHandlingEnumFactory());
                }
                this.handling.setValue((Object)value);
            }
            return this;
        }

        public List<CodeableConcept> getValueCategory() {
            if (this.valueCategory == null) {
                this.valueCategory = new ArrayList<CodeableConcept>();
            }
            return this.valueCategory;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent setValueCategory(List<CodeableConcept> theValueCategory) {
            this.valueCategory = theValueCategory;
            return this;
        }

        public boolean hasValueCategory() {
            if (this.valueCategory == null) {
                return false;
            }
            for (CodeableConcept item : this.valueCategory) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addValueCategory() {
            CodeableConcept t = new CodeableConcept();
            if (this.valueCategory == null) {
                this.valueCategory = new ArrayList<CodeableConcept>();
            }
            this.valueCategory.add(t);
            return t;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent addValueCategory(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.valueCategory == null) {
                this.valueCategory = new ArrayList<CodeableConcept>();
            }
            this.valueCategory.add(t);
            return this;
        }

        public CodeableConcept getValueCategoryFirstRep() {
            if (this.getValueCategory().isEmpty()) {
                this.addValueCategory();
            }
            return this.getValueCategory().get(0);
        }

        public List<Quantity> getValueQuantity() {
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            return this.valueQuantity;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent setValueQuantity(List<Quantity> theValueQuantity) {
            this.valueQuantity = theValueQuantity;
            return this;
        }

        public boolean hasValueQuantity() {
            if (this.valueQuantity == null) {
                return false;
            }
            for (Quantity item : this.valueQuantity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addValueQuantity() {
            Quantity t = new Quantity();
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return t;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent addValueQuantity(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return this;
        }

        public Quantity getValueQuantityFirstRep() {
            if (this.getValueQuantity().isEmpty()) {
                this.addValueQuantity();
            }
            return this.getValueQuantity().get(0);
        }

        public List<Range> getValueRange() {
            if (this.valueRange == null) {
                this.valueRange = new ArrayList<Range>();
            }
            return this.valueRange;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent setValueRange(List<Range> theValueRange) {
            this.valueRange = theValueRange;
            return this;
        }

        public boolean hasValueRange() {
            if (this.valueRange == null) {
                return false;
            }
            for (Range item : this.valueRange) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Range addValueRange() {
            Range t = new Range();
            if (this.valueRange == null) {
                this.valueRange = new ArrayList<Range>();
            }
            this.valueRange.add(t);
            return t;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent addValueRange(Range t) {
            if (t == null) {
                return this;
            }
            if (this.valueRange == null) {
                this.valueRange = new ArrayList<Range>();
            }
            this.valueRange.add(t);
            return this;
        }

        public Range getValueRangeFirstRep() {
            if (this.getValueRange().isEmpty()) {
                this.addValueRange();
            }
            return this.getValueRange().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("variableDefinition", "Reference(Group|EvidenceVariable)", "Description of the variable.", 0, 1, this.variableDefinition));
            children.add(new Property("handling", "code", "How the variable is classified for use in adjusted analysis.", 0, 1, this.handling));
            children.add(new Property("valueCategory", "CodeableConcept", "Description for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueCategory));
            children.add(new Property("valueQuantity", "Quantity", "Discrete value for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueQuantity));
            children.add(new Property("valueRange", "Range", "Range of values for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueRange));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1807222545: {
                    return new Property("variableDefinition", "Reference(Group|EvidenceVariable)", "Description of the variable.", 0, 1, this.variableDefinition);
                }
                case 2072805: {
                    return new Property("handling", "code", "How the variable is classified for use in adjusted analysis.", 0, 1, this.handling);
                }
                case -694308465: {
                    return new Property("valueCategory", "CodeableConcept", "Description for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueCategory);
                }
                case -2029823716: {
                    return new Property("valueQuantity", "Quantity", "Discrete value for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueQuantity);
                }
                case 2030761548: {
                    return new Property("valueRange", "Range", "Range of values for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueRange);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    Base[] baseArray;
                    if (this.variableDefinition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.variableDefinition;
                    }
                    return baseArray;
                }
                case 2072805: {
                    Base[] baseArray;
                    if (this.handling == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.handling;
                    }
                    return baseArray;
                }
                case -694308465: {
                    return this.valueCategory == null ? new Base[]{} : this.valueCategory.toArray(new Base[this.valueCategory.size()]);
                }
                case -2029823716: {
                    return this.valueQuantity == null ? new Base[]{} : this.valueQuantity.toArray(new Base[this.valueQuantity.size()]);
                }
                case 2030761548: {
                    return this.valueRange == null ? new Base[]{} : this.valueRange.toArray(new Base[this.valueRange.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    this.variableDefinition = TypeConvertor.castToReference(value);
                    return value;
                }
                case 2072805: {
                    value = new Enumerations.EvidenceVariableHandlingEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.handling = value;
                    return value;
                }
                case -694308465: {
                    this.getValueCategory().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -2029823716: {
                    this.getValueQuantity().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
                case 2030761548: {
                    this.getValueRange().add(TypeConvertor.castToRange(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("variableDefinition")) {
                this.variableDefinition = TypeConvertor.castToReference(value);
            } else if (name.equals("handling")) {
                value = new Enumerations.EvidenceVariableHandlingEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.handling = value;
            } else if (name.equals("valueCategory")) {
                this.getValueCategory().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("valueQuantity")) {
                this.getValueQuantity().add(TypeConvertor.castToQuantity(value));
            } else if (name.equals("valueRange")) {
                this.getValueRange().add(TypeConvertor.castToRange(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    return this.getVariableDefinition();
                }
                case 2072805: {
                    return this.getHandlingElement();
                }
                case -694308465: {
                    return this.addValueCategory();
                }
                case -2029823716: {
                    return this.addValueQuantity();
                }
                case 2030761548: {
                    return this.addValueRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    return new String[]{"Reference"};
                }
                case 2072805: {
                    return new String[]{"code"};
                }
                case -694308465: {
                    return new String[]{"CodeableConcept"};
                }
                case -2029823716: {
                    return new String[]{"Quantity"};
                }
                case 2030761548: {
                    return new String[]{"Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("variableDefinition")) {
                this.variableDefinition = new Reference();
                return this.variableDefinition;
            }
            if (name.equals("handling")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.modelCharacteristic.variable.handling");
            }
            if (name.equals("valueCategory")) {
                return this.addValueCategory();
            }
            if (name.equals("valueQuantity")) {
                return this.addValueQuantity();
            }
            if (name.equals("valueRange")) {
                return this.addValueRange();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceStatisticModelCharacteristicVariableComponent copy() {
            EvidenceStatisticModelCharacteristicVariableComponent dst = new EvidenceStatisticModelCharacteristicVariableComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceStatisticModelCharacteristicVariableComponent dst) {
            super.copyValues(dst);
            dst.variableDefinition = this.variableDefinition == null ? null : this.variableDefinition.copy();
            Enumeration<Enumerations.EvidenceVariableHandling> enumeration = dst.handling = this.handling == null ? null : this.handling.copy();
            if (this.valueCategory != null) {
                dst.valueCategory = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.valueCategory) {
                    dst.valueCategory.add(codeableConcept.copy());
                }
            }
            if (this.valueQuantity != null) {
                dst.valueQuantity = new ArrayList<Quantity>();
                for (Quantity quantity : this.valueQuantity) {
                    dst.valueQuantity.add(quantity.copy());
                }
            }
            if (this.valueRange != null) {
                dst.valueRange = new ArrayList<Range>();
                for (Range range : this.valueRange) {
                    dst.valueRange.add(range.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticModelCharacteristicVariableComponent)) {
                return false;
            }
            EvidenceStatisticModelCharacteristicVariableComponent o = (EvidenceStatisticModelCharacteristicVariableComponent)other_;
            return EvidenceStatisticModelCharacteristicVariableComponent.compareDeep(this.variableDefinition, o.variableDefinition, true) && EvidenceStatisticModelCharacteristicVariableComponent.compareDeep(this.handling, o.handling, true) && EvidenceStatisticModelCharacteristicVariableComponent.compareDeep(this.valueCategory, o.valueCategory, true) && EvidenceStatisticModelCharacteristicVariableComponent.compareDeep(this.valueQuantity, o.valueQuantity, true) && EvidenceStatisticModelCharacteristicVariableComponent.compareDeep(this.valueRange, o.valueRange, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticModelCharacteristicVariableComponent)) {
                return false;
            }
            EvidenceStatisticModelCharacteristicVariableComponent o = (EvidenceStatisticModelCharacteristicVariableComponent)other_;
            return EvidenceStatisticModelCharacteristicVariableComponent.compareValues(this.handling, o.handling, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.variableDefinition, this.handling, this.valueCategory, this.valueQuantity, this.valueRange});
        }

        @Override
        public String fhirType() {
            return "Evidence.statistic.modelCharacteristic.variable";
        }
    }

    @Block
    public static class EvidenceStatisticModelCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Model specification", formalDefinition="Description of a component of the method to generate the statistic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/statistic-model-code")
        protected CodeableConcept code;
        @Child(name="value", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Numerical value to complete model specification", formalDefinition="Further specification of the quantified value of the component of the method to generate the statistic.")
        protected Quantity value;
        @Child(name="variable", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A variable adjusted for in the adjusted analysis", formalDefinition="A variable adjusted for in the adjusted analysis.")
        protected List<EvidenceStatisticModelCharacteristicVariableComponent> variable;
        @Child(name="attributeEstimate", type={EvidenceStatisticAttributeEstimateComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An attribute of the statistic used as a model characteristic", formalDefinition="An attribute of the statistic used as a model characteristic.")
        protected List<EvidenceStatisticAttributeEstimateComponent> attributeEstimate;
        private static final long serialVersionUID = 1787793468L;

        public EvidenceStatisticModelCharacteristicComponent() {
        }

        public EvidenceStatisticModelCharacteristicComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticModelCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public EvidenceStatisticModelCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticModelCharacteristicComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public EvidenceStatisticModelCharacteristicComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        public List<EvidenceStatisticModelCharacteristicVariableComponent> getVariable() {
            if (this.variable == null) {
                this.variable = new ArrayList<EvidenceStatisticModelCharacteristicVariableComponent>();
            }
            return this.variable;
        }

        public EvidenceStatisticModelCharacteristicComponent setVariable(List<EvidenceStatisticModelCharacteristicVariableComponent> theVariable) {
            this.variable = theVariable;
            return this;
        }

        public boolean hasVariable() {
            if (this.variable == null) {
                return false;
            }
            for (EvidenceStatisticModelCharacteristicVariableComponent item : this.variable) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent addVariable() {
            EvidenceStatisticModelCharacteristicVariableComponent t = new EvidenceStatisticModelCharacteristicVariableComponent();
            if (this.variable == null) {
                this.variable = new ArrayList<EvidenceStatisticModelCharacteristicVariableComponent>();
            }
            this.variable.add(t);
            return t;
        }

        public EvidenceStatisticModelCharacteristicComponent addVariable(EvidenceStatisticModelCharacteristicVariableComponent t) {
            if (t == null) {
                return this;
            }
            if (this.variable == null) {
                this.variable = new ArrayList<EvidenceStatisticModelCharacteristicVariableComponent>();
            }
            this.variable.add(t);
            return this;
        }

        public EvidenceStatisticModelCharacteristicVariableComponent getVariableFirstRep() {
            if (this.getVariable().isEmpty()) {
                this.addVariable();
            }
            return this.getVariable().get(0);
        }

        public List<EvidenceStatisticAttributeEstimateComponent> getAttributeEstimate() {
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            return this.attributeEstimate;
        }

        public EvidenceStatisticModelCharacteristicComponent setAttributeEstimate(List<EvidenceStatisticAttributeEstimateComponent> theAttributeEstimate) {
            this.attributeEstimate = theAttributeEstimate;
            return this;
        }

        public boolean hasAttributeEstimate() {
            if (this.attributeEstimate == null) {
                return false;
            }
            for (EvidenceStatisticAttributeEstimateComponent item : this.attributeEstimate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceStatisticAttributeEstimateComponent addAttributeEstimate() {
            EvidenceStatisticAttributeEstimateComponent t = new EvidenceStatisticAttributeEstimateComponent();
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return t;
        }

        public EvidenceStatisticModelCharacteristicComponent addAttributeEstimate(EvidenceStatisticAttributeEstimateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return this;
        }

        public EvidenceStatisticAttributeEstimateComponent getAttributeEstimateFirstRep() {
            if (this.getAttributeEstimate().isEmpty()) {
                this.addAttributeEstimate();
            }
            return this.getAttributeEstimate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Description of a component of the method to generate the statistic.", 0, 1, this.code));
            children.add(new Property("value", "Quantity", "Further specification of the quantified value of the component of the method to generate the statistic.", 0, 1, this.value));
            children.add(new Property("variable", "", "A variable adjusted for in the adjusted analysis.", 0, Integer.MAX_VALUE, this.variable));
            children.add(new Property("attributeEstimate", "@Evidence.statistic.attributeEstimate", "An attribute of the statistic used as a model characteristic.", 0, Integer.MAX_VALUE, this.attributeEstimate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Description of a component of the method to generate the statistic.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "Quantity", "Further specification of the quantified value of the component of the method to generate the statistic.", 0, 1, this.value);
                }
                case -1249586564: {
                    return new Property("variable", "", "A variable adjusted for in the adjusted analysis.", 0, Integer.MAX_VALUE, this.variable);
                }
                case -1539581980: {
                    return new Property("attributeEstimate", "@Evidence.statistic.attributeEstimate", "An attribute of the statistic used as a model characteristic.", 0, Integer.MAX_VALUE, this.attributeEstimate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    return this.variable == null ? new Base[]{} : this.variable.toArray(new Base[this.variable.size()]);
                }
                case -1539581980: {
                    return this.attributeEstimate == null ? new Base[]{} : this.attributeEstimate.toArray(new Base[this.attributeEstimate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1249586564: {
                    this.getVariable().add((EvidenceStatisticModelCharacteristicVariableComponent)value);
                    return value;
                }
                case -1539581980: {
                    this.getAttributeEstimate().add((EvidenceStatisticAttributeEstimateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToQuantity(value);
            } else if (name.equals("variable")) {
                this.getVariable().add((EvidenceStatisticModelCharacteristicVariableComponent)value);
            } else if (name.equals("attributeEstimate")) {
                this.getAttributeEstimate().add((EvidenceStatisticAttributeEstimateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1249586564: {
                    return this.addVariable();
                }
                case -1539581980: {
                    return this.addAttributeEstimate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity"};
                }
                case -1249586564: {
                    return new String[0];
                }
                case -1539581980: {
                    return new String[]{"@Evidence.statistic.attributeEstimate"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("variable")) {
                return this.addVariable();
            }
            if (name.equals("attributeEstimate")) {
                return this.addAttributeEstimate();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceStatisticModelCharacteristicComponent copy() {
            EvidenceStatisticModelCharacteristicComponent dst = new EvidenceStatisticModelCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceStatisticModelCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            Quantity quantity = dst.value = this.value == null ? null : this.value.copy();
            if (this.variable != null) {
                dst.variable = new ArrayList<EvidenceStatisticModelCharacteristicVariableComponent>();
                for (EvidenceStatisticModelCharacteristicVariableComponent evidenceStatisticModelCharacteristicVariableComponent : this.variable) {
                    dst.variable.add(evidenceStatisticModelCharacteristicVariableComponent.copy());
                }
            }
            if (this.attributeEstimate != null) {
                dst.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
                for (EvidenceStatisticAttributeEstimateComponent evidenceStatisticAttributeEstimateComponent : this.attributeEstimate) {
                    dst.attributeEstimate.add(evidenceStatisticAttributeEstimateComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticModelCharacteristicComponent)) {
                return false;
            }
            EvidenceStatisticModelCharacteristicComponent o = (EvidenceStatisticModelCharacteristicComponent)other_;
            return EvidenceStatisticModelCharacteristicComponent.compareDeep(this.code, o.code, true) && EvidenceStatisticModelCharacteristicComponent.compareDeep(this.value, o.value, true) && EvidenceStatisticModelCharacteristicComponent.compareDeep(this.variable, o.variable, true) && EvidenceStatisticModelCharacteristicComponent.compareDeep(this.attributeEstimate, o.attributeEstimate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticModelCharacteristicComponent)) {
                return false;
            }
            EvidenceStatisticModelCharacteristicComponent o = (EvidenceStatisticModelCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.value, this.variable, this.attributeEstimate});
        }

        @Override
        public String fhirType() {
            return "Evidence.statistic.modelCharacteristic";
        }
    }

    @Block
    public static class EvidenceStatisticAttributeEstimateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of the attribute estimate", formalDefinition="Human-readable summary of the estimate.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnote or explanatory note about the estimate", formalDefinition="Footnote or explanatory note about the estimate.")
        protected List<Annotation> note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of attribute estimate, e.g., confidence interval or p value", formalDefinition="The type of attribute estimate, e.g., confidence interval or p value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/attribute-estimate-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure", formalDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.")
        protected Quantity quantity;
        @Child(name="level", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Level of confidence interval, e.g., 0.95 for 95% confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="range", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Lower and upper bound values of the attribute estimate", formalDefinition="Lower bound of confidence interval.")
        protected Range range;
        @Child(name="attributeEstimate", type={EvidenceStatisticAttributeEstimateComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A nested attribute estimate; which is the attribute estimate of an attribute estimate", formalDefinition="A nested attribute estimate; which is the attribute estimate of an attribute estimate.")
        protected List<EvidenceStatisticAttributeEstimateComponent> attributeEstimate;
        private static final long serialVersionUID = -1535970380L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticAttributeEstimateComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceStatisticAttributeEstimateComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceStatisticAttributeEstimateComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceStatisticAttributeEstimateComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceStatisticAttributeEstimateComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticAttributeEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public EvidenceStatisticAttributeEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticAttributeEstimateComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public EvidenceStatisticAttributeEstimateComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticAttributeEstimateComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public EvidenceStatisticAttributeEstimateComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public EvidenceStatisticAttributeEstimateComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public EvidenceStatisticAttributeEstimateComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public EvidenceStatisticAttributeEstimateComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticAttributeEstimateComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public EvidenceStatisticAttributeEstimateComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        public List<EvidenceStatisticAttributeEstimateComponent> getAttributeEstimate() {
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            return this.attributeEstimate;
        }

        public EvidenceStatisticAttributeEstimateComponent setAttributeEstimate(List<EvidenceStatisticAttributeEstimateComponent> theAttributeEstimate) {
            this.attributeEstimate = theAttributeEstimate;
            return this;
        }

        public boolean hasAttributeEstimate() {
            if (this.attributeEstimate == null) {
                return false;
            }
            for (EvidenceStatisticAttributeEstimateComponent item : this.attributeEstimate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceStatisticAttributeEstimateComponent addAttributeEstimate() {
            EvidenceStatisticAttributeEstimateComponent t = new EvidenceStatisticAttributeEstimateComponent();
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return t;
        }

        public EvidenceStatisticAttributeEstimateComponent addAttributeEstimate(EvidenceStatisticAttributeEstimateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return this;
        }

        public EvidenceStatisticAttributeEstimateComponent getAttributeEstimateFirstRep() {
            if (this.getAttributeEstimate().isEmpty()) {
                this.addAttributeEstimate();
            }
            return this.getAttributeEstimate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "Human-readable summary of the estimate.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("type", "CodeableConcept", "The type of attribute estimate, e.g., confidence interval or p value.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range));
            children.add(new Property("attributeEstimate", "@Evidence.statistic.attributeEstimate", "A nested attribute estimate; which is the attribute estimate of an attribute estimate.", 0, Integer.MAX_VALUE, this.attributeEstimate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "Human-readable summary of the estimate.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of attribute estimate, e.g., confidence interval or p value.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 108280125: {
                    return new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range);
                }
                case -1539581980: {
                    return new Property("attributeEstimate", "@Evidence.statistic.attributeEstimate", "A nested attribute estimate; which is the attribute estimate of an attribute estimate.", 0, Integer.MAX_VALUE, this.attributeEstimate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.level;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.range;
                    }
                    return baseArray;
                }
                case -1539581980: {
                    return this.attributeEstimate == null ? new Base[]{} : this.attributeEstimate.toArray(new Base[this.attributeEstimate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 102865796: {
                    this.level = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
                case -1539581980: {
                    this.getAttributeEstimate().add((EvidenceStatisticAttributeEstimateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("level")) {
                this.level = TypeConvertor.castToDecimal(value);
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else if (name.equals("attributeEstimate")) {
                this.getAttributeEstimate().add((EvidenceStatisticAttributeEstimateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 108280125: {
                    return this.getRange();
                }
                case -1539581980: {
                    return this.addAttributeEstimate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
                case -1539581980: {
                    return new String[]{"@Evidence.statistic.attributeEstimate"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.attributeEstimate.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.attributeEstimate.level");
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            if (name.equals("attributeEstimate")) {
                return this.addAttributeEstimate();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceStatisticAttributeEstimateComponent copy() {
            EvidenceStatisticAttributeEstimateComponent dst = new EvidenceStatisticAttributeEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceStatisticAttributeEstimateComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.level = this.level == null ? null : this.level.copy();
            Range range = dst.range = this.range == null ? null : this.range.copy();
            if (this.attributeEstimate != null) {
                dst.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
                for (EvidenceStatisticAttributeEstimateComponent evidenceStatisticAttributeEstimateComponent : this.attributeEstimate) {
                    dst.attributeEstimate.add(evidenceStatisticAttributeEstimateComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticAttributeEstimateComponent)) {
                return false;
            }
            EvidenceStatisticAttributeEstimateComponent o = (EvidenceStatisticAttributeEstimateComponent)other_;
            return EvidenceStatisticAttributeEstimateComponent.compareDeep(this.description, o.description, true) && EvidenceStatisticAttributeEstimateComponent.compareDeep(this.note, o.note, true) && EvidenceStatisticAttributeEstimateComponent.compareDeep(this.type, o.type, true) && EvidenceStatisticAttributeEstimateComponent.compareDeep(this.quantity, o.quantity, true) && EvidenceStatisticAttributeEstimateComponent.compareDeep(this.level, o.level, true) && EvidenceStatisticAttributeEstimateComponent.compareDeep(this.range, o.range, true) && EvidenceStatisticAttributeEstimateComponent.compareDeep(this.attributeEstimate, o.attributeEstimate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticAttributeEstimateComponent)) {
                return false;
            }
            EvidenceStatisticAttributeEstimateComponent o = (EvidenceStatisticAttributeEstimateComponent)other_;
            return EvidenceStatisticAttributeEstimateComponent.compareValues(this.description, o.description, true) && EvidenceStatisticAttributeEstimateComponent.compareValues(this.level, o.level, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.quantity, this.level, this.range, this.attributeEstimate});
        }

        @Override
        public String fhirType() {
            return "Evidence.statistic.attributeEstimate";
        }
    }

    @Block
    public static class EvidenceStatisticSampleSizeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of sample size for statistic", formalDefinition="Human-readable summary of population sample size.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnote or explanatory note about the sample size", formalDefinition="Footnote or explanatory note about the sample size.")
        protected List<Annotation> note;
        @Child(name="numberOfStudies", type={UnsignedIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of contributing studies", formalDefinition="Number of participants in the population.")
        protected UnsignedIntType numberOfStudies;
        @Child(name="numberOfParticipants", type={UnsignedIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Cumulative number of participants", formalDefinition="A human-readable string to clarify or explain concepts about the sample size.")
        protected UnsignedIntType numberOfParticipants;
        @Child(name="knownDataCount", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of participants with known results for measured variables", formalDefinition="Number of participants with known results for measured variables.")
        protected UnsignedIntType knownDataCount;
        private static final long serialVersionUID = -1710653289L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticSampleSizeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceStatisticSampleSizeComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceStatisticSampleSizeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceStatisticSampleSizeComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceStatisticSampleSizeComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public UnsignedIntType getNumberOfStudiesElement() {
            if (this.numberOfStudies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticSampleSizeComponent.numberOfStudies");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfStudies = new UnsignedIntType();
                }
            }
            return this.numberOfStudies;
        }

        public boolean hasNumberOfStudiesElement() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public boolean hasNumberOfStudies() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public EvidenceStatisticSampleSizeComponent setNumberOfStudiesElement(UnsignedIntType value) {
            this.numberOfStudies = value;
            return this;
        }

        public int getNumberOfStudies() {
            return this.numberOfStudies == null || this.numberOfStudies.isEmpty() ? 0 : (Integer)this.numberOfStudies.getValue();
        }

        public EvidenceStatisticSampleSizeComponent setNumberOfStudies(int value) {
            if (this.numberOfStudies == null) {
                this.numberOfStudies = new UnsignedIntType();
            }
            this.numberOfStudies.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getNumberOfParticipantsElement() {
            if (this.numberOfParticipants == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticSampleSizeComponent.numberOfParticipants");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfParticipants = new UnsignedIntType();
                }
            }
            return this.numberOfParticipants;
        }

        public boolean hasNumberOfParticipantsElement() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public boolean hasNumberOfParticipants() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public EvidenceStatisticSampleSizeComponent setNumberOfParticipantsElement(UnsignedIntType value) {
            this.numberOfParticipants = value;
            return this;
        }

        public int getNumberOfParticipants() {
            return this.numberOfParticipants == null || this.numberOfParticipants.isEmpty() ? 0 : (Integer)this.numberOfParticipants.getValue();
        }

        public EvidenceStatisticSampleSizeComponent setNumberOfParticipants(int value) {
            if (this.numberOfParticipants == null) {
                this.numberOfParticipants = new UnsignedIntType();
            }
            this.numberOfParticipants.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getKnownDataCountElement() {
            if (this.knownDataCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticSampleSizeComponent.knownDataCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.knownDataCount = new UnsignedIntType();
                }
            }
            return this.knownDataCount;
        }

        public boolean hasKnownDataCountElement() {
            return this.knownDataCount != null && !this.knownDataCount.isEmpty();
        }

        public boolean hasKnownDataCount() {
            return this.knownDataCount != null && !this.knownDataCount.isEmpty();
        }

        public EvidenceStatisticSampleSizeComponent setKnownDataCountElement(UnsignedIntType value) {
            this.knownDataCount = value;
            return this;
        }

        public int getKnownDataCount() {
            return this.knownDataCount == null || this.knownDataCount.isEmpty() ? 0 : (Integer)this.knownDataCount.getValue();
        }

        public EvidenceStatisticSampleSizeComponent setKnownDataCount(int value) {
            if (this.knownDataCount == null) {
                this.knownDataCount = new UnsignedIntType();
            }
            this.knownDataCount.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "Human-readable summary of population sample size.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the sample size.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("numberOfStudies", "unsignedInt", "Number of participants in the population.", 0, 1, this.numberOfStudies));
            children.add(new Property("numberOfParticipants", "unsignedInt", "A human-readable string to clarify or explain concepts about the sample size.", 0, 1, this.numberOfParticipants));
            children.add(new Property("knownDataCount", "unsignedInt", "Number of participants with known results for measured variables.", 0, 1, this.knownDataCount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "Human-readable summary of population sample size.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the sample size.", 0, Integer.MAX_VALUE, this.note);
                }
                case -177467129: {
                    return new Property("numberOfStudies", "unsignedInt", "Number of participants in the population.", 0, 1, this.numberOfStudies);
                }
                case 1799357120: {
                    return new Property("numberOfParticipants", "unsignedInt", "A human-readable string to clarify or explain concepts about the sample size.", 0, 1, this.numberOfParticipants);
                }
                case -937344126: {
                    return new Property("knownDataCount", "unsignedInt", "Number of participants with known results for measured variables.", 0, 1, this.knownDataCount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -177467129: {
                    Base[] baseArray;
                    if (this.numberOfStudies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.numberOfStudies;
                    }
                    return baseArray;
                }
                case 1799357120: {
                    Base[] baseArray;
                    if (this.numberOfParticipants == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.numberOfParticipants;
                    }
                    return baseArray;
                }
                case -937344126: {
                    Base[] baseArray;
                    if (this.knownDataCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.knownDataCount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -177467129: {
                    this.numberOfStudies = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 1799357120: {
                    this.numberOfParticipants = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case -937344126: {
                    this.knownDataCount = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("numberOfStudies")) {
                this.numberOfStudies = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("numberOfParticipants")) {
                this.numberOfParticipants = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("knownDataCount")) {
                this.knownDataCount = TypeConvertor.castToUnsignedInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -177467129: {
                    return this.getNumberOfStudiesElement();
                }
                case 1799357120: {
                    return this.getNumberOfParticipantsElement();
                }
                case -937344126: {
                    return this.getKnownDataCountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -177467129: {
                    return new String[]{"unsignedInt"};
                }
                case 1799357120: {
                    return new String[]{"unsignedInt"};
                }
                case -937344126: {
                    return new String[]{"unsignedInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.sampleSize.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("numberOfStudies")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.sampleSize.numberOfStudies");
            }
            if (name.equals("numberOfParticipants")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.sampleSize.numberOfParticipants");
            }
            if (name.equals("knownDataCount")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.sampleSize.knownDataCount");
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceStatisticSampleSizeComponent copy() {
            EvidenceStatisticSampleSizeComponent dst = new EvidenceStatisticSampleSizeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceStatisticSampleSizeComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.numberOfStudies = this.numberOfStudies == null ? null : this.numberOfStudies.copy();
            dst.numberOfParticipants = this.numberOfParticipants == null ? null : this.numberOfParticipants.copy();
            dst.knownDataCount = this.knownDataCount == null ? null : this.knownDataCount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticSampleSizeComponent)) {
                return false;
            }
            EvidenceStatisticSampleSizeComponent o = (EvidenceStatisticSampleSizeComponent)other_;
            return EvidenceStatisticSampleSizeComponent.compareDeep(this.description, o.description, true) && EvidenceStatisticSampleSizeComponent.compareDeep(this.note, o.note, true) && EvidenceStatisticSampleSizeComponent.compareDeep(this.numberOfStudies, o.numberOfStudies, true) && EvidenceStatisticSampleSizeComponent.compareDeep(this.numberOfParticipants, o.numberOfParticipants, true) && EvidenceStatisticSampleSizeComponent.compareDeep(this.knownDataCount, o.knownDataCount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticSampleSizeComponent)) {
                return false;
            }
            EvidenceStatisticSampleSizeComponent o = (EvidenceStatisticSampleSizeComponent)other_;
            return EvidenceStatisticSampleSizeComponent.compareValues(this.description, o.description, true) && EvidenceStatisticSampleSizeComponent.compareValues(this.numberOfStudies, o.numberOfStudies, true) && EvidenceStatisticSampleSizeComponent.compareValues(this.numberOfParticipants, o.numberOfParticipants, true) && EvidenceStatisticSampleSizeComponent.compareValues(this.knownDataCount, o.knownDataCount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.numberOfStudies, this.numberOfParticipants, this.knownDataCount});
        }

        @Override
        public String fhirType() {
            return "Evidence.statistic.sampleSize";
        }
    }

    @Block
    public static class EvidenceStatisticComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of content", formalDefinition="A description of the content value of the statistic.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        protected List<Annotation> note;
        @Child(name="statisticType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of statistic, e.g., relative risk", formalDefinition="Type of statistic, e.g., relative risk.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/statistic-type")
        protected CodeableConcept statisticType;
        @Child(name="category", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Associated category for categorical variable", formalDefinition="When the measured variable is handled categorically, the category element is used to define which category the statistic is reporting.")
        protected CodeableConcept category;
        @Child(name="quantity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Statistic value", formalDefinition="Statistic value.")
        protected Quantity quantity;
        @Child(name="numberOfEvents", type={UnsignedIntType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of events associated with the statistic", formalDefinition="The number of events associated with the statistic, where the unit of analysis is different from numberAffected, sampleSize.knownDataCount and sampleSize.numberOfParticipants.")
        protected UnsignedIntType numberOfEvents;
        @Child(name="numberAffected", type={UnsignedIntType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of participants affected", formalDefinition="The number of participants affected where the unit of analysis is the same as sampleSize.knownDataCount and sampleSize.numberOfParticipants.")
        protected UnsignedIntType numberAffected;
        @Child(name="sampleSize", type={}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of samples in the statistic", formalDefinition="Number of samples in the statistic.")
        protected EvidenceStatisticSampleSizeComponent sampleSize;
        @Child(name="attributeEstimate", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An attribute of the Statistic", formalDefinition="A statistical attribute of the statistic such as a measure of heterogeneity.")
        protected List<EvidenceStatisticAttributeEstimateComponent> attributeEstimate;
        @Child(name="modelCharacteristic", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An aspect of the statistical model", formalDefinition="A component of the method to generate the statistic.")
        protected List<EvidenceStatisticModelCharacteristicComponent> modelCharacteristic;
        private static final long serialVersionUID = 1798829622L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceStatisticComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceStatisticComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceStatisticComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceStatisticComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getStatisticType() {
            if (this.statisticType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.statisticType");
                }
                if (Configuration.doAutoCreate()) {
                    this.statisticType = new CodeableConcept();
                }
            }
            return this.statisticType;
        }

        public boolean hasStatisticType() {
            return this.statisticType != null && !this.statisticType.isEmpty();
        }

        public EvidenceStatisticComponent setStatisticType(CodeableConcept value) {
            this.statisticType = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public EvidenceStatisticComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public EvidenceStatisticComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public UnsignedIntType getNumberOfEventsElement() {
            if (this.numberOfEvents == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.numberOfEvents");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfEvents = new UnsignedIntType();
                }
            }
            return this.numberOfEvents;
        }

        public boolean hasNumberOfEventsElement() {
            return this.numberOfEvents != null && !this.numberOfEvents.isEmpty();
        }

        public boolean hasNumberOfEvents() {
            return this.numberOfEvents != null && !this.numberOfEvents.isEmpty();
        }

        public EvidenceStatisticComponent setNumberOfEventsElement(UnsignedIntType value) {
            this.numberOfEvents = value;
            return this;
        }

        public int getNumberOfEvents() {
            return this.numberOfEvents == null || this.numberOfEvents.isEmpty() ? 0 : (Integer)this.numberOfEvents.getValue();
        }

        public EvidenceStatisticComponent setNumberOfEvents(int value) {
            if (this.numberOfEvents == null) {
                this.numberOfEvents = new UnsignedIntType();
            }
            this.numberOfEvents.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getNumberAffectedElement() {
            if (this.numberAffected == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.numberAffected");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberAffected = new UnsignedIntType();
                }
            }
            return this.numberAffected;
        }

        public boolean hasNumberAffectedElement() {
            return this.numberAffected != null && !this.numberAffected.isEmpty();
        }

        public boolean hasNumberAffected() {
            return this.numberAffected != null && !this.numberAffected.isEmpty();
        }

        public EvidenceStatisticComponent setNumberAffectedElement(UnsignedIntType value) {
            this.numberAffected = value;
            return this;
        }

        public int getNumberAffected() {
            return this.numberAffected == null || this.numberAffected.isEmpty() ? 0 : (Integer)this.numberAffected.getValue();
        }

        public EvidenceStatisticComponent setNumberAffected(int value) {
            if (this.numberAffected == null) {
                this.numberAffected = new UnsignedIntType();
            }
            this.numberAffected.setValue((Object)value);
            return this;
        }

        public EvidenceStatisticSampleSizeComponent getSampleSize() {
            if (this.sampleSize == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceStatisticComponent.sampleSize");
                }
                if (Configuration.doAutoCreate()) {
                    this.sampleSize = new EvidenceStatisticSampleSizeComponent();
                }
            }
            return this.sampleSize;
        }

        public boolean hasSampleSize() {
            return this.sampleSize != null && !this.sampleSize.isEmpty();
        }

        public EvidenceStatisticComponent setSampleSize(EvidenceStatisticSampleSizeComponent value) {
            this.sampleSize = value;
            return this;
        }

        public List<EvidenceStatisticAttributeEstimateComponent> getAttributeEstimate() {
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            return this.attributeEstimate;
        }

        public EvidenceStatisticComponent setAttributeEstimate(List<EvidenceStatisticAttributeEstimateComponent> theAttributeEstimate) {
            this.attributeEstimate = theAttributeEstimate;
            return this;
        }

        public boolean hasAttributeEstimate() {
            if (this.attributeEstimate == null) {
                return false;
            }
            for (EvidenceStatisticAttributeEstimateComponent item : this.attributeEstimate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceStatisticAttributeEstimateComponent addAttributeEstimate() {
            EvidenceStatisticAttributeEstimateComponent t = new EvidenceStatisticAttributeEstimateComponent();
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return t;
        }

        public EvidenceStatisticComponent addAttributeEstimate(EvidenceStatisticAttributeEstimateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return this;
        }

        public EvidenceStatisticAttributeEstimateComponent getAttributeEstimateFirstRep() {
            if (this.getAttributeEstimate().isEmpty()) {
                this.addAttributeEstimate();
            }
            return this.getAttributeEstimate().get(0);
        }

        public List<EvidenceStatisticModelCharacteristicComponent> getModelCharacteristic() {
            if (this.modelCharacteristic == null) {
                this.modelCharacteristic = new ArrayList<EvidenceStatisticModelCharacteristicComponent>();
            }
            return this.modelCharacteristic;
        }

        public EvidenceStatisticComponent setModelCharacteristic(List<EvidenceStatisticModelCharacteristicComponent> theModelCharacteristic) {
            this.modelCharacteristic = theModelCharacteristic;
            return this;
        }

        public boolean hasModelCharacteristic() {
            if (this.modelCharacteristic == null) {
                return false;
            }
            for (EvidenceStatisticModelCharacteristicComponent item : this.modelCharacteristic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceStatisticModelCharacteristicComponent addModelCharacteristic() {
            EvidenceStatisticModelCharacteristicComponent t = new EvidenceStatisticModelCharacteristicComponent();
            if (this.modelCharacteristic == null) {
                this.modelCharacteristic = new ArrayList<EvidenceStatisticModelCharacteristicComponent>();
            }
            this.modelCharacteristic.add(t);
            return t;
        }

        public EvidenceStatisticComponent addModelCharacteristic(EvidenceStatisticModelCharacteristicComponent t) {
            if (t == null) {
                return this;
            }
            if (this.modelCharacteristic == null) {
                this.modelCharacteristic = new ArrayList<EvidenceStatisticModelCharacteristicComponent>();
            }
            this.modelCharacteristic.add(t);
            return this;
        }

        public EvidenceStatisticModelCharacteristicComponent getModelCharacteristicFirstRep() {
            if (this.getModelCharacteristic().isEmpty()) {
                this.addModelCharacteristic();
            }
            return this.getModelCharacteristic().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "A description of the content value of the statistic.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("statisticType", "CodeableConcept", "Type of statistic, e.g., relative risk.", 0, 1, this.statisticType));
            children.add(new Property("category", "CodeableConcept", "When the measured variable is handled categorically, the category element is used to define which category the statistic is reporting.", 0, 1, this.category));
            children.add(new Property("quantity", "Quantity", "Statistic value.", 0, 1, this.quantity));
            children.add(new Property("numberOfEvents", "unsignedInt", "The number of events associated with the statistic, where the unit of analysis is different from numberAffected, sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberOfEvents));
            children.add(new Property("numberAffected", "unsignedInt", "The number of participants affected where the unit of analysis is the same as sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberAffected));
            children.add(new Property("sampleSize", "", "Number of samples in the statistic.", 0, 1, this.sampleSize));
            children.add(new Property("attributeEstimate", "", "A statistical attribute of the statistic such as a measure of heterogeneity.", 0, Integer.MAX_VALUE, this.attributeEstimate));
            children.add(new Property("modelCharacteristic", "", "A component of the method to generate the statistic.", 0, Integer.MAX_VALUE, this.modelCharacteristic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "A description of the content value of the statistic.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
                }
                case -392342358: {
                    return new Property("statisticType", "CodeableConcept", "Type of statistic, e.g., relative risk.", 0, 1, this.statisticType);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "When the measured variable is handled categorically, the category element is used to define which category the statistic is reporting.", 0, 1, this.category);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "Statistic value.", 0, 1, this.quantity);
                }
                case 1534510137: {
                    return new Property("numberOfEvents", "unsignedInt", "The number of events associated with the statistic, where the unit of analysis is different from numberAffected, sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberOfEvents);
                }
                case -460990243: {
                    return new Property("numberAffected", "unsignedInt", "The number of participants affected where the unit of analysis is the same as sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberAffected);
                }
                case 143123659: {
                    return new Property("sampleSize", "", "Number of samples in the statistic.", 0, 1, this.sampleSize);
                }
                case -1539581980: {
                    return new Property("attributeEstimate", "", "A statistical attribute of the statistic such as a measure of heterogeneity.", 0, Integer.MAX_VALUE, this.attributeEstimate);
                }
                case 274795812: {
                    return new Property("modelCharacteristic", "", "A component of the method to generate the statistic.", 0, Integer.MAX_VALUE, this.modelCharacteristic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -392342358: {
                    Base[] baseArray;
                    if (this.statisticType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.statisticType;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 1534510137: {
                    Base[] baseArray;
                    if (this.numberOfEvents == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.numberOfEvents;
                    }
                    return baseArray;
                }
                case -460990243: {
                    Base[] baseArray;
                    if (this.numberAffected == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.numberAffected;
                    }
                    return baseArray;
                }
                case 143123659: {
                    Base[] baseArray;
                    if (this.sampleSize == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.sampleSize;
                    }
                    return baseArray;
                }
                case -1539581980: {
                    return this.attributeEstimate == null ? new Base[]{} : this.attributeEstimate.toArray(new Base[this.attributeEstimate.size()]);
                }
                case 274795812: {
                    return this.modelCharacteristic == null ? new Base[]{} : this.modelCharacteristic.toArray(new Base[this.modelCharacteristic.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -392342358: {
                    this.statisticType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 1534510137: {
                    this.numberOfEvents = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case -460990243: {
                    this.numberAffected = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 143123659: {
                    this.sampleSize = (EvidenceStatisticSampleSizeComponent)value;
                    return value;
                }
                case -1539581980: {
                    this.getAttributeEstimate().add((EvidenceStatisticAttributeEstimateComponent)value);
                    return value;
                }
                case 274795812: {
                    this.getModelCharacteristic().add((EvidenceStatisticModelCharacteristicComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("statisticType")) {
                this.statisticType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("numberOfEvents")) {
                this.numberOfEvents = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("numberAffected")) {
                this.numberAffected = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("sampleSize")) {
                this.sampleSize = (EvidenceStatisticSampleSizeComponent)value;
            } else if (name.equals("attributeEstimate")) {
                this.getAttributeEstimate().add((EvidenceStatisticAttributeEstimateComponent)value);
            } else if (name.equals("modelCharacteristic")) {
                this.getModelCharacteristic().add((EvidenceStatisticModelCharacteristicComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -392342358: {
                    return this.getStatisticType();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 1534510137: {
                    return this.getNumberOfEventsElement();
                }
                case -460990243: {
                    return this.getNumberAffectedElement();
                }
                case 143123659: {
                    return this.getSampleSize();
                }
                case -1539581980: {
                    return this.addAttributeEstimate();
                }
                case 274795812: {
                    return this.addModelCharacteristic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -392342358: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 1534510137: {
                    return new String[]{"unsignedInt"};
                }
                case -460990243: {
                    return new String[]{"unsignedInt"};
                }
                case 143123659: {
                    return new String[0];
                }
                case -1539581980: {
                    return new String[0];
                }
                case 274795812: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("statisticType")) {
                this.statisticType = new CodeableConcept();
                return this.statisticType;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("numberOfEvents")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.numberOfEvents");
            }
            if (name.equals("numberAffected")) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.statistic.numberAffected");
            }
            if (name.equals("sampleSize")) {
                this.sampleSize = new EvidenceStatisticSampleSizeComponent();
                return this.sampleSize;
            }
            if (name.equals("attributeEstimate")) {
                return this.addAttributeEstimate();
            }
            if (name.equals("modelCharacteristic")) {
                return this.addModelCharacteristic();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceStatisticComponent copy() {
            EvidenceStatisticComponent dst = new EvidenceStatisticComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceStatisticComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            dst.statisticType = this.statisticType == null ? null : this.statisticType.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.numberOfEvents = this.numberOfEvents == null ? null : this.numberOfEvents.copy();
            dst.numberAffected = this.numberAffected == null ? null : this.numberAffected.copy();
            EvidenceStatisticSampleSizeComponent evidenceStatisticSampleSizeComponent = dst.sampleSize = this.sampleSize == null ? null : this.sampleSize.copy();
            if (this.attributeEstimate != null) {
                dst.attributeEstimate = new ArrayList<EvidenceStatisticAttributeEstimateComponent>();
                for (EvidenceStatisticAttributeEstimateComponent evidenceStatisticAttributeEstimateComponent : this.attributeEstimate) {
                    dst.attributeEstimate.add(evidenceStatisticAttributeEstimateComponent.copy());
                }
            }
            if (this.modelCharacteristic != null) {
                dst.modelCharacteristic = new ArrayList<EvidenceStatisticModelCharacteristicComponent>();
                for (EvidenceStatisticModelCharacteristicComponent evidenceStatisticModelCharacteristicComponent : this.modelCharacteristic) {
                    dst.modelCharacteristic.add(evidenceStatisticModelCharacteristicComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticComponent)) {
                return false;
            }
            EvidenceStatisticComponent o = (EvidenceStatisticComponent)other_;
            return EvidenceStatisticComponent.compareDeep(this.description, o.description, true) && EvidenceStatisticComponent.compareDeep(this.note, o.note, true) && EvidenceStatisticComponent.compareDeep(this.statisticType, o.statisticType, true) && EvidenceStatisticComponent.compareDeep(this.category, o.category, true) && EvidenceStatisticComponent.compareDeep(this.quantity, o.quantity, true) && EvidenceStatisticComponent.compareDeep(this.numberOfEvents, o.numberOfEvents, true) && EvidenceStatisticComponent.compareDeep(this.numberAffected, o.numberAffected, true) && EvidenceStatisticComponent.compareDeep(this.sampleSize, o.sampleSize, true) && EvidenceStatisticComponent.compareDeep(this.attributeEstimate, o.attributeEstimate, true) && EvidenceStatisticComponent.compareDeep(this.modelCharacteristic, o.modelCharacteristic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceStatisticComponent)) {
                return false;
            }
            EvidenceStatisticComponent o = (EvidenceStatisticComponent)other_;
            return EvidenceStatisticComponent.compareValues(this.description, o.description, true) && EvidenceStatisticComponent.compareValues(this.numberOfEvents, o.numberOfEvents, true) && EvidenceStatisticComponent.compareValues(this.numberAffected, o.numberAffected, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.statisticType, this.category, this.quantity, this.numberOfEvents, this.numberAffected, this.sampleSize, this.attributeEstimate, this.modelCharacteristic});
        }

        @Override
        public String fhirType() {
            return "Evidence.statistic";
        }
    }

    @Block
    public static class EvidenceVariableDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A text description or summary of the variable", formalDefinition="A text description or summary of the variable.")
        protected MarkdownType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
        protected List<Annotation> note;
        @Child(name="variableRole", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="population | subpopulation | exposure | referenceExposure | measuredVariable | confounder", formalDefinition="population | subpopulation | exposure | referenceExposure | measuredVariable | confounder.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-role")
        protected CodeableConcept variableRole;
        @Child(name="observed", type={Group.class, EvidenceVariable.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Definition of the actual variable related to the statistic(s)", formalDefinition="Definition of the actual variable related to the statistic(s).")
        protected Reference observed;
        @Child(name="intended", type={Group.class, EvidenceVariable.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of the intended variable related to the Evidence", formalDefinition="Definition of the intended variable related to the Evidence.")
        protected Reference intended;
        @Child(name="directnessMatch", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="low | moderate | high | exact", formalDefinition="Indication of quality of match between intended variable to actual variable.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/directness")
        protected CodeableConcept directnessMatch;
        private static final long serialVersionUID = -702346164L;

        public EvidenceVariableDefinitionComponent() {
        }

        public EvidenceVariableDefinitionComponent(CodeableConcept variableRole) {
            this.setVariableRole(variableRole);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceVariableDefinitionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceVariableDefinitionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceVariableDefinitionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getVariableRole() {
            if (this.variableRole == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.variableRole");
                }
                if (Configuration.doAutoCreate()) {
                    this.variableRole = new CodeableConcept();
                }
            }
            return this.variableRole;
        }

        public boolean hasVariableRole() {
            return this.variableRole != null && !this.variableRole.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setVariableRole(CodeableConcept value) {
            this.variableRole = value;
            return this;
        }

        public Reference getObserved() {
            if (this.observed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.observed");
                }
                if (Configuration.doAutoCreate()) {
                    this.observed = new Reference();
                }
            }
            return this.observed;
        }

        public boolean hasObserved() {
            return this.observed != null && !this.observed.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setObserved(Reference value) {
            this.observed = value;
            return this;
        }

        public Reference getIntended() {
            if (this.intended == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.intended");
                }
                if (Configuration.doAutoCreate()) {
                    this.intended = new Reference();
                }
            }
            return this.intended;
        }

        public boolean hasIntended() {
            return this.intended != null && !this.intended.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setIntended(Reference value) {
            this.intended = value;
            return this;
        }

        public CodeableConcept getDirectnessMatch() {
            if (this.directnessMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableDefinitionComponent.directnessMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.directnessMatch = new CodeableConcept();
                }
            }
            return this.directnessMatch;
        }

        public boolean hasDirectnessMatch() {
            return this.directnessMatch != null && !this.directnessMatch.isEmpty();
        }

        public EvidenceVariableDefinitionComponent setDirectnessMatch(CodeableConcept value) {
            this.directnessMatch = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Evidence.SP_DESCRIPTION, "markdown", "A text description or summary of the variable.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("variableRole", "CodeableConcept", "population | subpopulation | exposure | referenceExposure | measuredVariable | confounder.", 0, 1, this.variableRole));
            children.add(new Property("observed", "Reference(Group|EvidenceVariable)", "Definition of the actual variable related to the statistic(s).", 0, 1, this.observed));
            children.add(new Property("intended", "Reference(Group|EvidenceVariable)", "Definition of the intended variable related to the Evidence.", 0, 1, this.intended));
            children.add(new Property("directnessMatch", "CodeableConcept", "Indication of quality of match between intended variable to actual variable.", 0, 1, this.directnessMatch));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(Evidence.SP_DESCRIPTION, "markdown", "A text description or summary of the variable.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
                }
                case -372889326: {
                    return new Property("variableRole", "CodeableConcept", "population | subpopulation | exposure | referenceExposure | measuredVariable | confounder.", 0, 1, this.variableRole);
                }
                case 348607176: {
                    return new Property("observed", "Reference(Group|EvidenceVariable)", "Definition of the actual variable related to the statistic(s).", 0, 1, this.observed);
                }
                case 570282027: {
                    return new Property("intended", "Reference(Group|EvidenceVariable)", "Definition of the intended variable related to the Evidence.", 0, 1, this.intended);
                }
                case -2144864283: {
                    return new Property("directnessMatch", "CodeableConcept", "Indication of quality of match between intended variable to actual variable.", 0, 1, this.directnessMatch);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -372889326: {
                    Base[] baseArray;
                    if (this.variableRole == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.variableRole;
                    }
                    return baseArray;
                }
                case 348607176: {
                    Base[] baseArray;
                    if (this.observed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.observed;
                    }
                    return baseArray;
                }
                case 570282027: {
                    Base[] baseArray;
                    if (this.intended == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.intended;
                    }
                    return baseArray;
                }
                case -2144864283: {
                    Base[] baseArray;
                    if (this.directnessMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.directnessMatch;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -372889326: {
                    this.variableRole = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 348607176: {
                    this.observed = TypeConvertor.castToReference(value);
                    return value;
                }
                case 570282027: {
                    this.intended = TypeConvertor.castToReference(value);
                    return value;
                }
                case -2144864283: {
                    this.directnessMatch = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("variableRole")) {
                this.variableRole = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("observed")) {
                this.observed = TypeConvertor.castToReference(value);
            } else if (name.equals("intended")) {
                this.intended = TypeConvertor.castToReference(value);
            } else if (name.equals("directnessMatch")) {
                this.directnessMatch = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -372889326: {
                    return this.getVariableRole();
                }
                case 348607176: {
                    return this.getObserved();
                }
                case 570282027: {
                    return this.getIntended();
                }
                case -2144864283: {
                    return this.getDirectnessMatch();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -372889326: {
                    return new String[]{"CodeableConcept"};
                }
                case 348607176: {
                    return new String[]{"Reference"};
                }
                case 570282027: {
                    return new String[]{"Reference"};
                }
                case -2144864283: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Evidence.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Evidence.variableDefinition.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("variableRole")) {
                this.variableRole = new CodeableConcept();
                return this.variableRole;
            }
            if (name.equals("observed")) {
                this.observed = new Reference();
                return this.observed;
            }
            if (name.equals("intended")) {
                this.intended = new Reference();
                return this.intended;
            }
            if (name.equals("directnessMatch")) {
                this.directnessMatch = new CodeableConcept();
                return this.directnessMatch;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableDefinitionComponent copy() {
            EvidenceVariableDefinitionComponent dst = new EvidenceVariableDefinitionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableDefinitionComponent dst) {
            super.copyValues(dst);
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.variableRole = this.variableRole == null ? null : this.variableRole.copy();
            dst.observed = this.observed == null ? null : this.observed.copy();
            dst.intended = this.intended == null ? null : this.intended.copy();
            dst.directnessMatch = this.directnessMatch == null ? null : this.directnessMatch.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableDefinitionComponent)) {
                return false;
            }
            EvidenceVariableDefinitionComponent o = (EvidenceVariableDefinitionComponent)other_;
            return EvidenceVariableDefinitionComponent.compareDeep(this.description, o.description, true) && EvidenceVariableDefinitionComponent.compareDeep(this.note, o.note, true) && EvidenceVariableDefinitionComponent.compareDeep(this.variableRole, o.variableRole, true) && EvidenceVariableDefinitionComponent.compareDeep(this.observed, o.observed, true) && EvidenceVariableDefinitionComponent.compareDeep(this.intended, o.intended, true) && EvidenceVariableDefinitionComponent.compareDeep(this.directnessMatch, o.directnessMatch, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableDefinitionComponent)) {
                return false;
            }
            EvidenceVariableDefinitionComponent o = (EvidenceVariableDefinitionComponent)other_;
            return EvidenceVariableDefinitionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.variableRole, this.observed, this.intended, this.directnessMatch});
        }

        @Override
        public String fhirType() {
            return "Evidence.variableDefinition";
        }
    }
}

