/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Ingredient", profile="http://hl7.org/fhir/StructureDefinition/Ingredient")
public class Ingredient
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier or code by which the ingredient can be referenced", formalDefinition="The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this ingredient. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="for", type={MedicinalProductDefinition.class, AdministrableProductDefinition.class, ManufacturedItemDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product which this ingredient is a constituent part of", formalDefinition="The product which this ingredient is a constituent part of.")
    protected List<Reference> for_;
    @Child(name="role", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Purpose of the ingredient within the product, e.g. active, inactive", formalDefinition="A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/ingredient-role")
    protected CodeableConcept role;
    @Child(name="function", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Precise action within the drug product, e.g. antioxidant, alkalizing agent", formalDefinition="A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: antioxidant, alkalizing agent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/ingredient-function")
    protected List<CodeableConcept> function;
    @Child(name="group", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink", formalDefinition="A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink.")
    protected CodeableConcept group;
    @Child(name="allergenicIndicator", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the ingredient is a known or suspected allergen", formalDefinition="If the ingredient is a known or suspected allergen. Note that this is a property of the substance, so if a reference to a SubstanceDefinition is used to decribe that (rather than just a code), the allergen information should go there, not here.")
    protected BooleanType allergenicIndicator;
    @Child(name="comment", type={MarkdownType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A place for providing any notes that are relevant to the component, e.g. removed during process, adjusted for loss on drying", formalDefinition="A place for providing any notes that are relevant to the component, e.g. removed during process, adjusted for loss on drying.")
    protected MarkdownType comment;
    @Child(name="manufacturer", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An organization that manufactures this ingredient", formalDefinition="The organization(s) that manufacture this ingredient. Can be used to indicate:         1) Organizations we are aware of that manufacture this ingredient         2) Specific Manufacturer(s) currently being used         3) Set of organisations allowed to manufacture this ingredient for this product         Users must be clear on the application of context relevant to their use case.")
    protected List<IngredientManufacturerComponent> manufacturer;
    @Child(name="substance", type={}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The substance that comprises this ingredient", formalDefinition="The substance that comprises this ingredient.")
    protected IngredientSubstanceComponent substance;
    private static final long serialVersionUID = 701648703L;
    @SearchParamDefinition(name="for", path="Ingredient.for", description="The product which this ingredient is a constituent part of", type="reference", target={AdministrableProductDefinition.class, ManufacturedItemDefinition.class, MedicinalProductDefinition.class})
    public static final String SP_FOR = "for";
    public static final ReferenceClientParam FOR = new ReferenceClientParam("for");
    public static final Include INCLUDE_FOR = new Include("Ingredient:for").toLocked();
    @SearchParamDefinition(name="function", path="Ingredient.function", description="A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: Antioxidant, Alkalizing Agent", type="token")
    public static final String SP_FUNCTION = "function";
    public static final TokenClientParam FUNCTION = new TokenClientParam("function");
    @SearchParamDefinition(name="identifier", path="Ingredient.identifier", description="An identifier or code by which the ingredient can be referenced", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manufacturer", path="Ingredient.manufacturer.manufacturer", description="The organization that manufactures this ingredient", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Ingredient:manufacturer").toLocked();
    @SearchParamDefinition(name="role", path="Ingredient.role", description="A classification of the ingredient identifying its purpose within the product, e.g. active, inactive", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="status", path="Ingredient.status", description="The status of this ingredient. Enables tracking the life-cycle of the content", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="strength-concentration-quantity", path="Ingredient.substance.strength.concentration.ofType(Quantity)", description="Ingredient concentration strength as quantity", type="quantity")
    public static final String SP_STRENGTH_CONCENTRATION_QUANTITY = "strength-concentration-quantity";
    public static final QuantityClientParam STRENGTH_CONCENTRATION_QUANTITY = new QuantityClientParam("strength-concentration-quantity");
    @SearchParamDefinition(name="strength-presentation-quantity", path="Ingredient.substance.strength.presentation.ofType(Quantity)", description="Ingredient presentation strength as quantity", type="quantity")
    public static final String SP_STRENGTH_PRESENTATION_QUANTITY = "strength-presentation-quantity";
    public static final QuantityClientParam STRENGTH_PRESENTATION_QUANTITY = new QuantityClientParam("strength-presentation-quantity");
    @SearchParamDefinition(name="substance-code", path="Ingredient.substance.code.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_SUBSTANCE_CODE = "substance-code";
    public static final TokenClientParam SUBSTANCE_CODE = new TokenClientParam("substance-code");
    @SearchParamDefinition(name="substance-definition", path="Ingredient.substance.code.reference", description="Reference to a resource (by instance)", type="reference", target={SubstanceDefinition.class})
    public static final String SP_SUBSTANCE_DEFINITION = "substance-definition";
    public static final ReferenceClientParam SUBSTANCE_DEFINITION = new ReferenceClientParam("substance-definition");
    public static final Include INCLUDE_SUBSTANCE_DEFINITION = new Include("Ingredient:substance-definition").toLocked();
    @SearchParamDefinition(name="substance", path="Ingredient.substance.code.reference", description="Reference to a resource (by instance)", type="reference", target={SubstanceDefinition.class})
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_SUBSTANCE = new Include("Ingredient:substance").toLocked();

    public Ingredient() {
    }

    public Ingredient(Enumerations.PublicationStatus status, CodeableConcept role, IngredientSubstanceComponent substance) {
        this.setStatus(status);
        this.setRole(role);
        this.setSubstance(substance);
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Ingredient setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Ingredient setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public Ingredient setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Reference> getFor() {
        if (this.for_ == null) {
            this.for_ = new ArrayList<Reference>();
        }
        return this.for_;
    }

    public Ingredient setFor(List<Reference> theFor) {
        this.for_ = theFor;
        return this;
    }

    public boolean hasFor() {
        if (this.for_ == null) {
            return false;
        }
        for (Reference item : this.for_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFor() {
        Reference t = new Reference();
        if (this.for_ == null) {
            this.for_ = new ArrayList<Reference>();
        }
        this.for_.add(t);
        return t;
    }

    public Ingredient addFor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.for_ == null) {
            this.for_ = new ArrayList<Reference>();
        }
        this.for_.add(t);
        return this;
    }

    public Reference getForFirstRep() {
        if (this.getFor().isEmpty()) {
            this.addFor();
        }
        return this.getFor().get(0);
    }

    public CodeableConcept getRole() {
        if (this.role == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.role");
            }
            if (Configuration.doAutoCreate()) {
                this.role = new CodeableConcept();
            }
        }
        return this.role;
    }

    public boolean hasRole() {
        return this.role != null && !this.role.isEmpty();
    }

    public Ingredient setRole(CodeableConcept value) {
        this.role = value;
        return this;
    }

    public List<CodeableConcept> getFunction() {
        if (this.function == null) {
            this.function = new ArrayList<CodeableConcept>();
        }
        return this.function;
    }

    public Ingredient setFunction(List<CodeableConcept> theFunction) {
        this.function = theFunction;
        return this;
    }

    public boolean hasFunction() {
        if (this.function == null) {
            return false;
        }
        for (CodeableConcept item : this.function) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFunction() {
        CodeableConcept t = new CodeableConcept();
        if (this.function == null) {
            this.function = new ArrayList<CodeableConcept>();
        }
        this.function.add(t);
        return t;
    }

    public Ingredient addFunction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.function == null) {
            this.function = new ArrayList<CodeableConcept>();
        }
        this.function.add(t);
        return this;
    }

    public CodeableConcept getFunctionFirstRep() {
        if (this.getFunction().isEmpty()) {
            this.addFunction();
        }
        return this.getFunction().get(0);
    }

    public CodeableConcept getGroup() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new CodeableConcept();
            }
        }
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public Ingredient setGroup(CodeableConcept value) {
        this.group = value;
        return this;
    }

    public BooleanType getAllergenicIndicatorElement() {
        if (this.allergenicIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.allergenicIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.allergenicIndicator = new BooleanType();
            }
        }
        return this.allergenicIndicator;
    }

    public boolean hasAllergenicIndicatorElement() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public boolean hasAllergenicIndicator() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public Ingredient setAllergenicIndicatorElement(BooleanType value) {
        this.allergenicIndicator = value;
        return this;
    }

    public boolean getAllergenicIndicator() {
        return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
    }

    public Ingredient setAllergenicIndicator(boolean value) {
        if (this.allergenicIndicator == null) {
            this.allergenicIndicator = new BooleanType();
        }
        this.allergenicIndicator.setValue((Object)value);
        return this;
    }

    public MarkdownType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new MarkdownType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Ingredient setCommentElement(MarkdownType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Ingredient setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new MarkdownType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public List<IngredientManufacturerComponent> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<IngredientManufacturerComponent>();
        }
        return this.manufacturer;
    }

    public Ingredient setManufacturer(List<IngredientManufacturerComponent> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (IngredientManufacturerComponent item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IngredientManufacturerComponent addManufacturer() {
        IngredientManufacturerComponent t = new IngredientManufacturerComponent();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<IngredientManufacturerComponent>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public Ingredient addManufacturer(IngredientManufacturerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<IngredientManufacturerComponent>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public IngredientManufacturerComponent getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public IngredientSubstanceComponent getSubstance() {
        if (this.substance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.substance");
            }
            if (Configuration.doAutoCreate()) {
                this.substance = new IngredientSubstanceComponent();
            }
        }
        return this.substance;
    }

    public boolean hasSubstance() {
        return this.substance != null && !this.substance.isEmpty();
    }

    public Ingredient setSubstance(IngredientSubstanceComponent value) {
        this.substance = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of this ingredient. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_FOR, "Reference(MedicinalProductDefinition|AdministrableProductDefinition|ManufacturedItemDefinition)", "The product which this ingredient is a constituent part of.", 0, Integer.MAX_VALUE, this.for_));
        children.add(new Property(SP_ROLE, "CodeableConcept", "A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.", 0, 1, this.role));
        children.add(new Property(SP_FUNCTION, "CodeableConcept", "A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: antioxidant, alkalizing agent.", 0, Integer.MAX_VALUE, this.function));
        children.add(new Property("group", "CodeableConcept", "A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink.", 0, 1, this.group));
        children.add(new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen. Note that this is a property of the substance, so if a reference to a SubstanceDefinition is used to decribe that (rather than just a code), the allergen information should go there, not here.", 0, 1, this.allergenicIndicator));
        children.add(new Property("comment", "markdown", "A place for providing any notes that are relevant to the component, e.g. removed during process, adjusted for loss on drying.", 0, 1, this.comment));
        children.add(new Property(SP_MANUFACTURER, "", "The organization(s) that manufacture this ingredient. Can be used to indicate:         1) Organizations we are aware of that manufacture this ingredient         2) Specific Manufacturer(s) currently being used         3) Set of organisations allowed to manufacture this ingredient for this product         Users must be clear on the application of context relevant to their use case.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property(SP_SUBSTANCE, "", "The substance that comprises this ingredient.", 0, 1, this.substance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this ingredient. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 101577: {
                return new Property(SP_FOR, "Reference(MedicinalProductDefinition|AdministrableProductDefinition|ManufacturedItemDefinition)", "The product which this ingredient is a constituent part of.", 0, Integer.MAX_VALUE, this.for_);
            }
            case 3506294: {
                return new Property(SP_ROLE, "CodeableConcept", "A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.", 0, 1, this.role);
            }
            case 1380938712: {
                return new Property(SP_FUNCTION, "CodeableConcept", "A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: antioxidant, alkalizing agent.", 0, Integer.MAX_VALUE, this.function);
            }
            case 98629247: {
                return new Property("group", "CodeableConcept", "A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink.", 0, 1, this.group);
            }
            case 75406931: {
                return new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen. Note that this is a property of the substance, so if a reference to a SubstanceDefinition is used to decribe that (rather than just a code), the allergen information should go there, not here.", 0, 1, this.allergenicIndicator);
            }
            case 950398559: {
                return new Property("comment", "markdown", "A place for providing any notes that are relevant to the component, e.g. removed during process, adjusted for loss on drying.", 0, 1, this.comment);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "", "The organization(s) that manufacture this ingredient. Can be used to indicate:         1) Organizations we are aware of that manufacture this ingredient         2) Specific Manufacturer(s) currently being used         3) Set of organisations allowed to manufacture this ingredient for this product         Users must be clear on the application of context relevant to their use case.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case 530040176: {
                return new Property(SP_SUBSTANCE, "", "The substance that comprises this ingredient.", 0, 1, this.substance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 101577: {
                return this.for_ == null ? new Base[]{} : this.for_.toArray(new Base[this.for_.size()]);
            }
            case 3506294: {
                Base[] baseArray;
                if (this.role == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.role;
                }
                return baseArray;
            }
            case 1380938712: {
                return this.function == null ? new Base[]{} : this.function.toArray(new Base[this.function.size()]);
            }
            case 98629247: {
                Base[] baseArray;
                if (this.group == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.group;
                }
                return baseArray;
            }
            case 75406931: {
                Base[] baseArray;
                if (this.allergenicIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.allergenicIndicator;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.comment;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case 530040176: {
                Base[] baseArray;
                if (this.substance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.substance;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 101577: {
                this.getFor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3506294: {
                this.role = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1380938712: {
                this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 98629247: {
                this.group = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 75406931: {
                this.allergenicIndicator = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 950398559: {
                this.comment = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add((IngredientManufacturerComponent)((Object)value));
                return value;
            }
            case 530040176: {
                this.substance = (IngredientSubstanceComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_FOR)) {
            this.getFor().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ROLE)) {
            this.role = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_FUNCTION)) {
            this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("group")) {
            this.group = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("allergenicIndicator")) {
            this.allergenicIndicator = TypeConvertor.castToBoolean(value);
        } else if (name.equals("comment")) {
            this.comment = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.getManufacturer().add((IngredientManufacturerComponent)((Object)value));
        } else if (name.equals(SP_SUBSTANCE)) {
            this.substance = (IngredientSubstanceComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 101577: {
                return this.addFor();
            }
            case 3506294: {
                return this.getRole();
            }
            case 1380938712: {
                return this.addFunction();
            }
            case 98629247: {
                return this.getGroup();
            }
            case 75406931: {
                return this.getAllergenicIndicatorElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case 530040176: {
                return this.getSubstance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 101577: {
                return new String[]{"Reference"};
            }
            case 3506294: {
                return new String[]{"CodeableConcept"};
            }
            case 1380938712: {
                return new String[]{"CodeableConcept"};
            }
            case 98629247: {
                return new String[]{"CodeableConcept"};
            }
            case 75406931: {
                return new String[]{"boolean"};
            }
            case 950398559: {
                return new String[]{"markdown"};
            }
            case -1969347631: {
                return new String[0];
            }
            case 530040176: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Ingredient.status");
        }
        if (name.equals(SP_FOR)) {
            return this.addFor();
        }
        if (name.equals(SP_ROLE)) {
            this.role = new CodeableConcept();
            return this.role;
        }
        if (name.equals(SP_FUNCTION)) {
            return this.addFunction();
        }
        if (name.equals("group")) {
            this.group = new CodeableConcept();
            return this.group;
        }
        if (name.equals("allergenicIndicator")) {
            throw new FHIRException("Cannot call addChild on a singleton property Ingredient.allergenicIndicator");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a singleton property Ingredient.comment");
        }
        if (name.equals(SP_MANUFACTURER)) {
            return this.addManufacturer();
        }
        if (name.equals(SP_SUBSTANCE)) {
            this.substance = new IngredientSubstanceComponent();
            return this.substance;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Ingredient";
    }

    @Override
    public Ingredient copy() {
        Ingredient dst = new Ingredient();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Ingredient dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.for_ != null) {
            dst.for_ = new ArrayList<Reference>();
            for (Reference reference : this.for_) {
                dst.for_.add(reference.copy());
            }
        }
        CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
        if (this.function != null) {
            dst.function = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.function) {
                dst.function.add(codeableConcept2.copy());
            }
        }
        dst.group = this.group == null ? null : this.group.copy();
        dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
        MarkdownType markdownType = dst.comment = this.comment == null ? null : this.comment.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<IngredientManufacturerComponent>();
            for (IngredientManufacturerComponent ingredientManufacturerComponent : this.manufacturer) {
                dst.manufacturer.add(ingredientManufacturerComponent.copy());
            }
        }
        dst.substance = this.substance == null ? null : this.substance.copy();
    }

    protected Ingredient typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Ingredient)) {
            return false;
        }
        Ingredient o = (Ingredient)other_;
        return Ingredient.compareDeep(this.identifier, o.identifier, true) && Ingredient.compareDeep(this.status, o.status, true) && Ingredient.compareDeep(this.for_, o.for_, true) && Ingredient.compareDeep(this.role, o.role, true) && Ingredient.compareDeep(this.function, o.function, true) && Ingredient.compareDeep(this.group, o.group, true) && Ingredient.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true) && Ingredient.compareDeep(this.comment, o.comment, true) && Ingredient.compareDeep(this.manufacturer, o.manufacturer, true) && Ingredient.compareDeep(this.substance, o.substance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Ingredient)) {
            return false;
        }
        Ingredient o = (Ingredient)other_;
        return Ingredient.compareValues(this.status, o.status, true) && Ingredient.compareValues(this.allergenicIndicator, o.allergenicIndicator, true) && Ingredient.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.for_, this.role, this.function, this.group, this.allergenicIndicator, this.comment, this.manufacturer, this.substance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Ingredient;
    }

    @Block
    public static class IngredientSubstanceStrengthReferenceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Relevant reference substance", formalDefinition="Relevant reference substance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
        protected CodeableReference substance;
        @Child(name="strength", type={Ratio.class, RatioRange.class, Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected DataType strength;
        @Child(name="measurementPoint", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Where the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/country")
        protected List<CodeableConcept> country;
        private static final long serialVersionUID = 1700529245L;

        public IngredientSubstanceStrengthReferenceStrengthComponent() {
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent(CodeableReference substance, DataType strength) {
            this.setSubstance(substance);
            this.setStrength(strength);
        }

        public CodeableReference getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthReferenceStrengthComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableReference();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setSubstance(CodeableReference value) {
            this.substance = value;
            return this;
        }

        public DataType getStrength() {
            return this.strength;
        }

        public Ratio getStrengthRatio() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Ratio();
            }
            if (!(this.strength instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Ratio)this.strength;
        }

        public boolean hasStrengthRatio() {
            return this != null && this.strength instanceof Ratio;
        }

        public RatioRange getStrengthRatioRange() throws FHIRException {
            if (this.strength == null) {
                this.strength = new RatioRange();
            }
            if (!(this.strength instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.strength;
        }

        public boolean hasStrengthRatioRange() {
            return this != null && this.strength instanceof RatioRange;
        }

        public Quantity getStrengthQuantity() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Quantity();
            }
            if (!(this.strength instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Quantity)this.strength;
        }

        public boolean hasStrengthQuantity() {
            return this != null && this.strength instanceof Quantity;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setStrength(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof RatioRange || value instanceof Quantity)) {
                throw new FHIRException("Not the right type for Ingredient.substance.strength.referenceStrength.strength[x]: " + value.fhirType());
            }
            this.strength = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthReferenceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Ingredient.SP_SUBSTANCE, "CodeableReference(SubstanceDefinition)", "Relevant reference substance.", 0, 1, this.substance));
            children.add(new Property("strength[x]", "Ratio|RatioRange|Quantity", "Strength expressed in terms of a reference substance.", 0, 1, this.strength));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property(Ingredient.SP_SUBSTANCE, "CodeableReference(SubstanceDefinition)", "Relevant reference substance.", 0, 1, this.substance);
                }
                case 127377567: {
                    return new Property("strength[x]", "Ratio|RatioRange|Quantity", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case 1791316033: {
                    return new Property("strength[x]", "Ratio|RatioRange|Quantity", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case 2141786186: {
                    return new Property("strength[x]", "Ratio", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case -1300703469: {
                    return new Property("strength[x]", "RatioRange", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case -1793570836: {
                    return new Property("strength[x]", "Quantity", "Strength expressed in terms of a reference substance.", 0, 1, this.strength);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.strength;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = TypeConvertor.castToType(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = TypeConvertor.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Ingredient.SP_SUBSTANCE)) {
                this.substance = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("strength[x]")) {
                this.strength = TypeConvertor.castToType(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = TypeConvertor.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case 127377567: {
                    return this.getStrength();
                }
                case 1791316033: {
                    return this.getStrength();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableReference"};
                }
                case 1791316033: {
                    return new String[]{"Ratio", "RatioRange", "Quantity"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Ingredient.SP_SUBSTANCE)) {
                this.substance = new CodeableReference();
                return this.substance;
            }
            if (name.equals("strengthRatio")) {
                this.strength = new Ratio();
                return this.strength;
            }
            if (name.equals("strengthRatioRange")) {
                this.strength = new RatioRange();
                return this.strength;
            }
            if (name.equals("strengthQuantity")) {
                this.strength = new Quantity();
                return this.strength;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property Ingredient.substance.strength.referenceStrength.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceStrengthReferenceStrengthComponent copy() {
            IngredientSubstanceStrengthReferenceStrengthComponent dst = new IngredientSubstanceStrengthReferenceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceStrengthReferenceStrengthComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.country) {
                    dst.country.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthReferenceStrengthComponent o = (IngredientSubstanceStrengthReferenceStrengthComponent)other_;
            return IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.substance, o.substance, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strength, o.strength, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.country, o.country, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthReferenceStrengthComponent o = (IngredientSubstanceStrengthReferenceStrengthComponent)other_;
            return IngredientSubstanceStrengthReferenceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substance, this.strength, this.measurementPoint, this.country});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance.strength.referenceStrength";
        }
    }

    @Block
    public static class IngredientSubstanceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="presentation", type={Ratio.class, RatioRange.class, CodeableConcept.class, Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of substance in the unit of presentation", formalDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').")
        protected DataType presentation;
        @Child(name="textPresentation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text of either the whole presentation strength or a part of it (rest being in Strength.presentation as a ratio)", formalDefinition="A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio.")
        protected StringType textPresentation;
        @Child(name="concentration", type={Ratio.class, RatioRange.class, CodeableConcept.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The strength per unitary volume (or mass)", formalDefinition="The strength per unitary volume (or mass).")
        protected DataType concentration;
        @Child(name="textConcentration", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text of either the whole concentration strength or a part of it (rest being in Strength.concentration as a ratio)", formalDefinition="A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio.")
        protected StringType textConcentration;
        @Child(name="basis", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt)", formalDefinition="A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt).")
        protected CodeableConcept basis;
        @Child(name="measurementPoint", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance. There are products where strength is measured at a particular point. For example, the strength of the ingredient in some inhalers is measured at a particular position relative to the point of aerosolization.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Where the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/country")
        protected List<CodeableConcept> country;
        @Child(name="referenceStrength", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance. For when the ingredient strength is additionally expressed as equivalent to the strength of some other closely related substance (e.g. salt vs. base). Reference strength represents the strength (quantitative composition) of the active moiety of the active substance. There are situations when the active substance and active moiety are different, therefore both a strength and a reference strength are needed.")
        protected List<IngredientSubstanceStrengthReferenceStrengthComponent> referenceStrength;
        private static final long serialVersionUID = 1409093088L;

        public DataType getPresentation() {
            return this.presentation;
        }

        public Ratio getPresentationRatio() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new Ratio();
            }
            if (!(this.presentation instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (Ratio)this.presentation;
        }

        public boolean hasPresentationRatio() {
            return this != null && this.presentation instanceof Ratio;
        }

        public RatioRange getPresentationRatioRange() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new RatioRange();
            }
            if (!(this.presentation instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.presentation;
        }

        public boolean hasPresentationRatioRange() {
            return this != null && this.presentation instanceof RatioRange;
        }

        public CodeableConcept getPresentationCodeableConcept() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new CodeableConcept();
            }
            if (!(this.presentation instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.presentation;
        }

        public boolean hasPresentationCodeableConcept() {
            return this != null && this.presentation instanceof CodeableConcept;
        }

        public Quantity getPresentationQuantity() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new Quantity();
            }
            if (!(this.presentation instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (Quantity)this.presentation;
        }

        public boolean hasPresentationQuantity() {
            return this != null && this.presentation instanceof Quantity;
        }

        public boolean hasPresentation() {
            return this.presentation != null && !this.presentation.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setPresentation(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof RatioRange || value instanceof CodeableConcept || value instanceof Quantity)) {
                throw new FHIRException("Not the right type for Ingredient.substance.strength.presentation[x]: " + value.fhirType());
            }
            this.presentation = value;
            return this;
        }

        public StringType getTextPresentationElement() {
            if (this.textPresentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.textPresentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.textPresentation = new StringType();
                }
            }
            return this.textPresentation;
        }

        public boolean hasTextPresentationElement() {
            return this.textPresentation != null && !this.textPresentation.isEmpty();
        }

        public boolean hasTextPresentation() {
            return this.textPresentation != null && !this.textPresentation.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setTextPresentationElement(StringType value) {
            this.textPresentation = value;
            return this;
        }

        public String getTextPresentation() {
            return this.textPresentation == null ? null : (String)this.textPresentation.getValue();
        }

        public IngredientSubstanceStrengthComponent setTextPresentation(String value) {
            if (Utilities.noString((String)value)) {
                this.textPresentation = null;
            } else {
                if (this.textPresentation == null) {
                    this.textPresentation = new StringType();
                }
                this.textPresentation.setValue(value);
            }
            return this;
        }

        public DataType getConcentration() {
            return this.concentration;
        }

        public Ratio getConcentrationRatio() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new Ratio();
            }
            if (!(this.concentration instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (Ratio)this.concentration;
        }

        public boolean hasConcentrationRatio() {
            return this != null && this.concentration instanceof Ratio;
        }

        public RatioRange getConcentrationRatioRange() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new RatioRange();
            }
            if (!(this.concentration instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.concentration;
        }

        public boolean hasConcentrationRatioRange() {
            return this != null && this.concentration instanceof RatioRange;
        }

        public CodeableConcept getConcentrationCodeableConcept() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new CodeableConcept();
            }
            if (!(this.concentration instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.concentration;
        }

        public boolean hasConcentrationCodeableConcept() {
            return this != null && this.concentration instanceof CodeableConcept;
        }

        public Quantity getConcentrationQuantity() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new Quantity();
            }
            if (!(this.concentration instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (Quantity)this.concentration;
        }

        public boolean hasConcentrationQuantity() {
            return this != null && this.concentration instanceof Quantity;
        }

        public boolean hasConcentration() {
            return this.concentration != null && !this.concentration.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setConcentration(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof RatioRange || value instanceof CodeableConcept || value instanceof Quantity)) {
                throw new FHIRException("Not the right type for Ingredient.substance.strength.concentration[x]: " + value.fhirType());
            }
            this.concentration = value;
            return this;
        }

        public StringType getTextConcentrationElement() {
            if (this.textConcentration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.textConcentration");
                }
                if (Configuration.doAutoCreate()) {
                    this.textConcentration = new StringType();
                }
            }
            return this.textConcentration;
        }

        public boolean hasTextConcentrationElement() {
            return this.textConcentration != null && !this.textConcentration.isEmpty();
        }

        public boolean hasTextConcentration() {
            return this.textConcentration != null && !this.textConcentration.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setTextConcentrationElement(StringType value) {
            this.textConcentration = value;
            return this;
        }

        public String getTextConcentration() {
            return this.textConcentration == null ? null : (String)this.textConcentration.getValue();
        }

        public IngredientSubstanceStrengthComponent setTextConcentration(String value) {
            if (Utilities.noString((String)value)) {
                this.textConcentration = null;
            } else {
                if (this.textConcentration == null) {
                    this.textConcentration = new StringType();
                }
                this.textConcentration.setValue(value);
            }
            return this;
        }

        public CodeableConcept getBasis() {
            if (this.basis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.basis");
                }
                if (Configuration.doAutoCreate()) {
                    this.basis = new CodeableConcept();
                }
            }
            return this.basis;
        }

        public boolean hasBasis() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setBasis(CodeableConcept value) {
            this.basis = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public IngredientSubstanceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public IngredientSubstanceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public IngredientSubstanceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        public List<IngredientSubstanceStrengthReferenceStrengthComponent> getReferenceStrength() {
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
            }
            return this.referenceStrength;
        }

        public IngredientSubstanceStrengthComponent setReferenceStrength(List<IngredientSubstanceStrengthReferenceStrengthComponent> theReferenceStrength) {
            this.referenceStrength = theReferenceStrength;
            return this;
        }

        public boolean hasReferenceStrength() {
            if (this.referenceStrength == null) {
                return false;
            }
            for (IngredientSubstanceStrengthReferenceStrengthComponent item : this.referenceStrength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent addReferenceStrength() {
            IngredientSubstanceStrengthReferenceStrengthComponent t = new IngredientSubstanceStrengthReferenceStrengthComponent();
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return t;
        }

        public IngredientSubstanceStrengthComponent addReferenceStrength(IngredientSubstanceStrengthReferenceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return this;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent getReferenceStrengthFirstRep() {
            if (this.getReferenceStrength().isEmpty()) {
                this.addReferenceStrength();
            }
            return this.getReferenceStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("presentation[x]", "Ratio|RatioRange|CodeableConcept|Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation));
            children.add(new Property("textPresentation", "string", "A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio.", 0, 1, this.textPresentation));
            children.add(new Property("concentration[x]", "Ratio|RatioRange|CodeableConcept|Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration));
            children.add(new Property("textConcentration", "string", "A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio.", 0, 1, this.textConcentration));
            children.add(new Property("basis", "CodeableConcept", "A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt).", 0, 1, this.basis));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance. There are products where strength is measured at a particular point. For example, the strength of the ingredient in some inhalers is measured at a particular position relative to the point of aerosolization.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
            children.add(new Property("referenceStrength", "", "Strength expressed in terms of a reference substance. For when the ingredient strength is additionally expressed as equivalent to the strength of some other closely related substance (e.g. salt vs. base). Reference strength represents the strength (quantitative composition) of the active moiety of the active substance. There are situations when the active substance and active moiety are different, therefore both a strength and a reference strength are needed.", 0, Integer.MAX_VALUE, this.referenceStrength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1714280230: {
                    return new Property("presentation[x]", "Ratio|RatioRange|CodeableConcept|Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation);
                }
                case 696975130: {
                    return new Property("presentation[x]", "Ratio|RatioRange|CodeableConcept|Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation);
                }
                case -1853112047: {
                    return new Property("presentation[x]", "Ratio", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation);
                }
                case 643336876: {
                    return new Property("presentation[x]", "RatioRange", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation);
                }
                case 1095127335: {
                    return new Property("presentation[x]", "CodeableConcept", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation);
                }
                case -263057979: {
                    return new Property("presentation[x]", "Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. Unit of presentation refers to the quantity that the item occurs in e.g. a strength per tablet size, perhaps 'per 20mg' (the size of the tablet). It is not generally normalized as a unitary unit, which would be 'per mg').", 0, 1, this.presentation);
                }
                case -799720217: {
                    return new Property("textPresentation", "string", "A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio.", 0, 1, this.textPresentation);
                }
                case 1153502451: {
                    return new Property("concentration[x]", "Ratio|RatioRange|CodeableConcept|Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -410557331: {
                    return new Property("concentration[x]", "Ratio|RatioRange|CodeableConcept|Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case 405321630: {
                    return new Property("concentration[x]", "Ratio", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case 436249663: {
                    return new Property("concentration[x]", "RatioRange", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -90293388: {
                    return new Property("concentration[x]", "CodeableConcept", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case 71921688: {
                    return new Property("concentration[x]", "Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case 436527168: {
                    return new Property("textConcentration", "string", "A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio.", 0, 1, this.textConcentration);
                }
                case 93508670: {
                    return new Property("basis", "CodeableConcept", "A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt).", 0, 1, this.basis);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance. There are products where strength is measured at a particular point. For example, the strength of the ingredient in some inhalers is measured at a particular position relative to the point of aerosolization.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
                case 1943566508: {
                    return new Property("referenceStrength", "", "Strength expressed in terms of a reference substance. For when the ingredient strength is additionally expressed as equivalent to the strength of some other closely related substance (e.g. salt vs. base). Reference strength represents the strength (quantitative composition) of the active moiety of the active substance. There are situations when the active substance and active moiety are different, therefore both a strength and a reference strength are needed.", 0, Integer.MAX_VALUE, this.referenceStrength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    Base[] baseArray;
                    if (this.presentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.presentation;
                    }
                    return baseArray;
                }
                case -799720217: {
                    Base[] baseArray;
                    if (this.textPresentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.textPresentation;
                    }
                    return baseArray;
                }
                case -410557331: {
                    Base[] baseArray;
                    if (this.concentration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.concentration;
                    }
                    return baseArray;
                }
                case 436527168: {
                    Base[] baseArray;
                    if (this.textConcentration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.textConcentration;
                    }
                    return baseArray;
                }
                case 93508670: {
                    Base[] baseArray;
                    if (this.basis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.basis;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
                case 1943566508: {
                    return this.referenceStrength == null ? new Base[]{} : this.referenceStrength.toArray(new Base[this.referenceStrength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    this.presentation = TypeConvertor.castToType(value);
                    return value;
                }
                case -799720217: {
                    this.textPresentation = TypeConvertor.castToString(value);
                    return value;
                }
                case -410557331: {
                    this.concentration = TypeConvertor.castToType(value);
                    return value;
                }
                case 436527168: {
                    this.textConcentration = TypeConvertor.castToString(value);
                    return value;
                }
                case 93508670: {
                    this.basis = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = TypeConvertor.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1943566508: {
                    this.getReferenceStrength().add((IngredientSubstanceStrengthReferenceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("presentation[x]")) {
                this.presentation = TypeConvertor.castToType(value);
            } else if (name.equals("textPresentation")) {
                this.textPresentation = TypeConvertor.castToString(value);
            } else if (name.equals("concentration[x]")) {
                this.concentration = TypeConvertor.castToType(value);
            } else if (name.equals("textConcentration")) {
                this.textConcentration = TypeConvertor.castToString(value);
            } else if (name.equals("basis")) {
                this.basis = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = TypeConvertor.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("referenceStrength")) {
                this.getReferenceStrength().add((IngredientSubstanceStrengthReferenceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1714280230: {
                    return this.getPresentation();
                }
                case 696975130: {
                    return this.getPresentation();
                }
                case -799720217: {
                    return this.getTextPresentationElement();
                }
                case 1153502451: {
                    return this.getConcentration();
                }
                case -410557331: {
                    return this.getConcentration();
                }
                case 436527168: {
                    return this.getTextConcentrationElement();
                }
                case 93508670: {
                    return this.getBasis();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
                case 1943566508: {
                    return this.addReferenceStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    return new String[]{"Ratio", "RatioRange", "CodeableConcept", "Quantity"};
                }
                case -799720217: {
                    return new String[]{"string"};
                }
                case -410557331: {
                    return new String[]{"Ratio", "RatioRange", "CodeableConcept", "Quantity"};
                }
                case 436527168: {
                    return new String[]{"string"};
                }
                case 93508670: {
                    return new String[]{"CodeableConcept"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case 1943566508: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("presentationRatio")) {
                this.presentation = new Ratio();
                return this.presentation;
            }
            if (name.equals("presentationRatioRange")) {
                this.presentation = new RatioRange();
                return this.presentation;
            }
            if (name.equals("presentationCodeableConcept")) {
                this.presentation = new CodeableConcept();
                return this.presentation;
            }
            if (name.equals("presentationQuantity")) {
                this.presentation = new Quantity();
                return this.presentation;
            }
            if (name.equals("textPresentation")) {
                throw new FHIRException("Cannot call addChild on a singleton property Ingredient.substance.strength.textPresentation");
            }
            if (name.equals("concentrationRatio")) {
                this.concentration = new Ratio();
                return this.concentration;
            }
            if (name.equals("concentrationRatioRange")) {
                this.concentration = new RatioRange();
                return this.concentration;
            }
            if (name.equals("concentrationCodeableConcept")) {
                this.concentration = new CodeableConcept();
                return this.concentration;
            }
            if (name.equals("concentrationQuantity")) {
                this.concentration = new Quantity();
                return this.concentration;
            }
            if (name.equals("textConcentration")) {
                throw new FHIRException("Cannot call addChild on a singleton property Ingredient.substance.strength.textConcentration");
            }
            if (name.equals("basis")) {
                this.basis = new CodeableConcept();
                return this.basis;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property Ingredient.substance.strength.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            if (name.equals("referenceStrength")) {
                return this.addReferenceStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceStrengthComponent copy() {
            IngredientSubstanceStrengthComponent dst = new IngredientSubstanceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceStrengthComponent dst) {
            super.copyValues(dst);
            dst.presentation = this.presentation == null ? null : this.presentation.copy();
            dst.textPresentation = this.textPresentation == null ? null : this.textPresentation.copy();
            dst.concentration = this.concentration == null ? null : this.concentration.copy();
            dst.textConcentration = this.textConcentration == null ? null : this.textConcentration.copy();
            dst.basis = this.basis == null ? null : this.basis.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.country) {
                    dst.country.add(codeableConcept.copy());
                }
            }
            if (this.referenceStrength != null) {
                dst.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
                for (IngredientSubstanceStrengthReferenceStrengthComponent ingredientSubstanceStrengthReferenceStrengthComponent : this.referenceStrength) {
                    dst.referenceStrength.add(ingredientSubstanceStrengthReferenceStrengthComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthComponent o = (IngredientSubstanceStrengthComponent)other_;
            return IngredientSubstanceStrengthComponent.compareDeep(this.presentation, o.presentation, true) && IngredientSubstanceStrengthComponent.compareDeep(this.textPresentation, o.textPresentation, true) && IngredientSubstanceStrengthComponent.compareDeep(this.concentration, o.concentration, true) && IngredientSubstanceStrengthComponent.compareDeep(this.textConcentration, o.textConcentration, true) && IngredientSubstanceStrengthComponent.compareDeep(this.basis, o.basis, true) && IngredientSubstanceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && IngredientSubstanceStrengthComponent.compareDeep(this.country, o.country, true) && IngredientSubstanceStrengthComponent.compareDeep(this.referenceStrength, o.referenceStrength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthComponent o = (IngredientSubstanceStrengthComponent)other_;
            return IngredientSubstanceStrengthComponent.compareValues(this.textPresentation, o.textPresentation, true) && IngredientSubstanceStrengthComponent.compareValues(this.textConcentration, o.textConcentration, true) && IngredientSubstanceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.presentation, this.textPresentation, this.concentration, this.textConcentration, this.basis, this.measurementPoint, this.country, this.referenceStrength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance.strength";
        }
    }

    @Block
    public static class IngredientSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code or full resource that represents the ingredient substance", formalDefinition="A code or full resource that represents the ingredient's substance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
        protected CodeableReference code;
        @Child(name="strength", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of substance, per presentation, or per volume or mass, and type of quantity", formalDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. The allowed repetitions do not represent different strengths, but are different representations - mathematically equivalent - of a single strength.")
        protected List<IngredientSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = 538347209L;

        public IngredientSubstanceComponent() {
        }

        public IngredientSubstanceComponent(CodeableReference code) {
            this.setCode(code);
        }

        public CodeableReference getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableReference();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public IngredientSubstanceComponent setCode(CodeableReference value) {
            this.code = value;
            return this;
        }

        public List<IngredientSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public IngredientSubstanceComponent setStrength(List<IngredientSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (IngredientSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSubstanceStrengthComponent addStrength() {
            IngredientSubstanceStrengthComponent t = new IngredientSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public IngredientSubstanceComponent addStrength(IngredientSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public IngredientSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableReference(SubstanceDefinition)", "A code or full resource that represents the ingredient's substance.", 0, 1, this.code));
            children.add(new Property("strength", "", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. The allowed repetitions do not represent different strengths, but are different representations - mathematically equivalent - of a single strength.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableReference(SubstanceDefinition)", "A code or full resource that represents the ingredient's substance.", 0, 1, this.code);
                }
                case 1791316033: {
                    return new Property("strength", "", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. The allowed repetitions do not represent different strengths, but are different representations - mathematically equivalent - of a single strength.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((IngredientSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((IngredientSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableReference"};
                }
                case 1791316033: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableReference();
                return this.code;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceComponent copy() {
            IngredientSubstanceComponent dst = new IngredientSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceComponent dst) {
            super.copyValues(dst);
            CodeableReference codeableReference = dst.code = this.code == null ? null : this.code.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
                for (IngredientSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceComponent)) {
                return false;
            }
            IngredientSubstanceComponent o = (IngredientSubstanceComponent)other_;
            return IngredientSubstanceComponent.compareDeep(this.code, o.code, true) && IngredientSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceComponent)) {
                return false;
            }
            IngredientSubstanceComponent o = (IngredientSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.strength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance";
        }
    }

    @Block
    public static class IngredientManufacturerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="allowed | possible | actual", formalDefinition="The way in which this manufacturer is associated with the ingredient. For example whether it is a possible one (others allowed), or an exclusive authorized one for this ingredient. Note that this is not the manufacturing process role.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ingredient-manufacturer-role")
        protected Enumeration<IngredientManufacturerRole> role;
        @Child(name="manufacturer", type={Organization.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An organization that manufactures this ingredient", formalDefinition="An organization that manufactures this ingredient.")
        protected Reference manufacturer;
        private static final long serialVersionUID = -1226688097L;

        public IngredientManufacturerComponent() {
        }

        public IngredientManufacturerComponent(Reference manufacturer) {
            this.setManufacturer(manufacturer);
        }

        public Enumeration<IngredientManufacturerRole> getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientManufacturerComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Enumeration<IngredientManufacturerRole>(new IngredientManufacturerRoleEnumFactory());
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public IngredientManufacturerComponent setRoleElement(Enumeration<IngredientManufacturerRole> value) {
            this.role = value;
            return this;
        }

        public IngredientManufacturerRole getRole() {
            return this.role == null ? null : (IngredientManufacturerRole)((Object)this.role.getValue());
        }

        public IngredientManufacturerComponent setRole(IngredientManufacturerRole value) {
            if (value == null) {
                this.role = null;
            } else {
                if (this.role == null) {
                    this.role = new Enumeration<IngredientManufacturerRole>(new IngredientManufacturerRoleEnumFactory());
                }
                this.role.setValue((Object)value);
            }
            return this;
        }

        public Reference getManufacturer() {
            if (this.manufacturer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientManufacturerComponent.manufacturer");
                }
                if (Configuration.doAutoCreate()) {
                    this.manufacturer = new Reference();
                }
            }
            return this.manufacturer;
        }

        public boolean hasManufacturer() {
            return this.manufacturer != null && !this.manufacturer.isEmpty();
        }

        public IngredientManufacturerComponent setManufacturer(Reference value) {
            this.manufacturer = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Ingredient.SP_ROLE, "code", "The way in which this manufacturer is associated with the ingredient. For example whether it is a possible one (others allowed), or an exclusive authorized one for this ingredient. Note that this is not the manufacturing process role.", 0, 1, this.role));
            children.add(new Property(Ingredient.SP_MANUFACTURER, "Reference(Organization)", "An organization that manufactures this ingredient.", 0, 1, this.manufacturer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property(Ingredient.SP_ROLE, "code", "The way in which this manufacturer is associated with the ingredient. For example whether it is a possible one (others allowed), or an exclusive authorized one for this ingredient. Note that this is not the manufacturing process role.", 0, 1, this.role);
                }
                case -1969347631: {
                    return new Property(Ingredient.SP_MANUFACTURER, "Reference(Organization)", "An organization that manufactures this ingredient.", 0, 1, this.manufacturer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -1969347631: {
                    Base[] baseArray;
                    if (this.manufacturer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.manufacturer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    value = new IngredientManufacturerRoleEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.role = value;
                    return value;
                }
                case -1969347631: {
                    this.manufacturer = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Ingredient.SP_ROLE)) {
                value = new IngredientManufacturerRoleEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.role = value;
            } else if (name.equals(Ingredient.SP_MANUFACTURER)) {
                this.manufacturer = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRoleElement();
                }
                case -1969347631: {
                    return this.getManufacturer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"code"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Ingredient.SP_ROLE)) {
                throw new FHIRException("Cannot call addChild on a singleton property Ingredient.manufacturer.role");
            }
            if (name.equals(Ingredient.SP_MANUFACTURER)) {
                this.manufacturer = new Reference();
                return this.manufacturer;
            }
            return super.addChild(name);
        }

        @Override
        public IngredientManufacturerComponent copy() {
            IngredientManufacturerComponent dst = new IngredientManufacturerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientManufacturerComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientManufacturerComponent)) {
                return false;
            }
            IngredientManufacturerComponent o = (IngredientManufacturerComponent)other_;
            return IngredientManufacturerComponent.compareDeep(this.role, o.role, true) && IngredientManufacturerComponent.compareDeep(this.manufacturer, o.manufacturer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientManufacturerComponent)) {
                return false;
            }
            IngredientManufacturerComponent o = (IngredientManufacturerComponent)other_;
            return IngredientManufacturerComponent.compareValues(this.role, o.role, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.manufacturer});
        }

        @Override
        public String fhirType() {
            return "Ingredient.manufacturer";
        }
    }

    public static class IngredientManufacturerRoleEnumFactory
    implements EnumFactory<IngredientManufacturerRole> {
        @Override
        public IngredientManufacturerRole fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("allowed".equals(codeString)) {
                return IngredientManufacturerRole.ALLOWED;
            }
            if ("possible".equals(codeString)) {
                return IngredientManufacturerRole.POSSIBLE;
            }
            if ("actual".equals(codeString)) {
                return IngredientManufacturerRole.ACTUAL;
            }
            throw new IllegalArgumentException("Unknown IngredientManufacturerRole code '" + codeString + "'");
        }

        public Enumeration<IngredientManufacturerRole> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<IngredientManufacturerRole>(this, IngredientManufacturerRole.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<IngredientManufacturerRole>(this, IngredientManufacturerRole.NULL, code);
            }
            if ("allowed".equals(codeString)) {
                return new Enumeration<IngredientManufacturerRole>(this, IngredientManufacturerRole.ALLOWED, code);
            }
            if ("possible".equals(codeString)) {
                return new Enumeration<IngredientManufacturerRole>(this, IngredientManufacturerRole.POSSIBLE, code);
            }
            if ("actual".equals(codeString)) {
                return new Enumeration<IngredientManufacturerRole>(this, IngredientManufacturerRole.ACTUAL, code);
            }
            throw new FHIRException("Unknown IngredientManufacturerRole code '" + codeString + "'");
        }

        @Override
        public String toCode(IngredientManufacturerRole code) {
            if (code == IngredientManufacturerRole.ALLOWED) {
                return "allowed";
            }
            if (code == IngredientManufacturerRole.POSSIBLE) {
                return "possible";
            }
            if (code == IngredientManufacturerRole.ACTUAL) {
                return "actual";
            }
            return "?";
        }

        @Override
        public String toSystem(IngredientManufacturerRole code) {
            return code.getSystem();
        }
    }

    public static enum IngredientManufacturerRole {
        ALLOWED,
        POSSIBLE,
        ACTUAL,
        NULL;


        public static IngredientManufacturerRole fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("allowed".equals(codeString)) {
                return ALLOWED;
            }
            if ("possible".equals(codeString)) {
                return POSSIBLE;
            }
            if ("actual".equals(codeString)) {
                return ACTUAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown IngredientManufacturerRole code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ALLOWED: {
                    return "allowed";
                }
                case POSSIBLE: {
                    return "possible";
                }
                case ACTUAL: {
                    return "actual";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ALLOWED: {
                    return "http://hl7.org/fhir/ingredient-manufacturer-role";
                }
                case POSSIBLE: {
                    return "http://hl7.org/fhir/ingredient-manufacturer-role";
                }
                case ACTUAL: {
                    return "http://hl7.org/fhir/ingredient-manufacturer-role";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ALLOWED: {
                    return "";
                }
                case POSSIBLE: {
                    return "";
                }
                case ACTUAL: {
                    return "";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ALLOWED: {
                    return "Manufacturer is specifically allowed for this ingredient";
                }
                case POSSIBLE: {
                    return "Manufacturer is known to make this ingredient in general";
                }
                case ACTUAL: {
                    return "Manufacturer actually makes this particular ingredient";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

