/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;

@ResourceDef(name="NutritionIntake", profile="http://hl7.org/fhir/StructureDefinition/NutritionIntake")
public class NutritionIntake
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifiers associated with this Nutrition Intake that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="Instantiates FHIR protocol or definition.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="Instantiates external protocol or definition.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={NutritionOrder.class, CarePlan.class, ServiceRequest.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfils plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={NutritionIntake.class, Procedure.class, Observation.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", formalDefinition="A code representing the patient or other source's judgment about the state of the intake that this assertion is about.  Generally, this will be active or completed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<Enumerations.EventStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the NutritionIntake.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-status-reason")
    protected List<CodeableConcept> statusReason;
    @Child(name="code", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code representing an overall type of nutrition intake", formalDefinition="Overall type of nutrition intake.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diet-type")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is/was consuming the food or fluid", formalDefinition="The person, animal or group who is/was consuming the food or fluid.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter associated with NutritionIntake", formalDefinition="The encounter that establishes the context for this NutritionIntake.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date/time or interval when the food or fluid is/was consumed", formalDefinition="The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.")
    protected DataType occurrence;
    @Child(name="recorded", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the intake was recorded", formalDefinition="The date when the Nutrition Intake was asserted by the information source.")
    protected DateTimeType recorded;
    @Child(name="reported", type={BooleanType.class, Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Person or organization that provided the information about the consumption of this food or fluid", formalDefinition="The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.")
    protected DataType reported;
    @Child(name="consumedItem", type={}, order=13, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What food or fluid product or item was consumed", formalDefinition="What food or fluid product or item was consumed.")
    protected List<NutritionIntakeConsumedItemComponent> consumedItem;
    @Child(name="ingredientLabel", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Total nutrient for the whole meal, product, serving", formalDefinition="Total nutrient amounts for the whole meal, product, serving, etc.")
    protected List<NutritionIntakeIngredientLabelComponent> ingredientLabel;
    @Child(name="performer", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who was performed in the intake", formalDefinition="Who performed the intake and how they were involved.")
    protected List<NutritionIntakePerformerComponent> performer;
    @Child(name="location", type={Location.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the intake occurred", formalDefinition="Where the intake occurred.")
    protected Reference location;
    @Child(name="derivedFrom", type={Reference.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional supporting information", formalDefinition="Allows linking the NutritionIntake to the underlying NutritionOrder, or to other information, such as AllergyIntolerance, that supports or is used to derive the NutritionIntake.")
    protected List<Reference> derivedFrom;
    @Child(name="reason", type={CodeableReference.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for why the food or fluid is /was consumed", formalDefinition="A reason, Condition or observation for why the food or fluid is /was consumed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableReference> reason;
    @Child(name="note", type={Annotation.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Further information about the consumption", formalDefinition="Provides extra information about the Nutrition Intake that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 890692162L;
    @SearchParamDefinition(name="nutrition", path="NutritionIntake.consumedItem.nutritionProduct.concept", description="Return intakes for a specific consumed item", type="token")
    public static final String SP_NUTRITION = "nutrition";
    public static final TokenClientParam NUTRITION = new TokenClientParam("nutrition");
    @SearchParamDefinition(name="source", path="(NutritionIntake.reported as Reference)", description="Who or where the information in the statement came from", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("NutritionIntake:source").toLocked();
    @SearchParamDefinition(name="status", path="NutritionIntake.status", description="Return statements that match the given status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="NutritionIntake.subject", description="The identity of a patient, animal or group to list statements for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("NutritionIntake:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter | CarePlan.encounter | ChargeItem.encounter | Claim.item.encounter | ClinicalImpression.encounter | Communication.encounter | CommunicationRequest.encounter | Composition.encounter | Condition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | EncounterHistory.encounter | ExplanationOfBenefit.item.encounter | Flag.encounter | ImagingStudy.encounter | List.encounter | MedicationDispense.encounter | MedicationStatement.encounter | NutritionIntake.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | Provenance.encounter | QuestionnaireResponse.encounter | RequestOrchestration.encounter | RiskAssessment.encounter | ServiceRequest.encounter | Task.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent\r\n* [CarePlan](careplan.html): The Encounter during which this CarePlan was created\r\n* [ChargeItem](chargeitem.html): Encounter associated with event\r\n* [Claim](claim.html): Encounters associated with a billed line item\r\n* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created\r\n* [Communication](communication.html): The Encounter during which this Communication was created\r\n* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created\r\n* [Composition](composition.html): Context of the Composition\r\n* [Condition](condition.html): The Encounter during which this Condition was created\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values\r\n* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [ImagingStudy](imagingstudy.html): The context of the study\r\n* [List](list.html): Context in which list created\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [Provenance](provenance.html): Encounter related to the Provenance\r\n* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response\r\n* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [Task](task.html): Search by encounter\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("NutritionIntake:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("NutritionIntake:patient").toLocked();

    public NutritionIntake() {
    }

    public NutritionIntake(Enumerations.EventStatus status, Reference subject, NutritionIntakeConsumedItemComponent consumedItem) {
        this.setStatus(status);
        this.setSubject(subject);
        this.addConsumedItem(consumedItem);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public NutritionIntake setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public NutritionIntake addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public NutritionIntake setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public NutritionIntake addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public NutritionIntake setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public NutritionIntake addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public NutritionIntake setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public NutritionIntake addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public NutritionIntake setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public NutritionIntake addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<Enumerations.EventStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public NutritionIntake setStatusElement(Enumeration<Enumerations.EventStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.EventStatus getStatus() {
        return this.status == null ? null : (Enumerations.EventStatus)((Object)this.status.getValue());
    }

    public NutritionIntake setStatus(Enumerations.EventStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getStatusReason() {
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        return this.statusReason;
    }

    public NutritionIntake setStatusReason(List<CodeableConcept> theStatusReason) {
        this.statusReason = theStatusReason;
        return this;
    }

    public boolean hasStatusReason() {
        if (this.statusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.statusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return t;
    }

    public NutritionIntake addStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return this;
    }

    public CodeableConcept getStatusReasonFirstRep() {
        if (this.getStatusReason().isEmpty()) {
            this.addStatusReason();
        }
        return this.getStatusReason().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public NutritionIntake setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public NutritionIntake setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public NutritionIntake setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public NutritionIntake setOccurrence(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRException("Not the right type for NutritionIntake.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new DateTimeType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public NutritionIntake setRecordedElement(DateTimeType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public NutritionIntake setRecorded(Date value) {
        if (value == null) {
            this.recorded = null;
        } else {
            if (this.recorded == null) {
                this.recorded = new DateTimeType();
            }
            this.recorded.setValue(value);
        }
        return this;
    }

    public DataType getReported() {
        return this.reported;
    }

    public BooleanType getReportedBooleanType() throws FHIRException {
        if (this.reported == null) {
            this.reported = new BooleanType();
        }
        if (!(this.reported instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.reported.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.reported;
    }

    public boolean hasReportedBooleanType() {
        return this != null && this.reported instanceof BooleanType;
    }

    public Reference getReportedReference() throws FHIRException {
        if (this.reported == null) {
            this.reported = new Reference();
        }
        if (!(this.reported instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reported.getClass().getName() + " was encountered");
        }
        return (Reference)this.reported;
    }

    public boolean hasReportedReference() {
        return this != null && this.reported instanceof Reference;
    }

    public boolean hasReported() {
        return this.reported != null && !this.reported.isEmpty();
    }

    public NutritionIntake setReported(DataType value) {
        if (value != null && !(value instanceof BooleanType) && !(value instanceof Reference)) {
            throw new FHIRException("Not the right type for NutritionIntake.reported[x]: " + value.fhirType());
        }
        this.reported = value;
        return this;
    }

    public List<NutritionIntakeConsumedItemComponent> getConsumedItem() {
        if (this.consumedItem == null) {
            this.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
        }
        return this.consumedItem;
    }

    public NutritionIntake setConsumedItem(List<NutritionIntakeConsumedItemComponent> theConsumedItem) {
        this.consumedItem = theConsumedItem;
        return this;
    }

    public boolean hasConsumedItem() {
        if (this.consumedItem == null) {
            return false;
        }
        for (NutritionIntakeConsumedItemComponent item : this.consumedItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionIntakeConsumedItemComponent addConsumedItem() {
        NutritionIntakeConsumedItemComponent t = new NutritionIntakeConsumedItemComponent();
        if (this.consumedItem == null) {
            this.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
        }
        this.consumedItem.add(t);
        return t;
    }

    public NutritionIntake addConsumedItem(NutritionIntakeConsumedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.consumedItem == null) {
            this.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
        }
        this.consumedItem.add(t);
        return this;
    }

    public NutritionIntakeConsumedItemComponent getConsumedItemFirstRep() {
        if (this.getConsumedItem().isEmpty()) {
            this.addConsumedItem();
        }
        return this.getConsumedItem().get(0);
    }

    public List<NutritionIntakeIngredientLabelComponent> getIngredientLabel() {
        if (this.ingredientLabel == null) {
            this.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
        }
        return this.ingredientLabel;
    }

    public NutritionIntake setIngredientLabel(List<NutritionIntakeIngredientLabelComponent> theIngredientLabel) {
        this.ingredientLabel = theIngredientLabel;
        return this;
    }

    public boolean hasIngredientLabel() {
        if (this.ingredientLabel == null) {
            return false;
        }
        for (NutritionIntakeIngredientLabelComponent item : this.ingredientLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionIntakeIngredientLabelComponent addIngredientLabel() {
        NutritionIntakeIngredientLabelComponent t = new NutritionIntakeIngredientLabelComponent();
        if (this.ingredientLabel == null) {
            this.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
        }
        this.ingredientLabel.add(t);
        return t;
    }

    public NutritionIntake addIngredientLabel(NutritionIntakeIngredientLabelComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredientLabel == null) {
            this.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
        }
        this.ingredientLabel.add(t);
        return this;
    }

    public NutritionIntakeIngredientLabelComponent getIngredientLabelFirstRep() {
        if (this.getIngredientLabel().isEmpty()) {
            this.addIngredientLabel();
        }
        return this.getIngredientLabel().get(0);
    }

    public List<NutritionIntakePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<NutritionIntakePerformerComponent>();
        }
        return this.performer;
    }

    public NutritionIntake setPerformer(List<NutritionIntakePerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (NutritionIntakePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionIntakePerformerComponent addPerformer() {
        NutritionIntakePerformerComponent t = new NutritionIntakePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<NutritionIntakePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public NutritionIntake addPerformer(NutritionIntakePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<NutritionIntakePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public NutritionIntakePerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public NutritionIntake setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public NutritionIntake setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public NutritionIntake addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public NutritionIntake setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public NutritionIntake addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public NutritionIntake setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public NutritionIntake addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Nutrition Intake that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(ActivityDefinition|ChargeItemDefinition|ClinicalUseDefinition|EventDefinition|Measure|MessageDefinition|ObservationDefinition|OperationDefinition|PlanDefinition|Questionnaire|Requirements|SubscriptionTopic|TestPlan|TestScript)", "Instantiates FHIR protocol or definition.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "Instantiates external protocol or definition.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(NutritionOrder|CarePlan|ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(NutritionIntake|Procedure|Observation)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "A code representing the patient or other source's judgment about the state of the intake that this assertion is about.  Generally, this will be active or completed.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the NutritionIntake.", 0, Integer.MAX_VALUE, this.statusReason));
        children.add(new Property(SP_CODE, "CodeableConcept", "Overall type of nutrition intake.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was consuming the food or fluid.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this NutritionIntake.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.occurrence));
        children.add(new Property("recorded", "dateTime", "The date when the Nutrition Intake was asserted by the information source.", 0, 1, this.recorded));
        children.add(new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.reported));
        children.add(new Property("consumedItem", "", "What food or fluid product or item was consumed.", 0, Integer.MAX_VALUE, this.consumedItem));
        children.add(new Property("ingredientLabel", "", "Total nutrient amounts for the whole meal, product, serving, etc.", 0, Integer.MAX_VALUE, this.ingredientLabel));
        children.add(new Property("performer", "", "Who performed the intake and how they were involved.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("location", "Reference(Location)", "Where the intake occurred.", 0, 1, this.location));
        children.add(new Property("derivedFrom", "Reference(Any)", "Allows linking the NutritionIntake to the underlying NutritionOrder, or to other information, such as AllergyIntolerance, that supports or is used to derive the NutritionIntake.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "A reason, Condition or observation for why the food or fluid is /was consumed.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("note", "Annotation", "Provides extra information about the Nutrition Intake that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Nutrition Intake that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(ActivityDefinition|ChargeItemDefinition|ClinicalUseDefinition|EventDefinition|Measure|MessageDefinition|ObservationDefinition|OperationDefinition|PlanDefinition|Questionnaire|Requirements|SubscriptionTopic|TestPlan|TestScript)", "Instantiates FHIR protocol or definition.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "Instantiates external protocol or definition.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(NutritionOrder|CarePlan|ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(NutritionIntake|Procedure|Observation)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code representing the patient or other source's judgment about the state of the intake that this assertion is about.  Generally, this will be active or completed.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the NutritionIntake.", 0, Integer.MAX_VALUE, this.statusReason);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Overall type of nutrition intake.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was consuming the food or fluid.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this NutritionIntake.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.occurrence);
            }
            case -799233872: {
                return new Property("recorded", "dateTime", "The date when the Nutrition Intake was asserted by the information source.", 0, 1, this.recorded);
            }
            case -241505587: {
                return new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.reported);
            }
            case -427039533: {
                return new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.reported);
            }
            case 1219992533: {
                return new Property("reported[x]", "boolean", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.reported);
            }
            case 1198143416: {
                return new Property("reported[x]", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.reported);
            }
            case -854114533: {
                return new Property("consumedItem", "", "What food or fluid product or item was consumed.", 0, Integer.MAX_VALUE, this.consumedItem);
            }
            case -936536157: {
                return new Property("ingredientLabel", "", "Total nutrient amounts for the whole meal, product, serving, etc.", 0, Integer.MAX_VALUE, this.ingredientLabel);
            }
            case 481140686: {
                return new Property("performer", "", "Who performed the intake and how they were involved.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "Where the intake occurred.", 0, 1, this.location);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(Any)", "Allows linking the NutritionIntake to the underlying NutritionOrder, or to other information, such as AllergyIntolerance, that supports or is used to derive the NutritionIntake.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "A reason, Condition or observation for why the food or fluid is /was consumed.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides extra information about the Nutrition Intake that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.occurrence;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.recorded;
                }
                return baseArray;
            }
            case -427039533: {
                Base[] baseArray;
                if (this.reported == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.reported;
                }
                return baseArray;
            }
            case -854114533: {
                return this.consumedItem == null ? new Base[]{} : this.consumedItem.toArray(new Base[this.consumedItem.size()]);
            }
            case -936536157: {
                return this.ingredientLabel == null ? new Base[]{} : this.ingredientLabel.toArray(new Base[this.ingredientLabel.size()]);
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.location;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.EventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -427039533: {
                this.reported = TypeConvertor.castToType(value);
                return value;
            }
            case -854114533: {
                this.getConsumedItem().add((NutritionIntakeConsumedItemComponent)((Object)value));
                return value;
            }
            case -936536157: {
                this.getIngredientLabel().add((NutritionIntakeIngredientLabelComponent)((Object)value));
                return value;
            }
            case 481140686: {
                this.getPerformer().add((NutritionIntakePerformerComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.EventStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("recorded")) {
            this.recorded = TypeConvertor.castToDateTime(value);
        } else if (name.equals("reported[x]")) {
            this.reported = TypeConvertor.castToType(value);
        } else if (name.equals("consumedItem")) {
            this.getConsumedItem().add((NutritionIntakeConsumedItemComponent)((Object)value));
        } else if (name.equals("ingredientLabel")) {
            this.getIngredientLabel().add((NutritionIntakeIngredientLabelComponent)((Object)value));
        } else if (name.equals("performer")) {
            this.getPerformer().add((NutritionIntakePerformerComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.addStatusReason();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -241505587: {
                return this.getReported();
            }
            case -427039533: {
                return this.getReported();
            }
            case -854114533: {
                return this.addConsumedItem();
            }
            case -936536157: {
                return this.addIngredientLabel();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period"};
            }
            case -799233872: {
                return new String[]{"dateTime"};
            }
            case -427039533: {
                return new String[]{"boolean", "Reference"};
            }
            case -854114533: {
                return new String[0];
            }
            case -936536157: {
                return new String[0];
            }
            case 481140686: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionIntake.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionIntake.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionIntake.status");
        }
        if (name.equals("statusReason")) {
            return this.addStatusReason();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionIntake.recorded");
        }
        if (name.equals("reportedBoolean")) {
            this.reported = new BooleanType();
            return this.reported;
        }
        if (name.equals("reportedReference")) {
            this.reported = new Reference();
            return this.reported;
        }
        if (name.equals("consumedItem")) {
            return this.addConsumedItem();
        }
        if (name.equals("ingredientLabel")) {
            return this.addIngredientLabel();
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NutritionIntake";
    }

    @Override
    public NutritionIntake copy() {
        NutritionIntake dst = new NutritionIntake();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(NutritionIntake dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<Enumerations.EventStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusReason != null) {
            dst.statusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.statusReason) {
                dst.statusReason.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.recorded = this.recorded == null ? null : this.recorded.copy();
        DataType dataType = dst.reported = this.reported == null ? null : this.reported.copy();
        if (this.consumedItem != null) {
            dst.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
            for (NutritionIntakeConsumedItemComponent nutritionIntakeConsumedItemComponent : this.consumedItem) {
                dst.consumedItem.add(nutritionIntakeConsumedItemComponent.copy());
            }
        }
        if (this.ingredientLabel != null) {
            dst.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
            for (NutritionIntakeIngredientLabelComponent nutritionIntakeIngredientLabelComponent : this.ingredientLabel) {
                dst.ingredientLabel.add(nutritionIntakeIngredientLabelComponent.copy());
            }
        }
        if (this.performer != null) {
            dst.performer = new ArrayList<NutritionIntakePerformerComponent>();
            for (NutritionIntakePerformerComponent nutritionIntakePerformerComponent : this.performer) {
                dst.performer.add(nutritionIntakePerformerComponent.copy());
            }
        }
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference2 : this.derivedFrom) {
                dst.derivedFrom.add(reference2.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected NutritionIntake typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionIntake)) {
            return false;
        }
        NutritionIntake o = (NutritionIntake)other_;
        return NutritionIntake.compareDeep(this.identifier, o.identifier, true) && NutritionIntake.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && NutritionIntake.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && NutritionIntake.compareDeep(this.basedOn, o.basedOn, true) && NutritionIntake.compareDeep(this.partOf, o.partOf, true) && NutritionIntake.compareDeep(this.status, o.status, true) && NutritionIntake.compareDeep(this.statusReason, o.statusReason, true) && NutritionIntake.compareDeep(this.code, o.code, true) && NutritionIntake.compareDeep(this.subject, o.subject, true) && NutritionIntake.compareDeep(this.encounter, o.encounter, true) && NutritionIntake.compareDeep(this.occurrence, o.occurrence, true) && NutritionIntake.compareDeep(this.recorded, o.recorded, true) && NutritionIntake.compareDeep(this.reported, o.reported, true) && NutritionIntake.compareDeep(this.consumedItem, o.consumedItem, true) && NutritionIntake.compareDeep(this.ingredientLabel, o.ingredientLabel, true) && NutritionIntake.compareDeep(this.performer, o.performer, true) && NutritionIntake.compareDeep(this.location, o.location, true) && NutritionIntake.compareDeep(this.derivedFrom, o.derivedFrom, true) && NutritionIntake.compareDeep(this.reason, o.reason, true) && NutritionIntake.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionIntake)) {
            return false;
        }
        NutritionIntake o = (NutritionIntake)other_;
        return NutritionIntake.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && NutritionIntake.compareValues(this.instantiatesUri, o.instantiatesUri, true) && NutritionIntake.compareValues(this.status, o.status, true) && NutritionIntake.compareValues(this.recorded, o.recorded, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.partOf, this.status, this.statusReason, this.code, this.subject, this.encounter, this.occurrence, this.recorded, this.reported, this.consumedItem, this.ingredientLabel, this.performer, this.location, this.derivedFrom, this.reason, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NutritionIntake;
    }

    @Block
    public static class NutritionIntakePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of performer", formalDefinition="Type of performer.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who performed the intake", formalDefinition="Who performed the intake.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public NutritionIntakePerformerComponent() {
        }

        public NutritionIntakePerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakePerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public NutritionIntakePerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public NutritionIntakePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Type of performer.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Who performed the intake.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Type of performer.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Who performed the intake.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionIntakePerformerComponent copy() {
            NutritionIntakePerformerComponent dst = new NutritionIntakePerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionIntakePerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakePerformerComponent)) {
                return false;
            }
            NutritionIntakePerformerComponent o = (NutritionIntakePerformerComponent)other_;
            return NutritionIntakePerformerComponent.compareDeep(this.function, o.function, true) && NutritionIntakePerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakePerformerComponent)) {
                return false;
            }
            NutritionIntakePerformerComponent o = (NutritionIntakePerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "NutritionIntake.performer";
        }
    }

    @Block
    public static class NutritionIntakeIngredientLabelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="nutrient", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total nutrient consumed", formalDefinition="Total nutrient consumed. This could be a macronutrient (protein, fat, carbohydrate), or a vitamin and mineral.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutrient-code")
        protected CodeableReference nutrient;
        @Child(name="amount", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total amount of nutrient consumed", formalDefinition="Total amount of nutrient consumed.")
        protected Quantity amount;
        private static final long serialVersionUID = -193123424L;

        public NutritionIntakeIngredientLabelComponent() {
        }

        public NutritionIntakeIngredientLabelComponent(CodeableReference nutrient, Quantity amount) {
            this.setNutrient(nutrient);
            this.setAmount(amount);
        }

        public CodeableReference getNutrient() {
            if (this.nutrient == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeIngredientLabelComponent.nutrient");
                }
                if (Configuration.doAutoCreate()) {
                    this.nutrient = new CodeableReference();
                }
            }
            return this.nutrient;
        }

        public boolean hasNutrient() {
            return this.nutrient != null && !this.nutrient.isEmpty();
        }

        public NutritionIntakeIngredientLabelComponent setNutrient(CodeableReference value) {
            this.nutrient = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeIngredientLabelComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public NutritionIntakeIngredientLabelComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("nutrient", "CodeableReference(Substance)", "Total nutrient consumed. This could be a macronutrient (protein, fat, carbohydrate), or a vitamin and mineral.", 0, 1, this.nutrient));
            children.add(new Property("amount", "Quantity", "Total amount of nutrient consumed.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1671151641: {
                    return new Property("nutrient", "CodeableReference(Substance)", "Total nutrient consumed. This could be a macronutrient (protein, fat, carbohydrate), or a vitamin and mineral.", 0, 1, this.nutrient);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "Total amount of nutrient consumed.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    Base[] baseArray;
                    if (this.nutrient == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.nutrient;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    this.nutrient = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("nutrient")) {
                this.nutrient = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    return this.getNutrient();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    return new String[]{"CodeableReference"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nutrient")) {
                this.nutrient = new CodeableReference();
                return this.nutrient;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionIntakeIngredientLabelComponent copy() {
            NutritionIntakeIngredientLabelComponent dst = new NutritionIntakeIngredientLabelComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionIntakeIngredientLabelComponent dst) {
            super.copyValues(dst);
            dst.nutrient = this.nutrient == null ? null : this.nutrient.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeIngredientLabelComponent)) {
                return false;
            }
            NutritionIntakeIngredientLabelComponent o = (NutritionIntakeIngredientLabelComponent)other_;
            return NutritionIntakeIngredientLabelComponent.compareDeep(this.nutrient, o.nutrient, true) && NutritionIntakeIngredientLabelComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeIngredientLabelComponent)) {
                return false;
            }
            NutritionIntakeIngredientLabelComponent o = (NutritionIntakeIngredientLabelComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.nutrient, this.amount});
        }

        @Override
        public String fhirType() {
            return "NutritionIntake.ingredientLabel";
        }
    }

    @Block
    public static class NutritionIntakeConsumedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of food or fluid product", formalDefinition="Indicates what a category of item that was consumed: e.g., food, fluid, enteral, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/edible-substance-type")
        protected CodeableConcept type;
        @Child(name="nutritionProduct", type={CodeableReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code that identifies the food or fluid product that was consumed", formalDefinition="Identifies the food or fluid product that was consumed. This is potentially a link to a resource representing the details of the food product (TBD) or a simple attribute carrying a code that identifies the food from a known list of foods.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/food-type")
        protected CodeableReference nutritionProduct;
        @Child(name="schedule", type={Timing.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of consumption", formalDefinition="Scheduled frequency of consumption.")
        protected Timing schedule;
        @Child(name="amount", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the specified food", formalDefinition="Quantity of the specified food.")
        protected Quantity amount;
        @Child(name="rate", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rate at which enteral feeding was administered", formalDefinition="Rate at which enteral feeding was administered.")
        protected Quantity rate;
        @Child(name="notConsumed", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Flag to indicate if the food or fluid item was refused or otherwise not consumed", formalDefinition="Indicator when a patient is in a setting where it is helpful to know if food was not consumed, such as it was refused, held (as in tube feedings), or otherwise not provided. If a consumption is being recorded from an app, such as MyFitnessPal, this indicator will likely not be used.")
        protected BooleanType notConsumed;
        @Child(name="notConsumedReason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason food or fluid was not consumed", formalDefinition="Document the reason the food or fluid was not consumed, such as refused, held, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/not-consumed-reason")
        protected CodeableConcept notConsumedReason;
        private static final long serialVersionUID = -1625538068L;

        public NutritionIntakeConsumedItemComponent() {
        }

        public NutritionIntakeConsumedItemComponent(CodeableConcept type, CodeableReference nutritionProduct) {
            this.setType(type);
            this.setNutritionProduct(nutritionProduct);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableReference getNutritionProduct() {
            if (this.nutritionProduct == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.nutritionProduct");
                }
                if (Configuration.doAutoCreate()) {
                    this.nutritionProduct = new CodeableReference();
                }
            }
            return this.nutritionProduct;
        }

        public boolean hasNutritionProduct() {
            return this.nutritionProduct != null && !this.nutritionProduct.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setNutritionProduct(CodeableReference value) {
            this.nutritionProduct = value;
            return this;
        }

        public Timing getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new Timing();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setSchedule(Timing value) {
            this.schedule = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        public Quantity getRate() {
            if (this.rate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.rate");
                }
                if (Configuration.doAutoCreate()) {
                    this.rate = new Quantity();
                }
            }
            return this.rate;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setRate(Quantity value) {
            this.rate = value;
            return this;
        }

        public BooleanType getNotConsumedElement() {
            if (this.notConsumed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.notConsumed");
                }
                if (Configuration.doAutoCreate()) {
                    this.notConsumed = new BooleanType();
                }
            }
            return this.notConsumed;
        }

        public boolean hasNotConsumedElement() {
            return this.notConsumed != null && !this.notConsumed.isEmpty();
        }

        public boolean hasNotConsumed() {
            return this.notConsumed != null && !this.notConsumed.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setNotConsumedElement(BooleanType value) {
            this.notConsumed = value;
            return this;
        }

        public boolean getNotConsumed() {
            return this.notConsumed == null || this.notConsumed.isEmpty() ? false : (Boolean)this.notConsumed.getValue();
        }

        public NutritionIntakeConsumedItemComponent setNotConsumed(boolean value) {
            if (this.notConsumed == null) {
                this.notConsumed = new BooleanType();
            }
            this.notConsumed.setValue((Object)value);
            return this;
        }

        public CodeableConcept getNotConsumedReason() {
            if (this.notConsumedReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.notConsumedReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.notConsumedReason = new CodeableConcept();
                }
            }
            return this.notConsumedReason;
        }

        public boolean hasNotConsumedReason() {
            return this.notConsumedReason != null && !this.notConsumedReason.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setNotConsumedReason(CodeableConcept value) {
            this.notConsumedReason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Indicates what a category of item that was consumed: e.g., food, fluid, enteral, etc.", 0, 1, this.type));
            children.add(new Property("nutritionProduct", "CodeableReference(NutritionProduct)", "Identifies the food or fluid product that was consumed. This is potentially a link to a resource representing the details of the food product (TBD) or a simple attribute carrying a code that identifies the food from a known list of foods.", 0, 1, this.nutritionProduct));
            children.add(new Property("schedule", "Timing", "Scheduled frequency of consumption.", 0, 1, this.schedule));
            children.add(new Property("amount", "Quantity", "Quantity of the specified food.", 0, 1, this.amount));
            children.add(new Property("rate", "Quantity", "Rate at which enteral feeding was administered.", 0, 1, this.rate));
            children.add(new Property("notConsumed", "boolean", "Indicator when a patient is in a setting where it is helpful to know if food was not consumed, such as it was refused, held (as in tube feedings), or otherwise not provided. If a consumption is being recorded from an app, such as MyFitnessPal, this indicator will likely not be used.", 0, 1, this.notConsumed));
            children.add(new Property("notConsumedReason", "CodeableConcept", "Document the reason the food or fluid was not consumed, such as refused, held, etc.", 0, 1, this.notConsumedReason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Indicates what a category of item that was consumed: e.g., food, fluid, enteral, etc.", 0, 1, this.type);
                }
                case -1684132297: {
                    return new Property("nutritionProduct", "CodeableReference(NutritionProduct)", "Identifies the food or fluid product that was consumed. This is potentially a link to a resource representing the details of the food product (TBD) or a simple attribute carrying a code that identifies the food from a known list of foods.", 0, 1, this.nutritionProduct);
                }
                case -697920873: {
                    return new Property("schedule", "Timing", "Scheduled frequency of consumption.", 0, 1, this.schedule);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "Quantity of the specified food.", 0, 1, this.amount);
                }
                case 3493088: {
                    return new Property("rate", "Quantity", "Rate at which enteral feeding was administered.", 0, 1, this.rate);
                }
                case -148762661: {
                    return new Property("notConsumed", "boolean", "Indicator when a patient is in a setting where it is helpful to know if food was not consumed, such as it was refused, held (as in tube feedings), or otherwise not provided. If a consumption is being recorded from an app, such as MyFitnessPal, this indicator will likely not be used.", 0, 1, this.notConsumed);
                }
                case -440795649: {
                    return new Property("notConsumedReason", "CodeableConcept", "Document the reason the food or fluid was not consumed, such as refused, held, etc.", 0, 1, this.notConsumedReason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1684132297: {
                    Base[] baseArray;
                    if (this.nutritionProduct == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.nutritionProduct;
                    }
                    return baseArray;
                }
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.schedule;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.rate;
                    }
                    return baseArray;
                }
                case -148762661: {
                    Base[] baseArray;
                    if (this.notConsumed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.notConsumed;
                    }
                    return baseArray;
                }
                case -440795649: {
                    Base[] baseArray;
                    if (this.notConsumedReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.notConsumedReason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1684132297: {
                    this.nutritionProduct = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -697920873: {
                    this.schedule = TypeConvertor.castToTiming(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3493088: {
                    this.rate = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -148762661: {
                    this.notConsumed = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -440795649: {
                    this.notConsumedReason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("nutritionProduct")) {
                this.nutritionProduct = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("schedule")) {
                this.schedule = TypeConvertor.castToTiming(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToQuantity(value);
            } else if (name.equals("rate")) {
                this.rate = TypeConvertor.castToQuantity(value);
            } else if (name.equals("notConsumed")) {
                this.notConsumed = TypeConvertor.castToBoolean(value);
            } else if (name.equals("notConsumedReason")) {
                this.notConsumedReason = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1684132297: {
                    return this.getNutritionProduct();
                }
                case -697920873: {
                    return this.getSchedule();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 3493088: {
                    return this.getRate();
                }
                case -148762661: {
                    return this.getNotConsumedElement();
                }
                case -440795649: {
                    return this.getNotConsumedReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1684132297: {
                    return new String[]{"CodeableReference"};
                }
                case -697920873: {
                    return new String[]{"Timing"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
                case 3493088: {
                    return new String[]{"Quantity"};
                }
                case -148762661: {
                    return new String[]{"boolean"};
                }
                case -440795649: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("nutritionProduct")) {
                this.nutritionProduct = new CodeableReference();
                return this.nutritionProduct;
            }
            if (name.equals("schedule")) {
                this.schedule = new Timing();
                return this.schedule;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("rate")) {
                this.rate = new Quantity();
                return this.rate;
            }
            if (name.equals("notConsumed")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionIntake.consumedItem.notConsumed");
            }
            if (name.equals("notConsumedReason")) {
                this.notConsumedReason = new CodeableConcept();
                return this.notConsumedReason;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionIntakeConsumedItemComponent copy() {
            NutritionIntakeConsumedItemComponent dst = new NutritionIntakeConsumedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionIntakeConsumedItemComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.nutritionProduct = this.nutritionProduct == null ? null : this.nutritionProduct.copy();
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            dst.notConsumed = this.notConsumed == null ? null : this.notConsumed.copy();
            dst.notConsumedReason = this.notConsumedReason == null ? null : this.notConsumedReason.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeConsumedItemComponent)) {
                return false;
            }
            NutritionIntakeConsumedItemComponent o = (NutritionIntakeConsumedItemComponent)other_;
            return NutritionIntakeConsumedItemComponent.compareDeep(this.type, o.type, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.nutritionProduct, o.nutritionProduct, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.schedule, o.schedule, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.amount, o.amount, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.rate, o.rate, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.notConsumed, o.notConsumed, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.notConsumedReason, o.notConsumedReason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeConsumedItemComponent)) {
                return false;
            }
            NutritionIntakeConsumedItemComponent o = (NutritionIntakeConsumedItemComponent)other_;
            return NutritionIntakeConsumedItemComponent.compareValues(this.notConsumed, o.notConsumed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.nutritionProduct, this.schedule, this.amount, this.rate, this.notConsumed, this.notConsumedReason});
        }

        @Override
        public String fhirType() {
            return "NutritionIntake.consumedItem";
        }
    }
}

