/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="Permission", profile="http://hl7.org/fhir/StructureDefinition/Permission")
public class Permission
extends DomainResource {
    @Child(name="status", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="active | entered-in-error | draft | rejected", formalDefinition="Status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/permission-status")
    protected Enumeration<PermissionStatus> status;
    @Child(name="asserter", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, RelatedPerson.class, HealthcareService.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person or entity that asserts the permission", formalDefinition="The person or entity that asserts the permission.")
    protected Reference asserter;
    @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The date that permission was asserted", formalDefinition="The date that permission was asserted.")
    protected List<DateTimeType> date;
    @Child(name="validity", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period in which the permission is active", formalDefinition="The period in which the permission is active.")
    protected Period validity;
    @Child(name="justification", type={}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The asserted justification for using the data", formalDefinition="The asserted justification for using the data.")
    protected PermissionJustificationComponent justification;
    @Child(name="combining", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="deny-overrides | permit-overrides | ordered-deny-overrides | ordered-permit-overrides | deny-unless-permit | permit-unless-deny", formalDefinition="Defines a procedure for arriving at an access decision given the set of rules.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/permission-rule-combining")
    protected Enumeration<PermissionRuleCombining> combining;
    @Child(name="rule", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Constraints to the Permission", formalDefinition="A set of rules.")
    protected List<RuleComponent> rule;
    private static final long serialVersionUID = 1252321973L;
    @SearchParamDefinition(name="status", path="Permission.status", description="active | entered-in-error | draft | rejected", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Permission() {
    }

    public Permission(PermissionStatus status, PermissionRuleCombining combining) {
        this.setStatus(status);
        this.setCombining(combining);
    }

    public Enumeration<PermissionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<PermissionStatus>(new PermissionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Permission setStatusElement(Enumeration<PermissionStatus> value) {
        this.status = value;
        return this;
    }

    public PermissionStatus getStatus() {
        return this.status == null ? null : (PermissionStatus)((Object)this.status.getValue());
    }

    public Permission setStatus(PermissionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<PermissionStatus>(new PermissionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getAsserter() {
        if (this.asserter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.asserter");
            }
            if (Configuration.doAutoCreate()) {
                this.asserter = new Reference();
            }
        }
        return this.asserter;
    }

    public boolean hasAsserter() {
        return this.asserter != null && !this.asserter.isEmpty();
    }

    public Permission setAsserter(Reference value) {
        this.asserter = value;
        return this;
    }

    public List<DateTimeType> getDate() {
        if (this.date == null) {
            this.date = new ArrayList<DateTimeType>();
        }
        return this.date;
    }

    public Permission setDate(List<DateTimeType> theDate) {
        this.date = theDate;
        return this;
    }

    public boolean hasDate() {
        if (this.date == null) {
            return false;
        }
        for (DateTimeType item : this.date) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DateTimeType addDateElement() {
        DateTimeType t = new DateTimeType();
        if (this.date == null) {
            this.date = new ArrayList<DateTimeType>();
        }
        this.date.add(t);
        return t;
    }

    public Permission addDate(Date value) {
        DateTimeType t = new DateTimeType();
        t.setValue(value);
        if (this.date == null) {
            this.date = new ArrayList<DateTimeType>();
        }
        this.date.add(t);
        return this;
    }

    public boolean hasDate(Date value) {
        if (this.date == null) {
            return false;
        }
        for (DateTimeType v : this.date) {
            if (!((Date)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getValidity() {
        if (this.validity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.validity");
            }
            if (Configuration.doAutoCreate()) {
                this.validity = new Period();
            }
        }
        return this.validity;
    }

    public boolean hasValidity() {
        return this.validity != null && !this.validity.isEmpty();
    }

    public Permission setValidity(Period value) {
        this.validity = value;
        return this;
    }

    public PermissionJustificationComponent getJustification() {
        if (this.justification == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.justification");
            }
            if (Configuration.doAutoCreate()) {
                this.justification = new PermissionJustificationComponent();
            }
        }
        return this.justification;
    }

    public boolean hasJustification() {
        return this.justification != null && !this.justification.isEmpty();
    }

    public Permission setJustification(PermissionJustificationComponent value) {
        this.justification = value;
        return this;
    }

    public Enumeration<PermissionRuleCombining> getCombiningElement() {
        if (this.combining == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.combining");
            }
            if (Configuration.doAutoCreate()) {
                this.combining = new Enumeration<PermissionRuleCombining>(new PermissionRuleCombiningEnumFactory());
            }
        }
        return this.combining;
    }

    public boolean hasCombiningElement() {
        return this.combining != null && !this.combining.isEmpty();
    }

    public boolean hasCombining() {
        return this.combining != null && !this.combining.isEmpty();
    }

    public Permission setCombiningElement(Enumeration<PermissionRuleCombining> value) {
        this.combining = value;
        return this;
    }

    public PermissionRuleCombining getCombining() {
        return this.combining == null ? null : (PermissionRuleCombining)((Object)this.combining.getValue());
    }

    public Permission setCombining(PermissionRuleCombining value) {
        if (this.combining == null) {
            this.combining = new Enumeration<PermissionRuleCombining>(new PermissionRuleCombiningEnumFactory());
        }
        this.combining.setValue((Object)value);
        return this;
    }

    public List<RuleComponent> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<RuleComponent>();
        }
        return this.rule;
    }

    public Permission setRule(List<RuleComponent> theRule) {
        this.rule = theRule;
        return this;
    }

    public boolean hasRule() {
        if (this.rule == null) {
            return false;
        }
        for (RuleComponent item : this.rule) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RuleComponent addRule() {
        RuleComponent t = new RuleComponent();
        if (this.rule == null) {
            this.rule = new ArrayList<RuleComponent>();
        }
        this.rule.add(t);
        return t;
    }

    public Permission addRule(RuleComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rule == null) {
            this.rule = new ArrayList<RuleComponent>();
        }
        this.rule.add(t);
        return this;
    }

    public RuleComponent getRuleFirstRep() {
        if (this.getRule().isEmpty()) {
            this.addRule();
        }
        return this.getRule().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_STATUS, "code", "Status.", 0, 1, this.status));
        children.add(new Property("asserter", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|RelatedPerson|HealthcareService)", "The person or entity that asserts the permission.", 0, 1, this.asserter));
        children.add(new Property("date", "dateTime", "The date that permission was asserted.", 0, Integer.MAX_VALUE, this.date));
        children.add(new Property("validity", "Period", "The period in which the permission is active.", 0, 1, this.validity));
        children.add(new Property("justification", "", "The asserted justification for using the data.", 0, 1, this.justification));
        children.add(new Property("combining", "code", "Defines a procedure for arriving at an access decision given the set of rules.", 0, 1, this.combining));
        children.add(new Property("rule", "", "A set of rules.", 0, Integer.MAX_VALUE, this.rule));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -892481550: {
                return new Property(SP_STATUS, "code", "Status.", 0, 1, this.status);
            }
            case -373242253: {
                return new Property("asserter", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|RelatedPerson|HealthcareService)", "The person or entity that asserts the permission.", 0, 1, this.asserter);
            }
            case 3076014: {
                return new Property("date", "dateTime", "The date that permission was asserted.", 0, Integer.MAX_VALUE, this.date);
            }
            case -1421265102: {
                return new Property("validity", "Period", "The period in which the permission is active.", 0, 1, this.validity);
            }
            case 1864993522: {
                return new Property("justification", "", "The asserted justification for using the data.", 0, 1, this.justification);
            }
            case -1806252484: {
                return new Property("combining", "code", "Defines a procedure for arriving at an access decision given the set of rules.", 0, 1, this.combining);
            }
            case 3512060: {
                return new Property("rule", "", "A set of rules.", 0, Integer.MAX_VALUE, this.rule);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -373242253: {
                Base[] baseArray;
                if (this.asserter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.asserter;
                }
                return baseArray;
            }
            case 3076014: {
                return this.date == null ? new Base[]{} : this.date.toArray(new Base[this.date.size()]);
            }
            case -1421265102: {
                Base[] baseArray;
                if (this.validity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.validity;
                }
                return baseArray;
            }
            case 1864993522: {
                Base[] baseArray;
                if (this.justification == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.justification;
                }
                return baseArray;
            }
            case -1806252484: {
                Base[] baseArray;
                if (this.combining == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.combining;
                }
                return baseArray;
            }
            case 3512060: {
                return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -892481550: {
                value = new PermissionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -373242253: {
                this.asserter = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.getDate().add(TypeConvertor.castToDateTime(value));
                return value;
            }
            case -1421265102: {
                this.validity = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1864993522: {
                this.justification = (PermissionJustificationComponent)((Object)value);
                return value;
            }
            case -1806252484: {
                value = new PermissionRuleCombiningEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.combining = value;
                return value;
            }
            case 3512060: {
                this.getRule().add((RuleComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            value = new PermissionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("asserter")) {
            this.asserter = TypeConvertor.castToReference(value);
        } else if (name.equals("date")) {
            this.getDate().add(TypeConvertor.castToDateTime(value));
        } else if (name.equals("validity")) {
            this.validity = TypeConvertor.castToPeriod(value);
        } else if (name.equals("justification")) {
            this.justification = (PermissionJustificationComponent)((Object)value);
        } else if (name.equals("combining")) {
            value = new PermissionRuleCombiningEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.combining = value;
        } else if (name.equals("rule")) {
            this.getRule().add((RuleComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return this.getStatusElement();
            }
            case -373242253: {
                return this.getAsserter();
            }
            case 3076014: {
                return this.addDateElement();
            }
            case -1421265102: {
                return this.getValidity();
            }
            case 1864993522: {
                return this.getJustification();
            }
            case -1806252484: {
                return this.getCombiningElement();
            }
            case 3512060: {
                return this.addRule();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return new String[]{"code"};
            }
            case -373242253: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -1421265102: {
                return new String[]{"Period"};
            }
            case 1864993522: {
                return new String[0];
            }
            case -1806252484: {
                return new String[]{"code"};
            }
            case 3512060: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Permission.status");
        }
        if (name.equals("asserter")) {
            this.asserter = new Reference();
            return this.asserter;
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a singleton property Permission.date");
        }
        if (name.equals("validity")) {
            this.validity = new Period();
            return this.validity;
        }
        if (name.equals("justification")) {
            this.justification = new PermissionJustificationComponent();
            return this.justification;
        }
        if (name.equals("combining")) {
            throw new FHIRException("Cannot call addChild on a singleton property Permission.combining");
        }
        if (name.equals("rule")) {
            return this.addRule();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Permission";
    }

    @Override
    public Permission copy() {
        Permission dst = new Permission();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Permission dst) {
        super.copyValues(dst);
        dst.status = this.status == null ? null : this.status.copy();
        Reference reference = dst.asserter = this.asserter == null ? null : this.asserter.copy();
        if (this.date != null) {
            dst.date = new ArrayList<DateTimeType>();
            for (DateTimeType dateTimeType : this.date) {
                dst.date.add(dateTimeType.copy());
            }
        }
        dst.validity = this.validity == null ? null : this.validity.copy();
        dst.justification = this.justification == null ? null : this.justification.copy();
        Enumeration<PermissionRuleCombining> enumeration = dst.combining = this.combining == null ? null : this.combining.copy();
        if (this.rule != null) {
            dst.rule = new ArrayList<RuleComponent>();
            for (RuleComponent ruleComponent : this.rule) {
                dst.rule.add(ruleComponent.copy());
            }
        }
    }

    protected Permission typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Permission)) {
            return false;
        }
        Permission o = (Permission)other_;
        return Permission.compareDeep(this.status, o.status, true) && Permission.compareDeep(this.asserter, o.asserter, true) && Permission.compareDeep(this.date, o.date, true) && Permission.compareDeep(this.validity, o.validity, true) && Permission.compareDeep(this.justification, o.justification, true) && Permission.compareDeep(this.combining, o.combining, true) && Permission.compareDeep(this.rule, o.rule, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Permission)) {
            return false;
        }
        Permission o = (Permission)other_;
        return Permission.compareValues(this.status, o.status, true) && Permission.compareValues(this.date, o.date, true) && Permission.compareValues(this.combining, o.combining, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.status, this.asserter, this.date, this.validity, this.justification, this.combining, this.rule});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Permission;
    }

    @Block
    public static class RuleActivityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actor", type={Device.class, Group.class, CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Authorized actor(s)", formalDefinition="The actor(s) authorized for the defined activity.")
        protected List<Reference> actor;
        @Child(name="action", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Actions controlled by this rule", formalDefinition="Actions controlled by this Rule.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-action")
        protected List<CodeableConcept> action;
        @Child(name="purpose", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The purpose for which the permission is given", formalDefinition="The purpose for which the permission is given.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected List<CodeableConcept> purpose;
        private static final long serialVersionUID = 1403721720L;

        public List<Reference> getActor() {
            if (this.actor == null) {
                this.actor = new ArrayList<Reference>();
            }
            return this.actor;
        }

        public RuleActivityComponent setActor(List<Reference> theActor) {
            this.actor = theActor;
            return this;
        }

        public boolean hasActor() {
            if (this.actor == null) {
                return false;
            }
            for (Reference item : this.actor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addActor() {
            Reference t = new Reference();
            if (this.actor == null) {
                this.actor = new ArrayList<Reference>();
            }
            this.actor.add(t);
            return t;
        }

        public RuleActivityComponent addActor(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.actor == null) {
                this.actor = new ArrayList<Reference>();
            }
            this.actor.add(t);
            return this;
        }

        public Reference getActorFirstRep() {
            if (this.getActor().isEmpty()) {
                this.addActor();
            }
            return this.getActor().get(0);
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public RuleActivityComponent setAction(List<CodeableConcept> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public RuleActivityComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public CodeableConcept getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<CodeableConcept> getPurpose() {
            if (this.purpose == null) {
                this.purpose = new ArrayList<CodeableConcept>();
            }
            return this.purpose;
        }

        public RuleActivityComponent setPurpose(List<CodeableConcept> thePurpose) {
            this.purpose = thePurpose;
            return this;
        }

        public boolean hasPurpose() {
            if (this.purpose == null) {
                return false;
            }
            for (CodeableConcept item : this.purpose) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPurpose() {
            CodeableConcept t = new CodeableConcept();
            if (this.purpose == null) {
                this.purpose = new ArrayList<CodeableConcept>();
            }
            this.purpose.add(t);
            return t;
        }

        public RuleActivityComponent addPurpose(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.purpose == null) {
                this.purpose = new ArrayList<CodeableConcept>();
            }
            this.purpose.add(t);
            return this;
        }

        public CodeableConcept getPurposeFirstRep() {
            if (this.getPurpose().isEmpty()) {
                this.addPurpose();
            }
            return this.getPurpose().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actor", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The actor(s) authorized for the defined activity.", 0, Integer.MAX_VALUE, this.actor));
            children.add(new Property("action", "CodeableConcept", "Actions controlled by this Rule.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("purpose", "CodeableConcept", "The purpose for which the permission is given.", 0, Integer.MAX_VALUE, this.purpose));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92645877: {
                    return new Property("actor", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The actor(s) authorized for the defined activity.", 0, Integer.MAX_VALUE, this.actor);
                }
                case -1422950858: {
                    return new Property("action", "CodeableConcept", "Actions controlled by this Rule.", 0, Integer.MAX_VALUE, this.action);
                }
                case -220463842: {
                    return new Property("purpose", "CodeableConcept", "The purpose for which the permission is given.", 0, Integer.MAX_VALUE, this.purpose);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case -220463842: {
                    return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    this.getActor().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -220463842: {
                    this.getPurpose().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actor")) {
                this.getActor().add(TypeConvertor.castToReference(value));
            } else if (name.equals("action")) {
                this.getAction().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("purpose")) {
                this.getPurpose().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.addActor();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case -220463842: {
                    return this.addPurpose();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case -220463842: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actor")) {
                return this.addActor();
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            if (name.equals("purpose")) {
                return this.addPurpose();
            }
            return super.addChild(name);
        }

        @Override
        public RuleActivityComponent copy() {
            RuleActivityComponent dst = new RuleActivityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RuleActivityComponent dst) {
            super.copyValues(dst);
            if (this.actor != null) {
                dst.actor = new ArrayList<Reference>();
                for (Reference reference : this.actor) {
                    dst.actor.add(reference.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.action) {
                    dst.action.add(codeableConcept.copy());
                }
            }
            if (this.purpose != null) {
                dst.purpose = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.purpose) {
                    dst.purpose.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleActivityComponent)) {
                return false;
            }
            RuleActivityComponent o = (RuleActivityComponent)other_;
            return RuleActivityComponent.compareDeep(this.actor, o.actor, true) && RuleActivityComponent.compareDeep(this.action, o.action, true) && RuleActivityComponent.compareDeep(this.purpose, o.purpose, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleActivityComponent)) {
                return false;
            }
            RuleActivityComponent o = (RuleActivityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.actor, this.action, this.purpose});
        }

        @Override
        public String fhirType() {
            return "Permission.rule.activity";
        }
    }

    @Block
    public static class RuleDataResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="meaning", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="instance | related | dependents | authoredby", formalDefinition="How the resource reference is interpreted when testing consent restrictions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning")
        protected Enumeration<Enumerations.ConsentDataMeaning> meaning;
        @Child(name="reference", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual data reference", formalDefinition="A reference to a specific resource that defines which resources are covered by this consent.")
        protected Reference reference;
        private static final long serialVersionUID = 1735979153L;

        public RuleDataResourceComponent() {
        }

        public RuleDataResourceComponent(Enumerations.ConsentDataMeaning meaning, Reference reference) {
            this.setMeaning(meaning);
            this.setReference(reference);
        }

        public Enumeration<Enumerations.ConsentDataMeaning> getMeaningElement() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RuleDataResourceComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new Enumeration<Enumerations.ConsentDataMeaning>(new Enumerations.ConsentDataMeaningEnumFactory());
                }
            }
            return this.meaning;
        }

        public boolean hasMeaningElement() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public RuleDataResourceComponent setMeaningElement(Enumeration<Enumerations.ConsentDataMeaning> value) {
            this.meaning = value;
            return this;
        }

        public Enumerations.ConsentDataMeaning getMeaning() {
            return this.meaning == null ? null : (Enumerations.ConsentDataMeaning)((Object)this.meaning.getValue());
        }

        public RuleDataResourceComponent setMeaning(Enumerations.ConsentDataMeaning value) {
            if (this.meaning == null) {
                this.meaning = new Enumeration<Enumerations.ConsentDataMeaning>(new Enumerations.ConsentDataMeaningEnumFactory());
            }
            this.meaning.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RuleDataResourceComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public RuleDataResourceComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning));
            children.add(new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938160637: {
                    return new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    Base[] baseArray;
                    if (this.meaning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.meaning;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    value = new Enumerations.ConsentDataMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.meaning = value;
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("meaning")) {
                value = new Enumerations.ConsentDataMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.meaning = value;
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return this.getMeaningElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("meaning")) {
                throw new FHIRException("Cannot call addChild on a singleton property Permission.rule.data.resource.meaning");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public RuleDataResourceComponent copy() {
            RuleDataResourceComponent dst = new RuleDataResourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RuleDataResourceComponent dst) {
            super.copyValues(dst);
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleDataResourceComponent)) {
                return false;
            }
            RuleDataResourceComponent o = (RuleDataResourceComponent)other_;
            return RuleDataResourceComponent.compareDeep(this.meaning, o.meaning, true) && RuleDataResourceComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleDataResourceComponent)) {
                return false;
            }
            RuleDataResourceComponent o = (RuleDataResourceComponent)other_;
            return RuleDataResourceComponent.compareValues(this.meaning, o.meaning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.reference});
        }

        @Override
        public String fhirType() {
            return "Permission.rule.data.resource";
        }
    }

    @Block
    public static class RuleDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resource", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Explicit FHIR Resource references", formalDefinition="Explicit FHIR Resource references.")
        protected List<RuleDataResourceComponent> resource;
        @Child(name="security", type={Coding.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Security tag code on .meta.security", formalDefinition="The data in scope are those with the given codes present in that data .meta.security element.")
        protected List<Coding> security;
        @Child(name="period", type={Period.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe encompasing data create/update", formalDefinition="Clinical or Operational Relevant period of time that bounds the data controlled by this rule.")
        protected List<Period> period;
        @Child(name="expression", type={Expression.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Expression identifying the data", formalDefinition="Used when other data selection elements are insufficient.")
        protected Expression expression;
        private static final long serialVersionUID = -774403139L;

        public List<RuleDataResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<RuleDataResourceComponent>();
            }
            return this.resource;
        }

        public RuleDataComponent setResource(List<RuleDataResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (RuleDataResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RuleDataResourceComponent addResource() {
            RuleDataResourceComponent t = new RuleDataResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<RuleDataResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public RuleDataComponent addResource(RuleDataResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<RuleDataResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public RuleDataResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<Coding> getSecurity() {
            if (this.security == null) {
                this.security = new ArrayList<Coding>();
            }
            return this.security;
        }

        public RuleDataComponent setSecurity(List<Coding> theSecurity) {
            this.security = theSecurity;
            return this;
        }

        public boolean hasSecurity() {
            if (this.security == null) {
                return false;
            }
            for (Coding item : this.security) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurity() {
            Coding t = new Coding();
            if (this.security == null) {
                this.security = new ArrayList<Coding>();
            }
            this.security.add(t);
            return t;
        }

        public RuleDataComponent addSecurity(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.security == null) {
                this.security = new ArrayList<Coding>();
            }
            this.security.add(t);
            return this;
        }

        public Coding getSecurityFirstRep() {
            if (this.getSecurity().isEmpty()) {
                this.addSecurity();
            }
            return this.getSecurity().get(0);
        }

        public List<Period> getPeriod() {
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            return this.period;
        }

        public RuleDataComponent setPeriod(List<Period> thePeriod) {
            this.period = thePeriod;
            return this;
        }

        public boolean hasPeriod() {
            if (this.period == null) {
                return false;
            }
            for (Period item : this.period) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Period addPeriod() {
            Period t = new Period();
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            this.period.add(t);
            return t;
        }

        public RuleDataComponent addPeriod(Period t) {
            if (t == null) {
                return this;
            }
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            this.period.add(t);
            return this;
        }

        public Period getPeriodFirstRep() {
            if (this.getPeriod().isEmpty()) {
                this.addPeriod();
            }
            return this.getPeriod().get(0);
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RuleDataComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public RuleDataComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("resource", "", "Explicit FHIR Resource references.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("security", "Coding", "The data in scope are those with the given codes present in that data .meta.security element.", 0, Integer.MAX_VALUE, this.security));
            children.add(new Property("period", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this rule.", 0, Integer.MAX_VALUE, this.period));
            children.add(new Property("expression", "Expression", "Used when other data selection elements are insufficient.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -341064690: {
                    return new Property("resource", "", "Explicit FHIR Resource references.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 949122880: {
                    return new Property("security", "Coding", "The data in scope are those with the given codes present in that data .meta.security element.", 0, Integer.MAX_VALUE, this.security);
                }
                case -991726143: {
                    return new Property("period", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this rule.", 0, Integer.MAX_VALUE, this.period);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "Used when other data selection elements are insufficient.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 949122880: {
                    return this.security == null ? new Base[]{} : this.security.toArray(new Base[this.security.size()]);
                }
                case -991726143: {
                    return this.period == null ? new Base[]{} : this.period.toArray(new Base[this.period.size()]);
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    this.getResource().add((RuleDataResourceComponent)value);
                    return value;
                }
                case 949122880: {
                    this.getSecurity().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -991726143: {
                    this.getPeriod().add(TypeConvertor.castToPeriod(value));
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resource")) {
                this.getResource().add((RuleDataResourceComponent)value);
            } else if (name.equals("security")) {
                this.getSecurity().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("period")) {
                this.getPeriod().add(TypeConvertor.castToPeriod(value));
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return this.addResource();
                }
                case 949122880: {
                    return this.addSecurity();
                }
                case -991726143: {
                    return this.addPeriod();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return new String[0];
                }
                case 949122880: {
                    return new String[]{"Coding"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resource")) {
                return this.addResource();
            }
            if (name.equals("security")) {
                return this.addSecurity();
            }
            if (name.equals("period")) {
                return this.addPeriod();
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public RuleDataComponent copy() {
            RuleDataComponent dst = new RuleDataComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RuleDataComponent dst) {
            super.copyValues(dst);
            if (this.resource != null) {
                dst.resource = new ArrayList<RuleDataResourceComponent>();
                for (RuleDataResourceComponent ruleDataResourceComponent : this.resource) {
                    dst.resource.add(ruleDataResourceComponent.copy());
                }
            }
            if (this.security != null) {
                dst.security = new ArrayList<Coding>();
                for (Coding coding : this.security) {
                    dst.security.add(coding.copy());
                }
            }
            if (this.period != null) {
                dst.period = new ArrayList<Period>();
                for (Period period : this.period) {
                    dst.period.add(period.copy());
                }
            }
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleDataComponent)) {
                return false;
            }
            RuleDataComponent o = (RuleDataComponent)other_;
            return RuleDataComponent.compareDeep(this.resource, o.resource, true) && RuleDataComponent.compareDeep(this.security, o.security, true) && RuleDataComponent.compareDeep(this.period, o.period, true) && RuleDataComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleDataComponent)) {
                return false;
            }
            RuleDataComponent o = (RuleDataComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.resource, this.security, this.period, this.expression});
        }

        @Override
        public String fhirType() {
            return "Permission.rule.data";
        }
    }

    @Block
    public static class RuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="deny | permit", formalDefinition="deny | permit.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-provision-type")
        protected Enumeration<Enumerations.ConsentProvisionType> type;
        @Child(name="data", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The selection criteria to identify data that is within scope of this provision", formalDefinition="A description or definition of which activities are allowed to be done on the data.")
        protected List<RuleDataComponent> data;
        @Child(name="activity", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A description or definition of which activities are allowed to be done on the data", formalDefinition="A description or definition of which activities are allowed to be done on the data.")
        protected List<RuleActivityComponent> activity;
        @Child(name="limit", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="What limits apply to the use of the data", formalDefinition="What limits apply to the use of the data.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-label-event-examples")
        protected List<CodeableConcept> limit;
        private static final long serialVersionUID = 1376717588L;

        public Enumeration<Enumerations.ConsentProvisionType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RuleComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.ConsentProvisionType>(new Enumerations.ConsentProvisionTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RuleComponent setTypeElement(Enumeration<Enumerations.ConsentProvisionType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.ConsentProvisionType getType() {
            return this.type == null ? null : (Enumerations.ConsentProvisionType)((Object)this.type.getValue());
        }

        public RuleComponent setType(Enumerations.ConsentProvisionType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.ConsentProvisionType>(new Enumerations.ConsentProvisionTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public List<RuleDataComponent> getData() {
            if (this.data == null) {
                this.data = new ArrayList<RuleDataComponent>();
            }
            return this.data;
        }

        public RuleComponent setData(List<RuleDataComponent> theData) {
            this.data = theData;
            return this;
        }

        public boolean hasData() {
            if (this.data == null) {
                return false;
            }
            for (RuleDataComponent item : this.data) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RuleDataComponent addData() {
            RuleDataComponent t = new RuleDataComponent();
            if (this.data == null) {
                this.data = new ArrayList<RuleDataComponent>();
            }
            this.data.add(t);
            return t;
        }

        public RuleComponent addData(RuleDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new ArrayList<RuleDataComponent>();
            }
            this.data.add(t);
            return this;
        }

        public RuleDataComponent getDataFirstRep() {
            if (this.getData().isEmpty()) {
                this.addData();
            }
            return this.getData().get(0);
        }

        public List<RuleActivityComponent> getActivity() {
            if (this.activity == null) {
                this.activity = new ArrayList<RuleActivityComponent>();
            }
            return this.activity;
        }

        public RuleComponent setActivity(List<RuleActivityComponent> theActivity) {
            this.activity = theActivity;
            return this;
        }

        public boolean hasActivity() {
            if (this.activity == null) {
                return false;
            }
            for (RuleActivityComponent item : this.activity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RuleActivityComponent addActivity() {
            RuleActivityComponent t = new RuleActivityComponent();
            if (this.activity == null) {
                this.activity = new ArrayList<RuleActivityComponent>();
            }
            this.activity.add(t);
            return t;
        }

        public RuleComponent addActivity(RuleActivityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.activity == null) {
                this.activity = new ArrayList<RuleActivityComponent>();
            }
            this.activity.add(t);
            return this;
        }

        public RuleActivityComponent getActivityFirstRep() {
            if (this.getActivity().isEmpty()) {
                this.addActivity();
            }
            return this.getActivity().get(0);
        }

        public List<CodeableConcept> getLimit() {
            if (this.limit == null) {
                this.limit = new ArrayList<CodeableConcept>();
            }
            return this.limit;
        }

        public RuleComponent setLimit(List<CodeableConcept> theLimit) {
            this.limit = theLimit;
            return this;
        }

        public boolean hasLimit() {
            if (this.limit == null) {
                return false;
            }
            for (CodeableConcept item : this.limit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLimit() {
            CodeableConcept t = new CodeableConcept();
            if (this.limit == null) {
                this.limit = new ArrayList<CodeableConcept>();
            }
            this.limit.add(t);
            return t;
        }

        public RuleComponent addLimit(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.limit == null) {
                this.limit = new ArrayList<CodeableConcept>();
            }
            this.limit.add(t);
            return this;
        }

        public CodeableConcept getLimitFirstRep() {
            if (this.getLimit().isEmpty()) {
                this.addLimit();
            }
            return this.getLimit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "deny | permit.", 0, 1, this.type));
            children.add(new Property("data", "", "A description or definition of which activities are allowed to be done on the data.", 0, Integer.MAX_VALUE, this.data));
            children.add(new Property("activity", "", "A description or definition of which activities are allowed to be done on the data.", 0, Integer.MAX_VALUE, this.activity));
            children.add(new Property("limit", "CodeableConcept", "What limits apply to the use of the data.", 0, Integer.MAX_VALUE, this.limit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "deny | permit.", 0, 1, this.type);
                }
                case 3076010: {
                    return new Property("data", "", "A description or definition of which activities are allowed to be done on the data.", 0, Integer.MAX_VALUE, this.data);
                }
                case -1655966961: {
                    return new Property("activity", "", "A description or definition of which activities are allowed to be done on the data.", 0, Integer.MAX_VALUE, this.activity);
                }
                case 102976443: {
                    return new Property("limit", "CodeableConcept", "What limits apply to the use of the data.", 0, Integer.MAX_VALUE, this.limit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3076010: {
                    return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
                }
                case -1655966961: {
                    return this.activity == null ? new Base[]{} : this.activity.toArray(new Base[this.activity.size()]);
                }
                case 102976443: {
                    return this.limit == null ? new Base[]{} : this.limit.toArray(new Base[this.limit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new Enumerations.ConsentProvisionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3076010: {
                    this.getData().add((RuleDataComponent)((Object)value));
                    return value;
                }
                case -1655966961: {
                    this.getActivity().add((RuleActivityComponent)((Object)value));
                    return value;
                }
                case 102976443: {
                    this.getLimit().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new Enumerations.ConsentProvisionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("data")) {
                this.getData().add((RuleDataComponent)((Object)value));
            } else if (name.equals("activity")) {
                this.getActivity().add((RuleActivityComponent)((Object)value));
            } else if (name.equals("limit")) {
                this.getLimit().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3076010: {
                    return this.addData();
                }
                case -1655966961: {
                    return this.addActivity();
                }
                case 102976443: {
                    return this.addLimit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3076010: {
                    return new String[0];
                }
                case -1655966961: {
                    return new String[0];
                }
                case 102976443: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Permission.rule.type");
            }
            if (name.equals("data")) {
                return this.addData();
            }
            if (name.equals("activity")) {
                return this.addActivity();
            }
            if (name.equals("limit")) {
                return this.addLimit();
            }
            return super.addChild(name);
        }

        @Override
        public RuleComponent copy() {
            RuleComponent dst = new RuleComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RuleComponent dst) {
            super.copyValues(dst);
            Enumeration<Enumerations.ConsentProvisionType> enumeration = dst.type = this.type == null ? null : this.type.copy();
            if (this.data != null) {
                dst.data = new ArrayList<RuleDataComponent>();
                for (RuleDataComponent ruleDataComponent : this.data) {
                    dst.data.add(ruleDataComponent.copy());
                }
            }
            if (this.activity != null) {
                dst.activity = new ArrayList<RuleActivityComponent>();
                for (RuleActivityComponent ruleActivityComponent : this.activity) {
                    dst.activity.add(ruleActivityComponent.copy());
                }
            }
            if (this.limit != null) {
                dst.limit = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.limit) {
                    dst.limit.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleComponent)) {
                return false;
            }
            RuleComponent o = (RuleComponent)other_;
            return RuleComponent.compareDeep(this.type, o.type, true) && RuleComponent.compareDeep(this.data, o.data, true) && RuleComponent.compareDeep(this.activity, o.activity, true) && RuleComponent.compareDeep(this.limit, o.limit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RuleComponent)) {
                return false;
            }
            RuleComponent o = (RuleComponent)other_;
            return RuleComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.data, this.activity, this.limit});
        }

        @Override
        public String fhirType() {
            return "Permission.rule";
        }
    }

    @Block
    public static class PermissionJustificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="basis", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The regulatory grounds upon which this Permission builds", formalDefinition="This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-policy")
        protected List<CodeableConcept> basis;
        @Child(name="evidence", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Justifing rational", formalDefinition="Justifing rational.")
        protected List<Reference> evidence;
        private static final long serialVersionUID = -2023272721L;

        public List<CodeableConcept> getBasis() {
            if (this.basis == null) {
                this.basis = new ArrayList<CodeableConcept>();
            }
            return this.basis;
        }

        public PermissionJustificationComponent setBasis(List<CodeableConcept> theBasis) {
            this.basis = theBasis;
            return this;
        }

        public boolean hasBasis() {
            if (this.basis == null) {
                return false;
            }
            for (CodeableConcept item : this.basis) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addBasis() {
            CodeableConcept t = new CodeableConcept();
            if (this.basis == null) {
                this.basis = new ArrayList<CodeableConcept>();
            }
            this.basis.add(t);
            return t;
        }

        public PermissionJustificationComponent addBasis(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.basis == null) {
                this.basis = new ArrayList<CodeableConcept>();
            }
            this.basis.add(t);
            return this;
        }

        public CodeableConcept getBasisFirstRep() {
            if (this.getBasis().isEmpty()) {
                this.addBasis();
            }
            return this.getBasis().get(0);
        }

        public List<Reference> getEvidence() {
            if (this.evidence == null) {
                this.evidence = new ArrayList<Reference>();
            }
            return this.evidence;
        }

        public PermissionJustificationComponent setEvidence(List<Reference> theEvidence) {
            this.evidence = theEvidence;
            return this;
        }

        public boolean hasEvidence() {
            if (this.evidence == null) {
                return false;
            }
            for (Reference item : this.evidence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEvidence() {
            Reference t = new Reference();
            if (this.evidence == null) {
                this.evidence = new ArrayList<Reference>();
            }
            this.evidence.add(t);
            return t;
        }

        public PermissionJustificationComponent addEvidence(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.evidence == null) {
                this.evidence = new ArrayList<Reference>();
            }
            this.evidence.add(t);
            return this;
        }

        public Reference getEvidenceFirstRep() {
            if (this.getEvidence().isEmpty()) {
                this.addEvidence();
            }
            return this.getEvidence().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("basis", "CodeableConcept", "This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR.", 0, Integer.MAX_VALUE, this.basis));
            children.add(new Property("evidence", "Reference(Any)", "Justifing rational.", 0, Integer.MAX_VALUE, this.evidence));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 93508670: {
                    return new Property("basis", "CodeableConcept", "This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR.", 0, Integer.MAX_VALUE, this.basis);
                }
                case 382967383: {
                    return new Property("evidence", "Reference(Any)", "Justifing rational.", 0, Integer.MAX_VALUE, this.evidence);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 93508670: {
                    return this.basis == null ? new Base[]{} : this.basis.toArray(new Base[this.basis.size()]);
                }
                case 382967383: {
                    return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 93508670: {
                    this.getBasis().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 382967383: {
                    this.getEvidence().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("basis")) {
                this.getBasis().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("evidence")) {
                this.getEvidence().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 93508670: {
                    return this.addBasis();
                }
                case 382967383: {
                    return this.addEvidence();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 93508670: {
                    return new String[]{"CodeableConcept"};
                }
                case 382967383: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("basis")) {
                return this.addBasis();
            }
            if (name.equals("evidence")) {
                return this.addEvidence();
            }
            return super.addChild(name);
        }

        @Override
        public PermissionJustificationComponent copy() {
            PermissionJustificationComponent dst = new PermissionJustificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PermissionJustificationComponent dst) {
            super.copyValues(dst);
            if (this.basis != null) {
                dst.basis = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.basis) {
                    dst.basis.add(codeableConcept.copy());
                }
            }
            if (this.evidence != null) {
                dst.evidence = new ArrayList<Reference>();
                for (Reference reference : this.evidence) {
                    dst.evidence.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PermissionJustificationComponent)) {
                return false;
            }
            PermissionJustificationComponent o = (PermissionJustificationComponent)other_;
            return PermissionJustificationComponent.compareDeep(this.basis, o.basis, true) && PermissionJustificationComponent.compareDeep(this.evidence, o.evidence, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PermissionJustificationComponent)) {
                return false;
            }
            PermissionJustificationComponent o = (PermissionJustificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.basis, this.evidence});
        }

        @Override
        public String fhirType() {
            return "Permission.justification";
        }
    }

    public static class PermissionStatusEnumFactory
    implements EnumFactory<PermissionStatus> {
        @Override
        public PermissionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return PermissionStatus.ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return PermissionStatus.ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return PermissionStatus.DRAFT;
            }
            if ("rejected".equals(codeString)) {
                return PermissionStatus.REJECTED;
            }
            throw new IllegalArgumentException("Unknown PermissionStatus code '" + codeString + "'");
        }

        public Enumeration<PermissionStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.ACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.ENTEREDINERROR, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.DRAFT, code);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.REJECTED, code);
            }
            throw new FHIRException("Unknown PermissionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(PermissionStatus code) {
            if (code == PermissionStatus.ACTIVE) {
                return "active";
            }
            if (code == PermissionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == PermissionStatus.DRAFT) {
                return "draft";
            }
            if (code == PermissionStatus.REJECTED) {
                return "rejected";
            }
            return "?";
        }

        @Override
        public String toSystem(PermissionStatus code) {
            return code.getSystem();
        }
    }

    public static enum PermissionStatus {
        ACTIVE,
        ENTEREDINERROR,
        DRAFT,
        REJECTED,
        NULL;


        public static PermissionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PermissionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case DRAFT: {
                    return "draft";
                }
                case REJECTED: {
                    return "rejected";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "Permission is given.";
                }
                case ENTEREDINERROR: {
                    return "Permission was entered in error and is not active.";
                }
                case DRAFT: {
                    return "Permission is being defined.";
                }
                case REJECTED: {
                    return "Permission not granted.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case DRAFT: {
                    return "Draft";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class PermissionRuleCombiningEnumFactory
    implements EnumFactory<PermissionRuleCombining> {
        @Override
        public PermissionRuleCombining fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("deny-overrides".equals(codeString)) {
                return PermissionRuleCombining.DENYOVERRIDES;
            }
            if ("permit-overrides".equals(codeString)) {
                return PermissionRuleCombining.PERMITOVERRIDES;
            }
            if ("ordered-deny-overrides".equals(codeString)) {
                return PermissionRuleCombining.ORDEREDDENYOVERRIDES;
            }
            if ("ordered-permit-overrides".equals(codeString)) {
                return PermissionRuleCombining.ORDEREDPERMITOVERRIDES;
            }
            if ("deny-unless-permit".equals(codeString)) {
                return PermissionRuleCombining.DENYUNLESSPERMIT;
            }
            if ("permit-unless-deny".equals(codeString)) {
                return PermissionRuleCombining.PERMITUNLESSDENY;
            }
            throw new IllegalArgumentException("Unknown PermissionRuleCombining code '" + codeString + "'");
        }

        public Enumeration<PermissionRuleCombining> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.NULL, code);
            }
            if ("deny-overrides".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.DENYOVERRIDES, code);
            }
            if ("permit-overrides".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.PERMITOVERRIDES, code);
            }
            if ("ordered-deny-overrides".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.ORDEREDDENYOVERRIDES, code);
            }
            if ("ordered-permit-overrides".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.ORDEREDPERMITOVERRIDES, code);
            }
            if ("deny-unless-permit".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.DENYUNLESSPERMIT, code);
            }
            if ("permit-unless-deny".equals(codeString)) {
                return new Enumeration<PermissionRuleCombining>(this, PermissionRuleCombining.PERMITUNLESSDENY, code);
            }
            throw new FHIRException("Unknown PermissionRuleCombining code '" + codeString + "'");
        }

        @Override
        public String toCode(PermissionRuleCombining code) {
            if (code == PermissionRuleCombining.DENYOVERRIDES) {
                return "deny-overrides";
            }
            if (code == PermissionRuleCombining.PERMITOVERRIDES) {
                return "permit-overrides";
            }
            if (code == PermissionRuleCombining.ORDEREDDENYOVERRIDES) {
                return "ordered-deny-overrides";
            }
            if (code == PermissionRuleCombining.ORDEREDPERMITOVERRIDES) {
                return "ordered-permit-overrides";
            }
            if (code == PermissionRuleCombining.DENYUNLESSPERMIT) {
                return "deny-unless-permit";
            }
            if (code == PermissionRuleCombining.PERMITUNLESSDENY) {
                return "permit-unless-deny";
            }
            return "?";
        }

        @Override
        public String toSystem(PermissionRuleCombining code) {
            return code.getSystem();
        }
    }

    public static enum PermissionRuleCombining {
        DENYOVERRIDES,
        PERMITOVERRIDES,
        ORDEREDDENYOVERRIDES,
        ORDEREDPERMITOVERRIDES,
        DENYUNLESSPERMIT,
        PERMITUNLESSDENY,
        NULL;


        public static PermissionRuleCombining fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("deny-overrides".equals(codeString)) {
                return DENYOVERRIDES;
            }
            if ("permit-overrides".equals(codeString)) {
                return PERMITOVERRIDES;
            }
            if ("ordered-deny-overrides".equals(codeString)) {
                return ORDEREDDENYOVERRIDES;
            }
            if ("ordered-permit-overrides".equals(codeString)) {
                return ORDEREDPERMITOVERRIDES;
            }
            if ("deny-unless-permit".equals(codeString)) {
                return DENYUNLESSPERMIT;
            }
            if ("permit-unless-deny".equals(codeString)) {
                return PERMITUNLESSDENY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PermissionRuleCombining code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DENYOVERRIDES: {
                    return "deny-overrides";
                }
                case PERMITOVERRIDES: {
                    return "permit-overrides";
                }
                case ORDEREDDENYOVERRIDES: {
                    return "ordered-deny-overrides";
                }
                case ORDEREDPERMITOVERRIDES: {
                    return "ordered-permit-overrides";
                }
                case DENYUNLESSPERMIT: {
                    return "deny-unless-permit";
                }
                case PERMITUNLESSDENY: {
                    return "permit-unless-deny";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DENYOVERRIDES: {
                    return "http://hl7.org/fhir/permission-rule-combining";
                }
                case PERMITOVERRIDES: {
                    return "http://hl7.org/fhir/permission-rule-combining";
                }
                case ORDEREDDENYOVERRIDES: {
                    return "http://hl7.org/fhir/permission-rule-combining";
                }
                case ORDEREDPERMITOVERRIDES: {
                    return "http://hl7.org/fhir/permission-rule-combining";
                }
                case DENYUNLESSPERMIT: {
                    return "http://hl7.org/fhir/permission-rule-combining";
                }
                case PERMITUNLESSDENY: {
                    return "http://hl7.org/fhir/permission-rule-combining";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DENYOVERRIDES: {
                    return "The deny overrides combining algorithm is intended for those cases where a deny decision should have priority over a permit decision.";
                }
                case PERMITOVERRIDES: {
                    return "The permit overrides combining algorithm is intended for those cases where a permit decision should have priority over a deny decision.";
                }
                case ORDEREDDENYOVERRIDES: {
                    return "The behavior of this algorithm is identical to that of the \u201cDeny-overrides\u201d rule-combining algorithm with one exception.  The order in which the collection of rules is evaluated SHALL match the order as listed in the permission.";
                }
                case ORDEREDPERMITOVERRIDES: {
                    return "The behavior of this algorithm is identical to that of the \u201cPermit-overrides\u201d rule-combining algorithm with one exception.  The order in which the collection of rules is evaluated SHALL match the order as listed in the permission.";
                }
                case DENYUNLESSPERMIT: {
                    return "The \u201cDeny-unless-permit\u201d combining algorithm is intended for those cases where a permit decision should have priority over a deny decision, and an \u201cIndeterminate\u201d or \u201cNotApplicable\u201d must never be the result. It is particularly useful at the top level in a policy structure to ensure that a PDP will always return a definite \u201cPermit\u201d or \u201cDeny\u201d result.";
                }
                case PERMITUNLESSDENY: {
                    return "The \u201cPermit-unless-deny\u201d combining algorithm is intended for those cases where a deny decision should have priority over a permit decision, and an \u201cIndeterminate\u201d or \u201cNotApplicable\u201d must never be the result. It is particularly useful at the top level in a policy structure to ensure that a PDP will always return a definite \u201cPermit\u201d or \u201cDeny\u201d result. This algorithm has the following behavior.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DENYOVERRIDES: {
                    return "Deny-overrides";
                }
                case PERMITOVERRIDES: {
                    return "Permit-overrides";
                }
                case ORDEREDDENYOVERRIDES: {
                    return "Ordered-deny-overrides";
                }
                case ORDEREDPERMITOVERRIDES: {
                    return "Ordered-permit-overrides";
                }
                case DENYUNLESSPERMIT: {
                    return "Deny-unless-permit";
                }
                case PERMITUNLESSDENY: {
                    return "Permit-unless-deny";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

