/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RegulatedAuthorization", profile="http://hl7.org/fhir/StructureDefinition/RegulatedAuthorization")
public class RegulatedAuthorization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the authorization, typically assigned by the authorizing body", formalDefinition="Business identifier for the authorization, typically assigned by the authorizing body.")
    protected List<Identifier> identifier;
    @Child(name="subject", type={MedicinalProductDefinition.class, BiologicallyDerivedProduct.class, NutritionProduct.class, PackagedProductDefinition.class, ManufacturedItemDefinition.class, Ingredient.class, SubstanceDefinition.class, DeviceDefinition.class, ResearchStudy.class, ActivityDefinition.class, PlanDefinition.class, ObservationDefinition.class, Practitioner.class, Organization.class, Location.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product type, treatment, facility or activity that is being authorized", formalDefinition="The product type, treatment, facility or activity that is being authorized.")
    protected List<Reference> subject;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Overall type of this authorization, for example drug marketing approval, orphan drug designation", formalDefinition="Overall type of this authorization, for example drug marketing approval, orphan drug designation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/regulated-authorization-type")
    protected CodeableConcept type;
    @Child(name="description", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General textual supporting information", formalDefinition="General textual supporting information.")
    protected MarkdownType description;
    @Child(name="region", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The territory in which the authorization has been granted", formalDefinition="The territory (e.g., country, jurisdiction etc.) in which the authorization has been granted.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> region;
    @Child(name="status", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status that is authorised e.g. approved. Intermediate states can be tracked with cases and applications", formalDefinition="The status that is authorised e.g. approved. Intermediate states and actions can be tracked with cases and applications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the current status was assigned", formalDefinition="The date at which the current status was assigned.")
    protected DateTimeType statusDate;
    @Child(name="validityPeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The time period in which the regulatory approval etc. is in effect, e.g. a Marketing Authorization includes the date of authorization and/or expiration date", formalDefinition="The time period in which the regulatory approval, clearance or licencing is in effect. As an example, a Marketing Authorization includes the date of authorization and/or an expiration date.")
    protected Period validityPeriod;
    @Child(name="indication", type={CodeableReference.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition for which the use of the regulated product applies", formalDefinition="Condition for which the use of the regulated product applies.")
    protected List<CodeableReference> indication;
    @Child(name="intendedUse", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The intended use of the product, e.g. prevention, treatment", formalDefinition="The intended use of the product, e.g. prevention, treatment, diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-intended-use")
    protected CodeableConcept intendedUse;
    @Child(name="basis", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The legal/regulatory framework or reasons under which this authorization is granted", formalDefinition="The legal or regulatory framework against which this authorization is granted, or other reasons for it.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/regulated-authorization-basis")
    protected List<CodeableConcept> basis;
    @Child(name="holder", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The organization that has been granted this authorization, by the regulator", formalDefinition="The organization that has been granted this authorization, by some authoritative body (the 'regulator').")
    protected Reference holder;
    @Child(name="regulator", type={Organization.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The regulatory authority or authorizing body granting the authorization", formalDefinition="The regulatory authority or authorizing body granting the authorization. For example, European Medicines Agency (EMA), Food and Drug Administration (FDA), Health Canada (HC), etc.")
    protected Reference regulator;
    @Child(name="attachedDocument", type={DocumentReference.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information or supporting documentation about the authorization", formalDefinition="Additional information or supporting documentation about the authorization.")
    protected List<Reference> attachedDocument;
    @Child(name="case", type={}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The case or regulatory procedure for granting or amending a regulated authorization. Note: This area is subject to ongoing review and the workgroup is seeking implementer feedback on its use (see link at bottom of page)", formalDefinition="The case or regulatory procedure for granting or amending a regulated authorization. An authorization is granted in response to submissions/applications by those seeking authorization. A case is the administrative process that deals with the application(s) that relate to this and assesses them. Note: This area is subject to ongoing review and the workgroup is seeking implementer feedback on its use (see link at bottom of page).")
    protected RegulatedAuthorizationCaseComponent case_;
    private static final long serialVersionUID = 1227409639L;
    @SearchParamDefinition(name="case-type", path="RegulatedAuthorization.case.type", description="The defining type of case", type="token")
    public static final String SP_CASE_TYPE = "case-type";
    public static final TokenClientParam CASE_TYPE = new TokenClientParam("case-type");
    @SearchParamDefinition(name="case", path="RegulatedAuthorization.case.identifier", description="The case or procedure number", type="token")
    public static final String SP_CASE = "case";
    public static final TokenClientParam CASE = new TokenClientParam("case");
    @SearchParamDefinition(name="holder", path="RegulatedAuthorization.holder", description="The organization that holds the granted authorization", type="reference", target={Organization.class})
    public static final String SP_HOLDER = "holder";
    public static final ReferenceClientParam HOLDER = new ReferenceClientParam("holder");
    public static final Include INCLUDE_HOLDER = new Include("RegulatedAuthorization:holder").toLocked();
    @SearchParamDefinition(name="identifier", path="RegulatedAuthorization.identifier", description="Business identifier for the authorization, typically assigned by the authorizing body", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="region", path="RegulatedAuthorization.region", description="The territory (e.g., country, jurisdiction etc.) in which the authorization has been granted", type="token")
    public static final String SP_REGION = "region";
    public static final TokenClientParam REGION = new TokenClientParam("region");
    @SearchParamDefinition(name="status", path="RegulatedAuthorization.status", description="The status that is authorised e.g. approved. Intermediate states can be tracked with cases and applications", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="RegulatedAuthorization.subject", description="The type of regulated product, treatment, facility or activity that is being authorized", type="reference", target={ActivityDefinition.class, BiologicallyDerivedProduct.class, DeviceDefinition.class, Ingredient.class, Location.class, ManufacturedItemDefinition.class, MedicinalProductDefinition.class, NutritionProduct.class, ObservationDefinition.class, Organization.class, PackagedProductDefinition.class, PlanDefinition.class, Practitioner.class, ResearchStudy.class, SubstanceDefinition.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("RegulatedAuthorization:subject").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RegulatedAuthorization setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RegulatedAuthorization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public RegulatedAuthorization setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public RegulatedAuthorization addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public RegulatedAuthorization setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public RegulatedAuthorization setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public RegulatedAuthorization setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getRegion() {
        if (this.region == null) {
            this.region = new ArrayList<CodeableConcept>();
        }
        return this.region;
    }

    public RegulatedAuthorization setRegion(List<CodeableConcept> theRegion) {
        this.region = theRegion;
        return this;
    }

    public boolean hasRegion() {
        if (this.region == null) {
            return false;
        }
        for (CodeableConcept item : this.region) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRegion() {
        CodeableConcept t = new CodeableConcept();
        if (this.region == null) {
            this.region = new ArrayList<CodeableConcept>();
        }
        this.region.add(t);
        return t;
    }

    public RegulatedAuthorization addRegion(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.region == null) {
            this.region = new ArrayList<CodeableConcept>();
        }
        this.region.add(t);
        return this;
    }

    public CodeableConcept getRegionFirstRep() {
        if (this.getRegion().isEmpty()) {
            this.addRegion();
        }
        return this.getRegion().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public RegulatedAuthorization setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public RegulatedAuthorization setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public RegulatedAuthorization setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public Period getValidityPeriod() {
        if (this.validityPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.validityPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.validityPeriod = new Period();
            }
        }
        return this.validityPeriod;
    }

    public boolean hasValidityPeriod() {
        return this.validityPeriod != null && !this.validityPeriod.isEmpty();
    }

    public RegulatedAuthorization setValidityPeriod(Period value) {
        this.validityPeriod = value;
        return this;
    }

    public List<CodeableReference> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableReference>();
        }
        return this.indication;
    }

    public RegulatedAuthorization setIndication(List<CodeableReference> theIndication) {
        this.indication = theIndication;
        return this;
    }

    public boolean hasIndication() {
        if (this.indication == null) {
            return false;
        }
        for (CodeableReference item : this.indication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addIndication() {
        CodeableReference t = new CodeableReference();
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableReference>();
        }
        this.indication.add(t);
        return t;
    }

    public RegulatedAuthorization addIndication(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableReference>();
        }
        this.indication.add(t);
        return this;
    }

    public CodeableReference getIndicationFirstRep() {
        if (this.getIndication().isEmpty()) {
            this.addIndication();
        }
        return this.getIndication().get(0);
    }

    public CodeableConcept getIntendedUse() {
        if (this.intendedUse == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.intendedUse");
            }
            if (Configuration.doAutoCreate()) {
                this.intendedUse = new CodeableConcept();
            }
        }
        return this.intendedUse;
    }

    public boolean hasIntendedUse() {
        return this.intendedUse != null && !this.intendedUse.isEmpty();
    }

    public RegulatedAuthorization setIntendedUse(CodeableConcept value) {
        this.intendedUse = value;
        return this;
    }

    public List<CodeableConcept> getBasis() {
        if (this.basis == null) {
            this.basis = new ArrayList<CodeableConcept>();
        }
        return this.basis;
    }

    public RegulatedAuthorization setBasis(List<CodeableConcept> theBasis) {
        this.basis = theBasis;
        return this;
    }

    public boolean hasBasis() {
        if (this.basis == null) {
            return false;
        }
        for (CodeableConcept item : this.basis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBasis() {
        CodeableConcept t = new CodeableConcept();
        if (this.basis == null) {
            this.basis = new ArrayList<CodeableConcept>();
        }
        this.basis.add(t);
        return t;
    }

    public RegulatedAuthorization addBasis(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.basis == null) {
            this.basis = new ArrayList<CodeableConcept>();
        }
        this.basis.add(t);
        return this;
    }

    public CodeableConcept getBasisFirstRep() {
        if (this.getBasis().isEmpty()) {
            this.addBasis();
        }
        return this.getBasis().get(0);
    }

    public Reference getHolder() {
        if (this.holder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.holder");
            }
            if (Configuration.doAutoCreate()) {
                this.holder = new Reference();
            }
        }
        return this.holder;
    }

    public boolean hasHolder() {
        return this.holder != null && !this.holder.isEmpty();
    }

    public RegulatedAuthorization setHolder(Reference value) {
        this.holder = value;
        return this;
    }

    public Reference getRegulator() {
        if (this.regulator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.regulator");
            }
            if (Configuration.doAutoCreate()) {
                this.regulator = new Reference();
            }
        }
        return this.regulator;
    }

    public boolean hasRegulator() {
        return this.regulator != null && !this.regulator.isEmpty();
    }

    public RegulatedAuthorization setRegulator(Reference value) {
        this.regulator = value;
        return this;
    }

    public List<Reference> getAttachedDocument() {
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        return this.attachedDocument;
    }

    public RegulatedAuthorization setAttachedDocument(List<Reference> theAttachedDocument) {
        this.attachedDocument = theAttachedDocument;
        return this;
    }

    public boolean hasAttachedDocument() {
        if (this.attachedDocument == null) {
            return false;
        }
        for (Reference item : this.attachedDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAttachedDocument() {
        Reference t = new Reference();
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return t;
    }

    public RegulatedAuthorization addAttachedDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return this;
    }

    public Reference getAttachedDocumentFirstRep() {
        if (this.getAttachedDocument().isEmpty()) {
            this.addAttachedDocument();
        }
        return this.getAttachedDocument().get(0);
    }

    public RegulatedAuthorizationCaseComponent getCase() {
        if (this.case_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RegulatedAuthorization.case_");
            }
            if (Configuration.doAutoCreate()) {
                this.case_ = new RegulatedAuthorizationCaseComponent();
            }
        }
        return this.case_;
    }

    public boolean hasCase() {
        return this.case_ != null && !this.case_.isEmpty();
    }

    public RegulatedAuthorization setCase(RegulatedAuthorizationCaseComponent value) {
        this.case_ = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the authorization, typically assigned by the authorizing body.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition|BiologicallyDerivedProduct|NutritionProduct|PackagedProductDefinition|ManufacturedItemDefinition|Ingredient|SubstanceDefinition|DeviceDefinition|ResearchStudy|ActivityDefinition|PlanDefinition|ObservationDefinition|Practitioner|Organization|Location)", "The product type, treatment, facility or activity that is being authorized.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("type", "CodeableConcept", "Overall type of this authorization, for example drug marketing approval, orphan drug designation.", 0, 1, this.type));
        children.add(new Property("description", "markdown", "General textual supporting information.", 0, 1, this.description));
        children.add(new Property(SP_REGION, "CodeableConcept", "The territory (e.g., country, jurisdiction etc.) in which the authorization has been granted.", 0, Integer.MAX_VALUE, this.region));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status that is authorised e.g. approved. Intermediate states and actions can be tracked with cases and applications.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the current status was assigned.", 0, 1, this.statusDate));
        children.add(new Property("validityPeriod", "Period", "The time period in which the regulatory approval, clearance or licencing is in effect. As an example, a Marketing Authorization includes the date of authorization and/or an expiration date.", 0, 1, this.validityPeriod));
        children.add(new Property("indication", "CodeableReference(ClinicalUseDefinition)", "Condition for which the use of the regulated product applies.", 0, Integer.MAX_VALUE, this.indication));
        children.add(new Property("intendedUse", "CodeableConcept", "The intended use of the product, e.g. prevention, treatment, diagnosis.", 0, 1, this.intendedUse));
        children.add(new Property("basis", "CodeableConcept", "The legal or regulatory framework against which this authorization is granted, or other reasons for it.", 0, Integer.MAX_VALUE, this.basis));
        children.add(new Property(SP_HOLDER, "Reference(Organization)", "The organization that has been granted this authorization, by some authoritative body (the 'regulator').", 0, 1, this.holder));
        children.add(new Property("regulator", "Reference(Organization)", "The regulatory authority or authorizing body granting the authorization. For example, European Medicines Agency (EMA), Food and Drug Administration (FDA), Health Canada (HC), etc.", 0, 1, this.regulator));
        children.add(new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the authorization.", 0, Integer.MAX_VALUE, this.attachedDocument));
        children.add(new Property(SP_CASE, "", "The case or regulatory procedure for granting or amending a regulated authorization. An authorization is granted in response to submissions/applications by those seeking authorization. A case is the administrative process that deals with the application(s) that relate to this and assesses them. Note: This area is subject to ongoing review and the workgroup is seeking implementer feedback on its use (see link at bottom of page).", 0, 1, this.case_));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the authorization, typically assigned by the authorizing body.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition|BiologicallyDerivedProduct|NutritionProduct|PackagedProductDefinition|ManufacturedItemDefinition|Ingredient|SubstanceDefinition|DeviceDefinition|ResearchStudy|ActivityDefinition|PlanDefinition|ObservationDefinition|Practitioner|Organization|Location)", "The product type, treatment, facility or activity that is being authorized.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Overall type of this authorization, for example drug marketing approval, orphan drug designation.", 0, 1, this.type);
            }
            case -1724546052: {
                return new Property("description", "markdown", "General textual supporting information.", 0, 1, this.description);
            }
            case -934795532: {
                return new Property(SP_REGION, "CodeableConcept", "The territory (e.g., country, jurisdiction etc.) in which the authorization has been granted.", 0, Integer.MAX_VALUE, this.region);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status that is authorised e.g. approved. Intermediate states and actions can be tracked with cases and applications.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the current status was assigned.", 0, 1, this.statusDate);
            }
            case -1434195053: {
                return new Property("validityPeriod", "Period", "The time period in which the regulatory approval, clearance or licencing is in effect. As an example, a Marketing Authorization includes the date of authorization and/or an expiration date.", 0, 1, this.validityPeriod);
            }
            case -597168804: {
                return new Property("indication", "CodeableReference(ClinicalUseDefinition)", "Condition for which the use of the regulated product applies.", 0, Integer.MAX_VALUE, this.indication);
            }
            case -1618671268: {
                return new Property("intendedUse", "CodeableConcept", "The intended use of the product, e.g. prevention, treatment, diagnosis.", 0, 1, this.intendedUse);
            }
            case 93508670: {
                return new Property("basis", "CodeableConcept", "The legal or regulatory framework against which this authorization is granted, or other reasons for it.", 0, Integer.MAX_VALUE, this.basis);
            }
            case -1211707988: {
                return new Property(SP_HOLDER, "Reference(Organization)", "The organization that has been granted this authorization, by some authoritative body (the 'regulator').", 0, 1, this.holder);
            }
            case 414760449: {
                return new Property("regulator", "Reference(Organization)", "The regulatory authority or authorizing body granting the authorization. For example, European Medicines Agency (EMA), Food and Drug Administration (FDA), Health Canada (HC), etc.", 0, 1, this.regulator);
            }
            case -513945889: {
                return new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the authorization.", 0, Integer.MAX_VALUE, this.attachedDocument);
            }
            case 3046192: {
                return new Property(SP_CASE, "", "The case or regulatory procedure for granting or amending a regulated authorization. An authorization is granted in response to submissions/applications by those seeking authorization. A case is the administrative process that deals with the application(s) that relate to this and assesses them. Note: This area is subject to ongoing review and the workgroup is seeking implementer feedback on its use (see link at bottom of page).", 0, 1, this.case_);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.description;
                }
                return baseArray;
            }
            case -934795532: {
                return this.region == null ? new Base[]{} : this.region.toArray(new Base[this.region.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.statusDate;
                }
                return baseArray;
            }
            case -1434195053: {
                Base[] baseArray;
                if (this.validityPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.validityPeriod;
                }
                return baseArray;
            }
            case -597168804: {
                return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
            }
            case -1618671268: {
                Base[] baseArray;
                if (this.intendedUse == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.intendedUse;
                }
                return baseArray;
            }
            case 93508670: {
                return this.basis == null ? new Base[]{} : this.basis.toArray(new Base[this.basis.size()]);
            }
            case -1211707988: {
                Base[] baseArray;
                if (this.holder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.holder;
                }
                return baseArray;
            }
            case 414760449: {
                Base[] baseArray;
                if (this.regulator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.regulator;
                }
                return baseArray;
            }
            case -513945889: {
                return this.attachedDocument == null ? new Base[]{} : this.attachedDocument.toArray(new Base[this.attachedDocument.size()]);
            }
            case 3046192: {
                Base[] baseArray;
                if (this.case_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.case_;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -934795532: {
                this.getRegion().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1434195053: {
                this.validityPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -597168804: {
                this.getIndication().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1618671268: {
                this.intendedUse = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 93508670: {
                this.getBasis().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1211707988: {
                this.holder = TypeConvertor.castToReference(value);
                return value;
            }
            case 414760449: {
                this.regulator = TypeConvertor.castToReference(value);
                return value;
            }
            case -513945889: {
                this.getAttachedDocument().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3046192: {
                this.case_ = (RegulatedAuthorizationCaseComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_REGION)) {
            this.getRegion().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("validityPeriod")) {
            this.validityPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("indication")) {
            this.getIndication().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("intendedUse")) {
            this.intendedUse = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("basis")) {
            this.getBasis().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_HOLDER)) {
            this.holder = TypeConvertor.castToReference(value);
        } else if (name.equals("regulator")) {
            this.regulator = TypeConvertor.castToReference(value);
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_CASE)) {
            this.case_ = (RegulatedAuthorizationCaseComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 3575610: {
                return this.getType();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -934795532: {
                return this.addRegion();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -1434195053: {
                return this.getValidityPeriod();
            }
            case -597168804: {
                return this.addIndication();
            }
            case -1618671268: {
                return this.getIntendedUse();
            }
            case 93508670: {
                return this.addBasis();
            }
            case -1211707988: {
                return this.getHolder();
            }
            case 414760449: {
                return this.getRegulator();
            }
            case -513945889: {
                return this.addAttachedDocument();
            }
            case 3046192: {
                return this.getCase();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -934795532: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -1434195053: {
                return new String[]{"Period"};
            }
            case -597168804: {
                return new String[]{"CodeableReference"};
            }
            case -1618671268: {
                return new String[]{"CodeableConcept"};
            }
            case 93508670: {
                return new String[]{"CodeableConcept"};
            }
            case -1211707988: {
                return new String[]{"Reference"};
            }
            case 414760449: {
                return new String[]{"Reference"};
            }
            case -513945889: {
                return new String[]{"Reference"};
            }
            case 3046192: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property RegulatedAuthorization.description");
        }
        if (name.equals(SP_REGION)) {
            return this.addRegion();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property RegulatedAuthorization.statusDate");
        }
        if (name.equals("validityPeriod")) {
            this.validityPeriod = new Period();
            return this.validityPeriod;
        }
        if (name.equals("indication")) {
            return this.addIndication();
        }
        if (name.equals("intendedUse")) {
            this.intendedUse = new CodeableConcept();
            return this.intendedUse;
        }
        if (name.equals("basis")) {
            return this.addBasis();
        }
        if (name.equals(SP_HOLDER)) {
            this.holder = new Reference();
            return this.holder;
        }
        if (name.equals("regulator")) {
            this.regulator = new Reference();
            return this.regulator;
        }
        if (name.equals("attachedDocument")) {
            return this.addAttachedDocument();
        }
        if (name.equals(SP_CASE)) {
            this.case_ = new RegulatedAuthorizationCaseComponent();
            return this.case_;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RegulatedAuthorization";
    }

    @Override
    public RegulatedAuthorization copy() {
        RegulatedAuthorization dst = new RegulatedAuthorization();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RegulatedAuthorization dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.region != null) {
            dst.region = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.region) {
                dst.region.add(codeableConcept.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        Period period = dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
        if (this.indication != null) {
            dst.indication = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.indication) {
                dst.indication.add(codeableReference.copy());
            }
        }
        CodeableConcept codeableConcept = dst.intendedUse = this.intendedUse == null ? null : this.intendedUse.copy();
        if (this.basis != null) {
            dst.basis = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.basis) {
                dst.basis.add(codeableConcept2.copy());
            }
        }
        dst.holder = this.holder == null ? null : this.holder.copy();
        Reference reference = dst.regulator = this.regulator == null ? null : this.regulator.copy();
        if (this.attachedDocument != null) {
            dst.attachedDocument = new ArrayList<Reference>();
            for (Reference reference2 : this.attachedDocument) {
                dst.attachedDocument.add(reference2.copy());
            }
        }
        dst.case_ = this.case_ == null ? null : this.case_.copy();
    }

    protected RegulatedAuthorization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RegulatedAuthorization)) {
            return false;
        }
        RegulatedAuthorization o = (RegulatedAuthorization)other_;
        return RegulatedAuthorization.compareDeep(this.identifier, o.identifier, true) && RegulatedAuthorization.compareDeep(this.subject, o.subject, true) && RegulatedAuthorization.compareDeep(this.type, o.type, true) && RegulatedAuthorization.compareDeep(this.description, o.description, true) && RegulatedAuthorization.compareDeep(this.region, o.region, true) && RegulatedAuthorization.compareDeep(this.status, o.status, true) && RegulatedAuthorization.compareDeep(this.statusDate, o.statusDate, true) && RegulatedAuthorization.compareDeep(this.validityPeriod, o.validityPeriod, true) && RegulatedAuthorization.compareDeep(this.indication, o.indication, true) && RegulatedAuthorization.compareDeep(this.intendedUse, o.intendedUse, true) && RegulatedAuthorization.compareDeep(this.basis, o.basis, true) && RegulatedAuthorization.compareDeep(this.holder, o.holder, true) && RegulatedAuthorization.compareDeep(this.regulator, o.regulator, true) && RegulatedAuthorization.compareDeep(this.attachedDocument, o.attachedDocument, true) && RegulatedAuthorization.compareDeep(this.case_, o.case_, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RegulatedAuthorization)) {
            return false;
        }
        RegulatedAuthorization o = (RegulatedAuthorization)other_;
        return RegulatedAuthorization.compareValues(this.description, o.description, true) && RegulatedAuthorization.compareValues(this.statusDate, o.statusDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.subject, this.type, this.description, this.region, this.status, this.statusDate, this.validityPeriod, this.indication, this.intendedUse, this.basis, this.holder, this.regulator, this.attachedDocument, this.case_});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RegulatedAuthorization;
    }

    @Block
    public static class RegulatedAuthorizationCaseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier by which this case can be referenced", formalDefinition="Identifier by which this case can be referenced.")
        protected Identifier identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The defining type of case", formalDefinition="The defining type of case.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/regulated-authorization-case-type")
        protected CodeableConcept type;
        @Child(name="status", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status associated with the case", formalDefinition="The status associated with the case.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
        protected CodeableConcept status;
        @Child(name="date", type={Period.class, DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Relevant date for this case", formalDefinition="Relevant date for this case.")
        protected DataType date;
        @Child(name="application", type={RegulatedAuthorizationCaseComponent.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Applications submitted to obtain a regulated authorization. Steps within the longer running case or procedure", formalDefinition="A regulatory submission from an organization to a regulator, as part of an assessing case. Multiple applications may occur over time, with more or different information to support or modify the submission or the authorization. The applications can be considered as steps within the longer running case or procedure for this authorization process.")
        protected List<RegulatedAuthorizationCaseComponent> application;
        private static final long serialVersionUID = 2052202113L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RegulatedAuthorizationCaseComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public RegulatedAuthorizationCaseComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RegulatedAuthorizationCaseComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RegulatedAuthorizationCaseComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RegulatedAuthorizationCaseComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public RegulatedAuthorizationCaseComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DataType getDate() {
            return this.date;
        }

        public Period getDatePeriod() throws FHIRException {
            if (this.date == null) {
                this.date = new Period();
            }
            if (!(this.date instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.date.getClass().getName() + " was encountered");
            }
            return (Period)this.date;
        }

        public boolean hasDatePeriod() {
            return this != null && this.date instanceof Period;
        }

        public DateTimeType getDateDateTimeType() throws FHIRException {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            if (!(this.date instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.date.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.date;
        }

        public boolean hasDateDateTimeType() {
            return this != null && this.date instanceof DateTimeType;
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public RegulatedAuthorizationCaseComponent setDate(DataType value) {
            if (value != null && !(value instanceof Period) && !(value instanceof DateTimeType)) {
                throw new FHIRException("Not the right type for RegulatedAuthorization.case.date[x]: " + value.fhirType());
            }
            this.date = value;
            return this;
        }

        public List<RegulatedAuthorizationCaseComponent> getApplication() {
            if (this.application == null) {
                this.application = new ArrayList<RegulatedAuthorizationCaseComponent>();
            }
            return this.application;
        }

        public RegulatedAuthorizationCaseComponent setApplication(List<RegulatedAuthorizationCaseComponent> theApplication) {
            this.application = theApplication;
            return this;
        }

        public boolean hasApplication() {
            if (this.application == null) {
                return false;
            }
            for (RegulatedAuthorizationCaseComponent item : this.application) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RegulatedAuthorizationCaseComponent addApplication() {
            RegulatedAuthorizationCaseComponent t = new RegulatedAuthorizationCaseComponent();
            if (this.application == null) {
                this.application = new ArrayList<RegulatedAuthorizationCaseComponent>();
            }
            this.application.add(t);
            return t;
        }

        public RegulatedAuthorizationCaseComponent addApplication(RegulatedAuthorizationCaseComponent t) {
            if (t == null) {
                return this;
            }
            if (this.application == null) {
                this.application = new ArrayList<RegulatedAuthorizationCaseComponent>();
            }
            this.application.add(t);
            return this;
        }

        public RegulatedAuthorizationCaseComponent getApplicationFirstRep() {
            if (this.getApplication().isEmpty()) {
                this.addApplication();
            }
            return this.getApplication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(RegulatedAuthorization.SP_IDENTIFIER, "Identifier", "Identifier by which this case can be referenced.", 0, 1, this.identifier));
            children.add(new Property("type", "CodeableConcept", "The defining type of case.", 0, 1, this.type));
            children.add(new Property(RegulatedAuthorization.SP_STATUS, "CodeableConcept", "The status associated with the case.", 0, 1, this.status));
            children.add(new Property("date[x]", "Period|dateTime", "Relevant date for this case.", 0, 1, this.date));
            children.add(new Property("application", "@RegulatedAuthorization.case", "A regulatory submission from an organization to a regulator, as part of an assessing case. Multiple applications may occur over time, with more or different information to support or modify the submission or the authorization. The applications can be considered as steps within the longer running case or procedure for this authorization process.", 0, Integer.MAX_VALUE, this.application));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(RegulatedAuthorization.SP_IDENTIFIER, "Identifier", "Identifier by which this case can be referenced.", 0, 1, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The defining type of case.", 0, 1, this.type);
                }
                case -892481550: {
                    return new Property(RegulatedAuthorization.SP_STATUS, "CodeableConcept", "The status associated with the case.", 0, 1, this.status);
                }
                case 1443311122: {
                    return new Property("date[x]", "Period|dateTime", "Relevant date for this case.", 0, 1, this.date);
                }
                case 3076014: {
                    return new Property("date[x]", "Period|dateTime", "Relevant date for this case.", 0, 1, this.date);
                }
                case 432297743: {
                    return new Property("date[x]", "Period", "Relevant date for this case.", 0, 1, this.date);
                }
                case 185136489: {
                    return new Property("date[x]", "dateTime", "Relevant date for this case.", 0, 1, this.date);
                }
                case 1554253136: {
                    return new Property("application", "@RegulatedAuthorization.case", "A regulatory submission from an organization to a regulator, as part of an assessing case. Multiple applications may occur over time, with more or different information to support or modify the submission or the authorization. The applications can be considered as steps within the longer running case or procedure for this authorization process.", 0, Integer.MAX_VALUE, this.application);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.date;
                    }
                    return baseArray;
                }
                case 1554253136: {
                    return this.application == null ? new Base[]{} : this.application.toArray(new Base[this.application.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToType(value);
                    return value;
                }
                case 1554253136: {
                    this.getApplication().add((RegulatedAuthorizationCaseComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(RegulatedAuthorization.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(RegulatedAuthorization.SP_STATUS)) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("date[x]")) {
                this.date = TypeConvertor.castToType(value);
            } else if (name.equals("application")) {
                this.getApplication().add((RegulatedAuthorizationCaseComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 1443311122: {
                    return this.getDate();
                }
                case 3076014: {
                    return this.getDate();
                }
                case 1554253136: {
                    return this.addApplication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"Period", "dateTime"};
                }
                case 1554253136: {
                    return new String[]{"@RegulatedAuthorization.case"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(RegulatedAuthorization.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(RegulatedAuthorization.SP_STATUS)) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("datePeriod")) {
                this.date = new Period();
                return this.date;
            }
            if (name.equals("dateDateTime")) {
                this.date = new DateTimeType();
                return this.date;
            }
            if (name.equals("application")) {
                return this.addApplication();
            }
            return super.addChild(name);
        }

        @Override
        public RegulatedAuthorizationCaseComponent copy() {
            RegulatedAuthorizationCaseComponent dst = new RegulatedAuthorizationCaseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RegulatedAuthorizationCaseComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.status = this.status == null ? null : this.status.copy();
            DataType dataType = dst.date = this.date == null ? null : this.date.copy();
            if (this.application != null) {
                dst.application = new ArrayList<RegulatedAuthorizationCaseComponent>();
                for (RegulatedAuthorizationCaseComponent i : this.application) {
                    dst.application.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RegulatedAuthorizationCaseComponent)) {
                return false;
            }
            RegulatedAuthorizationCaseComponent o = (RegulatedAuthorizationCaseComponent)other_;
            return RegulatedAuthorizationCaseComponent.compareDeep(this.identifier, o.identifier, true) && RegulatedAuthorizationCaseComponent.compareDeep(this.type, o.type, true) && RegulatedAuthorizationCaseComponent.compareDeep(this.status, o.status, true) && RegulatedAuthorizationCaseComponent.compareDeep(this.date, o.date, true) && RegulatedAuthorizationCaseComponent.compareDeep(this.application, o.application, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RegulatedAuthorizationCaseComponent)) {
                return false;
            }
            RegulatedAuthorizationCaseComponent o = (RegulatedAuthorizationCaseComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.status, this.date, this.application});
        }

        @Override
        public String fhirType() {
            return "RegulatedAuthorization.case";
        }
    }
}

