/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RequestOrchestration", profile="http://hl7.org/fhir/StructureDefinition/RequestOrchestration")
public class RequestOrchestration
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Allows a service to provide a unique, business identifier for the request.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Fulfills plan, proposal, or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this request.")
    protected List<Reference> basedOn;
    @Child(name="replaces", type={Reference.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request(s) replaced by this request", formalDefinition="Completed or terminated request(s) whose function is taken by this new request.")
    protected List<Reference> replaces;
    @Child(name="groupIdentifier", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown", formalDefinition="The current state of the request. For request orchestrations, the status reflects the status of all the requests in the orchestration.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<Enumerations.RequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<Enumerations.RequestIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the request should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<Enumerations.RequestPriority> priority;
    @Child(name="code", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What's being requested/ordered", formalDefinition="A code that identifies what the overall request orchestration is.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-code")
    protected CodeableConcept code;
    @Child(name="subject", type={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who the request orchestration is about", formalDefinition="The subject for which the request orchestration was created.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Created as part of", formalDefinition="Describes the context of the request orchestration, if any.")
    protected Reference encounter;
    @Child(name="authoredOn", type={DateTimeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the request orchestration was authored", formalDefinition="Indicates when the request orchestration was created.")
    protected DateTimeType authoredOn;
    @Child(name="author", type={Device.class, Practitioner.class, PractitionerRole.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Device or practitioner that authored the request orchestration", formalDefinition="Provides a reference to the author of the request orchestration.")
    protected Reference author;
    @Child(name="reason", type={CodeableReference.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the request orchestration is needed", formalDefinition="Describes the reason for the request orchestration in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-reason-code")
    protected List<CodeableReference> reason;
    @Child(name="goal", type={Goal.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What goals", formalDefinition="Goals that are intended to be achieved by following the requests in this RequestOrchestration.")
    protected List<Reference> goal;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional notes about the response", formalDefinition="Provides a mechanism to communicate additional information about the response.")
    protected List<Annotation> note;
    @Child(name="action", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Proposed actions, if any", formalDefinition="The actions, if any, produced by the evaluation of the artifact.")
    protected List<RequestOrchestrationActionComponent> action;
    private static final long serialVersionUID = -683989911L;
    @SearchParamDefinition(name="author", path="RequestOrchestration.author", description="The author of the request orchestration", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("RequestOrchestration:author").toLocked();
    @SearchParamDefinition(name="authored", path="RequestOrchestration.authoredOn", description="The date the request orchestration was authored", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="based-on", path="RequestOrchestration.basedOn", description="What this request fullfills.", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("RequestOrchestration:based-on").toLocked();
    @SearchParamDefinition(name="group-identifier", path="RequestOrchestration.groupIdentifier", description="The group identifier for the request orchestration", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="instantiates-canonical", path="RequestOrchestration.instantiatesCanonical", description="The FHIR-based definition from which the request orchestration is realized", type="reference", target={ActivityDefinition.class, ActorDefinition.class, CapabilityStatement.class, ChargeItemDefinition.class, Citation.class, CodeSystem.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConditionDefinition.class, Contract.class, Device.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, GraphDefinition.class, ImplementationGuide.class, Library.class, Measure.class, MessageDefinition.class, NamingSystem.class, ObservationDefinition.class, OperationDefinition.class, PlanDefinition.class, Questionnaire.class, Requirements.class, ResearchStudy.class, SearchParameter.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, SubscriptionTopic.class, TerminologyCapabilities.class, TestPlan.class, TestScript.class, ValueSet.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("RequestOrchestration:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="RequestOrchestration.instantiatesUri", description="The external definition from which the request orchestration is realized", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="intent", path="RequestOrchestration.intent", description="The intent of the request orchestration", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="participant", path="RequestOrchestration.action.participant.actor.ofType(Reference) | RequestOrchestration.action.participant.actor.ofType(canonical)", description="The participant in the requests in the orchestration", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CapabilityStatement.class, CareTeam.class, Device.class, DeviceDefinition.class, Endpoint.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("RequestOrchestration:participant").toLocked();
    @SearchParamDefinition(name="priority", path="RequestOrchestration.priority", description="The priority of the request orchestration", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="status", path="RequestOrchestration.status", description="The status of the request orchestration", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="RequestOrchestration.subject", description="The subject that the request orchestration is about", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("RequestOrchestration:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter | CarePlan.encounter | ChargeItem.encounter | Claim.item.encounter | ClinicalImpression.encounter | Communication.encounter | CommunicationRequest.encounter | Composition.encounter | Condition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | EncounterHistory.encounter | ExplanationOfBenefit.item.encounter | Flag.encounter | ImagingStudy.encounter | List.encounter | MedicationDispense.encounter | MedicationStatement.encounter | NutritionIntake.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | Provenance.encounter | QuestionnaireResponse.encounter | RequestOrchestration.encounter | RiskAssessment.encounter | ServiceRequest.encounter | Task.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent\r\n* [CarePlan](careplan.html): The Encounter during which this CarePlan was created\r\n* [ChargeItem](chargeitem.html): Encounter associated with event\r\n* [Claim](claim.html): Encounters associated with a billed line item\r\n* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created\r\n* [Communication](communication.html): The Encounter during which this Communication was created\r\n* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created\r\n* [Composition](composition.html): Context of the Composition\r\n* [Condition](condition.html): The Encounter during which this Condition was created\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values\r\n* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [ImagingStudy](imagingstudy.html): The context of the study\r\n* [List](list.html): Context in which list created\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [Provenance](provenance.html): Encounter related to the Provenance\r\n* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response\r\n* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [Task](task.html): Search by encounter\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("RequestOrchestration:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RequestOrchestration:patient").toLocked();

    public RequestOrchestration() {
    }

    public RequestOrchestration(Enumerations.RequestStatus status, Enumerations.RequestIntent intent) {
        this.setStatus(status);
        this.setIntent(intent);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RequestOrchestration setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RequestOrchestration addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public RequestOrchestration setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public RequestOrchestration addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public RequestOrchestration setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public RequestOrchestration addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public RequestOrchestration setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public RequestOrchestration addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public RequestOrchestration setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public RequestOrchestration addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public RequestOrchestration setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<Enumerations.RequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public RequestOrchestration setStatusElement(Enumeration<Enumerations.RequestStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.RequestStatus getStatus() {
        return this.status == null ? null : (Enumerations.RequestStatus)((Object)this.status.getValue());
    }

    public RequestOrchestration setStatus(Enumerations.RequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.RequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public RequestOrchestration setIntentElement(Enumeration<Enumerations.RequestIntent> value) {
        this.intent = value;
        return this;
    }

    public Enumerations.RequestIntent getIntent() {
        return this.intent == null ? null : (Enumerations.RequestIntent)((Object)this.intent.getValue());
    }

    public RequestOrchestration setIntent(Enumerations.RequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public RequestOrchestration setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public Enumerations.RequestPriority getPriority() {
        return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
    }

    public RequestOrchestration setPriority(Enumerations.RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public RequestOrchestration setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public RequestOrchestration setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public RequestOrchestration setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public RequestOrchestration setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public RequestOrchestration setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestOrchestration.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public RequestOrchestration setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public RequestOrchestration setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public RequestOrchestration addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public RequestOrchestration setGoal(List<Reference> theGoal) {
        this.goal = theGoal;
        return this;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (Reference item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGoal() {
        Reference t = new Reference();
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return t;
    }

    public RequestOrchestration addGoal(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return this;
    }

    public Reference getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            this.addGoal();
        }
        return this.getGoal().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public RequestOrchestration setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public RequestOrchestration addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<RequestOrchestrationActionComponent> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<RequestOrchestrationActionComponent>();
        }
        return this.action;
    }

    public RequestOrchestration setAction(List<RequestOrchestrationActionComponent> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (RequestOrchestrationActionComponent item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RequestOrchestrationActionComponent addAction() {
        RequestOrchestrationActionComponent t = new RequestOrchestrationActionComponent();
        if (this.action == null) {
            this.action = new ArrayList<RequestOrchestrationActionComponent>();
        }
        this.action.add(t);
        return t;
    }

    public RequestOrchestration addAction(RequestOrchestrationActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<RequestOrchestrationActionComponent>();
        }
        this.action.add(t);
        return this;
    }

    public RequestOrchestrationActionComponent getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the request.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical", "A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(Any)", "A plan, proposal or order that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("replaces", "Reference(Any)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.", 0, 1, this.groupIdentifier));
        children.add(new Property(SP_STATUS, SP_CODE, "The current state of the request. For request orchestrations, the status reflects the status of all the requests in the orchestration.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, SP_CODE, "Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.", 0, 1, this.intent));
        children.add(new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that identifies what the overall request orchestration is.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The subject for which the request orchestration was created.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the context of the request orchestration, if any.", 0, 1, this.encounter));
        children.add(new Property("authoredOn", "dateTime", "Indicates when the request orchestration was created.", 0, 1, this.authoredOn));
        children.add(new Property(SP_AUTHOR, "Reference(Device|Practitioner|PractitionerRole)", "Provides a reference to the author of the request orchestration.", 0, 1, this.author));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Describes the reason for the request orchestration in coded or textual form.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this RequestOrchestration.", 0, Integer.MAX_VALUE, this.goal));
        children.add(new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the request.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical", "A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "A plan, proposal or order that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property("replaces", "Reference(Any)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to multiple independent Request instances that were activated/authorized more or less simultaneously by a single author.  The presence of the same identifier on each request ties those requests together and may have business ramifications in terms of reporting of results, billing, etc.  E.g. a requisition number shared by a set of lab tests ordered together, or a prescription number shared by all meds ordered at one time.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The current state of the request. For request orchestrations, the status reflects the status of all the requests in the orchestration.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that identifies what the overall request orchestration is.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The subject for which the request orchestration was created.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the context of the request orchestration, if any.", 0, 1, this.encounter);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "Indicates when the request orchestration was created.", 0, 1, this.authoredOn);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Device|Practitioner|PractitionerRole)", "Provides a reference to the author of the request orchestration.", 0, 1, this.author);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Describes the reason for the request orchestration in coded or textual form.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3178259: {
                return new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this RequestOrchestration.", 0, Integer.MAX_VALUE, this.goal);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1422950858: {
                return new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.encounter;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.authoredOn;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.author;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new Enumerations.RequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3178259: {
                this.getGoal().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1422950858: {
                this.getAction().add((RequestOrchestrationActionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("replaces")) {
            this.getReplaces().add(TypeConvertor.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new Enumerations.RequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_PRIORITY)) {
            value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.priority = value;
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("goal")) {
            this.getGoal().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("action")) {
            this.getAction().add((RequestOrchestrationActionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3178259: {
                return this.addGoal();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3178259: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1422950858: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("replaces")) {
            return this.addReplaces();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.intent");
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.priority");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.authoredOn");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("goal")) {
            return this.addGoal();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RequestOrchestration";
    }

    @Override
    public RequestOrchestration copy() {
        RequestOrchestration dst = new RequestOrchestration();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RequestOrchestration dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<Reference>();
            for (Reference reference2 : this.goal) {
                dst.goal.add(reference2.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<RequestOrchestrationActionComponent>();
            for (RequestOrchestrationActionComponent requestOrchestrationActionComponent : this.action) {
                dst.action.add(requestOrchestrationActionComponent.copy());
            }
        }
    }

    protected RequestOrchestration typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RequestOrchestration)) {
            return false;
        }
        RequestOrchestration o = (RequestOrchestration)other_;
        return RequestOrchestration.compareDeep(this.identifier, o.identifier, true) && RequestOrchestration.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && RequestOrchestration.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && RequestOrchestration.compareDeep(this.basedOn, o.basedOn, true) && RequestOrchestration.compareDeep(this.replaces, o.replaces, true) && RequestOrchestration.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && RequestOrchestration.compareDeep(this.status, o.status, true) && RequestOrchestration.compareDeep(this.intent, o.intent, true) && RequestOrchestration.compareDeep(this.priority, o.priority, true) && RequestOrchestration.compareDeep(this.code, o.code, true) && RequestOrchestration.compareDeep(this.subject, o.subject, true) && RequestOrchestration.compareDeep(this.encounter, o.encounter, true) && RequestOrchestration.compareDeep(this.authoredOn, o.authoredOn, true) && RequestOrchestration.compareDeep(this.author, o.author, true) && RequestOrchestration.compareDeep(this.reason, o.reason, true) && RequestOrchestration.compareDeep(this.goal, o.goal, true) && RequestOrchestration.compareDeep(this.note, o.note, true) && RequestOrchestration.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RequestOrchestration)) {
            return false;
        }
        RequestOrchestration o = (RequestOrchestration)other_;
        return RequestOrchestration.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && RequestOrchestration.compareValues(this.instantiatesUri, o.instantiatesUri, true) && RequestOrchestration.compareValues(this.status, o.status, true) && RequestOrchestration.compareValues(this.intent, o.intent, true) && RequestOrchestration.compareValues(this.priority, o.priority, true) && RequestOrchestration.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.intent, this.priority, this.code, this.subject, this.encounter, this.authoredOn, this.author, this.reason, this.goal, this.note, this.action});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RequestOrchestration;
    }

    @Block
    public static class RequestOrchestrationActionDynamicValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="path", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The path to the element to be set dynamically", formalDefinition="The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolvable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).")
        protected StringType path;
        @Child(name="expression", type={Expression.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An expression that provides the dynamic value for the customization", formalDefinition="An expression specifying the value of the customized element.")
        protected Expression expression;
        private static final long serialVersionUID = 1064529082L;

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionDynamicValueComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public RequestOrchestrationActionDynamicValueComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public RequestOrchestrationActionDynamicValueComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionDynamicValueComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public RequestOrchestrationActionDynamicValueComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolvable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, 1, this.path));
            children.add(new Property("expression", "Expression", "An expression specifying the value of the customized element.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolvable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, 1, this.path);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "An expression specifying the value of the customized element.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.dynamicValue.path");
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionDynamicValueComponent copy() {
            RequestOrchestrationActionDynamicValueComponent dst = new RequestOrchestrationActionDynamicValueComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionDynamicValueComponent dst) {
            super.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionDynamicValueComponent)) {
                return false;
            }
            RequestOrchestrationActionDynamicValueComponent o = (RequestOrchestrationActionDynamicValueComponent)other_;
            return RequestOrchestrationActionDynamicValueComponent.compareDeep(this.path, o.path, true) && RequestOrchestrationActionDynamicValueComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionDynamicValueComponent)) {
                return false;
            }
            RequestOrchestrationActionDynamicValueComponent o = (RequestOrchestrationActionDynamicValueComponent)other_;
            return RequestOrchestrationActionDynamicValueComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.expression});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action.dynamicValue";
        }
    }

    @Block
    public static class RequestOrchestrationActionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="careteam | device | group | healthcareservice | location | organization | patient | practitioner | practitionerrole | relatedperson", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected Enumeration<Enumerations.ActionParticipantType> type;
        @Child(name="typeCanonical", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who or what can participate", formalDefinition="The type of participant in the action.")
        protected CanonicalType typeCanonical;
        @Child(name="typeReference", type={CareTeam.class, Device.class, DeviceDefinition.class, Endpoint.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who or what can participate", formalDefinition="The type of participant in the action.")
        protected Reference typeReference;
        @Child(name="role", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent, etc", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/action-participant-role")
        protected CodeableConcept role;
        @Child(name="function", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Author, Reviewer, Witness, etc", formalDefinition="Indicates how the actor will be involved in the action - author, reviewer, witness, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-function")
        protected CodeableConcept function;
        @Child(name="actor", type={CanonicalType.class, CareTeam.class, Device.class, DeviceDefinition.class, Endpoint.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who/what is participating?", formalDefinition="A reference to the actual participant.")
        protected DataType actor;
        private static final long serialVersionUID = -147206285L;

        public Enumeration<Enumerations.ActionParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RequestOrchestrationActionParticipantComponent setTypeElement(Enumeration<Enumerations.ActionParticipantType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.ActionParticipantType getType() {
            return this.type == null ? null : (Enumerations.ActionParticipantType)((Object)this.type.getValue());
        }

        public RequestOrchestrationActionParticipantComponent setType(Enumerations.ActionParticipantType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public CanonicalType getTypeCanonicalElement() {
            if (this.typeCanonical == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionParticipantComponent.typeCanonical");
                }
                if (Configuration.doAutoCreate()) {
                    this.typeCanonical = new CanonicalType();
                }
            }
            return this.typeCanonical;
        }

        public boolean hasTypeCanonicalElement() {
            return this.typeCanonical != null && !this.typeCanonical.isEmpty();
        }

        public boolean hasTypeCanonical() {
            return this.typeCanonical != null && !this.typeCanonical.isEmpty();
        }

        public RequestOrchestrationActionParticipantComponent setTypeCanonicalElement(CanonicalType value) {
            this.typeCanonical = value;
            return this;
        }

        public String getTypeCanonical() {
            return this.typeCanonical == null ? null : (String)this.typeCanonical.getValue();
        }

        public RequestOrchestrationActionParticipantComponent setTypeCanonical(String value) {
            if (Utilities.noString((String)value)) {
                this.typeCanonical = null;
            } else {
                if (this.typeCanonical == null) {
                    this.typeCanonical = new CanonicalType();
                }
                this.typeCanonical.setValue(value);
            }
            return this;
        }

        public Reference getTypeReference() {
            if (this.typeReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionParticipantComponent.typeReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.typeReference = new Reference();
                }
            }
            return this.typeReference;
        }

        public boolean hasTypeReference() {
            return this.typeReference != null && !this.typeReference.isEmpty();
        }

        public RequestOrchestrationActionParticipantComponent setTypeReference(Reference value) {
            this.typeReference = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public RequestOrchestrationActionParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public RequestOrchestrationActionParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public DataType getActor() {
            return this.actor;
        }

        public CanonicalType getActorCanonicalType() throws FHIRException {
            if (this.actor == null) {
                this.actor = new CanonicalType();
            }
            if (!(this.actor instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.actor.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.actor;
        }

        public boolean hasActorCanonicalType() {
            return this != null && this.actor instanceof CanonicalType;
        }

        public Reference getActorReference() throws FHIRException {
            if (this.actor == null) {
                this.actor = new Reference();
            }
            if (!(this.actor instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.actor.getClass().getName() + " was encountered");
            }
            return (Reference)this.actor;
        }

        public boolean hasActorReference() {
            return this != null && this.actor instanceof Reference;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public RequestOrchestrationActionParticipantComponent setActor(DataType value) {
            if (value != null && !(value instanceof CanonicalType) && !(value instanceof Reference)) {
                throw new FHIRException("Not the right type for RequestOrchestration.action.participant.actor[x]: " + value.fhirType());
            }
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", RequestOrchestration.SP_CODE, "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("typeCanonical", "canonical(CapabilityStatement)", "The type of participant in the action.", 0, 1, this.typeCanonical));
            children.add(new Property("typeReference", "Reference(CareTeam|Device|DeviceDefinition|Endpoint|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
            children.add(new Property("function", "CodeableConcept", "Indicates how the actor will be involved in the action - author, reviewer, witness, etc.", 0, 1, this.function));
            children.add(new Property("actor[x]", "canonical(CapabilityStatement)|Reference(CareTeam|Device|DeviceDefinition|Endpoint|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "A reference to the actual participant.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", RequestOrchestration.SP_CODE, "The type of participant in the action.", 0, 1, this.type);
                }
                case -466635046: {
                    return new Property("typeCanonical", "canonical(CapabilityStatement)", "The type of participant in the action.", 0, 1, this.typeCanonical);
                }
                case 2074825009: {
                    return new Property("typeReference", "Reference(CareTeam|Device|DeviceDefinition|Endpoint|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Indicates how the actor will be involved in the action - author, reviewer, witness, etc.", 0, 1, this.function);
                }
                case -1650558357: {
                    return new Property("actor[x]", "canonical(CapabilityStatement)|Reference(CareTeam|Device|DeviceDefinition|Endpoint|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "A reference to the actual participant.", 0, 1, this.actor);
                }
                case 92645877: {
                    return new Property("actor[x]", "canonical(CapabilityStatement)|Reference(CareTeam|Device|DeviceDefinition|Endpoint|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "A reference to the actual participant.", 0, 1, this.actor);
                }
                case 1323531903: {
                    return new Property("actor[x]", "canonical(CapabilityStatement)", "A reference to the actual participant.", 0, 1, this.actor);
                }
                case -429975338: {
                    return new Property("actor[x]", "Reference(CareTeam|Device|DeviceDefinition|Endpoint|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "A reference to the actual participant.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -466635046: {
                    Base[] baseArray;
                    if (this.typeCanonical == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.typeCanonical;
                    }
                    return baseArray;
                }
                case 2074825009: {
                    Base[] baseArray;
                    if (this.typeReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.typeReference;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.role;
                    }
                    return baseArray;
                }
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new Enumerations.ActionParticipantTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -466635046: {
                    this.typeCanonical = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 2074825009: {
                    this.typeReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new Enumerations.ActionParticipantTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("typeCanonical")) {
                this.typeCanonical = TypeConvertor.castToCanonical(value);
            } else if (name.equals("typeReference")) {
                this.typeReference = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor[x]")) {
                this.actor = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -466635046: {
                    return this.getTypeCanonicalElement();
                }
                case 2074825009: {
                    return this.getTypeReference();
                }
                case 3506294: {
                    return this.getRole();
                }
                case 1380938712: {
                    return this.getFunction();
                }
                case -1650558357: {
                    return this.getActor();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -466635046: {
                    return new String[]{"canonical"};
                }
                case 2074825009: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"canonical", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.participant.type");
            }
            if (name.equals("typeCanonical")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.participant.typeCanonical");
            }
            if (name.equals("typeReference")) {
                this.typeReference = new Reference();
                return this.typeReference;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actorCanonical")) {
                this.actor = new CanonicalType();
                return this.actor;
            }
            if (name.equals("actorReference")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionParticipantComponent copy() {
            RequestOrchestrationActionParticipantComponent dst = new RequestOrchestrationActionParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionParticipantComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.typeCanonical = this.typeCanonical == null ? null : this.typeCanonical.copy();
            dst.typeReference = this.typeReference == null ? null : this.typeReference.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionParticipantComponent)) {
                return false;
            }
            RequestOrchestrationActionParticipantComponent o = (RequestOrchestrationActionParticipantComponent)other_;
            return RequestOrchestrationActionParticipantComponent.compareDeep(this.type, o.type, true) && RequestOrchestrationActionParticipantComponent.compareDeep(this.typeCanonical, o.typeCanonical, true) && RequestOrchestrationActionParticipantComponent.compareDeep(this.typeReference, o.typeReference, true) && RequestOrchestrationActionParticipantComponent.compareDeep(this.role, o.role, true) && RequestOrchestrationActionParticipantComponent.compareDeep(this.function, o.function, true) && RequestOrchestrationActionParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionParticipantComponent)) {
                return false;
            }
            RequestOrchestrationActionParticipantComponent o = (RequestOrchestrationActionParticipantComponent)other_;
            return RequestOrchestrationActionParticipantComponent.compareValues(this.type, o.type, true) && RequestOrchestrationActionParticipantComponent.compareValues(this.typeCanonical, o.typeCanonical, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.typeCanonical, this.typeReference, this.role, this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action.participant";
        }
    }

    @Block
    public static class RequestOrchestrationActionRelatedActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="targetId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What action this is related to", formalDefinition="The element id of the target related action.")
        protected IdType targetId;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before | before-start | before-end | concurrent | concurrent-with-start | concurrent-with-end | after | after-start | after-end", formalDefinition="The relationship of this action to the related action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type")
        protected Enumeration<Enumerations.ActionRelationshipType> relationship;
        @Child(name="endRelationship", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before | before-start | before-end | concurrent | concurrent-with-start | concurrent-with-end | after | after-start | after-end", formalDefinition="The relationship of the end of this action to the related action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type")
        protected Enumeration<Enumerations.ActionRelationshipType> endRelationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected DataType offset;
        private static final long serialVersionUID = 1997058061L;

        public RequestOrchestrationActionRelatedActionComponent() {
        }

        public RequestOrchestrationActionRelatedActionComponent(String targetId, Enumerations.ActionRelationshipType relationship) {
            this.setTargetId(targetId);
            this.setRelationship(relationship);
        }

        public IdType getTargetIdElement() {
            if (this.targetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionRelatedActionComponent.targetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetId = new IdType();
                }
            }
            return this.targetId;
        }

        public boolean hasTargetIdElement() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public boolean hasTargetId() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public RequestOrchestrationActionRelatedActionComponent setTargetIdElement(IdType value) {
            this.targetId = value;
            return this;
        }

        public String getTargetId() {
            return this.targetId == null ? null : this.targetId.getValue();
        }

        public RequestOrchestrationActionRelatedActionComponent setTargetId(String value) {
            if (this.targetId == null) {
                this.targetId = new IdType();
            }
            this.targetId.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.ActionRelationshipType> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RequestOrchestrationActionRelatedActionComponent setRelationshipElement(Enumeration<Enumerations.ActionRelationshipType> value) {
            this.relationship = value;
            return this;
        }

        public Enumerations.ActionRelationshipType getRelationship() {
            return this.relationship == null ? null : (Enumerations.ActionRelationshipType)((Object)this.relationship.getValue());
        }

        public RequestOrchestrationActionRelatedActionComponent setRelationship(Enumerations.ActionRelationshipType value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public Enumeration<Enumerations.ActionRelationshipType> getEndRelationshipElement() {
            if (this.endRelationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionRelatedActionComponent.endRelationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.endRelationship = new Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
                }
            }
            return this.endRelationship;
        }

        public boolean hasEndRelationshipElement() {
            return this.endRelationship != null && !this.endRelationship.isEmpty();
        }

        public boolean hasEndRelationship() {
            return this.endRelationship != null && !this.endRelationship.isEmpty();
        }

        public RequestOrchestrationActionRelatedActionComponent setEndRelationshipElement(Enumeration<Enumerations.ActionRelationshipType> value) {
            this.endRelationship = value;
            return this;
        }

        public Enumerations.ActionRelationshipType getEndRelationship() {
            return this.endRelationship == null ? null : (Enumerations.ActionRelationshipType)((Object)this.endRelationship.getValue());
        }

        public RequestOrchestrationActionRelatedActionComponent setEndRelationship(Enumerations.ActionRelationshipType value) {
            if (value == null) {
                this.endRelationship = null;
            } else {
                if (this.endRelationship == null) {
                    this.endRelationship = new Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
                }
                this.endRelationship.setValue((Object)value);
            }
            return this;
        }

        public DataType getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (this.offset == null) {
                this.offset = new Duration();
            }
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this != null && this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (this.offset == null) {
                this.offset = new Range();
            }
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this != null && this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public RequestOrchestrationActionRelatedActionComponent setOffset(DataType value) {
            if (value != null && !(value instanceof Duration) && !(value instanceof Range)) {
                throw new FHIRException("Not the right type for RequestOrchestration.action.relatedAction.offset[x]: " + value.fhirType());
            }
            this.offset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("targetId", "id", "The element id of the target related action.", 0, 1, this.targetId));
            children.add(new Property("relationship", RequestOrchestration.SP_CODE, "The relationship of this action to the related action.", 0, 1, this.relationship));
            children.add(new Property("endRelationship", RequestOrchestration.SP_CODE, "The relationship of the end of this action to the related action.", 0, 1, this.endRelationship));
            children.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -441951604: {
                    return new Property("targetId", "id", "The element id of the target related action.", 0, 1, this.targetId);
                }
                case -261851592: {
                    return new Property("relationship", RequestOrchestration.SP_CODE, "The relationship of this action to the related action.", 0, 1, this.relationship);
                }
                case -1506024781: {
                    return new Property("endRelationship", RequestOrchestration.SP_CODE, "The relationship of the end of this action to the related action.", 0, 1, this.endRelationship);
                }
                case -1960684787: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case -1019779949: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 134075207: {
                    return new Property("offset[x]", "Duration", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 1263585386: {
                    return new Property("offset[x]", "Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    Base[] baseArray;
                    if (this.targetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.targetId;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1506024781: {
                    Base[] baseArray;
                    if (this.endRelationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.endRelationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    this.targetId = TypeConvertor.castToId(value);
                    return value;
                }
                case -261851592: {
                    value = new Enumerations.ActionRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case -1506024781: {
                    value = new Enumerations.ActionRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.endRelationship = value;
                    return value;
                }
                case -1019779949: {
                    this.offset = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("targetId")) {
                this.targetId = TypeConvertor.castToId(value);
            } else if (name.equals("relationship")) {
                value = new Enumerations.ActionRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("endRelationship")) {
                value = new Enumerations.ActionRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.endRelationship = value;
            } else if (name.equals("offset[x]")) {
                this.offset = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    return this.getTargetIdElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -1506024781: {
                    return this.getEndRelationshipElement();
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1019779949: {
                    return this.getOffset();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    return new String[]{"id"};
                }
                case -261851592: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -1506024781: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -1019779949: {
                    return new String[]{"Duration", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("targetId")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.relatedAction.targetId");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.relatedAction.relationship");
            }
            if (name.equals("endRelationship")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.relatedAction.endRelationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionRelatedActionComponent copy() {
            RequestOrchestrationActionRelatedActionComponent dst = new RequestOrchestrationActionRelatedActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionRelatedActionComponent dst) {
            super.copyValues(dst);
            dst.targetId = this.targetId == null ? null : this.targetId.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.endRelationship = this.endRelationship == null ? null : this.endRelationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionRelatedActionComponent)) {
                return false;
            }
            RequestOrchestrationActionRelatedActionComponent o = (RequestOrchestrationActionRelatedActionComponent)other_;
            return RequestOrchestrationActionRelatedActionComponent.compareDeep(this.targetId, o.targetId, true) && RequestOrchestrationActionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && RequestOrchestrationActionRelatedActionComponent.compareDeep(this.endRelationship, o.endRelationship, true) && RequestOrchestrationActionRelatedActionComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionRelatedActionComponent)) {
                return false;
            }
            RequestOrchestrationActionRelatedActionComponent o = (RequestOrchestrationActionRelatedActionComponent)other_;
            return RequestOrchestrationActionRelatedActionComponent.compareValues(this.targetId, o.targetId, true) && RequestOrchestrationActionRelatedActionComponent.compareValues(this.relationship, o.relationship, true) && RequestOrchestrationActionRelatedActionComponent.compareValues(this.endRelationship, o.endRelationship, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.targetId, this.relationship, this.endRelationship, this.offset});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action.relatedAction";
        }
    }

    @Block
    public static class RequestOrchestrationActionOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.")
        protected StringType title;
        @Child(name="requirement", type={DataRequirement.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Defines the data that results as output from the action.")
        protected DataRequirement requirement;
        @Child(name="relatedData", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Points to an existing input or output element that is results as output from the action.")
        protected StringType relatedData;
        private static final long serialVersionUID = 1822414421L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionOutputComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public RequestOrchestrationActionOutputComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public RequestOrchestrationActionOutputComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public DataRequirement getRequirement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionOutputComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new DataRequirement();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public RequestOrchestrationActionOutputComponent setRequirement(DataRequirement value) {
            this.requirement = value;
            return this;
        }

        public StringType getRelatedDataElement() {
            if (this.relatedData == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionOutputComponent.relatedData");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedData = new StringType();
                }
            }
            return this.relatedData;
        }

        public boolean hasRelatedDataElement() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public boolean hasRelatedData() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public RequestOrchestrationActionOutputComponent setRelatedDataElement(StringType value) {
            this.relatedData = value;
            return this;
        }

        public String getRelatedData() {
            return this.relatedData == null ? null : (String)this.relatedData.getValue();
        }

        public RequestOrchestrationActionOutputComponent setRelatedData(String value) {
            if (Utilities.noString((String)value)) {
                this.relatedData = null;
            } else {
                if (this.relatedData == null) {
                    this.relatedData = new StringType();
                }
                this.relatedData.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title));
            children.add(new Property("requirement", "DataRequirement", "Defines the data that results as output from the action.", 0, 1, this.requirement));
            children.add(new Property("relatedData", "string", "Points to an existing input or output element that is results as output from the action.", 0, 1, this.relatedData));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title);
                }
                case 363387971: {
                    return new Property("requirement", "DataRequirement", "Defines the data that results as output from the action.", 0, 1, this.requirement);
                }
                case 1112535669: {
                    return new Property("relatedData", "string", "Points to an existing input or output element that is results as output from the action.", 0, 1, this.relatedData);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1112535669: {
                    Base[] baseArray;
                    if (this.relatedData == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relatedData;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = TypeConvertor.castToDataRequirement(value);
                    return value;
                }
                case 1112535669: {
                    this.relatedData = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("requirement")) {
                this.requirement = TypeConvertor.castToDataRequirement(value);
            } else if (name.equals("relatedData")) {
                this.relatedData = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 363387971: {
                    return this.getRequirement();
                }
                case 1112535669: {
                    return this.getRelatedDataElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 363387971: {
                    return new String[]{"DataRequirement"};
                }
                case 1112535669: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.output.title");
            }
            if (name.equals("requirement")) {
                this.requirement = new DataRequirement();
                return this.requirement;
            }
            if (name.equals("relatedData")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.output.relatedData");
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionOutputComponent copy() {
            RequestOrchestrationActionOutputComponent dst = new RequestOrchestrationActionOutputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionOutputComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            dst.relatedData = this.relatedData == null ? null : this.relatedData.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionOutputComponent)) {
                return false;
            }
            RequestOrchestrationActionOutputComponent o = (RequestOrchestrationActionOutputComponent)other_;
            return RequestOrchestrationActionOutputComponent.compareDeep(this.title, o.title, true) && RequestOrchestrationActionOutputComponent.compareDeep(this.requirement, o.requirement, true) && RequestOrchestrationActionOutputComponent.compareDeep(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionOutputComponent)) {
                return false;
            }
            RequestOrchestrationActionOutputComponent o = (RequestOrchestrationActionOutputComponent)other_;
            return RequestOrchestrationActionOutputComponent.compareValues(this.title, o.title, true) && RequestOrchestrationActionOutputComponent.compareValues(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.title, this.requirement, this.relatedData});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action.output";
        }
    }

    @Block
    public static class RequestOrchestrationActionInputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.")
        protected StringType title;
        @Child(name="requirement", type={DataRequirement.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Defines the data that is to be provided as input to the action.")
        protected DataRequirement requirement;
        @Child(name="relatedData", type={IdType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Points to an existing input or output element that provides data to this input.")
        protected IdType relatedData;
        private static final long serialVersionUID = -1064046709L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionInputComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public RequestOrchestrationActionInputComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public RequestOrchestrationActionInputComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public DataRequirement getRequirement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionInputComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new DataRequirement();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public RequestOrchestrationActionInputComponent setRequirement(DataRequirement value) {
            this.requirement = value;
            return this;
        }

        public IdType getRelatedDataElement() {
            if (this.relatedData == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionInputComponent.relatedData");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedData = new IdType();
                }
            }
            return this.relatedData;
        }

        public boolean hasRelatedDataElement() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public boolean hasRelatedData() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public RequestOrchestrationActionInputComponent setRelatedDataElement(IdType value) {
            this.relatedData = value;
            return this;
        }

        public String getRelatedData() {
            return this.relatedData == null ? null : this.relatedData.getValue();
        }

        public RequestOrchestrationActionInputComponent setRelatedData(String value) {
            if (Utilities.noString((String)value)) {
                this.relatedData = null;
            } else {
                if (this.relatedData == null) {
                    this.relatedData = new IdType();
                }
                this.relatedData.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title));
            children.add(new Property("requirement", "DataRequirement", "Defines the data that is to be provided as input to the action.", 0, 1, this.requirement));
            children.add(new Property("relatedData", "id", "Points to an existing input or output element that provides data to this input.", 0, 1, this.relatedData));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title);
                }
                case 363387971: {
                    return new Property("requirement", "DataRequirement", "Defines the data that is to be provided as input to the action.", 0, 1, this.requirement);
                }
                case 1112535669: {
                    return new Property("relatedData", "id", "Points to an existing input or output element that provides data to this input.", 0, 1, this.relatedData);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1112535669: {
                    Base[] baseArray;
                    if (this.relatedData == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relatedData;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = TypeConvertor.castToDataRequirement(value);
                    return value;
                }
                case 1112535669: {
                    this.relatedData = TypeConvertor.castToId(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("requirement")) {
                this.requirement = TypeConvertor.castToDataRequirement(value);
            } else if (name.equals("relatedData")) {
                this.relatedData = TypeConvertor.castToId(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 363387971: {
                    return this.getRequirement();
                }
                case 1112535669: {
                    return this.getRelatedDataElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 363387971: {
                    return new String[]{"DataRequirement"};
                }
                case 1112535669: {
                    return new String[]{"id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.input.title");
            }
            if (name.equals("requirement")) {
                this.requirement = new DataRequirement();
                return this.requirement;
            }
            if (name.equals("relatedData")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.input.relatedData");
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionInputComponent copy() {
            RequestOrchestrationActionInputComponent dst = new RequestOrchestrationActionInputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionInputComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            dst.relatedData = this.relatedData == null ? null : this.relatedData.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionInputComponent)) {
                return false;
            }
            RequestOrchestrationActionInputComponent o = (RequestOrchestrationActionInputComponent)other_;
            return RequestOrchestrationActionInputComponent.compareDeep(this.title, o.title, true) && RequestOrchestrationActionInputComponent.compareDeep(this.requirement, o.requirement, true) && RequestOrchestrationActionInputComponent.compareDeep(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionInputComponent)) {
                return false;
            }
            RequestOrchestrationActionInputComponent o = (RequestOrchestrationActionInputComponent)other_;
            return RequestOrchestrationActionInputComponent.compareValues(this.title, o.title, true) && RequestOrchestrationActionInputComponent.compareValues(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.title, this.requirement, this.relatedData});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action.input";
        }
    }

    @Block
    public static class RequestOrchestrationActionConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kind", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="applicability | start | stop", formalDefinition="The kind of condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind")
        protected Enumeration<Enumerations.ActionConditionKind> kind;
        @Child(name="expression", type={Expression.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether or not the condition is satisfied.")
        protected Expression expression;
        private static final long serialVersionUID = -455150438L;

        public RequestOrchestrationActionConditionComponent() {
        }

        public RequestOrchestrationActionConditionComponent(Enumerations.ActionConditionKind kind) {
            this.setKind(kind);
        }

        public Enumeration<Enumerations.ActionConditionKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionConditionComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<Enumerations.ActionConditionKind>(new Enumerations.ActionConditionKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public RequestOrchestrationActionConditionComponent setKindElement(Enumeration<Enumerations.ActionConditionKind> value) {
            this.kind = value;
            return this;
        }

        public Enumerations.ActionConditionKind getKind() {
            return this.kind == null ? null : (Enumerations.ActionConditionKind)((Object)this.kind.getValue());
        }

        public RequestOrchestrationActionConditionComponent setKind(Enumerations.ActionConditionKind value) {
            if (this.kind == null) {
                this.kind = new Enumeration<Enumerations.ActionConditionKind>(new Enumerations.ActionConditionKindEnumFactory());
            }
            this.kind.setValue((Object)value);
            return this;
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionConditionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public RequestOrchestrationActionConditionComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kind", RequestOrchestration.SP_CODE, "The kind of condition.", 0, 1, this.kind));
            children.add(new Property("expression", "Expression", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3292052: {
                    return new Property("kind", RequestOrchestration.SP_CODE, "The kind of condition.", 0, 1, this.kind);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kind;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    value = new Enumerations.ActionConditionKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.kind = value;
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kind")) {
                value = new Enumerations.ActionConditionKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return this.getKindElement();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.condition.kind");
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionConditionComponent copy() {
            RequestOrchestrationActionConditionComponent dst = new RequestOrchestrationActionConditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionConditionComponent dst) {
            super.copyValues(dst);
            dst.kind = this.kind == null ? null : this.kind.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionConditionComponent)) {
                return false;
            }
            RequestOrchestrationActionConditionComponent o = (RequestOrchestrationActionConditionComponent)other_;
            return RequestOrchestrationActionConditionComponent.compareDeep(this.kind, o.kind, true) && RequestOrchestrationActionConditionComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionConditionComponent)) {
                return false;
            }
            RequestOrchestrationActionConditionComponent o = (RequestOrchestrationActionConditionComponent)other_;
            return RequestOrchestrationActionConditionComponent.compareValues(this.kind, o.kind, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.kind, this.expression});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action.condition";
        }
    }

    @Block
    public static class RequestOrchestrationActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item from the PlanDefinition", formalDefinition="The linkId of the action from the PlanDefinition that corresponds to this action in the RequestOrchestration resource.")
        protected StringType linkId;
        @Child(name="prefix", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible prefix for the action (e.g. 1. or A.)", formalDefinition="A user-visible prefix for the action. For example a section or item numbering such as 1. or A.")
        protected StringType prefix;
        @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="The title of the action displayed to a user.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short description of the action", formalDefinition="A short description of the action used to provide a summary to display to the user.")
        protected MarkdownType description;
        @Child(name="textEquivalent", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.")
        protected MarkdownType textEquivalent;
        @Child(name="priority", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the action should be addressed with respect to other actions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
        protected Enumeration<Enumerations.RequestPriority> priority;
        @Child(name="code", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Code representing the meaning of the action or sub-actions", formalDefinition="A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-code")
        protected List<CodeableConcept> code;
        @Child(name="documentation", type={RelatedArtifact.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="goal", type={Goal.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What goals", formalDefinition="Goals that are intended to be achieved by following the requests in this action.")
        protected List<Reference> goal;
        @Child(name="condition", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not the action is applicable", formalDefinition="An expression that describes applicability criteria, or start/stop conditions for the action.")
        protected List<RequestOrchestrationActionConditionComponent> condition;
        @Child(name="input", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Input data requirements", formalDefinition="Defines input data requirements for the action.")
        protected List<RequestOrchestrationActionInputComponent> input;
        @Child(name="output", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Output data definition", formalDefinition="Defines the outputs of the action, if any.")
        protected List<RequestOrchestrationActionOutputComponent> output;
        @Child(name="relatedAction", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
        protected List<RequestOrchestrationActionRelatedActionComponent> relatedAction;
        @Child(name="timing", type={DateTimeType.class, Age.class, Period.class, Duration.class, Range.class, Timing.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should take place", formalDefinition="An optional value describing when the action should be performed.")
        protected DataType timing;
        @Child(name="location", type={CodeableReference.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.")
        protected CodeableReference location;
        @Child(name="participant", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who should perform the action", formalDefinition="The participant that should perform or be responsible for this action.")
        protected List<RequestOrchestrationActionParticipantComponent> participant;
        @Child(name="type", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-type")
        protected CodeableConcept type;
        @Child(name="groupingBehavior", type={CodeType.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="visual-group | logical-group | sentence-group", formalDefinition="Defines the grouping behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior")
        protected Enumeration<Enumerations.ActionGroupingBehavior> groupingBehavior;
        @Child(name="selectionBehavior", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="any | all | all-or-none | exactly-one | at-most-one | one-or-more", formalDefinition="Defines the selection behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior")
        protected Enumeration<Enumerations.ActionSelectionBehavior> selectionBehavior;
        @Child(name="requiredBehavior", type={CodeType.class}, order=20, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="must | could | must-unless-documented", formalDefinition="Defines expectations around whether an action is required.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior")
        protected Enumeration<Enumerations.ActionRequiredBehavior> requiredBehavior;
        @Child(name="precheckBehavior", type={CodeType.class}, order=21, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="yes | no", formalDefinition="Defines whether the action should usually be preselected.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior")
        protected Enumeration<Enumerations.ActionPrecheckBehavior> precheckBehavior;
        @Child(name="cardinalityBehavior", type={CodeType.class}, order=22, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="single | multiple", formalDefinition="Defines whether the action can be selected multiple times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior")
        protected Enumeration<Enumerations.ActionCardinalityBehavior> cardinalityBehavior;
        @Child(name="resource", type={Reference.class}, order=23, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The target of the action", formalDefinition="The resource that is the target of the action (e.g. CommunicationRequest).")
        protected Reference resource;
        @Child(name="definition", type={CanonicalType.class, UriType.class}, order=24, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the activity to be performed", formalDefinition="A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, a SpecimenDefinition describing a specimen to be collected, or an ObservationDefinition that specifies what observation should be captured.")
        protected DataType definition;
        @Child(name="transform", type={CanonicalType.class}, order=25, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Transform to apply the template", formalDefinition="A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.")
        protected CanonicalType transform;
        @Child(name="dynamicValue", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dynamic aspects of the definition", formalDefinition="Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.")
        protected List<RequestOrchestrationActionDynamicValueComponent> dynamicValue;
        @Child(name="action", type={RequestOrchestrationActionComponent.class}, order=27, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Sub action", formalDefinition="Sub actions.")
        protected List<RequestOrchestrationActionComponent> action;
        private static final long serialVersionUID = -1292193514L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public RequestOrchestrationActionComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public RequestOrchestrationActionComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getPrefixElement() {
            if (this.prefix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.prefix");
                }
                if (Configuration.doAutoCreate()) {
                    this.prefix = new StringType();
                }
            }
            return this.prefix;
        }

        public boolean hasPrefixElement() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public boolean hasPrefix() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public RequestOrchestrationActionComponent setPrefixElement(StringType value) {
            this.prefix = value;
            return this;
        }

        public String getPrefix() {
            return this.prefix == null ? null : (String)this.prefix.getValue();
        }

        public RequestOrchestrationActionComponent setPrefix(String value) {
            if (Utilities.noString((String)value)) {
                this.prefix = null;
            } else {
                if (this.prefix == null) {
                    this.prefix = new StringType();
                }
                this.prefix.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public RequestOrchestrationActionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public RequestOrchestrationActionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public RequestOrchestrationActionComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public RequestOrchestrationActionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public MarkdownType getTextEquivalentElement() {
            if (this.textEquivalent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.textEquivalent");
                }
                if (Configuration.doAutoCreate()) {
                    this.textEquivalent = new MarkdownType();
                }
            }
            return this.textEquivalent;
        }

        public boolean hasTextEquivalentElement() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public boolean hasTextEquivalent() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public RequestOrchestrationActionComponent setTextEquivalentElement(MarkdownType value) {
            this.textEquivalent = value;
            return this;
        }

        public String getTextEquivalent() {
            return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
        }

        public RequestOrchestrationActionComponent setTextEquivalent(String value) {
            if (Utilities.noString((String)value)) {
                this.textEquivalent = null;
            } else {
                if (this.textEquivalent == null) {
                    this.textEquivalent = new MarkdownType();
                }
                this.textEquivalent.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
                }
            }
            return this.priority;
        }

        public boolean hasPriorityElement() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public RequestOrchestrationActionComponent setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
            this.priority = value;
            return this;
        }

        public Enumerations.RequestPriority getPriority() {
            return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
        }

        public RequestOrchestrationActionComponent setPriority(Enumerations.RequestPriority value) {
            if (value == null) {
                this.priority = null;
            } else {
                if (this.priority == null) {
                    this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
                }
                this.priority.setValue((Object)value);
            }
            return this;
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public RequestOrchestrationActionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public RequestOrchestrationActionComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<Reference> getGoal() {
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            return this.goal;
        }

        public RequestOrchestrationActionComponent setGoal(List<Reference> theGoal) {
            this.goal = theGoal;
            return this;
        }

        public boolean hasGoal() {
            if (this.goal == null) {
                return false;
            }
            for (Reference item : this.goal) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addGoal() {
            Reference t = new Reference();
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addGoal(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return this;
        }

        public Reference getGoalFirstRep() {
            if (this.getGoal().isEmpty()) {
                this.addGoal();
            }
            return this.getGoal().get(0);
        }

        public List<RequestOrchestrationActionConditionComponent> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<RequestOrchestrationActionConditionComponent>();
            }
            return this.condition;
        }

        public RequestOrchestrationActionComponent setCondition(List<RequestOrchestrationActionConditionComponent> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (RequestOrchestrationActionConditionComponent item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionConditionComponent addCondition() {
            RequestOrchestrationActionConditionComponent t = new RequestOrchestrationActionConditionComponent();
            if (this.condition == null) {
                this.condition = new ArrayList<RequestOrchestrationActionConditionComponent>();
            }
            this.condition.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addCondition(RequestOrchestrationActionConditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<RequestOrchestrationActionConditionComponent>();
            }
            this.condition.add(t);
            return this;
        }

        public RequestOrchestrationActionConditionComponent getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public List<RequestOrchestrationActionInputComponent> getInput() {
            if (this.input == null) {
                this.input = new ArrayList<RequestOrchestrationActionInputComponent>();
            }
            return this.input;
        }

        public RequestOrchestrationActionComponent setInput(List<RequestOrchestrationActionInputComponent> theInput) {
            this.input = theInput;
            return this;
        }

        public boolean hasInput() {
            if (this.input == null) {
                return false;
            }
            for (RequestOrchestrationActionInputComponent item : this.input) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionInputComponent addInput() {
            RequestOrchestrationActionInputComponent t = new RequestOrchestrationActionInputComponent();
            if (this.input == null) {
                this.input = new ArrayList<RequestOrchestrationActionInputComponent>();
            }
            this.input.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addInput(RequestOrchestrationActionInputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.input == null) {
                this.input = new ArrayList<RequestOrchestrationActionInputComponent>();
            }
            this.input.add(t);
            return this;
        }

        public RequestOrchestrationActionInputComponent getInputFirstRep() {
            if (this.getInput().isEmpty()) {
                this.addInput();
            }
            return this.getInput().get(0);
        }

        public List<RequestOrchestrationActionOutputComponent> getOutput() {
            if (this.output == null) {
                this.output = new ArrayList<RequestOrchestrationActionOutputComponent>();
            }
            return this.output;
        }

        public RequestOrchestrationActionComponent setOutput(List<RequestOrchestrationActionOutputComponent> theOutput) {
            this.output = theOutput;
            return this;
        }

        public boolean hasOutput() {
            if (this.output == null) {
                return false;
            }
            for (RequestOrchestrationActionOutputComponent item : this.output) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionOutputComponent addOutput() {
            RequestOrchestrationActionOutputComponent t = new RequestOrchestrationActionOutputComponent();
            if (this.output == null) {
                this.output = new ArrayList<RequestOrchestrationActionOutputComponent>();
            }
            this.output.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addOutput(RequestOrchestrationActionOutputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.output == null) {
                this.output = new ArrayList<RequestOrchestrationActionOutputComponent>();
            }
            this.output.add(t);
            return this;
        }

        public RequestOrchestrationActionOutputComponent getOutputFirstRep() {
            if (this.getOutput().isEmpty()) {
                this.addOutput();
            }
            return this.getOutput().get(0);
        }

        public List<RequestOrchestrationActionRelatedActionComponent> getRelatedAction() {
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestOrchestrationActionRelatedActionComponent>();
            }
            return this.relatedAction;
        }

        public RequestOrchestrationActionComponent setRelatedAction(List<RequestOrchestrationActionRelatedActionComponent> theRelatedAction) {
            this.relatedAction = theRelatedAction;
            return this;
        }

        public boolean hasRelatedAction() {
            if (this.relatedAction == null) {
                return false;
            }
            for (RequestOrchestrationActionRelatedActionComponent item : this.relatedAction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionRelatedActionComponent addRelatedAction() {
            RequestOrchestrationActionRelatedActionComponent t = new RequestOrchestrationActionRelatedActionComponent();
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestOrchestrationActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addRelatedAction(RequestOrchestrationActionRelatedActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestOrchestrationActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return this;
        }

        public RequestOrchestrationActionRelatedActionComponent getRelatedActionFirstRep() {
            if (this.getRelatedAction().isEmpty()) {
                this.addRelatedAction();
            }
            return this.getRelatedAction().get(0);
        }

        public DataType getTiming() {
            return this.timing;
        }

        public DateTimeType getTimingDateTimeType() throws FHIRException {
            if (this.timing == null) {
                this.timing = new DateTimeType();
            }
            if (!(this.timing instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.timing;
        }

        public boolean hasTimingDateTimeType() {
            return this != null && this.timing instanceof DateTimeType;
        }

        public Age getTimingAge() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Age();
            }
            if (!(this.timing instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Age)this.timing;
        }

        public boolean hasTimingAge() {
            return this != null && this.timing instanceof Age;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Period();
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this != null && this.timing instanceof Period;
        }

        public Duration getTimingDuration() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Duration();
            }
            if (!(this.timing instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Duration)this.timing;
        }

        public boolean hasTimingDuration() {
            return this != null && this.timing instanceof Duration;
        }

        public Range getTimingRange() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Range();
            }
            if (!(this.timing instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Range)this.timing;
        }

        public boolean hasTimingRange() {
            return this != null && this.timing instanceof Range;
        }

        public Timing getTimingTiming() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Timing();
            }
            if (!(this.timing instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Timing)this.timing;
        }

        public boolean hasTimingTiming() {
            return this != null && this.timing instanceof Timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public RequestOrchestrationActionComponent setTiming(DataType value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Duration || value instanceof Range || value instanceof Timing)) {
                throw new FHIRException("Not the right type for RequestOrchestration.action.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public CodeableReference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new CodeableReference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public RequestOrchestrationActionComponent setLocation(CodeableReference value) {
            this.location = value;
            return this;
        }

        public List<RequestOrchestrationActionParticipantComponent> getParticipant() {
            if (this.participant == null) {
                this.participant = new ArrayList<RequestOrchestrationActionParticipantComponent>();
            }
            return this.participant;
        }

        public RequestOrchestrationActionComponent setParticipant(List<RequestOrchestrationActionParticipantComponent> theParticipant) {
            this.participant = theParticipant;
            return this;
        }

        public boolean hasParticipant() {
            if (this.participant == null) {
                return false;
            }
            for (RequestOrchestrationActionParticipantComponent item : this.participant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionParticipantComponent addParticipant() {
            RequestOrchestrationActionParticipantComponent t = new RequestOrchestrationActionParticipantComponent();
            if (this.participant == null) {
                this.participant = new ArrayList<RequestOrchestrationActionParticipantComponent>();
            }
            this.participant.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addParticipant(RequestOrchestrationActionParticipantComponent t) {
            if (t == null) {
                return this;
            }
            if (this.participant == null) {
                this.participant = new ArrayList<RequestOrchestrationActionParticipantComponent>();
            }
            this.participant.add(t);
            return this;
        }

        public RequestOrchestrationActionParticipantComponent getParticipantFirstRep() {
            if (this.getParticipant().isEmpty()) {
                this.addParticipant();
            }
            return this.getParticipant().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RequestOrchestrationActionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Enumeration<Enumerations.ActionGroupingBehavior> getGroupingBehaviorElement() {
            if (this.groupingBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.groupingBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupingBehavior = new Enumeration<Enumerations.ActionGroupingBehavior>(new Enumerations.ActionGroupingBehaviorEnumFactory());
                }
            }
            return this.groupingBehavior;
        }

        public boolean hasGroupingBehaviorElement() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public boolean hasGroupingBehavior() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public RequestOrchestrationActionComponent setGroupingBehaviorElement(Enumeration<Enumerations.ActionGroupingBehavior> value) {
            this.groupingBehavior = value;
            return this;
        }

        public Enumerations.ActionGroupingBehavior getGroupingBehavior() {
            return this.groupingBehavior == null ? null : (Enumerations.ActionGroupingBehavior)((Object)this.groupingBehavior.getValue());
        }

        public RequestOrchestrationActionComponent setGroupingBehavior(Enumerations.ActionGroupingBehavior value) {
            if (value == null) {
                this.groupingBehavior = null;
            } else {
                if (this.groupingBehavior == null) {
                    this.groupingBehavior = new Enumeration<Enumerations.ActionGroupingBehavior>(new Enumerations.ActionGroupingBehaviorEnumFactory());
                }
                this.groupingBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionSelectionBehavior> getSelectionBehaviorElement() {
            if (this.selectionBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.selectionBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.selectionBehavior = new Enumeration<Enumerations.ActionSelectionBehavior>(new Enumerations.ActionSelectionBehaviorEnumFactory());
                }
            }
            return this.selectionBehavior;
        }

        public boolean hasSelectionBehaviorElement() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public boolean hasSelectionBehavior() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public RequestOrchestrationActionComponent setSelectionBehaviorElement(Enumeration<Enumerations.ActionSelectionBehavior> value) {
            this.selectionBehavior = value;
            return this;
        }

        public Enumerations.ActionSelectionBehavior getSelectionBehavior() {
            return this.selectionBehavior == null ? null : (Enumerations.ActionSelectionBehavior)((Object)this.selectionBehavior.getValue());
        }

        public RequestOrchestrationActionComponent setSelectionBehavior(Enumerations.ActionSelectionBehavior value) {
            if (value == null) {
                this.selectionBehavior = null;
            } else {
                if (this.selectionBehavior == null) {
                    this.selectionBehavior = new Enumeration<Enumerations.ActionSelectionBehavior>(new Enumerations.ActionSelectionBehaviorEnumFactory());
                }
                this.selectionBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionRequiredBehavior> getRequiredBehaviorElement() {
            if (this.requiredBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.requiredBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.requiredBehavior = new Enumeration<Enumerations.ActionRequiredBehavior>(new Enumerations.ActionRequiredBehaviorEnumFactory());
                }
            }
            return this.requiredBehavior;
        }

        public boolean hasRequiredBehaviorElement() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public boolean hasRequiredBehavior() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public RequestOrchestrationActionComponent setRequiredBehaviorElement(Enumeration<Enumerations.ActionRequiredBehavior> value) {
            this.requiredBehavior = value;
            return this;
        }

        public Enumerations.ActionRequiredBehavior getRequiredBehavior() {
            return this.requiredBehavior == null ? null : (Enumerations.ActionRequiredBehavior)((Object)this.requiredBehavior.getValue());
        }

        public RequestOrchestrationActionComponent setRequiredBehavior(Enumerations.ActionRequiredBehavior value) {
            if (value == null) {
                this.requiredBehavior = null;
            } else {
                if (this.requiredBehavior == null) {
                    this.requiredBehavior = new Enumeration<Enumerations.ActionRequiredBehavior>(new Enumerations.ActionRequiredBehaviorEnumFactory());
                }
                this.requiredBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionPrecheckBehavior> getPrecheckBehaviorElement() {
            if (this.precheckBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.precheckBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.precheckBehavior = new Enumeration<Enumerations.ActionPrecheckBehavior>(new Enumerations.ActionPrecheckBehaviorEnumFactory());
                }
            }
            return this.precheckBehavior;
        }

        public boolean hasPrecheckBehaviorElement() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public boolean hasPrecheckBehavior() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public RequestOrchestrationActionComponent setPrecheckBehaviorElement(Enumeration<Enumerations.ActionPrecheckBehavior> value) {
            this.precheckBehavior = value;
            return this;
        }

        public Enumerations.ActionPrecheckBehavior getPrecheckBehavior() {
            return this.precheckBehavior == null ? null : (Enumerations.ActionPrecheckBehavior)((Object)this.precheckBehavior.getValue());
        }

        public RequestOrchestrationActionComponent setPrecheckBehavior(Enumerations.ActionPrecheckBehavior value) {
            if (value == null) {
                this.precheckBehavior = null;
            } else {
                if (this.precheckBehavior == null) {
                    this.precheckBehavior = new Enumeration<Enumerations.ActionPrecheckBehavior>(new Enumerations.ActionPrecheckBehaviorEnumFactory());
                }
                this.precheckBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionCardinalityBehavior> getCardinalityBehaviorElement() {
            if (this.cardinalityBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.cardinalityBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.cardinalityBehavior = new Enumeration<Enumerations.ActionCardinalityBehavior>(new Enumerations.ActionCardinalityBehaviorEnumFactory());
                }
            }
            return this.cardinalityBehavior;
        }

        public boolean hasCardinalityBehaviorElement() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public boolean hasCardinalityBehavior() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public RequestOrchestrationActionComponent setCardinalityBehaviorElement(Enumeration<Enumerations.ActionCardinalityBehavior> value) {
            this.cardinalityBehavior = value;
            return this;
        }

        public Enumerations.ActionCardinalityBehavior getCardinalityBehavior() {
            return this.cardinalityBehavior == null ? null : (Enumerations.ActionCardinalityBehavior)((Object)this.cardinalityBehavior.getValue());
        }

        public RequestOrchestrationActionComponent setCardinalityBehavior(Enumerations.ActionCardinalityBehavior value) {
            if (value == null) {
                this.cardinalityBehavior = null;
            } else {
                if (this.cardinalityBehavior == null) {
                    this.cardinalityBehavior = new Enumeration<Enumerations.ActionCardinalityBehavior>(new Enumerations.ActionCardinalityBehaviorEnumFactory());
                }
                this.cardinalityBehavior.setValue((Object)value);
            }
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public RequestOrchestrationActionComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public DataType getDefinition() {
            return this.definition;
        }

        public CanonicalType getDefinitionCanonicalType() throws FHIRException {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            if (!(this.definition instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.definition;
        }

        public boolean hasDefinitionCanonicalType() {
            return this != null && this.definition instanceof CanonicalType;
        }

        public UriType getDefinitionUriType() throws FHIRException {
            if (this.definition == null) {
                this.definition = new UriType();
            }
            if (!(this.definition instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (UriType)this.definition;
        }

        public boolean hasDefinitionUriType() {
            return this != null && this.definition instanceof UriType;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public RequestOrchestrationActionComponent setDefinition(DataType value) {
            if (value != null && !(value instanceof CanonicalType) && !(value instanceof UriType)) {
                throw new FHIRException("Not the right type for RequestOrchestration.action.definition[x]: " + value.fhirType());
            }
            this.definition = value;
            return this;
        }

        public CanonicalType getTransformElement() {
            if (this.transform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestOrchestrationActionComponent.transform");
                }
                if (Configuration.doAutoCreate()) {
                    this.transform = new CanonicalType();
                }
            }
            return this.transform;
        }

        public boolean hasTransformElement() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public boolean hasTransform() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public RequestOrchestrationActionComponent setTransformElement(CanonicalType value) {
            this.transform = value;
            return this;
        }

        public String getTransform() {
            return this.transform == null ? null : (String)this.transform.getValue();
        }

        public RequestOrchestrationActionComponent setTransform(String value) {
            if (Utilities.noString((String)value)) {
                this.transform = null;
            } else {
                if (this.transform == null) {
                    this.transform = new CanonicalType();
                }
                this.transform.setValue(value);
            }
            return this;
        }

        public List<RequestOrchestrationActionDynamicValueComponent> getDynamicValue() {
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<RequestOrchestrationActionDynamicValueComponent>();
            }
            return this.dynamicValue;
        }

        public RequestOrchestrationActionComponent setDynamicValue(List<RequestOrchestrationActionDynamicValueComponent> theDynamicValue) {
            this.dynamicValue = theDynamicValue;
            return this;
        }

        public boolean hasDynamicValue() {
            if (this.dynamicValue == null) {
                return false;
            }
            for (RequestOrchestrationActionDynamicValueComponent item : this.dynamicValue) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionDynamicValueComponent addDynamicValue() {
            RequestOrchestrationActionDynamicValueComponent t = new RequestOrchestrationActionDynamicValueComponent();
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<RequestOrchestrationActionDynamicValueComponent>();
            }
            this.dynamicValue.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addDynamicValue(RequestOrchestrationActionDynamicValueComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<RequestOrchestrationActionDynamicValueComponent>();
            }
            this.dynamicValue.add(t);
            return this;
        }

        public RequestOrchestrationActionDynamicValueComponent getDynamicValueFirstRep() {
            if (this.getDynamicValue().isEmpty()) {
                this.addDynamicValue();
            }
            return this.getDynamicValue().get(0);
        }

        public List<RequestOrchestrationActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<RequestOrchestrationActionComponent>();
            }
            return this.action;
        }

        public RequestOrchestrationActionComponent setAction(List<RequestOrchestrationActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (RequestOrchestrationActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestOrchestrationActionComponent addAction() {
            RequestOrchestrationActionComponent t = new RequestOrchestrationActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<RequestOrchestrationActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public RequestOrchestrationActionComponent addAction(RequestOrchestrationActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<RequestOrchestrationActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public RequestOrchestrationActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("linkId", "string", "The linkId of the action from the PlanDefinition that corresponds to this action in the RequestOrchestration resource.", 0, 1, this.linkId));
            children.add(new Property("prefix", "string", "A user-visible prefix for the action. For example a section or item numbering such as 1. or A.", 0, 1, this.prefix));
            children.add(new Property("title", "string", "The title of the action displayed to a user.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description));
            children.add(new Property("textEquivalent", "markdown", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent));
            children.add(new Property(RequestOrchestration.SP_PRIORITY, RequestOrchestration.SP_CODE, "Indicates how quickly the action should be addressed with respect to other actions.", 0, 1, this.priority));
            children.add(new Property(RequestOrchestration.SP_CODE, "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this action.", 0, Integer.MAX_VALUE, this.goal));
            children.add(new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("input", "", "Defines input data requirements for the action.", 0, Integer.MAX_VALUE, this.input));
            children.add(new Property("output", "", "Defines the outputs of the action, if any.", 0, Integer.MAX_VALUE, this.output));
            children.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
            children.add(new Property("timing[x]", "dateTime|Age|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing));
            children.add(new Property("location", "CodeableReference(Location)", "Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
            children.add(new Property(RequestOrchestration.SP_PARTICIPANT, "", "The participant that should perform or be responsible for this action.", 0, Integer.MAX_VALUE, this.participant));
            children.add(new Property("type", "CodeableConcept", "The type of action to perform (create, update, remove).", 0, 1, this.type));
            children.add(new Property("groupingBehavior", RequestOrchestration.SP_CODE, "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior));
            children.add(new Property("selectionBehavior", RequestOrchestration.SP_CODE, "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior));
            children.add(new Property("requiredBehavior", RequestOrchestration.SP_CODE, "Defines expectations around whether an action is required.", 0, 1, this.requiredBehavior));
            children.add(new Property("precheckBehavior", RequestOrchestration.SP_CODE, "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior));
            children.add(new Property("cardinalityBehavior", RequestOrchestration.SP_CODE, "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior));
            children.add(new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, 1, this.resource));
            children.add(new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire|SpecimenDefinition)|uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, a SpecimenDefinition describing a specimen to be collected, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition));
            children.add(new Property("transform", "canonical(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform));
            children.add(new Property("dynamicValue", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue));
            children.add(new Property("action", "@RequestOrchestration.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1102667083: {
                    return new Property("linkId", "string", "The linkId of the action from the PlanDefinition that corresponds to this action in the RequestOrchestration resource.", 0, 1, this.linkId);
                }
                case -980110702: {
                    return new Property("prefix", "string", "A user-visible prefix for the action. For example a section or item numbering such as 1. or A.", 0, 1, this.prefix);
                }
                case 110371416: {
                    return new Property("title", "string", "The title of the action displayed to a user.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description);
                }
                case -900391049: {
                    return new Property("textEquivalent", "markdown", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent);
                }
                case -1165461084: {
                    return new Property(RequestOrchestration.SP_PRIORITY, RequestOrchestration.SP_CODE, "Indicates how quickly the action should be addressed with respect to other actions.", 0, 1, this.priority);
                }
                case 3059181: {
                    return new Property(RequestOrchestration.SP_CODE, "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case 3178259: {
                    return new Property("goal", "Reference(Goal)", "Goals that are intended to be achieved by following the requests in this action.", 0, Integer.MAX_VALUE, this.goal);
                }
                case -861311717: {
                    return new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition);
                }
                case 100358090: {
                    return new Property("input", "", "Defines input data requirements for the action.", 0, Integer.MAX_VALUE, this.input);
                }
                case -1005512447: {
                    return new Property("output", "", "Defines the outputs of the action, if any.", 0, Integer.MAX_VALUE, this.output);
                }
                case -384107967: {
                    return new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction);
                }
                case 164632566: {
                    return new Property("timing[x]", "dateTime|Age|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "dateTime|Age|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1837458939: {
                    return new Property("timing[x]", "dateTime", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 164607061: {
                    return new Property("timing[x]", "Age", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "Period", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1327253506: {
                    return new Property("timing[x]", "Duration", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -710871277: {
                    return new Property("timing[x]", "Range", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -497554124: {
                    return new Property("timing[x]", "Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 1901043637: {
                    return new Property("location", "CodeableReference(Location)", "Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
                }
                case 767422259: {
                    return new Property(RequestOrchestration.SP_PARTICIPANT, "", "The participant that should perform or be responsible for this action.", 0, Integer.MAX_VALUE, this.participant);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of action to perform (create, update, remove).", 0, 1, this.type);
                }
                case 586678389: {
                    return new Property("groupingBehavior", RequestOrchestration.SP_CODE, "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior);
                }
                case 168639486: {
                    return new Property("selectionBehavior", RequestOrchestration.SP_CODE, "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior);
                }
                case -1163906287: {
                    return new Property("requiredBehavior", RequestOrchestration.SP_CODE, "Defines expectations around whether an action is required.", 0, 1, this.requiredBehavior);
                }
                case -1174249033: {
                    return new Property("precheckBehavior", RequestOrchestration.SP_CODE, "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior);
                }
                case -922577408: {
                    return new Property("cardinalityBehavior", RequestOrchestration.SP_CODE, "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior);
                }
                case -341064690: {
                    return new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, 1, this.resource);
                }
                case -1139422643: {
                    return new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire|SpecimenDefinition)|uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, a SpecimenDefinition describing a specimen to be collected, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case -1014418093: {
                    return new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire|SpecimenDefinition)|uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, a SpecimenDefinition describing a specimen to be collected, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case 933485793: {
                    return new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire|SpecimenDefinition)", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, a SpecimenDefinition describing a specimen to be collected, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case -1139428583: {
                    return new Property("definition[x]", "uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, a SpecimenDefinition describing a specimen to be collected, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case 1052666732: {
                    return new Property("transform", "canonical(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform);
                }
                case 572625010: {
                    return new Property("dynamicValue", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue);
                }
                case -1422950858: {
                    return new Property("action", "@RequestOrchestration.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case -980110702: {
                    Base[] baseArray;
                    if (this.prefix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.prefix;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -900391049: {
                    Base[] baseArray;
                    if (this.textEquivalent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.textEquivalent;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.priority;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case 3178259: {
                    return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
                }
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case 100358090: {
                    return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
                }
                case -1005512447: {
                    return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
                }
                case -384107967: {
                    return this.relatedAction == null ? new Base[]{} : this.relatedAction.toArray(new Base[this.relatedAction.size()]);
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.timing;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.location;
                    }
                    return baseArray;
                }
                case 767422259: {
                    return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.type;
                    }
                    return baseArray;
                }
                case 586678389: {
                    Base[] baseArray;
                    if (this.groupingBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.groupingBehavior;
                    }
                    return baseArray;
                }
                case 168639486: {
                    Base[] baseArray;
                    if (this.selectionBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.selectionBehavior;
                    }
                    return baseArray;
                }
                case -1163906287: {
                    Base[] baseArray;
                    if (this.requiredBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.requiredBehavior;
                    }
                    return baseArray;
                }
                case -1174249033: {
                    Base[] baseArray;
                    if (this.precheckBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.precheckBehavior;
                    }
                    return baseArray;
                }
                case -922577408: {
                    Base[] baseArray;
                    if (this.cardinalityBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.cardinalityBehavior;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.resource;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray17 = new Base[1];
                        baseArray = baseArray17;
                        baseArray17[0] = this.definition;
                    }
                    return baseArray;
                }
                case 1052666732: {
                    Base[] baseArray;
                    if (this.transform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray18 = new Base[1];
                        baseArray = baseArray18;
                        baseArray18[0] = this.transform;
                    }
                    return baseArray;
                }
                case 572625010: {
                    return this.dynamicValue == null ? new Base[]{} : this.dynamicValue.toArray(new Base[this.dynamicValue.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = TypeConvertor.castToString(value);
                    return value;
                }
                case -980110702: {
                    this.prefix = TypeConvertor.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -900391049: {
                    this.textEquivalent = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1165461084: {
                    value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.priority = value;
                    return value;
                }
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
                case 3178259: {
                    this.getGoal().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -861311717: {
                    this.getCondition().add((RequestOrchestrationActionConditionComponent)((Object)value));
                    return value;
                }
                case 100358090: {
                    this.getInput().add((RequestOrchestrationActionInputComponent)((Object)value));
                    return value;
                }
                case -1005512447: {
                    this.getOutput().add((RequestOrchestrationActionOutputComponent)((Object)value));
                    return value;
                }
                case -384107967: {
                    this.getRelatedAction().add((RequestOrchestrationActionRelatedActionComponent)((Object)value));
                    return value;
                }
                case -873664438: {
                    this.timing = TypeConvertor.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 767422259: {
                    this.getParticipant().add((RequestOrchestrationActionParticipantComponent)((Object)value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 586678389: {
                    value = new Enumerations.ActionGroupingBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.groupingBehavior = value;
                    return value;
                }
                case 168639486: {
                    value = new Enumerations.ActionSelectionBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.selectionBehavior = value;
                    return value;
                }
                case -1163906287: {
                    value = new Enumerations.ActionRequiredBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.requiredBehavior = value;
                    return value;
                }
                case -1174249033: {
                    value = new Enumerations.ActionPrecheckBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.precheckBehavior = value;
                    return value;
                }
                case -922577408: {
                    value = new Enumerations.ActionCardinalityBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.cardinalityBehavior = value;
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToType(value);
                    return value;
                }
                case 1052666732: {
                    this.transform = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 572625010: {
                    this.getDynamicValue().add((RequestOrchestrationActionDynamicValueComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((RequestOrchestrationActionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = TypeConvertor.castToString(value);
            } else if (name.equals("prefix")) {
                this.prefix = TypeConvertor.castToString(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("textEquivalent")) {
                this.textEquivalent = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(RequestOrchestration.SP_PRIORITY)) {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
            } else if (name.equals(RequestOrchestration.SP_CODE)) {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
            } else if (name.equals("goal")) {
                this.getGoal().add(TypeConvertor.castToReference(value));
            } else if (name.equals("condition")) {
                this.getCondition().add((RequestOrchestrationActionConditionComponent)((Object)value));
            } else if (name.equals("input")) {
                this.getInput().add((RequestOrchestrationActionInputComponent)((Object)value));
            } else if (name.equals("output")) {
                this.getOutput().add((RequestOrchestrationActionOutputComponent)((Object)value));
            } else if (name.equals("relatedAction")) {
                this.getRelatedAction().add((RequestOrchestrationActionRelatedActionComponent)((Object)value));
            } else if (name.equals("timing[x]")) {
                this.timing = TypeConvertor.castToType(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals(RequestOrchestration.SP_PARTICIPANT)) {
                this.getParticipant().add((RequestOrchestrationActionParticipantComponent)((Object)value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("groupingBehavior")) {
                value = new Enumerations.ActionGroupingBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.groupingBehavior = value;
            } else if (name.equals("selectionBehavior")) {
                value = new Enumerations.ActionSelectionBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.selectionBehavior = value;
            } else if (name.equals("requiredBehavior")) {
                value = new Enumerations.ActionRequiredBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.requiredBehavior = value;
            } else if (name.equals("precheckBehavior")) {
                value = new Enumerations.ActionPrecheckBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.precheckBehavior = value;
            } else if (name.equals("cardinalityBehavior")) {
                value = new Enumerations.ActionCardinalityBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.cardinalityBehavior = value;
            } else if (name.equals("resource")) {
                this.resource = TypeConvertor.castToReference(value);
            } else if (name.equals("definition[x]")) {
                this.definition = TypeConvertor.castToType(value);
            } else if (name.equals("transform")) {
                this.transform = TypeConvertor.castToCanonical(value);
            } else if (name.equals("dynamicValue")) {
                this.getDynamicValue().add((RequestOrchestrationActionDynamicValueComponent)((Object)value));
            } else if (name.equals("action")) {
                this.getAction().add((RequestOrchestrationActionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return this.getLinkIdElement();
                }
                case -980110702: {
                    return this.getPrefixElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -900391049: {
                    return this.getTextEquivalentElement();
                }
                case -1165461084: {
                    return this.getPriorityElement();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case 3178259: {
                    return this.addGoal();
                }
                case -861311717: {
                    return this.addCondition();
                }
                case 100358090: {
                    return this.addInput();
                }
                case -1005512447: {
                    return this.addOutput();
                }
                case -384107967: {
                    return this.addRelatedAction();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 767422259: {
                    return this.addParticipant();
                }
                case 3575610: {
                    return this.getType();
                }
                case 586678389: {
                    return this.getGroupingBehaviorElement();
                }
                case 168639486: {
                    return this.getSelectionBehaviorElement();
                }
                case -1163906287: {
                    return this.getRequiredBehaviorElement();
                }
                case -1174249033: {
                    return this.getPrecheckBehaviorElement();
                }
                case -922577408: {
                    return this.getCardinalityBehaviorElement();
                }
                case -341064690: {
                    return this.getResource();
                }
                case -1139422643: {
                    return this.getDefinition();
                }
                case -1014418093: {
                    return this.getDefinition();
                }
                case 1052666732: {
                    return this.getTransformElement();
                }
                case 572625010: {
                    return this.addDynamicValue();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -980110702: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -900391049: {
                    return new String[]{"markdown"};
                }
                case -1165461084: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case 3178259: {
                    return new String[]{"Reference"};
                }
                case -861311717: {
                    return new String[0];
                }
                case 100358090: {
                    return new String[0];
                }
                case -1005512447: {
                    return new String[0];
                }
                case -384107967: {
                    return new String[0];
                }
                case -873664438: {
                    return new String[]{"dateTime", "Age", "Period", "Duration", "Range", "Timing"};
                }
                case 1901043637: {
                    return new String[]{"CodeableReference"};
                }
                case 767422259: {
                    return new String[0];
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 586678389: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case 168639486: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -1163906287: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -1174249033: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -922577408: {
                    return new String[]{RequestOrchestration.SP_CODE};
                }
                case -341064690: {
                    return new String[]{"Reference"};
                }
                case -1014418093: {
                    return new String[]{"canonical", "uri"};
                }
                case 1052666732: {
                    return new String[]{"canonical"};
                }
                case 572625010: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"@RequestOrchestration.action"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.linkId");
            }
            if (name.equals("prefix")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.prefix");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.description");
            }
            if (name.equals("textEquivalent")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.textEquivalent");
            }
            if (name.equals(RequestOrchestration.SP_PRIORITY)) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.priority");
            }
            if (name.equals(RequestOrchestration.SP_CODE)) {
                return this.addCode();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("goal")) {
                return this.addGoal();
            }
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("output")) {
                return this.addOutput();
            }
            if (name.equals("relatedAction")) {
                return this.addRelatedAction();
            }
            if (name.equals("timingDateTime")) {
                this.timing = new DateTimeType();
                return this.timing;
            }
            if (name.equals("timingAge")) {
                this.timing = new Age();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("timingDuration")) {
                this.timing = new Duration();
                return this.timing;
            }
            if (name.equals("timingRange")) {
                this.timing = new Range();
                return this.timing;
            }
            if (name.equals("timingTiming")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("location")) {
                this.location = new CodeableReference();
                return this.location;
            }
            if (name.equals(RequestOrchestration.SP_PARTICIPANT)) {
                return this.addParticipant();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("groupingBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.groupingBehavior");
            }
            if (name.equals("selectionBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.selectionBehavior");
            }
            if (name.equals("requiredBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.requiredBehavior");
            }
            if (name.equals("precheckBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.precheckBehavior");
            }
            if (name.equals("cardinalityBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.cardinalityBehavior");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            if (name.equals("definitionCanonical")) {
                this.definition = new CanonicalType();
                return this.definition;
            }
            if (name.equals("definitionUri")) {
                this.definition = new UriType();
                return this.definition;
            }
            if (name.equals("transform")) {
                throw new FHIRException("Cannot call addChild on a singleton property RequestOrchestration.action.transform");
            }
            if (name.equals("dynamicValue")) {
                return this.addDynamicValue();
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public RequestOrchestrationActionComponent copy() {
            RequestOrchestrationActionComponent dst = new RequestOrchestrationActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RequestOrchestrationActionComponent dst) {
            super.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            dst.prefix = this.prefix == null ? null : this.prefix.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
            Enumeration<Enumerations.RequestPriority> enumeration = dst.priority = this.priority == null ? null : this.priority.copy();
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.goal != null) {
                dst.goal = new ArrayList<Reference>();
                for (Reference reference : this.goal) {
                    dst.goal.add(reference.copy());
                }
            }
            if (this.condition != null) {
                dst.condition = new ArrayList<RequestOrchestrationActionConditionComponent>();
                for (RequestOrchestrationActionConditionComponent requestOrchestrationActionConditionComponent : this.condition) {
                    dst.condition.add(requestOrchestrationActionConditionComponent.copy());
                }
            }
            if (this.input != null) {
                dst.input = new ArrayList<RequestOrchestrationActionInputComponent>();
                for (RequestOrchestrationActionInputComponent requestOrchestrationActionInputComponent : this.input) {
                    dst.input.add(requestOrchestrationActionInputComponent.copy());
                }
            }
            if (this.output != null) {
                dst.output = new ArrayList<RequestOrchestrationActionOutputComponent>();
                for (RequestOrchestrationActionOutputComponent requestOrchestrationActionOutputComponent : this.output) {
                    dst.output.add(requestOrchestrationActionOutputComponent.copy());
                }
            }
            if (this.relatedAction != null) {
                dst.relatedAction = new ArrayList<RequestOrchestrationActionRelatedActionComponent>();
                for (RequestOrchestrationActionRelatedActionComponent requestOrchestrationActionRelatedActionComponent : this.relatedAction) {
                    dst.relatedAction.add(requestOrchestrationActionRelatedActionComponent.copy());
                }
            }
            dst.timing = this.timing == null ? null : this.timing.copy();
            CodeableReference codeableReference = dst.location = this.location == null ? null : this.location.copy();
            if (this.participant != null) {
                dst.participant = new ArrayList<RequestOrchestrationActionParticipantComponent>();
                for (RequestOrchestrationActionParticipantComponent requestOrchestrationActionParticipantComponent : this.participant) {
                    dst.participant.add(requestOrchestrationActionParticipantComponent.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupingBehavior = this.groupingBehavior == null ? null : this.groupingBehavior.copy();
            dst.selectionBehavior = this.selectionBehavior == null ? null : this.selectionBehavior.copy();
            dst.requiredBehavior = this.requiredBehavior == null ? null : this.requiredBehavior.copy();
            dst.precheckBehavior = this.precheckBehavior == null ? null : this.precheckBehavior.copy();
            dst.cardinalityBehavior = this.cardinalityBehavior == null ? null : this.cardinalityBehavior.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            CanonicalType canonicalType = dst.transform = this.transform == null ? null : this.transform.copy();
            if (this.dynamicValue != null) {
                dst.dynamicValue = new ArrayList<RequestOrchestrationActionDynamicValueComponent>();
                for (RequestOrchestrationActionDynamicValueComponent requestOrchestrationActionDynamicValueComponent : this.dynamicValue) {
                    dst.dynamicValue.add(requestOrchestrationActionDynamicValueComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<RequestOrchestrationActionComponent>();
                for (RequestOrchestrationActionComponent requestOrchestrationActionComponent : this.action) {
                    dst.action.add(requestOrchestrationActionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionComponent)) {
                return false;
            }
            RequestOrchestrationActionComponent o = (RequestOrchestrationActionComponent)other_;
            return RequestOrchestrationActionComponent.compareDeep(this.linkId, o.linkId, true) && RequestOrchestrationActionComponent.compareDeep(this.prefix, o.prefix, true) && RequestOrchestrationActionComponent.compareDeep(this.title, o.title, true) && RequestOrchestrationActionComponent.compareDeep(this.description, o.description, true) && RequestOrchestrationActionComponent.compareDeep(this.textEquivalent, o.textEquivalent, true) && RequestOrchestrationActionComponent.compareDeep(this.priority, o.priority, true) && RequestOrchestrationActionComponent.compareDeep(this.code, o.code, true) && RequestOrchestrationActionComponent.compareDeep(this.documentation, o.documentation, true) && RequestOrchestrationActionComponent.compareDeep(this.goal, o.goal, true) && RequestOrchestrationActionComponent.compareDeep(this.condition, o.condition, true) && RequestOrchestrationActionComponent.compareDeep(this.input, o.input, true) && RequestOrchestrationActionComponent.compareDeep(this.output, o.output, true) && RequestOrchestrationActionComponent.compareDeep(this.relatedAction, o.relatedAction, true) && RequestOrchestrationActionComponent.compareDeep(this.timing, o.timing, true) && RequestOrchestrationActionComponent.compareDeep(this.location, o.location, true) && RequestOrchestrationActionComponent.compareDeep(this.participant, o.participant, true) && RequestOrchestrationActionComponent.compareDeep(this.type, o.type, true) && RequestOrchestrationActionComponent.compareDeep(this.groupingBehavior, o.groupingBehavior, true) && RequestOrchestrationActionComponent.compareDeep(this.selectionBehavior, o.selectionBehavior, true) && RequestOrchestrationActionComponent.compareDeep(this.requiredBehavior, o.requiredBehavior, true) && RequestOrchestrationActionComponent.compareDeep(this.precheckBehavior, o.precheckBehavior, true) && RequestOrchestrationActionComponent.compareDeep(this.cardinalityBehavior, o.cardinalityBehavior, true) && RequestOrchestrationActionComponent.compareDeep(this.resource, o.resource, true) && RequestOrchestrationActionComponent.compareDeep(this.definition, o.definition, true) && RequestOrchestrationActionComponent.compareDeep(this.transform, o.transform, true) && RequestOrchestrationActionComponent.compareDeep(this.dynamicValue, o.dynamicValue, true) && RequestOrchestrationActionComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestOrchestrationActionComponent)) {
                return false;
            }
            RequestOrchestrationActionComponent o = (RequestOrchestrationActionComponent)other_;
            return RequestOrchestrationActionComponent.compareValues(this.linkId, o.linkId, true) && RequestOrchestrationActionComponent.compareValues(this.prefix, o.prefix, true) && RequestOrchestrationActionComponent.compareValues(this.title, o.title, true) && RequestOrchestrationActionComponent.compareValues(this.description, o.description, true) && RequestOrchestrationActionComponent.compareValues(this.textEquivalent, o.textEquivalent, true) && RequestOrchestrationActionComponent.compareValues(this.priority, o.priority, true) && RequestOrchestrationActionComponent.compareValues(this.groupingBehavior, o.groupingBehavior, true) && RequestOrchestrationActionComponent.compareValues(this.selectionBehavior, o.selectionBehavior, true) && RequestOrchestrationActionComponent.compareValues(this.requiredBehavior, o.requiredBehavior, true) && RequestOrchestrationActionComponent.compareValues(this.precheckBehavior, o.precheckBehavior, true) && RequestOrchestrationActionComponent.compareValues(this.cardinalityBehavior, o.cardinalityBehavior, true) && RequestOrchestrationActionComponent.compareValues(this.transform, o.transform, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.linkId, this.prefix, this.title, this.description, this.textEquivalent, this.priority, this.code, this.documentation, this.goal, this.condition, this.input, this.output, this.relatedAction, this.timing, this.location, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.resource, this.definition, this.transform, this.dynamicValue, this.action});
        }

        @Override
        public String fhirType() {
            return "RequestOrchestration.action";
        }
    }
}

